/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.IRfAssociatedType;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfFieldTCLayer;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;

public class RfFieldTypeConstraint
extends RfField {
    private RfNamedElement fieldOrVariable;

    public RfFieldTypeConstraint(RfProject project, RfStruct parentStruct, FullName name) {
        super(project, parentStruct, name);
    }

    @Override
    public void deepClean() {
        try {
            this.fieldOrVariable = null;
            super.deepClean();
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    @Override
    public boolean checkEquals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.fieldOrVariable == null) {
            return false;
        }
        return this.fieldOrVariable.checkEquals(obj);
    }

    public List<Determinant> getDeterminants() {
        List<RfDefElement> layers = this.getLayers();
        if (layers == null || layers.isEmpty()) {
            return null;
        }
        ArrayList<Determinant> determinants = new ArrayList<Determinant>();
        for (RfDefElement layer : layers) {
            determinants.add(((RfFieldTCLayer)layer).getDeterminant());
        }
        return determinants;
    }

    public void setFieldOrVariable(RfNamedElement fieldOrVariable) {
        this.fieldOrVariable = fieldOrVariable;
    }

    public RfNamedElement getFieldOrVariable() {
        return this.fieldOrVariable;
    }

    @Override
    public Determinant getAssociatedTypeDeterminant() {
        Determinant assocDeterminant = super.getAssociatedTypeDeterminant();
        if (this.fieldOrVariable == null) {
            return assocDeterminant;
        }
        if (this.getAssociatedBaseType() != ((IRfAssociatedType)((Object)this.fieldOrVariable)).getAssociatedBaseType()) {
            return assocDeterminant;
        }
        Determinant assocOrigDeterminant = ((IRfAssociatedType)((Object)this.fieldOrVariable)).getAssociatedTypeDeterminant();
        assocDeterminant = Determinant.merge(assocDeterminant.toArray(), assocOrigDeterminant.toArray());
        return assocDeterminant;
    }

    @Override
    public String getAssociatedFullTypeName() {
        Determinant determinant = this.getAssociatedTypeDeterminant();
        if (determinant != null) {
            return determinant.toString();
        }
        return super.getAssociatedFullTypeName();
    }
}

