/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import ro.amiq.dvt.model.reflection.IRfKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.edt.base.model.reflection.RfArg;
import ro.amiq.edt.base.model.reflection.RfAssert;
import ro.amiq.edt.base.model.reflection.RfCheckThat;
import ro.amiq.edt.base.model.reflection.RfCoverLayer;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfExpect;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfFieldPropConstraint;
import ro.amiq.edt.base.model.reflection.RfFieldTypeConstraint;
import ro.amiq.edt.base.model.reflection.RfMacro;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfMethodType;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfSLNTokenField;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfSpecman;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfTemplateStructInstance;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.RfVar;

public enum RfKind implements IRfKind
{
    UNIT("unit"),
    STRUCT("struct"),
    SEQUENCE("sequence"),
    FIELD("field"),
    CONSTRAINT("constraint"),
    ENUM_ELEMENT("enum element"),
    PORT_SIMPLE_IN("in simple port"),
    PORT_SIMPLE_OUT("out simple port"),
    PORT_SIMPLE_INOUT("inout simple port"),
    PORT_EVENT_IN("in event port"),
    PORT_EVENT_OUT("out event port"),
    PORT_EVENT_INOUT("inout event port"),
    PORT_BUFFER_IN("in buffer port"),
    PORT_BUFFER_OUT("out buffer port"),
    PORT_METHOD_IN("in method port"),
    PORT_METHOD_OUT("out method port"),
    PORT_INTERFACE_IN("in interface port"),
    PORT_INTERFACE_OUT("out interface port"),
    UNIT_INSTANCE("unit instance"),
    EVENT("event"),
    METHOD("method"),
    ON_EVENT_METHOD("method"),
    TCM("time consuming method"),
    ARGUMENT("argument"),
    VARIABLE("variable"),
    COVER_ITEM("cover item"),
    COVER_CROSS("cover cross"),
    COVER_TRANSITION("cover transition"),
    PACKAGE("package"),
    SCALAR_TYPE("scalar type"),
    METHOD_TYPE("method type"),
    MODULE("module"),
    EXPECT("expect"),
    ASSUME("assume"),
    ASSERT("assert"),
    CHECK_THAT("check that"),
    MACRO("macro"),
    SDL_AGENT("agent"),
    SDL_SCENARIO("scenario"),
    SDL_ROLE("role"),
    SLN_ACTION("action"),
    SLN_COMPONENT("component"),
    SLN_COMPONENT_INSTANCE("sln_component_instance"),
    SLN_EXECUTABLE_INSTANCE("sln_executable_instance"),
    SLN_PLACE_INSTANCE("sln_place_instance"),
    SLN_THREAD_INSTANCE("sln_thread_instance"),
    SLN_TOKEN("token"),
    UNKNOWN("");

    private static final String ANY_METHOD_PORT = "any_method_port";
    private static final String ANY_BUFFER_PORT = "any_buffer_port";
    private static final String ANY_EVENT_PORT = "any_event_port";
    private static final String ANY_SIMPLE_PORT = "any_simple_port";
    private String fName;

    private RfKind(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    public static RfKind of(IRfNamedElement e) {
        if (RfStruct.isPackageElement(e, false)) {
            return PACKAGE;
        }
        if (e instanceof RfEnum) {
            return ENUM_ELEMENT;
        }
        if (e instanceof RfMacro) {
            return MACRO;
        }
        if (e instanceof RfScalarType) {
            return SCALAR_TYPE;
        }
        if (e instanceof RfStruct) {
            if (((RfStruct)e).isUnit()) {
                return UNIT;
            }
            if (((RfStruct)e).isSLNAction()) {
                return SLN_ACTION;
            }
            if (((RfStruct)e).isSLNComponent()) {
                return SLN_COMPONENT;
            }
            if (((RfStruct)e).isSLNToken()) {
                return SLN_TOKEN;
            }
            if (((RfStruct)e).isSDLAgent()) {
                return SDL_AGENT;
            }
            if (((RfStruct)e).isSDLScenario()) {
                return SDL_SCENARIO;
            }
            if (((RfStruct)e).isSDLRole()) {
                return SDL_ROLE;
            }
            if (((RfStruct)e).isLike("any_sequence")) {
                return SEQUENCE;
            }
            if (e instanceof RfMethodType) {
                return METHOD_TYPE;
            }
            return STRUCT;
        }
        if (e instanceof RfField) {
            String associatedTypeName = ((RfField)e).getAssociatedTypeName();
            int direction = ((RfField)e).getDirection();
            if (e instanceof RfFieldPropConstraint) {
                return CONSTRAINT;
            }
            if (e instanceof RfFieldTypeConstraint) {
                return CONSTRAINT;
            }
            if (e instanceof RfSLNTokenField) {
                if (direction == 1) {
                    return PORT_SIMPLE_IN;
                }
                if (direction == 2) {
                    return PORT_SIMPLE_OUT;
                }
            } else {
                if (ANY_SIMPLE_PORT.equals(associatedTypeName)) {
                    if (direction == 1) {
                        return PORT_SIMPLE_IN;
                    }
                    if (direction == 2) {
                        return PORT_SIMPLE_OUT;
                    }
                    return PORT_SIMPLE_INOUT;
                }
                if (ANY_EVENT_PORT.equals(associatedTypeName)) {
                    if (direction == 1) {
                        return PORT_EVENT_IN;
                    }
                    if (direction == 2) {
                        return PORT_EVENT_OUT;
                    }
                    return PORT_EVENT_INOUT;
                }
                if (ANY_BUFFER_PORT.equals(associatedTypeName)) {
                    if (direction == 1) {
                        return PORT_BUFFER_IN;
                    }
                    return PORT_BUFFER_OUT;
                }
                if (ANY_METHOD_PORT.equals(associatedTypeName)) {
                    if (direction == 1) {
                        return PORT_METHOD_IN;
                    }
                    return PORT_METHOD_OUT;
                }
                if (RfSpecman.isTLMPort(associatedTypeName)) {
                    if (direction == 1) {
                        return PORT_INTERFACE_IN;
                    }
                    return PORT_INTERFACE_OUT;
                }
                if (((RfField)e).isInstance()) {
                    RfType associatedBaseType = ((RfField)e).getAssociatedBaseType();
                    if (associatedBaseType instanceof RfStruct) {
                        RfStruct rfStruct = (RfStruct)associatedBaseType;
                        if (associatedBaseType instanceof RfTemplateStructInstance) {
                            rfStruct = ((RfTemplateStructInstance)associatedBaseType).getTemplateStruct();
                        }
                        if (rfStruct.isLike("sln_component")) {
                            return SLN_COMPONENT_INSTANCE;
                        }
                        if (rfStruct.isLike("sln_place")) {
                            return SLN_PLACE_INSTANCE;
                        }
                        if (rfStruct.isLike("sln_thread")) {
                            return SLN_THREAD_INSTANCE;
                        }
                        if (rfStruct.isLike("sln_executable")) {
                            return SLN_EXECUTABLE_INSTANCE;
                        }
                    }
                    return UNIT_INSTANCE;
                }
            }
            return FIELD;
        }
        if (e instanceof RfArg) {
            return ARGUMENT;
        }
        if (e instanceof RfVar) {
            if (e.getEnclosingScope() instanceof RfCoverLayer) {
                if (((RfVar)e).getKind() == 1) {
                    return COVER_CROSS;
                }
                if (((RfVar)e).getKind() == 2) {
                    return COVER_TRANSITION;
                }
                return COVER_ITEM;
            }
            return VARIABLE;
        }
        if (e instanceof RfEvent) {
            return EVENT;
        }
        if (e instanceof RfMethod) {
            RfMethod m = (RfMethod)e;
            if (m.isTCM()) {
                return TCM;
            }
            if (m.isByEvent()) {
                return ON_EVENT_METHOD;
            }
            return METHOD;
        }
        if (e instanceof RfModule) {
            return MODULE;
        }
        if (e instanceof RfExpect) {
            if (((RfExpect)e).isExpect()) {
                return EXPECT;
            }
            return ASSUME;
        }
        if (e instanceof RfCheckThat) {
            return CHECK_THAT;
        }
        if (e instanceof RfAssert) {
            return ASSERT;
        }
        return UNKNOWN;
    }
}

