/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.IRfAssociatedType;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfFieldLayer;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfPseudoListField;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfTemplateParam;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.WrapperType;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedArg;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedMethod;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedStruct;
import ro.amiq.edt.base.model.reflection.semantic.RfDummyField;
import ro.amiq.edt.base.model.reflection.util.NullProtectedList;

public class RfListType
extends RfPredefinedStruct
implements IRfAssociatedType,
IRfListType {
    public static final String LIST_OF_NAME_PREFIX = "list of ";
    public static final String LIST_OF_ITEM_OR_ITEM = "[item / list of items]";
    private transient RfType fAssocType;
    private transient String fKeyName;
    private transient int fListDepth;
    private static final String FIELD_PSEUDO_METHOD_COMMENT = "Returns a list containing the contents of the specified field-name for each item in the list. If the list is empty, it returns an empty list. This syntax is the same as list.apply(field).";

    public RfListType(RfProject project, RfType associatedType, String keyName, int listDepth) {
        this(project, associatedType, RfListType.computeName(associatedType), keyName, RfListType.computeDepth(associatedType, listDepth));
    }

    public RfListType(RfProject project, RfType assocType, String assocTypeName, String keyName, int listDepth) {
        super(project, assocTypeName, "main", false, null, null);
        try {
            String assocFullTypeName;
            this.fListDepth = RfListType.computeDepth(assocType, listDepth);
            this.setName(RfListType.prependListOfPrefix(assocTypeName, this.fListDepth));
            this.fKeyName = keyName;
            RfPredefinedMethod method = null;
            RfType rfType = this.fAssocType = assocType instanceof RfListType ? ((RfListType)assocType).fAssocType : assocType;
            if (this.fAssocType instanceof RfTemplateParam) {
                this.fAssocType = ((RfTemplateParam)this.fAssocType).getAssociatedBaseType();
            }
            RfType boolType = project.getSpecman().getSpecman("bool");
            RfType intType = project.getSpecman().getSpecman("int");
            RfType untypedType = project.getSpecman().getUntypedType();
            String assocFullTypeName2 = assocFullTypeName = this.getAssociatedFullTypeName();
            assocFullTypeName = RfListType.prependListOfPrefix(assocFullTypeName, this.fListDepth - 1);
            this.initPredefinedMethods(project, assocTypeName);
            RfMethod copyMethod = (RfMethod)this.getLocalMember(new FullName("copy", this.getDeterminant()), 1);
            copyMethod.setAssociatedType(this);
            Determinant assocDeterminant = this.getDeterminant();
            copyMethod.setAssociatedTypeDeterminant(assocDeterminant);
            LineInfo line = new LineInfo(-1, -1, -1);
            RfPredefinedArg argumentListType = new RfPredefinedArg(project, "[argument]", new WrapperType(assocFullTypeName2, assocFullTypeName2, line, null, null), method, this);
            argumentListType.setAssociatedType(this);
            String assocTypeName2 = this.getAssociatedTypeName();
            RfPredefinedArg argumentListTypeOrListItemType = new RfPredefinedArg(project, LIST_OF_ITEM_OR_ITEM, new WrapperType(assocTypeName2, assocTypeName2, line, null, null), method, this);
            argumentListTypeOrListItemType.setAssociatedType(this.fAssocType);
            argumentListTypeOrListItemType.setAssociatedTypeList(this.fListDepth - 1);
            argumentListTypeOrListItemType.setAssociatedTypeDeterminant(assocDeterminant);
            RfPredefinedArg argumentListItemType = new RfPredefinedArg(project, "[argument]", new WrapperType(assocTypeName2, assocTypeName2, line, null, null), method, this);
            argumentListItemType.setAssociatedType(this.fAssocType);
            argumentListItemType.setAssociatedTypeList(this.fListDepth - 1);
            argumentListItemType.setAssociatedTypeDeterminant(assocDeterminant);
            RfPredefinedArg argumentIntType = new RfPredefinedArg(project, "[argument]", new WrapperType("int", "int", line, null, null), method, this);
            argumentIntType.setAssociatedType(intType);
            RfPredefinedArg argumentUntypedType = new RfPredefinedArg(project, "[argument]", new WrapperType("int", "int", line, null, null), method, this);
            argumentUntypedType.setAssociatedType(untypedType);
            RfPredefinedArg argumentIntListType = new RfPredefinedArg(project, "[argument]", new WrapperType("list of int", "list of int", line, null, null), method, this);
            argumentIntListType.setAssociatedType(intType);
            argumentIntListType.setAssociatedTypeList(1);
            RfPredefinedArg argumentBoolType = new RfPredefinedArg(project, "[argument]", new WrapperType("bool", "bool", line, null, null), method, this);
            argumentBoolType.setAssociatedType(boolType);
            RfPredefinedArg argumentBoolTypeDefault = new RfPredefinedArg(project, "[argument]", new WrapperType("bool", "bool", line, null, null), method, this, "TRUE");
            argumentBoolTypeDefault.setAssociatedType(boolType);
            method = new RfPredefinedMethod(project, this, "add", null, "item / list of: " + assocFullTypeName, null, "[list pseudomethod] Add an item to the end of a list.");
            method.addArgument(argumentListTypeOrListItemType);
            this.addMethod(method);
            method = new RfPredefinedMethod(project, this, "add0", null, "item / list of: " + assocFullTypeName, null, "[list pseudomethod] Add an item to the head of a list.");
            method.addArgument(argumentListTypeOrListItemType);
            this.addMethod(method);
            method = new RfPredefinedMethod(project, this, "clear", null, null, null, "[list pseudomethod] Delete all items from a list.");
            this.addMethod(method);
            method = new RfPredefinedMethod(project, this, "delete", null, "index: int", null, "[list pseudomethod] Delete an item from a list.");
            method.addArgument(argumentIntType);
            this.addMethod(method);
            method = new RfPredefinedMethod(project, this, "fast_delete", null, "index: int", null, "[list pseudomethod] Delete an item without adjusting all indexes.Removes item number index from list (indexes start counting from 0). The index of the last item in the list is changed to the index of the item that was deleted, so all items following the deleted item keep their original indexes except that the original last index is removed.");
            method.addArgument(argumentIntType);
            this.addMethod(method);
            method = new RfPredefinedMethod(project, this, "insert", null, "index: int, item / list of: " + assocFullTypeName, null, "[list pseudomethod] Insert an item in a list at a specified index.");
            method.addArgument(argumentIntType);
            method.addArgument(argumentListTypeOrListItemType);
            this.addMethod(method);
            method = new RfPredefinedMethod(project, this, "set", null, "index: int, item / list of: " + assocFullTypeName, null, "[list pseudomethod] Set an item in a list at a specified index.");
            method.addArgument(argumentIntType);
            method.addArgument(argumentListTypeOrListItemType);
            this.addMethod(method);
            method = new RfPredefinedMethod(project, this, "pop", assocFullTypeName, null, null, "[list pseudomethod] Remove and return the last list item.");
            this.addMethod(method);
            method.setAssociatedType(this.fAssocType);
            method.setAssociatedTypeList(this.fListDepth - 1);
            method.setAssociatedTypeDeterminant(assocDeterminant);
            method = new RfPredefinedMethod(project, this, "pop0", assocFullTypeName, null, null, "[list pseudomethod] Remove and return the first list item.");
            this.addMethod(method);
            method.setAssociatedType(this.fAssocType);
            method.setAssociatedTypeList(this.fListDepth - 1);
            method.setAssociatedTypeDeterminant(assocDeterminant);
            method = new RfPredefinedMethod(project, this, "push", null, "item / list of: " + assocFullTypeName, null, "[list pseudomethod] Add an item to the end of a list (same as add(item)).");
            method.addArgument(argumentListTypeOrListItemType);
            this.addMethod(method);
            method = new RfPredefinedMethod(project, this, "push0", null, "item / list of: " + assocFullTypeName, null, "[list pseudomethod] Add an item to the head of a list (same as add0(item)).");
            method.addArgument(argumentListTypeOrListItemType);
            this.addMethod(method);
            method = new RfPredefinedMethod(project, this, "resize", null, "size: int [, full: bool, filler: exp, keep_old: bool]", null, "[list pseudomethod] Allocates a new list of declared size, or resizes an old list if keep_old is TRUE. If full is TRUE, sets all new items to have filler as their value. If only the first parameter, size, is used, this method allocates a new list of the given size and all items are initialized to the default value for the list type. If any of the three parameters after size are used, all three of them must be used. Default [TRUE, <default value>,FALSE].");
            method.addArgument(argumentIntType);
            RfPredefinedArg argumentBoolType2 = new RfPredefinedArg(project, "[argument]", new WrapperType("bool", "bool", line, null, null), method, this, "TRUE");
            argumentBoolType2.setAssociatedType(boolType);
            method.addArgument(argumentBoolType2);
            RfPredefinedArg argumentNoListType2 = new RfPredefinedArg(project, "[argument]", new WrapperType(assocTypeName2, assocTypeName2, line, null, null), method, this, "[DUMMY]");
            method.addArgument(argumentNoListType2);
            argumentNoListType2.setAssociatedType(this.fAssocType);
            argumentBoolType2 = new RfPredefinedArg(project, "[argument]", new WrapperType("bool", "bool", line, null, null), method, this, "FALSE");
            argumentBoolType2.setAssociatedType(boolType);
            method.addArgument(argumentBoolType2);
            this.addMethod(method);
            method = new RfPredefinedMethod(project, this, "all_different", "bool", "item: exp, exp: bool = TRUE", null, "[list pseudomethod] Returns TRUE if evaluation of the expression returns a unique value for each of the list elements.");
            method.addArgument(argumentUntypedType);
            method.addArgument(argumentBoolTypeDefault);
            this.addMethod(method);
            method.setAssociatedType(boolType);
            method = new RfPredefinedMethod(project, this, "swap", "list of bit", "small: int, large: int", null, "[list pseudomethod] Swap small bit chunks within larger chunks. This predefined list method accepts a list of bits, changes the order of the bits, and then returns the reordered list of bits. This method is often used in conjunction with pack() or unpack() to reorder the bits in a bit stream going to or coming from the DUT.");
            method.addArgument(argumentIntType);
            method.addArgument(argumentIntType);
            if ("bit".equals(assocFullTypeName)) {
                this.addMethod(method);
                method.setAssociatedTypeNoKey(this);
            }
            method = new RfPredefinedMethod(project, this, "apply", "list of exp", "item: exp", null, "[list pseudomethod] Perform a computation on each item in a list.");
            method.addArgument(argumentUntypedType);
            this.addMethod(method);
            method = new RfPredefinedMethod(project, this, "count", "int", "exp: bool", null, "[list pseudomethod] Return the number of items that satisfy a given condition.");
            method.addArgument(argumentBoolType);
            this.addMethod(method);
            method.setAssociatedType(intType);
            method = new RfPredefinedMethod(project, this, "exists", "bool", "index: int", null, "[list pseudomethod] Check if an index exists in a list.");
            method.addArgument(argumentIntType);
            this.addMethod(method);
            method.setAssociatedType(boolType);
            method = new RfPredefinedMethod(project, this, "first", assocFullTypeName, "exp: bool", null, "[list pseudomethod] Get the first item that satisfies a given condition.");
            method.addArgument(argumentBoolType);
            this.addMethod(method);
            method.setAssociatedType(this.fAssocType);
            method.setAssociatedTypeList(this.fListDepth - 1);
            method.setAssociatedTypeDeterminant(assocDeterminant);
            method = new RfPredefinedMethod(project, this, "first_index", "int", "exp: bool", null, "[list pseudomethod] Get the index of the first item that satisfies a given condition.");
            method.addArgument(argumentBoolType);
            this.addMethod(method);
            method.setAssociatedType(intType);
            method = new RfPredefinedMethod(project, this, "index", "int", "item: " + assocFullTypeName, null, "[list pseudomethod] Get the index of the item.");
            method.addArgument(argumentListItemType);
            this.addMethod(method);
            method.setNonStandard(true);
            method.setAssociatedType(intType);
            method = new RfPredefinedMethod(project, this, "flatten", LIST_OF_NAME_PREFIX + assocFullTypeName, null, null, "[list pseudomethod] Get a list of the base elements that make up the sub-lists in a multi-dimensional list.");
            this.addMethod(method);
            method.setAssociatedTypeNoKey(this);
            method = new RfPredefinedMethod(project, this, "get_indices", LIST_OF_NAME_PREFIX + assocFullTypeName, "index-list: list of int", null, "[list pseudomethod] Copies the items in list that have the indexes specified in index-list and returns a new list containing those items. If the index-list is empty, an empty list is returned.");
            method.addArgument(argumentIntListType);
            this.addMethod(method);
            method.setAssociatedTypeNoKey(this);
            method = new RfPredefinedMethod(project, this, "has", "bool", "exp: bool", null, "[list pseudomethod] Check that a list has at least one item that satisfies a given condition.");
            method.addArgument(argumentBoolType);
            this.addMethod(method);
            method.setAssociatedType(boolType);
            method = new RfPredefinedMethod(project, this, "is_empty", "bool", null, null, "[list pseudomethod] Check if a list is empty.");
            this.addMethod(method);
            method.setAssociatedType(boolType);
            method = new RfPredefinedMethod(project, this, "is_a_permutation", "bool", "of_list: list of " + assocFullTypeName, null, "[list pseudomethod] Check that two lists contain exactly the same items.");
            this.addMethod(method);
            method.addArgument(argumentListType);
            method.setAssociatedType(boolType);
            method = new RfPredefinedMethod(project, this, "last", assocFullTypeName, "exp: bool", null, "[list pseudomethod] Get the last item that satisfies a given condition.");
            method.addArgument(argumentBoolType);
            this.addMethod(method);
            method.setAssociatedType(this.fAssocType);
            method.setAssociatedTypeList(this.fListDepth - 1);
            method.setAssociatedTypeDeterminant(assocDeterminant);
            method = new RfPredefinedMethod(project, this, "last_index", "int", "exp: bool", null, "[list pseudomethod] Get the index of the last item that satisfies a given condition.");
            method.addArgument(argumentBoolType);
            this.addMethod(method);
            method.setAssociatedType(intType);
            method = new RfPredefinedMethod(project, this, "max", assocFullTypeName, "exp: int", null, "[list pseudomethod] Get the item with the maximum value of a given expression.");
            method.addArgument(argumentIntType);
            this.addMethod(method);
            method.setAssociatedType(this.fAssocType);
            method.setAssociatedTypeList(this.fListDepth - 1);
            method.setAssociatedTypeDeterminant(assocDeterminant);
            method = new RfPredefinedMethod(project, this, "max_index", "int", "exp: int", null, "[list pseudomethod] Get the index of the item with the maximum value of a given expression.");
            method.addArgument(argumentIntType);
            this.addMethod(method);
            method.setAssociatedType(intType);
            method = new RfPredefinedMethod(project, this, "max_value", "int / uint", "exp: int", null, "[list pseudomethod] Return the maximum value found by evaluating a given expression for all items.");
            method.addArgument(argumentIntType);
            this.addMethod(method);
            method.setAssociatedType(intType);
            method = new RfPredefinedMethod(project, this, "min", assocFullTypeName, "exp: int", null, "[list pseudomethod] Get the item with the minimum value of a given expression.");
            method.addArgument(argumentIntType);
            this.addMethod(method);
            method.setAssociatedType(this.fAssocType);
            method.setAssociatedTypeList(this.fListDepth - 1);
            method.setAssociatedTypeDeterminant(assocDeterminant);
            method = new RfPredefinedMethod(project, this, "min_index", "int", "exp: int", null, "[list pseudomethod] Get the index of the item with the minimum value of a given expression.");
            method.addArgument(argumentIntType);
            this.addMethod(method);
            method.setAssociatedType(intType);
            method = new RfPredefinedMethod(project, this, "min_value", "int / uint", "exp: int", null, "[list pseudomethod] Return the minimum value found by evaluating a given expression for all items.");
            method.addArgument(argumentIntType);
            this.addMethod(method);
            method.setAssociatedType(intType);
            method = new RfPredefinedMethod(project, this, "reverse", LIST_OF_NAME_PREFIX + assocFullTypeName, null, null, "[list pseudomethod] Reverse the order of a list.");
            this.addMethod(method);
            method.setAssociatedTypeNoKey(this);
            method = new RfPredefinedMethod(project, this, "size", "int", null, null, "[list pseudomethod] Return the size of a list.");
            this.addMethod(method);
            method.setAssociatedType(intType);
            method = new RfPredefinedMethod(project, this, "sort", LIST_OF_NAME_PREFIX + assocFullTypeName, "sort-exp: exp", null, "[list pseudomethod] Returns a new list of all the items in list, sorted in increasing order of the values of the sort-exp. If the sort-exp is a scalar value, the list is sorted by value. If the sort-exp is a nonscalar, the list is sorted by address. .");
            method.addArgument(argumentUntypedType);
            this.addMethod(method);
            method.setAssociatedTypeNoKey(this);
            method = new RfPredefinedMethod(project, this, "sort_by_field", LIST_OF_NAME_PREFIX + assocFullTypeName, "field: field-name", null, "[list pseudomethod] Returns a new list of all the items in struct-list, sorted in increasing order of their field values.");
            this.addMethod(method);
            method.addArgument(argumentUntypedType);
            method.setAssociatedTypeNoKey(this);
            method = new RfPredefinedMethod(project, this, "split", "list of struct_list_holder", "split-exp: exp", null, "[list pseudomethod] Splits a list at each point where an expression is true.");
            method.addArgument(argumentUntypedType);
            this.addMethod(method);
            RfType structListHolderType = project.getType("main", false, 1, "struct_list_holder", -1);
            method.setAssociatedType(structListHolderType);
            method.setAssociatedTypeList(1);
            method = new RfPredefinedMethod(project, this, "top", assocFullTypeName, null, null, "[list pseudomethod] Return the last item in a list.");
            this.addMethod(method);
            method.setAssociatedType(this.fAssocType);
            method.setAssociatedTypeList(this.fListDepth - 1);
            method.setAssociatedTypeDeterminant(assocDeterminant);
            method = new RfPredefinedMethod(project, this, "top0", assocFullTypeName, null, null, "[list pseudomethod] Return the first item in a list.");
            this.addMethod(method);
            method.setAssociatedType(this.fAssocType);
            method.setAssociatedTypeList(this.fListDepth - 1);
            method.setAssociatedTypeDeterminant(assocDeterminant);
            method = new RfPredefinedMethod(project, this, "get", assocFullTypeName, "index : int", null, "[list pseudomethod] Return the item at the specified index in list.");
            this.addMethod(method);
            method.setAssociatedType(this.fAssocType);
            method.setAssociatedTypeList(this.fListDepth - 1);
            method.addArgument(argumentIntType);
            method.setAssociatedTypeDeterminant(assocDeterminant);
            method = new RfPredefinedMethod(project, this, "all_unique", LIST_OF_NAME_PREFIX + assocFullTypeName, "select-exp: exp", null, "[list pseudomethod] Returns a new list of all the distinct values in list. In the new list, all occurrences of items for which the value of exp are the same are collapsed into one item.");
            method.addArgument(argumentUntypedType);
            this.addMethod(method);
            method.setAssociatedTypeNoKey(this);
            method = new RfPredefinedMethod(project, this, "unique", LIST_OF_NAME_PREFIX + assocFullTypeName, "select-exp: exp", null, "[list pseudomethod] Returns a new list of all the distinct values in list. In the new list, all consecutive occurrences of items for which the value of exp are the same are collapsed into one item.");
            method.addArgument(argumentUntypedType);
            this.addMethod(method);
            method.setAssociatedTypeNoKey(this);
            method = new RfPredefinedMethod(project, this, "uniq", LIST_OF_NAME_PREFIX + assocFullTypeName, "select-exp: exp", null, "@non_standard");
            method.addArgument(argumentUntypedType);
            this.addMethod(method);
            method.setAssociatedTypeNoKey(this);
            if (project.isInSLNMode()) {
                method = new RfPredefinedMethod(project, this, "sn_sorted_unique", LIST_OF_NAME_PREFIX + assocFullTypeName, "select-exp: exp", null, "@non_standard");
                method.addArgument(argumentUntypedType);
                this.addMethod(method);
                method.setAssociatedTypeNoKey(this);
            }
            method = new RfPredefinedMethod(project, this, "all", LIST_OF_NAME_PREFIX + assocFullTypeName, "exp: bool", null, "[list pseudomethod] Get all items that satisfy a condition.");
            method.addArgument(argumentBoolType);
            this.addMethod(method);
            method.setAssociatedTypeNoKey(this);
            method = new RfPredefinedMethod(project, this, "permutation", LIST_OF_NAME_PREFIX + assocFullTypeName, null, null, "[list pseudomethod] @non_standard");
            this.addMethod(method);
            method.setAssociatedTypeNoKey(this);
            method = new RfPredefinedMethod(project, this, "all_indices", "list of int", "exp: bool", null, "[list pseudomethod] Get indexes of all items that satisfy a condition.");
            method.addArgument(argumentBoolType);
            this.addMethod(method);
            if (this.fAssocType.getName().equals("int")) {
                method.setAssociatedTypeNoKey(this);
            } else {
                method.setAssociatedType(project.getSpecman().getIntListType(project));
            }
            method = new RfPredefinedMethod(project, this, "and_all", "bool", "exp: bool", null, "[list pseudomethod] Returns a TRUE if all values of the exp are true, or returns FALSE if the exp is false for any item in the list.");
            method.addArgument(argumentBoolType);
            this.addMethod(method);
            method.setAssociatedType(boolType);
            method = new RfPredefinedMethod(project, this, "or_all", "bool", "exp: bool", null, "[list pseudomethod] Returns a TRUE if any value of the exp is true, or returns FALSE if the exp is false for every item in the list. Returns FALSE if the list is empty.");
            method.addArgument(argumentBoolType);
            this.addMethod(method);
            method.setAssociatedType(boolType);
            method = new RfPredefinedMethod(project, this, "average", "int", "exp: int", null, "[list pseudomethod] Compute the average of an expression for all items.");
            method.addArgument(argumentIntType);
            this.addMethod(method);
            method.setAssociatedType(intType);
            method = new RfPredefinedMethod(project, this, "product", "int", "exp: int", null, "[list pseudomethod] Compute the product of an expression for all items.");
            method.addArgument(argumentIntType);
            this.addMethod(method);
            method.setAssociatedType(intType);
            method = new RfPredefinedMethod(project, this, "sum", "int", "exp: int, exp: bool = TRUE", null, "[list pseudomethod] Compute the sum of all items.");
            method.addArgument(argumentIntType);
            method.addArgument(argumentBoolTypeDefault);
            this.addMethod(method);
            method.setAssociatedType(intType);
            method = new RfPredefinedMethod(project, this, "crc_8", "int", "from-byte: int, num-bytes: int", null, "[list pseudomethod] Compute the CRC8 of a list of bits or a list of bytes.");
            method.addArgument(argumentIntType);
            method.addArgument(argumentIntType);
            this.addMethod(method);
            method.setAssociatedType(intType);
            method = new RfPredefinedMethod(project, this, "crc_32", "int", "from-byte: int, num-bytes: int", null, "[list pseudomethod] Compute the CRC32 of a list of bits or a list of bytes.");
            method.addArgument(argumentIntType);
            method.addArgument(argumentIntType);
            this.addMethod(method);
            method.setAssociatedType(intType);
            method = new RfPredefinedMethod(project, this, "crc_32_flip", "int", "from-byte: int, num-bytes: int", null, "[list pseudomethod] Compute the CRC32 of a list of bits or a list of bytes, flipping the bits.");
            method.addArgument(argumentIntType);
            method.addArgument(argumentIntType);
            this.addMethod(method);
            method.setAssociatedType(intType);
            method = new RfPredefinedMethod(project, this, "key", assocFullTypeName, "key-exp: exp", null, "[list pseudomethod] Get the item that has a particular key.");
            method.addArgument(argumentUntypedType);
            this.addMethod(method);
            method.setAssociatedType(this.fAssocType);
            method.setAssociatedTypeList(this.fListDepth - 1);
            method.setAssociatedTypeDeterminant(assocDeterminant);
            method = new RfPredefinedMethod(project, this, "key_index", "int", "key-exp: exp", null, "[list pseudomethod] Get the index of an item that has a particular key.");
            method.addArgument(argumentUntypedType);
            this.addMethod(method);
            method.setAssociatedType(intType);
            method = new RfPredefinedMethod(project, this, "key_exists", "bool", "key-exp: exp", null, "[list pseudomethod] Check that a particular key is in a list.");
            method.addArgument(argumentUntypedType);
            this.addMethod(method);
            method.setAssociatedType(boolType);
            method = new RfPredefinedMethod(project, this, "sn_rehash", null, "", null, "@non_standard");
            this.addMethod(method);
            method = new RfPredefinedMethod(project, this, "is_all_iterations", null, ".field_name: exp, __dvt_variable_nof_args", null, "[list method] Causes a list of structs to have all legal, non-contradicting iterations of the fields specified in the field list. The fields are iterated from right to left.");
            method.addArgument(argumentUntypedType);
            this.addMethod(method);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private static int computeDepth(RfType assocType, int listDepth) {
        if (assocType instanceof RfListType) {
            listDepth += ((RfListType)assocType).getAssociatedTypeList();
        }
        return listDepth;
    }

    private static String computeName(RfType assocType) {
        if (assocType instanceof RfListType) {
            return ((RfListType)assocType).getAssociatedTypeName();
        }
        return assocType.getName();
    }

    public static RfListType listFromType(RfProject project, RfType type) {
        if (type == null) {
            return null;
        }
        if (type instanceof RfListType) {
            RfType assocType = ((RfListType)type).getAssociatedBaseType();
            Determinant assocDeterminant = ((RfListType)type).getAssociatedTypeDeterminant();
            String assocListKey = ((RfListType)type).getAssociatedTypeListKey();
            int assocListDepth = ((RfListType)type).getAssociatedTypeList();
            String assocTypeName = assocType.getName();
            if (assocDeterminant != null && assocDeterminant.toArray() != null && assocDeterminant.toArray().length > 0) {
                assocTypeName = assocDeterminant.toString();
            }
            RfListType result = new RfListType(project, assocType, assocTypeName, assocListKey, assocListDepth + 1);
            result.setDeterminant(assocDeterminant);
            return result;
        }
        return new RfListType(project, type, type.getName(), null, 1);
    }

    public static RfType typeFromList(RfProject project, RfListType type) {
        if (type == null) {
            return null;
        }
        RfType assocType = type.getAssociatedBaseType();
        int assocListDepth = type.getAssociatedTypeList();
        if (assocListDepth == 1) {
            return assocType;
        }
        Determinant assocDeterminant = type.getAssociatedTypeDeterminant();
        String assocListKey = type.getAssociatedTypeListKey();
        String assocTypeName = assocType.getName();
        if (assocDeterminant != null && assocDeterminant.toArray() != null && assocDeterminant.toArray().length > 0) {
            assocTypeName = assocDeterminant.toString();
        }
        RfListType result = new RfListType(project, assocType, assocTypeName, assocListKey, assocListDepth - 1);
        result.setDeterminant(assocDeterminant);
        return result;
    }

    public static RfType listFromType(RfProject project, RfType assocType, Determinant assocDeterminant, String assocListKey, int assocListDepth) {
        if (assocType == null || assocListDepth <= 0) {
            return assocType;
        }
        String assocTypeName = assocType.getName();
        if (assocDeterminant != null && assocDeterminant.toArray() != null && assocDeterminant.toArray().length > 0) {
            assocTypeName = assocDeterminant.toString();
        }
        RfListType result = new RfListType(project, assocType, assocTypeName, assocListKey, assocListDepth);
        return result;
    }

    public static String prependListOfPrefix(String typeName, int listDepth) {
        if (listDepth == 0) {
            return typeName;
        }
        StringBuilder result = new StringBuilder(LIST_OF_NAME_PREFIX);
        int i = 0;
        while (i < listDepth - 1) {
            result.append(LIST_OF_NAME_PREFIX);
            ++i;
        }
        result.append(typeName);
        return result.toString();
    }

    public RfType getAssociatedType() {
        RfType result = this.fAssocType;
        HashSet<RfType> visited = new HashSet<RfType>();
        while (result instanceof RfTemplateParam && !visited.contains(result)) {
            visited.add(result);
            result = ((RfTemplateParam)result).getAssociatedType();
        }
        return result;
    }

    public RfType getAssociatedBaseType() {
        return this.fAssocType;
    }

    @Override
    public int getAssociatedTypeKind() {
        return -1;
    }

    @Override
    public void setAssociatedType(RfModule module, WrapperType typeInfo) {
    }

    @Override
    public int getAssociatedTypeList() {
        return this.fListDepth;
    }

    @Override
    public String getAssociatedTypeListKey() {
        return this.fKeyName;
    }

    @Override
    public String getAssociatedFullTypeName() {
        Determinant determinant;
        if (this.fAssocType instanceof RfStruct && (determinant = this.getAssociatedTypeDeterminant()) != null && determinant.toArray().length > 1) {
            return determinant.toString();
        }
        return this.fAssocType.getName();
    }

    public String getAssociatedTypeName() {
        return this.fAssocType.getName();
    }

    @Override
    public RfNamedElement semanticGetMember(RfProject project, Determinant determinant, String packageName, RfStruct enclosingStruct, String name, EnumSet<IRfNamedElement.ElementKind> allowedElements, int accessModifiers, int maxModuleIndex, ParserPath parserPath, RfNamedElement exclude) {
        if (this.fAssocType != null && this.fAssocType instanceof RfStruct) {
            RfField candidate;
            RfType assocType = this.fAssocType;
            int listDepth = 0;
            listDepth = 0;
            while (assocType instanceof RfListType && listDepth < 20) {
                assocType = ((RfListType)assocType).getAssociatedType();
                ++listDepth;
            }
            if (allowedElements.contains(IRfNamedElement.ElementKind.E_FIELD) && assocType instanceof RfStruct && (candidate = (RfField)((RfStruct)assocType).semanticGetMember(project, determinant = determinant == null ? new Determinant(assocType.getName()) : determinant, packageName, enclosingStruct, name, EnumSet.of(IRfNamedElement.ElementKind.E_FIELD_ONLY), accessModifiers, maxModuleIndex, parserPath, exclude)) != null) {
                RfDefElement layer;
                RfPseudoListField pseudoListField = new RfPseudoListField(project, this, candidate.getFullName(), candidate);
                WrapperType typeInfo = candidate.getTypeInfo();
                if (typeInfo != null) {
                    WrapperType typeInfo2 = new WrapperType(typeInfo);
                    RfType assocType2 = candidate.getAssociatedType();
                    if (assocType2 instanceof RfListType) {
                        typeInfo2.listDepth = 11;
                        pseudoListField.setAssociatedType(assocType2);
                        pseudoListField.setAssociatedTypeFrom(project, candidate);
                    } else {
                        typeInfo2.listDepth = 1;
                        Determinant assocDeterminant2 = candidate.getAssociatedTypeDeterminant();
                        RfType listFromType = RfListType.listFromType(project, assocType2, assocDeterminant2, null, 1);
                        pseudoListField.setAssociatedType(listFromType);
                        pseudoListField.setAssociatedTypeFrom(project, new RfDummyField(project, (IRfNamedElement)listFromType, assocDeterminant2));
                    }
                    pseudoListField.setAssociatedType(candidate.getModule(), typeInfo2);
                }
                if ((layer = candidate.getDeclaration()) != null) {
                    LineInfo line = layer.getStartInfo();
                    RfFieldLayer fieldPseudoMethodLayer = new RfFieldLayer(layer.getLayerModule(), null, line, new CommentBlock(FIELD_PSEUDO_METHOD_COMMENT, null, false), null);
                    pseudoListField.addLayer(fieldPseudoMethodLayer);
                }
                return pseudoListField;
            }
        }
        return super.semanticGetMember(project, determinant, packageName, enclosingStruct, name, allowedElements, accessModifiers, maxModuleIndex, parserPath, exclude);
    }

    @Override
    public List<RfField> getFieldsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        try {
            List<RfField> result = super.getFieldsWithPrefix(packageName, enclosingStruct, matchType, prefix, accessModifiers);
            if (result != null && !result.isEmpty() && matchType == 1) {
                return result;
            }
            if (this.fAssocType != null && this.fAssocType instanceof RfStruct) {
                RfType assocType = this.fAssocType;
                int listDepth = 0;
                listDepth = 0;
                while (assocType instanceof RfListType && listDepth < 20) {
                    assocType = ((RfListType)assocType).getAssociatedType();
                    ++listDepth;
                }
                if (assocType == null) {
                    return result;
                }
                Determinant transientDeterminant = assocType.getTransientDeterminant();
                assocType.setTransientDeterminant(this.getDeterminant());
                List<RfField> candidates = ((RfStruct)assocType).getFieldsWithPrefix(packageName, enclosingStruct, matchType, prefix, accessModifiers);
                assocType.setTransientDeterminant(transientDeterminant);
                if (candidates == null || candidates.isEmpty()) {
                    return result;
                }
                if (result == null) {
                    result = new NullProtectedList<RfField>();
                }
                for (RfField candidate : candidates) {
                    RfDefElement layer;
                    RfProject project = candidate.getRfProject();
                    RfPseudoListField pseudoListField = new RfPseudoListField(project, this, candidate.getFullName(), candidate);
                    WrapperType typeInfo = candidate.getTypeInfo();
                    if (typeInfo != null) {
                        WrapperType typeInfo2 = new WrapperType(typeInfo);
                        RfType assocType2 = candidate.getAssociatedType();
                        if (assocType2 instanceof RfListType) {
                            typeInfo2.listDepth = 11;
                            pseudoListField.setAssociatedType(assocType2);
                            pseudoListField.setAssociatedTypeFrom(project, candidate);
                        } else {
                            typeInfo2.listDepth = 1;
                            Determinant assocDeterminant2 = candidate.getAssociatedTypeDeterminant();
                            RfType listFromType = RfListType.listFromType(project, assocType2, assocDeterminant2, null, 1);
                            pseudoListField.setAssociatedType(listFromType);
                            pseudoListField.setAssociatedTypeFrom(project, new RfDummyField(project, (IRfNamedElement)listFromType, assocDeterminant2));
                        }
                        pseudoListField.setAssociatedType(candidate.getModule(), typeInfo2);
                    }
                    if ((layer = candidate.getDeclaration()) != null) {
                        LineInfo line = layer.getStartInfo();
                        RfFieldLayer fieldPseudoMethodLayer = new RfFieldLayer(layer.getLayerModule(), null, line, new CommentBlock(FIELD_PSEUDO_METHOD_COMMENT, null, false), null);
                        pseudoListField.addLayer(fieldPseudoMethodLayer);
                    }
                    result.add(pseudoListField);
                }
                if (matchType == 1) {
                    return result;
                }
            }
            return result;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    @Override
    public boolean hasTypeFromName() {
        return false;
    }

    @Override
    public Determinant getDeterminant() {
        return Determinant.resolveTypeParam(super.getDeterminant(), this.fAssocType);
    }

    @Override
    public Determinant getAssociatedTypeDeterminant() {
        return this.getDeterminant();
    }

    @Override
    public boolean isUnit() {
        return this.fAssocType instanceof RfStruct ? ((RfStruct)this.fAssocType).isUnit() : false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fAssocType == null ? 0 : this.fAssocType.hashCode());
        result = 31 * result + (this.fKeyName == null ? 0 : this.fKeyName.hashCode());
        result = 31 * result + this.fListDepth;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RfListType other = (RfListType)obj;
        if (this.fAssocType == null ? other.fAssocType != null : !this.fAssocType.equals(other.fAssocType)) {
            return false;
        }
        if (this.fKeyName == null ? other.fKeyName != null : !this.fKeyName.equals(other.fKeyName)) {
            return false;
        }
        return this.fListDepth == other.fListDepth;
    }

    public RfType get_element_type() {
        return this.fAssocType;
    }

    @Override
    public String javaName() {
        return "EList<" + this.fAssocType.javaName() + ">";
    }
}

