/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.reflection.IMacroInfo;
import ro.amiq.dvt.model.reflection.IMacroText;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfMacroLayer;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.ascomputed.base.IRfType;
import ro.amiq.edt.base.model.reflection.ascomputed.base.__etools_string;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.views.AbstractEMacrosViewContributor;

public class RfMacro
extends RfNamedElement
implements IRfType,
IMacroInfo {
    public static final String TABLE_MACRO_NAME = "__etools__table'__etools__expansion";
    private String fStringLiteral;
    private String fType;
    private boolean fIsAsComputed = false;
    private boolean fPreprocessing;
    private boolean fIsPredefined;
    private CommentBlock fComment;

    public RfMacro(RfProject project, String name, String stringLiteral, String type, boolean isAsComputed, boolean preprocessing, boolean isPredefined, CommentBlock comment) {
        super(project, name);
        this.fStringLiteral = stringLiteral;
        this.fType = DVTStringUtil.intern((String)type);
        this.fIsAsComputed = isAsComputed;
        this.fPreprocessing = preprocessing;
        if (isPredefined && !TABLE_MACRO_NAME.equals(name)) {
            this.fIsPredefined = isPredefined;
        }
        this.fComment = comment;
    }

    @Override
    public void deepClean() {
        try {
            this.fComment = null;
            super.deepClean();
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    public RfMacro(RfProject project, String name, String stringLiteral, String type, boolean isAsComputed, boolean preprocessing, boolean isPredefined) {
        this(project, name, stringLiteral, type, isAsComputed, preprocessing, isPredefined, null);
    }

    @Override
    public boolean isPredefined() {
        return this.fIsPredefined;
    }

    @Override
    public String getComment(boolean removeHTMLTags) {
        if (this.fIsPredefined) {
            String comment = "<i>PREDEFINED: </i>" + (this.fComment == null ? "[Description not available]" : this.fComment.toRawString());
            if (removeHTMLTags) {
                return DVTStringUtil.replaceAll((Pattern)RfUtils.HTML_TAGS_PATTERN, (CharSequence)comment, (String)"");
            }
            return comment;
        }
        return super.getComment(removeHTMLTags);
    }

    public String getStringLiteral() {
        return this.fStringLiteral;
    }

    public String getMacroType() {
        return this.fType;
    }

    public boolean isAsComputed() {
        return this.fIsAsComputed;
    }

    @Override
    public RfDefElement getFirstLayer() {
        if (this.hasNoLayers()) {
            return null;
        }
        for (RfDefElement layer : this.getLayers()) {
            if (!(layer instanceof RfMacroLayer) || !((RfMacroLayer)layer).isDeclaration() || this.fPreprocessing && (((RfMacroLayer)layer).isConditional() || ((RfMacroLayer)layer).isUndef())) continue;
            return layer;
        }
        return this.getLayers().get(0);
    }

    public String getSignature() {
        if (this.fIsPredefined) {
            return String.valueOf(this.isPreprocessing() ? "define " : "macro ") + this.getName().replace("__etools__api__", "");
        }
        return String.valueOf(this.isPreprocessing() ? "define " : "macro ") + this.getName();
    }

    public LinkedHashSet<String> getPreprocessingReplacements() {
        LinkedHashSet<String> macroReplacements = new LinkedHashSet<String>();
        for (RfDefElement layer : this.getLayers()) {
            String macroReplacement;
            RfMacroLayer macroLayer;
            if (!(layer instanceof RfMacroLayer) || (macroLayer = (RfMacroLayer)layer).isConditional() || macroLayer.isUndef() || (macroReplacement = macroLayer.getReplacement()) == null || (macroReplacement = macroReplacement.trim()).length() <= 0) continue;
            macroReplacements.add(macroReplacement);
        }
        return macroReplacements;
    }

    public boolean isPreprocessing() {
        return this.fPreprocessing;
    }

    public boolean isNotConditional() {
        if (this.hasNoLayers() || !this.fPreprocessing) {
            return true;
        }
        for (RfDefElement layer : this.getLayers()) {
            if (!(layer instanceof RfMacroLayer) || ((RfMacroLayer)layer).isConditional()) continue;
            return true;
        }
        return false;
    }

    public CommentBlock getCommentBlock() {
        return this.fComment;
    }

    public void removeDirty(Iterator<RfMacro> iterator) {
        if (this.fIsPredefined) {
            return;
        }
        if (this.hasNoLayers()) {
            iterator.remove();
        }
    }

    @Override
    public __etools_string get_value() {
        RfDefElement declaration = this.getDeclaration();
        if (declaration instanceof RfMacroLayer) {
            return new __etools_string(((RfMacroLayer)declaration).getReplacement());
        }
        return new __etools_string();
    }

    @Override
    public String getPackageName() {
        return null;
    }

    public IMacroText getMacroText() {
        return null;
    }

    public String getSignature(boolean prependTick, boolean asTemplateVariables) {
        return null;
    }

    public boolean hasReplacement() {
        return false;
    }

    public IRfNamedElement getCategory() {
        return new AbstractEMacrosViewContributor.CategoryWrapper(this.getRfProject(), AbstractEMacrosViewContributor.EMacroType.from(this.fType));
    }

    public IProject getProject() {
        if (this.getRfProject() == null) {
            return null;
        }
        return this.getRfProject().getProject();
    }
}

