/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import antlr.collections.AST;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.edt.base.model.reflection.RfActionBlockLayer;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfMacro;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.WrapperActionBlock;

public class RfMacroLayer
extends RfDefElement {
    private String fFullName;
    private String fStringLiteral;
    private boolean fDeclaration;
    private boolean fIsUndef;
    private String fReplacement;
    private boolean fIsConditional;
    private boolean fPreprocessing;
    private boolean fNotReparsed;
    private String fUserDefinedReplace;
    private transient AST fAST;

    public RfMacroLayer(String name, String stringLiteral, RfModule module, LineInfo startLine, LineInfo endLine, CommentBlock comment, boolean preprocessing, boolean isUndef, String replacement, boolean isConditional, boolean notReparsed) {
        super(module, module, 0, startLine, endLine.line < startLine.line ? startLine : endLine, comment, null);
        this.fFullName = name;
        this.fStringLiteral = stringLiteral;
        this.fIsUndef = isUndef;
        this.fReplacement = replacement;
        this.fIsConditional = isConditional;
        this.fPreprocessing = preprocessing;
        this.fNotReparsed = notReparsed;
    }

    public RfMacro getMacro() {
        return (RfMacro)this.getNamedElement();
    }

    public void setAST(AST node) {
        this.fAST = node;
    }

    public AST getAST() {
        return this.fAST;
    }

    public String getInfo() {
        return this.fFullName;
    }

    public String getMacroInstanceStringLiteral() {
        return this.fStringLiteral;
    }

    public boolean isDeclaration() {
        return this.fDeclaration;
    }

    public boolean isPreprocessing() {
        return this.fPreprocessing;
    }

    public void setDeclaration(boolean declaration) {
        this.fDeclaration = declaration;
    }

    public String getReplacement() {
        return this.fReplacement;
    }

    public String getFullName() {
        return this.fFullName;
    }

    public boolean isUndef() {
        return this.fIsUndef;
    }

    public boolean isConditional() {
        return this.fIsConditional;
    }

    public String getSignature() {
        String result = null;
        if (this.fPreprocessing) {
            if (this.isConditional()) {
                result = this.isUndef() ? "ifndef " : "ifdef ";
                result = String.valueOf(result) + this.getFullName();
            } else {
                result = this.isUndef() ? "undef " + this.getFullName() : (this.fReplacement == null ? "define " + this.getFullName() : "define " + this.getFullName() + " = " + this.getReplacement().trim());
            }
        }
        return result;
    }

    protected boolean isNotReparsed() {
        return this.fNotReparsed;
    }

    public void setUserDefinedReplace(String userDefinedReplace) {
        this.fUserDefinedReplace = userDefinedReplace;
    }

    public String getUserDefinedReplace() {
        return this.fUserDefinedReplace;
    }

    public RfActionBlockLayer addActionLayer(WrapperActionBlock info, RfModule module) {
        RfActionBlockLayer actionBlockLayer = new RfActionBlockLayer(module, module, 378, info.startLine, info.endLine, RfActionBlockLayer.ActionKind.OTHER, null, null);
        return actionBlockLayer;
    }
}

