/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.IRfTemplateParam;
import ro.amiq.edt.base.model.reflection.RfArg;
import ro.amiq.edt.base.model.reflection.RfArgLayer;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfExpect;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfMeImplicitVariable;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfMethodType;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfResultImplicitVariable;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfTemplateStruct;
import ro.amiq.edt.base.model.reflection.RfTemplateStructInstance;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.WrapperType;
import ro.amiq.edt.base.model.reflection.ascomputed.ClassEncap;
import ro.amiq.edt.base.model.reflection.ascomputed.base.EList;
import ro.amiq.edt.base.model.reflection.ascomputed.base.IRfType;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedField;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedMethod;
import ro.amiq.edt.base.model.reflection.semantic.RfStructQualifier;
import ro.amiq.edt.base.model.reflection.semantic.SemanticUtils;
import ro.amiq.edt.base.model.reflection.util.NullProtectedList;

public class RfMethod
extends RfStructMember
implements IRfScope {
    public static final Set<String> PSEUDO_LIST_METHODS_DECLARING_IT = new HashSet<String>();
    private String fTypeName;
    private String fArgDescription;
    private boolean fDisableArgsCheck;
    private String fEvent;
    private String fBaseName;
    private transient boolean fAsComputedTranslate;

    static {
        PSEUDO_LIST_METHODS_DECLARING_IT.add("all");
        PSEUDO_LIST_METHODS_DECLARING_IT.add("all_different");
        PSEUDO_LIST_METHODS_DECLARING_IT.add("all_indices");
        PSEUDO_LIST_METHODS_DECLARING_IT.add("and_all");
        PSEUDO_LIST_METHODS_DECLARING_IT.add("all_unique");
        PSEUDO_LIST_METHODS_DECLARING_IT.add("apply");
        PSEUDO_LIST_METHODS_DECLARING_IT.add("average");
        PSEUDO_LIST_METHODS_DECLARING_IT.add("count");
        PSEUDO_LIST_METHODS_DECLARING_IT.add("first");
        PSEUDO_LIST_METHODS_DECLARING_IT.add("first_index");
        PSEUDO_LIST_METHODS_DECLARING_IT.add("has");
        PSEUDO_LIST_METHODS_DECLARING_IT.add("is_all_iterations");
        PSEUDO_LIST_METHODS_DECLARING_IT.add("last");
        PSEUDO_LIST_METHODS_DECLARING_IT.add("last_index");
        PSEUDO_LIST_METHODS_DECLARING_IT.add("max");
        PSEUDO_LIST_METHODS_DECLARING_IT.add("max_index");
        PSEUDO_LIST_METHODS_DECLARING_IT.add("max_value");
        PSEUDO_LIST_METHODS_DECLARING_IT.add("min");
        PSEUDO_LIST_METHODS_DECLARING_IT.add("min_index");
        PSEUDO_LIST_METHODS_DECLARING_IT.add("min_value");
        PSEUDO_LIST_METHODS_DECLARING_IT.add("or_all");
        PSEUDO_LIST_METHODS_DECLARING_IT.add("product");
        PSEUDO_LIST_METHODS_DECLARING_IT.add("sort");
        PSEUDO_LIST_METHODS_DECLARING_IT.add("split");
        PSEUDO_LIST_METHODS_DECLARING_IT.add("sum");
        PSEUDO_LIST_METHODS_DECLARING_IT.add("uniq");
        PSEUDO_LIST_METHODS_DECLARING_IT.add("unique");
        PSEUDO_LIST_METHODS_DECLARING_IT.add("sn_sorted_unique");
    }

    public RfMethod(RfProject project, RfStruct parentStruct, FullName name) {
        super(project, name, parentStruct);
    }

    @Override
    int getMemberKind() {
        return 1;
    }

    public void setArgumentDescr(String argDescription) {
        if (argDescription == null) {
            this.fArgDescription = "";
            return;
        }
        boolean[] hasReplacement = new boolean[1];
        this.fArgDescription = DVTStringUtil.replace((String)argDescription, (String[])new String[]{"__dvt_variable_nof_args", "__dvt_ignore_args"}, (String)"...", (boolean[])hasReplacement);
        this.fArgDescription = DVTStringUtil.intern((String)this.fArgDescription);
        this.fDisableArgsCheck = hasReplacement[0];
    }

    public boolean isDisabledArgsCheck() {
        return this.fDisableArgsCheck;
    }

    public void setTCMEventName(String eventName) {
        this.fEvent = eventName;
    }

    public boolean isIgnoreArgs() {
        return false;
    }

    @Override
    public IRfScope getEnclosingScope() {
        return this.getParentStruct();
    }

    @Override
    public void setAssociatedType(RfModule module, WrapperType typeInfo) {
        try {
            if (typeInfo == null) {
                return;
            }
            if (typeInfo.baseType == 10) {
                this.fTypeName = this.getTypeName(typeInfo.def, typeInfo.listDepth);
                this.fBaseName = typeInfo.baseName == null ? this.fTypeName : typeInfo.baseName;
            } else if (typeInfo.baseType == 9) {
                this.fTypeName = this.getTypeName(typeInfo.def == null ? this.getName() : typeInfo.def, typeInfo.listDepth);
                this.fBaseName = typeInfo.baseName == null ? this.fTypeName : typeInfo.baseName;
            } else {
                this.fTypeName = this.getTypeName(typeInfo.def, typeInfo.listDepth);
                String string = this.fBaseName = typeInfo.baseName == null ? this.fTypeName : typeInfo.baseName;
            }
            if ((this.fBaseName == null || this.fBaseName.isEmpty()) && (this.fTypeName == null || this.fTypeName.isEmpty())) {
                this.fTypeName = "void";
                this.fBaseName = "void";
            }
            this.fTypeName = DVTStringUtil.intern((String)this.fTypeName);
            this.fBaseName = DVTStringUtil.intern((String)this.fBaseName);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void setAssociatedType(RfType type) {
        super.setAssociatedType(type);
    }

    @Override
    public void setAssociatedTypeFrom(RfProject project, RfNamedElement typeContainer) {
        super.setAssociatedTypeFrom(project, typeContainer);
    }

    @Override
    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currLayer, LineInfo lineInfo, ParserPath parserPath) {
        try {
            if (currLayer instanceof RfMethodLayer) {
                String name = this.getName();
                if (currLayer instanceof RfMethodLayer && !((RfMethodLayer)currLayer).checkArgDefaults()) {
                    project.addSemanticError1(1, "ARGUMENT_DEFAULT: Arguments following an argument with default value must also have default values", lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, new Object[0]);
                }
                RfStructMember.FirstAndPrevLayer firstAndPrevLayer = this.getFirstAndPrevLayer(project, (RfMethodLayer)currLayer);
                RfStruct parentStruct = this.getParentStruct();
                boolean hasLocalUnknownParentStruct = parentStruct.hasLocalUnknownParentStruct();
                if (!hasLocalUnknownParentStruct) {
                    RfStruct firstStruct;
                    RfStruct rfStruct = firstStruct = firstAndPrevLayer == null ? null : firstAndPrevLayer.firstStruct;
                    if (firstAndPrevLayer == null || firstAndPrevLayer.prevRawLayer == null) {
                        boolean isFirstOrEmptyLayer = this.isFirstOrEmptyLayer(currLayer);
                        boolean isEmptyLayer = this.isEmptyLayer(currLayer);
                        boolean predefined = this.isPredefined();
                        if (!(predefined || firstStruct != null && firstStruct != parentStruct || isFirstOrEmptyLayer)) {
                            String errorMessage = ((RfMethodLayer)currLayer).isCVL() ? "UNDEFINED_METHOD: CVL method ''{0}.{1}()'' was not defined previously" : "UNDEFINED_METHOD: Method ''{0}.{1}()'' was not defined previously (cannot use ''is also'', ''is first'' or ''is only'')";
                            project.addSemanticError1(1, errorMessage, lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, parentStruct.getName(), this.getName());
                        } else if (predefined && firstStruct != null && firstStruct == this.getParentStruct() && firstStruct.isPredefined() && isEmptyLayer) {
                            Determinant determinant = ((RfMethodLayer)currLayer).getDefStructDeterminant();
                            if (determinant != null && determinant.toArray().length == 1) {
                                project.addSemanticError1(1, "REDEFINED_METHOD: Method ''{0}.{1}()'' was previously defined in predefined struct ''{2}'' (must use ''is also'', ''is first'' or ''is only'')", lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, this.getParentStruct().getName(), name, firstStruct.getName());
                            }
                        } else if (predefined && parentStruct.getMethod(this.getName()) instanceof RfPredefinedMethod) {
                            RfMethod parentMethod = parentStruct.getMethod(this.getName());
                            String currEvent = ((RfMethodLayer)currLayer).getTCMEvent();
                            String prevEvent = parentMethod.getEvent();
                            boolean isCurrTCM = currEvent != null && !currEvent.isEmpty();
                            boolean isPrevTCM = ((RfPredefinedMethod)parentMethod).isTCM();
                            if (isPrevTCM && !isCurrTCM) {
                                project.addSemanticError1(1, "EXTEND_TCM: Predefined TCM ''{0}.{1}() @{2}'' cannot be extended as non-TCM", lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, parentStruct.getName(), name, prevEvent);
                            } else if (!isPrevTCM && isCurrTCM) {
                                project.addSemanticError1(1, "EXTEND_NON_TCM: Predefined non-TCM ''{0}.{1}()'' cannot be extended as TCM", lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, parentStruct.getName(), name);
                            } else if (currEvent != null && !currEvent.equals(prevEvent)) {
                                project.addSemanticError1(2, "REDEFINED_TCM_EVENT: Event name ''{0}'' differs from previous TCM declaration ''{1}.{2}() @ {3}''", lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, currEvent, parentStruct.getName(), name, prevEvent);
                            }
                        }
                        return;
                    }
                }
                RfDefElement firstLayer = firstAndPrevLayer.firstLayer;
                RfDefElement prevLayer = firstAndPrevLayer.prevLayer;
                RfDefElement prevRawLayer = firstAndPrevLayer.prevRawLayer;
                if (prevRawLayer != null && this.isEmptyLayer(currLayer)) {
                    project.addSemanticError1(1, "REDEFINED_METHOD: Method ''{0}.{1}()'' was previously defined (must use ''is also'', ''is first'' or ''is only'')\n    at line {2,number,#######} in {3}", lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, parentStruct.getName(), name, prevRawLayer.getStartLine(), prevRawLayer.getParserPath());
                    return;
                }
                if (firstLayer instanceof RfMethodLayer && prevLayer != null) {
                    List<RfArgLayer> firstLayerArgs = ((RfMethodLayer)firstLayer).getArgs();
                    boolean isFinal = ((RfMethodLayer)firstLayer).isFinal();
                    String errorMessage = ((RfMethodLayer)currLayer).checkArgListVsOriginal(firstLayerArgs);
                    if (errorMessage != null) {
                        project.addSemanticError1(1, errorMessage, lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, new Object[0]);
                    } else if (((RfMethodLayer)currLayer).isFinal()) {
                        project.addSemanticError1(1, "REDEFINED_FINAL: Cannot declare ''{0}.{1}()'' as final, it was previously defined\n    at line {2,number,#######} in {3}", lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, name, parentStruct.getName(), prevLayer.getStartLine(), prevLayer.getParserPath());
                    } else if (isFinal) {
                        project.addSemanticError1(1, "EXTEND_FINAL: Cannot extend ''{0}.{1}()'', it was previously defined final\n    at line {2,number,#######} in {3}", lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, name, parentStruct.getName(), prevLayer.getStartLine(), prevLayer.getParserPath());
                    } else {
                        boolean isPrevTCM;
                        String currEvent = ((RfMethodLayer)currLayer).getTCMEvent();
                        String prevEvent = ((RfMethodLayer)firstLayer).getTCMEvent();
                        boolean isCurrTCM = currEvent != null && !currEvent.isEmpty();
                        boolean bl = isPrevTCM = prevEvent != null && !prevEvent.isEmpty();
                        if (!isCurrTCM && isPrevTCM) {
                            project.addSemanticError1(1, "EXTEND_TCM: TCM ''{0}.{1}()'' cannot be extended as non-TCM, it was previously defined\n    at line {2,number,#######} in {3}", lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, parentStruct.getName(), name, firstLayer.getStartLine(), firstLayer.getParserPath());
                        } else if (isCurrTCM && !isPrevTCM) {
                            project.addSemanticError1(1, "EXTEND_NON_TCM: Non-TCM ''{0}.{1}()'' cannot be extended as TCM, it was previously defined\n    at line {2,number,#######} in {3}", lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, parentStruct.getName(), name, firstLayer.getStartLine(), firstLayer.getParserPath());
                        } else if (currEvent != null && !currEvent.equals(prevEvent)) {
                            project.addSemanticError1(2, "REDEFINED_TCM_EVENT: Event name ''{0}'' differs from previous TCM declaration ''{1}.{2}() @ {3}''", lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, currEvent, parentStruct.getName(), name, prevEvent);
                        }
                    }
                    if ((this.isPrivate() || this.isPackage()) && !firstLayer.getPackageName().equals(currLayer.getPackageName())) {
                        project.addSemanticError1(1, "METHOD_ACCESS: Cannot access method ''{1}.{0}()'' of package ''{2}''", lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, this.getName(), parentStruct.getName(), this.getPackageName());
                    }
                    if (((RfMethodLayer)currLayer).getMethod() == ((RfMethodLayer)prevLayer).getMethod() && this.isFirstOrEmptyLayer(currLayer) && this.isFirstLayer(prevLayer)) {
                        project.addSemanticError1(1, "REDEFINED_METHOD: Method ''{0}.{1}()'' was previously defined (must use ''is also'', ''is first'' or ''is only'')\n    at line {2,number,#######} in {3}", lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, parentStruct.getName(), name, prevLayer.getStartLine(), prevLayer.getParserPath());
                    }
                }
            }
        }
        catch (BuildCancelException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean isFirstLayer(RfDefElement layer) {
        if (layer.getLayerKind() == 378) {
            return true;
        }
        return layer.getLayerKind() == 373;
    }

    private boolean isEmptyLayer(RfDefElement layer) {
        if (layer.getLayerKind() == 371) {
            return true;
        }
        return layer.getLayerKind() == 372;
    }

    private boolean isFirstOrEmptyLayer(RfDefElement layer) {
        if (this.isFirstLayer(layer)) {
            return true;
        }
        return this.isEmptyLayer(layer);
    }

    public boolean hasMethodInLikeParent() {
        return this.getMethodInLikeParent(true) != this.getParentStruct();
    }

    public RfStruct getMethodInLikeParent(boolean breakOnFirst) {
        String name = this.getName();
        RfStruct parent = this.getParentStruct();
        if (parent == null) {
            return null;
        }
        RfStruct firstStruct = parent;
        while ((parent = parent.getParentStruct()) != null) {
            if (!parent.hasLocalMember(name, null, this.getMemberKind())) continue;
            firstStruct = parent;
            if (breakOnFirst) break;
        }
        return firstStruct;
    }

    @Override
    public RfType getAssociatedBaseType() {
        if ("void".equals(this.fBaseName)) {
            return this.getRfProject().getSpecman().getVoidType();
        }
        return super.getAssociatedBaseType();
    }

    @Override
    public RfType getAssociatedType() {
        if ("void".equals(this.fBaseName)) {
            return this.getRfProject().getSpecman().getVoidType();
        }
        return super.getAssociatedType();
    }

    public RfDefElement getLastLayerOfMethodInLikeParent() {
        String name = this.getName();
        RfStruct parent = this.getParentStruct();
        while ((parent = parent.getParentStruct()) != null) {
            if (!parent.hasLocalMember(name, null, this.getMemberKind())) continue;
            return parent.getLastLocalMethodLayer(name);
        }
        return null;
    }

    public RfDefElement getFirstLayerOfMethodInLikeParent() {
        String name = this.getName();
        RfStruct parent = this.getMethodInLikeParent(false);
        if (parent != null) {
            return parent.getFirstLocalMethodLayer(name);
        }
        return null;
    }

    public String getSignature() {
        String typeName = this.getSignatureTypeName();
        return this.getSignature(typeName);
    }

    @Override
    public String getSignature(String typeName) {
        String parentStructName;
        RfStruct parentStruct = this.getParentStruct();
        boolean isPseudoMethod = false;
        boolean isMethodType = false;
        String string = parentStructName = parentStruct == null ? "" : parentStruct.getName();
        if (parentStructName.equals("pseudo_struct")) {
            isPseudoMethod = true;
        }
        if (parentStruct instanceof RfMethodType) {
            isMethodType = true;
        }
        String argDescription = this.getArgs();
        return String.valueOf(isPseudoMethod ? "pseudo-method " : (isMethodType ? "method_type " : String.valueOf(this.isTCM() ? "TCM " : "method ") + this.replaceParameterNames(parentStructName) + ".")) + this.getName() + "\n" + "(" + (argDescription != null ? argDescription : "") + ")" + (typeName == null || typeName.isEmpty() || "void".equals(typeName) ? "" : "\n:" + typeName) + (this.isTCM() ? "\n@" + this.fEvent : "");
    }

    public String getSignatureTypeName() {
        String typeName = this.getAssociatedFullTypeName();
        if ("void".equals(typeName)) {
            return "";
        }
        int i = 0;
        while (i < this.getAssociatedTypeList()) {
            typeName = DVTStringUtil.appendString((Object[])new Object[]{"list of ", typeName});
            ++i;
        }
        return typeName;
    }

    protected void toString(StringBuilder sb) {
        sb.append("Method: " + this.getName());
        sb.append("\n");
        int i = 0;
        while (i < this.getLayers().size()) {
            RfMethodLayer mLayer = (RfMethodLayer)this.getLayers().get(i);
            mLayer.toString(sb);
            sb.append("\n");
            ++i;
        }
    }

    public String getArgs() {
        return this.replaceParameterNames(this.fArgDescription);
    }

    public String getEvent() {
        return this.fEvent;
    }

    public boolean isTCM() {
        return this.fEvent != null && !this.fEvent.equals("");
    }

    @Override
    public Determinant getDeterminant() {
        return this.getFullName().getDeterminant();
    }

    @Override
    public void setTransientDeterminant(Determinant determinant) {
    }

    @Override
    public Determinant getTransientDeterminant() {
        return this.getDeterminant();
    }

    @Override
    public String getContextType() {
        return "ro.amiq.edt.templates.contextType.action";
    }

    @Override
    public List<RfVar> getVariablesWithPrefix(int line, int matchType, String prefix) {
        NullProtectedList<RfResultImplicitVariable> result = null;
        if (this.fTypeName == null || this.fTypeName.isEmpty() || "void".equals(this.fTypeName)) {
            return result;
        }
        if (DVTStringUtil.regionMatches((String)"result", (String)prefix, (int)matchType)) {
            result = new NullProtectedList<RfResultImplicitVariable>();
            result.add(new RfResultImplicitVariable(this.getRfProject(), this));
        }
        return result;
    }

    @Override
    public RfVar getVariableWithPrefix(int line, int matchType, String prefix) {
        if (this.fTypeName == null || this.fTypeName.isEmpty() || "void".equals(this.fTypeName)) {
            return null;
        }
        if (DVTStringUtil.regionMatches((String)"result", (String)prefix, (int)matchType)) {
            return new RfResultImplicitVariable(this.getRfProject(), this);
        }
        return null;
    }

    public RfVar getLocalVariable(String name) {
        if (this.fTypeName == null || this.fTypeName.isEmpty() || "void".equals(this.fTypeName)) {
            return null;
        }
        if ("result".equals(name)) {
            return new RfResultImplicitVariable(this.getRfProject(), this);
        }
        return null;
    }

    @Override
    public List<RfArg> getArgumentsWithPrefix(int matchType, String prefix) {
        return null;
    }

    public List<RfArg> getArguments(ParserPath importedByTest) {
        RfDefElement declaration = this.getDeclaration(importedByTest);
        if (declaration == null || !(declaration instanceof RfMethodLayer)) {
            return null;
        }
        List<RfArg> arguments = ((RfMethodLayer)declaration).getArgumentsWithPrefix(2, "");
        return this.processArguments(arguments);
    }

    public RfDefElement getDeclaration(ParserPath importedByTest) {
        if (importedByTest == null) {
            return this.getDeclaration();
        }
        for (RfDefElement layer : this.getLayers()) {
            RfModule layerModule = layer.getLayerModule();
            if (layerModule == null || !importedByTest.equals((Object)layerModule.fImportedByTest)) continue;
            return layer;
        }
        return this.getDeclaration();
    }

    public List<RfArg> processArguments(List<RfArg> arguments) {
        RfStruct parentStruct = this.getParentStruct();
        if (arguments == null || arguments.isEmpty() || !(parentStruct instanceof RfTemplateStructInstance)) {
            return arguments;
        }
        RfTemplateStructInstance templateStructInstance = (RfTemplateStructInstance)parentStruct;
        RfTemplateStruct templateStruct = templateStructInstance.getTemplateStruct();
        templateStruct.setParamsValueOverride(templateStructInstance.getParameters());
        RfProject project = this.getRfProject();
        ArrayList<RfArg> arguments2 = new ArrayList<RfArg>(arguments.size());
        for (RfArg arg : arguments) {
            IRfTemplateParam typeContainer = templateStruct.getParameter(arg.getTypeName());
            if (typeContainer != null) {
                try {
                    RfArg arg2 = (RfArg)arg.clone();
                    arg2.setAssociatedTypeFrom(project, (RfNamedElement)((Object)typeContainer));
                    arg2.setAssociatedTypeList(arg2.getAssociatedTypeList() + arg.getAssociatedTypeList());
                    if (arg.getAssociatedTypeListKey() != null) {
                        arg2.setAssociatedTypeListKey(arg.getAssociatedTypeListKey());
                    }
                    arg2.setAssociatedTypeDeterminant(arg.getAssociatedTypeDeterminant());
                    RfType instanceAssocType = arg2.getAssociatedType();
                    Determinant instanceAssocDeterminant = arg2.getAssociatedTypeDeterminant();
                    String typeName = null;
                    typeName = instanceAssocType instanceof RfListType ? (instanceAssocDeterminant == null ? ((RfListType)instanceAssocType).getAssociatedTypeName() : instanceAssocDeterminant.toString()) : (instanceAssocDeterminant == null ? instanceAssocType.getName() : instanceAssocDeterminant.toString());
                    arg2.setAssociatedType(this.getModule(), new WrapperType().setBaseName(typeName).setDefName(typeName));
                    arguments2.add(arg2);
                }
                catch (CloneNotSupportedException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                continue;
            }
            arguments2.add(arg);
        }
        return arguments2;
    }

    @Override
    public RfArg getArgumentWithPrefix(int matchType, String prefix) {
        return null;
    }

    @Override
    public List<RfField> getFieldsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int hidingLevel) {
        if (this.getParentStruct() == null) {
            return null;
        }
        return this.getParentStruct().getFieldsWithPrefix(packageName, enclosingStruct, matchType, prefix, hidingLevel);
    }

    @Override
    public RfField getFieldWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int hidingLevel) {
        if (this.getParentStruct() == null) {
            return null;
        }
        return this.getParentStruct().getFieldWithPrefix(packageName, enclosingStruct, matchType, prefix, hidingLevel);
    }

    @Override
    public List<RfMethod> getMethodsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int hidingLevel) {
        if (this.getParentStruct() == null) {
            return null;
        }
        return this.getParentStruct().getMethodsWithPrefix(packageName, enclosingStruct, matchType, prefix, hidingLevel);
    }

    @Override
    public RfMethod getMethodWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int hidingLevel) {
        if (this.getParentStruct() == null) {
            return null;
        }
        return this.getParentStruct().getMethodWithPrefix(packageName, enclosingStruct, matchType, prefix, hidingLevel);
    }

    @Override
    public List<RfEvent> getEventsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int hidingLevel) {
        if (this.getParentStruct() == null) {
            return null;
        }
        return this.getParentStruct().getEventsWithPrefix(packageName, enclosingStruct, matchType, prefix, hidingLevel);
    }

    @Override
    public RfEvent getEventWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int hidingLevel) {
        if (this.getParentStruct() == null) {
            return null;
        }
        return this.getParentStruct().getEventWithPrefix(packageName, enclosingStruct, matchType, prefix, hidingLevel);
    }

    @Override
    public List<RfExpect> getExpectsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        if (this.getParentStruct() == null) {
            return null;
        }
        return this.getParentStruct().getExpectsWithPrefix(packageName, enclosingStruct, matchType, prefix, accessModifiers);
    }

    @Override
    public RfExpect getExpectWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        if (this.getParentStruct() == null) {
            return null;
        }
        return this.getParentStruct().getExpectWithPrefix(packageName, enclosingStruct, matchType, prefix, accessModifiers);
    }

    @Override
    public RfMeImplicitVariable getMeImplicitVariable(int matchType, String prefix) {
        if (this.getParentStruct() == null) {
            return null;
        }
        return this.getParentStruct().getMeImplicitVariable(matchType, prefix);
    }

    @Override
    public RfPredefinedField getCompImplicitVariable(RfProject project, int matchType, String prefix) {
        if (this.getParentStruct() == null) {
            return null;
        }
        return this.getParentStruct().getCompImplicitVariable(project, matchType, prefix);
    }

    @Override
    public boolean isInGlobal() {
        if (this.getParentStruct() == null) {
            return false;
        }
        return this.getParentStruct().isInGlobal();
    }

    @Override
    public List<RfEnum> getEnumsWithPrefix(int matchType, String prefix) {
        return null;
    }

    @Override
    public RfEnum getEnumWithPrefix(int matchType, String prefix) {
        return null;
    }

    @Override
    public String getDefStructLayerName() {
        try {
            RfDefElement declaration = this.getDeclaration(false);
            if (declaration != null && declaration instanceof RfMethodLayer) {
                return ((RfMethodLayer)declaration).getDefStructLayerName();
            }
            return this.getParentStruct().getName();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }

    @Override
    public String getAssociatedFullTypeName() {
        return this.fTypeName;
    }

    public int getModuleIndex() {
        return this.getModule().getModuleIndex();
    }

    public String getAssociatedTypeName() {
        return this.fBaseName;
    }

    public String getAssociatedTypePackageName() {
        RfType assocType = this.getAssociatedType();
        if (assocType == null) {
            return null;
        }
        return assocType.getPackageName();
    }

    public boolean getAssociatedTypeStrictPackage() {
        return true;
    }

    public void setByEvent(boolean byEvent) {
    }

    public boolean isByEvent() {
        if (this.getName().startsWith("on_")) {
            FullName candidateName = new FullName(this.getName().substring(3), this.getFullName().getDeterminant());
            if (this.getParentStruct().getEvent(candidateName) != null) {
                return true;
            }
        }
        return false;
    }

    public RfType get_type() {
        return this.getAssociatedType();
    }

    @Override
    public ClassEncap toClassEncap(RfProject project) {
        String originalName = this.getName();
        if (this instanceof RfPredefinedMethod && !"to_string".equals(originalName)) {
            return null;
        }
        RfType assocType = this.getAssociatedBaseType();
        if (assocType == project.getSpecman().getVoidType()) {
            assocType = null;
        }
        HashSet<RfType> references = new HashSet<RfType>();
        if (assocType != null) {
            references.add(assocType);
        }
        StringBuilder javaCode = new StringBuilder();
        String javaTypeName = this.javaTypeName();
        int assocTypeListDepth = this.getAssociatedTypeList();
        String name = originalName;
        if ("to_string".equals(originalName)) {
            name = "toEString";
        }
        List<RfDefElement> layers = this.getLayers();
        String staticAccess = this.isStatic() ? "static " : "";
        int i = 0;
        while (i < layers.size()) {
            RfMethodLayer layer = (RfMethodLayer)layers.get(i);
            layer.collectJavaReferences(references);
            List<RfArg> arguments = layer.getArgumentsWithPrefix(2, "");
            String methodArguments = "to_string".equals(originalName) ? "Object input" : this.javaMethodArguments(arguments, references);
            StringBuilder resultArgument = new StringBuilder();
            if (!javaTypeName.equals("void")) {
                resultArgument.append(javaTypeName).append(" __etools_result");
                if (!methodArguments.isEmpty()) {
                    resultArgument.append(", ");
                }
            }
            javaCode.append("private ").append(staticAccess).append(javaTypeName).append(" ").append("__etools_").append(i).append("_").append(name).append("(").append((CharSequence)resultArgument).append(methodArguments).append(") {\n");
            javaCode.append("    try {\n");
            javaCode.append("        __etools_rf_manager = __global.__etools_rf_manager;\n");
            javaCode.append("        __global.__etools_push_matcher();\n");
            javaCode.append(layer.getJavaCode());
            if (!javaTypeName.equals("void")) {
                javaCode.append("        return __etools_result;\n");
            }
            javaCode.append("    } catch (Exception e) {\n");
            javaCode.append("        if (e instanceof AsComputedReturnException) {\n");
            javaCode.append("            // nothing\n");
            javaCode.append("        } else if (e instanceof RuntimeException) {\n");
            javaCode.append("            throw (RuntimeException) e;\n");
            javaCode.append("        } else {\n");
            javaCode.append("            throw new RuntimeException(e.getMessage());\n");
            javaCode.append("        }\n");
            if (!javaTypeName.equals("void")) {
                javaCode.append("        return null;\n");
            }
            javaCode.append("    } finally {\n");
            javaCode.append("        __global.__etools_pop_matcher();\n");
            javaCode.append("    }\n");
            javaCode.append("}\n\n");
            String javaExtendedCode = layer.getJavaExtendedCode();
            javaCode.append(javaExtendedCode);
            ++i;
        }
        RfDefElement declaration = this.getDeclaration();
        List<RfArg> arguments = null;
        if (declaration instanceof RfMethodLayer) {
            arguments = ((RfMethodLayer)declaration).getArgumentsWithPrefix(2, "");
        } else if (this instanceof RfPredefinedMethod) {
            arguments = ((RfPredefinedMethod)this).getArguments(null);
        }
        String methodArguments = "to_string".equals(originalName) ? "Object input" : this.javaMethodArguments(arguments, references);
        StringBuilder also = new StringBuilder();
        DVTStringBuilder first = new DVTStringBuilder();
        boolean[] newElementsToTranslate = new boolean[1];
        int i2 = 0;
        while (i2 < layers.size()) {
            RfMethodLayer layer = (RfMethodLayer)layers.get(i2);
            StringBuilder layerMethodCall = this.getJavaMethodLayerCall(project, layer, arguments, i2, javaTypeName, newElementsToTranslate);
            if (layer.getLayerKind() == 375) {
                first.prepend(layerMethodCall.toString());
            } else if (layer.getLayerKind() == 376) {
                also.append(layerMethodCall.toString());
            } else if (layer.getLayerKind() == 377 || layer.getLayerKind() == 378) {
                first.prepend(layerMethodCall.toString());
            }
            ++i2;
        }
        javaCode.append("public ").append(staticAccess).append(javaTypeName).append(" ").append(name).append("(").append(methodArguments).append(") {\n");
        javaCode.append("    try {\n");
        javaCode.append("        __etools_rf_manager = __global.__etools_rf_manager;\n");
        javaCode.append("        __global.__etools_push_matcher();\n");
        javaCode.append("        int layerIndex = -1;\n");
        if (!javaTypeName.equals("void")) {
            javaCode.append("        ").append(javaTypeName).append(" __etools_result");
            if (assocTypeListDepth > 0) {
                javaCode.append(" = new ").append(javaTypeName).append("()");
            } else if (javaTypeName.equals("_Int")) {
                javaCode.append(" = _Int.ZERO");
            } else if (javaTypeName.equals("Double")) {
                javaCode.append(" = 0D");
            } else if (javaTypeName.equals("Boolean")) {
                javaCode.append(" = false");
            } else {
                javaCode.append(" = null");
            }
            javaCode.append(";\n");
        }
        javaCode.append(first).append((CharSequence)also).append("\n");
        if (!javaTypeName.equals("void")) {
            javaCode.append("        return __etools_result;\n");
        }
        javaCode.append("    } catch (Exception e) {\n");
        javaCode.append("        if (e instanceof AsComputedReturnException) {\n");
        javaCode.append("            // nothing\n");
        javaCode.append("        } else if (e instanceof RuntimeException) {\n");
        javaCode.append("            throw (RuntimeException) e;\n");
        javaCode.append("        } else {\n");
        javaCode.append("            throw new RuntimeException(e.getMessage());\n");
        javaCode.append("        }\n");
        if (!javaTypeName.equals("void")) {
            javaCode.append("        return null;\n");
        }
        javaCode.append("    } finally {\n");
        javaCode.append("        __global.__etools_pop_matcher();\n");
        javaCode.append("    }\n");
        javaCode.append("}\n\n");
        if (arguments != null && !arguments.isEmpty()) {
            List<RfArg> nonDefaultArgs = arguments;
            int i3 = arguments.size() - 1;
            while (i3 >= 0) {
                String defaultValue;
                RfArg argument = arguments.get(i3);
                RfDefElement argDeclaration = argument.getDeclaration();
                String string = defaultValue = argDeclaration == null ? null : ((RfArgLayer)argDeclaration).javaDefaultValue();
                if (argDeclaration instanceof RfArgLayer && defaultValue != null) {
                    nonDefaultArgs = nonDefaultArgs.subList(0, nonDefaultArgs.size() - 1);
                    javaCode.append("public ").append(staticAccess).append(javaTypeName).append(" ").append(name).append("(").append(this.javaMethodArguments(nonDefaultArgs, references)).append(") {\n");
                    if (!javaTypeName.equals("void")) {
                        javaCode.append("    return ");
                    }
                    javaCode.append("this.").append(name).append("(");
                    if (!nonDefaultArgs.isEmpty()) {
                        javaCode.append(this.javaMethodCallArguments(nonDefaultArgs)).append(", ");
                    }
                    javaCode.append(defaultValue).append(");\n");
                    javaCode.append("}\n\n");
                }
                --i3;
            }
        }
        return new ClassEncap(javaCode.toString(), references, newElementsToTranslate[0]);
    }

    private StringBuilder getJavaMethodLayerCall(RfProject project, RfMethodLayer methodLayer, List<RfArg> arguments, int layerIndex, String javaTypeName, boolean[] newElementsToTranslate) {
        String methodCallArguments;
        String originalName;
        String name = originalName = this.getName();
        if ("to_string".equals(originalName)) {
            name = "toEString";
        }
        RfStructLayer structLayer = methodLayer.getStructLayer();
        List<RfStructQualifier> structQualifiers = structLayer.getStructQualifiers();
        StringBuilder layerMethodCall = new StringBuilder();
        boolean isWhenSubtype = false;
        if (structQualifiers == null || structQualifiers.isEmpty()) {
            layerMethodCall.append("if (layerIndex < ").append(layerIndex).append(") {\n");
        } else {
            isWhenSubtype = true;
            for (RfStructQualifier structQualifier : structQualifiers) {
                if (layerMethodCall.length() != 0) {
                    layerMethodCall.append(" && ");
                }
                layerMethodCall.append(structQualifier.javaCondition());
            }
            layerMethodCall.append(" && layerIndex < ").append(layerIndex);
            layerMethodCall.insert(0, "if (");
            layerMethodCall.append(") {\n");
        }
        String string = methodCallArguments = "to_string".equals(originalName) ? "input" : this.javaMethodCallArguments(arguments);
        if (!isWhenSubtype && layerIndex == 0 && methodLayer.getLayerKind() == 376) {
            RfMethod parentMethod;
            RfStruct parentStruct;
            RfStruct struct;
            if (!javaTypeName.equals("void")) {
                layerMethodCall.append("__etools_result = ");
            }
            if ((struct = structLayer.getStruct()) != null && (parentStruct = struct.getParentStruct()) != null && (parentMethod = parentStruct.getMethod(this.getName())) != null) {
                newElementsToTranslate[0] = newElementsToTranslate[0] | !parentMethod.isAsComputedTranslate();
                parentMethod.asComputedTranslate(project);
                layerMethodCall.append("super.").append(name).append("(").append(methodCallArguments).append(");\n");
            }
        }
        StringBuilder resultArgument = new StringBuilder();
        if (!javaTypeName.equals("void")) {
            resultArgument.append(" __etools_result");
            if (!methodCallArguments.isEmpty()) {
                resultArgument.append(", ");
            }
        }
        if (!javaTypeName.equals("void")) {
            layerMethodCall.append("__etools_result = ");
        }
        layerMethodCall.append("__etools_").append(layerIndex).append("_").append(name).append("(").append((CharSequence)resultArgument).append(methodCallArguments).append(");\n");
        if (methodLayer.getLayerKind() == 377 || methodLayer.getLayerKind() == 378 && layerIndex != 0 && isWhenSubtype) {
            layerMethodCall.append("layerIndex = ").append(layerIndex).append(";\n");
        } else if (methodLayer.getLayerKind() == 375) {
            layerMethodCall.insert(0, "__global.__etools_return_from_is_first_method_layer = false;\n");
            layerMethodCall.append("if (__global.__etools_return_from_is_first_method_layer) {\n");
            layerMethodCall.append("layerIndex = ").append(layerIndex).append(";\n");
            layerMethodCall.append("}\n");
        }
        layerMethodCall.append("}\n");
        return layerMethodCall;
    }

    protected String javaMethodArguments(List<RfArg> arguments, Collection<RfType> references) {
        if (arguments == null || arguments.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (RfArg argument : arguments) {
            if (result.length() != 0) {
                result.append(", ");
            }
            result.append(argument.javaTypeName()).append(" ").append(argument.javaName());
            references.add(argument.getAssociatedBaseType());
        }
        return result.toString();
    }

    protected String javaMethodCallArguments(List<RfArg> arguments) {
        if (arguments == null || arguments.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (RfArg argument : arguments) {
            if (result.length() != 0) {
                result.append(", ");
            }
            result.append(argument.javaName());
        }
        return result.toString();
    }

    public RfMethodLayer getLayer(int kind, int line) {
        List<RfDefElement> layers = this.internalGetLayers();
        if (layers == null) {
            return null;
        }
        for (RfDefElement layer : layers) {
            if (layer.getStartLine() != line) continue;
            return (RfMethodLayer)layer;
        }
        return null;
    }

    public boolean hasLayerAt(ParserPath parserPath, LineInfo line) {
        List<RfDefElement> layers = this.internalGetLayers();
        if (layers == null) {
            return false;
        }
        for (RfDefElement layer : layers) {
            if (layer.getStartLine() != line.line || !layer.getParserPath().equals((Object)parserPath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IRfNamedElement elementPathMember(String name, boolean isFirst, boolean isLast, boolean includeEnums, boolean isOnlyType, IRfNamedElement bindInstanceScope, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, ParserPath parserPath, int line) {
        int indexOfAt = name.indexOf(64);
        RfDefElement declaration = this.getDeclaration();
        if (declaration == null) {
            return null;
        }
        int offset = -1;
        if (indexOfAt > 0) {
            offset = Integer.parseInt(name.substring(indexOfAt + 1));
            name = name.substring(0, indexOfAt);
        }
        if (offset > 0) {
            IRfScope scope = declaration.getLayerModule().getScope(-1, offset);
            if (scope == null) {
                return null;
            }
            return scope.getVariableWithPrefix(Integer.MAX_VALUE, 1, name);
        }
        return super.elementPathMember(name, isFirst, isLast, includeEnums, isOnlyType, bindInstanceScope, classes, exclude, parserPath, line);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean checkEquals(Object obj) {
        block18: {
            field = null;
            if (obj instanceof RfField && this.getEnclosingScope().equals(((RfField)obj).getEnclosingScope()) && ((field = (RfField)obj).isInputPort() || field.isInoutPort()) && field.getAssociatedTypeName().equals("any_method_port")) {
                return this.getName().equals(field.getName());
            }
            event = null;
            parentType = this.getParentStruct();
            if (parentType instanceof RfTemplateStructInstance) {
                parentType = ((RfTemplateStructInstance)parentType).getTemplateStruct();
            }
            if (obj instanceof RfEvent && (event = (RfEvent)obj).getParentStruct() == parentType) {
                return this.getName().equals("on_" + event.getName());
            }
            if (obj instanceof RfField && parentType instanceof RfListType && ((RfField)obj).getName().equals(this.getName())) {
                objParentStruct = ((RfField)obj).getParentStruct();
                if (objParentStruct instanceof RfTemplateStructInstance) {
                    objParentStruct = ((RfTemplateStructInstance)objParentStruct).getTemplateStruct();
                }
                if (parentType instanceof RfListType) {
                    parentType = ((RfListType)parentType).getAssociatedBaseType();
                }
                if (parentType instanceof RfStruct) {
                    do {
                        if (parentType != objParentStruct) continue;
                        return true;
                    } while ((parentType = parentType.getParentStruct()) != null);
                }
            }
            if (!(obj instanceof RfMethod) || !((RfMethod)obj).getName().equals(this.getName())) break block18;
            objParentStruct = ((RfMethod)obj).getParentStruct();
            if (objParentStruct instanceof RfTemplateStructInstance) {
                objParentStruct = ((RfTemplateStructInstance)objParentStruct).getTemplateStruct();
            }
            if (objParentStruct instanceof RfTemplateStruct && parentType instanceof RfTemplateStruct) {
                if (objParentStruct == parentType) {
                    return true;
                }
                if (SemanticUtils.isChildOf(objParentStruct, parentType) || SemanticUtils.isChildOf(parentType, objParentStruct)) {
                    return true;
                }
            }
            if (!(objParentStruct instanceof RfListType) || !(parentType instanceof RfListType)) break block18;
            if (obj instanceof RfPredefinedMethod && this instanceof RfPredefinedMethod) {
                return true;
            }
            if (objParentStruct != parentType) ** GOTO lbl36
            return true;
lbl-1000:
            // 1 sources

            {
                parentType = ((RfListType)parentType).getAssociatedType();
lbl36:
                // 2 sources

                ** while (parentType instanceof RfListType)
            }
lbl37:
            // 2 sources

            while (objParentStruct instanceof RfListType) {
                objParentStruct = (RfStruct)((RfListType)objParentStruct).getAssociatedType();
            }
            while (parentType instanceof RfStruct && ((RfStruct)parentType).getParentStruct() != null && ((RfStruct)parentType).getLocalMember(this.getFullName(), 2) == null) {
                parentType = ((RfStruct)parentType).getParentStruct();
            }
            while (objParentStruct.getParentStruct() != null && objParentStruct.getLocalMember(this.getFullName(), 2) == null) {
                objParentStruct = objParentStruct.getParentStruct();
            }
            if (objParentStruct == parentType) {
                return true;
            }
        }
        return super.checkEquals(obj);
    }

    @Override
    public boolean isPredefined() {
        RfStruct parentStruct = this.getMethodInLikeParent(false);
        if (parentStruct == this.getParentStruct() && !(this instanceof RfPredefinedMethod)) {
            return false;
        }
        if (parentStruct != null) {
            return parentStruct.isPredefined();
        }
        return false;
    }

    @Override
    public boolean isLocalPredefined() {
        return this instanceof RfPredefinedMethod;
    }

    @Override
    public String javaTypeName() {
        if ("void".equals(this.fBaseName)) {
            return "void";
        }
        RfType assocType = this.getAssociatedBaseType();
        if (assocType == null) {
            return "void";
        }
        return super.javaTypeName();
    }

    public void asComputedTranslate(RfProject project) {
        RfMethod method;
        RfStruct parentStruct = this.getParentStruct();
        Set<String> disabledMethods = project.getAsComputedMethodsTranslateDisable(this.getPackageName(), parentStruct.getName());
        if (disabledMethods != null && disabledMethods.contains(this.getName())) {
            return;
        }
        this.fAsComputedTranslate = true;
        if (parentStruct instanceof RfTemplateStructInstance && (method = ((RfTemplateStructInstance)parentStruct).getTemplateStruct().getMethod(this.getFullName())) != null) {
            method.asComputedTranslate(project);
        }
    }

    public boolean isAsComputedTranslate() {
        RfStruct parentStruct = this.getParentStruct();
        if (parentStruct != null && "ntv".equals(parentStruct.getName()) && "get_context_name".equals(this.getName()) && "get_context_type".equals(this.getName())) {
            return false;
        }
        if (this.fAsComputedTranslate) {
            return true;
        }
        if (parentStruct == null) {
            return false;
        }
        do {
            RfMethod parentMethod;
            if ((parentMethod = parentStruct.getMethod(this.getName())) == null || !parentMethod.fAsComputedTranslate) continue;
            return true;
        } while ((parentStruct = parentStruct.getParentStruct()) != null);
        return false;
    }

    public Object invoke_unsafe(IRfType __etools_me, EList __etools_2list) {
        return null;
    }

    public RfMethodLayer getLayer(Determinant determinant, ParserPath parserPath, int line) {
        List<RfDefElement> layers = this.internalGetLayers();
        if (layers == null) {
            return null;
        }
        for (RfDefElement layer : layers) {
            Determinant layerDeterminant = ((RfMethodLayer)layer).getDeterminant();
            if (layerDeterminant == null || !layerDeterminant.equals(determinant) || line != layer.getStartLine() || !layer.getParserPath().equals((Object)parserPath)) continue;
            return (RfMethodLayer)layer;
        }
        return null;
    }

    public RfMethodLayer getFirstLayerOfDeterminant(Determinant determinant) {
        List<RfDefElement> layers = this.internalGetLayers();
        if (layers == null) {
            return null;
        }
        for (RfDefElement layer : layers) {
            Determinant layerDeterminant = ((RfMethodLayer)layer).getDeterminant();
            if (layerDeterminant == null || !layerDeterminant.equals(determinant)) continue;
            return (RfMethodLayer)layer;
        }
        return null;
    }
}

