/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.edt.base.model.EModuleInfo;
import ro.amiq.edt.base.model.IEProject;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.IRfLayersParent;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.IRfStructMemberLayer;
import ro.amiq.edt.base.model.reflection.RfActionBlockLayer;
import ro.amiq.edt.base.model.reflection.RfArg;
import ro.amiq.edt.base.model.reflection.RfArgLayer;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.WrapperType;
import ro.amiq.edt.base.model.reflection.ascomputed.AsComputedWalker;
import ro.amiq.edt.base.model.reflection.util.NullProtectedList;
import ro.amiq.etools.eparser.EAST;
import ro.amiq.etools.eparser.ReparseElement;

public class RfMethodLayer
extends RfActionBlockLayer
implements IRfStructMemberLayer {
    private String fJavaLayerCode;
    private String fJavaExtendedLayerCode;
    private Set<RfType> fJavaLayerRefs;
    private boolean fIsCVL;
    private boolean fIsFinal;
    private AST fMethodLayerAST;
    private String fTCMEvent;

    public RfMethodLayer(RfModule module, RfDefElement enclosingScope, boolean isCVL, boolean isFinal, String tcmEvent, int kind, LineInfo startLine, LineInfo endLine, CommentBlock comment, ReparseElement[] reparseStack) {
        super(module, enclosingScope, kind, startLine, endLine, RfActionBlockLayer.ActionKind.OTHER, comment, reparseStack);
        this.fIsCVL = isCVL;
        this.fIsFinal = isFinal;
        this.fTCMEvent = tcmEvent;
    }

    @Override
    public void deepClean() {
        this.fJavaLayerRefs = null;
        super.deepClean();
    }

    @Override
    public RfStructLayer getStructLayer() {
        return (RfStructLayer)this.getEnclosingScope();
    }

    @Override
    public String getDefStructLayerName() {
        return this.getStructLayer() == null ? "" : this.getStructLayer().getInfo();
    }

    @Override
    public Determinant getDefStructDeterminant() {
        return this.getStructLayer() == null ? new Determinant(new String[]{""}) : this.getStructLayer().getDeterminant();
    }

    public RfArgLayer startArgLayer(RfProject project, String name, WrapperType type) {
        RfArgLayer argLayer = new RfArgLayer(project, (IRfLayersParent)this, name, type, this.getLayerModule(), this.getMethod(), this.getMethod().getParentStruct());
        this.fDefElements = OptimizedUtils.listContainerAdd((ListContainer)this.fDefElements, (Object)argLayer);
        return argLayer;
    }

    @Override
    public boolean isIs() {
        return this.getLayerKind() == 378;
    }

    public boolean checkArgDefaults() {
        boolean hasDefault = false;
        for (RfDefElement element : this.fDefElements) {
            if (!(element instanceof RfArgLayer)) continue;
            RfArgLayer argLayer = (RfArgLayer)element;
            if (!argLayer.hasDefault() && hasDefault) {
                return false;
            }
            if (!argLayer.hasDefault()) continue;
            hasDefault = true;
        }
        return true;
    }

    public List<RfArgLayer> getArgs() {
        ArrayList<RfArgLayer> args = new ArrayList<RfArgLayer>();
        for (RfDefElement element : this.fDefElements) {
            if (!(element instanceof RfArgLayer)) continue;
            args.add((RfArgLayer)element);
        }
        return args;
    }

    public String checkArgListVsOriginal(List<RfArgLayer> firstLayerArgs) {
        List<RfArgLayer> currArgs = this.getArgs();
        if (currArgs.size() != firstLayerArgs.size()) {
            return "ARGUMENT_COUNT: Argument number differs from previous declaration\n    at line {0,number,#######} in {1}";
        }
        boolean prevHasDefaults = false;
        Iterator<RfArgLayer> currIt = currArgs.iterator();
        Iterator<RfArgLayer> origIt = firstLayerArgs.iterator();
        while (currIt.hasNext() && origIt.hasNext()) {
            RfArgLayer currArg = currIt.next();
            RfArgLayer origArg = origIt.next();
            if (currArg.hasDefault()) {
                prevHasDefaults = true;
                if (origArg.hasDefault()) {
                    if (currArg.getDefaultValue().equals(origArg.getDefaultValue())) continue;
                    return "ARGUMENT_DEFAULT: Argument default value differs from previous declaration\n    at line {0,number,#######} in {1}";
                }
                return "ARGUMENT_DEFAULT: Argument default value differs from previous declaration\n    at line {0,number,#######} in {1}";
            }
            if (!prevHasDefaults) continue;
            return "ARGUMENT_DEFAULT: Arguments following an argument with default value must also have default values";
        }
        return null;
    }

    public RfMethod getMethod() {
        return (RfMethod)this.getNamedElement();
    }

    @Override
    public String getInfo() {
        RfMethod method = this.getMethod();
        if (method != null) {
            if (method.isTCM()) {
                return String.valueOf(method.getName()) + "()@ " + this.getKindAsString();
            }
            return String.valueOf(method.getName()) + "() " + this.getKindAsString();
        }
        return "";
    }

    protected void toString(StringBuilder sb) {
        sb.append("Method Layer: ").append(this.getLayerModule().getName()).append("Line:").append(this.getStartLine());
    }

    @Override
    public List<RfArg> getArgumentsWithPrefix(int matchType, String prefix) {
        NullProtectedList<RfArg> result = null;
        for (RfDefElement element : this.fDefElements) {
            RfArg argument;
            if (!(element instanceof RfArgLayer) || !DVTStringUtil.regionMatches((String)(argument = ((RfArgLayer)element).getArgument()).getName(), (String)prefix, (int)matchType)) continue;
            if (result == null) {
                result = new NullProtectedList<RfArg>();
            }
            result.add(argument);
            if ((matchType & 1) == 0) continue;
            return result;
        }
        return result;
    }

    @Override
    public RfArg getArgumentWithPrefix(int matchType, String prefix) {
        for (RfDefElement element : this.fDefElements) {
            RfArg argument;
            if (!(element instanceof RfArgLayer) || !DVTStringUtil.regionMatches((String)(argument = ((RfArgLayer)element).getArgument()).getName(), (String)prefix, (int)matchType)) continue;
            return argument;
        }
        return null;
    }

    @Override
    public RfNamedElement semanticGetMember(RfProject project, String packageName, String name, EnumSet<IRfNamedElement.ElementKind> allowedElements, LineInfo lineInfo, int maxModuleIndex, ParserPath parserPath, RfNamedElement exclude) {
        IRfScope enclosingScope;
        RfVar result = null;
        if (allowedElements.contains(IRfNamedElement.ElementKind.E_VARIABLE)) {
            RfMethod method;
            for (RfDefElement element : this.fDefElements) {
                if (!(element instanceof RfArgLayer)) continue;
                RfArg argument = ((RfArgLayer)element).getArgument();
                if (argument == exclude) break;
                if (!name.equals(argument.getName())) continue;
                return argument;
            }
            if ((method = this.getMethod()) != null && (result = method.getVariableWithPrefix(0, 1, name)) != null) {
                return result;
            }
        }
        if ((enclosingScope = this.getEnclosingScope()) instanceof RfStructLayer) {
            return ((RfStructLayer)enclosingScope).semanticGetMember(project, packageName, name, allowedElements, lineInfo, maxModuleIndex, parserPath, exclude);
        }
        return null;
    }

    @Override
    public List<RfVar> getVariablesWithPrefix(int line, int matchType, String prefix) {
        RfMethod method = this.getMethod();
        if (method == null) {
            return null;
        }
        return method.getVariablesWithPrefix(line, matchType, prefix);
    }

    @Override
    public RfVar getVariableWithPrefix(int line, int matchType, String prefix) {
        RfMethod method = this.getMethod();
        if (method == null) {
            return null;
        }
        return method.getVariableWithPrefix(line, matchType, prefix);
    }

    @Override
    public RfVar getLocalVariable(String name, LineInfo lineInfo, RfNamedElement exclude) {
        RfMethod method = this.getMethod();
        if (method == null) {
            return null;
        }
        return method.getLocalVariable(name);
    }

    public boolean isCVL() {
        return this.fIsCVL;
    }

    public boolean isFinal() {
        return this.fIsFinal;
    }

    public void setMethodLayerAST(AST ast) {
        this.fMethodLayerAST = ast;
    }

    public boolean javaTranslateMethodLayer(RfProject rfProject, IEProject eProject) {
        EModuleInfo info;
        RfModule module;
        block7: {
            block6: {
                if (this.fJavaLayerCode != null) {
                    return false;
                }
                this.fJavaLayerCode = "";
                if (this.fMethodLayerAST == null) {
                    return false;
                }
                try {
                    module = this.getLayerModule();
                    if (module != null) break block6;
                    return false;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return false;
                }
            }
            info = rfProject.getModuleInfo(module.getModuleReference());
            if (info != null) break block7;
            return false;
        }
        AsComputedWalker walker = new AsComputedWalker(rfProject, info, module, eProject, false);
        walker.getASTFactory().setASTNodeClass(EAST.class);
        walker.method_struct_member_translate(this.fMethodLayerAST);
        return walker.hasNewElementsToTranslate();
    }

    public void setJavaCode(String javaCode, String javaExtendedCode, Set<RfType> referencedTypes) {
        this.fJavaLayerCode = javaCode;
        this.fJavaExtendedLayerCode = javaExtendedCode;
        this.fJavaLayerRefs = referencedTypes;
    }

    public String getJavaCode() {
        if (this.fJavaLayerCode == null) {
            return "";
        }
        return this.fJavaLayerCode;
    }

    public void collectJavaReferences(Set<RfType> result) {
        if (result != null && this.fJavaLayerRefs != null) {
            result.addAll(this.fJavaLayerRefs);
        }
    }

    public String getJavaExtendedCode() {
        if (this.fJavaExtendedLayerCode == null) {
            return "";
        }
        return this.fJavaExtendedLayerCode;
    }

    @Override
    public int compareTo(RfDefElement candidate) {
        boolean cvl2;
        boolean cvl1 = this.isCVL();
        boolean bl = cvl2 = candidate instanceof RfMethodLayer ? ((RfMethodLayer)candidate).isCVL() : false;
        if (cvl1 && !cvl2) {
            return 1;
        }
        if (!cvl1 && cvl2) {
            return -1;
        }
        return super.compareTo(candidate);
    }

    public String getTCMEvent() {
        return this.fTCMEvent;
    }
}

