/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.util.List;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.RfArg;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfExpect;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfMeImplicitVariable;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfVar;

public class RfMethodType
extends RfStruct {
    public RfMethodType(RfProject project, String structName) {
        super(project, structName, true);
    }

    @Override
    public String getSignature() {
        return "method_type " + this.getName();
    }

    @Override
    public String getContextType() {
        return "ro.amiq.edt.templates.contextType.statement";
    }

    public RfMethod getAssociatedMethod() {
        RfMethod method = (RfMethod)this.getLocalMember(new FullName(this.getName(), new Determinant(this.getName())), 1);
        return method;
    }

    @Override
    public Determinant getDeterminant() {
        return null;
    }

    @Override
    public void setTransientDeterminant(Determinant determinant) {
    }

    @Override
    public Determinant getTransientDeterminant() {
        return this.getDeterminant();
    }

    @Override
    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currLayer, LineInfo lineInfo, ParserPath parserPath) {
        boolean isCurrDeclarationLayer = this.isDeclarationLayer(currLayer);
        List<RfDefElement> layers = this.getLayers();
        if (layers == null || layers.isEmpty()) {
            return;
        }
        for (RfDefElement layer : layers) {
            if (layer == currLayer) {
                return;
            }
            if (!project.importedBySameTest(layer, currLayer)) continue;
            boolean isDeclarationLayer = this.isDeclarationLayer(layer);
            if (!isCurrDeclarationLayer || !isDeclarationLayer) continue;
            project.addSemanticError1(1, "DUPLICATE_NAME: Name ''{0}'' in package ''{1}'' was previously defined\n    at line {2,number,#######} in {3}", lineInfo.realOffset, lineInfo.realOffset + this.getName().length(), null, lineInfo.line, parserPath, this.getName(), this.getPackageName(), layer.getStartLine(), layer.getParserPath());
            return;
        }
    }

    @Override
    protected boolean isDeclarationLayer(RfDefElement layer) {
        return true;
    }

    @Override
    public List<RfEnum> getEnumsWithPrefix(int matchType, String prefix) {
        return null;
    }

    @Override
    public RfEnum getEnumWithPrefix(int matchType, String prefix) {
        return null;
    }

    @Override
    public List<RfArg> getArgumentsWithPrefix(int matchType, String prefix) {
        return null;
    }

    @Override
    public RfArg getArgumentWithPrefix(int matchType, String prefix) {
        return null;
    }

    @Override
    public List<RfField> getFieldsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int hidingLevel) {
        return null;
    }

    @Override
    public RfField getFieldWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int hidingLevel) {
        return null;
    }

    @Override
    public List<RfMethod> getMethodsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int hidingLevel) {
        return null;
    }

    @Override
    public RfMethod getMethodWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int hidingLevel) {
        return null;
    }

    @Override
    public List<RfEvent> getEventsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int hidingLevel) {
        return null;
    }

    @Override
    public RfEvent getEventWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        return null;
    }

    @Override
    public List<RfExpect> getExpectsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        return null;
    }

    @Override
    public RfExpect getExpectWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        return null;
    }

    @Override
    public List<RfVar> getVariablesWithPrefix(int line, int matchType, String prefix) {
        return null;
    }

    @Override
    public RfVar getVariableWithPrefix(int line, int matchType, String prefix) {
        return null;
    }

    @Override
    public RfMeImplicitVariable getMeImplicitVariable(int matchType, String prefix) {
        return null;
    }

    @Override
    public boolean isInGlobal() {
        return false;
    }
}

