/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import antlr.collections.AST;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.custompragma.CustomPragmaUsage;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTEditorCommon;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.ASTUtils;
import ro.amiq.edt.base.model.EModuleInfo;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.IRfAssociatedType;
import ro.amiq.edt.base.model.reflection.IRfLayersParent;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.ImportFilePath;
import ro.amiq.edt.base.model.reflection.Range;
import ro.amiq.edt.base.model.reflection.RfActionBlockLayer;
import ro.amiq.edt.base.model.reflection.RfAnnotationType;
import ro.amiq.edt.base.model.reflection.RfArg;
import ro.amiq.edt.base.model.reflection.RfAssert;
import ro.amiq.edt.base.model.reflection.RfBindMethodCall;
import ro.amiq.edt.base.model.reflection.RfBindMethodCallLayer;
import ro.amiq.edt.base.model.reflection.RfCheckThat;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfExpect;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfFieldAlias;
import ro.amiq.edt.base.model.reflection.RfMacroLayer;
import ro.amiq.edt.base.model.reflection.RfMeImplicitVariable;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfMethodType;
import ro.amiq.edt.base.model.reflection.RfMethodTypeLayer;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfOVMMessage;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfScalarTypeLayer;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfTemplateStruct;
import ro.amiq.edt.base.model.reflection.RfTemplateStructInstance;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.WrapperMethod;
import ro.amiq.edt.base.model.reflection.WrapperParam;
import ro.amiq.edt.base.model.reflection.ascomputed.base.IRfType;
import ro.amiq.edt.base.model.reflection.ascomputed.base.__etools_string;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedField;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedMethod;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedModule;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedScalar;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedStruct;
import ro.amiq.edt.base.model.reflection.semantic.IllegalAccessError;
import ro.amiq.edt.base.model.reflection.semantic.SemanticUtils;
import ro.amiq.etools.eparser.EAST;
import ro.amiq.etools.eparser.ReparseElement;

public class RfModule
extends RfNamedElement
implements IRfType,
IRfScope,
IRfFileDef,
IRfLayersParent {
    private static final long SERIAL_VERSION_UID = 336L;
    private static final Set<Integer> ID_TOKEN_TYPES = new HashSet<Integer>(Arrays.asList(293, 231, 232, 233, 263, 264, 265, 230, 234, 235, 131, 132, 133, 134, 135, 266, 236));
    private int fModuleIndex;
    private int fMaxModuleIndex;
    private int fClusterIndex;
    private int fInvocationIndex;
    private ParserPath fParserPath;
    private String fPackageName;
    protected boolean fIsInTop;
    protected boolean fIsInActiveTest;
    protected boolean fSNEncrypted;
    protected boolean fDVTEncrypted;
    protected ParserPath fImportedByTest;
    private List<RfCheckThat> fOVMCheckThatActions;
    private List<RfAssert> fAssertActions;
    private List<RfOVMMessage> fOVMMessageActions;
    private boolean fExplicitPackage;
    private List<ImportFilePath> fImportFilePaths;
    private IFile fResource;
    private List<RfDefElement> fChildrenDefs = new ArrayList<RfDefElement>();
    private final RfProject.ModuleReference fModuleReference;
    private IEPluginConfig fPluginConfig;
    private boolean fIsSLN;
    private List<CustomPragmaUsage> fCustomPragmas;
    public __etools_string __etools_name;

    public RfModule(String name, int clusterIndex, int moduleIndex, int maxModuleIndex, int invocationIndex, ParserPath parserPath, boolean isInTop, ParserPath importedByTest, RfProject project, boolean isSNencrypted, boolean isDVTencrypted, IEPluginConfig pluginConfig) {
        super(project, name);
        this.fClusterIndex = clusterIndex;
        this.fModuleIndex = moduleIndex;
        this.fMaxModuleIndex = maxModuleIndex;
        this.fInvocationIndex = invocationIndex;
        this.fParserPath = parserPath;
        this.fIsInTop = isInTop;
        this.fIsInActiveTest = false;
        this.fImportedByTest = importedByTest;
        this.fSNEncrypted = isSNencrypted;
        this.fDVTEncrypted = isDVTencrypted;
        this.fPackageName = "main";
        this.fOVMCheckThatActions = new ArrayList<RfCheckThat>();
        this.fAssertActions = new ArrayList<RfAssert>();
        this.fOVMMessageActions = new ArrayList<RfOVMMessage>();
        this.fModuleReference = new RfProject.ModuleReference(this.fParserPath, moduleIndex);
        this.__etools_name = this.get_name();
        this.fPluginConfig = pluginConfig;
        this.fIsSLN = project != null ? project.isSLNModule(parserPath) : (parserPath.path != null ? parserPath.path.endsWith(".sln") : false);
    }

    public boolean isSLN() {
        return this.fIsSLN;
    }

    public boolean isSDL() {
        return false;
    }

    public boolean isDefinedInTest() {
        return this.fImportedByTest != null;
    }

    public ParserPath getImportedByTest() {
        return this.fImportedByTest;
    }

    public RfProject.ModuleReference getModuleReference() {
        return this.fModuleReference;
    }

    public void createVariableDependency(RfProject project, RfNamedElement element, String elementName) {
        if (element == null) {
            if (elementName != null) {
                project.addUndeclaredVarNameReference(this.fModuleReference, elementName);
            }
            return;
        }
        if (element instanceof IllegalAccessError) {
            element = ((IllegalAccessError)element).getElement();
        }
        if (element instanceof RfFieldAlias) {
            element = ((RfFieldAlias)element).getField();
        }
        if (element.hasNoDefs(false)) {
            return;
        }
        RfDefElement declaration = element.getDeclaration();
        if (declaration == null || declaration.getLayerModule() == null) {
            return;
        }
        RfModule module = declaration.getLayerModule();
        if (module == this) {
            return;
        }
        if (this.fMaxModuleIndex >= module.fMaxModuleIndex) {
            module.addDependentModuleReference(project, this.fModuleReference);
            if (element instanceof IRfAssociatedType) {
                this.createTypeDependency(project, (RfNamedElement)((IRfAssociatedType)((Object)element)).getAssociatedBaseType(), null);
            }
        }
    }

    public void createTypeDependency(RfProject project, RfNamedElement element, String elementName) {
        if (element == null) {
            if (elementName != null) {
                project.addUndeclaredTypeNameReference(this.fModuleReference, elementName);
            }
            return;
        }
        if (element instanceof IllegalAccessError) {
            element = ((IllegalAccessError)element).getElement();
        }
        if (element.hasNoDefs(false)) {
            return;
        }
        Collection declarations = element.getDeclarations();
        if (declarations == null || declarations.isEmpty()) {
            return;
        }
        for (RfDefElement declaration : declarations) {
            RfModule module = declaration.getLayerModule();
            if (module == null || module == this || this.fMaxModuleIndex < module.fMaxModuleIndex) continue;
            module.addDependentModuleReference(project, this.fModuleReference);
        }
    }

    private void addDependentModuleReference(RfProject project, RfProject.ModuleReference reference) {
        project.addDependentModuleReference(this.fModuleReference, reference);
    }

    @Deprecated
    public void addIdentifier(AST id) {
    }

    public List<IdentifierPosition> getIdentifiers(final String name) {
        final ArrayList<IdentifierPosition> result = new ArrayList<IdentifierPosition>();
        EModuleInfo info = this.getRfProject().getModuleInfo(this.getModuleReference());
        AST ast = info.getModuleAST();
        ASTUtils.scanAST(new ASTUtils.ASTRunnable(){

            @Override
            public void run(AST node) throws Exception {
                if (ID_TOKEN_TYPES.contains(node.getType()) && name.equals(node.getText())) {
                    result.add(new IdentifierPosition((EAST)node));
                }
            }
        }, ast);
        return result;
    }

    public List<IdentifierPosition> getAllIdentifiers() {
        final ArrayList<IdentifierPosition> result = new ArrayList<IdentifierPosition>();
        EModuleInfo info = this.getRfProject().getModuleInfo(this.getModuleReference());
        AST ast = info.getModuleAST();
        ASTUtils.scanAST(new ASTUtils.ASTRunnable(){

            @Override
            public void run(AST node) throws Exception {
                if (ID_TOKEN_TYPES.contains(node.getType())) {
                    result.add(new IdentifierPosition((EAST)node));
                }
            }
        }, ast);
        return result;
    }

    public IdentifierPosition getIdentifier(final String name, final int offset) {
        final IdentifierPosition[] result = new IdentifierPosition[1];
        EModuleInfo info = this.getRfProject().getModuleInfo(this.getModuleReference());
        AST ast = info.getModuleAST();
        ASTUtils.scanAST(new ASTUtils.ASTRunnable(){

            @Override
            public void run(AST node) throws Exception {
                if (ID_TOKEN_TYPES.contains(node.getType()) && node.getOffset() <= offset && node.getOffset() + node.getText().length() >= offset && name.equals(node.getText())) {
                    result[0] = new IdentifierPosition((EAST)node);
                    throw new ASTUtils.StopScanning();
                }
            }
        }, ast);
        return result[0];
    }

    @Override
    public RfDefElement getDeclaration() {
        return null;
    }

    @Override
    public List<RfDefElement> getDeclarations() {
        return null;
    }

    @Override
    public RfDefElement getFirstLayer() {
        return null;
    }

    @Override
    public void addChild(RfDefElement child) {
        this.fChildrenDefs.add(child);
    }

    public List<RfDefElement> getChildren() {
        return this.fChildrenDefs;
    }

    public boolean isInTop() {
        return this.fIsInTop;
    }

    @Override
    public boolean hasNoLayers() {
        return true;
    }

    @Override
    public List<RfDefElement> getLayers() {
        DVTLogger.INSTANCE.logError((Throwable)new RuntimeException("RfModule: Internal error 1"));
        return Collections.emptyList();
    }

    @Override
    protected List<RfDefElement> internalGetLayers() {
        DVTLogger.INSTANCE.logError((Throwable)new RuntimeException("RfModule: Internal error 2"));
        return Collections.emptyList();
    }

    public void cleanUpModule(RfProject rfProject) {
        for (RfDefElement layer : this.fChildrenDefs) {
            if (layer.getChildren() == this.fChildrenDefs) continue;
            RfNamedElement namedElement = layer.getNamedElement();
            if (namedElement != null) {
                namedElement.removeLayer(layer);
            }
            layer.cleanChildrenLayers();
        }
        this.fChildrenDefs.clear();
    }

    @Override
    public Object getInternalAdapter(Class adapter) {
        if (this.fResource != null) {
            return this.fResource;
        }
        if (adapter == IResource.class) {
            this.fResource = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(this.getRfProject().getProject(), this.fParserPath.path);
        }
        return this.fResource;
    }

    public String getSignature() {
        return String.valueOf(this.fModuleIndex) + "." + this.getName();
    }

    public ParserPath getParserPath() {
        return this.fParserPath;
    }

    public IDocument getDocument() {
        if (this.getRfProject() == null) {
            return null;
        }
        DVTEditor editor = this.getRfProject().getEditor(this.fParserPath);
        if (editor == null) {
            return null;
        }
        return editor.getDocument();
    }

    @Override
    public IRfScope getEnclosingScope() {
        return this.getRfProject();
    }

    public void connectPositionToDocument(String editorID, Map<Annotation, Position> aditions, boolean connectPositionsAfterEditorFocus, List<Position> reflectionPositions) {
        try {
            IDocument document = this.getDocument();
            if (document == null) {
                return;
            }
            if (!document.containsPositionCategory("REFLECTION")) {
                return;
            }
            if (!connectPositionsAfterEditorFocus) {
                document.removePositionCategory("REFLECTION");
                document.addPositionCategory("REFLECTION");
            }
            RfModule.connectRecursive(editorID, this.fChildrenDefs, document, aditions, connectPositionsAfterEditorFocus, reflectionPositions);
            EModuleInfo info = this.getRfProject().getModuleInfo(this.getModuleReference());
            AST ast = info.getModuleAST();
            if (!connectPositionsAfterEditorFocus) {
                RfModule.connectIdentifiers(ast, document, reflectionPositions);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private static void connectRecursive(String editorID, List<RfDefElement> children, IDocument document, Map<Annotation, Position> aditions, boolean connectPositionsAfterEditorFocus, List<Position> reflectionPositions) {
        try {
            RfDefElement[] childrenCopy;
            if (children == null) {
                return;
            }
            RfDefElement[] rfDefElementArray = childrenCopy = children.toArray(new RfDefElement[children.size()]);
            int n = childrenCopy.length;
            int n2 = 0;
            while (n2 < n) {
                RfDefElement child = rfDefElementArray[n2];
                if (!(child instanceof RfMacroLayer)) {
                    if (!connectPositionsAfterEditorFocus) {
                        child.connectPositionToDocument(document, reflectionPositions);
                    }
                    if (child.getDefFile() != null && child.getParserPath() != null && child instanceof RfMethodLayer) {
                        RfMethod method = ((RfMethodLayer)child).getMethod();
                        RfStructLayer currLayer = child.getStructLayer();
                        Determinant determinant = currLayer.getDeterminant();
                        if (method != null) {
                            String message = "";
                            int kind = 0;
                            RfStruct currStruct = currLayer.getStruct();
                            if (method instanceof RfPredefinedMethod) {
                                message = method.getParentStruct() == currStruct ? "extends " + Utils.computeMethodOverrideIndicationMessageWithHyperlink((String)(String.valueOf(determinant.toString()) + "." + method.getName()), (IRfDefElement)child) : "overrides " + Utils.computeMethodOverrideIndicationMessageWithHyperlink((String)(String.valueOf(determinant.toString()) + "." + method.getName()), (IRfDefElement)child);
                                aditions.put((Annotation)new DVTEditorCommon.OverrideIndicator(1, message, null, 0, editorID), (Position)new DVTPosition(child.getStartOffset(), 0));
                            } else {
                                List<RfDefElement> layers = method.getLayers();
                                RfDefElement lastLayer = null;
                                for (RfDefElement layer : layers) {
                                    if (layer == child) break;
                                    RfStructLayer prevLayer = layer.getStructLayer();
                                    Determinant prevDeterminant = prevLayer.getDeterminant();
                                    if (!determinant.contains(prevDeterminant, true)) continue;
                                    lastLayer = layer;
                                    kind = 3;
                                    message = "extends " + Utils.computeMethodOverrideIndicationMessageWithHyperlink((String)(String.valueOf(prevDeterminant.toString()) + "." + method.getName()), (IRfDefElement)layer);
                                }
                                if (lastLayer == null && (lastLayer = method.getLastLayerOfMethodInLikeParent()) != null) {
                                    kind = 0;
                                    message = "overrides " + Utils.computeMethodOverrideIndicationMessageWithHyperlink((String)(String.valueOf(((RfMethod)lastLayer.getNamedElement()).getParentStruct().getName()) + "." + method.getName()), (IRfDefElement)lastLayer);
                                }
                                if (lastLayer != null && lastLayer.getDefFile() != null && lastLayer.getParserPath() != null) {
                                    aditions.put((Annotation)new DVTEditorCommon.OverrideIndicator(kind, message, lastLayer.getDefFile(), lastLayer.getStartLine(), editorID), (Position)new DVTPosition(child.getStartOffset(), 0));
                                }
                            }
                        }
                    }
                    if (child.getChildren() != children) {
                        RfModule.connectRecursive(editorID, (List<RfDefElement>)child.getChildren(), document, aditions, connectPositionsAfterEditorFocus, reflectionPositions);
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private static void connectIdentifiers(AST ast, IDocument document, final List<Position> reflectionPositions) {
        try {
            if (ast == null) {
                return;
            }
            final int documentLength = document.getLength();
            ASTUtils.scanAST(new ASTUtils.ASTRunnable(){

                @Override
                public void run(AST node) throws Exception {
                    if (ID_TOKEN_TYPES.contains(node.getType()) && node.getOffset() > 0 && node.getText() != null && node.getOffset() + node.getText().length() < documentLength) {
                        reflectionPositions.add(new IdentifierPosition((EAST)node));
                    }
                }
            }, ast);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void disconnectPositionFromDocument() {
        try {
            IDocument document = this.getDocument();
            if (document == null) {
                return;
            }
            if (!document.containsPositionCategory("REFLECTION")) {
                return;
            }
            boolean isCloned = DVTUtilsCommon.INSTANCE.isOpenClonedEditorSharingSameDocument(document);
            if (isCloned) {
                return;
            }
            document.removePositionCategory("REFLECTION");
            document.addPositionCategory("REFLECTION");
            this.disconnectRecursive(this.fChildrenDefs);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void disconnectRecursive(List<RfDefElement> children) {
        if (children == null) {
            return;
        }
        for (RfDefElement child : children) {
            child.removePosition();
            if (child.getChildren() == children) continue;
            this.disconnectRecursive((List<RfDefElement>)child.getChildren());
        }
    }

    public int convertPositionToLine(int offset) {
        try {
            IDocument document = this.getDocument();
            if (document != null && document.getLength() > offset) {
                return document.getLineOfOffset(offset) + 1;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return -1;
    }

    public int convertPositionToColumn(int offset) {
        try {
            IDocument document = this.getDocument();
            if (document != null && document.getLength() > offset) {
                return offset - document.getLineInformationOfOffset(offset).getOffset();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return -1;
    }

    public IRfScope getScope(int line, int offset) {
        RfDefElement result = null;
        if ((result = this.getScopeRecursive(line, offset, result, this.getChildren(), false)) == null || !(result instanceof IRfScope)) {
            return this;
        }
        return (IRfScope)((Object)result);
    }

    public IRfScope getMethodOrCoverOrStructScope(int line, int offset) {
        RfDefElement result = null;
        if ((result = this.getScopeRecursive(line, offset, result, this.getChildren(), true)) == null || !(result instanceof IRfScope)) {
            return this;
        }
        return (IRfScope)((Object)result);
    }

    /*
     * Exception decompiling
     */
    private RfDefElement getScopeRecursive(int line, int offset, RfDefElement result, Collection<RfDefElement> childrenList, boolean onlyMethodOrCoverOrStruct) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:760)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<RfMacroLayer> getMacrosLayers(int line) {
        ArrayList<RfMacroLayer> result = new ArrayList<RfMacroLayer>();
        for (RfDefElement layer : this.fChildrenDefs) {
            RfMacroLayer macroLayer;
            if (!(layer instanceof RfMacroLayer) || !(macroLayer = (RfMacroLayer)layer).isNotReparsed() || line < layer.getStartLine() || line > layer.getEndLine()) continue;
            result.add((RfMacroLayer)layer);
        }
        return result;
    }

    @Override
    public Determinant getDeterminant() {
        return null;
    }

    @Override
    public void setTransientDeterminant(Determinant determinant) {
    }

    @Override
    public Determinant getTransientDeterminant() {
        return this.getDeterminant();
    }

    @Override
    public String getContextType() {
        return "ro.amiq.edt.templates.contextType.statement";
    }

    @Override
    public RfMeImplicitVariable getMeImplicitVariable(int matchType, String prefix) {
        return null;
    }

    @Override
    public RfPredefinedField getCompImplicitVariable(RfProject project, int matchType, String prefix) {
        return null;
    }

    @Override
    public List<RfEnum> getEnumsWithPrefix(int matchType, String prefix) {
        return null;
    }

    @Override
    public RfEnum getEnumWithPrefix(int matchType, String prefix) {
        return null;
    }

    @Override
    public List<RfArg> getArgumentsWithPrefix(int matchType, String prefix) {
        return null;
    }

    @Override
    public RfArg getArgumentWithPrefix(int matchType, String prefix) {
        return null;
    }

    @Override
    public List<RfField> getFieldsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int hidingLevel) {
        return null;
    }

    @Override
    public RfField getFieldWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int hidingLevel) {
        return null;
    }

    @Override
    public List<RfMethod> getMethodsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int hidingLevel) {
        return null;
    }

    @Override
    public RfMethod getMethodWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int hidingLevel) {
        return null;
    }

    @Override
    public List<RfEvent> getEventsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int hidingLevel) {
        return null;
    }

    @Override
    public RfEvent getEventWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        return null;
    }

    @Override
    public List<RfExpect> getExpectsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        return null;
    }

    @Override
    public RfExpect getExpectWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        return null;
    }

    @Override
    public List<RfVar> getVariablesWithPrefix(int line, int matchType, String prefix) {
        return null;
    }

    @Override
    public RfVar getVariableWithPrefix(int line, int matchType, String prefix) {
        return null;
    }

    public void collectBindsForPort(RfNamedElement port, Set<RfNamedElement> collectedBinds) {
        this.collectBindsRecursive(port, collectedBinds, this.fChildrenDefs);
    }

    public void collectBindMethodsCalls(List<RfBindMethodCall> collectedCalls, RfStructLayer structScope) {
        this.collectBindsRecursive(collectedCalls, structScope, this.fChildrenDefs);
    }

    private void collectBindsRecursive(RfNamedElement port, Set<RfNamedElement> collectedBinds, List<RfDefElement> children) {
        RfDefElement[] layers;
        if (children == null) {
            return;
        }
        RfDefElement[] rfDefElementArray = layers = children.toArray(new RfDefElement[children.size()]);
        int n = layers.length;
        int n2 = 0;
        while (n2 < n) {
            RfDefElement child = rfDefElementArray[n2];
            if (child.getChildren() != children) {
                if (child instanceof RfBindMethodCallLayer) {
                    RfBindMethodCall bindMethodCall = ((RfBindMethodCallLayer)child).getMethodCall();
                    bindMethodCall.collectBindsForPort(port, collectedBinds);
                } else if (child instanceof RfStructLayer) {
                    this.collectBindsRecursive(port, collectedBinds, (List<RfDefElement>)child.getChildren());
                } else if (child instanceof RfActionBlockLayer) {
                    this.collectBindsRecursive(port, collectedBinds, (List<RfDefElement>)child.getChildren());
                }
            }
            ++n2;
        }
    }

    private void collectBindsRecursive(List<RfBindMethodCall> collectedCalls, RfStructLayer structScope, List<RfDefElement> children) {
        RfDefElement[] layers;
        if (children == null) {
            return;
        }
        RfDefElement[] rfDefElementArray = layers = children.toArray(new RfDefElement[children.size()]);
        int n = layers.length;
        int n2 = 0;
        while (n2 < n) {
            RfDefElement child = rfDefElementArray[n2];
            if (child.getChildren() != children) {
                if (child instanceof RfBindMethodCallLayer) {
                    RfBindMethodCall bindMethodCall = ((RfBindMethodCallLayer)child).getMethodCall();
                    if (bindMethodCall.isNonEmpty()) {
                        collectedCalls.add(bindMethodCall);
                    }
                } else if (child instanceof RfStructLayer && (structScope == null || child.equals(structScope))) {
                    this.collectBindsRecursive(collectedCalls, structScope, (List<RfDefElement>)child.getChildren());
                } else if (child instanceof RfActionBlockLayer) {
                    this.collectBindsRecursive(collectedCalls, structScope, (List<RfDefElement>)child.getChildren());
                }
            }
            ++n2;
        }
    }

    @Override
    public boolean isInGlobal() {
        return true;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof RfModule) {
            return ((RfModule)o).getName().equals(this.getName());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public RfModule getModule() {
        return this;
    }

    public void setPackageName(String packageName) {
        this.fPackageName = packageName;
    }

    @Override
    public String getPackageName() {
        if (this.fPackageName == null) {
            return "main";
        }
        return this.fPackageName;
    }

    protected RfProject.ElementContainer addAnnotationLayer(boolean incremental, RfProject project, String structName, CommentBlock comment, LineInfo startLine, LineInfo endLine, int accessModifier, ReparseElement[] reparseStack, RfStruct.KIND kind, boolean internalModule) {
        RfType struct = project.getType(this.fPackageName, false, 32, structName, this.fMaxModuleIndex);
        RfDefElement declaration = null;
        if (struct == null || !struct.isPredefined() && struct.hasNoLayers() && (struct instanceof RfTemplateStruct || !(struct instanceof RfStruct))) {
            struct = new RfAnnotationType(project, structName);
            project.getPackage(this.fPackageName).addType(struct, incremental);
            struct.setDefinitionData(this, this.fPackageName, false, false, accessModifier);
            project.addNewDefinedTypeName(struct);
        } else if (!(struct instanceof RfPredefinedStruct) && !(struct instanceof RfPredefinedScalar)) {
            declaration = struct.getDeclaration(false);
            if (declaration != null && !declaration.getPackageName().equals(this.fPackageName)) {
                struct = new RfAnnotationType(project, structName);
                project.getPackage(this.fPackageName).addType(struct, incremental);
                struct.setDefinitionData(this, this.fPackageName, false, false, accessModifier);
            } else {
                ((RfStruct)struct).setKind(kind);
                project.getPackage(this.fPackageName).addType(struct, incremental);
                struct.setDefinitionData(this, this.fPackageName, false, false, accessModifier);
            }
        }
        RfStructLayer layer = new RfStructLayer(structName, null, 0, startLine, endLine, comment, this, reparseStack);
        if (!internalModule) {
            struct.addLayer(layer);
            return new RfProject.ElementContainer(layer);
        }
        return new RfProject.ElementContainer(struct);
    }

    protected RfProject.ElementContainer addStructLikeLayer(boolean incremental, RfProject project, String structName, boolean isUnit, CommentBlock comment, LineInfo startLine, LineInfo endLine, int accessModifier, ReparseElement[] reparseStack, RfStruct.KIND kind, boolean internalModule) {
        RfType struct = project.getType(this.fPackageName, false, -1, structName, this.fMaxModuleIndex);
        RfDefElement declaration = null;
        if (struct == null || !struct.isPredefined() && struct.hasNoLayers() && (struct instanceof RfTemplateStruct || !(struct instanceof RfStruct))) {
            struct = this.createStruct(kind, internalModule, project, structName, this.fPackageName);
            project.getPackage(this.fPackageName).addType(struct, incremental);
            struct.setDefinitionData(this, this.fPackageName, isUnit, false, accessModifier);
            project.addNewDefinedTypeName(struct);
        } else if (!(struct instanceof RfPredefinedStruct) && !(struct instanceof RfPredefinedScalar)) {
            declaration = struct.getDeclaration(false);
            if (declaration != null && !declaration.getPackageName().equals(this.fPackageName)) {
                struct = this.createStruct(kind, internalModule, project, structName, this.fPackageName);
                project.getPackage(this.fPackageName).addType(struct, incremental);
                struct.setDefinitionData(this, this.fPackageName, isUnit, false, accessModifier);
            } else {
                ((RfStruct)struct).setKind(kind);
                project.getPackage(this.fPackageName).addType(struct, incremental);
                struct.setDefinitionData(this, this.fPackageName, isUnit, false, accessModifier);
            }
        }
        RfStructLayer layer = new RfStructLayer(structName, null, 0, startLine, endLine, comment, this, reparseStack);
        if (!internalModule) {
            struct.addLayer(layer);
            return new RfProject.ElementContainer(layer);
        }
        return new RfProject.ElementContainer(struct);
    }

    protected RfProject.ElementContainer addSLNTokenLikeLayer(boolean incremental, RfProject project, String structName, CommentBlock comment, LineInfo startLine, LineInfo endLine, int accessModifier, ReparseElement[] reparseStack, boolean internalModule) {
        RfType struct = project.getType(this.fPackageName, false, -1, structName, this.fMaxModuleIndex);
        if (struct == null) {
            struct = this.createStruct(RfStruct.KIND.SLN_TOKEN, internalModule, project, structName, this.fPackageName);
            project.getPackage(this.fPackageName).addType(struct, incremental);
            struct.setDefinitionData(this, this.fPackageName, false, false, accessModifier);
            project.addNewDefinedTypeName(struct);
        }
        RfStructLayer layer = new RfStructLayer(structName, null, 0, startLine, endLine, comment, this, reparseStack);
        if (!internalModule) {
            struct.addLayer(layer);
            return new RfProject.ElementContainer(layer);
        }
        return new RfProject.ElementContainer(struct);
    }

    protected RfProject.ElementContainer addSLNComponentLikeLayer(boolean incremental, RfProject project, String structName, String parentName, String parentPackageName, CommentBlock comment, LineInfo startLine, LineInfo endLine, int accessModifier, ReparseElement[] reparseStack, boolean internalModule) {
        RfStruct packg = project.getPackage(structName);
        if (packg == null) {
            packg = this.createStruct(RfStruct.KIND.SLN_COMPONENT, internalModule, project, structName, this.fPackageName);
            packg.setDefinitionData(this, this.fPackageName, true, false, accessModifier);
            project.addNewDefinedTypeName(packg);
            project.addPackage(packg);
        }
        RfStructLayer layer = new RfStructLayer(structName, null, 0, startLine, endLine, comment, this, reparseStack);
        if (!internalModule) {
            packg.addLayer(layer);
            return new RfProject.ElementContainer(layer);
        }
        return new RfProject.ElementContainer(packg);
    }

    protected RfProject.ElementContainer addSDLAgentLikeLayer(boolean incremental, RfProject project, String structName, String parentName, String parentPackageName, CommentBlock comment, LineInfo startLine, LineInfo endLine, int accessModifier, ReparseElement[] reparseStack, boolean internalModule) {
        RfStruct packg = project.getPackage(structName);
        if (packg == null) {
            packg = this.createStruct(RfStruct.KIND.SDL_AGENT, internalModule, project, structName, this.fPackageName);
            packg.setDefinitionData(this, this.fPackageName, true, false, accessModifier);
            project.addNewDefinedTypeName(packg);
            project.addPackage(packg);
        }
        RfStructLayer layer = new RfStructLayer(structName, null, 0, startLine, endLine, comment, this, reparseStack);
        if (!internalModule) {
            packg.addLayer(layer);
            return new RfProject.ElementContainer(layer);
        }
        return new RfProject.ElementContainer(packg);
    }

    protected RfScalarTypeLayer addSLNTypeLayer(boolean incremental, RfProject project, RfStruct slnComponent, String typeName, String assocTypeName, String assocTypePackageName, boolean isEnum, List<RfEnum> enums, List<Range> ranges, CommentBlock comment, LineInfo startLine, LineInfo endLine, int accessModifier, ReparseElement[] reparseStack) {
        RfType type = slnComponent.getType(typeName);
        RfDefElement declaration = null;
        if (type == null || !type.isPredefined() && type.hasNoLayers() && !(type instanceof RfScalarType)) {
            type = new RfScalarType(project, typeName);
            slnComponent.addType(type, incremental);
            type.setDefinitionData(slnComponent.getName(), accessModifier);
            project.addNewDefinedTypeName(type);
        } else if (!(type instanceof RfPredefinedStruct) && !(type instanceof RfPredefinedScalar)) {
            declaration = type.getDeclaration(false);
            if (declaration != null && !declaration.getPackageName().equals(this.fPackageName)) {
                type = new RfScalarType(project, typeName);
                slnComponent.addType(type, incremental);
                type.setDefinitionData(slnComponent.getName(), accessModifier);
            } else {
                slnComponent.addType(type, incremental);
                type.setDefinitionData(slnComponent.getName(), accessModifier);
            }
        }
        type.setAssociatedType(assocTypeName, assocTypePackageName, isEnum);
        RfScalarTypeLayer layer = new RfScalarTypeLayer(slnComponent.getName(), 0, startLine, endLine, comment, this, reparseStack);
        layer.setNamedElement(type);
        layer.addEnumItems(this, startLine, enums, type);
        type.setVisibleRanges(ranges);
        type.addLayer(layer);
        return layer;
    }

    protected RfScalarTypeLayer addSLNExtendTypeLayer(boolean incremental, RfProject project, RfStruct slnComponent, String typeName, String typePackageName, boolean isEnum, List<RfEnum> enums, CommentBlock comment, LineInfo startLine, LineInfo endLine, ReparseElement[] reparseStack) {
        String packageName = slnComponent.getName();
        RfType type = slnComponent.getType(typeName);
        if (type == null) {
            type = new RfScalarType(project, typeName);
            type.setDefinitionData(packageName, 16);
            RfStruct packg = project.getPackage(packageName);
            if (packg == null) {
                packg = RfStruct.createPackage(project, packageName);
                project.addPackage(packg);
            }
            packg.addType(type, incremental);
            project.addNewDefinedTypeName(type);
        }
        if (type instanceof RfScalarType) {
            ((RfScalarType)type).setIsEnumType(isEnum);
        }
        RfScalarTypeLayer layer = new RfScalarTypeLayer(typePackageName, 1, startLine, endLine, comment, this, reparseStack);
        layer.setNamedElement(type);
        layer.addEnumItems(this, startLine, enums, type);
        type.addLayer(layer);
        return layer;
    }

    protected RfProject.ElementContainer addSLNActionLikeLayer(boolean incremental, RfProject project, RfStruct slnComponent, String structName, CommentBlock comment, LineInfo startLine, LineInfo endLine, int accessModifier, ReparseElement[] reparseStack, boolean internalModule) {
        RfStruct slnAction = slnComponent.getSLNAction(structName);
        if (slnAction == null) {
            slnAction = this.createStruct(RfStruct.KIND.SLN_ACTION, internalModule, project, structName, slnComponent.getName());
            slnComponent.addSLNAction(slnAction, incremental);
            project.addNewDefinedTypeName(slnAction);
        }
        slnAction.setDefinitionData(this, slnComponent.getName(), false, false, accessModifier);
        if (internalModule) {
            return new RfProject.ElementContainer(slnAction);
        }
        RfStructLayer layer = new RfStructLayer(structName, null, 0, startLine, endLine, comment, this, reparseStack);
        slnAction.addLayer(layer);
        return new RfProject.ElementContainer(layer);
    }

    protected RfProject.ElementContainer addSDLScenarioLikeLayer(boolean incremental, RfProject project, RfStruct sdlAgent, String structName, CommentBlock comment, LineInfo startLine, LineInfo endLine, int accessModifier, ReparseElement[] reparseStack, boolean internalModule) {
        RfStruct sdlScenario = sdlAgent.getSDLScenario(structName);
        if (sdlScenario == null) {
            sdlScenario = this.createStruct(RfStruct.KIND.SDL_SCENARIO, internalModule, project, structName, sdlAgent.getName());
            sdlAgent.addSDLScenario(sdlScenario);
            project.addNewDefinedTypeName(sdlScenario);
        }
        sdlScenario.setDefinitionData(this, sdlAgent.getName(), false, false, accessModifier);
        if (internalModule) {
            return new RfProject.ElementContainer(sdlScenario);
        }
        RfStructLayer layer = new RfStructLayer(structName, null, 0, startLine, endLine, comment, this, reparseStack);
        sdlScenario.addLayer(layer);
        return new RfProject.ElementContainer(layer);
    }

    protected RfProject.ElementContainer addSDLRoleTypeLayer(boolean incremental, RfProject project, String roleName, CommentBlock comment, LineInfo startLine, LineInfo endLine, ReparseElement[] reparseStack, boolean internalModule) {
        RfStruct packg = project.getPackage("main");
        RfType type = project.getType("main", false, -1, roleName, this.fMaxModuleIndex);
        RfStruct sdlRole = null;
        if (type instanceof RfStruct) {
            sdlRole = (RfStruct)type;
        }
        if (sdlRole == null) {
            sdlRole = this.createStruct(RfStruct.KIND.SDL_ROLE, internalModule, project, roleName, "main");
            packg.addType(sdlRole, incremental);
            project.addNewDefinedTypeName(sdlRole);
        }
        sdlRole.setDefinitionData(this, "main", false, false, 16);
        if (internalModule) {
            return new RfProject.ElementContainer(sdlRole);
        }
        RfStructLayer layer = new RfStructLayer(roleName, null, 0, startLine, endLine, comment, this, reparseStack);
        sdlRole.addLayer(layer);
        return new RfProject.ElementContainer(layer);
    }

    private RfStruct createStruct(RfStruct.KIND kind, boolean internalModule, RfProject project, String name, String packageName) {
        RfStruct struct = internalModule ? new RfPredefinedStruct(project, name, packageName, false, null, null) : new RfStruct(project, name, true);
        struct.setKind(kind);
        return struct;
    }

    protected RfProject.ElementContainer addTemplateStructLayer(boolean incremental, RfProject project, String structName, boolean isUnit, List<WrapperParam> parameters, CommentBlock comment, LineInfo startLine, LineInfo endLine, int accessModifier, ReparseElement[] reparseStack, RfStruct.KIND kind) {
        RfType template = project.getType(this.fPackageName, false, -1, structName, this.fMaxModuleIndex);
        RfDefElement declaration = null;
        if (template == null || !template.isPredefined() && template.hasNoLayers() && !(template instanceof RfTemplateStruct)) {
            template = new RfTemplateStruct(project, structName);
            ((RfTemplateStruct)template).setKind(kind);
            project.getPackage(this.fPackageName).addType(template, incremental);
            template.setDefinitionData(this, parameters, this.fPackageName, isUnit, false, accessModifier);
            project.addNewDefinedTypeName(template);
        } else if (!(template instanceof RfPredefinedStruct) && !(template instanceof RfPredefinedScalar)) {
            declaration = template.getDeclaration(false);
            if (declaration != null && !declaration.getPackageName().equals(this.fPackageName)) {
                template = new RfTemplateStruct(project, structName);
                ((RfTemplateStruct)template).setKind(kind);
                project.getPackage(this.fPackageName).addType(template, incremental);
                template.setDefinitionData(this, parameters, this.fPackageName, isUnit, false, accessModifier);
            } else {
                if (template instanceof RfTemplateStruct) {
                    ((RfTemplateStruct)template).setKind(kind);
                }
                project.getPackage(this.fPackageName).addType(template, incremental);
                template.setDefinitionData(this, parameters, this.fPackageName, isUnit, false, accessModifier);
            }
        }
        RfStructLayer layer = new RfStructLayer(structName, null, 0, startLine, endLine, comment, this, reparseStack);
        template.addLayer(layer);
        return new RfProject.ElementContainer(layer);
    }

    protected RfStructLayer addStructLayer(boolean isWhenLayer, boolean incremental, RfProject project, String structName, String structPackageName, String subtypeName, CommentBlock comment, LineInfo startLine, LineInfo endLine, ReparseElement[] reparseStack, boolean templateExtend) {
        boolean isRegularExtend = subtypeName.equals(structName);
        boolean strictPackage = structPackageName != null;
        String packageName = strictPackage ? structPackageName : this.fPackageName;
        RfType struct = project.getType(packageName, false, -1, structName, this.fMaxModuleIndex);
        if (!templateExtend && !isWhenLayer && struct instanceof RfTemplateStruct && ((RfTemplateStruct)struct).isTemplateStruct()) {
            struct = new RfTemplateStructInstance((RfProject)this.getRfProject(), (RfTemplateStruct)struct);
        }
        if (struct == null) {
            struct = new RfStruct(project, structName, true);
            struct.setDefinitionData(this, packageName, false, true, 16);
            RfStruct packg = project.getPackage(packageName);
            if (packg == null) {
                packg = RfStruct.createPackage(project, packageName);
                project.addPackage(packg);
            }
            packg.addType(struct, incremental);
            project.addNewDefinedTypeName(struct);
        }
        int kind = isRegularExtend ? 1 : 2;
        RfStructLayer layer = new RfStructLayer(subtypeName, structPackageName, kind, startLine, endLine, comment, this, reparseStack);
        struct.addLayer(layer);
        return layer;
    }

    protected RfScalarTypeLayer addTypeLayer(boolean incremental, RfProject project, String typeName, String assocTypeName, String assocTypePackageName, boolean isEnum, List<RfEnum> enums, List<Range> ranges, CommentBlock comment, LineInfo startLine, LineInfo endLine, int accessModifier, ReparseElement[] reparseStack) {
        RfType type = project.getType(this.fPackageName, false, -1, typeName, this.fMaxModuleIndex);
        RfDefElement declaration = null;
        if (type == null || !type.isPredefined() && type.hasNoLayers() && !(type instanceof RfScalarType)) {
            type = new RfScalarType(project, typeName);
            project.getPackage(this.fPackageName).addType(type, incremental);
            type.setDefinitionData(this.fPackageName, accessModifier);
            project.addNewDefinedTypeName(type);
        } else if (!(type instanceof RfPredefinedStruct) && !(type instanceof RfPredefinedScalar)) {
            declaration = type.getDeclaration(false);
            if (declaration != null && !declaration.getPackageName().equals(this.fPackageName)) {
                type = new RfScalarType(project, typeName);
                project.getPackage(this.fPackageName).addType(type, incremental);
                type.setDefinitionData(this.fPackageName, accessModifier);
            } else {
                project.getPackage(this.fPackageName).addType(type, incremental);
                type.setDefinitionData(this.fPackageName, accessModifier);
            }
        }
        type.setAssociatedType(assocTypeName, assocTypePackageName, isEnum);
        RfScalarTypeLayer layer = new RfScalarTypeLayer(this.fPackageName, 0, startLine, endLine, comment, this, reparseStack);
        layer.setNamedElement(type);
        layer.addEnumItems(this, startLine, enums, type);
        type.setVisibleRanges(ranges);
        type.addLayer(layer);
        return layer;
    }

    protected RfScalarTypeLayer addExtendTypeLayer(boolean incremental, RfProject project, String typeName, String typePackageName, boolean isEnum, List<RfEnum> enums, CommentBlock comment, LineInfo startLine, LineInfo endLine, ReparseElement[] reparseStack) {
        boolean strictPackage = typePackageName != null;
        String packageName = strictPackage ? typePackageName : this.fPackageName;
        RfType type = project.getType(packageName, strictPackage, -1, typeName, this.fMaxModuleIndex);
        if (type == null) {
            type = new RfScalarType(project, typeName);
            type.setDefinitionData(packageName, 16);
            RfStruct packg = project.getPackage(packageName);
            if (packg == null) {
                packg = RfStruct.createPackage(project, packageName);
                project.addPackage(packg);
            }
            packg.addType(type, incremental);
            project.addNewDefinedTypeName(type);
        }
        if (type instanceof RfScalarType) {
            ((RfScalarType)type).setIsEnumType(isEnum);
        }
        RfScalarTypeLayer layer = new RfScalarTypeLayer(typePackageName, 1, startLine, endLine, comment, this, reparseStack);
        layer.setNamedElement(type);
        layer.addEnumItems(this, startLine, enums, type);
        type.addLayer(layer);
        return layer;
    }

    protected RfMethodTypeLayer addMethodTypeLayer(boolean incremental, RfProject project, WrapperMethod parseInfo, int accessModifier, ReparseElement[] reparseStack) {
        RfType type = project.getType(this.fPackageName, false, -1, parseInfo.name, this.fMaxModuleIndex);
        RfDefElement declaration = null;
        if (type == null || !type.isPredefined() && type.hasNoLayers() && !(type instanceof RfMethodType)) {
            type = new RfMethodType(project, parseInfo.name);
            project.getPackage(this.fPackageName).addType(type, incremental);
            project.addNewDefinedTypeName(type);
            type.setDefinitionData(this, this.fPackageName, false, false, accessModifier);
        } else if (!(type instanceof RfPredefinedStruct) && !(type instanceof RfPredefinedScalar)) {
            declaration = type.getDeclaration(false);
            if (declaration != null && !declaration.getPackageName().equals(this.fPackageName)) {
                type = new RfMethodType(project, parseInfo.name);
                project.getPackage(this.fPackageName).addType(type, incremental);
                type.setDefinitionData(this, this.fPackageName, false, false, accessModifier);
            } else {
                project.getPackage(this.fPackageName).addType(type, incremental);
                type.setDefinitionData(this, this.fPackageName, false, false, accessModifier);
            }
        }
        RfMethodTypeLayer layer = new RfMethodTypeLayer(parseInfo.name, 0, parseInfo.startLine, parseInfo.endLine, parseInfo.comment, this, reparseStack);
        type.addLayer(layer);
        return layer;
    }

    public void addCheckThatAction(String name, String parentStructName, String parentPackageName, String expression, boolean defaultDutError, String literal, LineInfo line, LineInfo endLine, CommentBlock comment) {
        name = name == null ? "[anonymous]" : name;
        this.fOVMCheckThatActions.add(new RfCheckThat((RfProject)this.getRfProject(), this, this, name, parentStructName, parentPackageName, expression, defaultDutError, literal, line, endLine, comment));
    }

    public void addAssertAction(String parentStructName, String parentPackageName, String expression, boolean defaultError, String literal, LineInfo line, LineInfo endLine, CommentBlock comment) {
        String name = "[anonymous]";
        this.fAssertActions.add(new RfAssert((RfProject)this.getRfProject(), this, this, name, parentStructName, parentPackageName, expression, defaultError, literal, line, endLine, comment));
    }

    public void addMessageAction(boolean messagef, String literal, LineInfo line) {
        this.fOVMMessageActions.add(new RfOVMMessage((RfProject)this.getRfProject(), this, messagef, literal, line.line));
    }

    public List<RfCheckThat> getCheckThatActions() {
        return this.fOVMCheckThatActions;
    }

    public List<RfAssert> getAssertActions() {
        return this.fAssertActions;
    }

    public List<RfOVMMessage> getMessageActions() {
        return this.fOVMMessageActions;
    }

    public void setExplicitPackage(boolean explicitPackage) {
        this.fExplicitPackage = explicitPackage;
    }

    public boolean isExplicitPackage() {
        return this.fExplicitPackage;
    }

    protected void addImportFilePath(String filePath, LineInfo line) {
        if (this.fImportFilePaths == null) {
            this.fImportFilePaths = new ArrayList<ImportFilePath>();
        }
        this.fImportFilePaths.add(new ImportFilePath(filePath, line));
    }

    public List<ImportFilePath> getImportedFilePaths() {
        return this.fImportFilePaths;
    }

    protected void writeCustom(ObjectOutputStream out) throws IOException {
        out.writeLong(336L);
        out.writeUTF(this.getName());
        out.writeUTF(this.fParserPath.path);
        out.writeUTF(this.fPackageName);
        out.writeBoolean(this.fSNEncrypted);
        out.writeBoolean(this.fDVTEncrypted);
        out.writeBoolean(this.fIsInTop);
        out.writeBoolean(this.fIsInActiveTest);
        out.writeObject(this.fImportedByTest);
        out.writeObject(this.fImportFilePaths);
        out.writeInt(this.fClusterIndex);
        out.writeInt(this.fModuleIndex);
        out.writeInt(this.fInvocationIndex);
    }

    protected void readCustom(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            long serial = in.readLong();
            if (serial != 336L) {
                throw new InvalidClassException("RFDM version changed");
            }
        }
        catch (InvalidClassException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new InvalidClassException("RFDM version changed");
        }
        this.setName(in.readUTF());
        this.fParserPath = new ParserPath(in.readUTF());
        this.fPackageName = in.readUTF();
        this.fSNEncrypted = in.readBoolean();
        this.fDVTEncrypted = in.readBoolean();
        this.fIsInTop = in.readBoolean();
        this.fIsInActiveTest = in.readBoolean();
        this.fImportedByTest = (ParserPath)in.readObject();
        this.fImportFilePaths = (List)in.readObject();
        this.fClusterIndex = in.readInt();
        this.fModuleIndex = in.readInt();
        this.fInvocationIndex = in.readInt();
    }

    public boolean isInternalModule() {
        boolean predefined;
        boolean bl = predefined = this.fPluginConfig == null ? true : this.getName().startsWith(this.fPluginConfig.getTopPathPrefix());
        return this instanceof RfPredefinedModule || predefined;
    }

    public boolean isDVTEncrypted() {
        return this.fDVTEncrypted;
    }

    public int getModuleIndex() {
        return this.fModuleIndex;
    }

    public int getMaxModuleIndex() {
        return this.fMaxModuleIndex;
    }

    public int getClusterIndex() {
        return this.fClusterIndex;
    }

    public void setModuleIndex(int moduleIndex) {
        this.fModuleIndex = moduleIndex;
    }

    public int getInvocationIndex() {
        return this.fInvocationIndex;
    }

    @Override
    public LanguageKind getLanguageKind() {
        return this.fPluginConfig.getLanguageKind();
    }

    @Override
    public __etools_string get_name() {
        String name = this.getName();
        int index = name.lastIndexOf(46);
        if (index > 0) {
            name = name.substring(0, index);
        }
        return new __etools_string(name);
    }

    @Override
    public __etools_string get_value() {
        return null;
    }

    @Override
    public IRfType get_package() {
        String packageName;
        IRfSingleLangProject rfProject = this.getRfProject();
        RfStruct rfPackage = rfProject.getPackage(packageName = this.getPackageName());
        if (rfPackage == null) {
            return new RfStruct((RfProject)rfProject, packageName, false);
        }
        return rfPackage;
    }

    @Override
    public Object get_key(String fieldName) {
        return this;
    }

    public boolean is_user_module() {
        return !this.isPredefined();
    }

    @Override
    public IRfNamedElement getMember(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, boolean isFirst, boolean isLast, boolean includeEnums, boolean isOnlyType, boolean skipParents) {
        for (RfDefElement childDef : this.fChildrenDefs) {
            if (!childDef.getName().equals(name)) continue;
            return childDef.getNamedElement();
        }
        return null;
    }

    public List<CustomPragmaUsage> getCustomPragmas() {
        return this.fCustomPragmas;
    }

    public void setCustomPragmas(List<CustomPragmaUsage> customPragmas) {
        this.fCustomPragmas = customPragmas;
    }

    public IRfNamedElement getNamedElement(String name, int offset, int virtualOffset) {
        if (virtualOffset != -1) {
            RfDefElement elementInsideMacro = this.getElementInsideMacro((List<RfDefElement>)this.getChildren(), virtualOffset);
            return elementInsideMacro == null ? null : elementInsideMacro.getNamedElement();
        }
        IdentifierPosition idPosition = this.getIdentifier(name, offset);
        if (idPosition != null) {
            return idPosition.getNamedElement();
        }
        IRfSingleLangProject rfProject = this.getRfProject();
        if (rfProject == null) {
            return null;
        }
        return rfProject.getPreproc(name);
    }

    public IRfBreadcrumbElement getDefElementForBC(String name, int offset, int virtualOffset) {
        if (this.getRfProject() == null) {
            return null;
        }
        if (virtualOffset != -1) {
            return this.getElementInsideMacro((List<RfDefElement>)this.getChildren(), virtualOffset);
        }
        IdentifierPosition idPosition = this.getIdentifier(name, offset);
        if (idPosition != null) {
            return idPosition.getDefElement();
        }
        IRfSingleLangProject rfProject = this.getRfProject();
        if (rfProject == null) {
            return null;
        }
        return rfProject.getPreproc(name);
    }

    private RfDefElement getElementInsideMacro(List<RfDefElement> children, int virtualOffset) {
        if (children == null || children.isEmpty()) {
            return null;
        }
        for (RfDefElement child : children) {
            if (virtualOffset >= child.getStartVirtualOffset() && virtualOffset <= child.getEndVirtualOffset()) {
                return child;
            }
            this.getElementInsideMacro((List<RfDefElement>)child.getChildren(), virtualOffset);
        }
        return null;
    }

    public static class IdentifierPosition
    extends DVTPosition {
        private AST idAST;

        public IdentifierPosition(EAST id) {
            super(0, 0);
            this.offset = id.getOffset();
            this.length = id.getText().length();
            this.idAST = id;
        }

        public RfNamedElement getNamedElement() {
            return SemanticUtils.getTransientResult(RfNamedElement.class, this.idAST);
        }

        public RfDefElement getDefElement() {
            return SemanticUtils.getTransientScope(RfDefElement.class, this.idAST);
        }

        public RfTemplateStructInstance getTemplateInstanceScope() {
            return SemanticUtils.getTransientScope(RfTemplateStructInstance.class, this.idAST);
        }

        public String getText() {
            return this.idAST.getText();
        }

        public AST getIdAst() {
            return this.idAST;
        }
    }
}

