/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.problems.LibraryPackageScope;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfVHBreadcrumbElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.MaxSizeReachedException;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.IRfAssociatedType;
import ro.amiq.edt.base.model.reflection.RfArgLayer;
import ro.amiq.edt.base.model.reflection.RfAssertLayer;
import ro.amiq.edt.base.model.reflection.RfBindMethodCallLayer;
import ro.amiq.edt.base.model.reflection.RfCheckThatLayer;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfElement;
import ro.amiq.edt.base.model.reflection.RfEventLayer;
import ro.amiq.edt.base.model.reflection.RfFieldLayer;
import ro.amiq.edt.base.model.reflection.RfKind;
import ro.amiq.edt.base.model.reflection.RfMacroLayer;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfMethodType;
import ro.amiq.edt.base.model.reflection.RfMethodTypeLayer;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfScalarTypeLayer;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfTemplateParamLayer;
import ro.amiq.edt.base.model.reflection.RfVarLayer;
import ro.amiq.edt.base.model.reflection.WrapperType;
import ro.amiq.edt.base.model.reflection.ascomputed.ClassEncap;
import ro.amiq.edt.base.model.reflection.ascomputed.base.__etools_string;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedModule;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedScalar;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedStruct;

public abstract class RfNamedElement
extends RfElement
implements Cloneable,
IRfNamedElement,
IRfVHBreadcrumbElement {
    private String fName;
    private int fAccessModifier = 16;
    private RfProject fRfProject;
    private ListContainer<RfDefElement> fLayers;
    private boolean fUnsortedLayers;
    private boolean fNonStandard;

    public RfNamedElement(RfProject project, String name) {
        this.fName = DVTStringUtil.intern((String)name);
        this.fRfProject = project;
    }

    public void deepClean() {
        try {
            this.fRfProject = null;
            if (this.fLayers != null) {
                this.fLayers = OptimizedUtils.listContainerClear(this.fLayers);
            }
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    protected void clearLayers() {
        if (this.fLayers != null) {
            this.fLayers = OptimizedUtils.listContainerClear(this.fLayers);
        }
    }

    public boolean isEscaped() {
        return false;
    }

    public boolean isPredefined() {
        return false;
    }

    public boolean isEPredefined() {
        return false;
    }

    public boolean hasNoDefs(boolean rawDefs) {
        return this.fLayers == null || this.fLayers.isEmpty();
    }

    public String getTooltipSignature(IRfScopeElement scope, ElementPath hierarchyPath, Hid hid, boolean useCharLimit) {
        return this.getSignature();
    }

    public void setNonStandard(boolean nonStandard) {
        this.fNonStandard = nonStandard;
    }

    public boolean isNonStandard() {
        return this.fNonStandard;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    public String getLowerCaseName() {
        return this.fName == null ? null : this.fName.toLowerCase();
    }

    public String getNameForDiagram() {
        return this.getName();
    }

    public RfProject getRfProject() {
        return this.fRfProject;
    }

    @Override
    public Object getAdapter(Class adapter) {
        return this.getInternalAdapter(adapter);
    }

    public void setAccessModifier(int accessModifier) {
        this.fAccessModifier = accessModifier;
    }

    public int getAccessModifier() {
        return this.fAccessModifier;
    }

    public boolean isPublic() {
        return (this.fAccessModifier & 0x10) == 16;
    }

    public boolean isPrivate() {
        return (this.fAccessModifier & 2) == 2;
    }

    public boolean isProtected() {
        return (this.fAccessModifier & 4) == 4;
    }

    public boolean isPackage() {
        return (this.fAccessModifier & 8) == 8;
    }

    public boolean isStatic() {
        return (this.fAccessModifier & 0x20) == 32;
    }

    public boolean isConst() {
        return (this.fAccessModifier & 0x40) == 64;
    }

    protected String getTypeName(String typeName, int listDepth) {
        if (listDepth == 0) {
            return typeName;
        }
        if (typeName == null) {
            return null;
        }
        int i = 0;
        while (i < listDepth) {
            int index = WrapperType.endIndexOfListOf(typeName);
            if (index > -1) {
                typeName = typeName.substring(index);
            }
            ++i;
        }
        return typeName;
    }

    public Object getInternalAdapter(Class adapter) {
        RfDefElement declaration;
        if (adapter == IResource.class && (declaration = this.getFirstLayer()) != null) {
            return declaration.getInternalAdapter(adapter);
        }
        return null;
    }

    public RfDefElement getDeclaration() {
        return this.getFirstLayer();
    }

    public List<RfDefElement> getDeclarations() {
        return this.getLayers();
    }

    public RfDefElement getDeclaration(boolean allowWhenLayer) {
        block11: {
            if (!this.hasNoLayers()) break block11;
            return null;
        }
        try {
            for (RfDefElement layer : this.getLayers()) {
                if (this instanceof RfPredefinedScalar) {
                    if (layer.isPredefined() || layer.getLayerKind() != 0) continue;
                    return layer;
                }
                if (layer instanceof RfStructLayer || layer instanceof RfScalarTypeLayer || layer instanceof RfMethodTypeLayer) {
                    if (layer.getLayerKind() != 0 && (!allowWhenLayer || layer.getLayerKind() != 2)) continue;
                    return layer;
                }
                if (layer instanceof RfEventLayer || layer instanceof RfFieldLayer || layer instanceof RfMethodLayer || layer instanceof RfVarLayer || layer instanceof RfArgLayer) {
                    if (layer.getLayerKind() != 378 && layer.getLayerKind() != 371 && layer.getLayerKind() != 372) continue;
                    return layer;
                }
                if (layer instanceof RfMacroLayer) {
                    return layer;
                }
                if (layer instanceof RfCheckThatLayer) {
                    return layer;
                }
                if (layer instanceof RfAssertLayer) {
                    return layer;
                }
                if (layer instanceof RfTemplateParamLayer) {
                    return layer;
                }
                if (!(layer instanceof RfBindMethodCallLayer)) continue;
                return layer;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    public RfDefElement getFirstLayer() {
        block4: {
            if (!this.hasNoLayers()) break block4;
            return null;
        }
        try {
            for (RfDefElement layer : this.getLayers()) {
                if (layer.getLayerModule() == null || layer.getLayerModule() instanceof RfPredefinedModule) continue;
                return layer;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    protected void addLayer(RfDefElement layer) {
        layer.setNamedElement(this);
        this.fLayers = OptimizedUtils.listContainerAdd(this.fLayers, (Object)layer);
        this.fUnsortedLayers = true;
    }

    private void sortLayers() {
        if (this.fLayers == null) {
            return;
        }
        if (this.fLayers instanceof List) {
            Collections.sort((List)this.fLayers);
        }
    }

    public RfModule getModule() {
        RfDefElement declaration = this.getDeclaration(true);
        if (declaration != null) {
            return declaration.getLayerModule();
        }
        declaration = this.getFirstLayer();
        if (declaration != null) {
            return declaration.getLayerModule();
        }
        return null;
    }

    public int getLine() {
        RfDefElement declaration = this.getFirstLayer();
        if (declaration != null) {
            return declaration.getStartLine();
        }
        return 0;
    }

    public LineInfo getLineInfo() {
        RfDefElement declaration = this.getFirstLayer();
        if (declaration != null) {
            return declaration.getStartInfo();
        }
        return new LineInfo(0, 0, -1);
    }

    public String getComment(boolean removeHTMLTags) {
        RfDefElement declaration = this.getFirstLayer();
        if (declaration != null) {
            return declaration.getLayerComment(removeHTMLTags);
        }
        return "";
    }

    public String getComment() {
        return this.getComment(true);
    }

    public String getRawUntrimmedComment(String inlineAboveDelimiter) {
        CommentBlock declarationCommentBlock;
        RfDefElement declaration = this.getFirstLayer();
        CommentBlock commentBlock = declarationCommentBlock = declaration == null ? null : declaration.getLayerCommentBlock();
        if (declarationCommentBlock == null) {
            return "";
        }
        return declarationCommentBlock.toRawUntrimmedString(inlineAboveDelimiter);
    }

    public boolean hasNoLayers() {
        List<RfDefElement> layers = this.internalGetLayers();
        if (layers == null || layers.isEmpty()) {
            return true;
        }
        if (this instanceof RfPredefinedScalar) {
            for (RfDefElement layer : layers) {
                if (layer.getLayerModule() == null || layer.getLayerModule().isInternalModule()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected int decodeTypeKind(int elemTypeKind) {
        if (elemTypeKind == 2) {
            return 1;
        }
        if (elemTypeKind == 1) {
            return 2;
        }
        if (elemTypeKind == 3) {
            return 12;
        }
        if (elemTypeKind == 9) {
            return 14;
        }
        if (elemTypeKind == 10) {
            return 13;
        }
        return -1;
    }

    protected int decodeTypeKind(IRfAssociatedType element) {
        IRfNamedElement assocType = element.getAssociatedType();
        if (assocType instanceof RfMethodType) {
            return 4;
        }
        if (assocType instanceof RfStruct) {
            return 1;
        }
        if (assocType instanceof RfPredefinedScalar && ((RfPredefinedScalar)assocType).isEnumType() && assocType.getName().startsWith("[") && assocType.getName().endsWith("]")) {
            return 12;
        }
        if (assocType instanceof RfScalarType) {
            return 2;
        }
        return -1;
    }

    protected boolean isDeclaredIn(RfStruct packg) {
        RfDefElement declaration = this.getDeclaration(false);
        String packageName = packg.getPackageName();
        if (declaration == null) {
            if (packageName.equals("main") && (this instanceof RfPredefinedScalar || this instanceof RfPredefinedStruct)) {
                return true;
            }
            RfDefElement layer = this.getFirstLayer();
            return layer != null && (packageName.equals(layer.getPackageName()) || packageName.equals(layer.getQualifiedPackageName()));
        }
        return declaration.getPackageName().equals(packageName);
    }

    protected void reorderLayers() {
        this.sortLayers();
    }

    protected void removeLayer(RfDefElement layer) {
        this.fUnsortedLayers = true;
        if (this.fLayers == null) {
            return;
        }
        this.fLayers = OptimizedUtils.listContainerRemove(this.fLayers, (Object)layer);
    }

    public List<RfDefElement> getLayers() {
        if (this.fUnsortedLayers) {
            this.sortLayers();
        }
        this.fUnsortedLayers = false;
        return Collections.unmodifiableList(this.internalGetLayers());
    }

    protected List<RfDefElement> internalGetLayers() {
        if (this.fLayers == null) {
            this.fLayers = ListContainer.emptyContainer();
        }
        return OptimizedUtils.asList(this.fLayers, (boolean)false);
    }

    protected ListContainer<RfDefElement> getLayersContainer() {
        return this.fLayers;
    }

    protected void setLayersContainer(ListContainer<RfDefElement> layers) {
        this.fUnsortedLayers = true;
        this.fLayers = layers;
    }

    public boolean checkEquals(Object obj) {
        return obj == this;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Image getImage() {
        return null;
    }

    public Image testGetImage(String imageName) {
        try {
            ImageDescriptor descriptor = (ImageDescriptor)DVTImages.class.getDeclaredField(imageName).get(null);
            return DVTImages.imageCache.getImage(descriptor);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public IRfScopeElement getEnclosingScope() {
        return null;
    }

    public <T extends IRfScopeElement> T getEnclosingScope(Class<T> clazz) {
        return null;
    }

    public IRfScopeElement getEnclosingScope(Set<?> classes) {
        return null;
    }

    public IRfNamedElement getSignalWithPrefix(String prefix, int matchType) {
        return null;
    }

    public List<? extends IRfNamedElement> getSignalsWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfInstanceElement getInstanceWithPrefix(String prefix, int matchType) {
        return null;
    }

    public List<Hid> getHids(HidQualifier[] qualifiers, boolean local) {
        return null;
    }

    public List<IHidOperator> getHidOperators(HidOperatorQualifier[] qualifiers, boolean local) {
        return null;
    }

    public boolean visitHidObject(IRfSingleLangProject project, IHidVisitor<?> visitor) {
        return false;
    }

    public IHidHolder getHidHolder() {
        return null;
    }

    public __etools_string get_name() {
        return new __etools_string(this.fName);
    }

    public ClassEncap toClassEncap(RfProject rfProject) {
        return null;
    }

    public IResource getFileAdapter() {
        return (IResource)this.getInternalAdapter(IResource.class);
    }

    public String toString() {
        return this.fName;
    }

    public List<? extends IRfPackageElement> getPackagesWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfPackageElement getPackageWithPrefix(String prefix, int matchType) {
        return null;
    }

    public List<? extends IRfDesignElement> getDesignsWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfDesignElement getDesignWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfConfiguration getConfigurationWithPrefix(String prefix, int matchType) {
        return null;
    }

    public List<? extends IRfNamedElement> getTypesWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfNamedElement getTypeWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfLibraryElement getEnclosingLibrary() {
        return null;
    }

    public List<IRfInstanceElement> getBindInstances(long useCacheTimestamp) {
        return null;
    }

    public RfNamedElement semanticGetMember(RfProject project, Determinant determinant, String packageName, RfStruct enclosingStruct, String name, EnumSet<IRfNamedElement.ElementKind> allowedElements, int accessModifiers, int maxModuleIndex, ParserPath parserPath, RfNamedElement exclude) {
        return null;
    }

    public IRfNamedElement semanticGetMember(String name, IHid hid, ParserPath parserPath, IRfNamedElement initialScope, IRfNamedElement prevScope, boolean isFirst, boolean isLast, boolean recursiveCall) {
        return null;
    }

    public IRfNamedElement semanticGetLocalMember(String name, IHid hid, ParserPath parserPath, IRfNamedElement prevScope, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean recursiveCall) {
        return null;
    }

    public LibraryPackageScope getLibPkgScope() {
        throw new RuntimeException("Do not ask for library and package scope on a named element but file def");
    }

    public boolean isDirtyElement() {
        return false;
    }

    public IRfNamedElement getLocalMember(Set<Class<? extends IRfNamedElement>> classes, String name, IRfNamedElement exclude) {
        return null;
    }

    public boolean hasLocalMembers() {
        return false;
    }

    public IRfNamedElement getVisibleMemberInScope(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean isOnlyType, boolean skipParents) {
        return null;
    }

    public Class<? extends IRfNamedElement> getCustomClass() {
        return this.getClass();
    }

    public IRfNamedElement getMember(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, boolean isFirst, boolean isLast, boolean includeEnums, boolean isOnlyType, boolean skipParents) {
        return null;
    }

    public Collection<RfNamedElement> getMembers(boolean rawMembers, boolean unpackDuplicates) {
        return null;
    }

    public <T extends IRfNamedElement> void getLocalMembers(Collection<T> result, Class<T> clazz, String prefix, List<String> enumPrefixProposals, int matchType, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) throws MaxSizeReachedException {
    }

    public void getElementsWithPrefix(Collection<IRfNamedElement> result, String prefix, int matchType, int local, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) {
    }

    public String getNameForNoDuplicateList() {
        return this.getName();
    }

    public FullName getFullName() {
        return new FullName(this.getName(), new Determinant(""));
    }

    public boolean hasReferenceToIdentifierName(String name) {
        return false;
    }

    public LanguageKind getLanguageKind() {
        return this.fRfProject == null ? LanguageKind.E : this.fRfProject.getLanguageKind();
    }

    public String getKindName() {
        return RfKind.of(this).getName();
    }

    public String javaName() {
        return "__etools_" + this.getName();
    }

    public String javaTypeName() {
        return null;
    }

    public int javaVarDepth() {
        return 0;
    }

    public String javaTypeClassName() {
        return null;
    }

    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currLayer, LineInfo lineInfo, ParserPath parserPath) {
    }

    public String elementPathName() {
        return this.getName();
    }

    public IRfNamedElement elementPathMember(String name, boolean isFirst, boolean isLast, boolean includeEnums, boolean isOnlyType, IRfNamedElement bindInstanceScope, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, ParserPath parserPath, int line) {
        return this.getMember(name, classes, exclude, isFirst, isLast, includeEnums, isOnlyType, false);
    }

    public <T> T get_value() {
        return null;
    }

    public String printScope() {
        StringBuilder result = new StringBuilder();
        this.printScope(result, false);
        return result.toString();
    }

    public void printScope(StringBuilder result, boolean appendThis) {
        RfDefElement declaration;
        String packageName;
        IRfScopeElement scope = this.getEnclosingScope();
        if (scope instanceof RfProject) {
            return;
        }
        if (scope instanceof RfModule && (packageName = ((RfModule)scope).getPackageName()) != null && !packageName.isEmpty()) {
            result.append(packageName).append("::");
        }
        if (scope instanceof RfNamedElement) {
            ((RfNamedElement)scope).printScope(result, true);
        }
        if (appendThis) {
            result.append(this.fName).append('.');
        }
        if ((declaration = this.getDeclaration()) != null && !this.checkEquals(declaration.getNamedElement())) {
            result.append(declaration.getName()).append(".");
        }
    }

    public String getFullNameLabel() {
        return String.valueOf(this.printScope()) + this.getName();
    }
}

