/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import antlr.Token;
import antlr.TreeParser;
import antlr.collections.AST;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTExternalProgramOutputCache;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.AsComputedMethodsToTranslate;
import ro.amiq.dvt.buildconfig.BCFileInstance;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.BuildConfigUtils;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.memorymonitor.MemoryMonitor;
import ro.amiq.dvt.memorymonitor.MemoryMonitorState;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.ChangedFilesManager;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.problems.DVTProblemCategory;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.EProblemCategories;
import ro.amiq.dvt.model.problems.LibraryPackageScope;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IDVTRfManager;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfProjectContent;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfCompiledFiles;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.RfGUIUtils;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.RfProjectState;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidBuilders;
import ro.amiq.dvt.model.reflection.util.IIdleListener;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.custompragma.CustomPragma;
import ro.amiq.dvt.ui.custompragma.CustomPragmaUsage;
import ro.amiq.dvt.ui.custompragma.CustomPragmaUtils;
import ro.amiq.dvt.ui.custompragma.TranslatePragma;
import ro.amiq.dvt.ui.decorators.DVTAbstractDecorator;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTSemanticFoldingPosition;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetType;
import ro.amiq.dvt.ui.guifilters.ElementType;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdater;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdaterRegistry;
import ro.amiq.dvt.ui.views.BuildEventManager;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.MemUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.dvt.utils.parser.DVTCodeCommentsPreferences;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.AbstractEModelManager;
import ro.amiq.edt.base.model.AbstractEModule;
import ro.amiq.edt.base.model.EModuleInfo;
import ro.amiq.edt.base.model.IEModel;
import ro.amiq.edt.base.model.IEModule;
import ro.amiq.edt.base.model.IEProject;
import ro.amiq.edt.base.model.IEReparseListener;
import ro.amiq.edt.base.model.importgraph.ImportGraphNode;
import ro.amiq.edt.base.model.importgraph.ImportGraphNodeVisitor;
import ro.amiq.edt.base.model.importgraph.ImportGraphWalker;
import ro.amiq.edt.base.model.reflection.AbstractRfManager;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.ExpEvaluator;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.IRfModuleListener;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.IdentifiersWalker;
import ro.amiq.edt.base.model.reflection.ImportFilePath;
import ro.amiq.edt.base.model.reflection.RfActionBlockLayer;
import ro.amiq.edt.base.model.reflection.RfAnnotationType;
import ro.amiq.edt.base.model.reflection.RfArg;
import ro.amiq.edt.base.model.reflection.RfArgLayer;
import ro.amiq.edt.base.model.reflection.RfAssert;
import ro.amiq.edt.base.model.reflection.RfAssertLayer;
import ro.amiq.edt.base.model.reflection.RfCheckThat;
import ro.amiq.edt.base.model.reflection.RfCheckThatLayer;
import ro.amiq.edt.base.model.reflection.RfConstraintLayer;
import ro.amiq.edt.base.model.reflection.RfCoverItem;
import ro.amiq.edt.base.model.reflection.RfCoverLayer;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfEventLayer;
import ro.amiq.edt.base.model.reflection.RfExpect;
import ro.amiq.edt.base.model.reflection.RfExpectLayer;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfFieldLayer;
import ro.amiq.edt.base.model.reflection.RfFieldPropConstraint;
import ro.amiq.edt.base.model.reflection.RfFieldTypeConstraint;
import ro.amiq.edt.base.model.reflection.RfInactiveCodeFileInfo;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfMacro;
import ro.amiq.edt.base.model.reflection.RfMacroLayer;
import ro.amiq.edt.base.model.reflection.RfMeImplicitVariable;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfMethodType;
import ro.amiq.edt.base.model.reflection.RfMethodTypeLayer;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfOnEventLayer;
import ro.amiq.edt.base.model.reflection.RfSDLInlineSMLayer;
import ro.amiq.edt.base.model.reflection.RfSDLToolEditorAvoidCallLayer;
import ro.amiq.edt.base.model.reflection.RfSDLToolEditorPrioritizeCallLayer;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfScalarTypeLayer;
import ro.amiq.edt.base.model.reflection.RfSpecman;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfTableDefine;
import ro.amiq.edt.base.model.reflection.RfTableDefineLayer;
import ro.amiq.edt.base.model.reflection.RfTemplateStruct;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.RfTypesUtil;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.RfVarLayer;
import ro.amiq.edt.base.model.reflection.RfWalker;
import ro.amiq.edt.base.model.reflection.TypesWalker;
import ro.amiq.edt.base.model.reflection.WrapperActionBlock;
import ro.amiq.edt.base.model.reflection.WrapperExtendStruct;
import ro.amiq.edt.base.model.reflection.WrapperLikeStruct;
import ro.amiq.edt.base.model.reflection.WrapperMacro;
import ro.amiq.edt.base.model.reflection.WrapperMethod;
import ro.amiq.edt.base.model.reflection.WrapperParam;
import ro.amiq.edt.base.model.reflection.WrapperSequence;
import ro.amiq.edt.base.model.reflection.WrapperType;
import ro.amiq.edt.base.model.reflection.ascomputed.AsComputedCompiler;
import ro.amiq.edt.base.model.reflection.ascomputed.AsComputedProcessor;
import ro.amiq.edt.base.model.reflection.ascomputed.AsComputedWalker;
import ro.amiq.edt.base.model.reflection.ascomputed.ClassEncap;
import ro.amiq.edt.base.model.reflection.ascomputed.RfValueHolder;
import ro.amiq.edt.base.model.reflection.ascomputed.RfWhenSubtype;
import ro.amiq.edt.base.model.reflection.ascomputed.base.AsComputedEvolvedClassHandler;
import ro.amiq.edt.base.model.reflection.ascomputed.base.EList;
import ro.amiq.edt.base.model.reflection.ascomputed.base.IRfType;
import ro.amiq.edt.base.model.reflection.ascomputed.base._Int;
import ro.amiq.edt.base.model.reflection.ascomputed.base.__etools_string;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedArg;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedEvent;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedField;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedMethod;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedScalar;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedStruct;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedVar;
import ro.amiq.edt.base.model.reflection.predefined.ecode.RfPredefinedCodeLoader;
import ro.amiq.edt.base.model.reflection.semantic.DebugSemanticWalker;
import ro.amiq.edt.base.model.reflection.semantic.RfDummyField;
import ro.amiq.edt.base.model.reflection.semantic.RfSemanticError;
import ro.amiq.edt.base.model.reflection.semantic.SemanticWalker;
import ro.amiq.edt.base.model.reflection.util.NullProtectedList;
import ro.amiq.edt.base.model.reflection.views.EQuickViewersUtil;
import ro.amiq.edt.base.r2lparser.R2LAmbiguousType;
import ro.amiq.edt.base.r2lparser.R2LUtils;
import ro.amiq.edt.base.test.AbstractTestHelper;
import ro.amiq.etools.eparser.Comment;
import ro.amiq.etools.eparser.EAST;
import ro.amiq.etools.eparser.EParser;
import ro.amiq.etools.eparser.ReparseElement;
import ro.amiq.etools.eparser.ascomputed.IRfManager;

public class RfProject
extends RfNamedElement
implements IRfManager,
IRfSingleLangProject,
IRfScope {
    private static final String DVT_DISABLE_E_LANG_SEMANTIC_EXT = "DVT_DISABLE_E_LANG_SEMANTIC_EXT";
    private Map<String, RfStruct> fPackages;
    private Map<ParserPath, RfModule> fParserPathToModuleMap;
    private Map<String, RfMacro> fMacros;
    private Map<String, RfMacro> fPreprocs;
    private Map<String, RfTableDefine> fTableDefines;
    private Map<ParserPath, RfInactiveCodeFileInfo> fInactiveCodeInfos;
    private RfSpecman fSpecman;
    private boolean fDisableAsComputedSupport;
    private boolean fTempDisableSemanticErrorReporting;
    private Map<ParserPath, Set<ParserPath>> fImportedTestFiles;
    private Map<String, ClassEncap> fAsComputedJavaClassMap;
    private int fAnonymousExpectCounter;
    private int fSDLInlineCounter;
    private DVTCodeCommentsPreferences fCommentsPreferences;
    private boolean fIsNonStandardCheckEnabled;
    public transient Object FAMILY_PROJECT_RESTORE;
    private transient IProject fProject;
    private transient String fInternalApiFilesPrefix;
    private transient RfModule fLastModule;
    private transient RfStruct fLastStruct;
    private transient RfMethod fLastMethod;
    private transient RfStructLayer fLastStructLayer;
    private transient RfConstraintLayer fLastConstraintLayer;
    private transient RfMethodLayer fLastMethodLayer;
    private transient RfCoverLayer fLastCoverLayer;
    private transient RfMacroLayer fLastMacroLayer;
    private transient WrapperType fLastPerUnitInstance;
    private transient RfStruct fLastPackage;
    private transient Deque<ElementContainer> fStructContainersStack;
    private transient Deque<ElementContainer> fSDLInlineBlockStructContainersStack;
    private transient Deque<RfActionBlockLayer> fActionLayersStack;
    private transient Map<String, Collection<RfSemanticError>> fSemanticErrors;
    private transient Map<ParserPath, DVTEditor> fParserPathToEditorMap;
    private transient boolean fIncremental;
    private transient AsComputedProcessor fAsComputedProcessor;
    private transient ParserPath fTempLastRemovedModuleName;
    private transient int fTempLastRemovedModuleIndex;
    private transient int fTempLastRemovedClusterIndex;
    private transient boolean fTempLastRemovedModuleInTop;
    private transient ParserPath fTempLastRemovedModuleByTestParserPath;
    private transient Map<ParserPath, List<IRfModuleListener>> fModuleListeners;
    private transient long fTimeToRegisterNamedElements;
    private transient long fTimeToResolveTypes;
    private transient long fTimeToResolveIdentifiers;
    private transient long fTimeToResolveAsComputed;
    private transient long fTimeToCheckCustomPragmas;
    private transient boolean fShouldReportCustomPragmas;
    private transient long fLastFullBuildStartTime;
    private transient long fLastFullBuildDuration;
    private transient long fLastFullBuildStartMemory;
    private transient long fLastFullBuildMemoryAllocation;
    private transient RfMixedLangProject fMixedLangProjectParent;
    private transient String fBuildConfig;
    private transient Map<String, ImportGraphNode> fImportNodes = new HashMap<String, ImportGraphNode>();
    private transient Map<String, RfPredefinedScalar> fCachedScalarTypes = new HashMap<String, RfPredefinedScalar>();
    private transient RfProjectState fProjectState = RfProjectState.NEW;
    private transient List<EModuleInfo> fClusterList = new ArrayList<EModuleInfo>();
    private transient Map<ModuleReference, EModuleInfo> fModuleReferenceToEModuleInfoMap;
    private transient List<ModuleReference> fFullBuildModuleReferences;
    private transient List<ModuleReference> fRestoreModuleReferences;
    private transient Object fRestoreModulesLock = new Object();
    private transient Object fSemanticErrorsLock = new Object();
    private transient RfGUIUtils fGUIUtils;
    private transient IProgressMonitor fBuildProgressMonitor;
    private transient int fNofBuildCanceledQueries;
    private transient boolean fCachedBuildCanceled;
    private transient Set<String> fAsComputedTranslateMethodMissing;
    private transient AbstractRfManager fRfManager;
    private transient Set<String> fGlobalPseudoMethods;
    private transient boolean fEnableExtendedSemanticChecks;
    private transient RfTypesUtil fTypesUtil;
    private transient AsComputedMethodsToTranslate fAsComputedMethodsTranslateDisable;
    private transient boolean fAsComputedMethodsTranslateDisableDirty;
    private transient List<RfNamedElement> fAsComputedStore = new ArrayList<RfNamedElement>();
    private transient String fSemanticTemplateDefinitionName;
    private transient ChangedFilesManager fChangedFilesManager;
    private List<StringMatcher> fIncrDepMatchers;
    private transient int fMaxNofSemanticProblemsPerFile;
    public EParser fFullBuildEParser;
    public static final int SEARCH_STRUCT_TYPE_KIND = 1;
    public static final int SEARCH_SCALAR_TYPE_KIND = 2;
    public static final int SEARCH_METHOD_TYPE_KIND = 4;
    public static final int SEARCH_ALL_TYPE_KIND = 7;
    public static final int SEARCH_METHOD_MEMBER_KIND = 1;
    public static final int SEARCH_EVENT_MEMBER_KIND = 2;
    public static final int SEARCH_FIELD_MEMBER_KIND = 4;
    private Map<String, Set<ModuleReference>> fUndeclaredVarNameReferences;
    private Map<String, Set<ModuleReference>> fUndeclaredTypeNameReferences;
    private List<RfStructMember> fAddedVarsInCurrentFile;
    private List<RfType> fAddedTypesInCurrentFile;
    private Map<ModuleReference, Set<ModuleReference>> fDependentModuleReferences;
    private long fLastChangeTimestamp;
    private Set<String> fCustomPragmaFirstIdentifiers;
    private Map<String, CustomPragma> fStartPragmas;
    private Map<String, CustomPragma> fEndPragmas;

    public boolean isInSLNMode() {
        return DVTUtilsCommon.INSTANCE.isInSLNMode(this.getNature());
    }

    public boolean isInSDLMode() {
        return DVTUtilsCommon.INSTANCE.isInSDLMode(this.getNature());
    }

    public boolean isSLNModule(ParserPath parserPath) {
        if (!this.isInSLNMode() || parserPath == null || parserPath.path == null || parserPath.path.isEmpty()) {
            return false;
        }
        String[] slnFileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.slndt.SLNSource", false);
        if (slnFileExtensions == null || slnFileExtensions.length == 0) {
            return false;
        }
        String moduleExtension = Path.fromOSString((String)parserPath.path).getFileExtension();
        if (moduleExtension == null) {
            return false;
        }
        int i = 0;
        while (i < slnFileExtensions.length) {
            String slnFileExtension = slnFileExtensions[i];
            if (moduleExtension.equals(slnFileExtension)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isSDLModule(ParserPath parserPath) {
        return false;
    }

    public String getNature() {
        return this.getPluginConfig().getNature();
    }

    public IEPluginConfig getPluginConfig() {
        return this.fRfManager.getPluginConfig();
    }

    public AbstractEModelManager getModelManager() {
        return this.getPluginConfig().getModelManager();
    }

    private int getMaxSemanticIssuesPerFile() {
        return TestHelper.isTestMode() && TestHelper.isUsingMaxIntSemanticIssuesPerFile() ? Integer.MAX_VALUE : this.fMaxNofSemanticProblemsPerFile;
    }

    public Map<String, ImportGraphNode> getImportNodes() {
        return this.fImportNodes;
    }

    public void setLastFullBuildStartTime() {
        this.fLastFullBuildStartTime = System.currentTimeMillis();
    }

    public long getLastFullBuildDuration() {
        return this.fLastFullBuildDuration;
    }

    private void updateDuration() {
        long tmp = System.currentTimeMillis();
        this.fLastFullBuildDuration = (tmp - this.fLastFullBuildStartTime) / 1000L;
    }

    public void setLastFullBuildStartMemory() {
        this.fLastFullBuildStartMemory = MemUtils.computeUsedMemory((boolean)MemUtils.COLLECT_STATS);
    }

    public long getLastFullBuildMemoryAllocation() {
        return this.fLastFullBuildMemoryAllocation / 0x100000L;
    }

    private void updateMemoryAllocation() {
        long tmp = MemUtils.computeUsedMemory((boolean)MemUtils.COLLECT_STATS);
        this.fLastFullBuildMemoryAllocation = tmp - this.fLastFullBuildStartMemory;
    }

    public void setBuildProgressMonitor(IProgressMonitor buildProgressMonitor) {
        this.fBuildProgressMonitor = buildProgressMonitor;
        this.fNofBuildCanceledQueries = 0;
        this.fCachedBuildCanceled = false;
    }

    private boolean isBuildCanceled() {
        if (this.fGUIUtils != null && this.fGUIUtils.isCancelChecking()) {
            return true;
        }
        if (this.fBuildProgressMonitor == null) {
            return false;
        }
        return this.fBuildProgressMonitor.isCanceled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompiled(ParserPath parserPath) {
        ArrayList<ModuleReference> restoreModuleReferences = null;
        Object object = this.fRestoreModulesLock;
        synchronized (object) {
            if (this.fRestoreModuleReferences == null) {
                return this.fParserPathToModuleMap.containsKey(parserPath);
            }
            restoreModuleReferences = new ArrayList<ModuleReference>(this.fRestoreModuleReferences);
        }
        for (ModuleReference restoreModule : restoreModuleReferences) {
            if (!restoreModule.parserPath.equals((Object)parserPath)) continue;
            return true;
        }
        return false;
    }

    public void checkBuildCanceled() throws BuildCancelException {
        if (this.fNofBuildCanceledQueries % 5000 == 0) {
            this.fCachedBuildCanceled = this.isBuildCanceled();
        }
        ++this.fNofBuildCanceledQueries;
        if (MemoryMonitorState.ERROR.equals((Object)MemoryMonitor.getInstance().getMonitorState())) {
            this.fCachedBuildCanceled = true;
            throw new BuildCancelException();
        }
        if (this.fCachedBuildCanceled) {
            DVTLogger.INSTANCE.logDebug("### E SEMANTIC CANCELED BY USER ###");
            throw new BuildCancelException();
        }
    }

    public RfProject(IProject project, RfMixedLangProject rfMixedLangProject, AbstractRfManager rfManager) {
        super(null, project.getName());
        this.init(project, rfManager, true);
        this.setMixedLangProjectParent(rfMixedLangProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ParserPath> getCompiledFilesSet() {
        Map<ParserPath, RfModule> map = this.fParserPathToModuleMap;
        synchronized (map) {
            HashSet<ParserPath> result = new HashSet<ParserPath>(this.fParserPathToModuleMap.keySet());
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IResource> getCompiledFileResourcesSet() {
        Map<ParserPath, RfModule> map = this.fParserPathToModuleMap;
        synchronized (map) {
            Collection<RfModule> fileDefs = this.fParserPathToModuleMap.values();
            if (fileDefs == null || fileDefs.isEmpty()) {
                return Collections.emptySet();
            }
            LinkedHashSet<IResource> result = new LinkedHashSet<IResource>();
            for (RfModule fileDef : fileDefs) {
                IResource adapter = fileDef.getFileAdapter();
                if (adapter == null) continue;
                result.add(adapter);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSomethingToCompile() {
        Map<ParserPath, RfModule> map = this.fParserPathToModuleMap;
        synchronized (map) {
            return !this.fParserPathToModuleMap.isEmpty();
        }
    }

    public void setMixedLangProjectParent(RfMixedLangProject rfMixedLangProject) {
        this.fMixedLangProjectParent = rfMixedLangProject;
    }

    public RfMixedLangProject getMixedLangProjectParent() {
        return this.fMixedLangProjectParent;
    }

    public void init(IProject project, IDVTRfManager rfManager, boolean shouldRunSemanticChecks) {
        try {
            AsComputedEvolvedClassHandler.INSTANCE.init(this);
            this.fProject = project;
            this.fTypesUtil = new RfTypesUtil(this);
            this.fRfManager = (AbstractRfManager)rfManager;
            this.fSemanticTemplateDefinitionName = null;
            this.fCommentsPreferences = BuildConfigManager.getCommentsPreferences((IProject)this.fProject);
            this.fIsNonStandardCheckEnabled = BuildConfigManager.isNonStandardCheckEnabled((IProject)this.fProject);
            this.fMaxNofSemanticProblemsPerFile = BuildConfigManager.getMaxNofSemanticProblemsPerFile((IProject)this.fProject);
            this.fGUIUtils = new RfGUIUtils();
            this.fSemanticErrorsLock = new Object();
            this.fModuleReferenceToEModuleInfoMap = new LinkedHashMap<ModuleReference, EModuleInfo>();
            this.fFullBuildModuleReferences = new ArrayList<ModuleReference>();
            if (this.fAsComputedJavaClassMap == null) {
                this.fAsComputedJavaClassMap = new HashMap<String, ClassEncap>();
            }
            if (this.fSemanticErrors == null) {
                this.fSemanticErrors = new LinkedHashMap<String, Collection<RfSemanticError>>();
            }
            if (this.fPackages == null) {
                this.fPackages = new LinkedHashMap<String, RfStruct>();
            }
            if (this.fParserPathToModuleMap == null) {
                this.fParserPathToModuleMap = new LinkedHashMap<ParserPath, RfModule>();
            }
            if (this.fMacros == null) {
                this.fMacros = new HashMap<String, RfMacro>();
            }
            if (this.fPreprocs == null) {
                this.fPreprocs = new HashMap<String, RfMacro>();
            }
            if (this.fTableDefines == null) {
                this.fTableDefines = new HashMap<String, RfTableDefine>();
            }
            if (this.fSpecman == null) {
                this.fSpecman = new RfSpecman(this);
            }
            if (this.fInactiveCodeInfos == null) {
                this.fInactiveCodeInfos = new HashMap<ParserPath, RfInactiveCodeFileInfo>();
            }
            this.getAsComputedProcessor();
            this.fAnonymousExpectCounter = 0;
            this.fSDLInlineCounter = 0;
            this.fStructContainersStack = new ArrayDeque<ElementContainer>();
            this.fSDLInlineBlockStructContainersStack = new ArrayDeque<ElementContainer>();
            this.fActionLayersStack = new ArrayDeque<RfActionBlockLayer>();
            this.fBuildConfig = BuildConfigManager.getActiveBuildConfigName((IProject)this.fProject);
            this.fAsComputedMethodsTranslateDisable = new AsComputedMethodsToTranslate(null);
            this.fAsComputedMethodsTranslateDisableDirty = true;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void restoreMixedLangProjectPreElab(IProgressMonitor monitor) {
        if (this.fParserPathToEditorMap != null && !this.fParserPathToEditorMap.isEmpty()) {
            Set<ParserPath> parserPaths = this.fParserPathToEditorMap.keySet();
            this.startSemanticHighlight(parserPaths);
            for (ParserPath parserPath : parserPaths) {
                this.checkCustomPragmas(parserPath);
            }
        }
        this.updateBreadcrumbs();
        this.getPluginConfig().getNameCheckerWarningsManager().clean();
    }

    private void startSemanticHighlight(Set<ParserPath> parserPaths) {
        try {
            if (parserPaths == null || parserPaths.isEmpty() || this.fParserPathToEditorMap == null) {
                ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
                return;
            }
            for (ParserPath parserPath : parserPaths) {
                ro.amiq.edt.base.utils.Utils.startHighlight(this.getPluginConfig().getPlugin(), this.getModule(parserPath), this.fParserPathToEditorMap.get(parserPath));
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void updateBreadcrumbs() {
        Job updateBCJob = new Job("Updating Breadcrumbs..."){

            protected IStatus run(IProgressMonitor monitor) {
                for (IEditorReference edReference : Utils.getCurrentlyOpenEditorReferences()) {
                    IEditorPart editor = edReference.getEditor(false);
                    if (!(editor instanceof DVTEditor)) continue;
                    ro.amiq.edt.base.utils.Utils.startUpdateBreadcrumbs((DVTEditor)editor);
                }
                return Status.OK_STATUS;
            }
        };
        updateBCJob.setSystem(true);
        updateBCJob.schedule();
    }

    public void removeMixedLangProject() {
        IProject project = this.fProject;
        this.clean();
        this.fProjectState = RfProjectState.NEW;
        this.getModelManager().cbClean(project);
    }

    protected int getAnonymousExpectCounter() {
        return this.fAnonymousExpectCounter++;
    }

    protected int getSDLInlineCounter() {
        return this.fSDLInlineCounter++;
    }

    private synchronized void reportBuildStatistics(boolean reportToConsole) {
        if (!reportToConsole) {
            return;
        }
        this.consolePrint("Full build step 1 (RNE) [" + this.fTimeToRegisterNamedElements + " ms] ...");
        this.consolePrint("Full build step 2 (RT) [" + this.fTimeToResolveTypes + " ms] ...");
        this.consolePrint("Full build step 3 (FSC) [" + this.fTimeToResolveIdentifiers + " ms] ...");
        this.consolePrint("Full build step 4 (ASC) [" + this.fTimeToResolveAsComputed + " ms] ...");
        if (this.fShouldReportCustomPragmas) {
            this.consolePrint("Full build step 5 (CP) [" + this.fTimeToCheckCustomPragmas + " ms] ...");
        }
    }

    private void consolePrint(String message) {
        DVTBuildConsoleRegistry.getConsole((IProject)this.fProject).print(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clean() {
        try {
            AsComputedEvolvedClassHandler.INSTANCE.init(this);
            this.fGlobalPseudoMethods = BuildConfigManager.getGlobalPseudomethods((IProject)this.fProject);
            this.fEnableExtendedSemanticChecks = BuildConfigManager.isEnableExtendedSemanticChecks((IProject)this.fProject);
            this.fClusterList.clear();
            AsComputedCompiler.getInstance().clean(true);
            this.fSemanticTemplateDefinitionName = null;
            this.fCommentsPreferences = BuildConfigManager.getCommentsPreferences((IProject)this.fProject);
            this.fIsNonStandardCheckEnabled = BuildConfigManager.isNonStandardCheckEnabled((IProject)this.fProject);
            this.fMaxNofSemanticProblemsPerFile = BuildConfigManager.getMaxNofSemanticProblemsPerFile((IProject)this.fProject);
            this.fAsComputedTranslateMethodMissing = null;
            if (this.fChangedFilesManager != null) {
                this.fChangedFilesManager.clear();
            }
            this.fChangedFilesManager = null;
            this.fFullBuildModuleReferences = new ArrayList<ModuleReference>();
            if (this.fCachedScalarTypes != null) {
                this.fCachedScalarTypes.clear();
            }
            if (this.fDependentModuleReferences != null) {
                this.fDependentModuleReferences.clear();
            }
            if (this.fTypesUtil != null) {
                this.fTypesUtil.clean();
            }
            if (this.fAsComputedProcessor != null) {
                this.fDisableAsComputedSupport = BuildConfigManager.isAsComputedDisabled((IProject)this.fProject);
                this.fAsComputedProcessor.clean();
                this.fAsComputedProcessor.disable(this.fDisableAsComputedSupport);
            }
            if (this.fAsComputedJavaClassMap != null) {
                this.fAsComputedJavaClassMap.clear();
            }
            if (this.fParserPathToModuleMap != null) {
                Map<ParserPath, RfModule> map = this.fParserPathToModuleMap;
                synchronized (map) {
                    for (RfModule module : this.fParserPathToModuleMap.values()) {
                        module.cleanUpModule(this);
                        RfStruct packg = this.getPackage(module.getPackageName());
                        if (packg == null) continue;
                        ParserPath parserPath = module.getParserPath();
                        packg.removeModuleReference(parserPath);
                    }
                    this.fParserPathToModuleMap.clear();
                }
            }
            try {
                this.deepClean();
            }
            catch (Throwable e) {
                DVTLogger.INSTANCE.logError(e);
            }
            this.fModuleReferenceToEModuleInfoMap = new LinkedHashMap<ModuleReference, EModuleInfo>();
            if (this.fSpecman != null) {
                this.fSpecman.clear(this);
            }
            if (this.fImportedTestFiles != null) {
                this.fImportedTestFiles.clear();
            }
            if (this.fInactiveCodeInfos != null) {
                this.fInactiveCodeInfos.clear();
            }
            this.cleanContext();
            this.cleanTemporaryModuleInfo();
            this.cleanSemanticProblems();
            this.fAnonymousExpectCounter = 0;
            this.fImportNodes.clear();
            this.fAsComputedStore.clear();
            this.fTimeToRegisterNamedElements = 0L;
            this.fTimeToResolveTypes = 0L;
            this.fTimeToResolveIdentifiers = 0L;
            this.fTimeToResolveAsComputed = 0L;
            this.fAsComputedMethodsTranslateDisable = new AsComputedMethodsToTranslate(null);
            this.fAsComputedMethodsTranslateDisableDirty = true;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public RfTypesUtil getTypesUtil() {
        if (this.fTypesUtil == null) {
            this.fTypesUtil = new RfTypesUtil(this);
        }
        return this.fTypesUtil;
    }

    @Override
    public void deepClean() {
        try {
            if (this.fModuleReferenceToEModuleInfoMap != null && !this.fModuleReferenceToEModuleInfoMap.isEmpty()) {
                for (EModuleInfo info : this.fModuleReferenceToEModuleInfoMap.values()) {
                    info.cleanModuleAST();
                }
            }
            if (this.fPackages != null && !this.fPackages.isEmpty()) {
                for (RfStruct packg : this.fPackages.values()) {
                    packg.deepClean();
                }
                this.fPackages.clear();
            }
            if (this.fMacros != null && !this.fMacros.isEmpty()) {
                for (RfMacro macro : this.fMacros.values()) {
                    macro.deepClean();
                }
                this.fMacros.clear();
            }
            if (this.fPreprocs != null && !this.fPreprocs.isEmpty()) {
                for (RfMacro preproc : this.fPreprocs.values()) {
                    preproc.deepClean();
                }
                this.fPreprocs.clear();
            }
            if (this.fTableDefines != null && !this.fTableDefines.isEmpty()) {
                for (RfTableDefine tableDefine : this.fTableDefines.values()) {
                    tableDefine.deepClean();
                }
                this.fTableDefines.clear();
            }
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    private void cleanSemanticProblems() {
        try {
            if (this.fSemanticErrors == null) {
                this.fSemanticErrors = new HashMap<String, Collection<RfSemanticError>>();
            } else {
                this.fSemanticErrors.clear();
            }
            this.getPluginConfig().getSemanticErrorManager().clean(this.fProject);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void cleanSemanticProblems(Collection<ModuleReference> references, ParserPath skipParserPath) {
        try {
            if (this.fSemanticErrors == null) {
                return;
            }
            HashSet<ParserPath> alreadyDeleted = new HashSet<ParserPath>();
            if (references != null) {
                for (ModuleReference reference : references) {
                    if (skipParserPath != null && skipParserPath.equals((Object)reference.parserPath) || alreadyDeleted.contains(reference.parserPath)) continue;
                    alreadyDeleted.add(reference.parserPath);
                    String resourcePath = this.parser2resource(reference.parserPath);
                    this.fSemanticErrors.remove(resourcePath);
                }
            }
            this.getPluginConfig().getSemanticErrorManager().clean(this.fProject);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void build(EModuleInfo info, boolean incrementalBuild, boolean saveRFDM) {
        ParserPath parserPath = info.getParserPath();
        try {
            this.checkBuildCanceled();
            this.updateAsComputedMethodsTranslateDisable();
            this.fLastChangeTimestamp = this.getTimestamp(this.fLastChangeTimestamp);
            AsComputedCompiler.getInstance().clean(false);
            this.fAsComputedProcessor.newClassLoader();
            this.fIncremental = incrementalBuild;
            ModuleReference moduleReference = new ModuleReference(parserPath, info.getModuleIndex());
            this.fIncrDepMatchers = this.computeIncrDepMatchers();
            if (incrementalBuild) {
                this.initNewDefinedElementsInCurrentFile(true);
                this.cleanSemanticProblems(Collections.singletonList(moduleReference), null);
            } else {
                if (this.fFullBuildModuleReferences == null) {
                    this.fFullBuildModuleReferences = new ArrayList<ModuleReference>();
                }
                this.fFullBuildModuleReferences.add(moduleReference);
                this.setTestFileImported(parserPath, info.getImportedByTest());
                if (!info.isInTop() && this.fModuleReferenceToEModuleInfoMap.containsKey(moduleReference)) {
                    return;
                }
            }
            int clusterNofModules = info.getClusterNofModules();
            boolean isAutoTranslateDisable = BuildConfigManager.isAsComputedAutoMethodsTranslateDisable((IProject)this.getProject());
            this.fModuleReferenceToEModuleInfoMap.put(moduleReference, info);
            this.registerRfElements(info);
            if (incrementalBuild) {
                this.cleanDirtyElements();
                this.fClusterList.clear();
                this.fClusterList.add(info);
                this.resolveSemanticInCluster(this.fClusterList, isAutoTranslateDisable);
                ArrayList<ModuleReference> dependentTopModuleReferences = new ArrayList<ModuleReference>();
                HashMap<ParserPath, ArrayList<ModuleReference>> dependentTestModuleReferencesMap = new HashMap<ParserPath, ArrayList<ModuleReference>>();
                RfModule module = this.getModule(parserPath);
                if (module != null) {
                    List dependentModuleReferences = this.getSemanticDependentModuleReferences(moduleReference);
                    this.cleanSemanticProblems(dependentModuleReferences, parserPath);
                    Collections.sort(dependentModuleReferences);
                    for (ModuleReference dependentModuleReference : dependentModuleReferences) {
                        RfModule dependentModule;
                        EModuleInfo moduleInfo = this.getModuleInfo(dependentModuleReference);
                        if (moduleInfo == null) continue;
                        this.checkBuildCanceled();
                        if (this.matchesIncrDepMatchers(dependentModuleReference.parserPath) || (dependentModule = this.getModule(dependentModuleReference.parserPath)) == null) continue;
                        if (dependentModule.isInTop()) {
                            dependentTopModuleReferences.add(dependentModuleReference);
                            continue;
                        }
                        ParserPath byParserPath = dependentModule.fImportedByTest;
                        if (byParserPath == null) continue;
                        ArrayList<ModuleReference> references = (ArrayList<ModuleReference>)dependentTestModuleReferencesMap.get(byParserPath);
                        if (references == null) {
                            references = new ArrayList<ModuleReference>();
                            dependentTestModuleReferencesMap.put(byParserPath, references);
                        }
                        references.add(dependentModuleReference);
                    }
                }
                if (!dependentTopModuleReferences.isEmpty()) {
                    int lastClusterIndex = -1;
                    this.fClusterList.clear();
                    for (ModuleReference dependentModuleReference : dependentTopModuleReferences) {
                        EModuleInfo moduleInfo = this.getModuleInfo(dependentModuleReference);
                        if (moduleInfo == null) continue;
                        this.checkBuildCanceled();
                        if (lastClusterIndex < moduleInfo.getClusterIndex()) {
                            lastClusterIndex = moduleInfo.getClusterIndex();
                            if (!this.fClusterList.isEmpty()) {
                                this.resolveSemanticInCluster(this.fClusterList, isAutoTranslateDisable);
                            }
                            this.fClusterList.clear();
                            this.fClusterList.add(moduleInfo);
                            continue;
                        }
                        this.fClusterList.add(moduleInfo);
                    }
                    if (!this.fClusterList.isEmpty()) {
                        this.resolveSemanticInCluster(this.fClusterList, isAutoTranslateDisable);
                    }
                }
                if (!dependentTestModuleReferencesMap.isEmpty()) {
                    int lastClusterIndex = -1;
                    for (List dependentModuleReferences : dependentTestModuleReferencesMap.values()) {
                        this.fClusterList.clear();
                        this.checkBuildCanceled();
                        for (ModuleReference dependentModuleReference : dependentModuleReferences) {
                            EModuleInfo moduleInfo = this.getModuleInfo(dependentModuleReference);
                            if (moduleInfo == null) continue;
                            this.checkBuildCanceled();
                            if (lastClusterIndex < moduleInfo.getClusterIndex()) {
                                lastClusterIndex = moduleInfo.getClusterIndex();
                                if (!this.fClusterList.isEmpty()) {
                                    this.resolveSemanticInCluster(this.fClusterList, isAutoTranslateDisable);
                                }
                                this.fClusterList.clear();
                                this.fClusterList.add(moduleInfo);
                                continue;
                            }
                            this.fClusterList.add(moduleInfo);
                        }
                        if (this.fClusterList.isEmpty()) continue;
                        this.resolveSemanticInCluster(this.fClusterList, isAutoTranslateDisable);
                    }
                }
            } else {
                this.fClusterList.add(info);
                if (this.fClusterList.size() == clusterNofModules) {
                    this.resolveSemanticInCluster(this.fClusterList, isAutoTranslateDisable);
                    this.fClusterList.clear();
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError("RfProject.build()", (Throwable)e);
        }
        try {
            if (incrementalBuild) {
                this.setCustomPragmas();
                this.checkCustomPragmas(parserPath);
                if (this.fParserPathToEditorMap != null) {
                    DVTEditor editor = this.fParserPathToEditorMap.get(parserPath);
                    this.connectModuleToDocument(this.getPluginConfig().getEditorID(), parserPath, editor, false);
                }
                this.notifyParsingEndUsingParserPath(parserPath);
                ro.amiq.edt.base.utils.Utils.triggerSemanticMarkers(this.getPluginConfig(), this.fProject, this.fSemanticErrors, false);
            }
            this.cleanContext();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError("RfProject.build()", (Throwable)e);
        }
    }

    private boolean matchesIncrDepMatchers(ParserPath parserPath) {
        if (this.fIncrDepMatchers == null || parserPath == null || parserPath.path == null) {
            return false;
        }
        for (StringMatcher sm : this.fIncrDepMatchers) {
            if (!sm.match(parserPath.path)) continue;
            return true;
        }
        return false;
    }

    private List<StringMatcher> computeIncrDepMatchers() {
        List incrCompileDeps = BuildConfigManager.getSkipIncrementalCompileDeps((IProject)this.fProject);
        if (incrCompileDeps == null || incrCompileDeps.isEmpty()) {
            return null;
        }
        return incrCompileDeps.stream().map(s -> new StringMatcher(s, false, false)).collect(Collectors.toList());
    }

    private long getTimestamp(long prevTimestamp) {
        long timestamp = System.currentTimeMillis();
        if (prevTimestamp >= timestamp) {
            timestamp = prevTimestamp + 1L;
        }
        return timestamp;
    }

    private void registerRfElements(EModuleInfo info) {
        AST pAST = info.getModuleAST();
        if (pAST != null) {
            this.fTimeToRegisterNamedElements -= System.currentTimeMillis();
            try {
                RfWalker walker = new RfWalker(this, info);
                walker.setCommentsPreferences(this.fCommentsPreferences);
                walker.getASTFactory().setASTNodeClass(EAST.class);
                walker.program(pAST);
                if (walker.getAST() != null) {
                    TestHelper.out.println("*** INTERNAL ERROR: walker AST is not null.");
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError("RfProject.build()", (Throwable)e);
            }
            this.fTimeToRegisterNamedElements += System.currentTimeMillis();
        }
    }

    private void resolveSemanticInCluster(List<EModuleInfo> cluster, boolean isAutoTranslateDisable) {
        TreeParser walker;
        RfModule module;
        ParserPath parserPath;
        AST pAST;
        EModuleInfo info;
        IEProject eProject = this.getModelManager().getEModel().getEProject(this.fProject);
        int i = 0;
        while (i < cluster.size()) {
            this.checkBuildCanceled();
            info = cluster.get(i);
            pAST = info.getModuleAST();
            parserPath = info.getParserPath();
            module = this.getModule(parserPath);
            if (module != null) {
                this.checkBuildCanceled();
                this.fTimeToResolveTypes -= System.currentTimeMillis();
                try {
                    if (pAST != null) {
                        walker = new TypesWalker(this, info, module);
                        walker.getASTFactory().setASTNodeClass(EAST.class);
                        walker.program(pAST);
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError("RfProject.build()", (Throwable)e);
                }
                this.fTimeToResolveTypes += System.currentTimeMillis();
            }
            ++i;
        }
        this.fLastChangeTimestamp = this.getTimestamp(this.fLastChangeTimestamp);
        i = 0;
        while (i < cluster.size()) {
            this.checkBuildCanceled();
            info = cluster.get(i);
            pAST = info.getModuleAST();
            parserPath = info.getParserPath();
            module = this.getModule(parserPath);
            if (module != null) {
                this.checkBuildCanceled();
                this.fTimeToResolveIdentifiers -= System.currentTimeMillis();
                try {
                    if (pAST != null) {
                        walker = new SemanticWalker(this, info, module, this.fIncremental);
                        walker.getASTFactory().setASTNodeClass(EAST.class);
                        walker.program(pAST);
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError("RfProject.build()", (Throwable)e);
                }
                this.fTimeToResolveIdentifiers += System.currentTimeMillis();
                this.debugSemanticWalker(false, info, module, pAST);
            }
            ++i;
        }
        i = 0;
        while (i < cluster.size()) {
            this.checkBuildCanceled();
            info = cluster.get(i);
            pAST = info.getModuleAST();
            parserPath = info.getParserPath();
            module = this.getModule(parserPath);
            if (module != null) {
                this.checkBuildCanceled();
                this.fTimeToResolveAsComputed -= System.currentTimeMillis();
                try {
                    if (pAST != null && !this.fDisableAsComputedSupport) {
                        this.fAsComputedProcessor.newClassLoader();
                        walker = new AsComputedWalker(this, info, module, eProject, isAutoTranslateDisable);
                        walker.getASTFactory().setASTNodeClass(EAST.class);
                        walker.program(pAST);
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError("RfProject.build()", (Throwable)e);
                }
                this.fTimeToResolveAsComputed += System.currentTimeMillis();
                try {
                    if (AbstractTestHelper.isRecordIdentifiers()) {
                        walker = new IdentifiersWalker(this, info.getParserPath());
                        walker.program(pAST);
                    }
                    if (pAST != null) {
                        walker = new ImportGraphWalker();
                        walker.setImportNodes(this.fImportNodes);
                        walker.program(pAST);
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError("RfProject.build()", (Throwable)e);
                }
            }
            ++i;
        }
    }

    public void startSDLInlineBlockWalk() {
        this.fSDLInlineBlockStructContainersStack.push(new ElementContainer(this.fLastStructLayer, this.fLastStruct));
    }

    public void endSDLInlineBlockWalk() {
        if (!this.fSDLInlineBlockStructContainersStack.isEmpty()) {
            ElementContainer container = this.fSDLInlineBlockStructContainersStack.pop();
            this.fLastStructLayer = (RfStructLayer)container.def;
            this.fLastStruct = (RfStruct)container.element;
        }
    }

    public void parseSDLInlineBlock(AST scenarioInvocationAST, AST inlineBlockAST, RfModule module, RfStruct invokingScenario, RfStruct invokedScenario, List<RfField> assignedParams) {
        TreeParser walker;
        if (scenarioInvocationAST == null || inlineBlockAST == null || invokingScenario == null || invokedScenario == null || !invokingScenario.isSDLScenario() || !invokedScenario.isSDLScenario()) {
            return;
        }
        RfStruct invokingAgent = invokingScenario.getSDLEnclosingAgent();
        if (invokingAgent == null) {
            return;
        }
        String bigInlineBlockText = "";
        String invocationLabel = ((EAST)scenarioInvocationAST).getMeta("sdl_label");
        String parentInvocationLabel = ((EAST)scenarioInvocationAST).getMeta("parent_sdl_label");
        String uncleInvocationLabel = ((EAST)scenarioInvocationAST).getMeta("ref_sdl_label");
        List<RfSDLInlineSMLayer> inlines = invokedScenario.getSDLInlineLayers();
        for (RfSDLInlineSMLayer inline : inlines) {
            String inlineBlockText = null;
            String argName = inline.getArgName();
            if (argName != null) {
                boolean replaceInlineText = false;
                if (assignedParams != null) {
                    for (RfField assignedParam : assignedParams) {
                        if (assignedParam == null || !argName.equals(assignedParam.getName())) continue;
                        replaceInlineText = true;
                        break;
                    }
                }
                if (replaceInlineText) {
                    inlineBlockText = inline.getInlineText();
                    if (invocationLabel != null && inlineBlockText != null) {
                        String fieldPattern = String.valueOf(argName) + "\\?";
                        if (uncleInvocationLabel != null) {
                            inlineBlockText = inlineBlockText.replaceAll(fieldPattern, uncleInvocationLabel);
                        }
                    }
                } else {
                    inlineBlockText = inline.getInlineElseText();
                }
            } else {
                inlineBlockText = inline.getInlineText();
            }
            if (inlineBlockText == null || inlineBlockText.length() == 0) continue;
            if (invocationLabel != null) {
                inlineBlockText = inlineBlockText.replaceAll("name\\?", invocationLabel);
                inlineBlockText = inlineBlockText.replaceAll("value\\?\\((?<id>\\w+)\\s*\\)", String.valueOf(invocationLabel) + "." + "${id}");
            }
            if (parentInvocationLabel != null) {
                inlineBlockText = inlineBlockText.replaceAll("context\\?", parentInvocationLabel);
            }
            bigInlineBlockText = String.valueOf(bigInlineBlockText) + inlineBlockText + ";";
        }
        if (bigInlineBlockText.isEmpty()) {
            return;
        }
        bigInlineBlockText = "<'\nextend " + invokingAgent.getName() + "::" + invokingScenario.getName() + " {" + bigInlineBlockText + "};" + "\n'>";
        IResource fileAdapter = module.getFileAdapter();
        if (!(fileAdapter instanceof IFile)) {
            return;
        }
        IEModule eModule = this.getModelManager().getEModel().getOrCreateEModule((IFile)fileAdapter);
        if (!(eModule instanceof AbstractEModule)) {
            return;
        }
        ((AbstractEModule)eModule).parseSDLInlineBlock(scenarioInvocationAST, bigInlineBlockText);
        AST extendAST = ((AbstractEModule)eModule).getSDLInlineBlockAST();
        if (extendAST == null) {
            return;
        }
        if ((extendAST = extendAST.getFirstChild()) == null) {
            return;
        }
        if ((extendAST = extendAST.getFirstChild()) == null) {
            return;
        }
        if ((extendAST = extendAST.getFirstChild()) == null) {
            return;
        }
        inlineBlockAST.addChild(extendAST);
        EModuleInfo info = this.getModuleInfo(module.getModuleReference());
        try {
            walker = new RfWalker(this, info);
            walker.setCommentsPreferences(this.fCommentsPreferences);
            walker.getASTFactory().setASTNodeClass(EAST.class);
            this.fLastModule = module;
            this.fLastPackage = this.getPackage(this.fLastModule.getPackageName());
            walker.inMacro(scenarioInvocationAST);
            walker.extend_struct_statement(extendAST);
            if (walker.getAST() != null) {
                TestHelper.out.println("*** INTERNAL ERROR: walker AST is not null.");
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError("RfProject.build()", (Throwable)e);
        }
        try {
            walker = new TypesWalker(this, info, module);
            walker.getASTFactory().setASTNodeClass(EAST.class);
            walker.inMacro(scenarioInvocationAST);
            walker.extend_struct_statement(extendAST);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError("RfProject.build()", (Throwable)e);
        }
        try {
            walker = new SemanticWalker(this, info, module, this.fIncremental);
            walker.getASTFactory().setASTNodeClass(EAST.class);
            walker.inMacro(scenarioInvocationAST);
            walker.extend_struct_statement(extendAST);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError("RfProject.build()", (Throwable)e);
        }
        inlineBlockAST.setFirstChild(null);
    }

    private final void debugSemanticWalker(boolean debugMode, EModuleInfo info, RfModule module, AST pAST) {
        try {
            if (!debugMode) {
                return;
            }
            if (pAST != null) {
                DebugSemanticWalker walker = new DebugSemanticWalker(this, info, module);
                walker.getASTFactory().setASTNodeClass(EAST.class);
                walker.program(pAST);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void addIdentifier(AST id, ParserPath parserPath) {
        AbstractTestHelper.addIdentifier((EAST)id, parserPath.path);
    }

    public boolean isNonStandardSemanticEnabled() {
        return this.fIsNonStandardCheckEnabled;
    }

    public void clean(IEModule eModule) {
        this.fClusterList.clear();
        this.fCommentsPreferences = BuildConfigManager.getCommentsPreferences((IProject)this.fProject);
        this.fIsNonStandardCheckEnabled = BuildConfigManager.isNonStandardCheckEnabled((IProject)this.fProject);
        this.fMaxNofSemanticProblemsPerFile = BuildConfigManager.getMaxNofSemanticProblemsPerFile((IProject)this.fProject);
        this.remove(eModule);
    }

    protected void remove(IEModule eModule) {
        ParserPath parserPath = eModule.getParserPath();
        if (parserPath != null) {
            this.removeModuleContent(parserPath);
        }
    }

    public void postFullBuild(boolean writeRFDM, boolean reportToConsole) {
        Iterator<ImportGraphNode> it = this.fImportNodes.values().iterator();
        while (it.hasNext()) {
            if (it.next().getPath() != null) continue;
            it.remove();
        }
        DVTLogger.INSTANCE.logDebug("AS_COMPUTED: Total generation time = " + this.fAsComputedProcessor.totalGenerationType);
        DVTLogger.INSTANCE.logDebug("AS_COMPUTED: Total compilation time = " + this.fAsComputedProcessor.totalCompilerTime);
        DVTLogger.INSTANCE.logDebug("AS_COMPUTED: Total execution time = " + this.fAsComputedProcessor.totalExecutionType);
        this.fAsComputedProcessor.totalGenerationType = 0L;
        this.fAsComputedProcessor.totalCompilerTime = 0L;
        this.fAsComputedProcessor.totalExecutionType = 0L;
        this.fGUIUtils.resetTimer();
        this.activeTestChangedNotification();
        this.updateDuration();
        this.updateMemoryAllocation();
        if (writeRFDM) {
            this.fRfManager.writeRFDM(this);
        }
        if (!this.fDisableAsComputedSupport && this.fAsComputedProcessor.getJavaCompilerError()) {
            ro.amiq.edt.base.utils.Utils.runOnDisplayThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        File file = new File(System.getProperty("java.home"));
                        if (file.getName().equalsIgnoreCase("jre")) {
                            file = file.getParentFile();
                        }
                        if (PlatformUI.getWorkbench() != null) {
                            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"'as computed' Macros Support", (String)("Java compiler needed for 'as computed' macros execution is missing\n(missing package: " + file.getAbsolutePath() + File.separator + "lib" + File.separator + "tools.jar).\n\n" + "Please invoke Eclipse using Java JDK 1.8 (http://java.sun.com).\n\n" + "The support for 'as computed' macros in the current DVT version is limited.\n\n" + "Set the system variable DVT_AS_COMPUTED_DISABLE to TRUE in order to disable this message and the 'as computed' support."));
                        }
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            });
        }
        this.setCustomPragmas();
        this.fShouldReportCustomPragmas = false;
        this.fTimeToCheckCustomPragmas -= System.currentTimeMillis();
        for (ParserPath parserPath : this.getCompiledFilesSet()) {
            if (!this.checkCustomPragmas(parserPath)) continue;
            this.fShouldReportCustomPragmas = true;
        }
        this.fTimeToCheckCustomPragmas += System.currentTimeMillis();
        ro.amiq.edt.base.utils.Utils.connectActiveOpenEditor(this.getPluginConfig().getEditorID(), this);
        ro.amiq.edt.base.utils.Utils.triggerSemanticMarkers(this.getPluginConfig(), this.fProject, this.fSemanticErrors, true);
        DVTProblemCategory category = this.isInSLNMode() ? EProblemCategories.SLN_NAME_CHECKING : EProblemCategories.E_NAME_CHECKING;
        DVTProblemsUiUpdater dvtProblemsUiUpdater = DVTProblemsUiUpdaterRegistry.get((String)category.getId());
        dvtProblemsUiUpdater.update(this.fProject);
        dvtProblemsUiUpdater.scheduleObjectionsClear(this.fProject);
        this.reportBuildStatistics(true);
        DVTProblemManager.getInstance().save(this.fProject);
    }

    public Map<ParserPath, DVTEditor> getFileEditors() {
        return this.fParserPathToEditorMap;
    }

    public void postMixedLangFullBuild() {
        try {
            try {
                this.fBuildConfig = BuildConfigManager.getActiveBuildConfigName((IProject)this.fProject);
                if (this.fParserPathToEditorMap != null && !this.fParserPathToEditorMap.isEmpty()) {
                    this.startSemanticHighlight(this.fParserPathToEditorMap.keySet());
                }
                this.updateBreadcrumbs();
                this.getPluginConfig().getNameCheckerWarningsManager().clean();
            }
            catch (BuildCancelException buildCancelException) {
                DVTMixedLangModelManager.getInstance().notifyBuildStatusListeners(this.isBuildCanceled());
                this.setBuildProgressMonitor(null);
            }
        }
        finally {
            DVTMixedLangModelManager.getInstance().notifyBuildStatusListeners(this.isBuildCanceled());
            this.setBuildProgressMonitor(null);
        }
    }

    public void postMixedLangIncrementalBuild(Set<FileCompileInfo> changedFiles, Set<String> updateViewsIds) {
        Set<ParserPath> changedParserPaths;
        if (updateViewsIds != null) {
            if (TestHelper.isTestMode()) {
                updateViewsIds.addAll(ViewsUtils.ALL_VIEWS);
            } else {
                updateViewsIds.addAll(ViewsUtils.ALL_BUT_DH_VIEWS);
            }
        }
        if ((changedParserPaths = this.resource2parser(changedFiles)) != null && !changedFiles.isEmpty()) {
            this.startSemanticHighlight(changedParserPaths);
        }
        if (changedFiles == null || changedFiles.isEmpty()) {
            DVTProblemsUiUpdaterRegistry.get((String)EProblemCategories.E_SYNTAX.getId()).scheduleObjectionsClear(this.fProject);
            DVTProblemsUiUpdaterRegistry.get((String)EProblemCategories.E_SEMANTIC.getId()).scheduleObjectionsClear(this.fProject);
            DVTProblemCategory nameCheckingCategory = this.isInSLNMode() ? EProblemCategories.SLN_NAME_CHECKING : EProblemCategories.E_NAME_CHECKING;
            DVTProblemsUiUpdaterRegistry.get((String)nameCheckingCategory.getId()).scheduleObjectionsClear(this.fProject);
        }
        this.updateBreadcrumbs();
        Display.getDefault().asyncExec(() -> FWidgetFactory.INSTANCE.paint(false, FWidgetType.DB_OUT_OF_SYNC));
        this.getPluginConfig().getNameCheckerWarningsManager().clean();
    }

    protected void activeTestChangedNotification() {
        this.reindexModules(this.getActiveTest(), this.getTests());
        this.rearrangeLayers();
    }

    private RfModule getActiveTest() {
        IEProject eProject = this.getModelManager().getEModel().getEProject(this.fProject);
        ParserPath parserPath = eProject.getActiveTest();
        if (parserPath == null) {
            return null;
        }
        return this.getModule(parserPath);
    }

    private List<RfModule> getTests() {
        ArrayList<RfModule> result = new ArrayList<RfModule>();
        IEProject eProject = this.getModelManager().getEModel().getEProject(this.fProject);
        List<ParserPath> testFullPaths = eProject.getNonActiveTests();
        if (testFullPaths == null) {
            return result;
        }
        for (ParserPath parserPath : testFullPaths) {
            RfModule module = this.getModule(parserPath);
            if (module == null) continue;
            result.add(module);
        }
        return result;
    }

    public Set<RfModule> getAllTests() {
        RfModule activeTest = this.getActiveTest();
        List<RfModule> tests = this.getTests();
        LinkedHashSet<RfModule> result = new LinkedHashSet<RfModule>(tests);
        if (activeTest != null) {
            result.add(activeTest);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RfModule[] getImportedModules() {
        Map<ParserPath, RfModule> map = this.fParserPathToModuleMap;
        synchronized (map) {
            ArrayList<RfModule> imported = new ArrayList<RfModule>();
            for (RfModule module : this.fParserPathToModuleMap.values()) {
                if (module.getName().startsWith(this.getPluginConfig().getTopPathPrefix()) || module.getModuleIndex() <= -1) continue;
                imported.add(module);
            }
            int loadedByTestLength = 0;
            int loadedByTopLength = imported.size();
            RfModule[] sorted = new RfModule[loadedByTopLength + loadedByTestLength];
            Arrays.sort(imported.toArray(sorted), 0, loadedByTopLength, this.fRfManager.fModuleSorter);
            return sorted;
        }
    }

    private void reindexModules(RfModule activeTest, List<RfModule> testModules) {
        if (activeTest == null || testModules == null) {
            return;
        }
        ArrayList<IFile> refreshList = new ArrayList<IFile>();
        IFile iFile = (IFile)activeTest.getAdapter(IResource.class);
        PropertiesManager.addSessionProperty((IResource)iFile, (String)PropertyTypes.QN_ACTIVE_TEST_FILE, (String)"*");
        ParserPath activeTestParserPath = activeTest.getParserPath();
        for (Map.Entry<ParserPath, Set<ParserPath>> importedTestFileEntry : this.fImportedTestFiles.entrySet()) {
            Set<ParserPath> testImportedParserPaths;
            ParserPath testModuleParserPath = importedTestFileEntry.getKey();
            RfModule testModule = this.getModule(testModuleParserPath);
            if (testModule == null || testModule.isInTop() || (testImportedParserPaths = importedTestFileEntry.getValue()) == null || testImportedParserPaths.isEmpty()) continue;
            for (ParserPath topTestParserPath : testImportedParserPaths) {
                if (activeTestParserPath.equals((Object)topTestParserPath)) {
                    testModule.fIsInActiveTest = true;
                    iFile = (IFile)testModule.getAdapter(IResource.class);
                    if (iFile == null) continue;
                    PropertiesManager.addSessionProperty((IResource)iFile, (String)PropertyTypes.QN_ACTIVE_TEST_FILE, (String)"*");
                    if (refreshList.contains(iFile)) continue;
                    refreshList.add(iFile);
                    continue;
                }
                testModule.fIsInActiveTest = false;
            }
        }
        DVTAbstractDecorator.refresh((String)"ro.amiq.dvt.CompiledFileDecorator", (Object[])refreshList.toArray());
    }

    private synchronized void rearrangeLayers() {
        for (RfStruct packg : this.fPackages.values()) {
            packg.rearrangeLayers();
        }
    }

    private void cleanContext() {
        try {
            this.fLastPackage = null;
            this.fLastModule = null;
            this.fLastStruct = null;
            this.fLastMethod = null;
            this.fLastStructLayer = null;
            this.fLastMethodLayer = null;
            this.fLastCoverLayer = null;
            this.fLastMacroLayer = null;
            this.fLastPerUnitInstance = null;
            this.fStructContainersStack.clear();
            this.fSDLInlineBlockStructContainersStack.clear();
            this.fActionLayersStack.clear();
            if (this.fAddedVarsInCurrentFile != null) {
                this.fAddedVarsInCurrentFile.clear();
            }
            if (this.fAddedTypesInCurrentFile != null) {
                this.fAddedTypesInCurrentFile.clear();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public synchronized void removeModuleContent(ParserPath parserPath) {
        RfModule module = this.getModule(parserPath);
        if (module == null) {
            return;
        }
        this.saveTemporaryModuleInfo(parserPath, module);
        module.cleanUpModule(this);
        RfStruct packg = this.getPackage(module.getPackageName());
        if (packg != null) {
            packg.removeModuleReference(parserPath);
        }
    }

    private void saveTemporaryModuleInfo(ParserPath parserPath, RfModule module) {
        this.fTempLastRemovedModuleName = parserPath;
        this.fTempLastRemovedModuleIndex = module.getModuleIndex();
        this.fTempLastRemovedClusterIndex = module.getClusterIndex();
        this.fTempLastRemovedModuleInTop = module.fIsInTop;
        this.fTempLastRemovedModuleByTestParserPath = module.fImportedByTest;
    }

    private void cleanTemporaryModuleInfo() {
        this.fTempLastRemovedModuleName = null;
        this.fTempLastRemovedModuleIndex = 0;
        this.fTempLastRemovedClusterIndex = 0;
        this.fTempLastRemovedModuleInTop = false;
        this.fTempLastRemovedModuleByTestParserPath = null;
    }

    public ScopeInfo getScopeInfo() {
        ScopeInfo result = new ScopeInfo();
        result.fLastPackage = this.fLastPackage;
        result.fLastModule = this.fLastModule;
        result.fLastStruct = this.fLastStruct;
        result.fLastMethod = this.fLastMethod;
        result.fLastStructLayer = this.fLastStructLayer;
        result.fLastMethodLayer = this.fLastMethodLayer;
        result.fLastCoverLayer = this.fLastCoverLayer;
        result.fLastMacroLayer = this.fLastMacroLayer;
        result.fLastPerUnitInstance = this.fLastPerUnitInstance;
        return result;
    }

    public void setScopeInfo(ScopeInfo scopeInfo) {
        this.fLastPackage = scopeInfo.fLastPackage;
        this.fLastModule = scopeInfo.fLastModule;
        this.fLastStruct = scopeInfo.fLastStruct;
        this.fLastMethod = scopeInfo.fLastMethod;
        this.fLastStructLayer = scopeInfo.fLastStructLayer;
        this.fLastMethodLayer = scopeInfo.fLastMethodLayer;
        this.fLastCoverLayer = scopeInfo.fLastCoverLayer;
        this.fLastMacroLayer = scopeInfo.fLastMacroLayer;
        this.fLastPerUnitInstance = scopeInfo.fLastPerUnitInstance;
    }

    public void addIdentifier(AST id) {
        if (this.fLastModule == null || this.fLastModule.isInternalModule()) {
            return;
        }
        this.fLastModule.addIdentifier(id);
    }

    @Override
    public LanguageKind getLanguageKind() {
        return this.getPluginConfig().getLanguageKind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RfModule encryptedModule(ParserPath parserPath, int clusterIndex, int moduleIndex, int maxModuleIndex, int invocationIndex, boolean isInTop, ParserPath byTestParserPath) {
        String startName = Path.fromOSString((String)parserPath.path).lastSegment();
        this.removeModuleContent(parserPath);
        if (this.fIncremental && parserPath.equals((Object)this.fTempLastRemovedModuleName)) {
            clusterIndex = this.fTempLastRemovedClusterIndex;
            moduleIndex = this.fTempLastRemovedModuleIndex;
            byTestParserPath = this.fTempLastRemovedModuleByTestParserPath;
            isInTop = this.fTempLastRemovedModuleInTop;
        }
        RfModule module = new RfModule(startName, clusterIndex, moduleIndex, maxModuleIndex, invocationIndex, parserPath, isInTop, byTestParserPath, this, true, false, this.getPluginConfig());
        Map<ParserPath, RfModule> map = this.fParserPathToModuleMap;
        synchronized (map) {
            this.fParserPathToModuleMap.put(parserPath, module);
        }
        this.fLastModule = module;
        this.startPackage("main");
        this.fLastModule.setExplicitPackage(false);
        return this.fLastModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RfModule startModule(ParserPath parserPath, int clusterIndex, int moduleIndex, int maxModuleIndex, int invocationIndex, boolean isInTop, ParserPath byTestParserPath, boolean isDVTEncrypted) {
        String startName = Path.fromOSString((String)parserPath.path).lastSegment();
        this.removeModuleContent(parserPath);
        if (this.fIncremental && parserPath.equals((Object)this.fTempLastRemovedModuleName)) {
            clusterIndex = this.fTempLastRemovedClusterIndex;
            moduleIndex = this.fTempLastRemovedModuleIndex;
            byTestParserPath = this.fTempLastRemovedModuleByTestParserPath;
            isInTop = this.fTempLastRemovedModuleInTop;
        }
        RfModule module = new RfModule(startName, clusterIndex, moduleIndex, maxModuleIndex, invocationIndex, parserPath, isInTop, byTestParserPath, this, false, isDVTEncrypted, this.getPluginConfig());
        Map<ParserPath, RfModule> map = this.fParserPathToModuleMap;
        synchronized (map) {
            this.fParserPathToModuleMap.put(parserPath, module);
        }
        this.fLastModule = module;
        this.startPackage("main");
        this.fLastModule.setExplicitPackage(false);
        if (this.fInactiveCodeInfos != null) {
            this.fInactiveCodeInfos.remove(parserPath);
        }
        return this.fLastModule;
    }

    public void endModule() {
        this.fLastModule = null;
    }

    protected void startPackage(String packageName) {
        if (this.fLastModule == null) {
            return;
        }
        this.fLastPackage = this.getPackage(packageName);
        this.fLastModule.setExplicitPackage(true);
        if (this.fLastPackage == null) {
            this.fLastPackage = RfStruct.createPackage(this, packageName);
            this.addPackage(this.fLastPackage);
        }
        ParserPath parserPath = this.fLastModule.getParserPath();
        this.fLastPackage.addModuleReference(parserPath);
        this.fLastModule.setPackageName(packageName);
    }

    public ElementContainer startLikeInterface(WrapperLikeStruct parseInfo) {
        if (this.fLastModule == null) {
            return null;
        }
        RfStruct.KIND structKind = RfStruct.KIND.INTERFACE;
        if (this.isInSLNMode() && !parseInfo.isUnit && structKind != RfStruct.KIND.INTERFACE) {
            structKind = RfStruct.KIND.SLN_STRUCT;
        }
        ElementContainer container = null;
        if (this.fLastModule.isInternalModule()) {
            this.fLastStruct = this.newPredefinedStruct(parseInfo.name, this.fLastModule.getPackageName(), parseInfo.parentName, parseInfo.isUnit, parseInfo.comment, parseInfo.templateParams);
            return new ElementContainer(this.fLastStruct);
        }
        container = parseInfo.isTemplate ? this.fLastModule.addTemplateStructLayer(this.fIncremental, this, parseInfo.name, parseInfo.isUnit, parseInfo.templateParams, parseInfo.comment, parseInfo.startLine, parseInfo.endLine, parseInfo.accessType, parseInfo.reparseStack, structKind) : this.fLastModule.addStructLikeLayer(this.fIncremental, this, parseInfo.name, parseInfo.isUnit, parseInfo.comment, parseInfo.startLine, parseInfo.endLine, parseInfo.accessType, parseInfo.reparseStack, structKind, this.fLastModule.isInternalModule());
        if (container == null || !(container.element instanceof RfStruct)) {
            return null;
        }
        this.fLastStructLayer = (RfStructLayer)container.def;
        this.fLastStruct = (RfStruct)container.element;
        return container;
    }

    public ElementContainer startLikeStruct(WrapperLikeStruct parseInfo) {
        if (this.fLastModule == null) {
            return null;
        }
        RfStruct.KIND structKind = RfStruct.KIND.STRUCT;
        if ((this.isInSLNMode() || this.isInSDLMode()) && !parseInfo.isUnit) {
            structKind = RfStruct.KIND.SLN_STRUCT;
        }
        ElementContainer container = null;
        if (this.fLastModule.isInternalModule()) {
            this.fLastStruct = this.newPredefinedStruct(parseInfo.name, this.fLastModule.getPackageName(), parseInfo.parentName, parseInfo.isUnit, parseInfo.comment, parseInfo.templateParams);
            return new ElementContainer(this.fLastStruct);
        }
        container = parseInfo.isTemplate ? this.fLastModule.addTemplateStructLayer(this.fIncremental, this, parseInfo.name, parseInfo.isUnit, parseInfo.templateParams, parseInfo.comment, parseInfo.startLine, parseInfo.endLine, parseInfo.accessType, parseInfo.reparseStack, structKind) : this.fLastModule.addStructLikeLayer(this.fIncremental, this, parseInfo.name, parseInfo.isUnit, parseInfo.comment, parseInfo.startLine, parseInfo.endLine, parseInfo.accessType, parseInfo.reparseStack, structKind, this.fLastModule.isInternalModule());
        if (container == null || !(container.element instanceof RfStruct)) {
            return null;
        }
        this.fLastStructLayer = (RfStructLayer)container.def;
        this.fLastStruct = (RfStruct)container.element;
        return container;
    }

    public ElementContainer startAnotation(String name, LineInfo startLine, LineInfo endLine, CommentBlock comment, ReparseElement[] reparseStack) {
        if (this.fLastModule == null) {
            return null;
        }
        ElementContainer container = null;
        container = this.fLastModule.addAnnotationLayer(this.fIncremental, this, name, comment, startLine, endLine, 16, reparseStack, RfStruct.KIND.ANNOTATION, this.fLastModule.isInternalModule());
        if (container == null || !(container.element instanceof RfStruct)) {
            return null;
        }
        this.fLastStructLayer = (RfStructLayer)container.def;
        this.fLastStruct = (RfStruct)container.element;
        RfType sequenceParent = this.getType("main", false, 1, "annotation", this.fLastModule.getMaxModuleIndex());
        ((RfStruct)container.element).setParentStructFrom(this, new RfDummyField(this, sequenceParent));
        return container;
    }

    private RfStruct newPredefinedStruct(String name, String packageName, String parentName, boolean isUnit, CommentBlock comment, List<WrapperParam> parameters) {
        RfPredefinedStruct newPredefinedStruct = new RfPredefinedStruct(this, name, packageName, isUnit, comment == null ? null : comment.toRawString(), parameters);
        if (this.isInSDLMode() && this.fLastModule.getName().contains("__etools__sn")) {
            newPredefinedStruct.setEPredefined(true);
        }
        this.fLastPackage.addType(newPredefinedStruct, false);
        return newPredefinedStruct;
    }

    public void endLikeStruct() {
        this.fLastStructLayer = null;
        this.fLastStruct = null;
        this.fLastMethod = null;
        this.fLastMethodLayer = null;
        this.fLastCoverLayer = null;
        this.fLastMacroLayer = null;
        this.fLastPerUnitInstance = null;
        this.fActionLayersStack.clear();
    }

    public ElementContainer startExtendStruct(WrapperExtendStruct parseInfo, boolean templateExtend) {
        RfStructLayer layer;
        if (this.fLastModule == null) {
            return null;
        }
        if (this.fLastModule.isInternalModule()) {
            boolean strictPackage = parseInfo.packageName != null;
            String packageName = strictPackage ? parseInfo.packageName : this.fLastModule.getPackageName();
            RfType rfType = this.getType(packageName, false, -1, parseInfo.baseName, this.fLastModule.getMaxModuleIndex());
            if (rfType instanceof RfStruct) {
                this.fLastStruct = (RfStruct)rfType;
            }
            return new ElementContainer(this.fLastStruct);
        }
        if (this.fLastStruct != null && this.fLastStruct.isSDLAgent()) {
            this.fStructContainersStack.push(new ElementContainer(this.fLastStructLayer, this.fLastStruct));
            parseInfo.packageName = this.fLastStruct.getName();
            parseInfo.fullName = String.valueOf(parseInfo.packageName) + "::" + parseInfo.baseName;
        }
        if ((layer = this.fLastModule.addStructLayer(false, this.fIncremental, this, parseInfo.baseName, parseInfo.packageName, parseInfo.fullName, parseInfo.comment, parseInfo.startLine, parseInfo.endLine, parseInfo.reparseStack, templateExtend)) == null || !(layer.getNamedElement() instanceof RfStruct)) {
            return new ElementContainer(layer);
        }
        this.fLastStructLayer = layer;
        this.fLastStruct = layer.getStruct();
        return new ElementContainer(layer);
    }

    public void endExtendStruct() {
        if (!this.fStructContainersStack.isEmpty()) {
            ElementContainer container = this.fStructContainersStack.pop();
            this.fLastStructLayer = (RfStructLayer)container.def;
            this.fLastStruct = (RfStruct)container.element;
        } else {
            this.fLastStructLayer = null;
            this.fLastStruct = null;
        }
        this.fLastMethod = null;
        this.fLastMethodLayer = null;
        this.fLastCoverLayer = null;
        this.fLastMacroLayer = null;
        this.fLastPerUnitInstance = null;
        this.fActionLayersStack.clear();
    }

    public RfStructLayer startWhenStruct(WrapperExtendStruct parseInfo) {
        RfStructLayer layer;
        String packageName = parseInfo.packageName;
        if (packageName == null) {
            packageName = this.fLastStruct.getPackageName();
        }
        if ((layer = this.fLastModule.addStructLayer(true, this.fIncremental, this, this.fLastStruct.getName(), packageName, parseInfo.fullName, parseInfo.comment, parseInfo.startLine, parseInfo.endLine, parseInfo.reparseStack, false)) == null || !(layer.getNamedElement() instanceof RfStruct)) {
            return null;
        }
        this.fStructContainersStack.push(new ElementContainer(this.fLastStructLayer, this.fLastStruct));
        this.fLastStructLayer = layer;
        this.fLastStruct = layer.getStruct();
        return layer;
    }

    public ElementContainer startSLNConstStatement(String name, WrapperType typeInfo, ReparseElement[] reparseStack) {
        this.startExtendStruct(new WrapperExtendStruct("global", null, "global", null, typeInfo.line, typeInfo.line, null, reparseStack), false);
        ElementContainer result = this.startField(name, typeInfo, false, false, false, 16, false, false, reparseStack);
        this.endExtendStruct();
        return result;
    }

    public ElementContainer startSDLToolDefineStatement(String name, LineInfo line, ReparseElement[] reparseStack) {
        RfType toolType;
        this.startExtendStruct(new WrapperExtendStruct("sdl_tools", null, "sdl_tools", null, line, line, null, reparseStack), false);
        String toolTypeName = "tool_" + name;
        WrapperType typeWrapper = new WrapperType(toolTypeName, toolTypeName, line, new CommentBlock("Tool '" + toolTypeName + "'.", null, false), reparseStack);
        typeWrapper.baseName = toolTypeName;
        typeWrapper.baseType = 2;
        ElementContainer fieldElementContainer = this.startField(name, typeWrapper, false, false, false, 16, false, false, reparseStack);
        if (this.fLastModule != null && fieldElementContainer != null && fieldElementContainer.element instanceof RfField && (toolType = this.getType(this.fLastModule.getPackageName(), false, 1, toolTypeName, this.fLastModule.getMaxModuleIndex())) != null) {
            RfDummyField dummyField = new RfDummyField(this, (IRfNamedElement)toolType, new Determinant(new String[]{toolType.getName()}));
            ((RfField)fieldElementContainer.element).setAssociatedTypeFrom(this, dummyField);
        }
        this.endExtendStruct();
        ElementContainer result = this.startExtendStruct(new WrapperExtendStruct(toolTypeName, null, toolTypeName, null, line, line, null, reparseStack), false);
        this.endExtendStruct();
        return result;
    }

    public void startSDLRoleStructMember(String name, LineInfo line, ReparseElement[] reparseStack) {
        if (this.fLastStruct == null || this.fLastStructLayer == null || this.fLastModule == null) {
            return;
        }
        this.fLastStruct.addSDLRoleSMLayer(this, this.fLastModule, this.fLastStructLayer, line, name, reparseStack);
        String packageName = this.fLastStruct.getPackageName();
        String structName = this.fLastStruct.getName();
        if ("singleton".equals(name)) {
            RfStructLayer prevStructLayer = this.fLastStructLayer;
            RfStruct prevStruct = this.fLastStruct;
            this.startExtendStruct(new WrapperExtendStruct("global", null, "global", null, line, line, null, reparseStack), false);
            WrapperType typeWrapper = new WrapperType(null, structName, line, new CommentBlock("Singleton '" + structName + "'.", null, false), reparseStack);
            typeWrapper.packageName = packageName;
            typeWrapper.baseName = structName;
            typeWrapper.baseType = 2;
            ElementContainer result = this.startField(structName, typeWrapper, false, false, false, 16, false, false, reparseStack);
            if (result != null && result.element instanceof RfField) {
                RfDummyField dummyField = new RfDummyField(this, (IRfNamedElement)prevStruct, new Determinant(new String[]{prevStruct.getName()}));
                ((RfField)result.element).setAssociatedTypeFrom(this, dummyField);
            }
            this.endExtendStruct();
            this.fLastStructLayer = prevStructLayer;
            this.fLastStruct = prevStruct;
        }
    }

    public void startSDLInlineStructMember(String argName, String inlineText, String inlineElseText, LineInfo line, ReparseElement[] reparseStack) {
        if (this.fLastStruct == null || this.fLastStructLayer == null || this.fLastModule == null) {
            return;
        }
        this.fLastStruct.addSDLInlineSMLayer(this, this.fLastModule, this.fLastStructLayer, argName, inlineText, inlineElseText, line, reparseStack);
    }

    public ElementContainer startSLNToken(WrapperLikeStruct parseInfo) {
        if (this.fLastModule == null) {
            return null;
        }
        ElementContainer container = this.fLastModule.addSLNTokenLikeLayer(this.fIncremental, this, parseInfo.name, parseInfo.comment, parseInfo.startLine, parseInfo.endLine, parseInfo.accessType, parseInfo.reparseStack, this.fLastModule.isInternalModule());
        this.fLastStructLayer = (RfStructLayer)container.def;
        this.fLastStruct = (RfStruct)container.element;
        return container;
    }

    public ElementContainer startSLNComponent(WrapperLikeStruct parseInfo) {
        if (this.fLastModule == null) {
            return null;
        }
        ElementContainer container = this.fLastModule.addSLNComponentLikeLayer(this.fIncremental, this, parseInfo.name, parseInfo.parentName, parseInfo.parentPackageName, parseInfo.comment, parseInfo.startLine, parseInfo.endLine, parseInfo.accessType, parseInfo.reparseStack, this.fLastModule.isInternalModule());
        this.fLastStructLayer = (RfStructLayer)container.def;
        this.fLastStruct = (RfStruct)container.element;
        return container;
    }

    public ElementContainer startSDLAgent(WrapperLikeStruct parseInfo) {
        if (this.fLastModule == null) {
            return null;
        }
        ElementContainer container = this.fLastModule.addSDLAgentLikeLayer(this.fIncremental, this, parseInfo.name, parseInfo.parentName, parseInfo.parentPackageName, parseInfo.comment, parseInfo.startLine, parseInfo.endLine, parseInfo.accessType, parseInfo.reparseStack, this.fLastModule.isInternalModule());
        this.fLastStructLayer = (RfStructLayer)container.def;
        this.fLastStruct = (RfStruct)container.element;
        WrapperLikeStruct wrp = new WrapperLikeStruct("start", null, "any_normal_scenario", "sdl", false, false, parseInfo.startLine, parseInfo.startLine, 16, new CommentBlock("<i>PREDEFINED: </i>The built-in start scenario.", null, false), parseInfo.reparseStack);
        ElementContainer scenarioContainer = this.startSDLScenario(wrp, parseInfo.name, null);
        if (scenarioContainer != null) {
            if (scenarioContainer.def != null) {
                scenarioContainer.def.setImplicit(true);
            }
            if (scenarioContainer.element instanceof RfStruct) {
                ((RfStruct)scenarioContainer.element).setParentStructFrom(this, new RfDummyField(this, this.getTypesUtil().SDL_SCENARIO_TYPE()));
            }
        }
        this.endSDLScenario();
        return container;
    }

    public ElementContainer startSLNType(WrapperType parseInfo, int accessType, ReparseElement[] reparseStack) {
        if (this.fLastModule == null) {
            return null;
        }
        RfStruct lastComponent = this.fLastStruct;
        if (lastComponent == null || !lastComponent.isSLNComponent()) {
            lastComponent = this.getPackage("DVE");
        }
        if (lastComponent == null || !lastComponent.isSLNComponent()) {
            return null;
        }
        boolean isEnum = parseInfo.baseType == 3;
        RfScalarTypeLayer layer = this.fLastModule.addSLNTypeLayer(this.fIncremental, this, lastComponent, parseInfo.name, isEnum ? parseInfo.def : parseInfo.baseName, parseInfo.packageName, isEnum, isEnum ? parseInfo.enums : null, parseInfo.ranges, parseInfo.comment, parseInfo.line, parseInfo.endLine != null ? parseInfo.endLine : parseInfo.line, accessType, reparseStack);
        return new ElementContainer(layer);
    }

    public ElementContainer startSLNExtendType(WrapperType parseInfo) {
        if (this.fLastModule == null) {
            return null;
        }
        RfStruct lastComponent = this.fLastStruct;
        if (lastComponent == null || !lastComponent.isSLNComponent()) {
            lastComponent = this.getPackage("DVE");
        }
        if (lastComponent == null || !lastComponent.isSLNComponent()) {
            return null;
        }
        boolean isEnum = parseInfo.baseType == 3;
        RfScalarTypeLayer layer = this.fLastModule.addSLNExtendTypeLayer(this.fIncremental, this, lastComponent, parseInfo.baseName, parseInfo.packageName, isEnum, isEnum ? parseInfo.enums : null, parseInfo.comment, parseInfo.line, parseInfo.endLine != null ? parseInfo.endLine : parseInfo.line, parseInfo.reparseStack);
        return new ElementContainer(layer);
    }

    public ElementContainer startSLNAction(WrapperLikeStruct parseInfo) {
        if (this.fLastModule == null) {
            return null;
        }
        RfStruct lastComponent = this.fLastStruct;
        if (lastComponent == null || !lastComponent.isSLNComponent()) {
            lastComponent = this.getPackage("DVE");
        }
        if (lastComponent == null || !lastComponent.isSLNComponent()) {
            return null;
        }
        ElementContainer container = this.fLastModule.addSLNActionLikeLayer(this.fIncremental, this, lastComponent, parseInfo.name, parseInfo.comment, parseInfo.startLine, parseInfo.endLine, parseInfo.accessType, parseInfo.reparseStack, this.fLastModule.isInternalModule());
        this.fStructContainersStack.push(new ElementContainer(this.fLastStructLayer, this.fLastStruct));
        this.fLastStructLayer = (RfStructLayer)container.def;
        this.fLastStruct = (RfStruct)container.element;
        return container;
    }

    public void endSLNAction() {
        if (!this.fStructContainersStack.isEmpty()) {
            ElementContainer container = this.fStructContainersStack.pop();
            this.fLastStructLayer = (RfStructLayer)container.def;
            this.fLastStruct = (RfStruct)container.element;
            this.fLastMethodLayer = null;
            this.fLastCoverLayer = null;
            this.fLastMacroLayer = null;
            this.fLastPerUnitInstance = null;
            this.fActionLayersStack.clear();
        }
    }

    public ElementContainer startSDLScenario(WrapperLikeStruct parseInfo, String agentName, String blockText) {
        if (this.fLastModule == null) {
            return null;
        }
        RfStruct lastComponent = this.fLastStruct;
        if (lastComponent == null || !lastComponent.isSDLAgent()) {
            if (agentName != null) {
                lastComponent = this.getPackage(agentName);
                if (lastComponent == null) {
                    lastComponent = this.getPackage("DVE");
                }
            } else {
                lastComponent = this.getPackage("DVE");
            }
        }
        if (lastComponent == null || !lastComponent.isSDLAgent()) {
            return null;
        }
        ElementContainer container = this.fLastModule.addSDLScenarioLikeLayer(this.fIncremental, this, lastComponent, parseInfo.name, parseInfo.comment, parseInfo.startLine, parseInfo.endLine, parseInfo.accessType, parseInfo.reparseStack, this.fLastModule.isInternalModule());
        this.fStructContainersStack.push(new ElementContainer(this.fLastStructLayer, this.fLastStruct));
        this.fLastStructLayer = (RfStructLayer)container.def;
        this.fLastStruct = (RfStruct)container.element;
        String slnComponentName = lastComponent.getName();
        WrapperType typeWrapper = new WrapperType(null, slnComponentName, parseInfo.startLine, new CommentBlock("<i>PREDEFINED: </i>The enclosing '" + slnComponentName + "' agent.", null, false), parseInfo.reparseStack);
        typeWrapper.baseName = slnComponentName;
        typeWrapper.baseType = 2;
        typeWrapper.isNotSDLParam = true;
        RfDummyField typeContainer = new RfDummyField(this, (IRfNamedElement)lastComponent, new Determinant(new String[]{slnComponentName}));
        ElementContainer fieldLayer = this.startField("agent", typeWrapper, false, true, false, 16, false, false, parseInfo.reparseStack);
        if (fieldLayer.def != null) {
            fieldLayer.def.setImplicit(true);
        }
        ((RfField)fieldLayer.element).setAssociatedTypeFrom(this, typeContainer);
        return container;
    }

    public ElementContainer startSDLRoleType(WrapperLikeStruct parseInfo) {
        if (this.fLastModule == null) {
            return null;
        }
        ElementContainer container = this.fLastModule.addSDLRoleTypeLayer(this.fIncremental, this, parseInfo.name, parseInfo.comment, parseInfo.startLine, parseInfo.endLine, parseInfo.reparseStack, this.fLastModule.isInternalModule());
        return container;
    }

    public void endSDLScenario() {
        if (!this.fStructContainersStack.isEmpty()) {
            ElementContainer container = this.fStructContainersStack.pop();
            this.fLastStructLayer = (RfStructLayer)container.def;
            this.fLastStruct = (RfStruct)container.element;
            this.fLastMethodLayer = null;
            this.fLastCoverLayer = null;
            this.fLastMacroLayer = null;
            this.fLastPerUnitInstance = null;
            this.fActionLayersStack.clear();
        }
    }

    public String getStructName() {
        if (this.fLastStruct == null) {
            return "";
        }
        return this.fLastStruct.getName();
    }

    public void endWhenStruct() {
        if (!this.fStructContainersStack.isEmpty()) {
            ElementContainer container = this.fStructContainersStack.pop();
            this.fLastStructLayer = (RfStructLayer)container.def;
            this.fLastMethodLayer = null;
            this.fLastCoverLayer = null;
            this.fLastMacroLayer = null;
            this.fLastPerUnitInstance = null;
            this.fActionLayersStack.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RfMacroLayer startPreproc(WrapperMacro parseInfo) {
        String preprocName;
        RfMacro preproc;
        boolean isPredefined = false;
        if (this.fLastModule != null && this.fLastModule.isInternalModule()) {
            isPredefined = true;
        }
        if ((preproc = this.getPreproc(preprocName = parseInfo.name)) == null) {
            preproc = new RfMacro(this, parseInfo.name, parseInfo.stringLiteral, null, false, true, isPredefined);
            Map<String, RfMacro> map = this.fPreprocs;
            synchronized (map) {
                this.fPreprocs.put(preprocName, preproc);
            }
        } else {
            RfDefElement declaration = preproc.getDeclaration();
            if (declaration != null && declaration.getLayerModule() == this.fLastModule && declaration.getStartLine() == parseInfo.startLine.line) {
                parseInfo.comment = declaration.getLayerCommentBlock();
            }
        }
        RfMacroLayer newLayer = new RfMacroLayer(parseInfo.name, parseInfo.stringLiteral, this.fLastModule, parseInfo.startLine, parseInfo.endLine, parseInfo.comment, true, parseInfo.isUndef, parseInfo.replacement, parseInfo.isConditional, parseInfo.reparsed);
        newLayer.setDeclaration(true);
        preproc.addLayer(newLayer);
        return newLayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElementContainer startTableDefine(WrapperMacro parseInfo) {
        String tableDefineName;
        RfTableDefine tableDefine;
        boolean isPredefined = false;
        if (this.fLastModule != null && this.fLastModule.isInternalModule()) {
            isPredefined = true;
        }
        if ((tableDefine = this.getTableDefine(tableDefineName = parseInfo.name)) == null) {
            tableDefine = new RfTableDefine(this, tableDefineName, isPredefined, parseInfo.comment);
            Map<String, RfTableDefine> map = this.fTableDefines;
            synchronized (map) {
                this.fTableDefines.put(tableDefineName, tableDefine);
            }
        }
        RfTableDefineLayer newLayer = new RfTableDefineLayer(this.fLastModule, parseInfo.startLine, parseInfo.endLine, parseInfo.comment, parseInfo.reparsed);
        tableDefine.addLayer(newLayer);
        return new ElementContainer(newLayer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElementContainer startMacro(WrapperMacro parseInfo, AST node, boolean isDefinition) {
        String macroName;
        RfMacro macro;
        boolean isPredefined = false;
        if (this.fLastModule != null && this.fLastModule.isInternalModule()) {
            isPredefined = true;
        }
        if ((macro = this.getMacro(macroName = String.valueOf(parseInfo.name) + "'" + parseInfo.type)) == null) {
            macro = new RfMacro(this, macroName, parseInfo.stringLiteral, parseInfo.type, parseInfo.isAsComputed, false, isPredefined, parseInfo.comment);
            Map<String, RfMacro> map = this.fMacros;
            synchronized (map) {
                this.fMacros.put(macroName, macro);
            }
        }
        if (this.isNonStandardSemanticEnabled() && macro.isNonStandard()) {
            this.addSemanticError3(2, "NON_STANDARD_MACRO: ''{0}''", -1, -1, null, parseInfo.startLine.line, this.fLastModule.getParserPath(), parseInfo.stringLiteral);
        }
        RfMacroLayer newLayer = new RfMacroLayer(parseInfo.name, parseInfo.stringLiteral, this.fLastModule, parseInfo.startLine, parseInfo.endLine, parseInfo.comment, false, false, null, false, parseInfo.reparsed);
        newLayer.setAST(node);
        newLayer.setDeclaration(parseInfo.definition);
        macro.addLayer(newLayer);
        newLayer.setUserDefinedReplace(parseInfo.userDefinedReplace);
        if (isDefinition) {
            this.fLastMacroLayer = newLayer;
        }
        return new ElementContainer(newLayer);
    }

    public void endMacro(boolean isDefinition) {
        if (isDefinition && !this.fActionLayersStack.isEmpty()) {
            this.fActionLayersStack.clear();
        }
        this.fLastMacroLayer = null;
    }

    public ElementContainer startSequence(WrapperSequence parseInfo) {
        String seqItemName;
        boolean strictPackage;
        AST seqIdAST = parseInfo.seqIdAST;
        Map<String, WrapperType> using = parseInfo.using;
        WrapperType createdKind = using.get("created_kind");
        WrapperType createdDriver = using.get("created_driver");
        WrapperType sequenceType = using.get("sequence_type");
        WrapperType sequenceDriverType = using.get("sequence_driver_type");
        WrapperType item = using.get("item");
        String seqName = parseInfo.seqIdAST.getText();
        int accessType = parseInfo.accessType;
        RfStruct sequenceStruct = null;
        RfField sequenceKindField = null;
        RfField sequenceDriverField = null;
        RfMethod sequenceGetDriverMethod = null;
        ElementContainer sequenceContainer = null;
        boolean isTemplate = parseInfo.templateParams != null && !parseInfo.templateParams.isEmpty();
        WrapperLikeStruct sequenceInfo = new WrapperLikeStruct(seqName, parseInfo.templateParams, sequenceType.baseName, sequenceType.packageName, false, isTemplate, parseInfo.startLine, parseInfo.endLine, accessType, parseInfo.comment, parseInfo.reparseStack);
        sequenceContainer = this.startLikeStruct(sequenceInfo);
        sequenceContainer.def.setImplicit(false);
        sequenceStruct = (RfStruct)sequenceContainer.element;
        RfType sequenceParent = this.getType(sequenceType.packageName, sequenceType.packageName != null, 1, sequenceType.baseName, this.fLastModule.getMaxModuleIndex());
        sequenceStruct.setParentStructFrom(this, new RfDummyField(this, sequenceParent));
        sequenceStruct.setSequenceAdditionalInfo(item == null ? null : item.baseName, createdDriver.baseName, createdKind.baseName);
        ((EAST)seqIdAST).transientResult = sequenceContainer.element;
        createdKind.comment = new CommentBlock("<i>PREDEFINED: </i>[" + seqName + " field] The kind field that determines which sequence it is.", null, false);
        ElementContainer fieldContainer = this.startField("kind", createdKind, false, true, false, 16, false, false, parseInfo.reparseStack);
        fieldContainer.def.setImplicit(true);
        sequenceKindField = (RfField)fieldContainer.element;
        createdDriver.comment = new CommentBlock("<i>PREDEFINED: </i>[" + seqName + " field] Driver for the sequence, soft-constrained to be its parent sequence's driver.", null, false);
        createdDriver.baseType = 2;
        fieldContainer = this.startField("driver", createdDriver, false, true, false, 16, false, false, parseInfo.reparseStack);
        fieldContainer.def.setImplicit(true);
        sequenceDriverField = (RfField)fieldContainer.element;
        ElementContainer methodContainer = this.startMethod(new WrapperMethod("get_driver", 371, "", createdDriver.baseName, createdDriver, "", false, parseInfo.startLine, parseInfo.startLine, accessType, new CommentBlock("<i>PREDEFINED: </i>[any_sequence_item method RO] Return the driver for an item.", null, false), parseInfo.reparseStack, false));
        this.endMethod();
        methodContainer.def.setImplicit(true);
        sequenceGetDriverMethod = (RfMethod)methodContainer.element;
        this.endLikeStruct();
        boolean bl = strictPackage = item != null && item.packageName != null;
        RfType itemType = item != null ? this.getType(strictPackage ? item.packageName : "main", strictPackage, 1, item.baseName, this.fLastModule.getMaxModuleIndex()) : null;
        RfDummyField itemTypeContainer = null;
        if (item != null && itemType != null) {
            Determinant determinant = item.def != null ? new Determinant(item.def) : new Determinant(new String[]{item.baseName});
            itemTypeContainer = new RfDummyField(this, (IRfNamedElement)itemType, determinant);
        }
        RfDummyField createdDriverTypeContainer = null;
        boolean isTemplate2 = parseInfo.templateParams != null;
        WrapperLikeStruct driverInfo = new WrapperLikeStruct(createdDriver.baseName, parseInfo.templateParams, sequenceDriverType.baseName, sequenceDriverType.packageName, true, isTemplate2, parseInfo.startLine, parseInfo.endLine, accessType, new CommentBlock("Created driver of " + seqName + ".", null, false), parseInfo.reparseStack);
        ElementContainer structContainer = this.startLikeStruct(driverInfo);
        structContainer.def.setImplicit(true);
        RfStruct driverUnit = (RfStruct)structContainer.element;
        RfType driverUnitParent = this.getType(sequenceDriverType.packageName, sequenceDriverType.packageName != null, 1, sequenceDriverType.baseName, this.fLastModule.getMaxModuleIndex());
        driverUnit.setParentStructFrom(this, new RfDummyField(this, driverUnitParent));
        createdDriverTypeContainer = new RfDummyField(this, (IRfNamedElement)structContainer.element, new Determinant(new String[]{structContainer.element.getName()}));
        sequenceDriverField.setAssociatedTypeFrom(this, createdDriverTypeContainer);
        sequenceGetDriverMethod.setAssociatedTypeFrom(this, createdDriverTypeContainer);
        WrapperType typeWrapper = new WrapperType(null, "MAIN'kind " + seqName, parseInfo.startLine, new CommentBlock("<i>PREDEFINED: </i>[sequence driver field] Declared in " + createdDriver.baseName + ".", null, false), parseInfo.reparseStack);
        typeWrapper.baseName = seqName;
        typeWrapper.baseType = 2;
        typeWrapper.typeAST = new EAST((EAST)seqIdAST);
        RfDummyField seqTypeContainer = new RfDummyField(this, (IRfNamedElement)sequenceStruct, new Determinant("MAIN'kind " + sequenceStruct.getName()));
        ElementContainer fieldContainer2 = this.startField("sequence", typeWrapper, false, true, false, 16, false, false, parseInfo.reparseStack);
        fieldContainer2.def.setImplicit(true);
        ((RfField)fieldContainer2.element).setAssociatedTypeFrom(this, seqTypeContainer);
        fieldContainer2 = this.startField("main_sequence", typeWrapper, false, true, false, 16, false, false, parseInfo.reparseStack);
        fieldContainer2.def.setImplicit(true);
        ((RfField)fieldContainer2.element).setAssociatedTypeFrom(this, seqTypeContainer);
        String string = seqItemName = item == null ? "any_sequence_item" : item.baseName;
        if (item == null) {
            itemTypeContainer = new RfDummyField(this, (IRfNamedElement)this.getType("main", true, 1, "any_sequence_item", -1), new Determinant(new String[]{"any_sequence_item"}));
        }
        ElementContainer methodContainer2 = this.startMethod(new WrapperMethod("get_next_item", 371, null, seqItemName, item, "clock", false, parseInfo.startLine, parseInfo.startLine, accessType, new CommentBlock("<i>PREDEFINED: </i>[any_sequence_driver method RO] This TCM should be called in PULL_MODE to receive the next item from the BFM driver. This TCM is blocked until there is an item to do in the driver.", null, false), parseInfo.reparseStack, false));
        methodContainer2.def.setImplicit(true);
        ((RfMethod)methodContainer2.element).setAssociatedTypeFrom(this, itemTypeContainer);
        this.endMethod();
        methodContainer2 = this.startMethod(new WrapperMethod("try_next_item", 371, null, seqItemName, item, "clock", false, parseInfo.startLine, parseInfo.startLine, accessType, new CommentBlock("<i>PREDEFINED: </i>[any_sequence_driver method RO] This TCM should be called in PULL_MODE when the BFM has to receive an item or perform some default behavior. Unlike get_next_item(), in case there is no available item waiting to be done in the current cycle, this TCM returns NULL. try_next_item() returns in the same cycle if there is no pending do action. However, if a do action started execution, then try_next_item() might take longer than a cycle, for example, if you extend the pre_do() TCM to take longer than a cycle.", null, false), parseInfo.reparseStack, false));
        methodContainer2.def.setImplicit(true);
        ((RfMethod)methodContainer2.element).setAssociatedTypeFrom(this, itemTypeContainer);
        this.endMethod();
        methodContainer2 = this.startMethod(new WrapperMethod("last", 371, "index: int", seqItemName, item, null, false, parseInfo.startLine, parseInfo.startLine, accessType, new CommentBlock("<i>PREDEFINED: </i>[any_sequence_driver method RO] RO This method is valid for BFM sequence drivers only. It enables access to previously sent items in the sequence driver.", null, false), parseInfo.reparseStack, false));
        ElementContainer argContainer = this.startArg("index", new WrapperType().setBaseName("int").setBaseType(1).setDefName("int").setLine(parseInfo.startLine));
        ((RfArg)argContainer.element).setAssociatedType(this.getSpecman().getSpecman("int"));
        methodContainer2.def.setImplicit(true);
        ((RfMethod)methodContainer2.element).setAssociatedTypeFrom(this, itemTypeContainer);
        this.endMethod();
        methodContainer2 = this.startMethod(new WrapperMethod("send_to_bfm", 371, "seq_item: " + seqItemName, null, null, "clock", false, parseInfo.startLine, parseInfo.startLine, accessType, new CommentBlock("<i>PREDEFINED: </i>[any_sequence_driver method RW] When working in PUSH_MODE, sends the item to the corresponding BFM. To be implemented by users as part of hooking. This method is called automatically (when working in PUSH_MODE).", null, false), parseInfo.reparseStack, false));
        argContainer = this.startArg("seq_item", new WrapperType().setBaseName(seqItemName).setBaseType(2).setDefName(seqItemName).setLine(parseInfo.startLine));
        ((RfArg)argContainer.element).setAssociatedTypeFrom(this, itemTypeContainer);
        methodContainer2.def.setImplicit(true);
        this.endMethod();
        this.endLikeStruct();
        ElementContainer structContainer2 = this.startExtendStruct(new WrapperExtendStruct(seqName, null, "MAIN'kind " + seqName, null, parseInfo.startLine, parseInfo.endLine, null, parseInfo.reparseStack), false);
        structContainer2.def.setImplicit(true);
        WrapperType typeWrapper2 = new WrapperType(null, "uint", parseInfo.startLine, new CommentBlock("<i>PREDEFINED: </i>[count field] Declared in MAIN'kind " + seqName + ".", null, false), parseInfo.reparseStack);
        typeWrapper2.baseName = "uint";
        typeWrapper2.baseType = 1;
        typeWrapper2.typeAST = new EAST((EAST)seqIdAST);
        ElementContainer fieldContainer3 = this.startField("count", typeWrapper2, false, true, false, 16, false, false, parseInfo.reparseStack);
        fieldContainer3.def.setImplicit(true);
        RfType uintType = this.getType("main", true, 2, "uint", -1);
        ((RfField)fieldContainer3.element).setAssociatedTypeFrom(this, new RfDummyField(this, uintType));
        typeWrapper2 = new WrapperType(null, seqName, parseInfo.startLine, new CommentBlock("<i>PREDEFINED: </i>[sequence field] Declared in MAIN'kind " + seqName + ".", null, false), parseInfo.reparseStack);
        typeWrapper2.baseName = seqName;
        typeWrapper2.baseType = 2;
        typeWrapper2.typeAST = new EAST((EAST)seqIdAST);
        RfDummyField typeContainer = new RfDummyField(this, (IRfNamedElement)sequenceStruct, new Determinant(new String[]{sequenceStruct.getName()}));
        ElementContainer fieldContainer4 = this.startField("sequence", typeWrapper2, false, true, false, 16, false, false, parseInfo.reparseStack);
        fieldContainer4.def.setImplicit(true);
        ((RfField)fieldContainer4.element).setAssociatedTypeFrom(this, typeContainer);
        fieldContainer4 = this.startField("sub_sequence", typeWrapper2, false, true, false, 16, false, false, parseInfo.reparseStack);
        fieldContainer4.def.setImplicit(true);
        ((RfField)fieldContainer4.element).setAssociatedTypeFrom(this, typeContainer);
        this.endExtendStruct();
        structContainer2 = this.startExtendStruct(new WrapperExtendStruct(seqName, null, "RANDOM'kind " + seqName, null, parseInfo.startLine, parseInfo.endLine, null, parseInfo.reparseStack), false);
        structContainer2.def.setImplicit(true);
        typeWrapper2 = new WrapperType(null, "uint", parseInfo.startLine, new CommentBlock("<i>PREDEFINED: </i>[count field] Declared in RANDOM'kind " + seqName + ".", null, false), parseInfo.reparseStack);
        typeWrapper2.baseName = "uint";
        typeWrapper2.baseType = 1;
        typeWrapper2.typeAST = new EAST((EAST)seqIdAST);
        ElementContainer fieldLayer = this.startField("count", typeWrapper2, false, true, false, 16, false, false, parseInfo.reparseStack);
        fieldLayer.def.setImplicit(true);
        uintType = this.getType("main", true, 2, "uint", -1);
        ((RfField)fieldLayer.element).setAssociatedTypeFrom(this, new RfDummyField(this, uintType));
        typeWrapper2 = new WrapperType(null, seqName, parseInfo.startLine, new CommentBlock("<i>PREDEFINED: </i>[sequence field] Declared in RANDOM'kind " + seqName + ".", null, false), parseInfo.reparseStack);
        typeWrapper2.baseName = seqName;
        typeWrapper2.baseType = 2;
        typeWrapper2.typeAST = new EAST((EAST)seqIdAST);
        typeContainer = new RfDummyField(this, (IRfNamedElement)sequenceStruct, new Determinant(new String[]{sequenceStruct.getName()}));
        fieldContainer4 = this.startField("sequence", typeWrapper2, false, true, false, 16, false, false, parseInfo.reparseStack);
        fieldContainer4.def.setImplicit(true);
        ((RfField)fieldContainer4.element).setAssociatedTypeFrom(this, typeContainer);
        fieldContainer4 = this.startField("sub_sequence", typeWrapper2, false, true, false, 16, false, false, parseInfo.reparseStack);
        fieldContainer4.def.setImplicit(true);
        ((RfField)fieldContainer4.element).setAssociatedTypeFrom(this, typeContainer);
        this.endExtendStruct();
        createdKind.baseType = 3;
        createdKind.enums = new ArrayList<RfEnum>();
        createdKind.enums.add(new RfEnum(this, "MAIN", null));
        createdKind.enums.add(new RfEnum(this, "RANDOM", null));
        if (item == null) {
            createdKind.name = createdKind.baseName;
            createdKind.def = "[MAIN, RANDOM]";
            createdKind.comment = new CommentBlock("<i>PREDEFINED: </i>Created kind of virtual sequence " + seqName + ".", null, false);
            ElementContainer typeContainer2 = this.startType(createdKind, accessType, parseInfo.reparseStack);
            RfDummyField createdKindTypeContainer = new RfDummyField(this, typeContainer2.element);
            sequenceKindField.setAssociatedTypeFrom(this, createdKindTypeContainer);
            typeContainer2.def.setImplicit(true);
            this.endType();
            ((EAST)createdKind.typeAST).transientResult = new RfDummyField(this, typeContainer2.element);
        } else {
            structContainer2 = this.startExtendStruct(new WrapperExtendStruct(seqName, null, "SIMPLE'kind " + seqName, null, parseInfo.startLine, parseInfo.endLine, null, parseInfo.reparseStack), false);
            structContainer2.def.setImplicit(true);
            ElementContainer fieldContainer5 = this.startField("item", item, false, true, false, 16, false, false, parseInfo.reparseStack);
            fieldContainer5.def.setImplicit(true);
            ((RfField)fieldContainer5.element).setAssociatedTypeFrom(this, itemTypeContainer);
            fieldContainer5 = this.startField("seq_item", item, false, true, false, 16, false, false, parseInfo.reparseStack);
            fieldContainer5.def.setImplicit(true);
            ((RfField)fieldContainer5.element).setAssociatedTypeFrom(this, itemTypeContainer);
            this.endExtendStruct();
            createdKind.name = createdKind.baseName;
            createdKind.def = "[MAIN, RANDOM, SIMPLE]";
            createdKind.comment = new CommentBlock("<i>PREDEFINED: </i>Created kind of sequence " + seqName + ".", null, false);
            createdKind.enums.add(new RfEnum(this, "SIMPLE", null));
            ElementContainer typeContainer3 = this.startType(createdKind, accessType, parseInfo.reparseStack);
            RfDummyField createdKindTypeContainer = new RfDummyField(this, typeContainer3.element);
            sequenceKindField.setAssociatedTypeFrom(this, createdKindTypeContainer);
            typeContainer3.def.setImplicit(true);
            this.endType();
            ((EAST)createdKind.typeAST).transientResult = new RfDummyField(this, typeContainer3.element);
            if (itemType != null) {
                this.startExtendStruct(new WrapperExtendStruct(item.baseName, null, item.def != null ? item.def : item.baseName, null, parseInfo.startLine, parseInfo.startLine, null, parseInfo.reparseStack), false);
                typeWrapper2 = new WrapperType(null, "any_sequence", parseInfo.startLine, new CommentBlock("<i>PREDEFINED: </i>[" + sequenceStruct.getName() + " field] Back-pointer to the sequence in which an item was created. Assigned automatically in the pre_generate() of the item.", null, false), parseInfo.reparseStack);
                typeWrapper2.baseName = "any_sequence";
                typeWrapper2.baseType = 2;
                typeContainer = new RfDummyField(this, (IRfNamedElement)this.getType("main", true, 1, "any_sequence", -1), new Determinant(new String[]{"any_sequence"}));
                fieldContainer4 = this.startField("parent_sequence", typeWrapper2, false, false, false, 16, false, false, parseInfo.reparseStack);
                fieldContainer4.def.setImplicit(true);
                ((RfField)fieldContainer4.element).setAssociatedTypeFrom(this, typeContainer);
                RfMethod getDriverMethord = ((RfStruct)itemType).getMethod(new FullName("get_driver", this.fLastStructLayer.getDeterminant()));
                if (getDriverMethord == null || getDriverMethord.hasNoLayers()) {
                    RfMethodLayer methodLayer2 = ((RfStruct)itemType).addMethodLayer(this, this.fLastModule, this.fLastStructLayer, new WrapperMethod("get_driver", 371, null, createdDriver.baseName, createdDriver, null, false, parseInfo.startLine, parseInfo.startLine, accessType, new CommentBlock("<i>PREDEFINED: </i>[any_sequence_item method RO] Return the driver for an item.", null, false), parseInfo.reparseStack, false), accessType);
                    methodLayer2.setImplicit(true);
                    methodLayer2.getMethod().setAssociatedTypeFrom(this, createdDriverTypeContainer);
                }
                fieldContainer3 = this.startField("driver", createdDriver, false, true, false, 16, false, false, parseInfo.reparseStack);
                fieldContainer3.def.setImplicit(true);
                ((RfField)fieldContainer3.element).setAssociatedTypeFrom(this, createdDriverTypeContainer);
                this.endExtendStruct();
            }
        }
        return sequenceContainer;
    }

    public void endSequence() {
        this.fLastStructLayer = null;
        this.fLastStruct = null;
        this.fLastMethod = null;
        this.fLastCoverLayer = null;
        this.fLastConstraintLayer = null;
        this.fLastMacroLayer = null;
        this.fLastMethodLayer = null;
        this.fActionLayersStack.clear();
    }

    public void startPortAttribute(WrapperMethod parseInfo) {
        if (this.fLastModule == null) {
            return;
        }
        RfStruct anyPort = (RfStruct)this.getSpecmanOnly("any_port");
        if (anyPort != null) {
            RfStructLayer layer = new RfStructLayer("any_port", null, 1, parseInfo.startLine, parseInfo.endLine, parseInfo.comment, this.fLastModule, parseInfo.reparseStack);
            anyPort.addLayer(layer);
            RfMethodLayer methodLayer = anyPort.addMethodLayer(this, this.fLastModule, layer, parseInfo, 16);
            methodLayer.setImplicit(true);
        }
    }

    public ElementContainer startType(WrapperType parseInfo, int accessType, ReparseElement[] reparseStack) {
        if (this.fLastModule == null) {
            return null;
        }
        if (this.fLastModule.isInternalModule()) {
            return this.newPredefinedScalar(parseInfo, reparseStack);
        }
        boolean isEnum = parseInfo.baseType == 3;
        RfScalarTypeLayer layer = this.fLastModule.addTypeLayer(this.fIncremental, this, parseInfo.name, isEnum ? parseInfo.def : parseInfo.baseName, parseInfo.packageName, isEnum, isEnum ? parseInfo.enums : null, parseInfo.ranges, parseInfo.comment, parseInfo.line, parseInfo.endLine != null ? parseInfo.endLine : parseInfo.line, accessType, reparseStack);
        return new ElementContainer(layer);
    }

    private ElementContainer newPredefinedScalar(WrapperType parseInfo, ReparseElement[] reparseStack) {
        boolean isEnum = parseInfo.baseType == 3;
        RfPredefinedScalar newPredefinedScalar = new RfPredefinedScalar(this, parseInfo.name, 32, parseInfo.comment == null ? null : parseInfo.comment.toRawString());
        if (this.isInSDLMode() && this.fLastModule.getName().contains("__etools__sn")) {
            newPredefinedScalar.setEPredefined(true);
        }
        this.fLastPackage.addType(newPredefinedScalar, false);
        if (isEnum) {
            String inlineComment = "PREDEFINED: " + (parseInfo.comment == null ? "" : parseInfo.comment.toRawString());
            RfScalarTypeLayer layer = new RfScalarTypeLayer("main", 0, new LineInfo(0, 0, -1), new LineInfo(0, 0, -1), new CommentBlock(inlineComment, null, parseInfo.comment == null ? -1 : parseInfo.comment.getAboveCommentStartLine(), false), this.fSpecman.fPredefinedModule, reparseStack);
            layer.addEnumItems(this.fSpecman.fPredefinedModule, new LineInfo(0, 0, -1), parseInfo.enums, newPredefinedScalar);
            newPredefinedScalar.addLayer(layer);
            return new ElementContainer(layer);
        }
        return new ElementContainer(newPredefinedScalar);
    }

    public void endType() {
    }

    public ElementContainer startMethodType(WrapperMethod parseInfo) {
        RfMethodTypeLayer layer = this.fLastModule.addMethodTypeLayer(this.fIncremental, this, parseInfo, parseInfo.accessType, parseInfo.reparseStack);
        this.fLastCoverLayer = null;
        this.fLastMacroLayer = null;
        this.fLastPerUnitInstance = null;
        this.fLastMethodLayer = ((RfMethodType)layer.getNamedElement()).addMethodLayer(this, this.fLastModule, layer, parseInfo, parseInfo.accessType);
        return new ElementContainer(layer);
    }

    public void endMethodType() {
        this.fLastMethodLayer = null;
    }

    public ElementContainer startExtendType(WrapperType parseInfo) {
        boolean isEnum = parseInfo.baseType == 3;
        RfScalarTypeLayer layer = this.fLastModule.addExtendTypeLayer(this.fIncremental, this, parseInfo.baseName, parseInfo.packageName, isEnum, isEnum ? parseInfo.enums : null, parseInfo.comment, parseInfo.line, parseInfo.endLine != null ? parseInfo.endLine : parseInfo.line, parseInfo.reparseStack);
        return new ElementContainer(layer);
    }

    public void endExtendType() {
    }

    public ElementContainer startMethod(WrapperMethod parseInfo) {
        if (this.fLastStruct == null || this.fLastModule == null) {
            return null;
        }
        if (this.fLastModule.isInternalModule()) {
            this.fLastMethod = this.newPredefinedMethod(parseInfo.name, parseInfo.resultType, parseInfo.args, parseInfo.tcmEvent, parseInfo.comment);
            return new ElementContainer(this.fLastMethod);
        }
        if (this.fLastStructLayer == null) {
            return null;
        }
        this.fLastCoverLayer = null;
        this.fLastMacroLayer = null;
        this.fLastPerUnitInstance = null;
        this.fLastMethodLayer = this.fLastStruct.addMethodLayer(this, this.fLastModule, this.fLastStructLayer, parseInfo, parseInfo.accessType);
        return new ElementContainer(this.fLastMethodLayer);
    }

    public ElementContainer startGlobalMethod(WrapperMethod parseInfo) {
        this.fLastStruct = this.fSpecman.getGlobalStruct();
        this.fLastMethod = this.newPredefinedMethod(parseInfo.name, parseInfo.resultType, parseInfo.args, parseInfo.tcmEvent, parseInfo.comment);
        return new ElementContainer(this.fLastMethod);
    }

    public ElementContainer startGlobalMethodArg(String name, WrapperType typeInfo) {
        if (this.fLastModule == null || this.fLastMethod == null) {
            return null;
        }
        if ("__dvt_variable_nof_args".equals(name) || "__dvt_ignore_args".equals(name)) {
            return null;
        }
        RfPredefinedArg arg = new RfPredefinedArg(this, name, typeInfo, this.fLastMethod, this.fLastStruct, typeInfo.argDefault);
        ((RfPredefinedMethod)this.fLastMethod).addArgument(arg);
        return new ElementContainer(arg);
    }

    public void endMethod() {
        this.fLastMethodLayer = null;
        this.fLastMethod = null;
    }

    private RfPredefinedMethod newPredefinedMethod(String name, String resultType, String args, String eventName, CommentBlock comment) {
        RfPredefinedMethod newPredefinedMethod = new RfPredefinedMethod(this, this.fLastStruct, name, resultType, args, eventName, comment == null ? null : comment.toRawString());
        if (this.isInSDLMode() && this.fLastModule.getName().contains("__etools__sn")) {
            newPredefinedMethod.setEPredefined(true);
        }
        this.fLastStruct.addMethod(newPredefinedMethod);
        return newPredefinedMethod;
    }

    public ElementContainer startField(String name, WrapperType typeInfo, boolean isInstance, boolean isGenerated, boolean isPhysical, int accessType, boolean isSLNTokenField, boolean isSDLScenarioParam, ReparseElement[] reparseStack) {
        if (this.fLastStruct == null || this.fLastModule == null) {
            return null;
        }
        if (this.fLastModule.isInternalModule()) {
            RfField field = this.newPredefinedField(name, typeInfo, isInstance, isGenerated, isPhysical, typeInfo.comment);
            return new ElementContainer(field);
        }
        if (this.fLastStructLayer == null) {
            return null;
        }
        if (typeInfo.isDollar) {
            WrapperType typeWrapper = new WrapperType(null, "uint", typeInfo.line, new CommentBlock("<i>PREDEFINED: </i>Index into the corresponding list.", null, false), reparseStack);
            typeWrapper.baseName = "uint";
            typeWrapper.baseType = 1;
            ElementContainer fieldLayer = this.startField(String.valueOf(name) + "_ind", typeWrapper, false, false, false, 16, false, false, reparseStack);
            fieldLayer.def.setImplicit(true);
            RfType uintType = this.getType("main", true, 2, "uint", -1);
            ((RfField)fieldLayer.element).setAssociatedTypeFrom(this, new RfDummyField(this, uintType));
        }
        RfFieldLayer newFieldLayer = this.fLastStruct.addFieldLayer(this, this.fLastModule, this.fLastStructLayer, name, typeInfo, isInstance, isGenerated, isPhysical, accessType, isSLNTokenField, isSDLScenarioParam, reparseStack);
        return new ElementContainer(newFieldLayer);
    }

    private RfField newPredefinedField(String name, WrapperType typeInfo, boolean isInstance, boolean isGenerated, boolean isPhysical, CommentBlock comment) {
        RfPredefinedField newPredefinedField = new RfPredefinedField(this, this.fLastStruct, name, typeInfo, isInstance, isGenerated, isPhysical, comment == null ? null : comment.toRawString());
        if (this.isInSDLMode() && this.fLastModule.getName().contains("__etools__sn")) {
            newPredefinedField.setEPredefined(true);
        }
        this.fLastStruct.addField(newPredefinedField);
        return newPredefinedField;
    }

    public ElementContainer startFieldTypeConstraint(String name, WrapperType typeInfo, ReparseElement[] reparseStack) {
        if (this.fLastStruct == null || this.fLastModule == null || this.fLastStructLayer == null) {
            return null;
        }
        RfFieldLayer newFieldLayer = this.fLastStruct.addFieldTypeConstraintLayer(this, this.fLastModule, this.fLastStructLayer, name, typeInfo, reparseStack);
        return new ElementContainer(newFieldLayer);
    }

    public ElementContainer startFieldPropConstraint(String fieldName1, String fieldName2, String propertyName, CommentBlock comment, LineInfo line, ReparseElement[] reparseStack) {
        if (this.fLastStruct == null || this.fLastModule == null || this.fLastStructLayer == null) {
            return null;
        }
        RfFieldLayer newFieldLayer = this.fLastStruct.addFieldPropConstraintLayer(this, this.fLastModule, this.fLastStructLayer, fieldName1, fieldName2, propertyName, comment, line, reparseStack);
        return new ElementContainer(newFieldLayer);
    }

    public ElementContainer startEvent(WrapperMethod parseInfo, List<RfWalker.Arg> args) {
        if (this.fLastStruct == null || this.fLastModule == null) {
            return null;
        }
        if (this.fLastModule.isInternalModule()) {
            this.newPredefinedEvent(parseInfo.name, parseInfo.comment);
            return null;
        }
        if (this.fLastStructLayer == null) {
            return null;
        }
        RfEventLayer newEventLayer = this.fLastStruct.addEventLayer(this, this.fLastModule, this.fLastStructLayer, parseInfo.name, parseInfo.kind, parseInfo.startLine, parseInfo.comment, parseInfo.accessType, parseInfo.reparseStack);
        if (parseInfo.kind == 371 || parseInfo.kind == 378) {
            RfMethod eventMethod;
            String onEventMethodName = parseInfo.name;
            if (!this.isSLNModule(this.fLastModule.getParserPath())) {
                onEventMethodName = "on_" + parseInfo.name;
            }
            if ((eventMethod = (RfMethod)this.fLastStruct.getLocalMember(new FullName(onEventMethodName, this.fLastStructLayer.getDeterminant()), 1)) == null || eventMethod.hasNoLayers() || !eventMethod.hasLayerAt(this.fLastModule.getModule().getParserPath(), parseInfo.startLine)) {
                ElementContainer methodLayer = this.startMethod(new WrapperMethod(onEventMethodName, 371, "", "", null, null, false, parseInfo.startLine, parseInfo.startLine, parseInfo.accessType, new CommentBlock("<i>PREDEFINED: </i>[on_event-type() method] The 'on' struct member is implemented as a method, named on_event-type(). You can invoke the action block without the occurrence of the event by calling the on_event-type() method. You can extend the on_event-type() method like any other method, using is, is also, is only, or is first.", null, false), parseInfo.reparseStack, false));
                methodLayer.def.setImplicit(true);
                ((RfMethod)methodLayer.element).setByEvent(true);
                RfMethodLayer prevMethodLayer = this.fLastMethodLayer;
                this.fLastMethodLayer = (RfMethodLayer)methodLayer.def;
                if (this.isSLNModule(this.fLastModule.getParserPath()) && args != null) {
                    for (RfWalker.Arg arg : args) {
                        ElementContainer container = this.startArg(arg.name, arg.type);
                        Object object = ((EAST)arg.argAST).transientResult = container == null ? null : container.element;
                    }
                }
                this.fLastCoverLayer = null;
                this.fLastMacroLayer = null;
                this.fLastPerUnitInstance = null;
                this.fLastMethodLayer = prevMethodLayer;
                this.endMethod();
            }
        }
        if (args != null && this.isSDLModule(this.fLastModule.getParserPath()) && this.fLastStruct.isSDLAgent() && (parseInfo.kind == 371 || parseInfo.kind == 378)) {
            String emitMethodName;
            RfMethod emitMethod;
            String scenarioName = parseInfo.name;
            ElementContainer scenarioContainer = this.startSDLScenario(new WrapperLikeStruct(scenarioName, null, "event_scenario", "sdl", false, false, parseInfo.startLine, parseInfo.startLine, 16, null, parseInfo.reparseStack), this.fLastStruct.getName(), null);
            if (scenarioContainer != null) {
                if (scenarioContainer.def != null) {
                    scenarioContainer.def.setImplicit(true);
                }
                if (scenarioContainer.element instanceof RfStruct) {
                    ((RfStruct)scenarioContainer.element).setParentStructFrom(this, new RfDummyField(this, this.getType("sdl", true, 1, "event_scenario", -1)));
                }
            }
            for (RfWalker.Arg arg : args) {
                ElementContainer fieldLayer = this.startField(arg.name, arg.type, false, false, false, 16, false, false, parseInfo.reparseStack);
                if (fieldLayer == null || fieldLayer.def == null) continue;
                fieldLayer.def.setImplicit(true);
            }
            this.endSDLScenario();
            String lastFieldName = "last_" + scenarioName;
            WrapperType typeWrapper = new WrapperType(scenarioName, String.valueOf(this.fLastStruct.getName()) + "::" + scenarioName, parseInfo.startLine, null, parseInfo.reparseStack);
            typeWrapper.baseName = scenarioName;
            typeWrapper.baseType = 2;
            ElementContainer lastFieldContainer = this.startField(lastFieldName, typeWrapper, false, false, false, 16, false, false, parseInfo.reparseStack);
            if (lastFieldContainer != null && lastFieldContainer.element instanceof RfField && scenarioContainer != null && scenarioContainer.element != null) {
                RfDummyField dummyField = new RfDummyField(this, (IRfNamedElement)scenarioContainer.element, new Determinant(new String[]{scenarioContainer.element.getName()}));
                ((RfField)lastFieldContainer.element).setAssociatedTypeFrom(this, dummyField);
            }
            if ((emitMethod = (RfMethod)this.fLastStruct.getLocalMember(new FullName(emitMethodName = "emit_" + parseInfo.name, this.fLastStructLayer.getDeterminant()), 1)) == null || emitMethod.hasNoLayers() || !emitMethod.hasLayerAt(this.fLastModule.getModule().getParserPath(), parseInfo.startLine)) {
                ElementContainer methodLayer = this.startMethod(new WrapperMethod(emitMethodName, 371, "", "", null, null, false, parseInfo.startLine, parseInfo.startLine, parseInfo.accessType, null, parseInfo.reparseStack, false));
                methodLayer.def.setImplicit(true);
                ((RfMethod)methodLayer.element).setByEvent(true);
                RfMethodLayer prevMethodLayer = this.fLastMethodLayer;
                this.fLastMethodLayer = (RfMethodLayer)methodLayer.def;
                for (RfWalker.Arg arg : args) {
                    ElementContainer container = this.startArg(arg.name, arg.type);
                    Object object = ((EAST)arg.argAST).transientResult = container == null ? null : container.element;
                }
                this.fLastCoverLayer = null;
                this.fLastMacroLayer = null;
                this.fLastPerUnitInstance = null;
                this.fLastMethodLayer = prevMethodLayer;
                this.endMethod();
            }
        }
        return new ElementContainer(newEventLayer);
    }

    private void newPredefinedEvent(String name, CommentBlock comment) {
        RfPredefinedEvent newPredefinedEvent = new RfPredefinedEvent(this, this.fLastStruct, name, comment == null ? null : comment.toRawString());
        if (this.isInSDLMode() && this.fLastModule.getName().contains("__etools__sn")) {
            newPredefinedEvent.setEPredefined(true);
        }
        this.fLastStruct.addEvent(newPredefinedEvent);
    }

    public ElementContainer startCover(String name, int kind, LineInfo startLine, LineInfo endLine, CommentBlock comment, String usingText, ReparseElement[] reparseStack) {
        String commentText;
        if (this.fLastStruct == null || this.fLastModule == null) {
            return null;
        }
        if (this.fLastModule.isInternalModule()) {
            RfEvent event = this.fLastStruct.getEvent(name);
            RfCoverLayer coverLayer = new RfCoverLayer(this.fLastModule, null, kind, startLine, endLine, comment, reparseStack);
            event.addLayer(coverLayer);
            return null;
        }
        if (this.fLastStructLayer == null) {
            return null;
        }
        String string = commentText = comment == null ? null : comment.toRawString();
        if (usingText != null) {
            commentText = commentText == null ? usingText : String.valueOf(commentText) + (commentText.endsWith(".") ? " " : ". ") + usingText;
        }
        RfCoverLayer newCoverLayer = this.fLastStruct.addCoverLayer(this, this.fLastModule, this.fLastStructLayer, name, kind, startLine, endLine, comment, reparseStack);
        this.fLastMethodLayer = null;
        this.fLastCoverLayer = newCoverLayer;
        this.fLastMacroLayer = null;
        return new ElementContainer(newCoverLayer);
    }

    public void endCover() {
        this.fLastCoverLayer = null;
    }

    public void setPerUnitInstanceType(WrapperType perUnitInstance) {
        this.fLastPerUnitInstance = perUnitInstance;
    }

    public ElementContainer startPerUnitInstVar(String name, LineInfo lineInfo, CommentBlock comment) {
        if (this.fLastStruct == null || this.fLastModule == null) {
            return null;
        }
        WrapperType perUnitInstance = this.fLastPerUnitInstance;
        if (perUnitInstance == null || perUnitInstance.baseName == null) {
            perUnitInstance = new WrapperType();
            perUnitInstance.baseName = this.fLastStruct.getName();
            perUnitInstance.line = lineInfo;
            perUnitInstance.def = this.fLastStructLayer == null || this.fLastStructLayer.getDeterminant() == null ? this.fLastStruct.getName() : this.fLastStructLayer.getDeterminant().toString();
        }
        perUnitInstance.baseType = 2;
        perUnitInstance.comment = comment;
        return this.startVar(name, perUnitInstance);
    }

    public ElementContainer startCoverItem(String name, WrapperType typeInfo, int usingKind) {
        if (this.fLastStruct == null || this.fLastModule == null || this.fLastStructLayer == null || this.fLastCoverLayer == null) {
            return null;
        }
        RfVar existing = this.fLastCoverLayer.getLocalVariable(name, typeInfo.line, null);
        if (existing != null) {
            RfVarLayer layer = new RfVarLayer(this, typeInfo, this.fLastModule, this.fLastCoverLayer);
            existing.addLayer(layer);
            return new ElementContainer(layer);
        }
        this.fLastCoverLayer.incItemsNumber();
        RfVarLayer layer = this.fLastCoverLayer.startVarLayer(this, name, typeInfo, this.fLastStructLayer.getStruct(), true, VariableKind.DEFAULT);
        return new ElementContainer(layer);
    }

    public ElementContainer startCoverItem(String name, LineInfo lineInfo, CommentBlock comment, int usingKind) {
        if (this.fLastStruct == null || this.fLastModule == null || this.fLastStructLayer == null || this.fLastCoverLayer == null) {
            return null;
        }
        RfVar existing = this.fLastCoverLayer.getLocalVariable(name, lineInfo, null);
        if (existing != null) {
            RfVarLayer layer = new RfVarLayer(this, name, this.fLastModule, this.fLastStructLayer, lineInfo, comment, VariableKind.DEFAULT);
            existing.addLayer(layer);
            return new ElementContainer(layer);
        }
        this.fLastCoverLayer.incItemsNumber();
        RfVarLayer layer = this.fLastCoverLayer.startVarLayer(this, name, lineInfo, comment, VariableKind.DEFAULT);
        return new ElementContainer(layer);
    }

    public void checkDuplicateCoverItem(RfNamedElement coverItem, RfDefElement currentScope, LineInfo lineInfo, int usingKind, ParserPath parserPath, int varOffset) {
        if (!(coverItem instanceof RfCoverItem) || !(currentScope instanceof RfCoverLayer) || usingKind == 376) {
            return;
        }
        String itemName = coverItem.getName();
        varOffset = varOffset > 0 && lineInfo.virtOffset <= 0 ? varOffset : lineInfo.realOffset;
        int endOffset = lineInfo.virtOffset > 0 ? varOffset : varOffset + itemName.length();
        List<RfDefElement> layers = coverItem.getLayers();
        for (RfDefElement layer : layers) {
            RfCoverLayer otherCoverLayer;
            if (!(layer instanceof RfVarLayer)) continue;
            RfVarLayer otherItemLayer = (RfVarLayer)layer;
            if (otherItemLayer.getParserPath().equals((Object)parserPath) && otherItemLayer.getStartOffset() >= lineInfo.realOffset) {
                return;
            }
            if (!(otherItemLayer.getEnclosingScope() instanceof RfCoverLayer) || !(otherCoverLayer = (RfCoverLayer)otherItemLayer.getEnclosingScope()).isSameLayerInstance(((RfCoverLayer)currentScope).getLayerInstanceExpression())) continue;
            RfNamedElement declarationElement = otherCoverLayer.getNamedElement();
            if (declarationElement != null && declarationElement.equals(currentScope.getNamedElement())) {
                this.addSemanticError1(1, "DUPLICATE_COVER_ITEM: Cover item ''{0}'' was previously defined\n    at line {1,number,#######} in {2}", varOffset, endOffset, null, lineInfo.line, parserPath, itemName, otherItemLayer.getStartLine(), otherItemLayer.getParserPath());
            }
            return;
        }
    }

    public void startCoverCross(String usingName, List<String> itemNames, LineInfo lineInfo, CommentBlock comment, String usingText) {
        String commentText;
        if (this.fLastStruct == null || this.fLastModule == null || this.fLastStructLayer == null || this.fLastCoverLayer == null) {
            return;
        }
        String string = commentText = comment == null ? null : comment.toRawString();
        if (usingText != null) {
            commentText = commentText == null ? usingText : String.valueOf(commentText) + (commentText.endsWith(".") ? " " : ". ") + usingText;
        }
        StringBuilder fullName = new StringBuilder();
        if (usingName != null && !usingName.isEmpty()) {
            fullName.append(usingName);
        } else {
            fullName.append("cross");
            for (String itemName : itemNames) {
                fullName.append("__").append(itemName);
            }
        }
        WrapperType typeInfo = new WrapperType("", "", lineInfo, comment, null);
        RfVarLayer varLayer = this.fLastCoverLayer.startVarLayer(this, fullName.toString(), typeInfo, this.fLastStructLayer.getStruct(), false, VariableKind.DEFAULT);
        varLayer.getVariable().setKind(1);
        varLayer.getVariable().setCoverCrossItems(itemNames);
        this.fLastCoverLayer.incCrossesNumber();
    }

    public void startCoverTrans(String usingName, String name, LineInfo line, CommentBlock comment, String usingText) {
        String commentText;
        if (this.fLastStruct == null || this.fLastModule == null || this.fLastStructLayer == null || this.fLastCoverLayer == null) {
            return;
        }
        String string = commentText = comment == null ? null : comment.toRawString();
        if (usingText != null) {
            commentText = commentText == null ? usingText : String.valueOf(commentText) + (commentText.endsWith(".") ? " " : ". ") + usingText;
        }
        String fullName = null;
        fullName = usingName != null && usingName.length() > 0 ? usingName : "transition__" + name;
        WrapperType typeInfo = new WrapperType("", "", line, comment, null);
        RfVarLayer varLayer = this.fLastCoverLayer.startVarLayer(this, fullName, typeInfo, this.fLastStructLayer.getStruct(), false, VariableKind.DEFAULT);
        varLayer.getVariable().setKind(2);
        this.fLastCoverLayer.incTransitionsNumber();
    }

    public RfCoverLayer getEnclosingCoverLayer() {
        return this.fLastCoverLayer;
    }

    public ElementContainer startOnEvent(String name, LineInfo startLine, LineInfo endLine, CommentBlock comment, ReparseElement[] reparseStack) {
        if (this.fLastStruct == null || this.fLastModule == null || this.fLastStructLayer == null) {
            return null;
        }
        this.fLastCoverLayer = null;
        this.fLastMacroLayer = null;
        this.fLastPerUnitInstance = null;
        this.fLastMethodLayer = this.fLastStruct.addOnEventLayer(this, this.fLastModule, this.fLastStructLayer, name, startLine, endLine, comment, reparseStack);
        return new ElementContainer(this.fLastMethodLayer);
    }

    public void startImport(String filePath, LineInfo line) {
        if (this.fLastModule == null) {
            return;
        }
        this.fLastModule.addImportFilePath(filePath, line);
    }

    public ElementContainer startExpect(boolean expectNoAssume, String name, String expression, boolean defaultDutError, String literal, int kind, LineInfo line, LineInfo endLine, CommentBlock comment, ReparseElement[] reparseStack) {
        if (this.fLastStruct == null || this.fLastModule == null || this.fLastStructLayer == null) {
            return null;
        }
        RfExpectLayer newExpectLayer = this.fLastStruct.addExpectLayer(this, this.fLastModule, this.fLastStructLayer, name, expectNoAssume, expression, defaultDutError, literal, kind, line, endLine, comment, reparseStack);
        return new ElementContainer(newExpectLayer);
    }

    public void startCheckThat(String name, String expression, boolean defaultDutError, String literal, LineInfo line, LineInfo endLine, CommentBlock comment) {
        if (this.fLastModule == null || this.fLastStruct == null) {
            return;
        }
        this.fLastModule.addCheckThatAction(name, this.fLastStruct.getName(), this.fLastStruct.getPackageName(), expression, defaultDutError, literal, line, endLine, comment);
    }

    public void startAssert(String expression, boolean defaultError, String literal, LineInfo line, LineInfo endLine, CommentBlock comment) {
        if (this.fLastModule == null || this.fLastStruct == null) {
            return;
        }
        this.fLastModule.addAssertAction(this.fLastStruct.getName(), this.fLastStruct.getPackageName(), expression, defaultError, literal, line, endLine, comment);
    }

    public void startMessage(boolean messagef, String literal, LineInfo line) {
        if (this.fLastModule == null) {
            return;
        }
        this.fLastModule.addMessageAction(messagef, literal, line);
    }

    public ElementContainer startConstraint(String name, int kind, LineInfo line, LineInfo endLine, CommentBlock comment, ReparseElement[] reparseStack) {
        RfConstraintLayer newConstraintLayer;
        if (this.fLastStruct == null || this.fLastModule == null || this.fLastStructLayer == null) {
            return null;
        }
        this.fLastConstraintLayer = newConstraintLayer = this.fLastStruct.addConstraintLayer(this, this.fLastModule, this.fLastStructLayer, name, kind, line, endLine, comment, reparseStack);
        return new ElementContainer(newConstraintLayer);
    }

    public void endConstraint() {
        this.fLastConstraintLayer = null;
    }

    public RfActionBlockLayer startKeepActionBlock(WrapperActionBlock parseInfo, boolean createdByIsA) {
        if (createdByIsA && !this.fActionLayersStack.isEmpty() && this.fActionLayersStack.peek().fCreatedByIsA) {
            return this.fActionLayersStack.peek();
        }
        RfActionBlockLayer newActionBlockLayer = null;
        if (this.fActionLayersStack.isEmpty()) {
            if (this.fLastConstraintLayer != null) {
                newActionBlockLayer = this.fLastConstraintLayer.addActionLayer(parseInfo, this.fLastModule);
            } else if (this.fLastStructLayer != null) {
                newActionBlockLayer = this.fLastStructLayer.addActionLayer(parseInfo, this.fLastModule);
            }
        } else {
            RfActionBlockLayer currentActionBlockLayer = this.fActionLayersStack.peek();
            if (currentActionBlockLayer != null) {
                newActionBlockLayer = currentActionBlockLayer.addActionLayer(parseInfo, this.fLastModule);
            }
        }
        if (newActionBlockLayer != null) {
            newActionBlockLayer.fCreatedByIsA = createdByIsA;
            this.fActionLayersStack.push(newActionBlockLayer);
        }
        return newActionBlockLayer;
    }

    public int getActionLayerStackSize() {
        return this.fActionLayersStack.size();
    }

    public RfActionBlockLayer startActionBlock(WrapperActionBlock parseInfo, boolean createdByIsA) {
        if (createdByIsA && !this.fActionLayersStack.isEmpty() && this.fActionLayersStack.peek().fCreatedByIsA) {
            return this.fActionLayersStack.peek();
        }
        RfActionBlockLayer newActionBlockLayer = null;
        if (this.fActionLayersStack.isEmpty()) {
            if (this.fLastMethodLayer != null) {
                newActionBlockLayer = this.fLastMethodLayer.addActionLayer(parseInfo, this.fLastModule);
            } else if (this.fLastCoverLayer != null) {
                newActionBlockLayer = this.fLastCoverLayer.addActionLayer(parseInfo, this.fLastModule);
            } else if (this.fLastConstraintLayer != null) {
                newActionBlockLayer = this.fLastConstraintLayer.addActionLayer(parseInfo, this.fLastModule);
            } else if (this.fLastStructLayer != null) {
                newActionBlockLayer = this.fLastStructLayer.addActionLayer(parseInfo, this.fLastModule);
                if (this.fLastStruct.isSLNAction()) {
                    this.fLastStruct.setSLNCompoundActionBlockLayer(newActionBlockLayer);
                }
            } else if (this.fLastMacroLayer != null) {
                newActionBlockLayer = this.fLastMacroLayer.addActionLayer(parseInfo, this.fLastModule);
            }
        } else {
            RfActionBlockLayer currentActionBlockLayer = this.fActionLayersStack.peek();
            if (currentActionBlockLayer != null) {
                newActionBlockLayer = currentActionBlockLayer.addActionLayer(parseInfo, this.fLastModule);
            }
        }
        if (newActionBlockLayer != null) {
            newActionBlockLayer.fCreatedByIsA = createdByIsA;
            this.fActionLayersStack.push(newActionBlockLayer);
        }
        return newActionBlockLayer;
    }

    public void endKeepActionBlock() {
        this.endActionBlock();
    }

    public void cleanActionBlockStack() {
        this.fActionLayersStack.clear();
    }

    public void endActionBlock() {
        if (!this.fActionLayersStack.isEmpty()) {
            RfActionBlockLayer actionBlockLayer = this.fActionLayersStack.pop();
            actionBlockLayer.performAdditionalSemanticChecks(this, null, null, this.fLastModule.getParserPath());
        }
    }

    public void endActionBlockIsA(LineInfo endLine) {
        if (!this.fActionLayersStack.isEmpty() && this.fActionLayersStack.peek().fCreatedByIsA) {
            RfActionBlockLayer actionBlockLayer = this.fActionLayersStack.pop();
            actionBlockLayer.overwriteLayerEnd(endLine);
            actionBlockLayer.performAdditionalSemanticChecks(this, null, null, this.fLastModule.getParserPath());
        }
    }

    public ElementContainer startArg(String name, WrapperType typeInfo) {
        if ("__dvt_variable_nof_args".equals(name) || "__dvt_ignore_args".equals(name)) {
            return null;
        }
        if (this.fLastModule == null) {
            return null;
        }
        if (this.fLastModule.isInternalModule() && this.fLastMethod instanceof RfPredefinedMethod) {
            RfPredefinedArg arg = new RfPredefinedArg(this, name, typeInfo, this.fLastMethod, this.fLastStruct, typeInfo.argDefault);
            ((RfPredefinedMethod)this.fLastMethod).addArgument(arg);
            return new ElementContainer(arg);
        }
        if (this.fLastMethodLayer == null) {
            return null;
        }
        RfArgLayer layer = this.fLastMethodLayer.startArgLayer(this, name, typeInfo);
        return new ElementContainer(layer);
    }

    public ElementContainer startVar(String name, WrapperType typeInfo) {
        return this.startVar(name, typeInfo, false, VariableKind.DEFAULT);
    }

    public ElementContainer startItVar(String name, WrapperType typeInfo, VariableKind kind) {
        return this.startVar(name, typeInfo, false, kind);
    }

    public ElementContainer startVar(String name, WrapperType typeInfo, boolean takeVarOrFieldType, VariableKind kind) {
        if (!this.fActionLayersStack.isEmpty()) {
            RfActionBlockLayer currentActionBlockLayer = this.fActionLayersStack.peek();
            RfVarLayer varLayer = currentActionBlockLayer.startVarLayer(this, name, typeInfo, this.fLastStruct, takeVarOrFieldType, kind);
            return new ElementContainer(varLayer);
        }
        return null;
    }

    public ElementContainer startVar(String name, LineInfo lineInfo, CommentBlock comment) {
        return this.startVar(name, lineInfo, null, false, comment, VariableKind.DEFAULT);
    }

    public ElementContainer startVar(String name, LineInfo lineInfo, AST exprNode, boolean isItem, CommentBlock comment, VariableKind kind) {
        if (!this.fActionLayersStack.isEmpty()) {
            RfActionBlockLayer currentActionBlockLayer = this.fActionLayersStack.peek();
            RfVarLayer varLayer = currentActionBlockLayer.startVarLayer(this, name, lineInfo, comment, kind);
            return new ElementContainer(varLayer);
        }
        return null;
    }

    public ElementContainer startKeepVar(String name, LineInfo lineInfo, AST exprNode, boolean isItem, CommentBlock comment) {
        return this.startVar(name, lineInfo, exprNode, isItem, comment, VariableKind.DEFAULT);
    }

    public ElementContainer startKeepVar(String name, WrapperType type, VariableKind kind) {
        return this.startItVar(name, type, kind);
    }

    public void startBindMethodCall(String name, List<AST> argExpressions, LineInfo line) {
        if (!this.fActionLayersStack.isEmpty()) {
            RfActionBlockLayer currentActionBlockLayer = this.fActionLayersStack.peek();
            currentActionBlockLayer.startBindMethodCallLayer(this, name, argExpressions, line);
        }
    }

    public void startSDLToolEditorPrioritizeCall(String role1, String role2, String scenarioInvocationKind, LineInfo line) {
        if (!this.fActionLayersStack.isEmpty()) {
            RfActionBlockLayer currentActionBlockLayer = this.fActionLayersStack.peek();
            currentActionBlockLayer.startSDLToolEditorPrioritizeCall(role1, role2, scenarioInvocationKind, line);
        }
    }

    public void startSDLToolEditorAvoidCall(String role1, String role2, String inout, LineInfo line) {
        if (!this.fActionLayersStack.isEmpty()) {
            RfActionBlockLayer currentActionBlockLayer = this.fActionLayersStack.peek();
            currentActionBlockLayer.startSDLToolEditorAvoidCall(role1, role2, inout, line);
        }
    }

    public List<RfSDLToolEditorPrioritizeCallLayer> collectSDLToolEditorPrioritizeCalls() {
        ArrayList<RfSDLToolEditorPrioritizeCallLayer> result = new ArrayList<RfSDLToolEditorPrioritizeCallLayer>();
        List<RfStruct> candidates = this.getStructsWithPrefix(1, "tool_editor");
        if (candidates != null && !candidates.isEmpty()) {
            candidates.get(0).collectSDLToolEditorPrioritizeCalls(result);
        }
        return result;
    }

    public List<RfSDLToolEditorAvoidCallLayer> collectSDLToolEditorAvoidCalls() {
        ArrayList<RfSDLToolEditorAvoidCallLayer> result = new ArrayList<RfSDLToolEditorAvoidCallLayer>();
        List<RfStruct> candidates = this.getStructsWithPrefix(1, "tool_editor");
        if (candidates != null && !candidates.isEmpty()) {
            candidates.get(0).collectSDLToolEditorAvoidCalls(result);
        }
        return result;
    }

    public final <T extends RfNamedElement> T filterDeclaredAfter(T candidate, int maxModuleIndex) {
        if (candidate == null) {
            return null;
        }
        if (!this.fIncremental || maxModuleIndex < 0) {
            return candidate;
        }
        if (candidate instanceof RfPredefinedStruct || candidate instanceof RfPredefinedScalar || candidate instanceof RfPredefinedEvent || candidate instanceof RfPredefinedMethod || candidate instanceof RfPredefinedField || candidate instanceof RfPredefinedArg || candidate instanceof RfPredefinedVar) {
            return candidate;
        }
        RfDefElement declaration = candidate.getDeclaration();
        if (declaration == null) {
            return candidate;
        }
        if (declaration.getModuleIndex() <= maxModuleIndex) {
            return candidate;
        }
        return null;
    }

    public Set<String> getPackageSearchDisambiguation(RfModule module) {
        if (module == null) {
            return null;
        }
        HashSet<String> packageNames = new HashSet<String>();
        packageNames.add(module.getPackageName());
        List<ImportFilePath> filePaths = module.getImportedFilePaths();
        if (filePaths == null || filePaths.isEmpty()) {
            return null;
        }
        for (ImportFilePath filePath : filePaths) {
            String lastSegment = filePath.getFilePath().lastSegment();
            RfModule importedModule = this.getModuleUsingLastSegment(lastSegment);
            if (importedModule == null) continue;
            packageNames.add(importedModule.getPackageName());
        }
        if (packageNames.isEmpty()) {
            return null;
        }
        return packageNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RfType getType(String packageName, String strictPackageName, int typeKind, String typeName, int maxModuleIndex, ParserPath parserPath, LineInfo packageLineInfo, LineInfo lineInfo) {
        if (strictPackageName != null) {
            String noTypeErrorMessage;
            RfStruct packg = this.getPackage(strictPackageName);
            RfType result = packg == null ? null : packg.getType(typeName);
            result = this.filterDeclaredAfter(result, maxModuleIndex);
            String string = noTypeErrorMessage = typeKind == 8 ? "UNDEFINED_TEMPLATE: No template called ''{1}::{0}''" : "UNDEFINED_TYPE: No type called ''{1}::{0}''";
            if (result == null) {
                this.addSemanticError1(1, noTypeErrorMessage, packageLineInfo.getOffset(), lineInfo.getOffset() + typeName.length(), null, lineInfo.line, parserPath, typeName, strictPackageName);
            } else if (!packageName.equals(strictPackageName) && !result.isPublic()) {
                this.addSemanticError1(1, "TYPE_ACCESS: Cannot access type ''{0}'' of package ''{1}''", lineInfo.getOffset(), lineInfo.getOffset() + typeName.length(), null, lineInfo.line, parserPath, typeName, result.getPackageName());
            } else {
                this.checkTypeKind(result, typeKind, typeName, parserPath, lineInfo);
            }
            return result;
        }
        RfStruct currPackage = this.getPackage(packageName);
        if (currPackage == null) {
            return null;
        }
        RfType result = currPackage.getType(typeName);
        if (result != null) {
            this.checkTypeKind(result, typeKind, typeName, parserPath, lineInfo);
            return result;
        }
        ArrayList<RfType> publicCandidates = new ArrayList<RfType>(2);
        ArrayList<RfType> packageCandidates = new ArrayList<RfType>(2);
        String noTypeErrorMessage = typeKind == 8 ? "UNDEFINED_TEMPLATE: No template called ''{0}''" : "UNDEFINED_TYPE: No type called ''{0}''";
        Set<String> packageRestictions = this.getPackageSearchDisambiguation(this.getModule(parserPath));
        int nofSearches = packageRestictions == null || packageRestictions.isEmpty() ? 1 : 2;
        int i = 0;
        while (i < nofSearches) {
            Map<String, RfStruct> map = this.fPackages;
            synchronized (map) {
                for (RfStruct packageCandidate : this.fPackages.values()) {
                    if (packageCandidate == currPackage || i == 0 && packageRestictions != null && !packageRestictions.contains(packageCandidate.getName()) || (result = packageCandidate.getType(typeName)) == null || (result = this.filterDeclaredAfter(result, maxModuleIndex)) == null) continue;
                    if (result.isPublic()) {
                        publicCandidates.add(result);
                    } else if (packageCandidates.size() < 2) {
                        packageCandidates.add(result);
                    }
                    if (publicCandidates.size() == 2) break;
                }
                if (publicCandidates.size() == 1) {
                    result = (RfType)publicCandidates.get(0);
                    this.checkTypeKind(result, typeKind, typeName, parserPath, lineInfo);
                    return result;
                }
                if (publicCandidates.size() == 2) {
                    this.multiplePackageOrComponentError((RfType)publicCandidates.get(0), (RfType)publicCandidates.get(1), typeName, lineInfo, parserPath);
                    return (RfType)publicCandidates.get(0);
                }
                if (packageCandidates.size() == 1) {
                    this.addSemanticError1(1, "TYPE_ACCESS: Cannot access type ''{0}'' of package ''{1}''", lineInfo.getOffset(), lineInfo.getOffset() + typeName.length(), null, lineInfo.line, parserPath, typeName, ((RfType)packageCandidates.get(0)).getPackageName());
                    return (RfType)packageCandidates.get(0);
                }
                if (packageCandidates.size() == 2) {
                    this.multiplePackageOrComponentError((RfType)packageCandidates.get(0), (RfType)packageCandidates.get(1), typeName, lineInfo, parserPath);
                    return (RfType)packageCandidates.get(0);
                }
            }
            ++i;
        }
        this.addSemanticError1(1, noTypeErrorMessage, lineInfo.getOffset(), lineInfo.getOffset() + typeName.length(), null, lineInfo.line, parserPath, typeName);
        return null;
    }

    private void multiplePackageOrComponentError(RfType candidate1, RfType candidate2, String typeName, LineInfo lineInfo, ParserPath parserPath) {
        if (this.isInSLNMode()) {
            if (candidate1 instanceof RfStruct && ((RfStruct)candidate1).isSLNAction() && candidate2 instanceof RfStruct && ((RfStruct)candidate2).isSLNAction()) {
                RfStruct slnEnclosingComponent1 = ((RfStruct)candidate1).getSLNEnclosingComponent();
                RfStruct slnEnclosingComponent2 = ((RfStruct)candidate2).getSLNEnclosingComponent();
                if (slnEnclosingComponent1 != null && slnEnclosingComponent2 != null) {
                    String componentName1 = slnEnclosingComponent1.getName();
                    String componentName2 = slnEnclosingComponent2.getName();
                    this.addSemanticError1(1, "MULTIPLE_COMPONENTS: Type name ''{0}'' exists in multiple components (''{1}'', ''{2}'', and possibly others)", lineInfo.getOffset(), lineInfo.getOffset() + typeName.length(), null, lineInfo.line, parserPath, typeName, componentName1, componentName2);
                    return;
                }
            }
        } else if (this.isInSDLMode() && candidate1 instanceof RfStruct && ((RfStruct)candidate1).isSDLScenario() && candidate2 instanceof RfStruct && ((RfStruct)candidate2).isSDLScenario()) {
            RfStruct sdlEnclosingAgent1 = ((RfStruct)candidate1).getSDLEnclosingAgent();
            RfStruct sdlEnclosingAgent2 = ((RfStruct)candidate2).getSDLEnclosingAgent();
            if (sdlEnclosingAgent1 != null && sdlEnclosingAgent2 != null) {
                String agentName1 = sdlEnclosingAgent1.getName();
                String agentName2 = sdlEnclosingAgent2.getName();
                this.addSemanticError1(1, "MULTIPLE_AGENTS: Type name ''{0}'' exists in multiple agents (''{1}'', ''{2}'', and possibly others)", lineInfo.getOffset(), lineInfo.getOffset() + typeName.length(), null, lineInfo.line, parserPath, typeName, agentName1, agentName2);
                return;
            }
        }
        String packageName1 = candidate1.getPackageName();
        String packageName2 = candidate2.getPackageName();
        this.addSemanticError1(1, "MULTIPLE_PACKAGES: Type name ''{0}'' exists in multiple packages (''{1}'', ''{2}'', and possibly others)", lineInfo.getOffset(), lineInfo.getOffset() + typeName.length(), null, lineInfo.line, parserPath, typeName, packageName1, packageName2);
    }

    private void checkTypeKind(RfType result, int typeKind, String typeName, ParserPath parserPath, LineInfo lineInfo) {
        if (typeKind == 8 && !(result instanceof RfTemplateStruct)) {
            this.addSemanticError1(1, "REQUESTED_TYPE: ''{1}::{0}'' it is not a {2} type", lineInfo.getOffset(), lineInfo.getOffset() + typeName.length(), null, lineInfo.line, parserPath, typeName, result.getPackageName(), "template");
        } else if (!(typeKind != 16 || result instanceof RfStruct && ((RfStruct)result).isInterface())) {
            this.addSemanticError1(1, "REQUESTED_TYPE: ''{1}::{0}'' it is not a {2} type", lineInfo.getOffset(), lineInfo.getOffset() + typeName.length(), null, lineInfo.line, parserPath, typeName, result.getPackageName(), "interface");
        } else if (typeKind == 1 && !(result instanceof RfStruct)) {
            this.addSemanticError1(1, "REQUESTED_TYPE: ''{1}::{0}'' it is not a {2} type", lineInfo.getOffset(), lineInfo.getOffset() + typeName.length(), null, lineInfo.line, parserPath, typeName, result.getPackageName(), "struct");
        } else if (typeKind == 2 && !(result instanceof RfScalarType)) {
            this.addSemanticError1(1, "REQUESTED_TYPE: ''{1}::{0}'' it is not a {2} type", lineInfo.getOffset(), lineInfo.getOffset() + typeName.length(), null, lineInfo.line, parserPath, typeName, result.getPackageName(), "scalar");
        } else if (typeKind == 4 && !(result instanceof RfMethodType)) {
            this.addSemanticError1(1, "REQUESTED_TYPE: ''{1}::{0}'' it is not a {2} type", lineInfo.getOffset(), lineInfo.getOffset() + typeName.length(), null, lineInfo.line, parserPath, typeName, result.getPackageName(), "method");
        } else if (result.isNonStandard()) {
            this.addSemanticError3(2, "NON_STANDARD_TYPE: ''{1}::{0}''", lineInfo.getOffset(), lineInfo.getOffset() + typeName.length(), null, lineInfo.line, parserPath, result.getName(), result.getPackageName());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized RfType getType(String packageName, boolean strictPackage, int typeKind, String typeName, int maxModuleIndex) {
        try {
            RfStruct packg = this.getPackage(packageName);
            RfType result = null;
            if (packg != null) {
                result = packg.getType(typeName);
            }
            if (result == null) {
                if (strictPackage) {
                    return null;
                }
                for (RfStruct temp : this.fPackages.values()) {
                    if (temp.getPackageName().equals(packageName) || (result = temp.getType(typeName)) == null) continue;
                    if (!result.isPublic()) {
                        result = null;
                        continue;
                    }
                    if (!((typeKind & 1) == 1 && result instanceof RfStruct || (typeKind & 2) == 2 && result instanceof RfScalarType || (typeKind & 4) == 4 && result instanceof RfMethodType || (typeKind & 0x20) == 32 && result instanceof RfAnnotationType) && typeKind != -1) continue;
                }
            }
            if (result == null) {
                return null;
            }
            if ((typeKind & 1) == 1) {
                if (result instanceof RfStruct) return result;
            }
            if ((typeKind & 2) == 2) {
                if (result instanceof RfScalarType) return result;
            }
            if ((typeKind & 4) == 4) {
                if (result instanceof RfMethodType) return result;
            }
            if ((typeKind & 0x20) == 32) {
                if (result instanceof RfAnnotationType) return result;
            }
            if (typeKind != -1) return null;
            return result;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RfStruct getPackage(String packageName) {
        if (this.fPackages == null) {
            return null;
        }
        Map<String, RfStruct> map = this.fPackages;
        synchronized (map) {
            return this.fPackages.get(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePackage(String packageName) {
        if (this.fPackages == null) {
            return;
        }
        Map<String, RfStruct> map = this.fPackages;
        synchronized (map) {
            this.fPackages.remove(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RfMacro getMacro(String name) {
        if (this.fMacros == null) {
            return null;
        }
        Map<String, RfMacro> map = this.fMacros;
        synchronized (map) {
            return this.fMacros.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RfMacro getPreproc(String name) {
        if (this.fPreprocs == null) {
            return null;
        }
        Map<String, RfMacro> map = this.fPreprocs;
        synchronized (map) {
            return this.fPreprocs.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RfTableDefine getTableDefine(String name) {
        if (this.fTableDefines == null) {
            return null;
        }
        Map<String, RfTableDefine> map = this.fTableDefines;
        synchronized (map) {
            return this.fTableDefines.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllPreprocAsString() {
        if (this.fPreprocs == null) {
            return null;
        }
        Map<String, RfMacro> map = this.fPreprocs;
        synchronized (map) {
            return Collections.unmodifiableSet(new HashSet<String>(this.fPreprocs.keySet()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RfMacro> getPreprocesingWithPrefix(int matchType, String prefix) {
        ArrayList<RfMacro> result = new ArrayList<RfMacro>();
        if (this.fPreprocs == null) {
            return result;
        }
        Map<String, RfMacro> map = this.fPreprocs;
        synchronized (map) {
            for (RfMacro preproc : this.fPreprocs.values()) {
                if (preproc == null || preproc.hasNoLayers() || preproc.isPredefined() || !DVTStringUtil.regionMatches((String)preproc.getName(), (String)prefix, (int)matchType)) continue;
                result.add(preproc);
            }
        }
        return result;
    }

    public RfSpecman getSpecman() {
        return this.fSpecman;
    }

    public RfType getSpecmanOnly(String typeName) {
        return this.fSpecman.getSpecman(typeName);
    }

    public RfStruct getPseudoStruct() {
        return this.fSpecman.getPseudoStruct(this);
    }

    public List<RfType> getTypesWithPrefix(String packageName, boolean strictPackage, int matchType, String prefix, int typeKind) {
        ArrayList<RfType> result = new ArrayList<RfType>();
        Collection<RfStruct> packages = null;
        if (!strictPackage) {
            packages = this.fPackages.values();
        } else {
            packages = new ArrayList<RfStruct>();
            RfStruct packg = this.fPackages.get(packageName);
            if (packg != null) {
                packages.add(packg);
            }
        }
        for (RfStruct packg : packages) {
            Collection<RfType> types = packg.getTypes();
            for (RfType type : types) {
                if (type.isPackage() && (packageName == null && !"main".equals(type.getPackageName()) || packageName != null && !packageName.equals(type.getPackageName())) || !((typeKind & 1) == 1 && type instanceof RfStruct || (typeKind & 2) == 2 && type instanceof RfScalarType || (typeKind & 4) == 4 && type instanceof RfMethodType) && typeKind != -1 || !DVTStringUtil.regionMatches((String)type.getName(), (String)prefix, (int)matchType)) continue;
                result.add(type);
            }
        }
        return result;
    }

    public Set<String> getDuplicateNames() {
        HashSet<String> duplicateNames = new HashSet<String>();
        HashSet<String> uniqueNames = new HashSet<String>();
        for (RfStruct rfPackage : this.fPackages.values()) {
            for (RfType rfType : rfPackage.getTypes()) {
                String name = rfType.getName();
                if (uniqueNames.contains(name)) {
                    duplicateNames.add(name);
                }
                uniqueNames.add(name);
            }
        }
        return duplicateNames;
    }

    public List<RfType> getTypesWithPrefixConsideringAmbiguities(String packageName, boolean strictPackage, int matchType, String prefix, int typeKind, String alreadyWrittenText) {
        String[] components;
        if (alreadyWrittenText.contains(" ")) {
            components = alreadyWrittenText.split(" ");
            alreadyWrittenText = components[components.length - 1];
        }
        if (alreadyWrittenText.contains("::")) {
            components = DVTStringUtil.split((Pattern)DVTStringUtil.COLON_COLON, (String)alreadyWrittenText);
            alreadyWrittenText = components[components.length - 1];
        }
        ArrayList<RfType> result = new ArrayList<RfType>();
        Collection<RfStruct> packages = null;
        Set<String> duplicateNames = this.getDuplicateNames();
        if (!strictPackage) {
            packages = this.fPackages.values();
        } else {
            packages = new ArrayList<RfStruct>(1);
            RfStruct packg = this.fPackages.get(packageName);
            if (packg != null) {
                packages.add(packg);
            }
        }
        for (RfStruct packg : packages) {
            Collection<RfType> types = packg.getTypes();
            for (RfType type : types) {
                if (type.isPackage() && (packageName == null && !"main".equals(type.getPackageName()) || packageName != null && !packageName.equals(type.getPackageName())) || type instanceof RfAnnotationType || !((typeKind & 1) == 1 && type instanceof RfStruct || (typeKind & 2) == 2 && type instanceof RfScalarType || (typeKind & 4) == 4 && type instanceof RfMethodType || (typeKind & 0x20) == 32 && type instanceof RfAnnotationType) && typeKind != -1 || !DVTStringUtil.regionMatches((String)type.getName(), (String)prefix, (int)matchType) || alreadyWrittenText.equals(type.getName())) continue;
                if (duplicateNames.contains(type.getName())) {
                    result.add(new R2LAmbiguousType(type));
                    continue;
                }
                result.add(type);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RfNamedElement> getAllTypes(boolean includePredefined, boolean enableSort) {
        Map<String, RfStruct> map = this.fPackages;
        synchronized (map) {
            ArrayList<RfNamedElement> nonEmptyNamedElements = new ArrayList<RfNamedElement>();
            for (RfStruct packg : this.fPackages.values()) {
                Collection<RfType> types = packg.getTypes();
                for (RfNamedElement rfNamedElement : types) {
                    if (rfNamedElement instanceof RfAnnotationType || rfNamedElement == null || rfNamedElement.hasNoLayers() && !includePredefined) continue;
                    nonEmptyNamedElements.add(rfNamedElement);
                }
            }
            RfType[] tmpElements = nonEmptyNamedElements.toArray(new RfType[nonEmptyNamedElements.size()]);
            if (enableSort) {
                RfNamedElementComparator comparator = new RfNamedElementComparator();
                Arrays.sort(tmpElements, comparator);
            }
            ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>(tmpElements.length);
            int i = 0;
            while (i < tmpElements.length) {
                result.add(tmpElements[i]);
                ++i;
            }
            return result;
        }
    }

    public RfMacro getTableMacro(RfMacro generalTableMacro, IFile file, int offset) {
        List<RfDefElement> tableLayers = generalTableMacro.getLayers();
        if (tableLayers == null || tableLayers.isEmpty()) {
            return null;
        }
        ParserPath parserPath = this.resource2parser((IResource)file);
        if (parserPath == null) {
            return null;
        }
        for (RfDefElement layer : tableLayers) {
            if (!parserPath.equals((Object)layer.getParserPath())) continue;
            int startOffset = layer.getStartOffset();
            int endOffset = layer.getEndOffset();
            if (startOffset > offset || offset > endOffset) continue;
            RfMacro tableMacro = new RfMacro(this, "__etools__table'__etools__expansion", ((RfMacroLayer)layer).getMacroInstanceStringLiteral(), "__etools__expansion", false, false, false);
            tableMacro.addLayer(layer);
            return tableMacro;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RfMacro> getAllMacros(boolean includePreprocessing, boolean includeTables) {
        ArrayList<RfMacro> nonEmptyNamedElements = new ArrayList<RfMacro>();
        Map<String, RfMacro> map = this.fMacros;
        synchronized (map) {
            for (RfMacro macro : this.fMacros.values()) {
                if (macro == null || macro.hasNoLayers() || macro.isPredefined()) continue;
                if (includeTables && "__etools__table'__etools__expansion".equals(macro.getName())) {
                    List<RfDefElement> tableLayers = macro.getLayers();
                    if (tableLayers == null || tableLayers.isEmpty()) continue;
                    for (RfDefElement layer : tableLayers) {
                        RfMacro tableMacro = new RfMacro(this, "__etools__table'__etools__expansion", ((RfMacroLayer)layer).getMacroInstanceStringLiteral(), "__etools__expansion", false, false, false);
                        nonEmptyNamedElements.add(tableMacro);
                        tableMacro.addLayer(layer);
                    }
                    continue;
                }
                nonEmptyNamedElements.add(macro);
            }
        }
        map = this.fPreprocs;
        synchronized (map) {
            if (includePreprocessing) {
                for (RfMacro el : this.fPreprocs.values()) {
                    if (el == null || el.hasNoLayers() || el.isPredefined()) continue;
                    nonEmptyNamedElements.add(el);
                }
            }
        }
        RfMacro[] tmpElements = nonEmptyNamedElements.toArray(new RfMacro[nonEmptyNamedElements.size()]);
        RfNamedElementComparator comparator = new RfNamedElementComparator();
        Arrays.sort(tmpElements, comparator);
        ArrayList<RfMacro> result = new ArrayList<RfMacro>(tmpElements.length);
        int i = 0;
        while (i < tmpElements.length) {
            result.add(tmpElements[i]);
            ++i;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RfNamedElement> getAllPreprocessing() {
        Map<String, RfMacro> map = this.fPreprocs;
        synchronized (map) {
            ArrayList<RfNamedElement> nonEmptyNamedElements = new ArrayList<RfNamedElement>();
            for (RfNamedElement rfNamedElement : this.fPreprocs.values()) {
                if (rfNamedElement == null || rfNamedElement.hasNoLayers()) continue;
                nonEmptyNamedElements.add(rfNamedElement);
            }
            RfNamedElement[] rfNamedElementArray = nonEmptyNamedElements.toArray(new RfNamedElement[nonEmptyNamedElements.size()]);
            RfNamedElementComparator comparator = new RfNamedElementComparator();
            Arrays.sort(rfNamedElementArray, comparator);
            ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>(rfNamedElementArray.length);
            int i = 0;
            while (i < rfNamedElementArray.length) {
                result.add(rfNamedElementArray[i]);
                ++i;
            }
            return result;
        }
    }

    public List<RfStruct> getStructsWithPrefix(int matchType, String prefix) {
        NullProtectedList<RfStruct> result = new NullProtectedList<RfStruct>();
        for (RfStruct struct : this.getAllStructs()) {
            if (!DVTStringUtil.regionMatches((String)struct.getName(), (String)prefix, (int)matchType)) continue;
            result.add(struct);
        }
        return result;
    }

    public ArrayList<RfScalarType> getScalarTypes(boolean includePredefined) {
        ArrayList<RfScalarType> nonEmptyNamedElements = new ArrayList<RfScalarType>();
        for (RfScalarType el : this.getAllScalars()) {
            if (el == null || el.hasNoLayers() && !includePredefined) continue;
            nonEmptyNamedElements.add(el);
        }
        RfScalarType[] tmpElements = nonEmptyNamedElements.toArray(new RfScalarType[nonEmptyNamedElements.size()]);
        RfNamedElementComparator comparator = new RfNamedElementComparator();
        Arrays.sort(tmpElements, comparator);
        ArrayList<RfScalarType> result = new ArrayList<RfScalarType>(tmpElements.length);
        int i = 0;
        while (i < tmpElements.length) {
            result.add(tmpElements[i]);
            ++i;
        }
        return result;
    }

    public ArrayList<RfMethodType> getMethodTypes() {
        ArrayList<RfMethodType> nonEmptyNamedElements = new ArrayList<RfMethodType>();
        for (RfMethodType el : this.getAllMethods()) {
            if (el == null || el.hasNoLayers()) continue;
            nonEmptyNamedElements.add(el);
        }
        RfMethodType[] tmpElements = nonEmptyNamedElements.toArray(new RfMethodType[nonEmptyNamedElements.size()]);
        RfNamedElementComparator comparator = new RfNamedElementComparator();
        Arrays.sort(tmpElements, comparator);
        ArrayList<RfMethodType> result = new ArrayList<RfMethodType>(tmpElements.length);
        int i = 0;
        while (i < tmpElements.length) {
            result.add(tmpElements[i]);
            ++i;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RfModule getModule(ParserPath parserPath) {
        if (parserPath == null) {
            return null;
        }
        Map<ParserPath, RfModule> map = this.fParserPathToModuleMap;
        synchronized (map) {
            return this.fParserPathToModuleMap.get(parserPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RfModule getModuleUsingLastSegment(String moduleName) {
        Map<ParserPath, RfModule> map = this.fParserPathToModuleMap;
        synchronized (map) {
            for (Map.Entry<ParserPath, RfModule> parserPathToModuleEntry : this.fParserPathToModuleMap.entrySet()) {
                ParserPath parserPath = parserPathToModuleEntry.getKey();
                if (!Path.fromOSString((String)parserPath.path).lastSegment().equals(moduleName)) continue;
                return parserPathToModuleEntry.getValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RfModule getModule(IResource file) {
        Map<ParserPath, RfModule> map = this.fParserPathToModuleMap;
        synchronized (map) {
            ParserPath parserPath;
            block4: {
                parserPath = this.resource2parser(file);
                if (parserPath != null) break block4;
                return null;
            }
            return this.fParserPathToModuleMap.get(parserPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RfModule> getAllModules() {
        Map<ParserPath, RfModule> map = this.fParserPathToModuleMap;
        synchronized (map) {
            return this.fParserPathToModuleMap.values();
        }
    }

    public List<ModuleReference> getFullBuildModuleInfos() {
        return this.fFullBuildModuleReferences;
    }

    public void setFullBuildModuleInfos(List<ModuleReference> fullBuildModulesInfo) {
        this.fFullBuildModuleReferences = fullBuildModulesInfo;
    }

    public List<RfField> getGlobalFieldsWithPrefix(String packageName, int matchType, String prefix) {
        RfStruct global = this.fSpecman.getGlobalStruct();
        return global.getFieldsWithPrefix(packageName, null, matchType, prefix, 31);
    }

    public RfField getGlobalFieldWithPrefix(String packageName, int matchType, String prefix) {
        RfStruct global = this.fSpecman.getGlobalStruct();
        return global.getFieldWithPrefix(packageName, null, matchType, prefix, 31);
    }

    public List<RfMethod> getGlobalMethodsWithPrefix(String packageName, int matchType, String prefix) {
        RfStruct global = this.fSpecman.getGlobalStruct();
        return global.getMethodsWithPrefix(packageName, null, matchType, prefix, 31);
    }

    public RfMethod getGlobalMethodWithPrefix(String packageName, int matchType, String prefix) {
        RfStruct global = this.fSpecman.getGlobalStruct();
        return global.getMethodWithPrefix(packageName, null, matchType, prefix, 31);
    }

    public RfModule getCurrentModule() {
        return this.fLastModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanDirtyElements() {
        block18: {
            try {
                Iterator<RfNamedElement> iterator;
                Map<String, RfNamedElement> map;
                if (this.fPackages != null) {
                    map = this.fPackages;
                    synchronized (map) {
                        Iterator<RfStruct> packgIterator = this.fPackages.values().iterator();
                        while (packgIterator.hasNext()) {
                            RfStruct packg = packgIterator.next();
                            Collection<RfType> types = packg.getTypes();
                            if (types != null) {
                                Iterator<RfType> iterator2 = types.iterator();
                                while (iterator2.hasNext()) {
                                    RfType type = iterator2.next();
                                    type.removeDirty(this, packg, iterator2);
                                }
                            }
                            if (!packg.isDirty()) continue;
                            packgIterator.remove();
                        }
                    }
                }
                if (this.fMacros != null) {
                    map = this.fMacros;
                    synchronized (map) {
                        iterator = this.fMacros.values().iterator();
                        while (iterator.hasNext()) {
                            ((RfMacro)iterator.next()).removeDirty(iterator);
                        }
                    }
                }
                if (this.fTableDefines == null) break block18;
                map = this.fTableDefines;
                synchronized (map) {
                    iterator = this.fTableDefines.values().iterator();
                    while (iterator.hasNext()) {
                        ((RfTableDefine)iterator.next()).removeDirty(iterator);
                    }
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public void addListenerUsingResourcePath(IResource resource, IRfModuleListener listener) {
        ParserPath parserPath;
        if (this.fModuleListeners == null) {
            this.fModuleListeners = new HashMap<ParserPath, List<IRfModuleListener>>();
        }
        if ((parserPath = this.resource2parser(resource)) == null) {
            return;
        }
        List<IRfModuleListener> listeners = this.fModuleListeners.get(parserPath);
        if (listeners == null) {
            listeners = new ArrayList<IRfModuleListener>();
            this.fModuleListeners.put(parserPath, listeners);
        }
        listeners.add(listener);
    }

    public void removeListenerUsingResourcePath(IResource resource, IRfModuleListener listener) {
        if (this.fModuleListeners == null) {
            return;
        }
        ParserPath parserPath = this.resource2parser(resource);
        if (parserPath == null) {
            return;
        }
        List<IRfModuleListener> listeners = this.fModuleListeners.get(parserPath);
        if (listeners == null) {
            return;
        }
        listeners.remove(listener);
    }

    public void notifyParsingEndUsingParserPath(ParserPath parserPath) {
        try {
            if (this.fModuleListeners == null) {
                return;
            }
            List<IRfModuleListener> listeners = this.fModuleListeners.get(parserPath);
            if (listeners == null) {
                return;
            }
            for (IRfModuleListener listener : listeners) {
                listener.notifyModuleReparse(this.getModule(parserPath));
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void connectModuleToDocument(String editorID, ParserPath parserPath, DVTEditor editor, boolean connectPositionsAfterEditorFocus) {
        try {
            if (parserPath == null || editor == null) {
                return;
            }
            if (this.fParserPathToEditorMap == null) {
                this.fParserPathToEditorMap = new HashMap<ParserPath, DVTEditor>();
            }
            this.fParserPathToEditorMap.put(parserPath, editor);
            RfModule module = this.getModule(parserPath);
            if (module == null) {
                return;
            }
            IDocument document = editor.getDocument();
            HashMap<Annotation, Position> aditions = new HashMap<Annotation, Position>();
            HashSet<DVTSemanticFoldingPosition> foldingPositions = new HashSet<DVTSemanticFoldingPosition>();
            ArrayList<Position> reflectionPositions = new ArrayList<Position>();
            module.connectPositionToDocument(editorID, aditions, connectPositionsAfterEditorFocus, reflectionPositions);
            this.connectInactiveCodeInfos(parserPath, document);
            ro.amiq.edt.base.utils.Utils.connectPragmaCodePositions(document, module, foldingPositions);
            if (DVTFileUtils.getInstance().shouldIncrementalBuild(document, null, this.getProject())) {
                DVTEditor.addOverrideIndications(aditions, (DVTEditor)editor);
            } else {
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
            }
            if (document != null && document.getNumberOfLines() < ro.amiq.edt.base.utils.Utils.getCodeFoldingNofLines(this.getPluginConfig())) {
                DVTEditor.addSemanticFolding(foldingPositions, (DVTEditor)editor);
            }
            if (!connectPositionsAfterEditorFocus && document != null) {
                DVTDocumentUtils.addDocumentPositions((IDocument)document, (String)"REFLECTION", reflectionPositions);
            }
            CustomPragmaUtils.notifyListeners((IProject)this.fProject);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void connectInactiveCodeInfos(ParserPath parserPath, IDocument document) {
        this.addInactiveCodeInfos(parserPath, document);
        ro.amiq.edt.base.utils.Utils.notifyAddInactiveCodeInfo(parserPath, document);
        ro.amiq.dvt.utils.Utils.notifyHighlightPositionsChange((IDocument)document, (String)"__dvt_inactive_code_position");
    }

    public void addInactiveCodeInfos(ParserPath parserPath, IDocument document) {
        if (document == null) {
            return;
        }
        if (document.containsPositionCategory("__dvt_inactive_code_position")) {
            try {
                document.removePositionCategory("__dvt_inactive_code_position");
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        if (this.fInactiveCodeInfos == null) {
            ro.amiq.dvt.utils.Utils.notifyHighlightPositionsChange((IDocument)document, (String)"__dvt_inactive_code_position");
            return;
        }
        RfInactiveCodeFileInfo infoForFile = this.fInactiveCodeInfos.get(parserPath);
        if (infoForFile == null) {
            ro.amiq.dvt.utils.Utils.notifyHighlightPositionsChange((IDocument)document, (String)"__dvt_inactive_code_position");
            return;
        }
        document.addPositionCategory("__dvt_inactive_code_position");
        infoForFile.connectToDocument(document);
    }

    public void disconnectModuleFromDocument(ParserPath parserPath) {
        RfModule module = this.getModule(parserPath);
        if (module == null) {
            if (this.fParserPathToEditorMap != null) {
                this.fParserPathToEditorMap.remove(parserPath);
            }
            return;
        }
        try {
            module.disconnectPositionFromDocument();
            if (this.fParserPathToEditorMap != null) {
                this.fParserPathToEditorMap.remove(parserPath);
            }
            this.internalRemoveNonTopFile(parserPath, module);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void internalRemoveNonTopFile(ParserPath parserPath, RfModule module) {
        if (module == null || module.fIsInTop || this.fImportedTestFiles != null && this.fImportedTestFiles.containsKey(parserPath)) {
            return;
        }
        this.removeModuleContent(parserPath);
        EQuickViewersUtil.getInstance().removeWaitEditorJob((IFile)module.getFileAdapter());
        if (this.fParserPathToModuleMap != null) {
            this.fParserPathToModuleMap.remove(parserPath);
        }
        CloseNonTopModuleJob closeNonTopModuleJob = new CloseNonTopModuleJob();
        closeNonTopModuleJob.setModule(module);
        closeNonTopModuleJob.schedule(150L);
    }

    public DVTEditor getEditor(ParserPath parserPath) {
        if (this.fParserPathToEditorMap == null) {
            return null;
        }
        return this.fParserPathToEditorMap.get(parserPath);
    }

    public IProject getProject() {
        return this.fProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RfStruct> getAllStructs() {
        ArrayList<RfStruct> result = new ArrayList<RfStruct>();
        if (this.fPackages == null) {
            return result;
        }
        Map<String, RfStruct> map = this.fPackages;
        synchronized (map) {
            for (RfStruct packg : this.fPackages.values()) {
                Collection<RfType> types = packg.getTypes();
                for (RfType type : types) {
                    if (!(type instanceof RfStruct)) continue;
                    result.add((RfStruct)type);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RfScalarType> getAllScalars() {
        ArrayList<RfScalarType> result = new ArrayList<RfScalarType>();
        if (this.fPackages == null) {
            return result;
        }
        Map<String, RfStruct> map = this.fPackages;
        synchronized (map) {
            for (RfStruct packg : this.fPackages.values()) {
                Collection<RfType> types = packg.getTypes();
                for (RfType type : types) {
                    if (!(type instanceof RfScalarType)) continue;
                    result.add((RfScalarType)type);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RfMethodType> getAllMethods() {
        ArrayList<RfMethodType> result = new ArrayList<RfMethodType>();
        if (this.fPackages == null) {
            return result;
        }
        Map<String, RfStruct> map = this.fPackages;
        synchronized (map) {
            for (RfStruct packg : this.fPackages.values()) {
                Collection<RfType> types = packg.getTypes();
                for (RfType type : types) {
                    if (!(type instanceof RfMethodType)) continue;
                    result.add((RfMethodType)type);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPackage(RfStruct packg) {
        if (this.fPackages == null) {
            return;
        }
        Map<String, RfStruct> map = this.fPackages;
        synchronized (map) {
            this.fPackages.put(packg.getName(), packg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RfStruct> getAllPackages() {
        if (this.fPackages == null) {
            return Collections.emptyList();
        }
        Map<String, RfStruct> map = this.fPackages;
        synchronized (map) {
            return this.fPackages.values();
        }
    }

    public boolean isInternalApiError(ParserPath parserPath) {
        if (this.fInternalApiFilesPrefix == null) {
            String topPathPrefix = this.getPluginConfig().getTopPathPrefix();
            this.fInternalApiFilesPrefix = topPathPrefix + this.fProject.getName() + "__etools__";
        }
        return parserPath.path.indexOf(this.fInternalApiFilesPrefix) >= 0;
    }

    public boolean addSemanticError(int messageType, String pattern, LibraryPackageScope libraryPackageScope, int offsetStart, int offsetEnd, Map<String, Object> attributes, int line, ParserPath parserPath, Object ... arguments) {
        return this.addSemanticError1(messageType, pattern, offsetStart, offsetEnd, attributes, line, parserPath, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSemanticError1(int messageType, String pattern, int offsetStart, int offsetEnd, Map<String, Object> attributes, int line, ParserPath parserPath, Object ... arguments) {
        if (this.fTempDisableSemanticErrorReporting) {
            return true;
        }
        if (this.fProject == null) {
            return true;
        }
        if (this.isInternalApiError(parserPath)) {
            return true;
        }
        if (attributes == null) {
            attributes = this.makeGenericAttributes(pattern, arguments);
        }
        String resourcePath = this.parser2resource(parserPath);
        Object object = this.fSemanticErrorsLock;
        synchronized (object) {
            int nofProblems;
            boolean maxSizeReached;
            int maxSemanticIssuesPerFile = this.getMaxSemanticIssuesPerFile();
            Collection<RfSemanticError> errors = this.fSemanticErrors.get(resourcePath);
            if (errors == null) {
                errors = new LinkedHashSet<RfSemanticError>();
                this.fSemanticErrors.put(resourcePath, errors);
            }
            boolean bl = maxSizeReached = (nofProblems = errors.size()) >= maxSemanticIssuesPerFile;
            if (maxSizeReached && nofProblems <= 2 * maxSemanticIssuesPerFile) {
                nofProblems = 0;
                for (RfSemanticError problem : errors) {
                    if (messageType != problem.getSeverity()) continue;
                    ++nofProblems;
                }
                boolean bl2 = maxSizeReached = nofProblems >= maxSemanticIssuesPerFile;
            }
            if (!maxSizeReached) {
                String message = MessageFormat.format(pattern, arguments);
                int fileIndex = this.fParserPathToModuleMap.get(parserPath).getModuleIndex() - RfPredefinedCodeLoader.PREDEF_FILES_LIST.length + 1;
                RfSemanticError error = new RfSemanticError(messageType, message, line, resourcePath, fileIndex);
                if (offsetStart != -1 && offsetEnd != -1) {
                    error.setOffsetStart(offsetStart);
                    error.setOffsetEnd(offsetEnd);
                }
                error.setAttributes(attributes);
                errors.add(error);
            }
        }
        return true;
    }

    public void filenameRemap(String originalPath, String mapingPath) {
        if (originalPath.equals(mapingPath)) {
            return;
        }
        Collection<RfSemanticError> exceptions = this.fSemanticErrors.remove(originalPath);
        if (exceptions == null || exceptions.isEmpty()) {
            return;
        }
        for (RfSemanticError exception : exceptions) {
            if (!exception.getResourcePath().equals(originalPath)) continue;
            exception.setResourcePath(mapingPath);
        }
        this.fSemanticErrors.put(mapingPath, exceptions);
    }

    private Map<String, Object> makeGenericAttributes(String kind, Object ... arguments) {
        HashMap<String, Object> attributes;
        block23: {
            block22: {
                try {
                    attributes = new HashMap<String, Object>(4);
                    if (arguments != null && arguments.length != 0) break block22;
                    return null;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            switch (kind) {
                case "NOT_A_SUBTYPE: ''{0}'' is not a subtype of ''{1}''": 
                case "UNDEFINED_METHOD: Method ''{0}'' is not a member of ''{1}''": 
                case "UNDEFINED_TYPE: No type called ''{0}''": 
                case "UNDEFINED_METHOD: Method ''{0}'' is not defined": 
                case "UNDEFINED_TYPE: No type called ''{1}::{0}''": {
                    attributes.put("QUICKFIX_KIND", 10);
                    attributes.put("QUICKFIX_ELEMENT_NAME", arguments[0]);
                    break;
                }
                case "UNDEFINED_EVENT: Event ''{0}.{1}'' was not defined previously": {
                    attributes.put("QUICKFIX_KIND", 28);
                    attributes.put("QUICKFIX_ELEMENT_NAME", arguments[1]);
                }
            }
            if (!attributes.isEmpty()) break block23;
            return null;
        }
        return attributes;
    }

    public void setSemanticInTemplateDefinition(RfStruct rfStruct) {
        this.fSemanticTemplateDefinitionName = rfStruct == null ? null : rfStruct.getName();
    }

    public boolean addSemanticError2(int messageType, String pattern, int offsetStart, int offsetEnd, Map<String, Object> attributes, int line, ParserPath parserPath, Object ... arguments) {
        if (System.getenv(DVT_DISABLE_E_LANG_SEMANTIC_EXT) != null) {
            return true;
        }
        if (this.fSemanticTemplateDefinitionName != null && !this.fSemanticTemplateDefinitionName.isEmpty()) {
            pattern = DVTStringUtil.appendString((Object[])new Object[]{pattern, " [in template ''", this.fSemanticTemplateDefinitionName, "'' definition]"});
        }
        return this.addSemanticError1(messageType, pattern, offsetStart, offsetEnd, attributes, line, parserPath, arguments);
    }

    public boolean addSemanticError3(int messageType, String pattern, int offsetStart, int offsetEnd, Map<String, Object> attributes, int line, ParserPath parserPath, Object ... arguments) {
        if (!this.isNonStandardSemanticEnabled()) {
            return true;
        }
        return this.addSemanticError1(messageType, pattern, offsetStart, offsetEnd, attributes, line, parserPath, arguments);
    }

    public void addInactiveCode(String ifLineString, LineInfo elseLineInfo, LineInfo endLineInfo, String activeString) {
        if (ifLineString == null || endLineInfo == null || activeString == null) {
            return;
        }
        try {
            int ifLine = -1;
            int endLine = -1;
            int elseLine = -1;
            ifLine = Integer.parseInt(ifLineString);
            if (elseLineInfo != null && elseLineInfo.line >= 0) {
                elseLine = elseLineInfo.line;
            }
            endLine = endLineInfo.line;
            boolean active = Boolean.parseBoolean(activeString);
            if (elseLineInfo != null && elseLineInfo.line >= 0) {
                if (active) {
                    this.addInactiveCode(new RfInactiveCodeFileInfo.RfInactiveCodeLineInfo(elseLine, endLine));
                } else {
                    this.addInactiveCode(new RfInactiveCodeFileInfo.RfInactiveCodeLineInfo(ifLine, elseLine));
                }
            } else if (!active) {
                this.addInactiveCode(new RfInactiveCodeFileInfo.RfInactiveCodeLineInfo(ifLine, endLine));
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void addInactiveCode(RfInactiveCodeFileInfo.RfInactiveCodeLineInfo info) {
        ParserPath parserPath;
        RfInactiveCodeFileInfo infosForFile;
        if (this.fLastModule == null) {
            return;
        }
        if (this.fInactiveCodeInfos == null) {
            this.fInactiveCodeInfos = new HashMap<ParserPath, RfInactiveCodeFileInfo>();
        }
        if ((infosForFile = this.fInactiveCodeInfos.get(parserPath = this.fLastModule.getParserPath())) == null) {
            infosForFile = new RfInactiveCodeFileInfo();
            this.fInactiveCodeInfos.put(parserPath, infosForFile);
        }
        infosForFile.addLineInfo(info);
    }

    public Map<ParserPath, RfInactiveCodeFileInfo> getInactiveCodeInfos() {
        return this.fInactiveCodeInfos;
    }

    public List<RfDefElement> getStructMembers(int memberKind, boolean includeAllLayers, Pattern packagePattern, Pattern structPattern, Pattern memberPattern) {
        List<RfStruct> packages = this.getPackages(packagePattern);
        List<RfType> structList = this.getTypes(1, packages, structPattern);
        return this.getStructMembers(memberKind, includeAllLayers, structList, memberPattern);
    }

    public List<RfDefElement> getTypes(int typeKind, boolean includeAllLayers, Pattern packagePattern, Pattern typePattern) {
        List<RfStruct> packages = this.getPackages(packagePattern);
        List<RfType> typeList = this.getTypes(typeKind, packages, typePattern);
        ArrayList<RfDefElement> result = new ArrayList<RfDefElement>();
        for (RfType candidate : typeList) {
            if (!includeAllLayers && (candidate instanceof RfPredefinedScalar || candidate instanceof RfPredefinedStruct)) continue;
            if (!includeAllLayers) {
                result.add(candidate.getFirstLayer());
                continue;
            }
            result.addAll(candidate.getLayers());
        }
        return result;
    }

    public List<RfDefElement> getMacros(boolean includePreproc, boolean searchReferences, boolean includeDeclaration, Pattern macroPattern) {
        ArrayList<RfDefElement> result = new ArrayList<RfDefElement>();
        List<RfMacro> candidates = this.getAllMacros(includePreproc, false);
        for (RfMacro macro : candidates) {
            Matcher matcher = null;
            matcher = macro.isPreprocessing() ? macroPattern.matcher(macro.getName()) : macroPattern.matcher(macro.getStringLiteral());
            if (!matcher.find()) continue;
            if (!searchReferences) {
                result.add(macro.getDeclaration(false));
                continue;
            }
            result.addAll(macro.getLayers());
            if (includeDeclaration) continue;
            result.remove(macro.getDeclaration(false));
        }
        return result;
    }

    private List<RfStruct> getPackages(Pattern packagePattern) {
        ArrayList<RfStruct> result = new ArrayList<RfStruct>();
        if (packagePattern == null) {
            result.addAll(this.getAllPackages());
        } else {
            for (RfStruct candidate : this.getAllPackages()) {
                Matcher matcher = packagePattern.matcher(candidate.getPackageName());
                if (!matcher.matches()) continue;
                result.add(candidate);
            }
        }
        return result;
    }

    private List<RfType> getTypes(int typeKind, List<RfStruct> packages, Pattern typePattern) {
        ArrayList<RfType> result = new ArrayList<RfType>();
        for (RfStruct packg : packages) {
            for (RfType candidate : packg.getTypes()) {
                if (!((typeKind & 1) == 1 && candidate instanceof RfStruct || (typeKind & 2) == 2 && candidate instanceof RfScalarType) && ((typeKind & 4) != 4 || !(candidate instanceof RfMethodType))) continue;
                if (typePattern == null) {
                    result.add(candidate);
                    continue;
                }
                Matcher matcher = typePattern.matcher(candidate.getName());
                if (!matcher.matches()) continue;
                result.add(candidate);
            }
        }
        return result;
    }

    private List<RfDefElement> getStructMembers(int memberKind, boolean includeAllLayers, List<RfType> structList, Pattern memberPattern) {
        ArrayList<RfDefElement> result = new ArrayList<RfDefElement>();
        if (memberPattern == null) {
            return result;
        }
        for (RfType struct : structList) {
            RfStructLayer enclosingStructLayer;
            List<RfDefElement> layers;
            RfDefElement layer;
            Matcher matcher;
            List candidates;
            if (!(struct instanceof RfStruct)) continue;
            if ((memberKind & 1) == 1 && (candidates = ((RfStruct)struct).getMembersWithPrefix(true, 1, null, struct.getPackageName(), null, 2, "", 31)) != null) {
                for (RfStructMember candidate : candidates) {
                    if (!includeAllLayers && candidate instanceof RfPredefinedMethod || !(matcher = memberPattern.matcher(candidate.getName())).matches()) continue;
                    if (!includeAllLayers) {
                        layer = candidate.getFirstLayer();
                        if (layer == null || result.contains(layer)) continue;
                        result.add(layer);
                        continue;
                    }
                    layers = candidate.getLayers();
                    for (RfDefElement layer2 : layers) {
                        enclosingStructLayer = ((RfMethodLayer)layer2).getStructLayer();
                        if (enclosingStructLayer == null || enclosingStructLayer.getNamedElement() == null || result.contains(layer2) || !((RfStruct)struct).isLike(((RfMethodLayer)layer2).getStructLayer().getNamedElement().getName())) continue;
                        result.add(layer2);
                    }
                }
            }
            if ((memberKind & 2) == 2 && (candidates = ((RfStruct)struct).getMembersWithPrefix(true, 5, null, struct.getPackageName(), null, 2, "", 31)) != null) {
                for (RfStructMember candidate : candidates) {
                    if (!includeAllLayers && candidate instanceof RfPredefinedEvent || !(matcher = memberPattern.matcher(candidate.getName())).matches()) continue;
                    if (!includeAllLayers) {
                        layer = ((RfEvent)candidate).getFirstLayer();
                        if (layer == null || result.contains(layer)) continue;
                        result.add(layer);
                        continue;
                    }
                    layers = candidate.getLayers();
                    for (RfDefElement layer2 : layers) {
                        enclosingStructLayer = ((RfEventLayer)layer2).getStructLayer();
                        if (enclosingStructLayer == null || enclosingStructLayer.getNamedElement() == null || result.contains(layer2) || !((RfStruct)struct).isLike(((RfEventLayer)layer2).getStructLayer().getNamedElement().getName())) continue;
                        result.add(layer2);
                    }
                }
            }
            if ((memberKind & 4) != 4 || (candidates = ((RfStruct)struct).getMembersWithPrefix(true, 2, null, struct.getPackageName(), null, 2, "", 31)) == null) continue;
            for (RfStructMember candidate : candidates) {
                if (!includeAllLayers && candidate instanceof RfPredefinedField || !(matcher = memberPattern.matcher(candidate.getName())).matches()) continue;
                if (!includeAllLayers) {
                    layer = candidate.getFirstLayer();
                    if (layer == null) continue;
                    result.add(layer);
                    continue;
                }
                layers = candidate.getLayers();
                for (RfDefElement layer2 : layers) {
                    enclosingStructLayer = ((RfFieldLayer)layer2).getStructLayer();
                    if (enclosingStructLayer == null || enclosingStructLayer.getNamedElement() == null || result.contains(layer2) || !((RfStruct)struct).isLike(((RfFieldLayer)layer2).getStructLayer().getNamedElement().getName())) continue;
                    result.add(layer2);
                }
            }
        }
        return result;
    }

    private void setTestFileImported(ParserPath parserPath, ParserPath parentModulePath) {
        Set<ParserPath> importedTestPaths;
        if (parentModulePath == null) {
            return;
        }
        if (this.fImportedTestFiles == null) {
            this.fImportedTestFiles = new HashMap<ParserPath, Set<ParserPath>>();
        }
        if ((importedTestPaths = this.fImportedTestFiles.get(parserPath)) == null) {
            importedTestPaths = new HashSet<ParserPath>();
            this.fImportedTestFiles.put(parserPath, importedTestPaths);
        }
        importedTestPaths.add(parentModulePath);
    }

    public Set<ParserPath> getTestFilesForModule(ParserPath parserPath) {
        if (this.fImportedTestFiles == null || parserPath == null) {
            return null;
        }
        return this.fImportedTestFiles.get(parserPath);
    }

    protected boolean importedBySameTest(RfDefElement element1, RfDefElement element2) {
        if (this.fImportedTestFiles == null || this.fImportedTestFiles.isEmpty() || element1 == null || element2 == null) {
            return true;
        }
        if (element1 == element2) {
            return true;
        }
        return this.importedBySameTest(element1.getParserPath(), element2.getParserPath());
    }

    protected boolean importedBySameTest(ParserPath parserPath, List<RfDefElement> elements) {
        if (this.fImportedTestFiles == null || elements == null || elements.isEmpty()) {
            return true;
        }
        for (RfDefElement element : elements) {
            if (!this.importedBySameTest(parserPath, element.getParserPath())) continue;
            return true;
        }
        return false;
    }

    protected boolean importedBySameTest(ParserPath parserPath, RfDefElement element) {
        if (this.fImportedTestFiles == null || element == null) {
            return true;
        }
        return this.importedBySameTest(parserPath, element.getParserPath());
    }

    public final boolean importedBySameTest(ParserPath parserPath1, ParserPath parserPath2) {
        if (this.fImportedTestFiles == null || this.fImportedTestFiles.isEmpty() || parserPath1 == null || parserPath2 == null) {
            return true;
        }
        if (parserPath1 == parserPath2) {
            return true;
        }
        Set<ParserPath> parentsOfModule1 = this.fImportedTestFiles.get(parserPath1);
        Set<ParserPath> parentsOfModule2 = this.fImportedTestFiles.get(parserPath2);
        if (parentsOfModule1 == null || parentsOfModule2 == null) {
            return true;
        }
        HashSet<ParserPath> commonParents = new HashSet<ParserPath>(parentsOfModule1);
        commonParents.retainAll(parentsOfModule2);
        return !commonParents.isEmpty();
    }

    /*
     * Loose catch block
     */
    private final EModuleInfo loadModuleInfo(IProject project, ParserPath parserPath, int moduleIndex) {
        String fileName = BuildConfigManager.getModelPersistenceLocation((IProject)project, (String)(String.valueOf(Integer.toHexString(parserPath.hashCode())) + "_" + moduleIndex), (boolean)true, (BuildConfigManagerCommon.PersistenceModeWrapper)BuildConfigManagerCommon.PersistenceModeWrapper.regular());
        if (fileName == null) {
            return null;
        }
        File file = new File(fileName);
        if (!file.exists()) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try {
                EModuleInfo eModuleInfo;
                ObjectInputStream ois;
                BufferedInputStream bif;
                block20: {
                    block19: {
                        EModuleInfo readObject;
                        bif = new BufferedInputStream(new FileInputStream(fileName), 32768);
                        ois = new ObjectInputStream(bif);
                        eModuleInfo = readObject = (EModuleInfo)ois.readObject();
                        if (ois == null) break block19;
                        ois.close();
                    }
                    if (bif == null) break block20;
                    bif.close();
                }
                return eModuleInfo;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (ois != null) {
                                ois.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (bif != null) {
                                bif.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logDebug("Error loading module '" + parserPath + "' info (" + e.getMessage() + ").");
            return null;
        }
    }

    public AsComputedProcessor getAsComputedProcessor() {
        if (this.fAsComputedProcessor == null) {
            this.fAsComputedProcessor = new AsComputedProcessor(this);
        }
        this.fAsComputedProcessor.setDebugLog(BuildConfigManager.isAsComputedLogEnabled((IProject)this.fProject));
        this.fAsComputedProcessor.setDebugPath(BuildConfigManager.getAsComputedDumpPath((IProject)this.fProject));
        return this.fAsComputedProcessor;
    }

    public IRfType get_type_by_name(__etools_string name) {
        RfDefElement declaration;
        RfType type;
        int index;
        boolean strictPackage = false;
        if (name == null) {
            return null;
        }
        String[] qualifiedName = DVTStringUtil.split((Pattern)DVTStringUtil.COLON_COLON, (String)name.toString().trim());
        String packageName = "main";
        String typeName = qualifiedName[0];
        if (qualifiedName.length == 2) {
            packageName = qualifiedName[0];
            typeName = qualifiedName[1];
            strictPackage = true;
        }
        if ((index = typeName.indexOf(40)) > 0) {
            typeName = typeName.substring(0, index).trim();
        }
        int length = typeName.length();
        typeName = DVTStringUtil.replaceAll((Pattern)DVTStringUtil.E_TYPE_LIST_OF, (CharSequence)typeName, (String)"");
        boolean isList = false;
        if (length > typeName.length()) {
            isList = true;
        }
        if ((type = this.getType(packageName, strictPackage, -1, typeName, -1)) == null) {
            return null;
        }
        if (!type.isPredefined() && (declaration = type.getDeclaration(false)) == null) {
            return null;
        }
        if (isList) {
            return RfListType.listFromType(this, type, null, null, 1);
        }
        return type;
    }

    public RfStruct get_struct_by_name(__etools_string name) {
        RfType result;
        int index = name.toString().trim().lastIndexOf(" ");
        if (index > 0) {
            Determinant determinant = new Determinant(name.toString());
            RfStruct struct = this.get_struct_by_name(new __etools_string(name.toString().substring(index).trim()));
            if (struct == null) {
                return null;
            }
            List<RfStructLayer> subtypeLayers = struct.getSubTypeLayers();
            RfProject project = this.getRfProject();
            for (RfStructLayer subtypeLayer : subtypeLayers) {
                if (!subtypeLayer.getDeterminant().contains(determinant, true)) continue;
                return new RfWhenSubtype(project, subtypeLayer);
            }
        }
        boolean strictPackage = false;
        String[] qualifiedName = DVTStringUtil.split((Pattern)DVTStringUtil.COLON_COLON, (String)name.toString().trim());
        String packageName = "main";
        String typeName = qualifiedName[0];
        if (qualifiedName.length == 2) {
            packageName = qualifiedName[0];
            typeName = qualifiedName[1];
            strictPackage = true;
        }
        if ((result = this.getType(packageName, strictPackage, 1, typeName, -1)) != null && !(result instanceof RfPredefinedStruct) && !(result instanceof RfPredefinedScalar) && result.getDeclaration(false) == null) {
            result = null;
        }
        return (RfStruct)result;
    }

    public EList<RfStruct> get_all_sequences() {
        EList<RfStruct> result = new EList<RfStruct>();
        List<RfNamedElement> allTypes = this.getAllTypes(false, false);
        for (RfNamedElement type : allTypes) {
            if (!(type instanceof RfStruct) || !((RfStruct)type).isSequence()) continue;
            result.add(type);
        }
        return result;
    }

    public EList<RfType> get_user_types() {
        EList<RfType> result = new EList<RfType>();
        List<RfNamedElement> allTypes = this.getAllTypes(false, false);
        for (RfNamedElement type : allTypes) {
            if (type.isPredefined()) continue;
            result.add(type);
        }
        return result;
    }

    @Override
    public RfProject getRfProject() {
        return this;
    }

    public Map<String, ClassEncap> getAsComputedJavaClassMap() {
        return this.fAsComputedJavaClassMap;
    }

    public EList<IRfType> get_user_modules() {
        EList<IRfType> result = new EList<IRfType>();
        result.addAll(this.fParserPathToModuleMap.values());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList<RfMacro> get_all_defines() {
        EList<RfMacro> result = new EList<RfMacro>();
        if (this.fPreprocs == null) {
            return result;
        }
        Map<String, RfMacro> map = this.fPreprocs;
        synchronized (map) {
            for (RfMacro el : this.fPreprocs.values()) {
                if (el == null || el.hasNoLayers()) continue;
                result.add(el);
            }
        }
        return result;
    }

    public RfMacro get_define(__etools_string name) {
        return this.getPreproc(name.toString());
    }

    public RfMacro get_defined_name(__etools_string name) {
        RfMacro preproc = this.getPreproc(name.toString());
        if (preproc == null) {
            return null;
        }
        List<RfDefElement> layers = preproc.getLayers();
        boolean isDefined = false;
        for (RfDefElement layer : layers) {
            if (((RfMacroLayer)layer).isConditional()) continue;
            isDefined = !((RfMacroLayer)layer).isUndef();
        }
        return isDefined ? preproc : null;
    }

    public Collection<? extends IRfLibraryElement> getLibraries() {
        return null;
    }

    public List<? extends IRfLibraryElement> getLibrariesWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfLibraryElement getLibraryWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfFileDef getFile(IResource file) {
        return this.getModule(file);
    }

    public IRfFileDef getFile(ParserPath parserPath) {
        return this.getModule(parserPath);
    }

    public String getBuildConfig() {
        return this.fBuildConfig;
    }

    public String parser2resource(ParserPath parserPath) {
        return DVTFileUtils.getInstance().parser2resource(this.fProject, parserPath);
    }

    public ParserPath resource2parser(IResource file) {
        return DVTFileUtils.getInstance().resource2parser(file);
    }

    private Set<ParserPath> resource2parser(Set<FileCompileInfo> changedFiles) {
        return DVTFileUtils.getInstance().resource2parser(changedFiles);
    }

    public void computeFilesIncludedByMatchingTop(Map<StringMatcher, Set<String>> expanded) {
        for (Map.Entry<StringMatcher, Set<String>> expandedEntry : expanded.entrySet()) {
            StringMatcher matcher = expandedEntry.getKey();
            for (Map.Entry<String, ImportGraphNode> importNodeEntry : this.fImportNodes.entrySet()) {
                ImportGraphNode node;
                String key = importNodeEntry.getKey();
                if (key.startsWith(this.getPluginConfig().getTopPathPrefix()) || (node = importNodeEntry.getValue()).getPath() == null || !matcher.match(node.getPath())) continue;
                expandedEntry.getValue().addAll(ImportGraphNodeVisitor.computeImportedTree(node));
            }
        }
    }

    public Set<String> computeFilesInMacroReparseStack(IRfDefElement declaration) {
        if (!(declaration instanceof RfDefElement)) {
            return null;
        }
        ReparseElement[] reparseStack = ((RfDefElement)declaration).getReparseStack();
        if (reparseStack == null) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        ReparseElement[] reparseElementArray = reparseStack;
        int n = reparseStack.length;
        int n2 = 0;
        while (n2 < n) {
            ReparseElement reparseElement = reparseElementArray[n2];
            result.add(reparseElement.getFileName());
            ++n2;
        }
        return result;
    }

    public ElementType computeElementType(IRfNamedElement namedElement, ElementPath instancePath) {
        ElementType.ElementTypeLanguage elementLanguageType = ElementType.ElementTypeLanguage.E;
        LanguageKind languageKind = this.getLanguageKind();
        switch (languageKind) {
            case E: {
                elementLanguageType = ElementType.ElementTypeLanguage.E;
                break;
            }
            case SLN: {
                elementLanguageType = ElementType.ElementTypeLanguage.SLN;
                break;
            }
        }
        if (namedElement instanceof RfMacro && !namedElement.isPredefined()) {
            return new ElementType(ElementType.ElementTypeName.MACRO, elementLanguageType);
        }
        if (namedElement instanceof RfMethod) {
            return new ElementType(ElementType.ElementTypeName.METHOD, elementLanguageType);
        }
        if (namedElement instanceof RfField) {
            return new ElementType(ElementType.ElementTypeName.FIELD, elementLanguageType);
        }
        if (namedElement instanceof RfEvent) {
            return new ElementType(ElementType.ElementTypeName.EVENT, elementLanguageType);
        }
        if (namedElement instanceof RfExpect) {
            return new ElementType(ElementType.ElementTypeName.EXPECT, elementLanguageType);
        }
        if (namedElement instanceof RfAssert) {
            return new ElementType(ElementType.ElementTypeName.ASSERT, elementLanguageType);
        }
        if (namedElement instanceof RfCheckThat) {
            return new ElementType(ElementType.ElementTypeName.CHECK, elementLanguageType);
        }
        if (namedElement instanceof RfMethodType) {
            return new ElementType(ElementType.ElementTypeName.METHOD_TYPE, elementLanguageType);
        }
        if (namedElement instanceof RfStruct) {
            if (((RfStruct)namedElement).isSLNAction()) {
                return new ElementType(ElementType.ElementTypeName.ACTION, elementLanguageType);
            }
            if (((RfStruct)namedElement).isSLNComponent()) {
                return new ElementType(ElementType.ElementTypeName.COMPONENT, elementLanguageType);
            }
            if (((RfStruct)namedElement).isSLNToken()) {
                return new ElementType(ElementType.ElementTypeName.TOKEN, elementLanguageType);
            }
            return new ElementType(ElementType.ElementTypeName.STRUCT, elementLanguageType);
        }
        if (namedElement instanceof RfScalarType) {
            return new ElementType(ElementType.ElementTypeName.TYPE, elementLanguageType);
        }
        if (namedElement instanceof RfCoverItem) {
            if (((RfCoverItem)namedElement).getKind() == 0) {
                return new ElementType(ElementType.ElementTypeName.COVER_POINT, elementLanguageType);
            }
            if (((RfCoverItem)namedElement).getKind() == 1) {
                return new ElementType(ElementType.ElementTypeName.COVER_CROSS, elementLanguageType);
            }
            if (((RfCoverItem)namedElement).getKind() == 2) {
                return new ElementType(ElementType.ElementTypeName.COVER_TRANSITION, elementLanguageType);
            }
        }
        return null;
    }

    public ElementType computeElementType(IRfDefElement defElement, IRfNamedElement namedElement, ElementPath instancePath) {
        ElementType.ElementTypeLanguage elementLanguageType = ElementType.ElementTypeLanguage.E;
        LanguageKind languageKind = this.getLanguageKind();
        switch (languageKind) {
            case E: {
                elementLanguageType = ElementType.ElementTypeLanguage.E;
                break;
            }
            case SLN: {
                elementLanguageType = ElementType.ElementTypeLanguage.SLN;
                break;
            }
        }
        if (defElement instanceof RfMacroLayer && !defElement.getNamedElement().isPredefined()) {
            return new ElementType(ElementType.ElementTypeName.MACRO, elementLanguageType);
        }
        if (defElement instanceof RfMethodLayer) {
            return new ElementType(ElementType.ElementTypeName.METHOD, elementLanguageType);
        }
        if (defElement instanceof RfFieldLayer && defElement.getNamedElement() instanceof RfFieldPropConstraint) {
            return new ElementType(ElementType.ElementTypeName.CONSTRAINT, elementLanguageType);
        }
        if (defElement instanceof RfFieldLayer && defElement.getNamedElement() instanceof RfFieldTypeConstraint) {
            return new ElementType(ElementType.ElementTypeName.CONSTRAINT, elementLanguageType);
        }
        if (defElement instanceof RfFieldLayer) {
            return new ElementType(ElementType.ElementTypeName.FIELD, elementLanguageType);
        }
        if (defElement instanceof RfOnEventLayer) {
            return new ElementType(ElementType.ElementTypeName.ONEVENT, elementLanguageType);
        }
        if (defElement instanceof RfCoverLayer) {
            return new ElementType(ElementType.ElementTypeName.COVER_GROUP, elementLanguageType);
        }
        if (defElement instanceof RfExpectLayer) {
            return new ElementType(ElementType.ElementTypeName.EXPECT, elementLanguageType);
        }
        if (defElement instanceof RfAssertLayer) {
            return new ElementType(ElementType.ElementTypeName.ASSERT, elementLanguageType);
        }
        if (defElement instanceof RfCheckThatLayer) {
            return new ElementType(ElementType.ElementTypeName.CHECK, elementLanguageType);
        }
        if (defElement instanceof RfConstraintLayer) {
            return new ElementType(ElementType.ElementTypeName.CONSTRAINT, elementLanguageType);
        }
        if (defElement instanceof RfEventLayer && !(defElement instanceof RfCoverLayer) && !(defElement instanceof RfOnEventLayer)) {
            return new ElementType(ElementType.ElementTypeName.EVENT, elementLanguageType);
        }
        if (defElement instanceof RfMethodTypeLayer) {
            return new ElementType(ElementType.ElementTypeName.METHOD_TYPE, elementLanguageType);
        }
        if (defElement instanceof RfStructLayer) {
            if (((RfStruct)defElement.getNamedElement()).isSLNAction()) {
                return new ElementType(ElementType.ElementTypeName.ACTION, elementLanguageType);
            }
            if (((RfStruct)defElement.getNamedElement()).isSLNComponent()) {
                return new ElementType(ElementType.ElementTypeName.COMPONENT, elementLanguageType);
            }
            if (((RfStruct)defElement.getNamedElement()).isSLNToken()) {
                return new ElementType(ElementType.ElementTypeName.TOKEN, elementLanguageType);
            }
            return new ElementType(ElementType.ElementTypeName.STRUCT, elementLanguageType);
        }
        if (defElement instanceof RfScalarTypeLayer) {
            return new ElementType(ElementType.ElementTypeName.TYPE, elementLanguageType);
        }
        if (defElement instanceof RfVarLayer) {
            if (((RfVarLayer)defElement).getVariable().getKind() == 0) {
                return new ElementType(ElementType.ElementTypeName.COVER_POINT, elementLanguageType);
            }
            if (((RfVarLayer)defElement).getVariable().getKind() == 1) {
                return new ElementType(ElementType.ElementTypeName.COVER_CROSS, elementLanguageType);
            }
            if (((RfVarLayer)defElement).getVariable().getKind() == 2) {
                return new ElementType(ElementType.ElementTypeName.COVER_TRANSITION, elementLanguageType);
            }
        }
        return null;
    }

    @Override
    public IRfScope getEnclosingScope() {
        return null;
    }

    @Override
    public <T extends IRfScopeElement> T getEnclosingScope(Class<T> clazz) {
        return null;
    }

    @Override
    public String getName() {
        return this.fProject.getName();
    }

    @Override
    public IRfNamedElement getSignalWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public List<? extends IRfNamedElement> getSignalsWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public IRfInstanceElement getInstanceWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public List<? extends IRfPackageElement> getPackagesWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public IRfPackageElement getPackageWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public List<? extends IRfDesignElement> getDesignsWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public IRfDesignElement getDesignWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public List<? extends IRfNamedElement> getTypesWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public IRfNamedElement getTypeWithPrefix(String prefix, int matchType) {
        return null;
    }

    public RfProjectState getProjectState() {
        return this.fProjectState;
    }

    public void setProjectState(RfProjectState state) {
        this.fProjectState = state;
    }

    public boolean preRestore() {
        this.clean();
        return this.fRfManager.preRestoreRfProject(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void restore(IProgressMonitor monitor) {
        try {
            this.setBuildProgressMonitor(monitor);
            var2_2 = this.fRestoreModulesLock;
            synchronized (var2_2) {
                this.fModuleReferenceToEModuleInfoMap = new LinkedHashMap<ModuleReference, EModuleInfo>();
                this.fImportedTestFiles = new LinkedHashMap<ParserPath, Set<ParserPath>>();
                if (this.fFullBuildModuleReferences == null) {
                    return;
                }
                {
                    this.fRestoreModuleReferences = new ArrayList<ModuleReference>(this.fFullBuildModuleReferences);
                    this.fFullBuildModuleReferences.clear();
                }
            }
            monitor.beginTask("", this.fRestoreModuleReferences.size());
            index = 0;
            {
                for (ModuleReference reference : this.fRestoreModuleReferences) {
                    ++index;
                    if (monitor.isCanceled()) {
                        this.clean();
                        break;
                    }
                    monitor.subTask("Load from dictionary (" + index + "/" + this.fRestoreModuleReferences.size() + ") module: " + reference);
                    info = this.loadModuleInfo(this.fProject, reference.parserPath, reference.moduleIndex);
                    if (info == null) {
                        return;
                    }
                    ** try [egrp 5[TRYBLOCK] [7 : 317->439)] { 
lbl27:
                    // 1 sources

                    info.setProject(this.fProject);
                    this.build(info, false, false);
                    if (!this.isInSDLMode()) {
                        this.getPluginConfig().getNameCheckerWarningsManager().build(1, info, this.fProject);
                    }
                    monitor.worked(1);
                }
                monitor.beginTask("", 1);
                monitor.subTask("Resolve types");
                this.postFullBuild(false, false);
                monitor.worked(1);
                BuildEventManager.getInstance().notifyFullBuild(this.getProject());
                var3_11 = this.fRestoreModulesLock;
                synchronized (var3_11) {
                    this.fRestoreModuleReferences = null;
                    return;
                }
            }
        }
lbl45:
        // 2 sources

        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return;
        }
        finally {
            eProject = this.getModelManager().getEModel().getEProject(this.fProject);
            if (eProject != null) {
                eProject.getCompilationUnitProperties(false);
            }
            ro.amiq.edt.base.utils.Utils.connectActiveOpenEditor(this.getPluginConfig().getEditorID(), this);
            monitor.done();
        }
    }

    public IRfProjectContent getRfProjectContent() {
        return null;
    }

    public IIdleListener getIdleListener() {
        return null;
    }

    public void setRfProjectContent(IRfProjectContent rfProjectContent) {
    }

    public RfCompiledFiles getRfCompiledFiles() {
        return null;
    }

    public void setRfCompiledFiles(RfCompiledFiles compiledFiles) {
    }

    public void syncCancelSave() {
    }

    public void getSortCandidatesForContentAssist(IRfNamedElement[] sortedCandidates, String prefix) {
        Arrays.sort(sortedCandidates, R2LUtils.getContextSorter(prefix, this.getLanguageKind()));
    }

    @Override
    public void getElementsWithPrefix(Collection<IRfNamedElement> result, String prefix, int matchType, int local, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) {
    }

    @Override
    public IRfLibraryElement getEnclosingLibrary() {
        return null;
    }

    @Override
    public IRfScopeElement getEnclosingScope(Set<?> classes) {
        return null;
    }

    public EModuleInfo getModuleInfo(ModuleReference reference) {
        if (this.fModuleReferenceToEModuleInfoMap == null || !this.fModuleReferenceToEModuleInfoMap.containsKey(reference)) {
            return null;
        }
        return this.fModuleReferenceToEModuleInfoMap.get(reference);
    }

    public Collection<EModuleInfo> getModuleInfos() {
        if (this.fModuleReferenceToEModuleInfoMap == null) {
            return Collections.emptyList();
        }
        return this.fModuleReferenceToEModuleInfoMap.values();
    }

    public void addUndeclaredVarNameReference(ModuleReference reference, String name) {
        if (this.fUndeclaredVarNameReferences == null) {
            this.fUndeclaredVarNameReferences = new HashMap<String, Set<ModuleReference>>();
        }
        this.addUndeclaredNameReference(this.fUndeclaredVarNameReferences, reference, name);
    }

    public void addUndeclaredTypeNameReference(ModuleReference reference, String name) {
        if (this.fUndeclaredTypeNameReferences == null) {
            this.fUndeclaredTypeNameReferences = new HashMap<String, Set<ModuleReference>>();
        }
        this.addUndeclaredNameReference(this.fUndeclaredTypeNameReferences, reference, name);
    }

    private final void addUndeclaredNameReference(Map<String, Set<ModuleReference>> undeclaredNameReferences, ModuleReference reference, String name) {
        Set<ModuleReference> references = undeclaredNameReferences.get(name);
        if (references == null) {
            references = new HashSet<ModuleReference>();
            undeclaredNameReferences.put(name, references);
        }
        references.add(reference);
    }

    private void cleanUndeclaredReferences(ModuleReference reference) {
        this.cleanUndeclaredNameReference(this.fUndeclaredVarNameReferences, reference);
        this.cleanUndeclaredNameReference(this.fUndeclaredTypeNameReferences, reference);
    }

    private final void cleanUndeclaredNameReference(Map<String, Set<ModuleReference>> undeclaredNameReferences, ModuleReference reference) {
        if (undeclaredNameReferences == null) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>(undeclaredNameReferences.keySet());
        for (String name : names) {
            Set<ModuleReference> references = undeclaredNameReferences.get(name);
            if (references == null) continue;
            references.remove(reference);
            if (!references.isEmpty()) continue;
            undeclaredNameReferences.remove(name);
        }
    }

    public void addNewDefinedVarName(RfStructMember element) {
        if (this.fAddedVarsInCurrentFile == null) {
            return;
        }
        this.fAddedVarsInCurrentFile.add(element);
    }

    public void addNewDefinedTypeName(RfType type) {
        if (this.fAddedTypesInCurrentFile == null) {
            return;
        }
        this.fAddedTypesInCurrentFile.add(type);
    }

    private void initNewDefinedElementsInCurrentFile(boolean incremental) {
        if (incremental) {
            this.fAddedVarsInCurrentFile = new ArrayList<RfStructMember>();
            this.fAddedTypesInCurrentFile = new ArrayList<RfType>();
        } else {
            this.fAddedVarsInCurrentFile = null;
            this.fAddedTypesInCurrentFile = null;
        }
    }

    public Set<ModuleReference> getPotentialyDependentModuleReferences(int moduleIndex) {
        HashSet<ModuleReference> result = new HashSet<ModuleReference>();
        this.getNewDefinedNamesReferences(result, this.fAddedVarsInCurrentFile, this.fUndeclaredVarNameReferences, moduleIndex);
        this.getNewDefinedNamesReferences(result, this.fAddedTypesInCurrentFile, this.fUndeclaredTypeNameReferences, moduleIndex);
        return result;
    }

    private final void getNewDefinedNamesReferences(Set<ModuleReference> result, List<? extends RfNamedElement> addedElementsInCurrentFile, Map<String, Set<ModuleReference>> undeclaredNameReferences, int moduleIndex) {
        if (addedElementsInCurrentFile == null || undeclaredNameReferences == null) {
            return;
        }
        for (RfNamedElement rfNamedElement : addedElementsInCurrentFile) {
            Set<ModuleReference> references;
            if (rfNamedElement instanceof RfScalarType && ((RfScalarType)rfNamedElement).isEnumType() && !(rfNamedElement instanceof RfEnum)) {
                this.getNewDefinedNamesReferences(result, ((RfScalarType)rfNamedElement).getEnumsWithPrefix(2, ""), this.fUndeclaredVarNameReferences, moduleIndex);
            }
            if (rfNamedElement instanceof RfField && ((RfField)rfNamedElement).getAssociatedType() instanceof RfScalarType && ((RfScalarType)((RfField)rfNamedElement).getAssociatedType()).isEnumType()) {
                this.getNewDefinedNamesReferences(result, ((RfScalarType)((RfField)rfNamedElement).getAssociatedType()).getEnumsWithPrefix(2, ""), this.fUndeclaredVarNameReferences, moduleIndex);
            }
            if ((references = undeclaredNameReferences.get(rfNamedElement.getName())) == null) continue;
            for (ModuleReference reference : references) {
                if (reference.moduleIndex < moduleIndex) continue;
                result.add(reference);
            }
        }
    }

    public void addDependentModuleReference(ModuleReference current, ModuleReference reference) {
        Set<ModuleReference> references;
        if (this.fDependentModuleReferences == null) {
            this.fDependentModuleReferences = new HashMap<ModuleReference, Set<ModuleReference>>();
        }
        if ((references = this.fDependentModuleReferences.get(current)) == null) {
            references = new HashSet<ModuleReference>();
            this.fDependentModuleReferences.put(current, references);
        }
        references.add(reference);
    }

    public List<ModuleReference> getSemanticDependentModuleReferences(ModuleReference current) {
        Set<ModuleReference> result = this.getPotentialyDependentModuleReferences(current.moduleIndex);
        if (this.fDependentModuleReferences != null) {
            Set<ModuleReference> dependencies = this.fDependentModuleReferences.get(current);
            Set<ParserPath> compiledFilesSet = this.getCompiledFilesSet();
            if (dependencies != null && !dependencies.isEmpty() && compiledFilesSet != null) {
                for (ModuleReference dependency : dependencies) {
                    if (!compiledFilesSet.contains(dependency.parserPath)) continue;
                    result.add(dependency);
                }
            }
        }
        ArrayList<ModuleReference> sorted = new ArrayList<ModuleReference>(result);
        Collections.sort(sorted);
        return sorted;
    }

    public String getSignature() {
        return "project " + this.getName();
    }

    @Override
    public IRfNamedElement getMember(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, boolean isFirst, boolean isLast, boolean includeEnums, boolean isOnlyType, boolean skipParents) {
        return this.getModuleUsingLastSegment(name);
    }

    @Override
    public String getContextType() {
        return null;
    }

    @Override
    public Determinant getDeterminant() {
        return null;
    }

    @Override
    public void setTransientDeterminant(Determinant determinant) {
    }

    @Override
    public Determinant getTransientDeterminant() {
        return null;
    }

    @Override
    public List<RfField> getFieldsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        return null;
    }

    @Override
    public RfField getFieldWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        return null;
    }

    @Override
    public List<RfMethod> getMethodsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        return null;
    }

    @Override
    public RfMethod getMethodWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        return null;
    }

    @Override
    public List<RfEvent> getEventsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        return null;
    }

    @Override
    public RfEvent getEventWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        return null;
    }

    @Override
    public List<RfExpect> getExpectsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        return null;
    }

    @Override
    public RfExpect getExpectWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        return null;
    }

    @Override
    public List<RfVar> getVariablesWithPrefix(int line, int matchType, String prefix) {
        return null;
    }

    @Override
    public RfVar getVariableWithPrefix(int line, int matchType, String prefix) {
        return null;
    }

    @Override
    public List<RfArg> getArgumentsWithPrefix(int matchType, String prefix) {
        return null;
    }

    @Override
    public RfArg getArgumentWithPrefix(int matchType, String prefix) {
        return null;
    }

    @Override
    public List<RfEnum> getEnumsWithPrefix(int matchType, String prefix) {
        return null;
    }

    @Override
    public RfEnum getEnumWithPrefix(int matchType, String prefix) {
        return null;
    }

    @Override
    public RfMeImplicitVariable getMeImplicitVariable(int matchType, String prefix) {
        return null;
    }

    @Override
    public RfPredefinedField getCompImplicitVariable(RfProject project, int matchType, String prefix) {
        return null;
    }

    @Override
    public boolean isInGlobal() {
        return false;
    }

    public boolean isLintingEnabled() {
        return false;
    }

    public void stopLintTracking() {
    }

    public DVTPFModel getPFModel() {
        return null;
    }

    public boolean addAsComputedTranslateMethodMissing(String missingMethodName) {
        if (this.fAsComputedTranslateMethodMissing == null) {
            this.fAsComputedTranslateMethodMissing = new HashSet<String>();
        }
        return this.fAsComputedTranslateMethodMissing.add(missingMethodName);
    }

    public String testGetAsComputedConsoleContent() {
        if (this.fAsComputedProcessor == null) {
            return null;
        }
        return this.fAsComputedProcessor.testGetAsComputedConsoleContent();
    }

    public long getLastChangeTimestamp() {
        return this.fLastChangeTimestamp;
    }

    public Set<String> getGlobalPseudomethods() {
        return this.fGlobalPseudoMethods;
    }

    public boolean isEnableExtendedSemanticChecks() {
        return this.fEnableExtendedSemanticChecks;
    }

    private void addDefaultMethodsTranslateDisable() {
        this.fAsComputedMethodsTranslateDisable.add("main::ntv.get_context_name");
    }

    public Set<String> getAsComputedMethodsTranslateDisable(String packageName, String structName) {
        this.updateAsComputedMethodsTranslateDisable();
        return this.fAsComputedMethodsTranslateDisable.get(packageName, structName);
    }

    private void updateAsComputedMethodsTranslateDisable() {
        if (!this.fAsComputedMethodsTranslateDisableDirty) {
            return;
        }
        this.fAsComputedMethodsTranslateDisable = new AsComputedMethodsToTranslate(null);
        this.fAsComputedMethodsTranslateDisableDirty = false;
        boolean isAutoTranslateDisable = BuildConfigManager.isAsComputedAutoMethodsTranslateDisable((IProject)this.getProject());
        if (isAutoTranslateDisable) {
            return;
        }
        this.addDefaultMethodsTranslateDisable();
        List cachedInfo = BuildConfigManager.getActiveBuildConfigCompactedCachedInfo((IProject)this.getProject());
        if (cachedInfo == null) {
            return;
        }
        for (BuildConfigProperty p : cachedInfo) {
            List attributes;
            if (p.getKind() != 11 || !p.hasAttribute("ATTRIBUTE_AS_COMPUTED_TRANSLATE_METHOD_DISABLE") || (attributes = (List)p.getAttribute("ATTRIBUTE_AS_COMPUTED_TRANSLATE_METHOD_DISABLE")) == null || attributes.isEmpty()) continue;
            for (Token attribute : attributes) {
                this.fAsComputedMethodsTranslateDisable.add(attribute.getText());
            }
        }
    }

    public RfStruct get_exact_subtype_of_instance(IRfType type) {
        String packageName = type.getPackageName();
        String typeName = type.getName();
        RfStruct subType = (RfStruct)this.getType(packageName, false, 1, typeName, -1);
        subType = subType.get_exact_subtype_of_instance(type);
        return subType;
    }

    public _Int get_list_size(RfNamedElement listHolder) {
        return _Int.ZERO;
    }

    public RfNamedElement get_list_element(RfNamedElement listHolder, _Int index) {
        return null;
    }

    public void setPFModel(DVTPFModel powerFormatModel) {
    }

    private boolean checkCustomPragmas(ParserPath parserPath) {
        boolean hasCustomPragmas = false;
        if (parserPath == null) {
            return false;
        }
        List customPragmas = BuildConfigManager.getCustomPragmas((IProject)this.getProject());
        if (customPragmas == null || customPragmas.isEmpty()) {
            return false;
        }
        ArrayList<CustomPragmaUsage> sortedPragmas = new ArrayList<CustomPragmaUsage>();
        ArrayDeque<CustomPragmaUsage> workingPragmas = new ArrayDeque<CustomPragmaUsage>();
        LibraryPackageScope libPkgScope = new LibraryPackageScope("[dummy]", null, RfElementPath.UNKNOWN_ELEMENT_PATH);
        RfModule module = this.fParserPathToModuleMap.get(parserPath);
        if (module == null) {
            return false;
        }
        IEModel eModel = this.getPluginConfig().getModelManager().getEModel();
        if (eModel == null) {
            return false;
        }
        IResource fileAdapter = module.getFileAdapter();
        if (!(fileAdapter instanceof IFile)) {
            return false;
        }
        IEModule eModule = eModel.getOrCreateEModule((IFile)fileAdapter);
        if (eModule == null) {
            return false;
        }
        Map<Integer, Comment> comments = eModule.getComments();
        if (comments == null) {
            return false;
        }
        TreeMap<Integer, Comment> sortedComments = new TreeMap<Integer, Comment>();
        sortedComments.putAll(comments);
        for (Map.Entry entry : sortedComments.entrySet()) {
            CustomPragmaUsage pragmaUsage;
            int errorType;
            String firstIdentifier;
            if (entry.getValue() == null || !this.isCustomPragmaFirstIdentifier(firstIdentifier = DVTStringUtil.getFirstIdentifier((String)((Comment)entry.getValue()).comment))) continue;
            String processedComment = this.processComment(((Comment)entry.getValue()).comment);
            CustomPragma customPragma = this.getStartCustomPragma(processedComment);
            if (customPragma != null) {
                hasCustomPragmas = true;
                errorType = customPragma instanceof TranslatePragma ? 1 : 2;
                pragmaUsage = new CustomPragmaUsage(CustomPragmaUsage.Kind.START, ((Integer)entry.getKey()).intValue(), customPragma);
                if (workingPragmas.size() < 3) {
                    workingPragmas.push(pragmaUsage);
                    continue;
                }
                this.addSemanticError(errorType, "CUSTOM_PRAGMA_NESTING_EXCEEDED: More than 3 nested custom pragmas found", libPkgScope, -1, -1, null, pragmaUsage.getLine(), parserPath, new Object[0]);
                continue;
            }
            customPragma = this.getEndCustomPragma(processedComment);
            if (customPragma == null) continue;
            hasCustomPragmas = true;
            errorType = customPragma instanceof TranslatePragma ? 1 : 2;
            pragmaUsage = new CustomPragmaUsage(CustomPragmaUsage.Kind.END, ((Integer)entry.getKey()).intValue(), customPragma);
            if (workingPragmas.isEmpty()) {
                this.addSemanticError(errorType, "CUSTOM_PRAGMA_UNEXPECTED_END: No ''{0}'' start found", libPkgScope, -1, -1, null, pragmaUsage.getLine(), parserPath, pragmaUsage.getPragma().getStartPragma());
                sortedPragmas.add(pragmaUsage);
                continue;
            }
            CustomPragmaUsage stackPragma = (CustomPragmaUsage)workingPragmas.pop();
            if (!stackPragma.getPragmaName().equals(pragmaUsage.getPragmaName())) {
                this.addSemanticError(errorType, "CUSTOM_PRAGMA_MISMATCH: Expecting ''{0}'' found ''{1}''", libPkgScope, -1, -1, null, pragmaUsage.getLine(), parserPath, stackPragma.getPragma().getEndPragma(), pragmaUsage.getPragma().getEndPragma());
                workingPragmas.push(stackPragma);
                sortedPragmas.add(pragmaUsage);
                continue;
            }
            stackPragma.setValid();
            pragmaUsage.setValid();
            sortedPragmas.add(stackPragma);
            sortedPragmas.add(pragmaUsage);
        }
        while (!workingPragmas.isEmpty()) {
            CustomPragmaUsage pragma = (CustomPragmaUsage)workingPragmas.pop();
            int errorType = pragma.getPragma() instanceof TranslatePragma ? 1 : 2;
            this.addSemanticError(errorType, "CUSTOM_PRAGMA_NO_END: No matching ''{0}'' end pragma found", libPkgScope, -1, -1, null, pragma.getLine(), parserPath, pragma.getPragma().getEndPragma());
            sortedPragmas.add(pragma);
        }
        module.setCustomPragmas(sortedPragmas);
        return hasCustomPragmas;
    }

    public int asComputedStore(RfNamedElement element) {
        this.fAsComputedStore.add(element);
        return this.fAsComputedStore.size() - 1;
    }

    public RfNamedElement asComputedStore(int storeIndex) {
        return this.fAsComputedStore.get(storeIndex);
    }

    private void setCustomPragmas() {
        if (this.fProject == null) {
            return;
        }
        List customPragmas = BuildConfigManager.getCustomPragmas((IProject)this.fProject);
        if (customPragmas == null) {
            return;
        }
        this.fStartPragmas = new HashMap<String, CustomPragma>();
        this.fEndPragmas = new HashMap<String, CustomPragma>();
        this.fCustomPragmaFirstIdentifiers = new HashSet<String>();
        for (CustomPragma pragma : customPragmas) {
            if (!pragma.isEnabled() || pragma.isOverriden()) continue;
            this.fStartPragmas.put(pragma.getStartPragma(), pragma);
            this.fEndPragmas.put(pragma.getEndPragma(), pragma);
            this.fCustomPragmaFirstIdentifiers.add(DVTStringUtil.getFirstIdentifier((String)pragma.getStartPragma()));
            this.fCustomPragmaFirstIdentifiers.add(DVTStringUtil.getFirstIdentifier((String)pragma.getEndPragma()));
        }
    }

    protected final String processComment(String comment) {
        if (this.fStartPragmas == null || this.fEndPragmas == null || this.fStartPragmas.isEmpty() || this.fEndPragmas.isEmpty() || comment == null) {
            return null;
        }
        return DVTStringUtil.collapseWhitespaces((String)comment);
    }

    private CustomPragma getStartCustomPragma(String processedComment) {
        if (this.fStartPragmas == null || this.fStartPragmas.isEmpty() || processedComment == null) {
            return null;
        }
        return this.fStartPragmas.get(processedComment);
    }

    private CustomPragma getEndCustomPragma(String processedComment) {
        if (this.fEndPragmas == null || this.fEndPragmas.isEmpty() || processedComment == null) {
            return null;
        }
        return this.fEndPragmas.get(processedComment);
    }

    protected final boolean isCustomPragmaFirstIdentifier(String firstIdentifier) {
        if (this.fCustomPragmaFirstIdentifiers == null || firstIdentifier == null) {
            return false;
        }
        return this.fCustomPragmaFirstIdentifiers.contains(firstIdentifier);
    }

    public Set<ParserPath> getRawCompiledFilesSet() {
        if (this.fFullBuildModuleReferences == null) {
            return null;
        }
        return this.fFullBuildModuleReferences.stream().map(mr -> mr.parserPath).collect(Collectors.toSet());
    }

    public __etools_string get_specman_version() {
        DVTExternalProgramOutputCache.DVTExternalProgram xrunVersion = DVTExternalProgramOutputCache.getInstance().get("xrun -version -nolog -nohistory");
        DVTExternalProgramOutputCache.DVTExternalProgram.Result xrunVersionString = xrunVersion.getResult(false);
        if (!xrunVersionString.isValid()) {
            return __etools_string.getDefaultValue();
        }
        return new __etools_string(xrunVersionString.value);
    }

    public RfValueHolder eval_exp_string(__etools_string expressionString) {
        EModuleInfo eModuleInfo = this.fModuleReferenceToEModuleInfoMap.values().iterator().next();
        RfModule rfModule = this.fParserPathToModuleMap.values().iterator().next();
        ExpEvaluator expExecutor = new ExpEvaluator(this, eModuleInfo, rfModule, this.fAsComputedProcessor);
        return expExecutor.eval(expressionString);
    }

    public void setTempDisableSemanticErrorReporting(boolean disable) {
        this.fTempDisableSemanticErrorReporting = disable;
    }

    public IProgressMonitor getBuildProgressMonitor() {
        return this.fBuildProgressMonitor;
    }

    public ChangedFilesManager getChangedFilesManager() {
        if (this.fChangedFilesManager == null) {
            this.fChangedFilesManager = new ChangedFilesManager();
        }
        return this.fChangedFilesManager;
    }

    public RfPredefinedScalar getCachedScalarType(String cachedTypeName) {
        if (cachedTypeName == null) {
            return null;
        }
        return this.fCachedScalarTypes.get(cachedTypeName);
    }

    public void setCachedScalarType(String cachedTypeName, RfPredefinedScalar copyAssocType) {
        if (cachedTypeName == null) {
            return;
        }
        this.fCachedScalarTypes.put(cachedTypeName, copyAssocType);
    }

    public void restoreInvocationsInfo(IRfProjectContent rfProjectContent, RfCompiledFiles compiledFiles, Map<String, BCFileInstance> buildConfigFiles) {
        if (this.fParserPathToModuleMap == null) {
            return;
        }
        Collection<RfModule> fileDefs = this.fParserPathToModuleMap.values();
        if (fileDefs == null) {
            return;
        }
        for (RfModule rfModule : fileDefs) {
            BuildConfigUtils.sendIndexToBCFiles((int)(rfModule.getModuleIndex() - RfPredefinedCodeLoader.PREDEF_FILES_LIST.length - (this.getLanguageKind() == LanguageKind.SLN ? 1 : 0)), (LanguageKind)this.getLanguageKind(), (int)rfModule.getInvocationIndex(), buildConfigFiles);
        }
    }

    public int cleanTests() {
        int moduleIndex = 0;
        if (this.fParserPathToModuleMap == null) {
            return 0;
        }
        Collection<RfModule> fileDefs = this.fParserPathToModuleMap.values();
        if (fileDefs == null) {
            return 0;
        }
        IEModel eModel = this.getPluginConfig().getModelManager().getEModel();
        if (eModel == null) {
            return 0;
        }
        Iterator<RfModule> iterator = fileDefs.iterator();
        while (iterator.hasNext()) {
            IEModule eModule;
            RfModule rfModule = iterator.next();
            if (rfModule.isInTop()) {
                moduleIndex = Math.max(moduleIndex, rfModule.getModuleIndex());
                continue;
            }
            IResource fileAdapter = rfModule.getFileAdapter();
            if (!(fileAdapter instanceof IFile) || (eModule = eModel.getOrCreateEModule((IFile)fileAdapter)) == null) continue;
            this.clean(eModule);
            ParserPath parserPath = rfModule.getParserPath();
            this.fModuleReferenceToEModuleInfoMap.remove(new ModuleReference(parserPath, -1));
            iterator.remove();
        }
        return moduleIndex;
    }

    public IHidBuilders getHidBuilders() {
        return HidUtils.DEFAULT_BUILDERS;
    }

    public IRfFileDef getFileDefUsingParserPath(ParserPath parserPath) {
        return this.fParserPathToModuleMap.get(parserPath);
    }

    class CloseNonTopModuleJob
    extends Job {
        private RfModule fModule;

        public CloseNonTopModuleJob() {
            super("CloseNonTopModuleJob");
            this.setSystem(true);
            this.setPriority(50);
        }

        public boolean belongsTo(Object family) {
            return family == ResourcesPlugin.FAMILY_MANUAL_BUILD || family == IDVTConstants.E_FAMILY_REPARSE;
        }

        public void setModule(RfModule module) {
            this.fModule = module;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                List emptyList = Collections.emptyList();
                IEReparseListener syntaxErrorManager = RfProject.this.getPluginConfig().getSyntaxErrorManager();
                if (syntaxErrorManager != null) {
                    syntaxErrorManager.reparsed(0, 2, this.fModule.getFileAdapter(), emptyList, emptyList, emptyList);
                }
                ModuleReference moduleReference = this.fModule.getModuleReference();
                RfProject.this.cleanSemanticProblems(Collections.singletonList(moduleReference), null);
                RfProject.this.cleanDirtyElements();
                EnumMap changedFilesMap = new EnumMap(LanguageKind.class);
                LinkedHashSet<FileCompileInfo> changedFiles = new LinkedHashSet<FileCompileInfo>();
                changedFilesMap.put(RfProject.this.getLanguageKind(), changedFiles);
                IFile iFile = (IFile)this.fModule.getAdapter(IResource.class);
                if (iFile != null) {
                    changedFiles.add(new FileCompileInfo(iFile));
                }
                BuildEventManager.getInstance().notifyIncrementalBuild(RfProject.this.fProject, changedFilesMap, ViewsUtils.ALL_BUT_DH_VIEWS);
                RfProject.this.fRfManager.writeRFDM(RfProject.this);
                ro.amiq.edt.base.utils.Utils.triggerSemanticMarkers(RfProject.this.getPluginConfig(), RfProject.this.fProject, RfProject.this.fSemanticErrors, false);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }

    public static class ElementContainer {
        public RfNamedElement element;
        public RfDefElement def;

        public ElementContainer(RfNamedElement element) {
            this.element = element;
        }

        public ElementContainer(RfDefElement def) {
            this.element = def == null ? null : def.getNamedElement();
            this.def = def;
        }

        public ElementContainer(RfDefElement def, RfNamedElement element) {
            this.element = def == null ? element : def.getNamedElement();
            this.def = def;
        }
    }

    public static class ModuleReference
    implements Comparable<ModuleReference>,
    Serializable {
        private static final long serialVersionUID = 20142L;
        public ParserPath parserPath;
        public int moduleIndex;

        public ModuleReference(ParserPath parserPath, int moduleIndex) {
            this.parserPath = parserPath;
            this.moduleIndex = moduleIndex;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.parserPath == null ? 0 : this.parserPath.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ModuleReference other = (ModuleReference)obj;
            return !(this.parserPath == null ? other.parserPath != null : !this.parserPath.equals((Object)other.parserPath));
        }

        @Override
        public int compareTo(ModuleReference o) {
            return this.moduleIndex - o.moduleIndex;
        }

        public String toString() {
            return this.parserPath.toString();
        }
    }

    private class RfNamedElementComparator
    implements Comparator<RfNamedElement> {
        private RfNamedElementComparator() {
        }

        @Override
        public int compare(RfNamedElement o1, RfNamedElement o2) {
            return o1.getName().compareTo(o2.getName());
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    public static class ScopeInfo {
        RfStruct fLastPackage;
        RfModule fLastModule;
        RfStruct fLastStruct;
        RfMethod fLastMethod;
        RfStructLayer fLastStructLayer;
        RfMethodLayer fLastMethodLayer;
        RfCoverLayer fLastCoverLayer;
        RfMacroLayer fLastMacroLayer;
        WrapperType fLastPerUnitInstance;
    }

    public static enum VariableKind {
        IT,
        INDEX,
        DEFAULT;

    }
}

