/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.text.MessageFormat;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.IRfStructMemberLayer;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfSDLInlineSM;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.etools.eparser.ReparseElement;

public class RfSDLInlineSMLayer
extends RfDefElement
implements IRfStructMemberLayer {
    private static final String INLINE = "[inline_{0}]";
    private RfStructLayer fEnclosingScope;
    private String fArgName;
    private String fInlineText;
    private String fInlineElseText;

    protected RfSDLInlineSMLayer(RfModule module, RfStructLayer structLayer, String argName, String inlineText, String inlineElseText, LineInfo line, ReparseElement[] reparseStack) {
        super(module, structLayer, 378, line, line, null, reparseStack);
        this.fEnclosingScope = structLayer;
        this.fArgName = argName;
        this.fInlineText = inlineText;
        this.fInlineElseText = inlineElseText;
    }

    protected static String getInlineName(RfProject project) {
        return MessageFormat.format(INLINE, project.getSDLInlineCounter());
    }

    public String getArgName() {
        return this.fArgName;
    }

    public String getInlineText() {
        return this.fInlineText;
    }

    public String getInlineElseText() {
        return this.fInlineElseText;
    }

    @Override
    public void deepClean() {
        this.fEnclosingScope = null;
        super.deepClean();
    }

    @Override
    public RfStructLayer getStructLayer() {
        return this.fEnclosingScope;
    }

    @Override
    public String getDefStructLayerName() {
        return this.getStructLayer() == null ? "" : this.getStructLayer().getInfo();
    }

    @Override
    public Determinant getDefStructDeterminant() {
        RfStructLayer structLayer = this.getStructLayer();
        return structLayer == null ? new Determinant(new String[]{""}) : structLayer.getDeterminant();
    }

    public String getInfo() {
        return ((RfSDLInlineSM)this.getNamedElement()).getName();
    }
}

