/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.IRfAssociatedType;
import ro.amiq.edt.base.model.reflection.Range;
import ro.amiq.edt.base.model.reflection.RfArg;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfExpect;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfMeImplicitVariable;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfScalarTypeLayer;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.ascomputed.AsComputedProcessor;
import ro.amiq.edt.base.model.reflection.ascomputed.ClassEncap;
import ro.amiq.edt.base.model.reflection.ascomputed.base.AsComputedBase;
import ro.amiq.edt.base.model.reflection.ascomputed.base.EList;
import ro.amiq.edt.base.model.reflection.ascomputed.base.ERange;
import ro.amiq.edt.base.model.reflection.ascomputed.base.ESet;
import ro.amiq.edt.base.model.reflection.ascomputed.base._Int;
import ro.amiq.edt.base.model.reflection.ascomputed.base.__etools_string;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedField;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedMethod;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedScalar;
import ro.amiq.edt.base.model.reflection.semantic.RfDummyField;
import ro.amiq.edt.base.model.reflection.semantic.SemanticUtils;
import ro.amiq.edt.base.utils.EDTFileUtils;

public class RfScalarType
extends RfType
implements IRfAssociatedTypeElement {
    public static final String ANONYMOUS_ENUM_PREFIX = "__dvt_anonymous_";
    public static final Set<String> INTEGRAL_TYPES_AS_JAVA = new HashSet<String>();
    public static final Set<String> NOT_ENUMS_FOR_AS_COMPUTED = new HashSet<String>();
    private String fBaseName;
    private RfScalarType fAssocType;
    private List<RfScalarType> fEnumTypeChildren;
    private int fNofBits;
    private boolean fIsEnumType;
    private boolean fIsIntegerAssignmentCompatible;
    private long fCacheTimestamp;
    private List<RfDefElement> fCachedLayers;
    private static int CLASS_ENCAP_NOF_ENUMS_PER_CLASS;

    static {
        INTEGRAL_TYPES_AS_JAVA.add("int");
        INTEGRAL_TYPES_AS_JAVA.add("uint");
        INTEGRAL_TYPES_AS_JAVA.add("byte");
        INTEGRAL_TYPES_AS_JAVA.add("nibble");
        INTEGRAL_TYPES_AS_JAVA.add("bit");
        INTEGRAL_TYPES_AS_JAVA.add("longint");
        INTEGRAL_TYPES_AS_JAVA.add("longuint");
        INTEGRAL_TYPES_AS_JAVA.add("time");
        INTEGRAL_TYPES_AS_JAVA.add("index");
        INTEGRAL_TYPES_AS_JAVA.add("thread_handle");
        INTEGRAL_TYPES_AS_JAVA.add("external_pointer");
        NOT_ENUMS_FOR_AS_COMPUTED.add("int");
        NOT_ENUMS_FOR_AS_COMPUTED.add("uint");
        NOT_ENUMS_FOR_AS_COMPUTED.add("byte");
        NOT_ENUMS_FOR_AS_COMPUTED.add("nibble");
        NOT_ENUMS_FOR_AS_COMPUTED.add("bit");
        NOT_ENUMS_FOR_AS_COMPUTED.add("longuint");
        NOT_ENUMS_FOR_AS_COMPUTED.add("longint");
        NOT_ENUMS_FOR_AS_COMPUTED.add("time");
        NOT_ENUMS_FOR_AS_COMPUTED.add("index");
        NOT_ENUMS_FOR_AS_COMPUTED.add("thread_handle");
        NOT_ENUMS_FOR_AS_COMPUTED.add("external_pointer");
        NOT_ENUMS_FOR_AS_COMPUTED.add("untyped");
        NOT_ENUMS_FOR_AS_COMPUTED.add("real");
        NOT_ENUMS_FOR_AS_COMPUTED.add("bool");
        NOT_ENUMS_FOR_AS_COMPUTED.add("source_ref");
        CLASS_ENCAP_NOF_ENUMS_PER_CLASS = 2500;
    }

    public RfScalarType(RfProject project, String typeName) {
        super(project, typeName);
        this.fIsIntegerAssignmentCompatible = RfPredefinedScalar.INTEGRAL_TYPES_AS_JAVA.contains(typeName);
    }

    @Override
    public void setAssociatedType(String assocTypeName, String assocTypePackageName, boolean isEnum) {
        this.fBaseName = null;
        this.fIsEnumType = isEnum;
        this.fBaseName = this.fIsEnumType ? null : assocTypeName;
        this.fIsIntegerAssignmentCompatible = RfPredefinedScalar.INTEGRAL_TYPES_AS_JAVA.contains(assocTypeName);
    }

    public boolean isSigned() {
        if (this.fAssocType == null) {
            return false;
        }
        return this.fAssocType.isSigned();
    }

    public boolean isJavaNotEnum() {
        if (this.fAssocType == null) {
            return !this.fIsEnumType;
        }
        return this.fAssocType.isJavaNotEnum();
    }

    public void setNofBits(int bits) {
        this.fNofBits = bits;
    }

    public int getNofBits() {
        return this.fNofBits;
    }

    public int getMaxNofBits() {
        if (this.fAssocType == null) {
            return this.fNofBits;
        }
        return this.fAssocType.getMaxNofBits();
    }

    @Override
    public void deepClean() {
        try {
            this.fAssocType = null;
            super.deepClean();
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    @Override
    protected void addLayer(RfDefElement layer) {
        if (layer instanceof RfScalarTypeLayer && ((RfScalarTypeLayer)layer).isEnumType()) {
            this.fIsEnumType = true;
        }
        super.addLayer(layer);
    }

    public List<RfDefElement> getAllEnumTypeLayers(long lastChangeTimestamp, int moduleIndex) {
        RfType parentType;
        if (this.fEnumTypeChildren == null && (parentType = this.getAssociatedType()) instanceof RfScalarType && ((RfScalarType)parentType).fEnumTypeChildren == null) {
            return this.getLayers();
        }
        if (lastChangeTimestamp != -1L && lastChangeTimestamp == this.fCacheTimestamp) {
            return this.fCachedLayers;
        }
        this.fCachedLayers = new ArrayList<RfDefElement>();
        RfType parentEnumType = this;
        while (parentEnumType instanceof RfScalarType) {
            RfType parentType2 = parentEnumType.getAssociatedType();
            if (!(parentType2 instanceof RfScalarType) || ((RfScalarType)parentType2).fEnumTypeChildren == null) break;
            parentEnumType = parentType2;
        }
        this.collectChildrenEnums(this.fCachedLayers, (RfScalarType)parentEnumType, moduleIndex);
        this.fCacheTimestamp = lastChangeTimestamp;
        Collections.sort(this.fCachedLayers);
        return this.fCachedLayers;
    }

    protected Map<String, RfEnum> internalGetGeneratableEnums(RfProject project, RfDefElement childDeclarationLayer, RfDefElement lastLayer) {
        List<RfDefElement> layers = this.getLayers();
        if (layers == null || layers.isEmpty()) {
            return new LinkedHashMap<String, RfEnum>();
        }
        Map<String, RfEnum> allGeneratableEnums = null;
        allGeneratableEnums = this.fAssocType != null && this.fAssocType.fEnumTypeChildren != null ? this.fAssocType.internalGetGeneratableEnums(project, layers.get(0), null) : new LinkedHashMap<String, RfEnum>();
        allGeneratableEnums = this.filterRange(allGeneratableEnums);
        for (RfDefElement layer : layers) {
            if (lastLayer != null && layer == lastLayer || childDeclarationLayer != null && layer.compareTo(childDeclarationLayer) >= 0) break;
            Collection<RfEnum> enums = ((RfScalarTypeLayer)layer).getEnums();
            if (enums == null || enums.isEmpty()) continue;
            for (RfEnum enumItem : enums) {
                String name = enumItem.getName();
                if (name.length() == 0 || allGeneratableEnums.containsKey(name)) continue;
                allGeneratableEnums.put(name, enumItem);
            }
        }
        return allGeneratableEnums;
    }

    protected Map<String, RfEnum> filterRange(Map<String, RfEnum> enums) {
        if (enums == null || enums.isEmpty()) {
            return enums;
        }
        List<Range> ranges = this.getVisibleRanges();
        if (ranges == null) {
            return enums;
        }
        LinkedHashMap<String, RfEnum> filteredEnums = new LinkedHashMap<String, RfEnum>();
        block0: for (Range range : ranges) {
            boolean enable = range.left == null;
            for (RfEnum enumElement : enums.values()) {
                String name = enumElement.getName();
                if (name == null) continue;
                if (!enable && name.equals(range.left)) {
                    enable = true;
                }
                if (enable) {
                    filteredEnums.put(enumElement.getName(), enumElement);
                }
                if (name.equals(range.right)) continue block0;
            }
        }
        return filteredEnums;
    }

    private void collectChildrenEnums(List<RfDefElement> enumTypeFamilyLayers, RfScalarType enumType, int moduleIndex) {
        this.addLayersOfType(enumTypeFamilyLayers, enumType, moduleIndex);
        if (enumType.fEnumTypeChildren == null) {
            return;
        }
        for (RfScalarType enumChildType : enumType.fEnumTypeChildren) {
            this.collectChildrenEnums(enumTypeFamilyLayers, enumChildType, moduleIndex);
            this.addLayersOfType(enumTypeFamilyLayers, enumChildType, moduleIndex);
        }
    }

    private void addLayersOfType(List<RfDefElement> enumTypeFamilyLayers, RfScalarType enumType, int moduleIndex) {
        List<RfDefElement> layers = enumType.getLayers();
        if (layers == null || layers.isEmpty()) {
            return;
        }
        for (RfDefElement layer : layers) {
            if (moduleIndex != -1 && layer.getModuleIndex() > moduleIndex) continue;
            enumTypeFamilyLayers.add(layer);
        }
    }

    @Override
    public List<RfDefElement> getLayers() {
        return super.getLayers();
    }

    public boolean isIntegerAlias() {
        String name = this.getName();
        boolean result = INTEGRAL_TYPES_AS_JAVA.contains(name);
        if (result) {
            return true;
        }
        if (this.fAssocType == null) {
            return false;
        }
        return this.fAssocType.isIntegerAlias();
    }

    public String getSignature() {
        String result = "type " + this.getName();
        return result;
    }

    public String getAssociatedTypeName() {
        return this.fBaseName;
    }

    public String getAssociatedFullTypeName() {
        return this.fBaseName;
    }

    @Override
    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currLayer, LineInfo lineInfo, ParserPath parserPath) {
        if (currLayer == null) {
            return;
        }
        boolean isCurrDeclarationLayer = this.isDeclarationLayer(currLayer);
        boolean isPredefined = this.isPredefined();
        if (isPredefined && isCurrDeclarationLayer) {
            project.addSemanticError1(1, "PREDEFINED_NAME: Type name ''{0}'' is a reserved type name. Use a different name", lineInfo.realOffset, lineInfo.realOffset + this.getName().length(), null, lineInfo.line, parserPath, this.getName());
            return;
        }
        List<RfDefElement> layers = this.getLayers();
        if (layers == null || layers.isEmpty()) {
            return;
        }
        boolean hasDeclaration = isCurrDeclarationLayer;
        for (RfDefElement layer : layers) {
            if (layer == currLayer) break;
            if (!project.importedBySameTest(layer, currLayer)) continue;
            boolean isDeclarationLayer = this.isDeclarationLayer(layer);
            hasDeclaration |= isDeclarationLayer;
            if (!isCurrDeclarationLayer || !isDeclarationLayer) continue;
            project.addSemanticError1(1, "DUPLICATE_NAME: Name ''{0}'' in package ''{1}'' was previously defined\n    at line {2,number,#######} in {3}", lineInfo.realOffset, lineInfo.realOffset + this.getName().length(), null, lineInfo.line, parserPath, this.getName(), this.getPackageName(), layer.getStartLine(), layer.getParserPath());
            return;
        }
        if (!isPredefined && !hasDeclaration) {
            project.addSemanticError1(1, "UNDEFINED_TYPE: No type called ''{0}''", lineInfo.getOffset(), lineInfo.getOffset() + this.getName().length(), null, lineInfo.line, parserPath, this.getName());
        }
        if (currLayer instanceof RfScalarTypeLayer) {
            ((RfScalarTypeLayer)currLayer).performDuplicateEnumCheck(project);
        }
    }

    @Override
    public List<RfEnum> getEnumsWithPrefix(int matchType, String prefix) {
        LinkedHashMap<String, RfEnum> result = new LinkedHashMap<String, RfEnum>();
        this.internalGetEnumsWithPrefix(this.getRfProject(), result, matchType, prefix);
        return new ArrayList<RfEnum>(result.values());
    }

    protected final void internalGetEnumsWithPrefix(RfProject project, Map<String, RfEnum> result, int matchType, String prefix) {
        try {
            if (project == null) {
                return;
            }
            if (this.isEnumType()) {
                List<RfDefElement> layers = this.getAllEnumTypeLayers(project.getLastChangeTimestamp(), -1);
                for (RfDefElement layer : layers) {
                    Collection<RfEnum> enums = ((RfScalarTypeLayer)layer).getEnums();
                    if (enums == null) continue;
                    for (RfEnum enumItem : enums) {
                        if (enumItem.getName().length() == 0 || !DVTStringUtil.regionMatches((String)enumItem.getName(), (String)prefix, (int)matchType) || result.containsKey(enumItem.getName())) continue;
                        result.put(enumItem.getName(), enumItem);
                    }
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public RfEnum getEnumWithPrefix(int matchType, String prefix) {
        RfProject project;
        block6: {
            project = this.getRfProject();
            if (project != null) break block6;
            return null;
        }
        try {
            if (this.isEnumType()) {
                List<RfDefElement> layers = this.getAllEnumTypeLayers(project.getLastChangeTimestamp(), -1);
                for (RfDefElement layer : layers) {
                    Collection<RfEnum> enums;
                    if (!(layer instanceof RfScalarTypeLayer) || (enums = ((RfScalarTypeLayer)layer).getEnums()) == null) continue;
                    for (RfEnum enumItem : enums) {
                        if (enumItem.getName().length() == 0 || !DVTStringUtil.regionMatches((String)enumItem.getName(), (String)prefix, (int)matchType)) continue;
                        return enumItem;
                    }
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    public RfEnum getEnum(RfProject project, String enumName, int moduleIndex, ParserPath parserPath) {
        try {
            if (this.isEnumType()) {
                List<RfDefElement> layers = this.getAllEnumTypeLayers(project.getLastChangeTimestamp(), -1);
                for (RfDefElement layer : layers) {
                    RfEnum enumItem;
                    if (!(layer instanceof RfScalarTypeLayer) || !project.importedBySameTest(parserPath, layer) || (enumItem = ((RfScalarTypeLayer)layer).getEnum(enumName)) == null) continue;
                    return enumItem;
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    @Override
    public List<RfMethod> getMethodsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int hidingLevel) {
        RfPredefinedMethod method;
        ArrayList<RfMethod> result = new ArrayList<RfMethod>();
        RfProject project = this.getRfProject();
        if (DVTStringUtil.regionMatches((String)"to_string", (String)prefix, (int)matchType)) {
            method = new RfPredefinedMethod(project, project.getPseudoStruct(), "to_string", "string", "", null, "Returns the string representation.");
            RfType stringType = project.getType("main", true, 2, "string", -1);
            method.setAssociatedType(stringType);
            result.add(method);
        }
        if (DVTStringUtil.regionMatches((String)"copy", (String)prefix, (int)matchType)) {
            method = new RfPredefinedMethod(project, project.getPseudoStruct(), "copy", this.getFullName().toString(), "", null, "Returns a shallow, non-recursive copy of the expression. This means that if the expression is a list or a struct that contains other lists or structs, the second-level items are not duplicated. Instead, they are copied by reference.");
            method.setAssociatedType(this);
            method.setAssociatedTypeDeterminant(this.getDeterminant());
            result.add(method);
        }
        return result;
    }

    @Override
    public RfMethod getMethodWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        RfProject project = this.getRfProject();
        if (DVTStringUtil.regionMatches((String)"to_string", (String)prefix, (int)matchType)) {
            RfPredefinedMethod method = new RfPredefinedMethod(project, project.getPseudoStruct(), "to_string", "string", "", null, "Returns the string representation.");
            RfType stringType = project.getType("main", true, 2, "string", -1);
            method.setAssociatedType(stringType);
            return method;
        }
        if (DVTStringUtil.regionMatches((String)"copy", (String)prefix, (int)matchType)) {
            RfPredefinedMethod method = new RfPredefinedMethod(project, project.getPseudoStruct(), "copy", this.getFullName().toString(), "", null, "Returns a shallow, non-recursive copy of the expression. This means that if the expression is a list or a struct that contains other lists or structs, the second-level items are not duplicated. Instead, they are copied by reference.");
            method.setAssociatedType(this);
            method.setAssociatedTypeDeterminant(this.getDeterminant());
            return method;
        }
        if ("sn_vec".equals(this.getName()) && DVTStringUtil.regionMatches((String)"is_plus_inf", (String)prefix, (int)matchType)) {
            RfPredefinedMethod method = new RfPredefinedMethod(project, project.getPseudoStruct(), "is_plus_inf", "bool", "", null, "@Non-standard");
            method.setAssociatedType(project.getTypesUtil().BOOL_TYPE());
            method.setAssociatedTypeDeterminant(this.getDeterminant());
            return method;
        }
        if ("sn_vec".equals(this.getName()) && DVTStringUtil.regionMatches((String)"is_minus_inf", (String)prefix, (int)matchType)) {
            RfPredefinedMethod method = new RfPredefinedMethod(project, project.getPseudoStruct(), "is_minus_inf", "bool", "", null, "@Non-standard");
            method.setAssociatedType(project.getTypesUtil().BOOL_TYPE());
            method.setAssociatedTypeDeterminant(this.getDeterminant());
            return method;
        }
        return null;
    }

    @Override
    public RfNamedElement semanticGetMember(RfProject project, Determinant determinant, String packageName, RfStruct enclosingStruct, String name, EnumSet<IRfNamedElement.ElementKind> allowedElements, int accessModifiers, int maxModuleIndex, ParserPath parserPath, RfNamedElement exclude) {
        RfMethod result;
        if (allowedElements.contains(IRfNamedElement.ElementKind.E_METHOD) && (result = this.getMethodWithPrefix(packageName, null, 1, name, accessModifiers)) != null) {
            return result;
        }
        if (allowedElements.contains(IRfNamedElement.ElementKind.E_FIELD)) {
            return this.getEnum(project, name, maxModuleIndex, parserPath);
        }
        return null;
    }

    public RfType getAssociatedType() {
        return this.fAssocType;
    }

    public RfType getAssociatedBaseType() {
        return this.fAssocType;
    }

    @Override
    public Determinant getDeterminant() {
        return null;
    }

    @Override
    public void setTransientDeterminant(Determinant determinant) {
    }

    @Override
    public Determinant getTransientDeterminant() {
        return this.getDeterminant();
    }

    @Override
    public String getContextType() {
        return "ro.amiq.edt.templates.contextType.statement";
    }

    @Override
    public List<RfArg> getArgumentsWithPrefix(int matchType, String prefix) {
        return null;
    }

    @Override
    public RfArg getArgumentWithPrefix(int matchType, String prefix) {
        return null;
    }

    @Override
    public List<RfField> getFieldsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int hidingLevel) {
        return null;
    }

    @Override
    public RfField getFieldWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        return null;
    }

    @Override
    public List<RfEvent> getEventsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int hidingLevel) {
        return null;
    }

    @Override
    public RfEvent getEventWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        return null;
    }

    @Override
    public List<RfExpect> getExpectsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        return null;
    }

    @Override
    public RfExpect getExpectWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        return null;
    }

    @Override
    public List<RfVar> getVariablesWithPrefix(int line, int matchType, String prefix) {
        return null;
    }

    @Override
    public RfVar getVariableWithPrefix(int line, int matchType, String prefix) {
        return null;
    }

    @Override
    public boolean isInGlobal() {
        return false;
    }

    @Override
    public RfMeImplicitVariable getMeImplicitVariable(int matchType, String prefix) {
        return null;
    }

    @Override
    public RfPredefinedField getCompImplicitVariable(RfProject project, int matchType, String prefix) {
        return null;
    }

    public void setIsEnumType(boolean isEnumType) {
        this.fIsEnumType = isEnumType;
    }

    public void setAssociatedTypeFrom(RfProject project, RfNamedElement typeContainer) {
        if (typeContainer instanceof IRfAssociatedType) {
            this.fAssocType = (RfScalarType)((IRfAssociatedType)((Object)typeContainer)).getAssociatedType();
        }
        if (this instanceof RfEnum) {
            return;
        }
        if (this.fAssocType != null) {
            this.fIsEnumType = this.fAssocType.isEnumType();
            if (this.fIsEnumType) {
                this.fAssocType.addEnumTypeChild(this);
            }
            this.fIsIntegerAssignmentCompatible = this.fAssocType.isIntegerAssignmentCompatible();
            if (typeContainer instanceof RfDummyField && ((RfDummyField)typeContainer).getWidth() > 0) {
                this.fNofBits = ((RfDummyField)typeContainer).getWidth();
            }
        }
        if (this.fIsIntegerAssignmentCompatible || !this.fIsEnumType) {
            project.getAsComputedProcessor().register("_Int", this.javaName());
        }
    }

    private void addEnumTypeChild(RfScalarType enumType) {
        if (this.fEnumTypeChildren == null) {
            this.fEnumTypeChildren = new ArrayList<RfScalarType>();
        }
        this.fEnumTypeChildren.add(enumType);
    }

    @Override
    protected void removeDirty(RfProject project, RfStruct packg, Iterator<RfType> typeIterator) {
        try {
            String packageName;
            RfDefElement layer;
            boolean removeType = this.hasNoLayers();
            if (removeType) {
                typeIterator.remove();
            } else if (!this.isDeclaredIn(packg) && (layer = this.getFirstLayer()) != null && !(packageName = layer.getPackageName()).equals(packg.getPackageName())) {
                packg = project.getPackage(packageName);
                RfType type = packg.getType(this.getName());
                if (type == null) {
                    packg.addType(this, true);
                }
                typeIterator.remove();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean isEnumType() {
        return this.fIsEnumType;
    }

    public boolean isIntegerAssignmentCompatible() {
        return this.fIsIntegerAssignmentCompatible;
    }

    public _Int get_size_in_bits() {
        int maxNofBits = this.getMaxNofBits();
        int nofBits = this.getNofBits() == -1 ? maxNofBits : this.getNofBits();
        return new _Int(nofBits);
    }

    private String javaNonGeneratableEnums(RfProject project) {
        if (this.fAssocType == null && this.fEnumTypeChildren == null) {
            return "null";
        }
        LinkedHashMap<String, RfEnum> allEnums = new LinkedHashMap<String, RfEnum>();
        this.internalGetEnumsWithPrefix(project, allEnums, 2, "");
        Map<String, RfEnum> allGeneratableEnums = this.internalGetGeneratableEnums(project, null, null);
        allEnums.keySet().removeAll(allGeneratableEnums.keySet());
        LinkedHashMap<String, RfEnum> nonGeneratableNames = allEnums;
        if (nonGeneratableNames.isEmpty()) {
            return "null";
        }
        StringBuilder result = new StringBuilder("new HashSet<String>(Arrays.asList(");
        boolean prependComma = false;
        for (String name : nonGeneratableNames.keySet()) {
            if (prependComma) {
                result.append(", ");
            }
            result.append('\"').append(name).append('\"');
            prependComma = true;
        }
        result.append("))");
        return result.toString();
    }

    @Override
    public ClassEncap toClassEncap(RfProject project) {
        String name = this.getName();
        if (INTEGRAL_TYPES_AS_JAVA.contains(name) || "bool".equals(name) || "real".equals(name)) {
            return null;
        }
        String javaName = this.javaName();
        if ("_Int".equals(javaName)) {
            return null;
        }
        HashSet<RfType> references = new HashSet<RfType>();
        if (this.fAssocType != null) {
            references.add(this.fAssocType);
        }
        if (this.fEnumTypeChildren != null) {
            references.addAll(this.fEnumTypeChildren);
        }
        if (this.isIntegerAssignmentCompatible()) {
            return null;
        }
        RfScalarType parentEnumType = this.getParentEnumType();
        if (parentEnumType != this) {
            StringBuilder javaCode = new StringBuilder("package ").append("ro.amiq.edt.base.debug.ascomputed").append(";\n").append("import ro.amiq.edt.base.model.reflection.*;\n").append("import ro.amiq.etools.eparser.*;\n").append("import ro.amiq.edt.base.model.reflection.ascomputed.base.*;\n").append("import java.io.Serializable;\n").append("import java.util.*;\n\n").append("public class ").append(javaName).append(" extends ").append(parentEnumType.javaName()).append(" implements Serializable {\n\n").append("    private static final long serialVersionUID = 1L;\n\n").append("    public Set<String> fNonGeneratableSet = ").append(this.javaNonGeneratableEnums(project)).append(";\n\n").append("    public Set<String> getNonGeneratableSet() {\n").append("        return fNonGeneratableSet;\n").append("    }\n\n").append("}\n\n");
            EDTFileUtils.getInstance().dumpAsComputedDebug(project.getProject(), this.javaName(), javaCode.toString());
            return new ClassEncap(javaCode.toString(), references, false);
        }
        List<RfEnum> enums = this.getEnumsWithPrefix(2, "");
        if (enums == null) {
            enums = new ArrayList<RfEnum>(0);
        }
        HashSet<String> alreadyRegistered = new HashSet<String>();
        ArrayList<RfEnum> uniqueEnums = new ArrayList<RfEnum>(enums.size());
        int i = 0;
        while (i < enums.size()) {
            RfEnum enumElement = enums.get(i);
            if (!alreadyRegistered.contains(enumElement.getName())) {
                alreadyRegistered.add(enumElement.getName());
                uniqueEnums.add(enumElement);
            }
            ++i;
        }
        int nofClasses = uniqueEnums.size() / CLASS_ENCAP_NOF_ENUMS_PER_CLASS;
        if (nofClasses == 0 || nofClasses * CLASS_ENCAP_NOF_ENUMS_PER_CLASS < uniqueEnums.size()) {
            ++nofClasses;
        }
        StringBuilder javaCode = new StringBuilder();
        int[] value = new int[1];
        int i2 = 0;
        while (i2 < nofClasses) {
            String prevClassName;
            int currClassIndex = nofClasses - i2 - 1;
            String currClassName = currClassIndex == 0 ? javaName : javaName.replace("__etools_", "__etools_" + Integer.toString(currClassIndex) + "_");
            String string = prevClassName = i2 == 0 ? "AsComputedEnum" : javaName.replace("__etools_", "__etools_" + Integer.toString(currClassIndex + 1) + "_");
            if (currClassIndex == 0) {
                this.toClassEncap1(project, javaCode, currClassName, prevClassName, CLASS_ENCAP_NOF_ENUMS_PER_CLASS * i2, CLASS_ENCAP_NOF_ENUMS_PER_CLASS, uniqueEnums, value);
            } else {
                this.toClassEncap2(project, javaCode, currClassName, prevClassName, CLASS_ENCAP_NOF_ENUMS_PER_CLASS * i2, CLASS_ENCAP_NOF_ENUMS_PER_CLASS, uniqueEnums, value);
            }
            ++i2;
        }
        EDTFileUtils.getInstance().dumpAsComputedDebug(project.getProject(), this.javaName(), javaCode.toString());
        return new ClassEncap(javaCode.toString(), references, false);
    }

    public void toClassEncap1(RfProject project, StringBuilder javaCode, String currClassName, String prevClassName, int offset, int length, List<RfEnum> enums, int[] value) {
        String javaName = this.javaName();
        StringBuilder tempCode = new StringBuilder("package ").append("ro.amiq.edt.base.debug.ascomputed").append(";\n").append("import ro.amiq.edt.base.model.reflection.*;\n").append("import ro.amiq.etools.eparser.*;\n").append("import ro.amiq.edt.base.model.reflection.ascomputed.base.*;\n").append("import java.io.Serializable;\n").append("import java.util.*;\n\n").append("public class ").append(currClassName).append(" extends ").append(prevClassName).append(" implements Serializable {\n\n").append("    private static final long serialVersionUID = 1L;\n\n").append("    private static ").append(javaName).append(" fInstance;\n\n").append("    public ").append(currClassName).append("() {\n").append("    }\n\n").append("    public ").append(currClassName).append("(String name, int value) {\n").append("        fName = name;\n").append("        fValue = value;\n").append("        getEnumList().add(this);\n").append("    }\n\n");
        length = Math.min(enums.size(), offset + length);
        int i = offset;
        while (i < length) {
            RfEnum enumElement = enums.get(i);
            value[0] = this.value(enumElement, value[0]);
            tempCode.append("    public static ").append(javaName).append(" ").append(enumElement.javaBaseName()).append(" = new ").append(javaName).append("(\"").append(enumElement.getName()).append("\", ").append(value[0]).append(");\n");
            value[0] = value[0] + 1;
            ++i;
        }
        tempCode.append("\n").append("    protected static List<").append(javaName).append("> fEnumList;\n\n").append("    public List<").append(javaName).append("> getEnumList() {\n").append("        if (fEnumList == null) {\n").append("            fEnumList = new ArrayList<").append(javaName).append(">();\n").append("        }\n").append("        return fEnumList;\n").append("    }\n\n").append("    public static ").append(javaName).append(" getDefaultValue() {\n").append("        if (fEnumList != null && !fEnumList.isEmpty()) {\n").append("            return fEnumList.get(0);\n").append("        }\n").append("        if (fInstance == null) {\n").append("            fInstance = new ").append(javaName).append("();\n").append("        }\n").append("        return fInstance;\n").append("    }\n\n");
        if (this.isJavaNotEnum()) {
            int maxNofBits = this.getMaxNofBits();
            int nofBits = this.getNofBits() == -1 ? maxNofBits : this.getNofBits();
            boolean signed = this.isSigned();
            int min = signed ? -((int)Math.pow(2.0, (double)nofBits - 1.0)) : 0;
            int max = (int)(Math.pow(2.0, (double)nofBits - (signed ? 1.0 : 0.0)) - 1.0);
            int minFull = signed ? -((int)Math.pow(2.0, (double)maxNofBits - 1.0)) : 0;
            int maxFull = (int)(Math.pow(2.0, (double)maxNofBits - (signed ? 1.0 : 0.0)) - 1.0);
            tempCode.append("    public List<ERange> getValueRanges(boolean full) {\n").append("    \tList<ERange> ranges = new ArrayList<ERange>();\n").append("    \ttry {\n").append("    \t\tif (full) {\n").append("    \t\t\tranges.add(new ERange(new _Int(").append(minFull).append("), new _Int(").append(maxFull).append(")));\n").append("    \t\t} else {\n").append("    \t\t\tranges.add(new ERange(new _Int(").append(min).append("), new _Int(").append(max).append(")));\n").append("    \t\t}\n").append("    \t} catch (Exception e) {\n").append("    \t}\n").append("    \treturn ranges;\n").append("    }\n\n").append("    public Set<String> getNonGeneratableSet() {\n").append("        return null;\n").append("    }\n\n");
        } else {
            tempCode.append("    public List<ERange> getValueRanges(boolean full) {\n").append("    \tList<ERange> ranges = new ArrayList<ERange>();\n").append("    \ttry {\n").append("    \t\tint min = 0;\n").append("    \t\tint prevValue = 0;\n").append("    \t\tint currValue = 0;\n").append("    \t\tif (fEnumList == null || full) {\n").append("    \t\t\tranges.add(new ERange(new _Int(0), new _Int(AsComputedBase.MAX_UINT)));\n").append("    \t\t} else {\n").append("    \t\t\tfor (int i = 0; i < fEnumList.size(); i++) {\n").append("    \t\t\t\tcurrValue = fEnumList.get(i).fValue;\n").append("    \t\t\t\tif (i == 0) {\n").append("    \t\t\t\t\tmin = currValue;\n").append("    \t\t\t\t} else if (currValue != prevValue + 1) {\n").append("    \t\t\t\t\tranges.add(new ERange(new _Int(min), new _Int(prevValue)));\n").append("    \t\t\t\t\tmin = currValue;\n").append("    \t\t\t\t}\n").append("    \t\t\t\tprevValue = currValue;\n").append("    \t\t\t}\n\n").append("    \t\t\tif (currValue != min)\n").append("    \t\t\t\tranges.add(new ERange(new _Int(min), new _Int(currValue)));\n").append("    \t\t}\n").append("    \t} catch (Exception e) {\n").append("    \t}\n").append("    \treturn ranges;\n").append("    }\n\n").append("    public Set<String> fNonGeneratableSet = ").append(this.javaNonGeneratableEnums(project)).append(";\n\n").append("    public Set<String> getNonGeneratableSet() {\n").append("        return fNonGeneratableSet;\n").append("    }\n\n");
        }
        tempCode.append("    public Object clone_deep() throws Exception {\n").append("        ").append(javaName).append(" result = this;\n").append("        return result;\n").append("    }\n\n").append("    public Object clone_copy() throws Exception {\n").append("        ").append(javaName).append(" result = this;\n").append("        return result;\n").append("    }\n\n");
        tempCode.append("}\n\n");
        javaCode.insert(0, tempCode.toString());
    }

    private int value(RfEnum enumElement, int defaultValue) {
        try {
            if (enumElement.fValue == null) {
                return defaultValue;
            }
            _Int value = AsComputedBase.as_a(new __etools_string(enumElement.fValue), _Int.class);
            return value.intValueExact();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return defaultValue;
        }
    }

    public void toClassEncap2(RfProject project, StringBuilder javaCode, String currClassName, String prevClassName, int offset, int length, List<RfEnum> enums, int[] value) {
        String javaName = this.javaName();
        javaCode.append("abstract class ").append(currClassName).append(" extends ").append(prevClassName).append(" {\n\n");
        length = Math.min(enums.size(), offset + length);
        int i = offset;
        while (i < length) {
            RfEnum enumElement = enums.get(i);
            value[0] = this.value(enumElement, value[0]);
            javaCode.append("    public static ").append(javaName).append(" ").append(enumElement.javaBaseName()).append(" = new ").append(javaName).append("(\"").append(enumElement.getName()).append("\", ").append(value[0]).append(");\n");
            value[0] = value[0] + 1;
            ++i;
        }
        javaCode.append("\n}\n\n");
    }

    public EList<RfScalarType> get_items() {
        EList<RfScalarType> result = new EList<RfScalarType>();
        List<RfEnum> enums = this.getEnumsWithPrefix(2, "");
        if (enums != null && !enums.isEmpty()) {
            result.addAll(enums);
        }
        return result;
    }

    public RfScalarType get_item_by_value(_Int value) {
        List<RfEnum> enums = this.getEnumsWithPrefix(2, "");
        if (enums == null || enums.isEmpty()) {
            return null;
        }
        _Int enumValue = _Int.ZERO;
        int i = 0;
        while (i < enums.size()) {
            RfEnum enumItem = enums.get(i);
            if (enumItem.fValue != null) {
                enumValue = new _Int(enumItem.fValue, 10);
            }
            if (enumValue.equals(value)) {
                return enumItem;
            }
            value = value.add(_Int.ONE);
            ++i;
        }
        return null;
    }

    public RfScalarType get_item_by_name(__etools_string name) {
        if (name == null || name.to_string() == null) {
            return null;
        }
        RfEnum enumItem = this.getEnumWithPrefix(1, name.toString());
        return enumItem;
    }

    @Override
    public String javaName() {
        AsComputedProcessor asComputedProcessor;
        String name = this.getName();
        if (INTEGRAL_TYPES_AS_JAVA.contains(name)) {
            return "_Int";
        }
        if ("real".equals(name)) {
            return "Double";
        }
        if ("bool".equals(name)) {
            return "Boolean";
        }
        if (SemanticUtils.isSetName(this.getRfProject(), name)) {
            return "ESet";
        }
        String typeName = super.javaName();
        RfProject rfProject = this.getRfProject();
        if (rfProject != null && (asComputedProcessor = rfProject.getAsComputedProcessor()) != null) {
            typeName = asComputedProcessor.registred(typeName);
        }
        return typeName;
    }

    public boolean isAnonymous() {
        String name = this.getName();
        return name.startsWith(ANONYMOUS_ENUM_PREFIX);
    }

    @Override
    protected void removeLayer(RfDefElement layer) {
        super.removeLayer(layer);
    }

    public RfScalarType getParentEnumType() {
        if (this.fAssocType != null && this.fAssocType.isEnumType() && !this.fAssocType.isIntegerAssignmentCompatible() && (this.fAssocType instanceof RfPredefinedScalar || !this.fAssocType.hasNoDefs(false))) {
            return this.fAssocType.getParentEnumType();
        }
        return this;
    }

    public ESet get_set_of_values() {
        if (!this.isEnumType()) {
            return null;
        }
        ESet result = new ESet(new ERange[0]);
        try {
            ArrayList<ERange> ranges = new ArrayList<ERange>();
            List<Range> visibleRanges = this.getVisibleRanges();
            if (visibleRanges != null) {
                for (Range visibleRange : visibleRanges) {
                    RfScalarType item = this.get_item_by_name(new __etools_string(visibleRange.left));
                    if (item == null || !item.isEnumType()) continue;
                    ranges.add(new ERange(item.get_value()));
                }
            } else {
                EList<RfScalarType> items = this.get_items();
                for (RfScalarType item : items) {
                    ranges.add(new ERange(item.get_value()));
                }
            }
            result = new ESet(ranges.toArray(new ERange[ranges.size()]));
        }
        catch (Exception exception) {}
        return result;
    }
}

