/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedScalar;
import ro.amiq.edt.base.model.reflection.semantic.RfDummyField;
import ro.amiq.etools.eparser.ReparseElement;

public class RfScalarTypeLayer
extends RfDefElement {
    protected Map<String, RfEnum> fEnumItems;
    private String fQualifiedPackageName;

    public RfScalarTypeLayer(String packageName, int kind, LineInfo startLine, LineInfo endLine, CommentBlock comment, RfModule module, ReparseElement[] reparseStack) {
        super(module, module, kind, startLine, endLine, comment, reparseStack);
        this.fQualifiedPackageName = packageName;
    }

    public void addEnumItems(RfModule module, LineInfo line, List<RfEnum> enums, RfType assocType) {
        if (enums == null || enums.isEmpty()) {
            return;
        }
        this.fEnumItems = new LinkedHashMap<String, RfEnum>();
        IRfSingleLangProject project = module.getRfProject();
        for (RfEnum enumElement : enums) {
            RfEnum existingEnum = this.fEnumItems.get(enumElement.getName());
            if (existingEnum != null) {
                RfDefElement declaration = existingEnum.getDeclaration();
                if (declaration != null && declaration.compareTo(this) <= 0 && project.importedBySameTest(this, declaration)) {
                    project.addSemanticError2(1, "DUPLICATE_ENUM: Enum name ''{0}'' was previously defined\n    at line {1,number,#######} in {2}", enumElement.getStartOffset(), enumElement.getEndOffset(), null, line.line, module.getParserPath(), enumElement.getName(), declaration.getStartLine(), declaration.getParserPath());
                } else {
                    this.fEnumItems.put(enumElement.getName(), enumElement);
                }
            } else {
                this.fEnumItems.put(enumElement.getName(), enumElement);
            }
            enumElement.setAssociatedTypeFrom((RfProject)project, new RfDummyField((RfProject)project, assocType));
            enumElement.addLayer(this);
        }
    }

    protected void performDuplicateEnumCheck(RfProject project) {
        if (this.fEnumItems == null || this.fEnumItems.isEmpty()) {
            return;
        }
        RfScalarType assocType = (RfScalarType)this.getNamedElement();
        LinkedHashMap<String, RfEnum> allEnums = new LinkedHashMap<String, RfEnum>();
        List<RfDefElement> layers = assocType.getAllEnumTypeLayers(project.getLastChangeTimestamp(), this.getModuleIndex());
        for (RfDefElement layer : layers) {
            if (layer == this) break;
            Collection<RfEnum> enums = ((RfScalarTypeLayer)layer).getEnums();
            if (enums == null) continue;
            for (RfEnum enumItem : enums) {
                if (enumItem.getName().length() == 0 || allEnums.containsKey(enumItem.getName())) continue;
                allEnums.put(enumItem.getName(), enumItem);
            }
        }
        Map<String, RfEnum> allGeneratableEnums = assocType.internalGetGeneratableEnums(project, null, this);
        for (RfEnum enumElement : this.fEnumItems.values()) {
            RfDefElement declaration;
            String name = enumElement.getName();
            RfEnum existingEnum = (RfEnum)allEnums.get(name);
            boolean isDuplicate = allGeneratableEnums.containsKey(name);
            if (existingEnum == null || !isDuplicate || (declaration = existingEnum.getDeclaration()) == null || declaration.compareTo(this) > 0 || !project.importedBySameTest(this, declaration)) continue;
            project.addSemanticError2(1, "DUPLICATE_ENUM: Enum name ''{0}'' was previously defined\n    at line {1,number,#######} in {2}", enumElement.getStartOffset(), enumElement.getEndOffset(), null, this.getStartLine(), this.getParserPath(), name, declaration.getStartLine(), declaration.getParserPath());
        }
    }

    @Override
    public String getQualifiedPackageName() {
        return this.fQualifiedPackageName;
    }

    @Override
    public void deepClean() {
        if (this.fEnumItems != null && !this.fEnumItems.isEmpty()) {
            for (RfEnum enumElement : this.fEnumItems.values()) {
                enumElement.deepClean();
            }
        }
        super.deepClean();
    }

    public String getInfo() {
        RfNamedElement element = this.getNamedElement();
        Collection<RfEnum> enums = this.getEnums();
        if (enums == null && element instanceof RfScalarType) {
            return ((RfScalarType)element).getAssociatedTypeName();
        }
        if (enums == null) {
            return "";
        }
        StringBuilder result = new StringBuilder("[");
        for (RfEnum enumItem : enums) {
            if (result.length() > 1) {
                result.append(", ");
            }
            result.append(enumItem.getName());
        }
        result.append("]");
        return result.toString();
    }

    public IRfScope getScope(int line) {
        return null;
    }

    @Override
    public boolean isEnumType() {
        return this.fEnumItems != null;
    }

    public Collection<RfEnum> getEnums() {
        if (this.fEnumItems == null) {
            return null;
        }
        return this.fEnumItems.values();
    }

    public RfEnum getEnum(String name) {
        if (this.fEnumItems == null) {
            return null;
        }
        return this.fEnumItems.get(name);
    }

    @Override
    public boolean hasQualifiedName() {
        return this.fQualifiedPackageName != null;
    }

    @Override
    public boolean isPredefined() {
        return this.getNamedElement() instanceof RfPredefinedScalar && this.getLayerModule().isInternalModule();
    }
}

