/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfScalarTypeLayer;
import ro.amiq.edt.base.model.reflection.RfStringType;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.predefined.RfGlobal;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedEvent;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedModule;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedScalar;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedStruct;
import ro.amiq.edt.base.model.reflection.predefined.rf.RfRfManager;
import ro.amiq.edt.base.model.reflection.semantic.RfDummyField;

public class RfSpecman {
    private RfGlobal fGlobal;
    private RfType fUntypedType;
    private RfProject fProject;
    public RfModule fPredefinedModule;
    private RfStruct fPseudoStruct;
    private RfPredefinedEvent fSimEvent;
    private RfPredefinedScalar fUndefType;
    private RfPredefinedScalar fHdlLiteralType;
    private RfPredefinedStruct fNullType;
    private RfPredefinedScalar fVoidType;
    private RfType fIntListType;
    private static List<String> fTLMPorts = Arrays.asList("tlm_analysis", "tlm_blocking_put", "tlm_blocking_get", "tlm_blocking_peek", "tlm_blocking_get_peek", "tlm_nonblocking_put", "tlm_nonblocking_get", "tlm_nonblocking_peek", "tlm_nonblocking_get_peek", "tlm_put", "tlm_get", "tlm_peek", "tlm_get_peek", "tlm_blocking_master", "tlm_blocking_slave", "tlm_blocking_transport", "tlm_nonblocking_master", "tlm_nonblocking_slave", "tlm_nonblocking_transport", "tlm_master", "tlm_slave", "tlm_transport");
    private static final CommentBlock predefinedComment = new CommentBlock("[predefined]", null, false);
    public static final String GLOBAL_COMMENT = "The predefined struct global is the root of all e structs. All predefined structs and most predefined methods are part of the global struct. It is highly recommended that you do not extend the global struct.";
    public static final String IMPLICIT_VARIABLE_ME_COMMENT = "The implicit variable me refers to the current struct and can be used anywhere in the struct.";
    public static final String IMPLICIT_VARIABLE_RESULT_COMMENT = "The result variable returns a value of the method's return type. If no return action is encountered, result is returned by default. The default for the result variable is the default value for the method's return type.";
    public static final String RF_MANAGER_STRUCT_COMMENT = "The starting point in every query into the type information is a set of services that are not related to any specific kind of meta-objects. They are scoped together as methods of a singleton class named rf_manager, the instance of which is under global.";

    public RfSpecman(RfProject project) {
        this.init(project);
    }

    public RfType getSpecman(String typeName) {
        if (this.fProject == null) {
            return null;
        }
        return this.fProject.getPackage("main").getType(typeName);
    }

    public static boolean isTLMPort(String name) {
        return fTLMPorts.contains(name);
    }

    private void init(RfProject project) {
        try {
            this.fProject = project;
            RfStruct pkgMain = RfStruct.createPackage(project, "main");
            project.addPackage(pkgMain);
            this.fPredefinedModule = new RfPredefinedModule(project.getPluginConfig());
            RfPredefinedScalar bit_t = new RfPredefinedScalar(project, "bit", 1, "Bit type.");
            pkgMain.addType(bit_t, false);
            RfPredefinedScalar bool_t = new RfPredefinedScalar(project, "bool", 1, "Boolean type.");
            pkgMain.addType(bool_t, false);
            ArrayList<RfEnum> enums = new ArrayList<RfEnum>(2);
            enums.add(new RfEnum(project, "TRUE", null));
            enums.add(new RfEnum(project, "FALSE", null));
            LineInfo line = new LineInfo(0, 0, -1);
            RfScalarTypeLayer bool_t_l = new RfScalarTypeLayer("main", 0, line, line, predefinedComment, this.fPredefinedModule, null);
            bool_t_l.addEnumItems(this.fPredefinedModule, line, enums, bool_t);
            bool_t.addLayer(bool_t_l);
            RfPredefinedScalar byte_t = new RfPredefinedScalar(project, "byte", 8, "Byte type.");
            pkgMain.addType(byte_t, false);
            enums = new ArrayList(9);
            enums.add(new RfEnum(project, "Strength_NONE", null));
            enums.add(new RfEnum(project, "Strength_HiZ", null));
            enums.add(new RfEnum(project, "Strength_SmallCharge", null));
            enums.add(new RfEnum(project, "Strength_MediumCharge", null));
            enums.add(new RfEnum(project, "Strength_LargeCharge", null));
            enums.add(new RfEnum(project, "Strength_WeakDrive", null));
            enums.add(new RfEnum(project, "Strength_PullDrive", null));
            enums.add(new RfEnum(project, "Strength_StrongDrive", null));
            enums.add(new RfEnum(project, "Strength_SupplyDrive", null));
            RfScalarTypeLayer byte_t_l = new RfScalarTypeLayer("main", 0, line, line, predefinedComment, this.fPredefinedModule, null);
            byte_t_l.addEnumItems(this.fPredefinedModule, line, enums, byte_t);
            byte_t.addLayer(byte_t_l);
            RfPredefinedScalar c_float = new RfPredefinedScalar(project, "c_float", 64, "C float type.");
            pkgMain.addType(c_float, false);
            RfPredefinedScalar external_pointer_t = new RfPredefinedScalar(project, "external_pointer", 64, "The external_pointer type is used to hold a pointer into an external (non-Specman) entity, such as a C struct. Unlike pointers to structs in e, external pointers are not changed during garbage collection.");
            pkgMain.addType(external_pointer_t, false);
            RfPredefinedScalar index_t = new RfPredefinedScalar(project, "index", 32, "Index type.");
            pkgMain.addType(index_t, false);
            RfPredefinedScalar C_file_t = new RfPredefinedScalar(project, "C_file", 32, "@non_standard C file.");
            pkgMain.addType(C_file_t, false);
            RfPredefinedScalar int_t = new RfPredefinedScalar(project, "int", 32, "Integer type (32 bit).");
            pkgMain.addType(int_t, false);
            enums = new ArrayList(4);
            enums.add(new RfEnum(project, "MIN_LONGINT", null));
            enums.add(new RfEnum(project, "MIN_INT", null));
            enums.add(new RfEnum(project, "MAX_INT", null));
            enums.add(new RfEnum(project, "MAX_LONGINT", null));
            RfScalarTypeLayer int_t_l = new RfScalarTypeLayer("main", 0, line, line, predefinedComment, this.fPredefinedModule, null);
            int_t_l.addEnumItems(this.fPredefinedModule, line, enums, int_t);
            int_t.addLayer(int_t_l);
            RfPredefinedScalar longint_t = new RfPredefinedScalar(project, "longint", 64, "Integer type (64-bit).");
            pkgMain.addType(longint_t, false);
            enums = new ArrayList(4);
            enums.add(new RfEnum(project, "MIN_LONGINT", null));
            enums.add(new RfEnum(project, "MIN_INT", null));
            enums.add(new RfEnum(project, "MAX_INT", null));
            enums.add(new RfEnum(project, "MAX_LONGINT", null));
            RfScalarTypeLayer longint_t_l = new RfScalarTypeLayer("main", 0, line, line, predefinedComment, this.fPredefinedModule, null);
            longint_t_l.addEnumItems(this.fPredefinedModule, line, enums, longint_t);
            longint_t.addLayer(longint_t_l);
            RfPredefinedScalar nibble_t = new RfPredefinedScalar(project, "nibble", 4, "Nibble type. An unsigned integer in the range 0-15.");
            pkgMain.addType(nibble_t, false);
            RfPredefinedScalar real_t = new RfPredefinedScalar(project, "real", 64, "Real type.");
            pkgMain.addType(real_t, false);
            RfPredefinedScalar source_ref = new RfPredefinedScalar(project, "source_ref", 32, "Source reference type.");
            source_ref.setAssociatedTypeFrom(this.fProject, new RfDummyField(this.fProject, int_t));
            pkgMain.addType(source_ref, false);
            RfStringType string_t = new RfStringType(project, "string");
            pkgMain.addType(string_t, false);
            RfPredefinedScalar thread_handle_t = new RfPredefinedScalar(project, "thread_handle", 32, "Thread handle type.");
            pkgMain.addType(thread_handle_t, false);
            RfPredefinedScalar time_t = new RfPredefinedScalar(project, "time", 64, "Time type.");
            pkgMain.addType(time_t, false);
            RfPredefinedScalar uint_t = new RfPredefinedScalar(project, "uint", 32, "Unsigned integer type (32-bit).");
            pkgMain.addType(uint_t, false);
            enums = new ArrayList(2);
            enums.add(new RfEnum(project, "MAX_UINT", null));
            enums.add(new RfEnum(project, "MAX_LONGUINT", null));
            RfScalarTypeLayer uint_t_l = new RfScalarTypeLayer("main", 0, line, line, predefinedComment, this.fPredefinedModule, null);
            uint_t_l.addEnumItems(this.fPredefinedModule, line, enums, uint_t);
            uint_t.addLayer(uint_t_l);
            RfPredefinedScalar longuint_t = new RfPredefinedScalar(project, "longuint", 64, "Unsigned integer type (64-bit).");
            pkgMain.addType(longuint_t, false);
            enums = new ArrayList(2);
            enums.add(new RfEnum(project, "MAX_UINT", null));
            enums.add(new RfEnum(project, "MAX_LONGUINT", null));
            RfScalarTypeLayer longuint_t_l = new RfScalarTypeLayer("main", 0, line, line, predefinedComment, this.fPredefinedModule, null);
            longuint_t_l.addEnumItems(this.fPredefinedModule, line, enums, longuint_t);
            longuint_t.addLayer(longuint_t_l);
            RfPredefinedScalar untyped_t = new RfPredefinedScalar(project, "untyped", 32, "This is a type placeholder for untyped values which can be used when runtime values of different types need to be manipulated in a generic way. For example, when objects are manipulated with the reflection API, their types are typically unknown at compile-time; thus, untyped expressions need to be used. Values of any type may be assigned to variables of the 'untyped' pseudo type using the unsafe() operator. Similarly, 'untyped' expressions may be used in typed contexts by using unsafe().<br><i>NOTE: </i>Untyped variables are left unchanged during garbage collection, which allows struct references to be corrupted."){

                @Override
                public String javaName() {
                    return "Object";
                }
            };
            pkgMain.addType(untyped_t, false);
            this.fUntypedType = untyped_t;
            this.fGlobal = new RfGlobal(project);
            pkgMain.addType(this.fGlobal, false);
            this.fPseudoStruct = new RfPredefinedStruct(project, "pseudo_struct", "main", false, "", null);
            this.fSimEvent = new RfPredefinedEvent(project, this.fPseudoStruct, "sim", "A special notation, @sim, is used in place of a sampling event for rise, fall, or change of HDL or SystemC objects. The @sim notation does not signify a Specman event, but is used only to cause a callback to Specman any time there is a change in the value of the HDL or SystemC object to which it is attached");
            this.initReflectionAPI(project, pkgMain);
            this.fUndefType = new RfPredefinedScalar(project, "UNDEF", 0, "");
            this.fHdlLiteralType = new RfPredefinedScalar(project, "HDL_LITERAL", 0, "");
            this.fNullType = new RfPredefinedStruct(project, "NULL", "main", false, "", null);
            this.fVoidType = new RfPredefinedScalar(project, "void", 0, "");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void initReflectionAPI(RfProject rfProject, RfStruct rfPackage) {
        RfRfManager rf_manager = new RfRfManager(rfProject);
        rfPackage.addType(rf_manager, false);
    }

    public void clear(RfProject project) {
        this.init(project);
    }

    public RfStruct getGlobalStruct() {
        return this.fGlobal;
    }

    public RfType getUntypedType() {
        return this.fUntypedType;
    }

    public RfPredefinedStruct getNullType() {
        return this.fNullType;
    }

    public RfPredefinedScalar getHdlLiteralType() {
        return this.fHdlLiteralType;
    }

    public RfPredefinedScalar getUndefType() {
        return this.fUndefType;
    }

    public RfPredefinedScalar getVoidType() {
        return this.fVoidType;
    }

    public RfModule getPredefinedModule() {
        return this.fPredefinedModule;
    }

    public RfType getIntListType(RfProject project) {
        if (this.fIntListType == null) {
            this.fIntListType = RfListType.listFromType(project, this.getSpecman("int"), null, null, 1);
        }
        return this.fIntListType;
    }

    public RfEvent getSimEvent() {
        return this.fSimEvent;
    }

    public RfStruct getPseudoStruct(RfProject project) {
        return this.fPseudoStruct;
    }
}

