/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.edt.base.model.IEProject;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.IRfAssociatedType;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.IRfTemplateParam;
import ro.amiq.edt.base.model.reflection.RfActionBlockLayer;
import ro.amiq.edt.base.model.reflection.RfArg;
import ro.amiq.edt.base.model.reflection.RfBindMethodCall;
import ro.amiq.edt.base.model.reflection.RfConstraint;
import ro.amiq.edt.base.model.reflection.RfConstraintLayer;
import ro.amiq.edt.base.model.reflection.RfCoverLayer;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfEventLayer;
import ro.amiq.edt.base.model.reflection.RfExpect;
import ro.amiq.edt.base.model.reflection.RfExpectLayer;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfFieldLayer;
import ro.amiq.edt.base.model.reflection.RfFieldPropConstraint;
import ro.amiq.edt.base.model.reflection.RfFieldTCLayer;
import ro.amiq.edt.base.model.reflection.RfFieldTypeConstraint;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfMeImplicitVariable;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfOnEventLayer;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfPropConstraint;
import ro.amiq.edt.base.model.reflection.RfSDLInlineSM;
import ro.amiq.edt.base.model.reflection.RfSDLInlineSMLayer;
import ro.amiq.edt.base.model.reflection.RfSDLRoleSM;
import ro.amiq.edt.base.model.reflection.RfSDLRoleSMLayer;
import ro.amiq.edt.base.model.reflection.RfSDLToolEditorAvoidCallLayer;
import ro.amiq.edt.base.model.reflection.RfSDLToolEditorPrioritizeCallLayer;
import ro.amiq.edt.base.model.reflection.RfSLNTokenField;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfTemplateParam;
import ro.amiq.edt.base.model.reflection.RfTemplateStruct;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.TypesWalker;
import ro.amiq.edt.base.model.reflection.WrapperMethod;
import ro.amiq.edt.base.model.reflection.WrapperType;
import ro.amiq.edt.base.model.reflection.ascomputed.ClassEncap;
import ro.amiq.edt.base.model.reflection.ascomputed.RfWhenSubtype;
import ro.amiq.edt.base.model.reflection.ascomputed.TransientField;
import ro.amiq.edt.base.model.reflection.ascomputed.base.EList;
import ro.amiq.edt.base.model.reflection.ascomputed.base.IRfType;
import ro.amiq.edt.base.model.reflection.ascomputed.base.__etools_string;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedEvent;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedField;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedMethod;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedScalar;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedStruct;
import ro.amiq.edt.base.model.reflection.predefined.RfPseudoMethod;
import ro.amiq.edt.base.model.reflection.semantic.IllegalAccessError;
import ro.amiq.edt.base.model.reflection.semantic.RfDummyField;
import ro.amiq.edt.base.model.reflection.semantic.RfStructQualifier;
import ro.amiq.edt.base.model.reflection.semantic.SemanticUtils;
import ro.amiq.edt.base.model.reflection.semantic.SemanticWalker;
import ro.amiq.edt.base.model.reflection.util.NullProtectedList;
import ro.amiq.edt.base.utils.EDTFileUtils;
import ro.amiq.etools.eparser.ReparseElement;

public class RfStruct
extends RfType {
    public static final String NULL_LIKE_PARENT = "__dvt_null_parent";
    public static final int METHOD_MEMBER = 1;
    public static final int FIELD_MEMBER = 2;
    public static final int FIELD_TC_MEMBER = 3;
    public static final int FIELD_PC_MEMBER = 4;
    public static final int EVENT_MEMBER = 5;
    public static final int EXPECT_MEMBER = 6;
    public static final int CONSTRAINT_MEMBER = 7;
    public static final int SDL_ROLE_MEMBER = 8;
    public static final int SDL_INLINE_MEMBER = 9;
    public static final int UNKNOWN_TYPE = -1;
    public static final int STRUCT_TYPE = 1;
    public static final int SCALAR_TYPE = 2;
    public static final int METHOD_TYPE = 4;
    public static final int TEMPLATE_TYPE = 8;
    public static final int INTERFACE_TYPE = 16;
    public static final int ANNOTATION_TYPE = 32;
    public static final int ENUM_TYPE = 12;
    public static final int TEMPLATE_PARAMETER = 13;
    public static final int TEMPLATE_INSTANCE = 14;
    private Map<String, RfType> fTypes = new LinkedHashMap<String, RfType>();
    private Set<ParserPath> fParserPaths = new HashSet<ParserPath>();
    private boolean fIsUnit;
    private boolean fIsPotentialUnit;
    private String fSequenceItemName;
    private String fSequenceDriverName;
    private String fSequenceKindName;
    private Map<String, ListContainer<RfStructMember>> fMethods;
    private Map<String, ListContainer<RfStructMember>> fFields;
    private Map<String, ListContainer<RfStructMember>> fFieldTCs;
    private Map<String, ListContainer<RfStructMember>> fFieldPCs;
    private Map<String, ListContainer<RfStructMember>> fEvents;
    private Map<String, ListContainer<RfStructMember>> fExpects;
    private Map<String, ListContainer<RfStructMember>> fConstraints;
    private transient RfType fParentStruct;
    private transient Map<RfDefElement, List<RfType>> fParentInterfaces;
    private transient List<RfStruct> fStructChildren;
    private transient RfMeImplicitVariable fMeVariable;
    private transient Determinant fDeterminant;
    private transient Determinant fTransientDeterminant;
    private KIND fKind;
    private boolean fIsPredefined;
    private RfStruct fSLNEnclosingComponent;
    private RfActionBlockLayer fSLNCompoundActionBlockLayer;
    private RfStruct fSDLEnclosingAgent;

    public RfStruct(RfProject project, String structName, boolean addPredefinedMethods) {
        super(project, structName);
        if (this instanceof RfListType) {
            this.setDeterminant(new Determinant(structName));
        }
        if (addPredefinedMethods && !(this instanceof RfListType)) {
            this.initPredefinedMethods(project, structName);
        }
    }

    public static RfStruct createPackage(RfProject project, String packageName) {
        RfStruct packg = new RfStruct(project, packageName, false);
        packg.fKind = KIND.PACKAGE;
        return packg;
    }

    @Override
    public boolean isPredefined() {
        return this.fIsPredefined;
    }

    @Override
    public void deepClean() {
        try {
            if (this.fParentInterfaces != null) {
                this.fParentInterfaces.clear();
            }
            this.fParentInterfaces = null;
            this.fParentStruct = null;
            if (this.fStructChildren != null) {
                this.fStructChildren.clear();
            }
            this.fStructChildren = null;
            this.fMeVariable = null;
            this.fDeterminant = null;
            this.fTransientDeterminant = null;
            this.deepCleanMembers(this.fMethods);
            this.fMethods = null;
            this.deepCleanMembers(this.fFields);
            this.fFields = null;
            this.deepCleanMembers(this.fFieldPCs);
            this.fFieldPCs = null;
            this.deepCleanMembers(this.fFieldTCs);
            this.fFieldTCs = null;
            this.deepCleanMembers(this.fEvents);
            this.fEvents = null;
            this.deepCleanMembers(this.fExpects);
            this.fExpects = null;
            this.deepCleanMembers(this.fConstraints);
            this.fConstraints = null;
            if (this.fParserPaths != null) {
                this.fParserPaths.clear();
            }
            if (this.fTypes != null && !this.fTypes.isEmpty()) {
                for (RfType type : this.fTypes.values()) {
                    type.deepClean();
                }
                this.fTypes.clear();
            }
            this.fSLNEnclosingComponent = null;
            this.fSLNCompoundActionBlockLayer = null;
            this.fSDLEnclosingAgent = null;
            super.deepClean();
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    private void deepCleanMembers(Map<String, ListContainer<RfStructMember>> membersMap) {
        if (membersMap != null && !membersMap.isEmpty()) {
            for (ListContainer<RfStructMember> members : membersMap.values()) {
                if (members == null || members.isEmpty()) continue;
                for (RfStructMember member : members) {
                    member.deepClean();
                }
            }
        }
    }

    protected void initPredefinedMethods(RfProject project, String structName) {
        Determinant determinant = this.getDeterminant();
        RfPredefinedMethod method = new RfPredefinedMethod(project, this, "to_string", "string", "", null, "Returns the string representation.");
        RfType stringType = project.getType("main", true, 2, "string", -1);
        method.setAssociatedType(stringType);
        method.setAssociatedTypeDeterminant(determinant);
        this.addMethod(method);
        method = new RfPredefinedMethod(project, this, "copy", structName, "", null, "Returns a shallow, non-recursive copy of the expression. This means that if the expression is a list or a struct that contains other lists or structs, the second-level items are not duplicated. Instead, they are copied by reference.");
        method.setAssociatedType(this);
        method.setAssociatedTypeDeterminant(determinant);
        this.addMethod(method);
    }

    public boolean isTemplateStruct() {
        return false;
    }

    public IRfTemplateParam getParameter(String name) {
        return null;
    }

    public List<IRfAssociatedType> getTemplateInstanceParameters() {
        return null;
    }

    public String getParametersInfo(boolean replace) {
        return "";
    }

    public void setParamsValueOverride() {
    }

    public void setParameterValue(RfProject project, RfModule module, String typeParamName, IRfAssociatedType defaultParamValue) {
    }

    @Override
    protected void setDefinitionData(RfModule module, String packageName, boolean isUnit, boolean isPotentialUnit, int accessModifier) {
        try {
            this.fIsUnit = isUnit;
            this.fIsPotentialUnit = !isUnit && isPotentialUnit;
            this.setPackageName(packageName);
            this.setAccessModifier(accessModifier);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected void setSequenceAdditionalInfo(String sequenceItemName, String sequenceDriverName, String sequenceKindName) {
        this.fSequenceItemName = sequenceItemName;
        this.fSequenceDriverName = sequenceDriverName;
        this.fSequenceKindName = sequenceKindName;
    }

    public List<RfStructLayer> getBaseTypeLayers() {
        List<RfDefElement> layers = this.getLayers();
        ArrayList<RfStructLayer> result = new ArrayList<RfStructLayer>();
        if (layers == null || layers.isEmpty()) {
            return result;
        }
        for (RfDefElement layer : layers) {
            Determinant determinant;
            if (!(layer instanceof RfStructLayer) || (determinant = ((RfStructLayer)layer).getDeterminant()).toArray().length != 1 || determinant.hasParameters()) continue;
            result.add((RfStructLayer)layer);
        }
        return result;
    }

    public List<RfStructLayer> getSubTypeLayers() {
        List<RfDefElement> layers = this.getLayers();
        ArrayList<RfStructLayer> result = new ArrayList<RfStructLayer>();
        if (layers == null || layers.isEmpty()) {
            return result;
        }
        HashSet<Determinant> visited = new HashSet<Determinant>();
        for (RfDefElement layer : layers) {
            Determinant determinant;
            if (!(layer instanceof RfStructLayer) || (determinant = ((RfStructLayer)layer).getDeterminant()).toArray().length == 1 && !determinant.hasParameters() || visited.contains(determinant)) continue;
            visited.add(determinant);
            result.add((RfStructLayer)layer);
        }
        return result;
    }

    public List<RfStructLayer> getSubTypeLayers(Determinant determinant) {
        List<RfStructLayer> candidates = this.getSubTypeLayers();
        if (candidates == null) {
            return null;
        }
        ArrayList<RfStructLayer> result = new ArrayList<RfStructLayer>();
        for (RfStructLayer candidate : candidates) {
            Determinant candidateDeterminant = candidate.getDeterminant();
            if (!candidateDeterminant.contains(determinant, true)) continue;
            result.add(candidate);
        }
        return result;
    }

    public List<Determinant> getSubTypeDeterminants() {
        List<RfStructLayer> layers = this.getSubTypeLayers();
        if (layers == null) {
            return null;
        }
        ArrayList<Determinant> result = new ArrayList<Determinant>(layers.size());
        for (RfStructLayer layer : layers) {
            Determinant determinant = layer.getDeterminant();
            result.add(determinant);
        }
        return result;
    }

    public List<Determinant> getSubTypeDeterminants(Determinant determinant) {
        List<Determinant> candidates = this.getSubTypeDeterminants();
        if (candidates == null) {
            return null;
        }
        ArrayList<Determinant> result = new ArrayList<Determinant>();
        for (Determinant candidate : candidates) {
            if (!candidate.equals(determinant) && !candidate.contains(determinant)) continue;
            result.add(candidate);
        }
        return result;
    }

    public boolean isSubTypeIrrelevant(Determinant determinant) {
        if (determinant == null) {
            return false;
        }
        if (determinant.equals(this.getDeterminant())) {
            return false;
        }
        List<Determinant> relevants = this.getSubTypeDeterminants();
        if (relevants == null) {
            return true;
        }
        for (Determinant relevant : relevants) {
            if (!determinant.equals(relevant)) continue;
            return false;
        }
        return true;
    }

    public List<RfField> getFields(String packageName, Determinant determinant, boolean showInherited, int accessModifiers) {
        NullProtectedList<RfField> result = new NullProtectedList<RfField>();
        List<RfStructMember> members = this.getFields();
        if (members == null) {
            return result;
        }
        for (RfStructMember member : members) {
            if ((member.getAccessModifier() & accessModifiers) == 0 || packageName != null && member.isPackage() && !member.getPackageName().equals(packageName) || packageName != null && member.isPrivate() && !member.getPackageName().equals(packageName) || (!showInherited || !determinant.contains(member.getFullName().getDeterminant(), true)) && (showInherited || !determinant.equals(member.getFullName().getDeterminant()))) continue;
            result.add((RfField)member);
        }
        RfStruct parent = null;
        if (showInherited && (parent = this.getParentStruct()) != null) {
            result.addAll(parent.getFieldsWithPrefix(packageName, null, 2, "", accessModifiers));
        }
        return result;
    }

    public List<RfMethod> getMethods(String packageName, Determinant determinant, boolean showInherited, int accessModifiers) {
        NullProtectedList<RfMethod> result = new NullProtectedList<RfMethod>();
        List<RfStructMember> members = this.getMethods();
        if (members == null) {
            return result;
        }
        for (RfStructMember member : members) {
            if ((member.getAccessModifier() & accessModifiers) == 0 || packageName != null && member.isPackage() && !member.getPackageName().equals(packageName) || packageName != null && member.isPrivate() && !member.getPackageName().equals(packageName) || (!showInherited || !determinant.contains(member.getFullName().getDeterminant(), true)) && (showInherited || !determinant.equals(member.getFullName().getDeterminant()))) continue;
            result.add((RfMethod)member);
        }
        RfStruct parent = null;
        if (showInherited && (parent = this.getParentStruct()) != null) {
            result.addAll(parent.getMethodsWithPrefix(packageName, null, 2, "", accessModifiers));
        }
        return result;
    }

    public List<RfEvent> getEvents(String packageName, Determinant determinant, boolean showInherited, int accessModifiers) {
        NullProtectedList<RfEvent> result = new NullProtectedList<RfEvent>();
        List<RfStructMember> members = this.getEvents();
        if (members == null) {
            return result;
        }
        for (RfStructMember member : members) {
            if ((member.getAccessModifier() & accessModifiers) == 0 || packageName != null && member.isPackage() && !member.getPackageName().equals(packageName) || packageName != null && member.isPrivate() && !member.getPackageName().equals(packageName) || (!showInherited || !determinant.contains(member.getFullName().getDeterminant(), true)) && (showInherited || !determinant.equals(member.getFullName().getDeterminant()))) continue;
            result.add((RfEvent)member);
        }
        RfStruct parent = null;
        if (showInherited && (parent = this.getParentStruct()) != null) {
            result.addAll(parent.getEventsWithPrefix(packageName, null, 2, "", accessModifiers));
        }
        return result;
    }

    protected String getParentPackageName() {
        if (this.fParentStruct == null) {
            return null;
        }
        return this.fParentStruct.getPackageName();
    }

    protected String getParentName() {
        if (this.fParentStruct == null) {
            return null;
        }
        return this.fParentStruct.getName();
    }

    public void setParentStructFrom(RfProject project, RfNamedElement parentContainer) {
        IRfNamedElement candidate;
        if (this.fParentStruct instanceof RfStruct) {
            ((RfStruct)this.fParentStruct).removeChildStruct(this);
        }
        if (this.fMeVariable == null) {
            this.fMeVariable = new RfMeImplicitVariable(project, this);
        }
        if (parentContainer == TypesWalker.DVT_NULL_PARENT) {
            this.fParentStruct = null;
        } else if (parentContainer instanceof RfTemplateParam) {
            this.fParentStruct = (RfTemplateParam)parentContainer;
        } else if (parentContainer instanceof IRfAssociatedType && (candidate = ((IRfAssociatedType)((Object)parentContainer)).getAssociatedType()) instanceof RfStruct) {
            this.fParentStruct = (RfStruct)candidate;
            if (((RfStruct)candidate).isUnit()) {
                this.fIsUnit = true;
            }
            ((RfStruct)this.fParentStruct).addChildStruct(this);
        }
    }

    @Override
    protected void removeLayer(RfDefElement layer) {
        if (this.fParentInterfaces != null) {
            this.fParentInterfaces.remove(layer);
        }
        super.removeLayer(layer);
    }

    public void setParentInterfacesFrom(RfProject project, RfStructLayer layer, List<RfNamedElement> parentsContainer) {
        List<RfType> parentInterfacesForLayer;
        if (parentsContainer == null || parentsContainer.isEmpty()) {
            return;
        }
        if (this.fParentInterfaces == null) {
            this.fParentInterfaces = new HashMap<RfDefElement, List<RfType>>();
        }
        if ((parentInterfacesForLayer = this.fParentInterfaces.get(layer)) == null) {
            parentInterfacesForLayer = new ArrayList<RfType>();
            this.fParentInterfaces.put(layer, parentInterfacesForLayer);
        }
        for (RfNamedElement parentContainer : parentsContainer) {
            IRfNamedElement candidate;
            if (parentContainer == TypesWalker.DVT_NULL_PARENT) continue;
            if (parentContainer instanceof RfTemplateParam) {
                parentInterfacesForLayer.add((RfTemplateParam)parentContainer);
                continue;
            }
            if (!(parentContainer instanceof IRfAssociatedType) || !((candidate = ((IRfAssociatedType)((Object)parentContainer)).getAssociatedType()) instanceof RfStruct)) continue;
            parentInterfacesForLayer.add((RfStruct)candidate);
        }
    }

    public List<RfStruct> getParentInterfaces() {
        if (this.fParentInterfaces == null || this.fParentInterfaces.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RfStruct> result = new ArrayList<RfStruct>();
        for (List<RfType> parentInterfacesForLayer : this.fParentInterfaces.values()) {
            if (parentInterfacesForLayer == null || parentInterfacesForLayer.isEmpty()) continue;
            for (RfType parentInterface : parentInterfacesForLayer) {
                if (parentInterface instanceof RfStruct) {
                    result.add((RfStruct)parentInterface);
                    continue;
                }
                HashSet<RfType> visited = new HashSet<RfType>();
                while (parentInterface instanceof RfTemplateParam && !visited.contains(parentInterface)) {
                    visited.add(parentInterface);
                    parentInterface = ((RfTemplateParam)parentInterface).getAssociatedBaseType();
                }
                if (!(parentInterface instanceof RfStruct)) continue;
                result.add((RfStruct)parentInterface);
            }
        }
        return result;
    }

    public void collectAllMethodsToImplement(RfStruct struct, Map<String, List<RfMethod>> result, Set<RfStruct> visited) {
        if (struct.fParentInterfaces == null || struct.fParentInterfaces.isEmpty()) {
            return;
        }
        if (visited.contains(struct)) {
            return;
        }
        visited.add(struct);
        List<RfStruct> interfaces = struct.getParentInterfaces();
        for (RfStruct interf : interfaces) {
            if (interf.fMethods == null || interf.fMethods.isEmpty()) continue;
            for (ListContainer<RfStructMember> methods : interf.fMethods.values()) {
                if (methods == null || methods.isEmpty()) continue;
                for (RfStructMember method : methods) {
                    if (method.isPredefined()) continue;
                    List<RfMethod> listOfMethods = result.get(method.getName());
                    if (listOfMethods == null) {
                        listOfMethods = new ArrayList<RfMethod>();
                        result.put(method.getName(), listOfMethods);
                    }
                    listOfMethods.add((RfMethod)method);
                }
            }
            this.collectAllMethodsToImplement(interf, result, visited);
        }
    }

    public boolean hasWhenSubtype(LineInfo lineInfo, int moduleIndex) {
        List<RfDefElement> layers = this.getLayers();
        if (layers == null || layers.isEmpty()) {
            return this.hasImplicitWhenSubtype(lineInfo, moduleIndex);
        }
        for (RfDefElement layer : layers) {
            int layerModuleIndex = layer.getModuleIndex();
            if (moduleIndex >= 0 && layerModuleIndex > moduleIndex || moduleIndex >= 0 && layerModuleIndex == moduleIndex && layer.getStartLine() > lineInfo.line) break;
            if (!layer.isWhen()) continue;
            return true;
        }
        return this.hasImplicitWhenSubtype(lineInfo, moduleIndex);
    }

    public boolean hasImplicitWhenSubtype(LineInfo lineInfo, int moduleIndex) {
        return false;
    }

    public boolean hasLikeSubtype(LineInfo lineInfo, int moduleIndex) {
        List<RfStruct> likeChildren = this.getChildStructs();
        if (likeChildren == null || likeChildren.isEmpty()) {
            return false;
        }
        RfStruct likeChild = likeChildren.get(0);
        if (likeChild.isPredefined()) {
            return true;
        }
        RfDefElement layer = likeChild.getDeclaration();
        int layerModuleIndex = layer.getModuleIndex();
        if (moduleIndex >= 0 && layerModuleIndex > moduleIndex) {
            return false;
        }
        return moduleIndex < 0 || layerModuleIndex != moduleIndex || layer.getStartLine() <= lineInfo.line;
    }

    public static RfNamedElement computeSafeParent(RfProject project, RfStruct element, RfNamedElement parentContainer, LineInfo lineInfo, ParserPath parserPath, RfStruct defaultParent) {
        RfNamedElement parentCandidate = parentContainer;
        if (parentCandidate instanceof RfTemplateParam) {
            return parentCandidate;
        }
        RfStruct parent = (RfStruct)((IRfAssociatedType)((Object)parentContainer)).getAssociatedType();
        String name = element.getName();
        String packageName = element.getPackageName();
        while (parent != null) {
            if (name.equals(parent.getName()) && packageName.equals(parent.getPackageName())) {
                project.addSemanticError1(1, "CIRCULAR_INHERITANCE: ''{1}::{0}'' extends itself", lineInfo.realOffset, lineInfo.realOffset + name.length(), null, lineInfo.line, parserPath, name, packageName);
                return new RfDummyField(project, defaultParent);
            }
            parent = parent.getParentStruct();
        }
        return parentCandidate;
    }

    @Override
    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currLayer, LineInfo lineInfo, ParserPath parserPath) {
        List<RfDefElement> layers;
        if (currLayer == null) {
            return;
        }
        boolean isCurrDeclarationLayer = this.isDeclarationLayer(currLayer);
        boolean isPredefined = this.isPredefined();
        if (isPredefined && isCurrDeclarationLayer) {
            project.addSemanticError1(1, "PREDEFINED_NAME: Type name ''{0}'' is a reserved type name. Use a different name", lineInfo.realOffset, lineInfo.getEndOffset(this.getName()), null, lineInfo.line, parserPath, this.getName());
        }
        if ((layers = this.getLayers()) == null || layers.isEmpty()) {
            return;
        }
        if (!currLayer.hasQualifiedName() && (!project.isInSLNMode() && !project.isInSDLMode() || this.isPackage())) {
            project.getType(currLayer.getPackageName(), null, 1, this.getName(), currLayer.getMaxModuleIndex(), parserPath, lineInfo, lineInfo);
        }
        boolean hasDeclaration = isCurrDeclarationLayer;
        for (RfDefElement layer : layers) {
            if (layer == currLayer) break;
            if (!project.importedBySameTest(layer, currLayer)) continue;
            boolean isDeclarationLayer = this.isDeclarationLayer(layer);
            hasDeclaration |= isDeclarationLayer;
            if (!isCurrDeclarationLayer || !isDeclarationLayer) continue;
            project.addSemanticError1(1, "DUPLICATE_NAME: Name ''{0}'' in package ''{1}'' was previously defined\n    at line {2,number,#######} in {3}", lineInfo.realOffset, lineInfo.getEndOffset(this.getName()), null, lineInfo.line, parserPath, this.getName(), this.getPackageName(), layer.getStartLine(), layer.getParserPath());
            return;
        }
        if (!isPredefined && !hasDeclaration) {
            project.addSemanticError1(1, "UNDEFINED_TYPE: No type called ''{0}''", lineInfo.realOffset, lineInfo.getEndOffset(this.getName()), null, lineInfo.line, parserPath, this.getName());
        }
    }

    protected boolean hasLocalUnknownParentStruct() {
        return this.fParentStruct instanceof IRfTemplateParam;
    }

    public <T extends RfStructMember> Map<String, ListContainer<RfStructMember>> getAllMembersOfType(int kind) {
        if (kind == 5) {
            return this.fEvents;
        }
        if (kind == 1) {
            return this.fMethods;
        }
        if (kind == 2) {
            return this.fFields;
        }
        if (kind == 3) {
            return this.fFieldTCs;
        }
        if (kind == 4) {
            return this.fFieldPCs;
        }
        if (kind == 6) {
            return this.fExpects;
        }
        if (kind == 7) {
            return this.fConstraints;
        }
        return null;
    }

    @Override
    public Determinant getDeterminant() {
        if (this.fDeterminant == null) {
            this.fDeterminant = new Determinant(new String[]{this.getName()});
        }
        return this.fDeterminant;
    }

    public void setDeterminant(Determinant determinant) {
        if (this.isPredefined() || this instanceof RfListType) {
            this.fDeterminant = determinant;
        }
    }

    private void addChildStruct(RfStruct structType) {
        try {
            if (this.fStructChildren == null) {
                this.fStructChildren = new ArrayList<RfStruct>();
            }
            this.fStructChildren.add(structType);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void removeChildStruct(RfStruct struct) {
        try {
            if (this.fStructChildren == null) {
                return;
            }
            this.fStructChildren.remove(struct);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public List<RfStruct> getChildStructs() {
        return this.fStructChildren;
    }

    public RfStruct getParentStruct() {
        if (this.fParentStruct instanceof RfStruct) {
            return (RfStruct)this.fParentStruct;
        }
        RfType result = this.fParentStruct;
        HashSet<RfType> visited = new HashSet<RfType>();
        while (result instanceof RfTemplateParam && !visited.contains(result)) {
            visited.add(result);
            result = ((RfTemplateParam)result).getAssociatedBaseType();
        }
        if (result instanceof RfStruct) {
            return (RfStruct)result;
        }
        return null;
    }

    public String getSignature() {
        if (this.fKind == KIND.PACKAGE) {
            return "package " + this.getName();
        }
        if (this.fKind == KIND.SLN_COMPONENT) {
            return "component " + this.getName();
        }
        if (this.fKind == KIND.SDL_AGENT) {
            return "agent " + this.getName();
        }
        if (this.fKind == KIND.SLN_ACTION) {
            return "action " + (this.fSLNEnclosingComponent != null ? this.fSLNEnclosingComponent.getName() : "DVE") + "::" + this.getName();
        }
        if (this.fKind == KIND.SDL_SCENARIO) {
            String sdlParams = this.getSDLParamsAsString();
            if (sdlParams.isEmpty()) {
                return "scenario " + (this.fSDLEnclosingAgent != null ? this.fSDLEnclosingAgent.getName() : "???") + "::" + this.getName();
            }
            return "scenario " + (this.fSDLEnclosingAgent != null ? this.fSDLEnclosingAgent.getName() : "???") + "::" + this.getName() + "(" + sdlParams + ")";
        }
        if (this.fKind == KIND.SLN_TOKEN) {
            return "token " + this.getName();
        }
        if (this.fKind == KIND.SLN_STRUCT) {
            return "struct " + this.getName();
        }
        if (this.isUnit()) {
            if (this.isLike("any_sequence_driver")) {
                List<RfStruct> structs = this.getRfProject().getAllStructs();
                for (RfStruct struct : structs) {
                    if (struct instanceof RfPredefinedStruct || !struct.isSequence() || struct.getSequenceDriverName() == null || !struct.getSequenceDriverName().equals(this.getName())) continue;
                    return String.valueOf(struct.isSequenceVirtual() ? "virtual sequence driver " : "BFM sequence driver ") + this.getPackageName() + "::" + this.getName();
                }
            }
            return "unit " + this.getName();
        }
        if (this.isSequence()) {
            return String.valueOf(this.isSequenceVirtual() ? "virtual sequence " : "BFM sequence ") + this.getName();
        }
        if (this.isLike("any_sequence_item")) {
            List<RfStruct> structs = this.getRfProject().getAllStructs();
            for (RfStruct struct : structs) {
                if (struct instanceof RfPredefinedStruct || !struct.isSequence() || struct.isSequenceVirtual() || !struct.getSequenceItemName().equals(this.getName())) continue;
                return "sequence item " + this.getPackageName() + "::" + this.getName();
            }
        }
        if (this.isInterface()) {
            return "interface " + this.getPackageName() + "::" + this.getName();
        }
        return "struct " + this.getPackageName() + "::" + this.getName();
    }

    public void collectBindMethodCalls(Determinant determinant, List<RfBindMethodCall> collectedCalls) {
        List<RfStructLayer> structLayers;
        RfModule module = this.getModule();
        if (module == null) {
            return;
        }
        List<RfStructLayer> baseTypeLayers = this.getBaseTypeLayers();
        if (baseTypeLayers != null) {
            for (RfStructLayer layer : baseTypeLayers) {
                RfModule layerModule = layer.getLayerModule();
                if (layerModule == null) continue;
                layerModule.collectBindMethodsCalls(collectedCalls, layer);
            }
        }
        if (determinant.toArray().length > 1 && (structLayers = this.getSubTypeLayers(determinant)) != null) {
            for (RfStructLayer layer : structLayers) {
                RfModule layerModule = layer.getLayerModule();
                if (layerModule == null) continue;
                layerModule.collectBindMethodsCalls(collectedCalls, layer);
            }
        }
    }

    public void collectSDLToolEditorPrioritizeCalls(List<RfSDLToolEditorPrioritizeCallLayer> collectedCalls) {
        List<RfStructLayer> baseTypeLayers = this.getBaseTypeLayers();
        if (baseTypeLayers != null) {
            for (RfStructLayer layer : baseTypeLayers) {
                layer.collectSDLToolEditorPrioritizeCalls(collectedCalls);
            }
        }
    }

    public void collectSDLToolEditorAvoidCalls(List<RfSDLToolEditorAvoidCallLayer> collectedCalls) {
        List<RfStructLayer> baseTypeLayers = this.getBaseTypeLayers();
        if (baseTypeLayers != null) {
            for (RfStructLayer layer : baseTypeLayers) {
                layer.collectSDLToolEditorAvoidCalls(collectedCalls);
            }
        }
    }

    public RfMethodLayer addMethodLayer(RfProject project, RfModule module, RfStructLayer structLayer, WrapperMethod parseInfo, int accessModifier) {
        try {
            Determinant determinant = structLayer.getDeterminant();
            FullName fullName = new FullName(parseInfo.name, determinant);
            RfMethod method = (RfMethod)this.internalGetNearestMember(this.fMethods, fullName);
            if (method == null) {
                method = new RfMethod(project, this, fullName);
                this.addMethod(method);
                project.addNewDefinedVarName(method);
            }
            if (parseInfo.kind == 371 || parseInfo.kind == 372 || parseInfo.kind == 378) {
                method.setAccessModifier(accessModifier);
            }
            method.setArgumentDescr(parseInfo.args);
            method.setTCMEventName(parseInfo.tcmEvent);
            RfMethodLayer methodLayer = new RfMethodLayer(module, structLayer, parseInfo.isCVL, parseInfo.isFinal, parseInfo.tcmEvent, parseInfo.kind, parseInfo.startLine, parseInfo.endLine, parseInfo.comment, parseInfo.reparseStack);
            method.addLayer(methodLayer);
            if (method.getFullName().getDeterminant().contains(determinant)) {
                method.getFullName().setDeterminant(determinant);
            }
            method.setAssociatedType(module, parseInfo.resultTypeInfo);
            return methodLayer;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public RfFieldLayer addFieldLayer(RfProject project, RfModule module, RfStructLayer structLayer, String name, WrapperType typeInfo, boolean isInstance, boolean isUngenerated, boolean isPhysical, int accessModifier, boolean isSLNTokenField, boolean isSDLScenarioParam, ReparseElement[] reparseStack) {
        try {
            Determinant determinant = structLayer.getDeterminant();
            FullName fullName = new FullName(name, determinant);
            RfField field = (RfField)this.internalGetNearestMember(this.fFields, fullName);
            if (field == null) {
                field = isSLNTokenField ? new RfSLNTokenField(project, this, fullName) : new RfField(project, this, fullName);
                this.addField(field);
                project.addNewDefinedVarName(field);
            }
            typeInfo.isInstance = isInstance;
            typeInfo.isGenerated = isUngenerated;
            typeInfo.isPhysical = isPhysical;
            field.setAccessModifier(accessModifier);
            RfFieldLayer fieldLayer = new RfFieldLayer(module, structLayer, typeInfo.line, typeInfo.comment, reparseStack);
            field.addLayer(fieldLayer);
            if (field.getFullName().getDeterminant().contains(determinant)) {
                field.getFullName().setDeterminant(determinant);
            }
            field.setAssociatedType(module, typeInfo);
            return fieldLayer;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public RfSDLRoleSMLayer addSDLRoleSMLayer(RfProject project, RfModule module, RfStructLayer structLayer, LineInfo line, String name, ReparseElement[] reparseStack) {
        return null;
    }

    public RfSDLInlineSMLayer addSDLInlineSMLayer(RfProject project, RfModule module, RfStructLayer structLayer, String argName, String inlineText, String inlineElseText, LineInfo line, ReparseElement[] reparseStack) {
        return null;
    }

    public RfFieldLayer addFieldTypeConstraintLayer(RfProject project, RfModule module, RfStructLayer structLayer, String name, WrapperType typeInfo, ReparseElement[] reparseStack) {
        try {
            Determinant determinant = structLayer.getDeterminant();
            FullName fullName = new FullName(name, determinant);
            RfFieldTCLayer fieldLayer = new RfFieldTCLayer(module, structLayer, typeInfo, reparseStack);
            RfField fieldTC = (RfField)this.internalGetNearestMember(this.fFieldTCs, fullName);
            if (fieldTC == null) {
                fieldTC = new RfFieldTypeConstraint(project, this, fullName);
                this.addFieldTC(fieldTC);
                project.addNewDefinedVarName(fieldTC);
            } else {
                Determinant newConstraintDeterminant = new Determinant(typeInfo.def == null ? typeInfo.baseName : typeInfo.def);
                Determinant oldConstraintDeterminant = fieldTC.getAssociatedTypeDeterminant();
                if (oldConstraintDeterminant != null) {
                    newConstraintDeterminant = Determinant.merge(newConstraintDeterminant.toArray(), oldConstraintDeterminant.toArray());
                }
                typeInfo.def = newConstraintDeterminant.toString();
            }
            fieldTC.addLayer(fieldLayer);
            if (fieldTC.getFullName().getDeterminant().contains(determinant)) {
                fieldTC.getFullName().setDeterminant(determinant);
            }
            fieldTC.setAssociatedType(module, typeInfo);
            return fieldLayer;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public RfFieldLayer addFieldPropConstraintLayer(RfProject project, RfModule module, RfStructLayer structLayer, String fieldName1, String fieldName2, String fieldName3, CommentBlock comment, LineInfo line, ReparseElement[] reparseStack) {
        try {
            Determinant determinant = structLayer.getDeterminant();
            FullName fullName = new FullName(fieldName2, determinant);
            RfField field = (RfField)this.internalGetNearestMember(this.fFieldPCs, fullName);
            if (field == null) {
                field = new RfFieldPropConstraint(project, this, fullName, fieldName1, fieldName3);
                this.addFieldPC(field);
                project.addNewDefinedVarName(field);
            }
            RfFieldLayer fieldLayer = new RfFieldLayer(module, structLayer, line, comment, reparseStack);
            field.addLayer(fieldLayer);
            if (field.getFullName().getDeterminant().contains(determinant)) {
                field.getFullName().setDeterminant(determinant);
            }
            return fieldLayer;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public RfEventLayer addEventLayer(RfProject project, RfModule module, RfStructLayer structLayer, String name, int kind, LineInfo line, CommentBlock comment, int accessModifier, ReparseElement[] reparseStack) {
        try {
            Determinant determinant = structLayer.getDeterminant();
            FullName fullName = new FullName(name, determinant);
            RfEvent event = (RfEvent)this.internalGetNearestMember(this.fEvents, fullName);
            if (event == null) {
                event = new RfEvent(project, this, fullName);
                this.addEvent(event);
                project.addNewDefinedVarName(event);
            }
            if (kind == 371 || kind == 378) {
                event.setAccessModifier(accessModifier);
            }
            RfEventLayer eventLayer = new RfEventLayer(module, structLayer, kind, line, comment, reparseStack);
            event.addLayer(eventLayer);
            if (event.getFullName().getDeterminant().contains(determinant)) {
                event.getFullName().setDeterminant(determinant);
            }
            return eventLayer;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public RfExpectLayer addExpectLayer(RfProject project, RfModule module, RfStructLayer structLayer, String name, boolean expectNoAssume, String expression, boolean defaultDutError, String literal, int kind, LineInfo line, LineInfo endLine, CommentBlock comment, ReparseElement[] reparseStack) {
        try {
            name = RfExpect.getExpectName(project, name);
            Determinant determinant = structLayer.getDeterminant();
            FullName fullName = new FullName(name, determinant);
            RfExpect expect = (RfExpect)this.internalGetNearestMember(this.fExpects, fullName);
            if (expect == null) {
                expect = new RfExpect(project, this, fullName, expectNoAssume);
                this.addExpect(expect);
            }
            RfExpectLayer expectLayer = new RfExpectLayer(module, structLayer, expectNoAssume, expression, defaultDutError, literal, kind, line, endLine, comment, reparseStack);
            expect.addLayer(expectLayer);
            if (expect.getFullName().getDeterminant().contains(determinant)) {
                expect.getFullName().setDeterminant(determinant);
            }
            return expectLayer;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public RfCoverLayer addCoverLayer(RfProject project, RfModule module, RfStructLayer structLayer, String name, int kind, LineInfo startLine, LineInfo endLine, CommentBlock comment, ReparseElement[] reparseStack) {
        try {
            Determinant determinant = structLayer.getDeterminant();
            FullName fullName = new FullName(name, determinant);
            RfEvent event = (RfEvent)this.internalGetNearestMember(this.fEvents, fullName);
            if (event == null) {
                event = new RfEvent(project, this, fullName);
                this.addEvent(event);
                project.addNewDefinedVarName(event);
            }
            RfCoverLayer coverLayer = new RfCoverLayer(module, structLayer, kind, startLine, endLine, comment, reparseStack);
            event.addLayer(coverLayer);
            return coverLayer;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public RfMethodLayer addOnEventLayer(RfProject project, RfModule module, RfStructLayer structLayer, String name, LineInfo startLine, LineInfo endLine, CommentBlock comment, ReparseElement[] reparseStack) {
        try {
            Determinant determinant = structLayer.getDeterminant();
            FullName fullName = new FullName(name, determinant);
            RfEvent event = (RfEvent)this.internalGetNearestMember(this.fEvents, fullName);
            RfMethodLayer result = null;
            if (event == null) {
                event = new RfEvent(project, this, fullName);
                this.addEvent(event);
                project.addNewDefinedVarName(event);
            }
            RfMethod onMethod = this.getMethod("on_" + name);
            boolean hasIsLayer = false;
            if (onMethod != null) {
                List<RfDefElement> onLayers = onMethod.getLayers();
                for (RfDefElement onLayer : onLayers) {
                    if (!onLayer.isIs()) continue;
                    hasIsLayer = true;
                    break;
                }
            }
            int kind = hasIsLayer ? 376 : 378;
            WrapperMethod parseInfo = new WrapperMethod("on_" + name, kind, "", null, new WrapperType(), "", false, startLine, endLine, 16, comment, reparseStack, false);
            result = this.addMethodLayer(project, module, structLayer, parseInfo, 16);
            result.setImplicit(true);
            RfOnEventLayer onEventLayer = new RfOnEventLayer(module, structLayer, startLine, comment, reparseStack);
            event.addLayer(onEventLayer);
            return result;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public RfConstraintLayer addConstraintLayer(RfProject project, RfModule module, RfStructLayer structLayer, String name, int kind, LineInfo line, LineInfo endLine, CommentBlock comment, ReparseElement[] reparseStack) {
        try {
            name = RfExpect.getExpectName(project, name);
            Determinant determinant = structLayer.getDeterminant();
            FullName fullName = new FullName(name, determinant);
            RfConstraint constraint = (RfConstraint)this.internalGetNearestMember(this.fConstraints, fullName);
            if (constraint == null) {
                constraint = new RfConstraint(project, this, fullName);
                this.addConstraint(constraint);
                project.addNewDefinedVarName(constraint);
            }
            RfConstraintLayer constraintLayer = new RfConstraintLayer(module, structLayer, kind, line, endLine, comment, reparseStack);
            constraint.addLayer(constraintLayer);
            if (constraint.getFullName().getDeterminant().contains(determinant)) {
                constraint.getFullName().setDeterminant(determinant);
            }
            return constraintLayer;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public List<RfStructMember> getMethods() {
        return this.getAll(this.fMethods, "", false);
    }

    public Map<String, ListContainer<RfStructMember>> getRawMethods() {
        return this.fMethods;
    }

    public List<RfStructMember> getFields() {
        return this.getAll(this.fFields, "", false);
    }

    public List<RfStructMember> getAsComputedUsedFields() {
        List<RfStructMember> fields = this.getFields();
        if (fields == null) {
            return Collections.emptyList();
        }
        ArrayList<RfStructMember> filteredFields = new ArrayList<RfStructMember>();
        for (RfStructMember field : fields) {
            if (!((RfField)field).isAsComputedTranslate()) continue;
            filteredFields.add(field);
        }
        return filteredFields;
    }

    public Map<String, ListContainer<RfStructMember>> getRawFields() {
        return this.fFields;
    }

    public Iterator<RfStructMember> getRawFieldsIterator(boolean onlyUnits) {
        return new RawFieldsIterator(this, onlyUnits);
    }

    public List<RfStructMember> getEvents() {
        return this.getAll(this.fEvents, "", false);
    }

    public Map<String, ListContainer<RfStructMember>> getRawEvents() {
        return this.fEvents;
    }

    public List<RfStructMember> getExpects() {
        return this.getAll(this.fExpects, "", false);
    }

    public Map<String, ListContainer<RfStructMember>> getRawExpects() {
        return this.fExpects;
    }

    public Map<String, ListContainer<RfStructMember>> getRawFieldTCs() {
        return this.fFieldTCs;
    }

    public Map<String, ListContainer<RfStructMember>> getRawFieldPCs() {
        return this.fFieldPCs;
    }

    public Map<String, ListContainer<RfStructMember>> getRawConstraints() {
        return this.fConstraints;
    }

    public RfField getField(FullName name) {
        RfStruct struct = this;
        RfStructMember field = null;
        name = new FullName(name.getName(), name.getDeterminant());
        while ((field = (RfStructMember)struct.getLocalMember(struct.fFields, name)) == null) {
            if ((struct = struct.getParentStruct()) == null) break;
            name.setDeterminant(struct.getDeterminant());
        }
        return (RfField)field;
    }

    public RfField getField(String name) {
        return this.getField(new FullName(name, this.getDeterminant()));
    }

    public void getLocalMemberLayers(List<RfDefElement> layers, String name, int memberKind) {
        Map rawMembers = this.getAllMembersOfType(memberKind);
        ListContainer members = this.get(rawMembers, name);
        if (members == null || members.isEmpty()) {
            return;
        }
        for (RfStructMember member : members) {
            List<RfDefElement> localLayers = member.getLayers();
            if (localLayers == null || localLayers.isEmpty()) continue;
            layers.addAll(localLayers);
        }
    }

    public void collectAllMemberLayers(List<RfDefElement> layers, String name, int memberKind) {
        RfStruct struct = this;
        RfStruct firstStructDefiningMember = this;
        while (struct != null) {
            if (struct.hasLocalMember(name, RfEventLayer.class, memberKind)) {
                firstStructDefiningMember = struct;
            }
            struct = struct.getParentStruct();
        }
        firstStructDefiningMember.getLocalMemberLayers(layers, name, memberKind);
        this.collectChildrenMemberLayers(layers, firstStructDefiningMember, name, memberKind);
        Collections.sort(layers);
    }

    private void collectChildrenMemberLayers(List<RfDefElement> layers, RfStruct struct, String name, int memberKind) {
        List<RfStruct> children = struct.getChildStructs();
        if (children == null || children.isEmpty()) {
            return;
        }
        for (RfStruct childStruct : children) {
            childStruct.getLocalMemberLayers(layers, name, memberKind);
            this.collectChildrenMemberLayers(layers, childStruct, name, memberKind);
        }
    }

    public RfMethod getMethod(FullName name) {
        RfStruct struct = this;
        RfStructMember method = null;
        name = new FullName(name.getName(), name.getDeterminant());
        while ((method = (RfStructMember)struct.getLocalMember(struct.fMethods, name)) == null) {
            if ((struct = struct.getParentStruct()) == null) break;
            name.setDeterminant(struct.getDeterminant());
        }
        return (RfMethod)method;
    }

    public RfMethod getLocalMethod(String name) {
        RfStructMember method = (RfStructMember)this.getLocalMember(this.fMethods, new FullName(name, this.getDeterminant()));
        return (RfMethod)method;
    }

    public List<RfDefElement> getLocalMethodLayers(String name) {
        if (this.fMethods == null) {
            return Collections.emptyList();
        }
        ListContainer<RfStructMember> candidates = this.fMethods.get(name);
        if (candidates == null || candidates.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RfDefElement> layers = new ArrayList<RfDefElement>();
        for (RfStructMember candidate : candidates) {
            List<RfDefElement> candidateLayers = candidate.getLayers();
            if (candidateLayers == null) continue;
            layers.addAll(candidateLayers);
        }
        return layers;
    }

    public RfMethod getMethod(String name) {
        return this.getMethod(new FullName(name, this.getDeterminant()));
    }

    public RfEvent getEvent(FullName name) {
        RfStruct struct = this;
        RfStructMember event = null;
        name = new FullName(name.getName(), name.getDeterminant());
        while ((event = (RfStructMember)struct.getLocalMember(struct.fEvents, name)) == null) {
            if ((struct = struct.getParentStruct()) == null) break;
            name.setDeterminant(struct.getDeterminant());
        }
        return (RfEvent)event;
    }

    public RfEvent getLocalEvent(String name) {
        RfStructMember event = (RfStructMember)this.getLocalMember(this.fEvents, new FullName(name, this.getDeterminant()));
        return (RfEvent)event;
    }

    public RfEvent getEvent(String name) {
        return this.getEvent(new FullName(name, this.getDeterminant()));
    }

    public RfExpect getExpect(FullName name) {
        RfStruct struct = this;
        RfStructMember expect = null;
        name = new FullName(name.getName(), name.getDeterminant());
        while ((expect = (RfStructMember)struct.getLocalMember(struct.fExpects, name)) == null) {
            if ((struct = struct.getParentStruct()) == null) break;
            name.setDeterminant(struct.getDeterminant());
        }
        return (RfExpect)expect;
    }

    public RfExpect getExpect(String name) {
        return this.getExpect(new FullName(name, this.getDeterminant()));
    }

    public RfSDLRoleSM getSDLRole(FullName name) {
        return null;
    }

    public RfSDLRoleSM getSDLRole(String name) {
        return this.getSDLRole(new FullName(name, this.getDeterminant()));
    }

    private RfStructMember internalGetNearestMember(Map<String, ListContainer<RfStructMember>> members, FullName name) {
        if (members == null || members.isEmpty()) {
            return null;
        }
        boolean memberOfBaseStruct = name.getDeterminant().equals(this.getDeterminant());
        ListContainer<RfStructMember> candidates = members.get(name.getName());
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        for (RfStructMember candidate : candidates) {
            if (candidate instanceof RfExpect && ((RfExpect)candidate).isAnonymous()) continue;
            Determinant candidateDeterminant = candidate.getFullName().getDeterminant();
            if (memberOfBaseStruct) {
                candidate.getFullName().setDeterminant(name.getDeterminant());
                return candidate;
            }
            if (name.getDeterminant().contains(candidateDeterminant, true)) {
                return candidate;
            }
            if (!candidateDeterminant.contains(name.getDeterminant(), false)) continue;
            candidate.getFullName().setDeterminant(name.getDeterminant());
            return candidate;
        }
        return null;
    }

    protected <T extends RfNamedElement> T getLocalMember(Map<String, ListContainer<T>> members, FullName name) {
        if (members == null) {
            return null;
        }
        ListContainer<T> candidates = members.get(name.getName());
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        for (RfNamedElement candidate : candidates) {
            Determinant candidateDeterminant = candidate.getFullName().getDeterminant();
            if (!name.getDeterminant().contains(candidateDeterminant, true)) continue;
            return (T)candidate;
        }
        return null;
    }

    public RfDefElement getLastLocalMethodLayer(String name) {
        ListContainer methods = this.get(this.fMethods, name);
        if (methods == null || methods.isEmpty()) {
            return null;
        }
        List<RfDefElement> layers = ((RfStructMember)methods.get(0)).getLayers();
        if (layers == null || layers.isEmpty()) {
            return null;
        }
        return layers.get(layers.size() - 1);
    }

    public RfDefElement getFirstLocalMethodLayer(String name) {
        ListContainer methods = this.get(this.fMethods, name);
        if (methods == null || methods.isEmpty()) {
            return null;
        }
        List<RfDefElement> layers = ((RfStructMember)methods.get(0)).getLayers();
        if (layers == null || layers.isEmpty()) {
            return null;
        }
        return layers.get(0);
    }

    public boolean hasLocalMember(String name, Class<? extends RfEventLayer> clazz, int memberKind) {
        Map rawMembers = this.getAllMembersOfType(memberKind);
        ListContainer members = this.get(rawMembers, name);
        if (members == null || members.isEmpty()) {
            return false;
        }
        if (clazz == null || memberKind != 5) {
            return true;
        }
        RfStructMember event = (RfStructMember)members.get(0);
        if (clazz == RfEventLayer.class && event.isPredefined()) {
            return true;
        }
        List<RfDefElement> layers = event.getLayers();
        if (layers == null || layers.isEmpty()) {
            return false;
        }
        int i = layers.size() - 1;
        while (i >= 0) {
            RfDefElement layer = layers.get(i);
            if (layer.getClass() == clazz) {
                return true;
            }
            --i;
        }
        return false;
    }

    public RfStructMember getLocalMember(FullName fullName, int kind) {
        Map rawMembers = this.getAllMembersOfType(kind);
        return (RfStructMember)this.getLocalMember(rawMembers, fullName);
    }

    @Override
    public IRfNamedElement getLocalMember(Set<Class<? extends IRfNamedElement>> classes, String name, IRfNamedElement exclude) {
        FullName fullName = new FullName(name, new Determinant(new String[]{this.getName()}));
        return this.getLocalMember(classes, fullName, exclude);
    }

    private IRfNamedElement getLocalMember(Set<Class<? extends IRfNamedElement>> classes, FullName fullName, IRfNamedElement exclude) {
        RfStructMember result = null;
        if ((classes.contains(RfMethod.class) || classes.contains(RfPredefinedMethod.class) || classes.contains(RfPseudoMethod.class)) && (result = this.getLocalMember(fullName, 1)) == exclude) {
            result = null;
        }
        if (result == null && (classes.contains(RfField.class) || classes.contains(RfPredefinedField.class)) && (result = this.getLocalMember(fullName, 2)) == exclude) {
            result = null;
        }
        if (result == null && (classes.contains(RfEvent.class) || classes.contains(RfPredefinedEvent.class)) && (result = this.getLocalMember(fullName, 5)) == exclude) {
            result = null;
        }
        if (result == null && classes.contains(RfExpect.class) && (result = this.getLocalMember(fullName, 6)) == exclude) {
            result = null;
        }
        if (result == null && classes.contains(RfConstraint.class) && (result = this.getLocalMember(fullName, 7)) == exclude) {
            result = null;
        }
        return result;
    }

    public boolean isUnit() {
        if (this.fKind == KIND.SLN_COMPONENT) {
            return true;
        }
        return this.fIsUnit;
    }

    public void setKind(KIND kind) {
        this.fKind = kind;
    }

    public boolean isInterface() {
        return this.fKind == KIND.INTERFACE;
    }

    public boolean isPotentialUnit() {
        return this.fIsPotentialUnit;
    }

    public int addMethodsToList(List<RfNamedElement> elements) {
        List<RfStructMember> methods = this.getMethods();
        elements.addAll(methods);
        return methods.size();
    }

    public int addFieldsToList(List<RfNamedElement> elements) {
        List<RfStructMember> fields = this.getFields();
        elements.addAll(fields);
        return fields.size();
    }

    public int addEventsToList(List<RfNamedElement> elements) {
        List<RfStructMember> events = this.getEvents();
        elements.addAll(events);
        return events.size();
    }

    public int addExpectsToList(List<RfNamedElement> elements) {
        List<RfStructMember> expects = this.getExpects();
        elements.addAll(expects);
        return expects.size();
    }

    @Override
    public String getContextType() {
        return "ro.amiq.edt.templates.contextType.struct_member";
    }

    @Override
    public void setTransientDeterminant(Determinant determinant) {
        this.fTransientDeterminant = determinant;
    }

    @Override
    public Determinant getTransientDeterminant() {
        if (this.fTransientDeterminant != null) {
            return this.fTransientDeterminant;
        }
        return this.getDeterminant();
    }

    @Override
    public List<RfField> getFieldsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        List<RfField> fields = this.getMembersWithPrefix(false, 2, this.getTransientDeterminant(), packageName, enclosingStruct, matchType, prefix, accessModifiers);
        if (fields == null || fields.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < fields.size()) {
            RfField field = fields.get(i);
            List fieldTCs = this.getMembersWithPrefix(false, 3, this.getTransientDeterminant(), packageName, enclosingStruct, 1, field.getName(), 31);
            if (fieldTCs != null && !fieldTCs.isEmpty()) {
                RfField clone = ((RfField)fieldTCs.get(0)).newField();
                clone.setLayersContainer(field.getLayersContainer());
                clone.setFullName(field.getFullName());
                fields.set(i, clone);
            }
            ++i;
        }
        return fields;
    }

    @Override
    public RfField getFieldWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        List<RfField> result = this.getFieldsWithPrefix(packageName, enclosingStruct, matchType, prefix, accessModifiers);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    @Override
    public List<RfMethod> getMethodsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        return this.getMembersWithPrefix(false, 1, this.getTransientDeterminant(), packageName, enclosingStruct, matchType, prefix, accessModifiers);
    }

    @Override
    public RfMethod getMethodWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        List<RfMethod> result = this.getMethodsWithPrefix(packageName, enclosingStruct, matchType, prefix, accessModifiers);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    public <T extends RfStructMember> List<T> getMembersWithPrefix(boolean allSubtypes, int membersKind, Determinant determinant, String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        try {
            RfStruct parentStruct;
            if (enclosingStruct != null && (accessModifiers & 4) == 4 && !enclosingStruct.isLike(this.getName())) {
                accessModifiers -= 4;
            }
            if (enclosingStruct != null && (accessModifiers & 2) == 2 && !enclosingStruct.isLike(this.getName())) {
                accessModifiers -= 2;
            }
            NullProtectedList<T> result = null;
            determinant = determinant == null ? this.getTransientDeterminant() : determinant;
            Map<String, ListContainer<T>> rawMembers = this.getAllMembersOfType(membersKind);
            List<T> localMembers = this.getAll(rawMembers, prefix, (matchType & 1) != 0);
            if (localMembers != null && !localMembers.isEmpty()) {
                for (RfStructMember member : localMembers) {
                    if ((member.getAccessModifier() & accessModifiers) == 0 || (accessModifiers & 1) == 0 && member instanceof RfMethod && ("copy".equals(member.getName()) || "to_string".equals(member.getName())) && member.isPredefined() || packageName != null && member.isPackage() && !member.getPackageName().equals(packageName) || packageName != null && member.isPrivate() && !member.getPackageName().equals(packageName) || !DVTStringUtil.regionMatches((String)member.getName(), (String)prefix, (int)matchType) || !allSubtypes && determinant != null && !determinant.equals(member.getFullName().getDeterminant()) && !determinant.contains(member.getFullName().getDeterminant())) continue;
                    if (result == null) {
                        result = new NullProtectedList<T>();
                    }
                    if (member instanceof RfMethod && ((RfMethod)member).hasMethodInLikeParent() || member instanceof RfEvent && ((RfEvent)member).hasEventInLikeParent(RfEventLayer.class)) continue;
                    result.add(member);
                    if ((matchType & 1) == 0) continue;
                    return result;
                }
            }
            if ((parentStruct = this.getParentStruct()) != null) {
                List<T> members;
                if ((accessModifiers & 1) == 1) {
                    --accessModifiers;
                }
                if ((members = parentStruct.getMembersWithPrefix(false, membersKind, null, packageName, enclosingStruct, matchType, prefix, accessModifiers)) == null) {
                    return result;
                }
                if (result == null) {
                    return members;
                }
                result.addAll(members);
            }
            return result;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void getStructQualifierCandidates(RfProject project, List<RfStructQualifier> result, String packageName, String enumName, String fieldOrEnumName, Determinant determinant, int accessModifiers, int moduleIndex, LineInfo lineInfo, ParserPath parserPath) {
        RfStructQualifier[] templateDummyCandidate = new RfStructQualifier[1];
        this.getStructQualifierCandidates(project, result, templateDummyCandidate, packageName, enumName, fieldOrEnumName, determinant, accessModifiers, moduleIndex, lineInfo, parserPath);
        if (result.isEmpty() && templateDummyCandidate[0] != null) {
            result.add(templateDummyCandidate[0]);
        }
    }

    private final void getStructQualifierCandidates(RfProject project, List<RfStructQualifier> result, RfStructQualifier[] templateDummyCandidate, String packageName, String enumName, String fieldOrEnumName, Determinant determinant, int accessModifiers, int moduleIndex, LineInfo lineInfo, ParserPath parserPath) {
        try {
            RfStruct parentStruct;
            if (this.fFields != null && !this.fFields.isEmpty()) {
                ListContainer<RfStructMember> candidates;
                boolean isFullyQualified = enumName != null;
                Collection<Object> fieldsList = null;
                fieldsList = isFullyQualified ? ((candidates = this.fFields.get(fieldOrEnumName)) == null ? Collections.emptyList() : Collections.singletonList(candidates)) : this.fFields.values();
                for (ListContainer<RfStructMember> fields : fieldsList) {
                    for (RfStructMember field : fields) {
                        RfEnum enumItem;
                        Determinant fieldDeterminant;
                        String assocTypeName;
                        if (this.illegalAccess(packageName, accessModifiers, field) || field.getAssociatedTypeList() != 0) continue;
                        RfType assocType = field.getAssociatedBaseType();
                        String fieldName = field.getName();
                        if (this instanceof RfTemplateStruct && assocType instanceof RfTemplateParam) {
                            RfEnum enumItem2;
                            if (isFullyQualified) {
                                enumItem2 = new RfEnum(project, enumName, null);
                                result.add(new RfStructQualifier(project, enumItem2, (RfField)field));
                                return;
                            }
                            if (fieldOrEnumName.equals(fieldName)) {
                                enumItem2 = new RfEnum(project, "TRUE", null);
                                result.add(new RfStructQualifier(project, enumItem2, (RfField)field));
                                return;
                            }
                            enumItem2 = new RfEnum(project, fieldOrEnumName, null);
                            templateDummyCandidate[0] = new RfStructQualifier(project, enumItem2, (RfField)field);
                            continue;
                        }
                        if (assocType == null || !(assocType instanceof RfScalarType) || !((RfScalarType)assocType).isEnumType() || !"bool".equals(assocTypeName = assocType.getName()) && RfPredefinedScalar.NOT_ENUMS_FOR_AS_COMPUTED.contains(assocTypeName)) continue;
                        RfDefElement declaration = field.getDeclaration();
                        if (!project.importedBySameTest(parserPath, (List<RfDefElement>)field.getDeclarations()) || !this.memberOf(determinant, fieldDeterminant = field.getFullName().getDeterminant())) continue;
                        if (fieldOrEnumName.equals(fieldName)) {
                            if (isFullyQualified) {
                                enumItem = ((RfScalarType)assocType).getEnum(project, enumName, moduleIndex, parserPath);
                                result.add(new RfStructQualifier(project, enumItem, (RfField)field));
                                return;
                            }
                            if ("bool".equals(assocTypeName)) {
                                enumItem = ((RfScalarType)assocType).getEnum(project, "TRUE", moduleIndex, parserPath);
                                result.add(new RfStructQualifier(project, enumItem, (RfField)field));
                                if (result.size() != 2) continue;
                                return;
                            }
                            enumItem = ((RfScalarType)assocType).getEnum(project, fieldOrEnumName, moduleIndex, parserPath);
                            if (enumItem == null) continue;
                            result.add(new RfStructQualifier(project, enumItem, (RfField)field));
                            if (result.size() != 2) continue;
                            return;
                        }
                        if (isFullyQualified || (enumItem = ((RfScalarType)assocType).getEnum(project, fieldOrEnumName, moduleIndex, parserPath)) == null) continue;
                        result.add(new RfStructQualifier(project, enumItem, (RfField)field));
                        if (result.size() != 2) continue;
                        return;
                    }
                }
            }
            if ((parentStruct = this.getParentStruct()) != null) {
                parentStruct.getStructQualifierCandidates(project, result, packageName, enumName, fieldOrEnumName, null, accessModifiers, moduleIndex, null, parserPath);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public RfNamedElement semanticGetMember(RfProject project, Determinant determinant, String packageName, RfStruct enclosingStruct, String name, EnumSet<IRfNamedElement.ElementKind> allowedElements, int accessModifiers, int maxModuleIndex, ParserPath parserPath, RfNamedElement exclude) {
        try {
            RfStruct sdlAgent;
            ListContainer<RfStructMember> subMembers;
            RfPredefinedField result;
            if (allowedElements.contains(IRfNamedElement.ElementKind.E_METHOD) && "copy".equals(name)) {
                return RfPredefinedMethod.createCopyMethod(project, this, determinant);
            }
            if (allowedElements.contains(IRfNamedElement.ElementKind.E_FIELD) && "comp".equals(name) && (result = this.getCompImplicitVariable(project, 1, name)) != null) {
                return result;
            }
            RfStructMember privateOrPackageErrorResult = null;
            Determinant propertyDeterminant = null;
            ArrayList localMembers = new ArrayList();
            if (allowedElements.contains(IRfNamedElement.ElementKind.E_FIELD) || allowedElements.contains(IRfNamedElement.ElementKind.E_FIELD_TC_ONLY)) {
                ListContainer<RfStructMember> propertyConstraints;
                if (this.fFieldPCs != null && (propertyConstraints = this.fFieldPCs.get(name)) != null && !propertyConstraints.isEmpty() && determinant != null && determinant.toArray().length > 1) {
                    propertyDeterminant = new Determinant(determinant.toArray());
                    for (Object propertyConstraint : propertyConstraints) {
                        propertyDeterminant = ((RfFieldPropConstraint)propertyConstraint).translateDeterminant(propertyDeterminant);
                    }
                }
                if (this.fFieldTCs != null && (subMembers = this.fFieldTCs.get(name)) != null && !subMembers.isEmpty()) {
                    localMembers.addAll(OptimizedUtils.asList(subMembers, (boolean)false));
                }
            }
            if (this.fFields != null && (allowedElements.contains(IRfNamedElement.ElementKind.E_FIELD) || allowedElements.contains(IRfNamedElement.ElementKind.E_FIELD_ONLY)) && (subMembers = this.fFields.get(name)) != null && !subMembers.isEmpty()) {
                localMembers.addAll(OptimizedUtils.asList(subMembers, (boolean)false));
            }
            if (this.fEvents != null && allowedElements.contains(IRfNamedElement.ElementKind.E_EVENT) && (subMembers = this.fEvents.get(name)) != null && !subMembers.isEmpty()) {
                localMembers.addAll(OptimizedUtils.asList(subMembers, (boolean)false));
            }
            if (this.fMethods != null && allowedElements.contains(IRfNamedElement.ElementKind.E_METHOD) && (subMembers = this.fMethods.get(name)) != null && !subMembers.isEmpty()) {
                localMembers.addAll(OptimizedUtils.asList(subMembers, (boolean)false));
            }
            for (RfStructMember member : localMembers) {
                List<RfDefElement> declarations;
                if (member == exclude || (member = project.filterDeclaredAfter(member, maxModuleIndex)) == null) continue;
                if (this instanceof RfListType) {
                    if (this.illegalAccess(packageName, enclosingStruct, accessModifiers, member)) {
                        privateOrPackageErrorResult = member;
                        continue;
                    }
                    return this.createMemberUsingPropertyConstraints(project, member, propertyDeterminant);
                }
                Determinant memberDeterminant = member.getFullName().getDeterminant();
                if (memberDeterminant.hasParameters() && (declarations = member.getLayers()) != null && !declarations.isEmpty() && declarations.get(0) instanceof RfMethodLayer) {
                    memberDeterminant = ((RfMethodLayer)declarations.get(0)).getDeterminant();
                }
                if (!this.memberOf(determinant, memberDeterminant)) continue;
                if (this.illegalAccess(packageName, enclosingStruct, accessModifiers, member)) {
                    privateOrPackageErrorResult = member;
                    continue;
                }
                return this.createMemberUsingPropertyConstraints(project, member, propertyDeterminant);
            }
            List<RfStruct> parentStructs = this.getParentStructsAndInterfaces();
            if (parentStructs != null && !parentStructs.isEmpty()) {
                for (RfStruct parentStruct : parentStructs) {
                    RfNamedElement result2;
                    if (parentStruct != null) {
                        RfNamedElement member = parentStruct.semanticGetMember(project, parentStruct.getDeterminant(), packageName, enclosingStruct, name, allowedElements, accessModifiers, maxModuleIndex, parserPath, exclude);
                        result2 = this.createMemberUsingPropertyConstraints(project, member, propertyDeterminant);
                        if (result2 == null) continue;
                        if (!(result2 instanceof IllegalAccessError)) {
                            return result2;
                        }
                        if (privateOrPackageErrorResult != null) {
                            return new IllegalAccessError(project, privateOrPackageErrorResult);
                        }
                        return result2;
                    }
                    if (!(this.fParentStruct instanceof RfTemplateParam)) continue;
                    RfStruct knownParentStruct = this.getKnownParentStruct(project);
                    if (knownParentStruct != null && (result2 = knownParentStruct.semanticGetMember(project, determinant, packageName, enclosingStruct, name, allowedElements, accessModifiers, maxModuleIndex, parserPath, exclude)) != null) {
                        return result2;
                    }
                    return SemanticWalker.ERROR_SCOPE;
                }
            }
            if (privateOrPackageErrorResult != null) {
                return new IllegalAccessError(project, privateOrPackageErrorResult);
            }
            if (this.isSDLScenario() && (sdlAgent = this.getSDLEnclosingAgent()) != null) {
                return sdlAgent.semanticGetMember(project, propertyDeterminant, packageName, enclosingStruct, name, allowedElements, accessModifiers, maxModuleIndex, parserPath, exclude);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    private List<RfStruct> getParentStructsAndInterfaces() {
        List<RfStruct> parentInterfaces = this.getParentInterfaces();
        RfStruct parentStruct = this.getParentStruct();
        if (parentStruct == null) {
            return parentInterfaces;
        }
        if (parentInterfaces == null || parentInterfaces.isEmpty()) {
            return Collections.singletonList(parentStruct);
        }
        ArrayList<RfStruct> result = new ArrayList<RfStruct>(parentInterfaces.size() + 1);
        result.addAll(parentInterfaces);
        result.add(parentStruct);
        return result;
    }

    private RfStruct getKnownParentStruct(RfProject project) {
        RfStruct result = null;
        result = project.isInSLNMode() ? project.getTypesUtil().SLN_USER_STRUCT_TYPE() : (this.isUnit() ? project.getTypesUtil().ANY_UNIT_TYPE() : project.getTypesUtil().ANY_STRUCT_TYPE());
        if (result == this) {
            return null;
        }
        return result;
    }

    private boolean illegalAccess(String packageName, RfStruct enclosingStruct, int accessModifiers, RfStructMember member) {
        if ((member.getAccessModifier() & accessModifiers) == 0) {
            return true;
        }
        if ((member.isPackage() || member.isPrivate()) && packageName != null && !member.getPackageName().equals(packageName)) {
            return true;
        }
        return (member.isProtected() || member.isPrivate()) && enclosingStruct != null && !enclosingStruct.isLike(this.getName());
    }

    private boolean illegalAccess(String packageName, int accessModifiers, RfStructMember member) {
        if ((member.getAccessModifier() & accessModifiers) == 0) {
            return true;
        }
        return (member.isPackage() || member.isPrivate()) && packageName != null && !member.getPackageName().equals(packageName);
    }

    protected boolean memberOf(Determinant determinant, Determinant containedDeterminant) {
        return RfStruct.isMemberOf(determinant, containedDeterminant);
    }

    public static boolean isMemberOf(Determinant determinant, Determinant containedDeterminant) {
        if (determinant == null || containedDeterminant == null) {
            return true;
        }
        if (determinant.equals(containedDeterminant)) {
            return true;
        }
        return determinant.contains(containedDeterminant);
    }

    private final RfNamedElement createMemberUsingPropertyConstraints(RfProject project, RfNamedElement member, Determinant propertyDeterminant) {
        if (propertyDeterminant == null) {
            return member;
        }
        if (member instanceof RfStructMember) {
            Determinant assocDeterminant = ((IRfAssociatedType)((Object)member)).getAssociatedTypeDeterminant();
            IRfNamedElement assocType = ((IRfAssociatedType)((Object)member)).getAssociatedType();
            if (assocType instanceof RfListType) {
                int assocListDepth = ((RfListType)assocType).getAssociatedTypeList();
                String assocListKey = ((RfListType)assocType).getAssociatedTypeListKey();
                assocType = ((RfListType)assocType).getAssociatedBaseType();
                assocDeterminant = Determinant.merge(propertyDeterminant.toArray(), assocDeterminant.toArray());
                assocType = RfListType.listFromType(project, (RfType)assocType, assocDeterminant, assocListKey, assocListDepth);
            } else {
                assocDeterminant = Determinant.merge(propertyDeterminant.toArray(), assocDeterminant.toArray());
            }
            return new RfPropConstraint(project, assocType, assocDeterminant, (RfStructMember)member);
        }
        return member;
    }

    @Override
    public List<RfEvent> getEventsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        return this.getMembersWithPrefix(false, 5, this.getTransientDeterminant(), packageName, enclosingStruct, matchType, prefix, accessModifiers);
    }

    @Override
    public RfEvent getEventWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        List<RfEvent> result = this.getEventsWithPrefix(packageName, enclosingStruct, matchType, prefix, accessModifiers);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    @Override
    public List<RfExpect> getExpectsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        return this.getMembersWithPrefix(false, 6, this.getTransientDeterminant(), packageName, enclosingStruct, matchType, prefix, accessModifiers);
    }

    @Override
    public RfExpect getExpectWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        List<RfExpect> result = this.getExpectsWithPrefix(packageName, enclosingStruct, matchType, prefix, accessModifiers);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    @Override
    public List<RfVar> getVariablesWithPrefix(int line, int matchType, String prefix) {
        return null;
    }

    @Override
    public RfVar getVariableWithPrefix(int line, int matchType, String prefix) {
        return null;
    }

    @Override
    public List<RfArg> getArgumentsWithPrefix(int matchType, String prefix) {
        return null;
    }

    @Override
    public RfArg getArgumentWithPrefix(int matchType, String prefix) {
        return null;
    }

    @Override
    public RfMeImplicitVariable getMeImplicitVariable(int matchType, String prefix) {
        return this.getMeImplicitVariable(matchType, this.getDeterminant(), prefix);
    }

    public RfMeImplicitVariable getMeImplicitVariable(int matchType, Determinant determinant, String prefix) {
        try {
            if (this.fMeVariable != null && this.fMeVariable.getFullName() != null && DVTStringUtil.regionMatches((String)"me", (String)prefix, (int)matchType)) {
                this.fMeVariable.getFullName().setDeterminant(determinant);
                return this.fMeVariable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    @Override
    public RfPredefinedField getCompImplicitVariable(RfProject project, int matchType, String prefix) {
        try {
            if (this.isSLNAction() && DVTStringUtil.regionMatches((String)"comp", (String)prefix, (int)matchType)) {
                IRfScope parentComponent = this.getEnclosingScope();
                RfPredefinedField compField = new RfPredefinedField(project, this, "comp", parentComponent.getName(), false, true, false, "Parent component");
                compField.setAssociatedType((RfStruct)parentComponent);
                return compField;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    @Override
    public List<RfEnum> getEnumsWithPrefix(int matchType, String prefix) {
        return null;
    }

    @Override
    public RfEnum getEnumWithPrefix(int matchType, String prefix) {
        return null;
    }

    @Override
    public boolean isInGlobal() {
        return "global".equals(this.getName());
    }

    @Override
    protected void reorderLayers() {
        try {
            super.reorderLayers();
            for (RfStructMember method : this.getMethods()) {
                method.reorderLayers();
            }
            for (RfStructMember field : this.getFields()) {
                field.reorderLayers();
            }
            for (RfStructMember event : this.getEvents()) {
                event.reorderLayers();
            }
            for (RfStructMember expect : this.getExpects()) {
                expect.reorderLayers();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    protected void removeDirty(RfProject project, RfStruct packg, Iterator<RfType> structIterator) {
        try {
            boolean removeStruct = this.hasNoLayers();
            this.removeDirtyStructMembers(this.fMethods, removeStruct);
            this.removeDirtyStructMembers(this.fFields, removeStruct);
            this.removeDirtyStructMembers(this.fFieldTCs, removeStruct);
            this.removeDirtyStructMembers(this.fFieldPCs, removeStruct);
            this.removeDirtyStructMembers(this.fEvents, removeStruct);
            this.removeDirtyStructMembers(this.fExpects, removeStruct);
            this.removeDirtyStructMembers(this.fConstraints, removeStruct);
            if (removeStruct) {
                RfStruct parentStruct = this.getParentStruct();
                if (parentStruct != null) {
                    parentStruct.removeChildStruct(this);
                }
                if (this.getChildStructs() != null) {
                    for (RfStruct child : this.getChildStructs()) {
                        child.fParentStruct = null;
                    }
                }
                structIterator.remove();
            } else if (!this.isDeclaredIn(packg)) {
                String packageName;
                RfDefElement layer = this.getFirstLayer();
                if (layer != null && !(packageName = layer.getPackageName()).equals(packg.getPackageName())) {
                    packg = project.getPackage(packageName);
                    RfType type = packg.getType(this.getName());
                    if (type == null) {
                        packg.addType(this, true);
                    }
                    structIterator.remove();
                }
            } else if (this.isSLNComponent() || this.isSDLAgent()) {
                structIterator.remove();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected void removeDirtyStructMembers(Map<String, ListContainer<RfStructMember>> candidateMembers, boolean removeStruct) {
        if (candidateMembers == null) {
            return;
        }
        Iterator<Map.Entry<String, ListContainer<RfStructMember>>> candidatesIterator = candidateMembers.entrySet().iterator();
        while (candidatesIterator.hasNext()) {
            RfStructMember member;
            Map.Entry<String, ListContainer<RfStructMember>> membersEntries = candidatesIterator.next();
            ListContainer<RfStructMember> members = membersEntries.getValue();
            if (members instanceof List) {
                Iterator iterator = members.iterator();
                while (iterator.hasNext()) {
                    RfStructMember member2 = (RfStructMember)iterator.next();
                    if (member2.isLocalPredefined() || !member2.hasNoLayers()) continue;
                    iterator.remove();
                    if (members.isEmpty()) {
                        candidatesIterator.remove();
                    }
                    if (members.size() != 1) continue;
                    membersEntries.setValue((ListContainer<RfStructMember>)((ListContainer)members.get(0)));
                }
                continue;
            }
            if (!(members instanceof RfStructMember) || (member = (RfStructMember)members).isLocalPredefined() || !member.hasNoLayers()) continue;
            candidatesIterator.remove();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isLike(String name) {
        try {
            if (this.getName() != null && this.getName().equals(name)) {
                return true;
            }
            if (this.getParentName() != null && this.getParentName().equals(name)) {
                return true;
            }
            RfStruct parent = this;
            do {
                if ((parent = parent.getParentStruct()) != null) continue;
                return false;
            } while (parent.getParentName() == null || !parent.getParentName().equals(name));
            return true;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    @Override
    public RfDefElement getFirstLayer() {
        block4: {
            if (!this.hasNoLayers()) break block4;
            return null;
        }
        try {
            List<RfDefElement> layers = this.getLayers();
            for (RfDefElement layer : layers) {
                if (layer.getLayerKind() != 0) continue;
                return layer;
            }
            return layers.get(0);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void setIsUnit(boolean isUnit) {
        this.fIsUnit = isUnit;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isWhen() {
        try {
            RfDefElement layer;
            if (this.hasNoLayers()) {
                return false;
            }
            Iterator<RfDefElement> iterator = this.getLayers().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(layer = iterator.next()).isWhen());
            return true;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    protected void addEvent(RfEvent event) {
        if (this.fEvents == null) {
            this.fEvents = new LinkedHashMap<String, ListContainer<RfStructMember>>();
        }
        ListContainer events = this.get(this.fEvents, event.getName());
        ListContainer eventsNew = OptimizedUtils.listContainerAdd(events, (Object)event);
        this.update(this.fEvents, event.getName(), events, eventsNew);
    }

    protected void addField(RfField field) {
        if (this.fFields == null) {
            this.fFields = new LinkedHashMap<String, ListContainer<RfStructMember>>();
        }
        ListContainer fields = this.get(this.fFields, field.getName());
        ListContainer fieldsNew = OptimizedUtils.listContainerAdd(fields, (Object)field);
        this.update(this.fFields, field.getName(), fields, fieldsNew);
    }

    protected void addFieldTC(RfField field) {
        if (this.fFieldTCs == null) {
            this.fFieldTCs = new LinkedHashMap<String, ListContainer<RfStructMember>>();
        }
        ListContainer fields = this.get(this.fFieldTCs, field.getName());
        ListContainer fieldsNew = OptimizedUtils.listContainerAdd(fields, (Object)field);
        this.update(this.fFieldTCs, field.getName(), fields, fieldsNew);
    }

    protected void addFieldPC(RfField field) {
        if (this.fFieldPCs == null) {
            this.fFieldPCs = new LinkedHashMap<String, ListContainer<RfStructMember>>();
        }
        ListContainer fields = this.get(this.fFieldPCs, field.getName());
        ListContainer fieldsNew = OptimizedUtils.listContainerAdd(fields, (Object)field);
        this.update(this.fFieldPCs, field.getName(), fields, fieldsNew);
    }

    protected void addMethod(RfMethod method) {
        if (this.fMethods == null) {
            this.fMethods = new LinkedHashMap<String, ListContainer<RfStructMember>>();
        }
        ListContainer methods = this.get(this.fMethods, method.getName());
        ListContainer methodsNew = OptimizedUtils.listContainerAdd(methods, (Object)method);
        this.update(this.fMethods, method.getName(), methods, methodsNew);
    }

    protected void addExpect(RfExpect expect) {
        if (this.fExpects == null) {
            this.fExpects = new LinkedHashMap<String, ListContainer<RfStructMember>>();
        }
        ListContainer expects = this.get(this.fExpects, expect.getName());
        ListContainer expectsNew = OptimizedUtils.listContainerAdd(expects, (Object)expect);
        this.update(this.fExpects, expect.getName(), expects, expectsNew);
    }

    protected void addConstraint(RfConstraint constraint) {
        if (this.fConstraints == null) {
            this.fConstraints = new LinkedHashMap<String, ListContainer<RfStructMember>>();
        }
        ListContainer constraints = this.get(this.fConstraints, constraint.getName());
        ListContainer constraintsNew = OptimizedUtils.listContainerAdd(constraints, (Object)constraint);
        this.update(this.fConstraints, constraint.getName(), constraints, constraintsNew);
    }

    protected void addSDLRole(RfSDLRoleSM role) {
    }

    protected void addSDLInline(RfSDLInlineSM inline) {
    }

    protected final <T extends RfNamedElement> ListContainer<T> get(Map<String, ListContainer<T>> candidates, String name) {
        if (candidates == null) {
            return null;
        }
        ListContainer members = candidates.get(name);
        if (members == null) {
            members = ListContainer.emptyContainer();
            candidates.put(name, members);
        }
        return members;
    }

    protected final <T extends RfNamedElement> void update(Map<String, ListContainer<T>> candidates, String name, ListContainer<T> members, ListContainer<T> newMembers) {
        if (members == newMembers) {
            return;
        }
        if (candidates == null) {
            return;
        }
        candidates.put(name, newMembers);
    }

    private <T extends RfStructMember> List<T> getAll(Map<String, ListContainer<T>> candidates, String prefix, boolean equals) {
        if (candidates == null) {
            return Collections.emptyList();
        }
        if (equals) {
            ListContainer<T> result = this.get(candidates, prefix);
            return OptimizedUtils.asList(result, (boolean)false);
        }
        Collection<ListContainer<T>> values = candidates.values();
        ArrayList result = new ArrayList();
        for (ListContainer<T> value : values) {
            result.addAll(OptimizedUtils.asList(value, (boolean)false));
        }
        return result;
    }

    public String getSequenceItemName() {
        return this.fSequenceItemName;
    }

    public RfStruct getSequenceItem() {
        RfProject project = this.getRfProject();
        if (this.fSequenceItemName == null || project == null) {
            return null;
        }
        return (RfStruct)project.getType(this.getPackageName(), false, 1, this.fSequenceItemName, -1);
    }

    public String getSequenceDriverName() {
        return this.fSequenceDriverName;
    }

    public RfStruct getSequenceDriver() {
        RfProject project = this.getRfProject();
        if (this.fSequenceDriverName == null || project == null) {
            return null;
        }
        return (RfStruct)project.getType(this.getPackageName(), false, 1, this.fSequenceDriverName, -1);
    }

    public String getSequenceKindName() {
        return this.fSequenceKindName;
    }

    public RfScalarType getSequenceKind() {
        RfProject project = this.getRfProject();
        if (this.fSequenceKindName == null || project == null) {
            return null;
        }
        return (RfScalarType)project.getType(this.getPackageName(), false, 2, this.fSequenceKindName, -1);
    }

    public boolean isSequence() {
        return this.isLike("any_sequence");
    }

    public boolean isSequenceVirtual() {
        return this.fSequenceItemName == null;
    }

    @Override
    public RfField get_field(__etools_string name) {
        RfField result = this.getField(new FullName(name.toString(), this.getDeterminant()));
        return result;
    }

    @Override
    public EList<RfField> get_fields() {
        EList<RfField> fields = new EList<RfField>();
        List<RfField> localFields = this.getFields(this.getPackageName(), this.getDeterminant(), true, 31);
        fields.addAll(localFields);
        return fields;
    }

    @Override
    public EList<RfField> get_declared_fields() {
        EList<RfField> fields = new EList<RfField>();
        List<RfField> localFields = this.getFields(this.getPackageName(), this.getDeterminant(), false, 31);
        fields.addAll(localFields);
        return fields;
    }

    @Override
    public RfMethod get_method(__etools_string name) {
        RfMethod result = this.getMethod(new FullName(name.toString(), this.getDeterminant()));
        return result;
    }

    @Override
    public EList<RfMethod> get_methods() {
        EList<RfMethod> methods = new EList<RfMethod>();
        List<RfMethod> localMethods = this.getMethods(this.getPackageName(), this.getDeterminant(), true, 31);
        methods.addAll(localMethods);
        return methods;
    }

    @Override
    public EList<RfMethod> get_declared_methods() {
        EList<RfMethod> methods = new EList<RfMethod>();
        List<RfMethod> localMethods = this.getMethods(this.getPackageName(), this.getDeterminant(), false, 31);
        methods.addAll(localMethods);
        return methods;
    }

    @Override
    public RfEvent get_event(__etools_string name) {
        RfEvent result = this.getEvent(new FullName(name.toString(), this.getDeterminant()));
        return result;
    }

    @Override
    public EList<RfEvent> get_events() {
        EList<RfEvent> events = new EList<RfEvent>();
        List<RfEvent> localEvents = this.getEvents(this.getPackageName(), this.getDeterminant(), true, 31);
        events.addAll(localEvents);
        return events;
    }

    @Override
    public EList<RfEvent> get_declared_events() {
        EList<RfEvent> events = new EList<RfEvent>();
        List<RfEvent> localEvents = this.getEvents(this.getPackageName(), this.getDeterminant(), false, 31);
        events.addAll(localEvents);
        return events;
    }

    @Override
    public boolean is_unit() {
        return this.fIsUnit;
    }

    @Override
    public RfStruct get_supertype() {
        return (RfStruct)this.fParentStruct;
    }

    @Override
    public RfStruct get_sequence_type() {
        RfField sequenceField = this.getField(new FullName("parent_sequence", this.getDeterminant()));
        if (sequenceField == null) {
            return null;
        }
        RfStruct result = null;
        try {
            RfType candidate = sequenceField.getAssociatedType();
            if (candidate instanceof RfStruct) {
                result = (RfStruct)candidate;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    @Override
    public EList<RfWhenSubtype> get_when_subtypes() {
        EList<RfWhenSubtype> result = new EList<RfWhenSubtype>();
        List<RfStructLayer> subtypeLayers = this.getSubTypeLayers();
        RfProject project = this.getRfProject();
        for (RfStructLayer subtypeLayer : subtypeLayers) {
            result.add(new RfWhenSubtype(project, subtypeLayer));
        }
        return result;
    }

    @Override
    public EList<RfStruct> get_all_like_subtypes() {
        EList<RfStruct> result = new EList<RfStruct>();
        ArrayList<RfStruct> result2 = new ArrayList<RfStruct>();
        this.collectAllChildrenStructs(this, result2);
        result.addAll(result2);
        return result;
    }

    protected void collectAllChildrenStructs(RfStruct parent, List<RfStruct> result) {
        List<RfStruct> children = parent.getChildStructs();
        if (children == null || children.isEmpty()) {
            return;
        }
        for (RfStruct rfStruct : children) {
            result.add(rfStruct);
            this.collectAllChildrenStructs(rfStruct, result);
        }
    }

    public RfScalarType get_kind() {
        return this.getSequenceKind();
    }

    public void toClassEncap(RfProject rfProject, int sliceNumber, int sliceSize, StringBuilder javaCode, Set<RfType> references, String javaName, String javaClassParams, RfStruct parentStruct, List<RfStructMember> fields, List<RfStructMember> methods) {
        String javaParentClassName = "";
        String javaParentClassParams = "";
        boolean lastSlice = false;
        if (sliceNumber * sliceSize >= fields.size()) {
            lastSlice = true;
        }
        if (sliceNumber > 1) {
            javaParentClassName = String.valueOf(javaName) + "__subclass__" + Integer.toString(sliceNumber - 1);
            javaParentClassParams = javaClassParams;
        } else {
            javaParentClassName = parentStruct != null ? parentStruct.javaName() : "base_class";
        }
        if (!lastSlice) {
            javaName = String.valueOf(javaName) + "__subclass__" + Integer.toString(sliceNumber);
        }
        StringBuilder javaDeep = new StringBuilder();
        StringBuilder javaCopy = new StringBuilder();
        if (lastSlice) {
            javaCode.append("public ");
        }
        javaCode.append("class ").append(javaName).append(javaClassParams).append(" extends ").append(javaParentClassName).append(javaParentClassParams).append(" implements Serializable {\n\n");
        javaCode.append("    private static final long serialVersionUID = ").append(javaName.hashCode()).append("L;\n\n");
        javaCode.append("    private static ").append(javaName).append(" fInstance = new ").append(javaName).append("();\n");
        javaCode.append("    private transient ").append(javaName).append(" __etools_me = this;\n");
        StringBuilder javaInitCode = new StringBuilder();
        boolean isTemplateStruct = this.isTemplateStruct();
        ArrayList<TransientField> transientFields = new ArrayList<TransientField>();
        int i = (sliceNumber - 1) * sliceSize;
        while (i < fields.size() && i < sliceNumber * sliceSize) {
            RfStructMember field = fields.get(i);
            ClassEncap classEncap = field.toClassEncap(rfProject);
            if (classEncap != null) {
                ((RfField)field).toClassEncapInitField(false, javaInitCode);
                Collection<RfType> allRefered = classEncap.getRefered();
                if (allRefered != null) {
                    references.addAll(allRefered);
                }
                if (!isTemplateStruct) {
                    String fieldType = classEncap.getFieldType();
                    if (fieldType.equals("_Int") || fieldType.equals("Double")) {
                        javaDeep.append("        result.").append(classEncap.getFieldName()).append(" = new ").append(fieldType).append("(").append(classEncap.getFieldName()).append(");\n");
                    } else if (fieldType.equals("Boolean")) {
                        javaDeep.append("        result.").append(classEncap.getFieldName()).append(" = new ").append(fieldType).append("(").append(classEncap.getFieldName()).append(");\n");
                    } else if (fieldType.equals("__etools_string")) {
                        javaDeep.append("        result.").append(classEncap.getFieldName()).append(" = new ").append(fieldType).append("(").append(classEncap.getFieldName()).append(".toString());\n");
                    } else {
                        javaDeep.append("        result.").append(classEncap.getFieldName()).append(" = (").append(fieldType).append(") ").append(classEncap.getFieldName()).append(".clone_deep();\n");
                    }
                }
                javaCopy.append("        result.").append(classEncap.getFieldName()).append(" = ").append(classEncap.getFieldName()).append(";\n");
                javaCode.append("    public ").append(classEncap.getContent()).append(";\n");
                transientFields.addAll(classEncap.getTransientFields());
            }
            ++i;
        }
        javaCode.append("\n\n");
        if (lastSlice) {
            boolean isAutoTranslateDisable = BuildConfigManager.isAsComputedAutoMethodsTranslateDisable((IProject)rfProject.getProject());
            if (isAutoTranslateDisable) {
                IEProject eProject = rfProject.getModelManager().getEModel().getEProject(rfProject.getProject());
                Set<String> methods2translate = eProject.getAsComputedMethodsToTranslate(this.getPackageName(), this.getName());
                if (methods2translate != null) {
                    for (RfStructMember method : this.getMethods()) {
                        ClassEncap classEncap;
                        if (!methods2translate.contains(method.getName()) || (classEncap = method.toClassEncap(rfProject)) == null) continue;
                        Collection<RfType> allRefered = classEncap.getRefered();
                        if (allRefered != null) {
                            references.addAll(allRefered);
                        }
                        javaCode.append("\n    ").append(classEncap.getContent()).append("\n");
                    }
                }
            } else {
                for (RfStructMember method : methods) {
                    ClassEncap classEncap;
                    if (!((RfMethod)method).isAsComputedTranslate() || (classEncap = method.toClassEncap(rfProject)) == null) continue;
                    Collection<RfType> allRefered = classEncap.getRefered();
                    if (allRefered != null) {
                        references.addAll(allRefered);
                    }
                    javaCode.append("\n    ").append(classEncap.getContent()).append("\n");
                }
            }
        }
        javaCode.append("\n");
        javaCode.append("    public static ").append(javaName).append(" getDefaultValue() {\n");
        javaCode.append("        return fInstance;\n");
        javaCode.append("    }\n\n");
        javaCode.append("    public Object clone_deep() throws Exception {\n");
        javaCode.append("        ").append(javaName).append(" result = (").append(javaName).append(") super.clone_deep();\n");
        javaCode.append((CharSequence)javaDeep);
        javaCode.append("        return result;\n");
        javaCode.append("    }\n\n");
        javaCode.append("    public Object clone_copy() throws Exception {\n");
        javaCode.append("        ").append(javaName).append(" result = (").append(javaName).append(") super.clone_copy();\n");
        javaCode.append((CharSequence)javaCopy);
        javaCode.append("        return result;\n");
        javaCode.append("    }\n\n");
        javaCode.append("    private void initEvolvedClassNewFields(Set<String> restoredFields) {\n");
        javaCode.append("        __etools_me = this;\n");
        javaCode.append((CharSequence)javaInitCode);
        javaCode.append("    }\n");
        javaCode.append("    private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException {\n");
        javaCode.append("    \t Set<String> restoredFields = (Set<String>) in.readObject();\n");
        javaCode.append("    \t in.defaultReadObject();\n");
        for (TransientField transientField : transientFields) {
            javaCode.append("    \t ").append(transientField.name).append(" = (").append(transientField.typeName).append(") __etools_rf_manager.asComputedStore(in.readInt());\n");
        }
        javaCode.append("    \t initEvolvedClassNewFields(restoredFields);\n");
        javaCode.append("    }\n\n");
        javaCode.append("    private void writeObject(java.io.ObjectOutputStream out) throws IOException {\n");
        javaCode.append("    \t Set<String> existingFields = new HashSet<>();\n");
        javaCode.append("    \t Field[] fields = this.getClass().getDeclaredFields();\n");
        javaCode.append("    \t for (Field field : fields) {\n");
        javaCode.append("            existingFields.add(field.getName());\n");
        javaCode.append("    \t }\n");
        javaCode.append("    \t out.writeObject(existingFields);\n");
        javaCode.append("    \t out.defaultWriteObject();\n");
        for (TransientField transientField : transientFields) {
            javaCode.append("    \t out.writeInt(__etools_rf_manager.asComputedStore(").append(transientField.name).append("));\n");
        }
        javaCode.append("    }\n\n");
        javaCode.append("    public String getName() {\n");
        javaCode.append("        return \"").append(this.getName()).append("\";\n");
        javaCode.append("    }\n\n");
        javaCode.append("    public String getPackageName() {\n");
        javaCode.append("        return \"").append(this.getPackageName()).append("\";\n");
        javaCode.append("    }\n\n");
        javaCode.append("\n}\n\n");
    }

    @Override
    public ClassEncap toClassEncap(RfProject rfProject) {
        String name = this.getName();
        if (SemanticUtils.isSetName(rfProject, name)) {
            return null;
        }
        if ("rf_package".equals(name)) {
            return null;
        }
        if ("rf_value_holder".equals(name)) {
            return null;
        }
        if ("rf_sequence".equals(name) || "rf_bfm_sequence".equals(name) || "rf_virtual_sequence".equals(name)) {
            return null;
        }
        if ("rf_struct".equals(name) || "rf_like_struct".equals(name) || "rf_when_subtype".equals(name)) {
            return null;
        }
        if ("rf_string".equals(name)) {
            return null;
        }
        if ("rf_value_holder".equals(name)) {
            return null;
        }
        if ("rf_module".equals(name)) {
            return null;
        }
        if ("rf_type".equals(name)) {
            return null;
        }
        if ("rf_list_type".equals(name)) {
            return null;
        }
        if ("rf_scalar".equals(name) || "rf_enum".equals(name) || "rf_enum_item".equals(name) || "rf_numeric".equals(name)) {
            return null;
        }
        if ("rf_field".equals(name) || "rf_event".equals(name)) {
            return null;
        }
        if ("rf_method".equals(name)) {
            return null;
        }
        HashSet<RfType> references = new HashSet<RfType>();
        String javaName = this.javaName();
        RfStruct parentStruct = this.getParentStruct();
        if (parentStruct != null) {
            references.add(parentStruct);
        }
        StringBuilder javaCode = new StringBuilder("package ").append("ro.amiq.edt.base.debug.ascomputed").append(";\n").append("import java.io.Serializable;\n").append("import java.util.*;\n").append("import static ro.amiq.edt.base.debug.ascomputed.__etools_main_global.*;\n").append("import java.io.IOException;\n").append("import java.lang.ClassNotFoundException;\n").append("import java.lang.reflect.Field;\n").append("import ro.amiq.edt.base.model.reflection.*;\n").append("import ro.amiq.edt.base.model.reflection.ascomputed.*;\n").append("import ro.amiq.etools.eparser.*;\n").append("import ro.amiq.edt.base.model.reflection.ascomputed.base.*;\n\n");
        List<RfStructMember> methods = this.getMethods();
        boolean newElementsToTranslate = this.javaTranslateMethods(rfProject, methods);
        List<RfStructMember> fields = this.getAsComputedUsedFields();
        String javaClassParams = this.javaClassParams();
        int nofFields = fields == null ? 0 : fields.size();
        int sliceNumber = 1;
        while ((sliceNumber - 1) * 2000 <= nofFields) {
            this.toClassEncap(rfProject, sliceNumber, 2000, javaCode, references, javaName, javaClassParams, parentStruct, fields, methods);
            ++sliceNumber;
        }
        EDTFileUtils.getInstance().dumpAsComputedDebug(rfProject.getProject(), javaName, javaCode.toString());
        return new ClassEncap(javaCode.toString(), references, newElementsToTranslate);
    }

    public boolean javaTranslateMethods(RfProject rfProject, List<RfStructMember> methods) {
        boolean isAutoTranslateDisable = BuildConfigManager.isAsComputedAutoMethodsTranslateDisable((IProject)rfProject.getProject());
        if (isAutoTranslateDisable) {
            return false;
        }
        Set alreadyTranslated = Collections.newSetFromMap(new IdentityHashMap());
        boolean newElementsToTranslate = false;
        IEProject eProject = rfProject.getPluginConfig().getModelManager().getEModel().getEProject(rfProject.getProject());
        if (eProject == null) {
            return false;
        }
        for (RfStructMember method : methods) {
            RfDefElement declaration;
            List<RfDefElement> layers;
            if (method instanceof RfPredefinedMethod && !"to_string".equals(method.getName()) || !((RfMethod)method).isAsComputedTranslate() || (layers = method.getLayers()) == null || layers.isEmpty() || (declaration = method.getDeclaration()) == null || alreadyTranslated.contains(method)) continue;
            alreadyTranslated.add((RfMethod)method);
            int i = 0;
            while (i < layers.size()) {
                RfMethodLayer layer = (RfMethodLayer)layers.get(i);
                newElementsToTranslate |= layer.javaTranslateMethodLayer(rfProject, eProject);
                ++i;
            }
        }
        return newElementsToTranslate;
    }

    public String javaClassParams() {
        return "";
    }

    @Override
    public String toString() {
        return this.getSignature();
    }

    @Override
    public Object get_key(String fieldName) {
        return this.getField(fieldName);
    }

    @Override
    public String javaName() {
        String name = this.getName();
        if ("rf_package".equals(name)) {
            return "RfStruct";
        }
        if ("rf_value_holder".equals(name)) {
            return "RfValueHolder";
        }
        if ("rf_sequence".equals(name) || "rf_bfm_sequence".equals(name) || "rf_virtual_sequence".equals(name)) {
            return "RfStruct";
        }
        if ("rf_struct".equals(name) || "rf_like_struct".equals(name)) {
            return "RfStruct";
        }
        if ("rf_structural_element".equals(name)) {
            return "RfStruct";
        }
        if ("rf_string".equals(name)) {
            return "RfStringType";
        }
        if ("rf_value_holder".equals(name)) {
            return "RfNamedElement";
        }
        if ("rf_module".equals(name)) {
            return "RfModule";
        }
        if ("rf_method".equals(name)) {
            return "RfMethod";
        }
        if ("rf_field".equals(name) || "rf_event".equals(name)) {
            return "RfField";
        }
        if ("rf_when_subtype".equals(name)) {
            return "RfWhenSubtype";
        }
        if ("rf_type".equals(name)) {
            return "RfType";
        }
        if ("rf_scalar".equals(name) || "rf_bool".equals(name) || "rf_enum".equals(name) || "rf_enum_item".equals(name)) {
            return "RfScalarType";
        }
        if ("rf_macro".equals(name)) {
            return "IRfType";
        }
        return super.javaName();
    }

    @Override
    public IRfNamedElement getMember(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, boolean isFirst, boolean isLast, boolean includeEnums, boolean isOnlyType, boolean skipParents) {
        if (this.fKind == KIND.PACKAGE || this.fKind == KIND.SLN_COMPONENT || this.fKind == KIND.SDL_AGENT) {
            return this.fTypes.get(name);
        }
        return this.getLocalMember(classes, name, exclude);
    }

    @Override
    public IRfNamedElement elementPathMember(String name, boolean isFirst, boolean isLast, boolean includeEnums, boolean isOnlyType, IRfNamedElement bindInstanceScope, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, ParserPath parserPath, int line) {
        int indexOfDot = name.indexOf(".");
        if (indexOfDot == -1) {
            return null;
        }
        name = name.replace('-', ' ');
        String memberName = name.substring(indexOfDot + 1);
        Determinant membersDeterminant = new Determinant(name.substring(0, indexOfDot));
        FullName fullName = new FullName(memberName, membersDeterminant);
        return this.getLocalMember(classes, fullName, exclude);
    }

    @Override
    public IRfScope getEnclosingScope() {
        if (this.fSLNEnclosingComponent == null && this.fSDLEnclosingAgent == null) {
            return super.getEnclosingScope();
        }
        if (this.fSDLEnclosingAgent == null) {
            return this.fSLNEnclosingComponent;
        }
        return this.fSDLEnclosingAgent;
    }

    @Override
    public String getPackageName() {
        if (this.fKind == KIND.SLN_COMPONENT || this.fKind == KIND.PACKAGE || this.fKind == KIND.SDL_AGENT) {
            return this.getName();
        }
        return super.getPackageName();
    }

    @Override
    protected boolean isDeclaredIn(RfStruct packg) {
        if (this.isSDLScenario()) {
            return packg != null && this.fSDLEnclosingAgent != null && packg.getName().equals(this.fSDLEnclosingAgent.getName());
        }
        if (this.isSLNAction()) {
            return packg != null && this.fSLNEnclosingComponent != null && packg.getName().equals(this.fSLNEnclosingComponent.getName());
        }
        return super.isDeclaredIn(packg);
    }

    public boolean isSLNComponent() {
        return this.fKind == KIND.SLN_COMPONENT;
    }

    public boolean isSDLAgent() {
        return this.fKind == KIND.SDL_AGENT;
    }

    public boolean isSDLRole() {
        return this.fKind == KIND.SDL_ROLE;
    }

    protected void addSLNAction(RfStruct slnAction, boolean incremental) {
        slnAction.setSLNEnclosingComponent(this);
        this.addType(slnAction, true);
    }

    protected void addSDLScenario(RfStruct sdlScenario) {
        sdlScenario.setSDLEnclosingAgent(this);
        this.addType(sdlScenario, true);
    }

    public RfStruct getSLNAction(String name) {
        RfStruct struct = this;
        RfStruct slnAction = null;
        if (name != null && this.isSLNComponent()) {
            while (slnAction == null && struct != null) {
                RfType candidate = this.getType(name);
                if (candidate instanceof RfStruct && ((RfStruct)candidate).isSLNAction()) {
                    slnAction = (RfStruct)candidate;
                }
                struct = struct.getParentStruct();
            }
        }
        return slnAction;
    }

    public List<RfStruct> getSDLScenarios() {
        ArrayList<RfStruct> result = new ArrayList<RfStruct>();
        if (this.isSDLAgent()) {
            RfStruct struct = this;
            while (struct != null) {
                Collection<RfType> candidates = struct.getTypes();
                for (RfType candidate : candidates) {
                    if (!(candidate instanceof RfStruct) || !((RfStruct)candidate).isSDLScenario()) continue;
                    result.add((RfStruct)candidate);
                }
                struct = struct.getParentStruct();
            }
        }
        return result;
    }

    public RfStruct getSDLScenario(String name) {
        RfStruct struct = this;
        RfStruct sdlScenario = null;
        if (name != null && this.isSDLAgent()) {
            while (sdlScenario == null && struct != null) {
                RfType candidate = this.getType(name);
                if (candidate instanceof RfStruct && ((RfStruct)candidate).isSDLScenario()) {
                    sdlScenario = (RfStruct)candidate;
                }
                struct = struct.getParentStruct();
            }
        }
        return sdlScenario;
    }

    public List<RfStruct> getLocalSLNActions() {
        ArrayList<RfStruct> result = new ArrayList<RfStruct>();
        if (this.isSLNComponent()) {
            Collection<RfType> candidates = this.getTypes();
            for (RfType candidate : candidates) {
                if (!(candidate instanceof RfStruct) || !((RfStruct)candidate).isSLNAction()) continue;
                result.add((RfStruct)candidate);
            }
        }
        return result;
    }

    public List<RfType> getLocalSLNTypes() {
        ArrayList<RfType> result = new ArrayList<RfType>();
        if (this.isSLNComponent()) {
            Collection<RfType> candidates = this.getTypes();
            for (RfType candidate : candidates) {
                if (candidate instanceof RfScalarType) {
                    result.add(candidate);
                    continue;
                }
                if (!(candidate instanceof RfStruct) || !((RfStruct)candidate).isSLNAction()) continue;
                result.add(candidate);
            }
        }
        return result;
    }

    public List<RfStruct> getLocalSDLScenarios() {
        ArrayList<RfStruct> result = new ArrayList<RfStruct>();
        if (this.isSDLAgent()) {
            Collection<RfType> candidates = this.getTypes();
            for (RfType candidate : candidates) {
                if (!(candidate instanceof RfStruct) || !((RfStruct)candidate).isSDLScenario()) continue;
                result.add((RfStruct)candidate);
            }
        }
        return result;
    }

    protected void addModuleReference(ParserPath parserPath) {
        if (!this.fParserPaths.contains(parserPath) && !this.getName().equals("main")) {
            this.fParserPaths.add(parserPath);
        }
    }

    protected void removeModuleReference(ParserPath parserPath) {
        this.fParserPaths.remove(parserPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RfType getType(String name) {
        if ((this.isSLNComponent() || this.isSDLAgent()) && name.equals(this.getName())) {
            return this;
        }
        Map<String, RfType> map = this.fTypes;
        synchronized (map) {
            RfType result = this.fTypes.get(name);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RfType> getTypes() {
        Map<String, RfType> map = this.fTypes;
        synchronized (map) {
            return this.fTypes.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rearrangeLayers() {
        Map<String, RfType> map = this.fTypes;
        synchronized (map) {
            for (RfType type : this.fTypes.values()) {
                if (!(type instanceof RfStruct)) continue;
                ((RfStruct)type).reorderLayers();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addType(RfType type, boolean overwrite) {
        String typeName = type.getName();
        if (overwrite) {
            Map<String, RfType> map = this.fTypes;
            synchronized (map) {
                this.fTypes.put(typeName, type);
            }
            return;
        }
        RfType temp = this.getType(typeName);
        if (temp == null) {
            Map<String, RfType> map = this.fTypes;
            synchronized (map) {
                this.fTypes.put(typeName, type);
            }
        }
    }

    public boolean isDirty() {
        if (this.isPredefined()) {
            return false;
        }
        if ((this.isSLNComponent() || this.isSDLAgent()) && !this.hasNoDefs(false)) {
            return false;
        }
        return this.fParserPaths.isEmpty() && this.fTypes.isEmpty() && !this.getName().equals("main");
    }

    public static boolean isPackageElement(Object packageCandidate, boolean includeSLNComponent) {
        if (packageCandidate instanceof RfStruct) {
            if (((RfStruct)packageCandidate).fKind == KIND.PACKAGE) {
                return true;
            }
            if (includeSLNComponent && ((RfStruct)packageCandidate).fKind == KIND.SLN_COMPONENT) {
                return true;
            }
            if (includeSLNComponent && ((RfStruct)packageCandidate).fKind == KIND.SDL_AGENT) {
                return true;
            }
        }
        return false;
    }

    public boolean isSLNAction() {
        return this.fKind == KIND.SLN_ACTION;
    }

    public boolean isSDLScenario() {
        return this.fKind == KIND.SDL_SCENARIO;
    }

    public void setSLNEnclosingComponent(RfStruct component) {
        this.fSLNEnclosingComponent = component;
    }

    public void setSDLEnclosingAgent(RfStruct agent) {
        this.fSDLEnclosingAgent = agent;
    }

    public RfStruct getSLNEnclosingComponent() {
        return this.fSLNEnclosingComponent;
    }

    public RfStruct getSDLEnclosingAgent() {
        return this.fSDLEnclosingAgent;
    }

    public void setSLNCompoundActionBlockLayer(RfActionBlockLayer fCompoundActionBlock) {
        this.fSLNCompoundActionBlockLayer = fCompoundActionBlock;
    }

    public RfNamedElement slnSemanticGetActionLabel(RfProject project, String name, LineInfo lineInfo) {
        if (this.fSLNCompoundActionBlockLayer != null) {
            return this.fSLNCompoundActionBlockLayer.slnSemanticGetActionLabel(project, name, lineInfo);
        }
        return null;
    }

    public RfField getSDLParam(int index) {
        if (this.fFields != null) {
            List<RfStructMember> fields = this.getFields();
            int paramIndex = 0;
            for (RfStructMember field : fields) {
                RfField potentialParam;
                if (!(field instanceof RfField) || !(potentialParam = (RfField)field).isSDLParam() || ++paramIndex != index) continue;
                return potentialParam;
            }
        }
        return null;
    }

    public RfField getSDLParam(String name) {
        if (name == null) {
            return null;
        }
        if (this.fFields != null) {
            List<RfStructMember> fields = this.getFields();
            for (RfStructMember field : fields) {
                RfField potentialParam;
                if (!(field instanceof RfField) || !(potentialParam = (RfField)field).isSDLParam() || !name.equals(potentialParam.getName())) continue;
                return potentialParam;
            }
        }
        return null;
    }

    public List<RfField> getSDLParams() {
        ArrayList<RfField> result = new ArrayList<RfField>();
        HashSet<String> duplicates = new HashSet<String>();
        if (this.fFields != null) {
            List<RfStructMember> fields = this.getFields();
            for (RfStructMember field : fields) {
                RfField potentialParam;
                if (!(field instanceof RfField) || !(potentialParam = (RfField)field).isSDLParam() || duplicates.contains(potentialParam.getName())) continue;
                result.add(potentialParam);
                duplicates.add(potentialParam.getName());
            }
        }
        return result;
    }

    public List<String> getSDLParamNames() {
        ArrayList<String> result = new ArrayList<String>();
        HashSet<String> duplicates = new HashSet<String>();
        if (this.fFields != null) {
            List<RfStructMember> fields = this.getFields();
            for (RfStructMember field : fields) {
                RfField potentialParam;
                if (!(field instanceof RfField) || !(potentialParam = (RfField)field).isSDLParam() || duplicates.contains(potentialParam.getName())) continue;
                result.add(potentialParam.getName());
                duplicates.add(potentialParam.getName());
            }
        }
        return result;
    }

    public String getSDLParamsAsString() {
        StringBuilder result = new StringBuilder();
        HashSet<String> duplicates = new HashSet<String>();
        if (this.fFields != null) {
            List<RfStructMember> fields = this.getFields();
            for (RfStructMember field : fields) {
                RfField potentialParam;
                if (!(field instanceof RfField) || !(potentialParam = (RfField)field).isSDLParam() || duplicates.contains(potentialParam.getName())) continue;
                if (result.length() != 0) {
                    result.append(", ");
                }
                result.append(potentialParam.getName()).append(": ").append(potentialParam.getAssociatedTypeName());
                duplicates.add(potentialParam.getName());
            }
        }
        return result.toString();
    }

    public List<RfSDLInlineSMLayer> getSDLInlineLayers() {
        return Collections.emptyList();
    }

    public boolean isSLNToken() {
        return this.fKind == KIND.SLN_TOKEN;
    }

    public boolean isSLNStruct() {
        return this.fKind == KIND.SLN_STRUCT;
    }

    public void addImplicitWhenSubtypeLayer(RfDefElement layer) {
    }

    public void removeImplicitWhenSubtypeLayer(RfDefElement layer) {
    }

    public RfStruct get_exact_subtype_of_instance(IRfType type) {
        if (this.fFields == null || this.fFields.isEmpty()) {
            return this;
        }
        Field[] javaFields = type.getClass().getFields();
        if (javaFields == null || javaFields.length == 0) {
            return this;
        }
        HashMap<String, Field> javaFieldsMap = new HashMap<String, Field>();
        Field[] fieldArray = javaFields;
        int n = javaFields.length;
        int n2 = 0;
        while (n2 < n) {
            Field javaField = fieldArray[n2];
            javaFieldsMap.put(javaField.getName(), javaField);
            ++n2;
        }
        ArrayList<String> determinantChunks = new ArrayList<String>();
        HashSet<String> visitedFieldNames = new HashSet<String>();
        RfStruct parentStruct = this;
        do {
            if (parentStruct.fFields == null || parentStruct.fFields.isEmpty()) continue;
            for (ListContainer<RfStructMember> fields : parentStruct.fFields.values()) {
                if (fields == null || fields.isEmpty()) continue;
                for (RfStructMember field : fields) {
                    String javaFieldName;
                    Field javaField;
                    RfType assocType;
                    String fieldName = field.getName();
                    if (visitedFieldNames.contains(fieldName)) continue;
                    visitedFieldNames.add(fieldName);
                    int assocListDepth = field.getAssociatedTypeList();
                    if (assocListDepth > 0 || !((assocType = field.getAssociatedBaseType()) instanceof RfScalarType) || ((RfScalarType)assocType).isIntegerAlias() || (javaField = (Field)javaFieldsMap.get(javaFieldName = field.javaName())) == null) continue;
                    try {
                        javaField.setAccessible(true);
                        Object javaValue = javaField.get(type);
                        if (javaValue == null) continue;
                        if ("bool".equals(assocType.getName()) && ("true".equals(javaValue.toString()) || "false".equals(javaValue.toString()))) {
                            javaValue = javaValue.toString().toUpperCase();
                        }
                        determinantChunks.add(javaValue + "'" + fieldName);
                    }
                    catch (Exception exception) {}
                }
            }
        } while ((parentStruct = parentStruct.getParentStruct()) != null);
        determinantChunks.add(this.getName());
        Determinant determinant = new Determinant(determinantChunks.toArray(new String[determinantChunks.size()]));
        List<RfStructLayer> subtypeLayers = this.getSubTypeLayers();
        RfProject project = this.getRfProject();
        RfStructLayer candidateSubtypeLayer = null;
        for (RfStructLayer subtypeLayer : subtypeLayers) {
            Determinant candidateDeterminant = subtypeLayer.getDeterminant();
            if (candidateDeterminant == null || candidateDeterminant.toArray() == null || candidateDeterminant.toArray().length == 0 || !determinant.contains(candidateDeterminant, true) || candidateSubtypeLayer != null && !candidateSubtypeLayer.getDeterminant().contains(candidateDeterminant, true)) continue;
            candidateSubtypeLayer = subtypeLayer;
        }
        if (candidateSubtypeLayer != null) {
            return new RfWhenSubtype(project, candidateSubtypeLayer);
        }
        return this;
    }

    public boolean is_contained_in(RfStruct other) {
        if (other == null) {
            return true;
        }
        boolean like = this.isLike(other.getName());
        return like;
    }

    public static enum KIND {
        UNKNOWN,
        ANNOTATION,
        STRUCT,
        INTERFACE,
        PACKAGE,
        SLN_STRUCT,
        SLN_TOKEN,
        SLN_COMPONENT,
        SLN_ACTION,
        SDL_AGENT,
        SDL_SCENARIO,
        SDL_ROLE;

    }

    class RawFieldsIterator
    implements Iterator<RfStructMember> {
        private boolean onlyUnits;
        private RfStruct currentRfStruct;
        private Iterator<ListContainer<RfStructMember>> currentMapIterator;
        private Iterator<RfStructMember> currentFieldIterator;

        public RawFieldsIterator(RfStruct rfStruct2, boolean onlyUnits) {
            this.onlyUnits = onlyUnits;
            this.goToStruct(rfStruct2);
        }

        private void goToStruct(RfStruct rfStruct) {
            this.currentMapIterator = null;
            this.currentFieldIterator = null;
            this.currentRfStruct = rfStruct;
            if (rfStruct == null) {
                return;
            }
            if (this.onlyUnits && !rfStruct.isUnit()) {
                return;
            }
            Map<String, ListContainer<RfStructMember>> fieldsMap = this.currentRfStruct.fFields;
            if (fieldsMap == null) {
                return;
            }
            Collection<ListContainer<RfStructMember>> fieldsMapValues = fieldsMap.values();
            if (fieldsMapValues == null || fieldsMapValues.isEmpty()) {
                return;
            }
            this.currentMapIterator = fieldsMapValues.iterator();
            if (this.currentMapIterator == null) {
                return;
            }
            if (!this.currentMapIterator.hasNext()) {
                return;
            }
            this.computeNextFieldIterator();
            if (this.currentFieldIterator == null) {
                this.currentMapIterator = null;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean hasNext() {
            try {
                block2: while (true) {
                    if (this.currentRfStruct == null) {
                        return false;
                    }
                    while (true) {
                        if (this.currentFieldIterator == null || this.currentMapIterator == null) {
                            this.goToStruct(this.currentRfStruct.getParentStruct());
                            continue block2;
                        }
                        if (this.currentFieldIterator.hasNext()) {
                            return true;
                        }
                        this.computeNextFieldIterator();
                    }
                    break;
                }
            }
            catch (ConcurrentModificationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            return false;
        }

        private void computeNextFieldIterator() {
            this.currentFieldIterator = null;
            while (this.currentFieldIterator == null && this.currentMapIterator.hasNext()) {
                ListContainer<RfStructMember> nextList = this.currentMapIterator.next();
                if (nextList == null || nextList.isEmpty()) continue;
                this.currentFieldIterator = nextList.iterator();
            }
        }

        @Override
        public RfStructMember next() {
            try {
                if (this.currentFieldIterator != null) {
                    return this.currentFieldIterator.next();
                }
            }
            catch (ConcurrentModificationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            return null;
        }
    }
}

