/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfVHBreadcrumbElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfActionBlockLayer;
import ro.amiq.edt.base.model.reflection.RfArg;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfExpect;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfFieldPropConstraint;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfMeImplicitVariable;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfSDLToolEditorAvoidCallLayer;
import ro.amiq.edt.base.model.reflection.RfSDLToolEditorPrioritizeCallLayer;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfTemplateStructInstance;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.WrapperActionBlock;
import ro.amiq.edt.base.model.reflection.WrapperType;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedField;
import ro.amiq.edt.base.model.reflection.semantic.RfStructQualifier;
import ro.amiq.etools.eparser.ReparseElement;

public class RfStructLayer
extends RfDefElement
implements IRfScope,
IRfVHBreadcrumbElement {
    private Determinant fDeterminant;
    private List<RfStructQualifier> fStructQualifiers;
    private String fQualifiedPackageName;
    private boolean fIsImplicitLayerOfDVE;

    public RfStructLayer(String fullName, String packageName, int kind, LineInfo startLine, LineInfo endLine, CommentBlock comment, RfModule module, ReparseElement[] reparseStack) {
        super(module, module, kind, startLine, endLine, comment, reparseStack);
        this.fDeterminant = new Determinant(fullName);
        this.fQualifiedPackageName = packageName;
    }

    @Override
    public String getQualifiedPackageName() {
        return this.fQualifiedPackageName;
    }

    @Override
    public void deepClean() {
        if (this.fStructQualifiers != null && !this.fStructQualifiers.isEmpty()) {
            for (RfStructQualifier structQualifier : this.fStructQualifiers) {
                structQualifier.deepClean();
            }
        }
        this.fStructQualifiers = null;
        if (this.fDeterminant != null) {
            this.fDeterminant.deepClean();
        }
        super.deepClean();
    }

    @Override
    public Determinant getDeterminant() {
        RfStruct struct = this.getStruct();
        if (struct instanceof RfTemplateStructInstance) {
            this.fDeterminant.setTemplateInstanceParameters(struct.getTemplateInstanceParameters());
        }
        return this.fDeterminant;
    }

    public RfStruct getStruct() {
        RfNamedElement element = this.getNamedElement();
        if (element instanceof RfStruct) {
            return (RfStruct)element;
        }
        return null;
    }

    @Override
    public IRfScope getEnclosingScope() {
        return this.getStruct();
    }

    public <T extends IRfScopeElement> T getEnclosingScope(Class<T> clazz) {
        IRfScope scope = this.getEnclosingScope();
        do {
            if (scope.getClass() != clazz) continue;
            return (T)scope;
        } while ((scope = scope.getEnclosingScope()) != null);
        return null;
    }

    public IRfScopeElement getEnclosingScope(Set<?> classes) {
        return null;
    }

    public void addStructQualifier(RfStructQualifier structQualifier) {
        if (structQualifier == null) {
            return;
        }
        if (this.fStructQualifiers == null) {
            this.fStructQualifiers = new ArrayList<RfStructQualifier>();
        }
        this.fStructQualifiers.add(structQualifier);
    }

    public List<RfStructQualifier> getStructQualifiers() {
        return this.fStructQualifiers;
    }

    public String getQualifiers() {
        return this.fStructQualifiers != null ? this.fStructQualifiers.stream().map(e -> e.toString()).collect(Collectors.joining(" ")) : "";
    }

    public RfActionBlockLayer addActionLayer(WrapperActionBlock info, RfModule module) {
        RfActionBlockLayer actionBlockLayer = new RfActionBlockLayer(module, this, info.startLine, info.endLine, info.actionKind);
        return actionBlockLayer;
    }

    public String getInfo() {
        RfStruct struct = this.getStruct();
        if (struct == null) {
            return "";
        }
        String result = String.valueOf(this.fDeterminant.toString(true)) + (this.fDeterminant.hasParameters() ? "" : struct.getParametersInfo(true));
        if (struct.isSDLScenario()) {
            result = String.valueOf(struct.getSDLEnclosingAgent().getName()) + "::" + result;
        } else if (struct.isSLNAction()) {
            result = String.valueOf(struct.getSLNEnclosingComponent().getName()) + "::" + result;
        }
        return result;
    }

    protected void toString(StringBuilder sb) {
        sb.append("Struct Layer: ").append(this.getLayerModule().getName()).append("Line:").append(this.getStartLine());
    }

    public boolean isUnit() {
        RfStruct struct = this.getStruct();
        if (struct == null) {
            return false;
        }
        return struct.isUnit();
    }

    @Override
    public String getContextType() {
        return "ro.amiq.edt.templates.contextType.struct_member";
    }

    @Override
    public void setTransientDeterminant(Determinant determinant) {
    }

    @Override
    public Determinant getTransientDeterminant() {
        return this.getDeterminant();
    }

    @Override
    public List<RfVar> getVariablesWithPrefix(int line, int matchType, String prefix) {
        return null;
    }

    @Override
    public RfVar getVariableWithPrefix(int line, int matchType, String prefix) {
        return null;
    }

    @Override
    public List<RfArg> getArgumentsWithPrefix(int matchType, String prefix) {
        return null;
    }

    @Override
    public RfArg getArgumentWithPrefix(int matchType, String prefix) {
        return null;
    }

    @Override
    public List<RfField> getFieldsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        List<RfField> fieldPCs;
        RfStruct struct = this.getStruct();
        if (struct == null) {
            return null;
        }
        if ((matchType & 1) != 0 && (fieldPCs = struct.getMembersWithPrefix(false, 4, this.getDeterminant(), packageName, enclosingStruct, 1, prefix, 16)) != null && !fieldPCs.isEmpty()) {
            Determinant customDeterminant = this.getDeterminant();
            Determinant determinant = ((RfFieldPropConstraint)fieldPCs.get(0)).getField().getAssociatedTypeDeterminant();
            if (determinant != null) {
                customDeterminant = Determinant.merge(customDeterminant.toArray(), determinant.toArray());
            }
            RfField original = ((RfFieldPropConstraint)fieldPCs.get(0)).getField();
            RfField clone = ((RfFieldPropConstraint)fieldPCs.get(0)).getField().newField();
            WrapperType typeInfo = original.getTypeInfo();
            typeInfo.def = customDeterminant.toString();
            int i = 0;
            while (i < typeInfo.listDepth) {
                typeInfo.def = DVTStringUtil.appendString((Object[])new Object[]{"list of ", typeInfo.def});
                ++i;
            }
            clone.setAssociatedType(original.getModule(), typeInfo);
            clone.setLayersContainer(original.getLayersContainer());
            clone.setFullName(original.getFullName());
            clone.setAssociatedTypeDeterminant(customDeterminant);
            RfType associatedType = original.getAssociatedType();
            if (associatedType instanceof RfListType) {
                associatedType = ((RfListType)associatedType).getAssociatedType();
            }
            clone.setAssociatedType(associatedType);
            fieldPCs.set(0, clone);
            return fieldPCs;
        }
        List<RfField> fields = struct.getMembersWithPrefix(false, 2, this.getDeterminant(), packageName, enclosingStruct, matchType, prefix, accessModifiers);
        if (fields == null || fields.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < fields.size()) {
            RfField field = fields.get(i);
            List fieldTCs = struct.getMembersWithPrefix(false, 3, this.getDeterminant(), packageName, enclosingStruct, 1, field.getName(), 16);
            if (fieldTCs != null && !fieldTCs.isEmpty()) {
                RfField clone = ((RfField)fieldTCs.get(0)).newField();
                clone.setLayersContainer(field.getLayersContainer());
                clone.setFullName(field.getFullName());
                fields.set(i, clone);
            }
            ++i;
        }
        return fields;
    }

    @Override
    public RfField getFieldWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        List<RfField> result = this.getFieldsWithPrefix(packageName, enclosingStruct, matchType, prefix, accessModifiers);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    @Override
    public List<RfMethod> getMethodsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        RfStruct struct = this.getStruct();
        if (struct == null) {
            return null;
        }
        return struct.getMembersWithPrefix(false, 1, this.getDeterminant(), packageName, enclosingStruct, matchType, prefix, accessModifiers);
    }

    @Override
    public RfMethod getMethodWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        List<RfMethod> result = this.getMethodsWithPrefix(packageName, enclosingStruct, matchType, prefix, accessModifiers);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    @Override
    public List<RfEvent> getEventsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        RfStruct struct = this.getStruct();
        if (struct == null) {
            return null;
        }
        return struct.getMembersWithPrefix(false, 5, this.getDeterminant(), packageName, enclosingStruct, matchType, prefix, accessModifiers);
    }

    @Override
    public RfEvent getEventWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        List<RfEvent> result = this.getEventsWithPrefix(packageName, enclosingStruct, matchType, prefix, accessModifiers);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    @Override
    public List<RfExpect> getExpectsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        RfStruct struct = this.getStruct();
        if (struct == null) {
            return null;
        }
        return struct.getMembersWithPrefix(false, 6, this.getDeterminant(), packageName, enclosingStruct, matchType, prefix, accessModifiers);
    }

    @Override
    public RfExpect getExpectWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        List<RfExpect> result = this.getExpectsWithPrefix(packageName, enclosingStruct, matchType, prefix, accessModifiers);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    @Override
    public RfMeImplicitVariable getMeImplicitVariable(int matchType, String prefix) {
        RfStruct struct = this.getStruct();
        if (struct == null) {
            return null;
        }
        return struct.getMeImplicitVariable(matchType, this.getDeterminant(), prefix);
    }

    @Override
    public RfPredefinedField getCompImplicitVariable(RfProject project, int matchType, String prefix) {
        RfStruct struct = this.getStruct();
        if (struct == null) {
            return null;
        }
        return struct.getCompImplicitVariable(project, matchType, prefix);
    }

    @Override
    public boolean isInGlobal() {
        RfStruct struct = this.getStruct();
        if (struct == null) {
            return false;
        }
        return struct.isInGlobal();
    }

    @Override
    public RfNamedElement semanticGetMember(RfProject project, String packageName, String name, EnumSet<IRfNamedElement.ElementKind> allowedElements, LineInfo lineInfo, int maxModuleIndex, ParserPath parserPath, RfNamedElement exclude) {
        RfStruct struct = this.getStruct();
        if (struct == null) {
            return null;
        }
        struct.setParamsValueOverride();
        RfNamedElement result = null;
        if (allowedElements.contains(IRfNamedElement.ElementKind.E_FIELD) && (result = struct.getMeImplicitVariable(1, this.fDeterminant, name)) != null) {
            return result;
        }
        result = struct.semanticGetMember(project, this.fDeterminant, packageName, struct, name, allowedElements, 31, maxModuleIndex, parserPath, exclude);
        if (result != null) {
            return result;
        }
        RfStruct global = project.getSpecman().getGlobalStruct();
        result = global.semanticGetMember(project, null, packageName, struct, name, allowedElements, 31, maxModuleIndex, parserPath, exclude);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public List<RfEnum> getEnumsWithPrefix(int matchType, String prefix) {
        return null;
    }

    @Override
    public RfEnum getEnumWithPrefix(int matchType, String prefix) {
        return null;
    }

    public IRfNamedElement getSignalWithPrefix(String prefix, int matchType) {
        return null;
    }

    public List<? extends IRfNamedElement> getSignalsWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfInstanceElement getInstanceWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public boolean hasQualifiedName() {
        return this.fQualifiedPackageName != null;
    }

    public void getElementsWithPrefix(Collection<IRfNamedElement> result, String prefix, int matchType, int local, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) {
    }

    public IRfLibraryElement getEnclosingLibrary() {
        return null;
    }

    public void setDeterminant(Determinant determinant) {
        this.fDeterminant.setArray(determinant.toArray());
    }

    public void collectSDLToolEditorPrioritizeCalls(List<RfSDLToolEditorPrioritizeCallLayer> collectedCalls) {
        Collection defElements = this.getChildren();
        if (defElements == null || defElements.isEmpty()) {
            return;
        }
        for (RfDefElement defElement : defElements) {
            if (defElement.getClass() != RfActionBlockLayer.class) continue;
            ((RfActionBlockLayer)defElement).collectSDLToolEditorPrioritizeCalls(collectedCalls);
        }
    }

    public void collectSDLToolEditorAvoidCalls(List<RfSDLToolEditorAvoidCallLayer> collectedCalls) {
        Collection defElements = this.getChildren();
        if (defElements == null || defElements.isEmpty()) {
            return;
        }
        for (RfDefElement defElement : defElements) {
            if (defElement.getClass() != RfActionBlockLayer.class) continue;
            ((RfActionBlockLayer)defElement).collectSDLToolEditorAvoidCalls(collectedCalls);
        }
    }
}

