/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.IRfAssociatedType;
import ro.amiq.edt.base.model.reflection.IRfStructMemberLayer;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEventLayer;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfTemplateParam;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.TypesWalker;

public abstract class RfStructMember
extends RfNamedElement
implements IRfAssociatedType,
ListContainer<RfStructMember> {
    public static final String ON_EVENT_METHOD_PREFIX = "on_";
    public static final int EVENT_KIND = 0;
    public static final int EXPECT_KIND = 1;
    public static final int METHOD_KIND = 2;
    public static final int FIELD_KIND = 3;
    private RfStruct fParentStruct;
    private FullName fFullName;
    protected transient IRfNamedElement fAssocType;
    private transient Determinant fAssocDeterminant;
    private transient String fAssocTypeListKey;
    private transient int fAssocTypeListDepth;

    public RfStructMember(RfProject project, FullName name, RfStruct parent) {
        super(project, name.getName());
        Assert.isNotNull((Object)parent);
        this.fParentStruct = parent;
        this.fFullName = name;
    }

    @Override
    public void deepClean() {
        try {
            if (this.fAssocDeterminant != null) {
                this.fAssocDeterminant.deepClean();
            }
            this.fAssocType = null;
            this.fFullName = null;
            this.fParentStruct = null;
            super.deepClean();
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    @Override
    public FullName getFullName() {
        return this.fFullName;
    }

    public void setFullName(FullName fullName) {
        this.fFullName = fullName;
    }

    public RfStruct getParentStruct() {
        return this.fParentStruct;
    }

    public void setParentStruct(RfStruct parentStruct) {
        this.fParentStruct = parentStruct;
    }

    @Override
    public boolean hasTypeFromName() {
        return false;
    }

    public abstract String getDefStructLayerName();

    public abstract boolean isLocalPredefined();

    protected final FirstAndPrevLayer getFirstAndPrevLayer(RfProject project, IRfStructMemberLayer currLayer) {
        RfStruct parent;
        List<RfDefElement> layers = this.getLayers();
        if (layers == null || layers.isEmpty()) {
            return null;
        }
        Determinant determinant = currLayer.getDefStructDeterminant();
        RfDefElement firstLayer = null;
        RfDefElement prevLayer = null;
        RfDefElement prevRawLayer = null;
        HashSet<Determinant> equalsDeterminant = new HashSet<Determinant>();
        HashSet<Determinant> notEqualsDeterminant = new HashSet<Determinant>();
        for (RfDefElement layer : layers) {
            RfDefElement candidateLayer;
            Determinant candidateDeterminant;
            project.checkBuildCanceled();
            if (layer == currLayer) break;
            if (currLayer.getClass() != layer.getClass() || notEqualsDeterminant.contains(candidateDeterminant = ((IRfStructMemberLayer)((Object)layer)).getDefStructDeterminant()) || !project.importedBySameTest(layer, (RfDefElement)((Object)currLayer))) continue;
            prevRawLayer = candidateLayer = layer;
            if (equalsDeterminant.contains(candidateDeterminant) || determinant.equals(candidateDeterminant)) {
                equalsDeterminant.add(candidateDeterminant);
                prevLayer = candidateLayer;
                if (firstLayer != null) continue;
                firstLayer = candidateLayer;
                continue;
            }
            notEqualsDeterminant.add(candidateDeterminant);
        }
        if (prevLayer != null) {
            return new FirstAndPrevLayer(firstLayer, null, prevLayer, prevRawLayer);
        }
        int memberKind = this.getMemberKind();
        String name = this.getName();
        RfStruct firstStruct = parent = this.getParentStruct();
        while ((parent = parent.getParentStruct()) != null) {
            RfDefElement layer;
            if (!parent.hasLocalMember(name, RfEventLayer.class, memberKind)) continue;
            firstStruct = parent;
            if (prevLayer != null || parent.isPredefined()) continue;
            RfStructMember member = firstStruct.getLocalMember(new FullName(name, new Determinant(new String[]{firstStruct.getName()})), memberKind);
            RfDefElement rfDefElement = layer = member == null ? null : member.getDeclaration();
            if (layer == null || !project.importedBySameTest(layer, (RfDefElement)((Object)currLayer))) continue;
            prevLayer = layer;
            if (prevRawLayer != null) continue;
            prevRawLayer = layer;
        }
        return new FirstAndPrevLayer(firstLayer, firstStruct, prevLayer, prevRawLayer);
    }

    protected String replaceParameterNames(String input) {
        RfType parent = this.getParentStruct();
        if (parent instanceof RfListType) {
            parent = ((RfListType)parent).getAssociatedType();
        }
        if (parent instanceof RfTemplateParam) {
            String result = input;
            if (input.contains(parent.getName())) {
                String assocFullTypeName = ((RfTemplateParam)parent).getAssociatedFullTypeName();
                result = result.replace(parent.getName(), assocFullTypeName);
            }
            return result;
        }
        String result = input;
        if (parent == null) {
            return result;
        }
        result = result.replaceAll("<[^>]*>", parent.getName() != null ? parent.getName() : "");
        return result;
    }

    public RfType getAssociatedBaseType() {
        if (this.fAssocType instanceof RfTemplateParam && ((RfTemplateParam)this.fAssocType).getAssociatedBaseType() != null) {
            return ((RfTemplateParam)this.fAssocType).getAssociatedBaseType();
        }
        return (RfType)this.fAssocType;
    }

    public RfType getAssociatedType() {
        RfType assocBaseType = this.getAssociatedBaseType();
        Determinant assocDeterminant = this.getAssociatedTypeDeterminant();
        int assocTypeListDepth = this.getAssociatedTypeList();
        String assocTypeListKey = this.getAssociatedTypeListKey();
        return RfListType.listFromType(this.getRfProject(), assocBaseType, assocDeterminant, assocTypeListKey, assocTypeListDepth);
    }

    @Override
    public int getAssociatedTypeList() {
        if (this.fAssocType instanceof RfTemplateParam && ((RfTemplateParam)this.fAssocType).getAssociatedBaseType() != null) {
            return ((RfTemplateParam)this.fAssocType).getAssociatedTypeList() + this.fAssocTypeListDepth;
        }
        return this.fAssocTypeListDepth;
    }

    public void setAssociatedTypeList(int assocTypeListDepth) {
        if (assocTypeListDepth > 0) {
            this.fAssocTypeListDepth = assocTypeListDepth;
        }
    }

    @Override
    public String getAssociatedTypeListKey() {
        String assocTypeListKey;
        if (this.fAssocType instanceof RfTemplateParam && ((RfTemplateParam)this.fAssocType).getAssociatedBaseType() != null && (assocTypeListKey = ((RfTemplateParam)this.fAssocType).getAssociatedTypeListKey()) != null) {
            return assocTypeListKey;
        }
        return this.fAssocTypeListKey;
    }

    public void setAssociatedType(RfType assocType) {
        RfDefElement declaration = this.getDeclaration();
        RfStructMember.removeImplicitWhenSubtypeLayer(declaration, this.fAssocType, this.fAssocDeterminant);
        if (assocType instanceof RfListType) {
            this.fAssocType = ((RfListType)assocType).getAssociatedBaseType();
            this.fAssocDeterminant = ((RfListType)assocType).getAssociatedTypeDeterminant();
            this.fAssocTypeListKey = ((RfListType)assocType).getAssociatedTypeListKey();
            this.fAssocTypeListDepth = ((RfListType)assocType).getAssociatedTypeList();
        } else {
            this.fAssocType = assocType;
            this.fAssocDeterminant = null;
            this.fAssocTypeListKey = null;
            this.fAssocTypeListDepth = 0;
        }
        RfStructMember.addImplicitWhenSubtypeLayer(this.getDeclaration(), this.fAssocType, this.fAssocDeterminant);
    }

    public void setAssociatedTypeNoKey(RfListType assocType) {
        RfDefElement declaration = this.getDeclaration();
        RfStructMember.removeImplicitWhenSubtypeLayer(declaration, this.fAssocType, this.fAssocDeterminant);
        this.fAssocType = assocType.getAssociatedBaseType();
        this.fAssocDeterminant = assocType.getAssociatedTypeDeterminant();
        this.fAssocTypeListDepth = assocType.getAssociatedTypeList();
        RfStructMember.addImplicitWhenSubtypeLayer(this.getDeclaration(), this.fAssocType, this.fAssocDeterminant);
    }

    protected static void removeImplicitWhenSubtypeLayer(RfDefElement layer, IRfNamedElement type, Determinant determinant) {
        if (type == null || layer == null || determinant == null || determinant.toArray() == null || !(type instanceof RfStruct) || determinant.toArray().length <= 1) {
            return;
        }
        ((RfStruct)type).removeImplicitWhenSubtypeLayer(layer);
    }

    protected static void addImplicitWhenSubtypeLayer(RfDefElement layer, IRfNamedElement type, Determinant determinant) {
        if (type == null || layer == null || determinant == null || determinant.toArray() == null || !(type instanceof RfStruct) || determinant.toArray().length <= 1) {
            return;
        }
        ((RfStruct)type).addImplicitWhenSubtypeLayer(layer);
    }

    public void setAssociatedTypeFrom(RfProject project, RfNamedElement typeContainer) {
        if (typeContainer instanceof IRfAssociatedType) {
            RfDefElement declaration = this.getDeclaration();
            RfStructMember.removeImplicitWhenSubtypeLayer(declaration, this.fAssocType, this.fAssocDeterminant);
            this.fAssocType = ((IRfAssociatedType)((Object)typeContainer)).getAssociatedBaseType();
            this.fAssocDeterminant = ((IRfAssociatedType)((Object)typeContainer)).getAssociatedTypeDeterminant();
            this.fAssocTypeListKey = ((IRfAssociatedType)((Object)typeContainer)).getAssociatedTypeListKey();
            this.fAssocTypeListDepth = ((IRfAssociatedType)((Object)typeContainer)).getAssociatedTypeList();
            RfStructMember.addImplicitWhenSubtypeLayer(declaration, this.fAssocType, this.fAssocDeterminant);
        }
    }

    @Override
    protected void removeLayer(RfDefElement layer) {
        RfStructMember.removeImplicitWhenSubtypeLayer(layer, this.fAssocType, this.fAssocDeterminant);
        super.removeLayer(layer);
    }

    public void setAssociatedTypeDeterminant(Determinant determinant) {
        this.fAssocDeterminant = determinant;
    }

    @Override
    public Determinant getAssociatedTypeDeterminant() {
        if (this.fAssocType instanceof RfTemplateParam && ((RfTemplateParam)this.fAssocType).getAssociatedBaseType() != null) {
            return ((RfTemplateParam)this.fAssocType).getAssociatedTypeDeterminant();
        }
        RfType assocType = this.getAssociatedBaseType();
        if (this.fAssocDeterminant == null && assocType instanceof RfListType) {
            return assocType.getDeterminant();
        }
        if (this.fAssocDeterminant == null && assocType instanceof RfStruct) {
            return new Determinant(new String[]{assocType.getName()});
        }
        return Determinant.resolveTypeParam(this.fAssocDeterminant, this.fAssocType);
    }

    public String getPackageName() {
        RfDefElement declaration = this.getDeclaration(false);
        if (declaration != null) {
            return declaration.getPackageName();
        }
        return this.fParentStruct.getPackageName();
    }

    abstract int getMemberKind();

    @Override
    public int getAssociatedTypeKind() {
        return this.decodeTypeKind(this);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        Object result = super.clone();
        ((RfStructMember)result).fFullName = new FullName(this.getName(), this.fParentStruct.getDeterminant());
        return result;
    }

    protected <T extends RfDefElement> List<T> getParentSubtypeLayers(Determinant determinant, Map<Determinant, List<T>> groups) {
        ArrayList result = new ArrayList();
        for (Map.Entry<Determinant, List<T>> groupEntry : groups.entrySet()) {
            if (!determinant.contains(groupEntry.getKey())) continue;
            result.addAll(groupEntry.getValue());
        }
        return result;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getSignature()) + "\n";
    }

    @Override
    public String javaTypeName() {
        IRfNamedElement assocType = this.fAssocType;
        if (assocType instanceof RfTemplateParam) {
            assocType = ((RfTemplateParam)assocType).getAssociatedType();
        }
        if (assocType == null || assocType == TypesWalker.UNRESOLVED_TYPE) {
            return "__INTERNAL_ERROR";
        }
        String result = ((RfNamedElement)assocType).javaName();
        if (this.fAssocTypeListDepth > 0) {
            int i = 0;
            while (i < this.fAssocTypeListDepth) {
                result = this.fAssocTypeListKey != null && i == 0 ? DVTStringUtil.appendString((Object[])new Object[]{"EKeyedList<", result, ">"}) : DVTStringUtil.appendString((Object[])new Object[]{"EList<", result, ">"});
                ++i;
            }
        }
        return result;
    }

    @Override
    public String javaTypeClassName() {
        if (this.fAssocType == null || this.fAssocType == TypesWalker.UNRESOLVED_TYPE) {
            return "__INTERNAL_ERROR";
        }
        if (this.fAssocTypeListDepth > 0) {
            if (this.fAssocTypeListKey != null) {
                return "EKeyedList.class";
            }
            return "EList.class";
        }
        return String.valueOf(((RfNamedElement)this.fAssocType).javaName()) + ".class";
    }

    @Override
    public String elementPathName() {
        return this.fFullName.toString().replace(' ', '-');
    }

    public abstract String getSignature(String var1);

    @Override
    public String javaName() {
        Determinant determinant = this.getFullName().getDeterminant();
        String subTypePrefix = determinant == null ? "" : determinant.javaName();
        return "__etools_" + subTypePrefix + this.getName();
    }

    public RfStructMember internalThis() {
        return this;
    }

    @Override
    public String getFullNameLabel() {
        RfStruct parentStruct;
        StringBuilder result = new StringBuilder();
        result.append(this.getName());
        if (this instanceof RfMethod) {
            result.append("()");
        }
        if ((parentStruct = this.getParentStruct()) == null) {
            return result.toString();
        }
        result = new StringBuilder().append(parentStruct.getName()).append(".").append(result.toString());
        return String.valueOf(parentStruct.printScope()) + result.toString();
    }

    static class FirstAndPrevLayer {
        public RfDefElement firstLayer;
        public RfStruct firstStruct;
        public RfDefElement prevLayer;
        public RfDefElement prevRawLayer;

        public FirstAndPrevLayer(RfDefElement firstLayer, RfStruct firstStruct, RfDefElement prevLayer, RfDefElement prevRawLayer) {
            this.firstLayer = firstLayer;
            this.firstStruct = firstStruct;
            this.prevLayer = prevLayer;
            this.prevRawLayer = prevRawLayer;
        }
    }
}

