/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.IRfAssociatedType;
import ro.amiq.edt.base.model.reflection.IRfTemplateParam;
import ro.amiq.edt.base.model.reflection.RfArg;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfExpect;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfMeImplicitVariable;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfTemplateStructInstance;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.TypesWalker;
import ro.amiq.edt.base.model.reflection.WrapperType;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedField;

public class RfTemplateParam
extends RfType
implements IRfTemplateParam {
    private String fTypeName;
    private String fBaseName;
    private boolean fIsImplicit;
    private transient IRfAssociatedType fParamValueDefault;
    private transient IRfAssociatedType fParamValueOverride;
    private RfStruct fParentStruct;

    public RfTemplateParam(RfProject project, RfModule module, String name, WrapperType typeInfo, RfStruct parentStruct) {
        super(project, name);
        this.setParentStruct(parentStruct);
        if (typeInfo == null) {
            return;
        }
        this.fIsImplicit = typeInfo.typeFromName;
        if (typeInfo.baseType == 4) {
            this.fBaseName = "any_simple_port";
            this.fTypeName = typeInfo.def;
        } else if (typeInfo.baseType == 5) {
            this.fBaseName = "any_buffer_port";
            this.fTypeName = typeInfo.def;
        } else if (typeInfo.baseType == 6) {
            this.fBaseName = "any_method_port";
            this.fTypeName = typeInfo.def;
        } else if (typeInfo.baseType == 7) {
            this.fBaseName = "any_event_port";
            this.fTypeName = typeInfo.def;
        } else if (typeInfo.baseType == 12) {
            this.fBaseName = typeInfo.elemTypeName;
            this.fTypeName = typeInfo.def;
        } else if (typeInfo.baseType == 10) {
            this.fBaseName = typeInfo.baseName;
            this.fTypeName = typeInfo.def == null ? typeInfo.baseName : typeInfo.def;
        } else if (typeInfo.baseType == 9) {
            this.fBaseName = typeInfo.baseName;
            this.fTypeName = typeInfo.def == null ? this.getName() : typeInfo.def;
        } else {
            this.fBaseName = typeInfo.baseName;
            this.fTypeName = typeInfo.def == null ? this.getName() : typeInfo.def;
        }
    }

    @Override
    public void deepClean() {
        try {
            this.fParentStruct = null;
            this.fParamValueDefault = null;
            this.fParamValueOverride = null;
            super.deepClean();
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    @Override
    public void setAssociatedTypeName(String packageName, String name, int type) {
        this.fBaseName = name;
        this.fTypeName = name;
    }

    @Override
    public boolean hasTypeFromName() {
        return this.fIsImplicit;
    }

    @Override
    public void setParamValueOverride(IRfAssociatedType paramValueOverride) {
        this.fParamValueOverride = paramValueOverride == null || paramValueOverride == TypesWalker.UNRESOLVED_TYPE || paramValueOverride.getAssociatedType() == this ? null : paramValueOverride;
    }

    public void setParamValueDefault(IRfAssociatedType paramValueDefault) {
        this.fParamValueDefault = paramValueDefault == null || paramValueDefault == TypesWalker.UNRESOLVED_TYPE || paramValueDefault.getAssociatedType() == this ? null : paramValueDefault;
    }

    @Override
    public RfStruct getParentStruct() {
        return this.fParentStruct;
    }

    @Override
    public void setParentStruct(RfStruct parentStruct) {
        this.fParentStruct = parentStruct;
    }

    @Override
    public String getContextType() {
        return "ro.amiq.edt.templates.contextType.struct_member";
    }

    @Override
    public Determinant getDeterminant() {
        return null;
    }

    @Override
    public void setTransientDeterminant(Determinant determinant) {
    }

    @Override
    public Determinant getTransientDeterminant() {
        RfType associatedType = this.getAssociatedType();
        if (associatedType == null || associatedType == this) {
            return null;
        }
        return associatedType.getTransientDeterminant();
    }

    @Override
    public List<RfField> getFieldsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        RfType associatedType = this.getAssociatedType();
        if (associatedType == null || associatedType == this) {
            return null;
        }
        return associatedType.getFieldsWithPrefix(packageName, enclosingStruct, matchType, prefix, accessModifiers);
    }

    @Override
    public RfField getFieldWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        RfType associatedType = this.getAssociatedType();
        if (associatedType == null || associatedType == this) {
            return null;
        }
        return associatedType.getFieldWithPrefix(packageName, enclosingStruct, matchType, prefix, accessModifiers);
    }

    @Override
    public List<RfMethod> getMethodsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        RfType associatedType = this.getAssociatedType();
        if (associatedType == null || associatedType == this) {
            return null;
        }
        return associatedType.getMethodsWithPrefix(packageName, enclosingStruct, matchType, prefix, accessModifiers);
    }

    @Override
    public RfMethod getMethodWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        RfType associatedType = this.getAssociatedType();
        if (associatedType == null || associatedType == this) {
            return null;
        }
        return associatedType.getMethodWithPrefix(packageName, enclosingStruct, matchType, prefix, accessModifiers);
    }

    @Override
    public List<RfEvent> getEventsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        RfType associatedType = this.getAssociatedType();
        if (associatedType == null || associatedType == this) {
            return null;
        }
        return associatedType.getEventsWithPrefix(packageName, enclosingStruct, matchType, prefix, accessModifiers);
    }

    @Override
    public RfEvent getEventWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        RfType associatedType = this.getAssociatedType();
        if (associatedType == null || associatedType == this) {
            return null;
        }
        return associatedType.getEventWithPrefix(packageName, enclosingStruct, matchType, prefix, accessModifiers);
    }

    @Override
    public List<RfExpect> getExpectsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        RfType associatedType = this.getAssociatedType();
        if (associatedType == null || associatedType == this) {
            return null;
        }
        return associatedType.getExpectsWithPrefix(packageName, enclosingStruct, matchType, prefix, accessModifiers);
    }

    @Override
    public RfExpect getExpectWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        RfType associatedType = this.getAssociatedType();
        if (associatedType == null || associatedType == this) {
            return null;
        }
        return associatedType.getExpectWithPrefix(packageName, enclosingStruct, matchType, prefix, accessModifiers);
    }

    @Override
    public List<RfVar> getVariablesWithPrefix(int line, int matchType, String prefix) {
        RfType associatedType = this.getAssociatedType();
        if (associatedType == null || associatedType == this) {
            return null;
        }
        return associatedType.getVariablesWithPrefix(line, matchType, prefix);
    }

    @Override
    public RfVar getVariableWithPrefix(int line, int matchType, String prefix) {
        RfType associatedType = this.getAssociatedType();
        if (associatedType == null || associatedType == this) {
            return null;
        }
        return associatedType.getVariableWithPrefix(line, matchType, prefix);
    }

    @Override
    public List<RfArg> getArgumentsWithPrefix(int matchType, String prefix) {
        RfType associatedType = this.getAssociatedType();
        if (associatedType == null || associatedType == this) {
            return null;
        }
        return associatedType.getArgumentsWithPrefix(matchType, prefix);
    }

    @Override
    public RfArg getArgumentWithPrefix(int matchType, String prefix) {
        RfType associatedType = this.getAssociatedType();
        if (associatedType == null || associatedType == this) {
            return null;
        }
        return associatedType.getArgumentWithPrefix(matchType, prefix);
    }

    @Override
    public List<RfEnum> getEnumsWithPrefix(int matchType, String prefix) {
        RfType associatedType = this.getAssociatedType();
        if (associatedType == null || associatedType == this) {
            return null;
        }
        return associatedType.getEnumsWithPrefix(matchType, prefix);
    }

    @Override
    public RfEnum getEnumWithPrefix(int matchType, String prefix) {
        RfType associatedType = this.getAssociatedType();
        if (associatedType == null || associatedType == this) {
            return null;
        }
        return associatedType.getEnumWithPrefix(matchType, prefix);
    }

    @Override
    public RfMeImplicitVariable getMeImplicitVariable(int matchType, String prefix) {
        RfType associatedType = this.getAssociatedType();
        if (associatedType == null || associatedType == this) {
            return null;
        }
        return associatedType.getMeImplicitVariable(matchType, prefix);
    }

    @Override
    public RfPredefinedField getCompImplicitVariable(RfProject project, int matchType, String prefix) {
        RfType associatedType = this.getAssociatedType();
        if (associatedType == null || associatedType == this) {
            return null;
        }
        return associatedType.getCompImplicitVariable(project, matchType, prefix);
    }

    @Override
    public boolean isInGlobal() {
        RfType associatedType = this.getAssociatedType();
        if (associatedType == null || associatedType == this) {
            return false;
        }
        return associatedType.isInGlobal();
    }

    public String getSignature() {
        if (this.getAssociatedFullTypeName() != null) {
            return "type parameter " + this.getName() + " : " + this.getAssociatedFullTypeName();
        }
        return "type parameter " + this.getName();
    }

    @Override
    public int getAssociatedTypeKind() {
        return this.decodeTypeKind(this);
    }

    public String getAssociatedTypeName() {
        if (this.fParamValueOverride instanceof RfTemplateStructInstance) {
            return String.valueOf(this.fBaseName) + ((RfTemplateStructInstance)((Object)this.fParamValueOverride)).getParametersInfo(false);
        }
        if (this.fParamValueDefault instanceof RfTemplateStructInstance) {
            return String.valueOf(this.fBaseName) + ((RfTemplateStructInstance)((Object)this.fParamValueDefault)).getParametersInfo(false);
        }
        IRfAssociatedType result = this.getRecursiveTemplateParamType(Collections.newSetFromMap(new IdentityHashMap()));
        if (result instanceof RfTemplateParam) {
            return ((RfTemplateParam)result).fBaseName;
        }
        if (result != null) {
            return result.getAssociatedTypeName();
        }
        if (this.fBaseName == null) {
            return this.getName();
        }
        return this.fBaseName;
    }

    @Override
    public void setAssociatedType(RfModule module, WrapperType typeInfo) {
    }

    @Override
    public int getAssociatedTypeList() {
        IRfAssociatedType result = this.getRecursiveTemplateParamType(Collections.newSetFromMap(new IdentityHashMap()));
        if (result instanceof RfTemplateParam) {
            return 0;
        }
        if (result != null) {
            return result.getAssociatedTypeList();
        }
        return 0;
    }

    public IRfAssociatedType getRecursiveTemplateParamType(Set<RfTemplateParam> visited) {
        if (visited.contains(this)) {
            return this;
        }
        visited.add(this);
        if (this.fParamValueOverride != null && this.fParamValueOverride != this) {
            if (this.fParamValueOverride instanceof RfTemplateParam) {
                return ((RfTemplateParam)this.fParamValueOverride).getRecursiveTemplateParamType(visited);
            }
            return this.fParamValueOverride;
        }
        if (this.fParamValueDefault != null && this.fParamValueDefault != this) {
            if (this.fParamValueDefault instanceof RfTemplateParam) {
                return ((RfTemplateParam)this.fParamValueDefault).getRecursiveTemplateParamType(visited);
            }
            return this.fParamValueDefault;
        }
        return this;
    }

    @Override
    public String getAssociatedTypeListKey() {
        IRfAssociatedType result = this.getRecursiveTemplateParamType(Collections.newSetFromMap(new IdentityHashMap()));
        if (result instanceof RfTemplateParam) {
            return null;
        }
        if (result != null) {
            return result.getAssociatedTypeListKey();
        }
        return null;
    }

    @Override
    public String getAssociatedFullTypeName() {
        IRfAssociatedType result = this.getRecursiveTemplateParamType(Collections.newSetFromMap(new IdentityHashMap()));
        if (result instanceof RfTemplateParam) {
            return ((RfTemplateParam)result).fTypeName;
        }
        if (result != null) {
            return result.getAssociatedTypeName();
        }
        return this.fTypeName;
    }

    public RfType getAssociatedType() {
        IRfAssociatedType result = this.getRecursiveTemplateParamType(Collections.newSetFromMap(new IdentityHashMap()));
        if (result instanceof RfTemplateParam) {
            return (RfType)((Object)result);
        }
        if (result != null) {
            return (RfType)result.getAssociatedType();
        }
        return this;
    }

    public RfType getAssociatedBaseType() {
        IRfAssociatedType result = this.getRecursiveTemplateParamType(Collections.newSetFromMap(new IdentityHashMap()));
        if (result instanceof RfTemplateParam) {
            return (RfType)((Object)result);
        }
        if (result != null) {
            return (RfType)result.getAssociatedBaseType();
        }
        return this;
    }

    @Override
    public Determinant getAssociatedTypeDeterminant() {
        IRfAssociatedType result = this.getRecursiveTemplateParamType(Collections.newSetFromMap(new IdentityHashMap()));
        if (result instanceof RfTemplateParam) {
            return null;
        }
        if (result != null) {
            return result.getAssociatedTypeDeterminant();
        }
        return null;
    }

    @Override
    public String javaName() {
        String name = this.getName();
        int tickIndex = name.indexOf(39);
        if (tickIndex > 0 && name.length() - tickIndex == 6 && (name.charAt(tickIndex + 1) == 't' || name.charAt(tickIndex + 1) == 'T') && name.charAt(tickIndex + 2) == 'y' && name.charAt(tickIndex + 3) == 'p' && name.charAt(tickIndex + 4) == 'e' && name.charAt(tickIndex + 5) == '>') {
            return DVTStringUtil.appendString((Object[])new Object[]{"__etools_", name.substring(1, tickIndex)});
        }
        return DVTStringUtil.appendString((Object[])new Object[]{"__etools_", "type"});
    }

    public IRfAssociatedType getParamValueDefault() {
        return this.fParamValueDefault;
    }
}

