/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.IRfAssociatedType;
import ro.amiq.edt.base.model.reflection.IRfTemplateParam;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfTemplateParam;
import ro.amiq.edt.base.model.reflection.RfTemplateParamLayer;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.WrapperParam;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedStruct;
import ro.amiq.edt.base.model.reflection.semantic.RfDummyField;

public class RfTemplateStruct
extends RfStruct {
    private Map<String, IRfTemplateParam> fParametersMap;

    public RfTemplateStruct(RfProject project, String structName, List<WrapperParam> typeParams) {
        super(project, structName, true);
        if (typeParams != null && !typeParams.isEmpty()) {
            this.fParametersMap = new LinkedHashMap<String, IRfTemplateParam>();
            for (WrapperParam typeParamInfo : typeParams) {
                String typeParamName = DVTStringUtil.intern((String)typeParamInfo.name);
                this.fParametersMap.put(typeParamName, new RfTemplateParam(project, null, typeParamInfo.name, typeParamInfo.typeValue, this));
            }
        }
    }

    @Override
    public void deepClean() {
        try {
            if (this.fParametersMap != null && this.fParametersMap.isEmpty()) {
                for (IRfTemplateParam parameter : this.fParametersMap.values()) {
                    parameter.deepClean();
                }
                this.fParametersMap.clear();
            }
            this.fParametersMap = null;
            super.deepClean();
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    public RfTemplateStruct(RfProject project, String structName) {
        super(project, structName, true);
    }

    @Override
    public boolean isTemplateStruct() {
        return this.fParametersMap != null;
    }

    @Override
    public void setParamsValueOverride() {
        this.setParamsValueOverride(Collections.emptyList());
    }

    @Override
    public void setParameterValue(RfProject project, RfModule module, String typeParamName, IRfAssociatedType defaultParamValue) {
        if (typeParamName == null) {
            return;
        }
        RfTemplateParam parameter = (RfTemplateParam)this.fParametersMap.get(typeParamName);
        if (parameter == null) {
            parameter = new RfTemplateParam(project, module, typeParamName, null, this);
            this.fParametersMap.put(typeParamName, parameter);
        }
        parameter.setParamValueDefault(defaultParamValue);
    }

    @Override
    public RfNamedElement semanticGetMember(RfProject project, Determinant determinant, String packageName, RfStruct enclosingStruct, String name, EnumSet<IRfNamedElement.ElementKind> allowedElements, int accessModifiers, int maxModuleIndex, ParserPath parserPath, RfNamedElement exclude) {
        RfNamedElement result;
        IRfNamedElement assocType;
        IRfTemplateParam param;
        if (RfPredefinedStruct.PORT_STRUCT_NAMES.contains(this.getName()) && this.fParametersMap != null && this.fParametersMap.size() == 1 && (param = this.fParametersMap.values().iterator().next()) != null && (assocType = param.getAssociatedType()) instanceof RfType && (result = ((RfType)assocType).semanticGetMember(project, param.getAssociatedTypeDeterminant(), packageName, enclosingStruct, name, allowedElements, accessModifiers, maxModuleIndex, parserPath, exclude)) != null) {
            return result;
        }
        return super.semanticGetMember(project, determinant, packageName, enclosingStruct, name, allowedElements, accessModifiers, maxModuleIndex, parserPath, exclude);
    }

    @Override
    protected void setDefinitionData(RfModule module, List<WrapperParam> params, String packageName, boolean isUnit, boolean isPotentialUnit, int accessModifier) {
        try {
            if (params != null && !params.isEmpty()) {
                this.fParametersMap = new LinkedHashMap<String, IRfTemplateParam>();
                for (WrapperParam param : params) {
                    RfTemplateParam candidate = new RfTemplateParam(this.getRfProject(), module, param.name, param.typeValue, this);
                    if (module != null) {
                        RfTemplateParamLayer layer = new RfTemplateParamLayer(module, param.line, param.comment);
                        candidate.addLayer(layer);
                    }
                    String typeParamName = DVTStringUtil.intern((String)param.name);
                    this.fParametersMap.put(typeParamName, candidate);
                }
            }
            super.setDefinitionData(module, packageName, isUnit, isPotentialUnit, accessModifier);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public IRfTemplateParam getParameter(String name) {
        if (this.fParametersMap == null) {
            return null;
        }
        return this.fParametersMap.get(name);
    }

    @Override
    public List<IRfAssociatedType> getTemplateInstanceParameters() {
        ArrayList<IRfAssociatedType> result = new ArrayList<IRfAssociatedType>();
        if (this.fParametersMap == null) {
            return null;
        }
        Collection<IRfTemplateParam> parameters = this.fParametersMap.values();
        for (IRfTemplateParam param : parameters) {
            result.add(new RfDummyField(this.getRfProject(), param.getAssociatedBaseType()));
        }
        return result;
    }

    public void setParamsValueOverride(List<IRfAssociatedType> params) {
        if (this.fParametersMap == null) {
            return;
        }
        Collection<IRfTemplateParam> parameters = this.fParametersMap.values();
        Iterator<IRfTemplateParam> iterator = parameters.iterator();
        int i = 0;
        while (i < parameters.size()) {
            IRfTemplateParam paramToOverride = iterator.next();
            if (params != null && i < params.size()) {
                paramToOverride.setParamValueOverride(params.get(i));
            } else {
                paramToOverride.setParamValueOverride(null);
            }
            ++i;
        }
    }

    @Override
    protected void removeDirty(RfProject project, RfStruct packg, Iterator<RfType> structIterator) {
        try {
            if (this.fParametersMap != null) {
                Iterator<IRfTemplateParam> iterator = this.fParametersMap.values().iterator();
                while (iterator.hasNext()) {
                    RfNamedElement parentParam = (RfNamedElement)((Object)iterator.next());
                    if (!parentParam.getLayers().isEmpty()) continue;
                    iterator.remove();
                }
            }
            super.removeDirty(project, packg, structIterator);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public String getSignature() {
        if (this.fParametersMap == null || this.fParametersMap.isEmpty()) {
            return super.getSignature();
        }
        String params = "";
        for (String param : this.fParametersMap.keySet()) {
            param = param.replace("<", "&lt;").replace(">", "&gt;");
            params = String.valueOf(params) + (params.length() == 0 ? param : ", " + param);
        }
        if (this.fParametersMap.size() > 1) {
            return "template " + super.getSignature() + " of (" + params + ")";
        }
        if (this.fParametersMap.size() == 1) {
            return "template " + super.getSignature() + " of " + params;
        }
        return super.getSignature();
    }

    @Override
    public String getParametersInfo(boolean replace) {
        String params = "";
        if (this.fParametersMap == null || this.fParametersMap.isEmpty()) {
            return params;
        }
        for (String param : this.fParametersMap.keySet()) {
            if (replace) {
                param = param.replace("type>", "T>").replace("Type>", "T>").replace("exp>", "E>");
            }
            params = String.valueOf(params) + (params.length() == 0 ? param : ", " + param);
        }
        if (replace) {
            return " (" + params + ")";
        }
        if (this.fParametersMap.size() > 1) {
            return " of (" + params + ")";
        }
        return " of " + params;
    }

    public Set<String> getParameterNames() {
        if (this.fParametersMap == null) {
            return null;
        }
        return this.fParametersMap.keySet();
    }

    public List<IRfTemplateParam> getParameters() {
        if (this.fParametersMap == null) {
            return null;
        }
        return new ArrayList<IRfTemplateParam>(this.fParametersMap.values());
    }

    @Override
    public String javaClassParams() {
        String params = "";
        if (this.fParametersMap == null || this.fParametersMap.isEmpty()) {
            return params;
        }
        StringBuilder result = new StringBuilder();
        for (IRfTemplateParam param : this.fParametersMap.values()) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(((RfNamedElement)((Object)param)).javaName());
        }
        return DVTStringUtil.appendString((Object[])new Object[]{"<", result.toString(), ">"});
    }
}

