/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.IRfAssociatedType;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.IRfTemplateParam;
import ro.amiq.edt.base.model.reflection.RfArg;
import ro.amiq.edt.base.model.reflection.RfConstraintLayer;
import ro.amiq.edt.base.model.reflection.RfCoverLayer;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfEventLayer;
import ro.amiq.edt.base.model.reflection.RfExpect;
import ro.amiq.edt.base.model.reflection.RfExpectLayer;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfFieldLayer;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfMeImplicitVariable;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfTemplateParam;
import ro.amiq.edt.base.model.reflection.RfTemplateStruct;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.TypesWalker;
import ro.amiq.edt.base.model.reflection.WrapperMethod;
import ro.amiq.edt.base.model.reflection.WrapperType;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedField;
import ro.amiq.edt.base.model.reflection.semantic.RfStructQualifier;
import ro.amiq.etools.eparser.ReparseElement;

public class RfTemplateStructInstance
extends RfStruct {
    private transient List<IRfAssociatedType> fParameters = new ArrayList<IRfAssociatedType>();
    private transient RfTemplateStruct fTemplateStruct;

    public RfTemplateStructInstance(RfProject project, RfTemplateStruct templateStruct) {
        super(project, templateStruct.getName(), false);
        this.fTemplateStruct = templateStruct;
        this.setPackageName(templateStruct.getPackageName());
        this.setParentStructFrom(this.getRfProject(), templateStruct.getParentStruct());
    }

    @Override
    public List<RfStruct> getChildStructs() {
        List<RfStruct> childrenStructs = super.getChildStructs();
        if (childrenStructs != null && !childrenStructs.isEmpty()) {
            return childrenStructs;
        }
        return this.fTemplateStruct.getChildStructs();
    }

    @Override
    public List<RfDefElement> getLayers() {
        ArrayList<RfDefElement> layers = new ArrayList<RfDefElement>();
        List<RfDefElement> temp = this.fTemplateStruct.getLayers();
        if (temp != null) {
            layers.addAll(temp);
        }
        if ((temp = super.getLayers()) != null) {
            layers.addAll(temp);
        }
        return layers;
    }

    @Override
    public boolean hasNoDefs(boolean rawDefs) {
        return this.fTemplateStruct.hasNoDefs(rawDefs);
    }

    @Override
    public boolean hasNoLayers() {
        return this.fTemplateStruct.hasNoLayers();
    }

    @Override
    public RfDefElement getFirstLayer() {
        return this.fTemplateStruct.getFirstLayer();
    }

    @Override
    public RfDefElement getDeclaration() {
        return this.fTemplateStruct.getDeclaration();
    }

    @Override
    public String getSignature() {
        this.fTemplateStruct.setParamsValueOverride(this.fParameters);
        Determinant determinant = this.getDeterminant();
        determinant.setTemplateInstanceParameters(this.getTemplateInstanceParameters());
        return this.fTemplateStruct.getSignature();
    }

    @Override
    public List<IRfAssociatedType> getTemplateInstanceParameters() {
        this.fTemplateStruct.setParamsValueOverride(this.fParameters);
        return this.fTemplateStruct.getTemplateInstanceParameters();
    }

    @Override
    public void setParameterValue(RfProject project, RfModule module, String typeParamName, IRfAssociatedType overrideParamValue) {
        if (overrideParamValue == TypesWalker.UNRESOLVED_TYPE) {
            this.fParameters.add(null);
        } else {
            this.fParameters.add(overrideParamValue);
        }
    }

    public void setParamsValueOverride(List<IRfAssociatedType> paramsOverride) {
        this.fParameters = paramsOverride;
    }

    @Override
    public void setParamsValueOverride() {
        this.fTemplateStruct.setParamsValueOverride(this.fParameters);
    }

    @Override
    protected void removeDirty(RfProject project, RfStruct packg, Iterator<RfType> structIterator) {
    }

    @Override
    public void getLocalMemberLayers(List<RfDefElement> layers, String name, int memberKind) {
        Map rawMembers = this.getAllMembersOfType(memberKind);
        ListContainer members = this.get(rawMembers, name);
        if (members == null || members.isEmpty()) {
            return;
        }
        Determinant templateInstanceDeterminant = this.getDeterminant();
        for (RfStructMember member : members) {
            List<RfDefElement> localLayers = member.getLayers();
            if (localLayers == null || localLayers.isEmpty()) continue;
            for (RfDefElement localLayer : localLayers) {
                Determinant determinant;
                if (!(localLayer instanceof IRfScope) || !(determinant = ((IRfScope)((Object)localLayer)).getDeterminant()).equalsParameters(templateInstanceDeterminant)) continue;
                layers.add(localLayer);
            }
        }
    }

    @Override
    public void getStructQualifierCandidates(RfProject project, List<RfStructQualifier> result, String packageName, String enumName, String fieldOrEnumName, Determinant determinant, int accessModifiers, int moduleIndex, LineInfo lineInfo, ParserPath parserPath) {
        this.fTemplateStruct.setParamsValueOverride(this.fParameters);
        this.fTemplateStruct.getStructQualifierCandidates(project, result, packageName, enumName, fieldOrEnumName, determinant, accessModifiers, moduleIndex, lineInfo, parserPath);
    }

    @Override
    public String getParametersInfo(boolean replace) {
        this.fTemplateStruct.setParamsValueOverride(this.fParameters);
        return this.fTemplateStruct.getParametersInfo(replace);
    }

    @Override
    public RfStruct getParentStruct() {
        RfStruct parentStruct = super.getParentStruct();
        if (parentStruct != null) {
            return parentStruct;
        }
        return this.fTemplateStruct.getParentStruct();
    }

    public boolean parameterExists(String paramName) {
        return this.fTemplateStruct.getParameter(paramName) != null;
    }

    public List<IRfAssociatedType> getParameters() {
        return Collections.unmodifiableList(this.fParameters);
    }

    @Override
    public RfMethodLayer addMethodLayer(RfProject project, RfModule module, RfStructLayer structLayer, WrapperMethod parseInfo, int accessModifier) {
        return this.fTemplateStruct.addMethodLayer(project, module, structLayer, parseInfo, accessModifier);
    }

    @Override
    public RfFieldLayer addFieldLayer(RfProject project, RfModule module, RfStructLayer structLayer, String name, WrapperType typeInfo, boolean isInstance, boolean isGenerated, boolean isPhysical, int accessModifier, boolean isSLNTokenField, boolean isSDLScenarioParam, ReparseElement[] reparseStack) {
        return this.fTemplateStruct.addFieldLayer(project, module, structLayer, name, typeInfo, isInstance, isGenerated, isPhysical, accessModifier, isSLNTokenField, isSDLScenarioParam, reparseStack);
    }

    @Override
    public RfEventLayer addEventLayer(RfProject project, RfModule module, RfStructLayer structLayer, String name, int kind, LineInfo line, CommentBlock comment, int accessModifier, ReparseElement[] reparseStack) {
        return this.fTemplateStruct.addEventLayer(project, module, structLayer, name, kind, line, comment, accessModifier, reparseStack);
    }

    @Override
    public RfConstraintLayer addConstraintLayer(RfProject project, RfModule module, RfStructLayer structLayer, String name, int kind, LineInfo line, LineInfo endLine, CommentBlock comment, ReparseElement[] reparseStack) {
        return this.fTemplateStruct.addConstraintLayer(project, module, structLayer, name, kind, line, endLine, comment, reparseStack);
    }

    @Override
    public RfCoverLayer addCoverLayer(RfProject project, RfModule module, RfStructLayer structLayer, String name, int kind, LineInfo startLine, LineInfo endLine, CommentBlock comment, ReparseElement[] reparseStack) {
        return this.fTemplateStruct.addCoverLayer(project, module, structLayer, name, kind, startLine, endLine, comment, reparseStack);
    }

    @Override
    public RfExpectLayer addExpectLayer(RfProject project, RfModule module, RfStructLayer structLayer, String name, boolean expectNoAssume, String expression, boolean defaultDutError, String literal, int kind, LineInfo line, LineInfo endLine, CommentBlock comment, ReparseElement[] reparseStack) {
        return this.fTemplateStruct.addExpectLayer(project, module, structLayer, name, expectNoAssume, expression, defaultDutError, literal, kind, line, endLine, comment, reparseStack);
    }

    @Override
    public RfFieldLayer addFieldPropConstraintLayer(RfProject project, RfModule module, RfStructLayer structLayer, String fieldName1, String fieldName2, String fieldName3, CommentBlock comment, LineInfo line, ReparseElement[] reparseStack) {
        return this.fTemplateStruct.addFieldPropConstraintLayer(project, module, structLayer, fieldName1, fieldName2, fieldName3, comment, line, reparseStack);
    }

    @Override
    public RfFieldLayer addFieldTypeConstraintLayer(RfProject project, RfModule module, RfStructLayer structLayer, String name, WrapperType typeInfo, ReparseElement[] reparseStack) {
        return this.fTemplateStruct.addFieldTypeConstraintLayer(project, module, structLayer, name, typeInfo, reparseStack);
    }

    @Override
    public RfNamedElement semanticGetMember(RfProject project, Determinant determinant, String packageName, RfStruct enclosingStruct, String name, EnumSet<IRfNamedElement.ElementKind> allowedElements, int accessModifiers, int maxModuleIndex, ParserPath parserPath, RfNamedElement exclude) {
        RfNamedElement result;
        this.fTemplateStruct.setParamsValueOverride(this.fParameters);
        if (determinant != null) {
            determinant.setTemplateInstanceParameters(this.fParameters);
        }
        if ((result = this.fTemplateStruct.semanticGetMember(project, determinant, packageName, enclosingStruct, name, allowedElements, accessModifiers, maxModuleIndex, parserPath, exclude)) instanceof RfStructMember && !(((RfStructMember)result).getParentStruct() instanceof RfTemplateStructInstance)) {
            RfNamedElement assocType = result;
            try {
                result = (RfNamedElement)result.clone();
            }
            catch (CloneNotSupportedException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            IRfNamedElement instanceAssocType = ((IRfAssociatedType)((Object)assocType)).getAssociatedType();
            if (instanceAssocType != null) {
                String typeName = null;
                Determinant instanceAssocDeterminant = ((IRfAssociatedType)((Object)assocType)).getAssociatedTypeDeterminant();
                typeName = instanceAssocType instanceof RfListType ? (instanceAssocDeterminant == null ? ((RfListType)instanceAssocType).getAssociatedTypeName() : instanceAssocDeterminant.toString()) : (instanceAssocDeterminant == null ? instanceAssocType.getName() : instanceAssocDeterminant.toString());
                ((RfStructMember)result).setAssociatedType(this.getModule(), new WrapperType().setBaseName(typeName).setDefName(typeName));
                ((RfStructMember)result).setAssociatedTypeFrom(project, assocType);
            }
            ((RfStructMember)result).setParentStruct(this);
        }
        return result;
    }

    @Override
    public <T extends RfStructMember> Map<String, ListContainer<RfStructMember>> getAllMembersOfType(int kind) {
        return this.fTemplateStruct.getAllMembersOfType(kind);
    }

    @Override
    public String getContextType() {
        return this.fTemplateStruct.getContextType();
    }

    @Override
    public Determinant getDeterminant() {
        Determinant templateStructDeterminant = this.fTemplateStruct.getDeterminant();
        Determinant determinant = new Determinant(templateStructDeterminant.toArray());
        List<IRfAssociatedType> parameters = this.getParameters();
        determinant.setTemplateInstanceParameters(parameters);
        return determinant;
    }

    @Override
    public void setTransientDeterminant(Determinant determinant) {
        this.fTemplateStruct.setTransientDeterminant(determinant);
    }

    @Override
    public Determinant getTransientDeterminant() {
        return this.fTemplateStruct.getDeterminant();
    }

    @Override
    public List<RfStructMember> getMethods() {
        this.fTemplateStruct.setParamsValueOverride(this.fParameters);
        return this.fTemplateStruct.getMethods();
    }

    @Override
    public List<RfStructMember> getFields() {
        this.fTemplateStruct.setParamsValueOverride(this.fParameters);
        return this.fTemplateStruct.getFields();
    }

    @Override
    public List<RfStructMember> getEvents() {
        this.fTemplateStruct.setParamsValueOverride(this.fParameters);
        return this.fTemplateStruct.getEvents();
    }

    @Override
    public String javaClassParams() {
        this.fTemplateStruct.setParamsValueOverride(this.fParameters);
        return this.fTemplateStruct.javaClassParams();
    }

    @Override
    public <T extends RfStructMember> List<T> getMembersWithPrefix(boolean allSubtypes, int membersKind, Determinant determinant, String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        this.fTemplateStruct.setParamsValueOverride(this.fParameters);
        return this.fTemplateStruct.getMembersWithPrefix(allSubtypes, membersKind, determinant, packageName, enclosingStruct, matchType, prefix, accessModifiers);
    }

    @Override
    public List<RfField> getFieldsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        this.fTemplateStruct.setParamsValueOverride(this.fParameters);
        return this.fTemplateStruct.getFieldsWithPrefix(packageName, enclosingStruct, matchType, prefix, accessModifiers);
    }

    @Override
    public RfField getFieldWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        this.fTemplateStruct.setParamsValueOverride(this.fParameters);
        return this.fTemplateStruct.getFieldWithPrefix(packageName, enclosingStruct, matchType, prefix, accessModifiers);
    }

    @Override
    public List<RfMethod> getMethodsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        this.fTemplateStruct.setParamsValueOverride(this.fParameters);
        return this.fTemplateStruct.getMethodsWithPrefix(packageName, enclosingStruct, matchType, prefix, accessModifiers);
    }

    @Override
    public RfMethod getMethodWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        this.fTemplateStruct.setParamsValueOverride(this.fParameters);
        return this.fTemplateStruct.getMethodWithPrefix(packageName, enclosingStruct, matchType, prefix, accessModifiers);
    }

    @Override
    public List<RfEvent> getEventsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        this.fTemplateStruct.setParamsValueOverride(this.fParameters);
        return this.fTemplateStruct.getEventsWithPrefix(packageName, enclosingStruct, matchType, prefix, accessModifiers);
    }

    @Override
    public RfEvent getEventWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        this.fTemplateStruct.setParamsValueOverride(this.fParameters);
        return this.fTemplateStruct.getEventWithPrefix(packageName, enclosingStruct, matchType, prefix, accessModifiers);
    }

    @Override
    public List<RfExpect> getExpectsWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        this.fTemplateStruct.setParamsValueOverride(this.fParameters);
        return this.fTemplateStruct.getExpectsWithPrefix(packageName, enclosingStruct, matchType, prefix, accessModifiers);
    }

    @Override
    public RfExpect getExpectWithPrefix(String packageName, RfStruct enclosingStruct, int matchType, String prefix, int accessModifiers) {
        this.fTemplateStruct.setParamsValueOverride(this.fParameters);
        return this.fTemplateStruct.getExpectWithPrefix(packageName, enclosingStruct, matchType, prefix, accessModifiers);
    }

    @Override
    public List<RfVar> getVariablesWithPrefix(int line, int matchType, String prefix) {
        this.fTemplateStruct.setParamsValueOverride(this.fParameters);
        return this.fTemplateStruct.getVariablesWithPrefix(line, matchType, prefix);
    }

    @Override
    public RfVar getVariableWithPrefix(int line, int matchType, String prefix) {
        this.fTemplateStruct.setParamsValueOverride(this.fParameters);
        return this.fTemplateStruct.getVariableWithPrefix(line, matchType, prefix);
    }

    @Override
    public List<RfArg> getArgumentsWithPrefix(int matchType, String prefix) {
        this.fTemplateStruct.setParamsValueOverride(this.fParameters);
        return this.fTemplateStruct.getArgumentsWithPrefix(matchType, prefix);
    }

    @Override
    public RfArg getArgumentWithPrefix(int matchType, String prefix) {
        this.fTemplateStruct.setParamsValueOverride(this.fParameters);
        return this.fTemplateStruct.getArgumentWithPrefix(matchType, prefix);
    }

    @Override
    public List<RfEnum> getEnumsWithPrefix(int matchType, String prefix) {
        this.fTemplateStruct.setParamsValueOverride(this.fParameters);
        return this.fTemplateStruct.getEnumsWithPrefix(matchType, prefix);
    }

    @Override
    public RfEnum getEnumWithPrefix(int matchType, String prefix) {
        this.fTemplateStruct.setParamsValueOverride(this.fParameters);
        return this.fTemplateStruct.getEnumWithPrefix(matchType, prefix);
    }

    @Override
    public RfMeImplicitVariable getMeImplicitVariable(int matchType, String prefix) {
        this.fTemplateStruct.setParamsValueOverride(this.fParameters);
        return this.fTemplateStruct.getMeImplicitVariable(matchType, prefix);
    }

    @Override
    public RfPredefinedField getCompImplicitVariable(RfProject project, int matchType, String prefix) {
        this.fTemplateStruct.setParamsValueOverride(this.fParameters);
        return this.fTemplateStruct.getCompImplicitVariable(project, matchType, prefix);
    }

    @Override
    public boolean isInGlobal() {
        return this.fTemplateStruct.isInGlobal();
    }

    public RfTemplateStruct getTemplateStruct() {
        return this.fTemplateStruct;
    }

    @Override
    public boolean isPredefined() {
        return this.fTemplateStruct.isPredefined();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Assert.isTrue((boolean)false, (String)"Attempt to write a template instance object.");
    }

    @Override
    public boolean isUnit() {
        return this.fTemplateStruct.isUnit();
    }

    @Override
    public boolean checkEquals(Object obj) {
        if (obj instanceof RfTemplateStructInstance) {
            if (!this.fTemplateStruct.checkEquals(((RfTemplateStructInstance)obj).fTemplateStruct)) {
                return false;
            }
            List<IRfAssociatedType> params1 = this.fParameters;
            List<IRfAssociatedType> params2 = ((RfTemplateStructInstance)obj).fParameters;
            if (params1 == null && params2 == null) {
                return true;
            }
            if (params1 == null || params2 == null) {
                return false;
            }
            if (params1.size() != params2.size()) {
                return false;
            }
            int i = 0;
            while (i < params1.size()) {
                IRfAssociatedType param2;
                IRfAssociatedType param1 = params1.get(i);
                if (!((RfNamedElement)((Object)param1)).checkEquals(param2 = params1.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (obj instanceof RfTemplateStruct) {
            return this.fTemplateStruct.checkEquals(obj);
        }
        return false;
    }

    public void fillInUnspecifiedParams() {
        List<IRfTemplateParam> definedTemplateParameters = this.fTemplateStruct.getParameters();
        if (this.fParameters == null || definedTemplateParameters == null) {
            return;
        }
        if (this.fParameters.size() == definedTemplateParameters.size()) {
            return;
        }
        int i = this.fParameters.size();
        while (i < definedTemplateParameters.size()) {
            RfTemplateParam definedParam = (RfTemplateParam)definedTemplateParameters.get(i);
            if (definedParam == null) break;
            this.fParameters.add(definedParam.getParamValueDefault());
            ++i;
        }
    }

    @Override
    public boolean hasLocalMember(String name, Class<? extends RfEventLayer> clazz, int memberKind) {
        return this.fTemplateStruct.hasLocalMember(name, clazz, memberKind);
    }

    @Override
    public RfDefElement getLastLocalMethodLayer(String name) {
        return this.fTemplateStruct.getLastLocalMethodLayer(name);
    }

    @Override
    public RfDefElement getFirstLocalMethodLayer(String name) {
        return this.fTemplateStruct.getFirstLocalMethodLayer(name);
    }
}

