/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.util.Iterator;
import java.util.List;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.Range;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfStringType;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.WrapperParam;
import ro.amiq.edt.base.model.reflection.ascomputed.base.ETester;
import ro.amiq.edt.base.model.reflection.ascomputed.base.IRfType;
import ro.amiq.edt.base.model.reflection.ascomputed.base.__etools_string;
import ro.amiq.edt.base.model.reflection.semantic.SemanticUtils;

public abstract class RfType
extends RfNamedElement
implements IRfScope,
IRfType {
    private String fPackageName;
    private List<Range> fRangeModifiers;

    public RfType(RfProject project, String elementName) {
        super(project, elementName);
    }

    public void setPackageName(String packageName) {
        this.fPackageName = packageName;
    }

    @Override
    public String getPackageName() {
        if (this.fPackageName == null) {
            return "main";
        }
        return this.fPackageName;
    }

    protected void setDefinitionData(String packageName, int accessModifier) {
        this.setPackageName(packageName);
        this.setAccessModifier(accessModifier);
    }

    protected void setAssociatedType(String assocTypeName, String assocTypePackageName, boolean isEnum) {
    }

    protected void setDefinitionData(RfModule module, String packageName, boolean isUnit, boolean isPotentialUnit, int accessModifier) {
    }

    protected void setDefinitionData(RfModule module, List<WrapperParam> params, String packageName, boolean isUnit, boolean isPotentialUnit, int accessModifier) {
    }

    @Override
    public IRfScope getEnclosingScope() {
        return this.getModule();
    }

    protected boolean isDeclarationLayer(RfDefElement layer) {
        return layer.getLayerKind() == 0;
    }

    protected void removeDirty(RfProject project, RfStruct packg, Iterator<RfType> iterator) {
        try {
            if (this.hasNoLayers() || !this.isDeclaredIn(packg)) {
                iterator.remove();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void setVisibleRanges(List<Range> ranges) {
        this.fRangeModifiers = ranges;
    }

    public List<Range> getVisibleRanges() {
        return this.fRangeModifiers;
    }

    @Override
    protected void removeLayer(RfDefElement layer) {
        super.removeLayer(layer);
        if (this.hasNoDefs(false)) {
            this.fRangeModifiers = null;
        }
    }

    @Override
    protected void addLayer(RfDefElement layer) {
        super.addLayer(layer);
    }

    @Override
    public boolean isPredefined() {
        return false;
    }

    @Override
    public __etools_string get_name() {
        return new __etools_string(this.getName());
    }

    @Override
    public __etools_string get_value() {
        return null;
    }

    @Override
    public IRfType get_package() {
        return this.getRfProject().getPackage(this.getPackageName());
    }

    @Override
    public Object get_key(String fieldName) {
        return this;
    }

    public Object clone_deep() throws Exception {
        return this.clone();
    }

    public Object clone_copy() throws Exception {
        return this.clone();
    }

    public static ETester<Object> testIsA(final String rfTypeName, final Class<?> clazz) {
        return new ETester<Object>(){

            @Override
            public boolean test(Object arg) {
                if (arg instanceof RfStringType) {
                    return "rf_string".equals(rfTypeName);
                }
                if (arg instanceof RfStruct && "rf_sequence".equals(rfTypeName)) {
                    return ((RfStruct)arg).isSequence();
                }
                if (arg instanceof RfStruct && "rf_virtual_sequence".equals(rfTypeName)) {
                    return ((RfStruct)arg).isSequence() && ((RfStruct)arg).isSequenceVirtual();
                }
                if (arg instanceof RfStruct && "rf_bfm_sequence".equals(rfTypeName)) {
                    return ((RfStruct)arg).isSequence() && !((RfStruct)arg).isSequenceVirtual();
                }
                if (arg instanceof RfScalarType && "rf_numeric".equals(rfTypeName)) {
                    return ((RfScalarType)arg).isJavaNotEnum();
                }
                if (arg instanceof RfScalarType && "rf_enum".equals(rfTypeName)) {
                    return ((RfScalarType)arg).isEnumType() && !((RfScalarType)arg).isJavaNotEnum();
                }
                if (arg instanceof RfEnum && "rf_enum_item".equals(rfTypeName)) {
                    return true;
                }
                return clazz.isInstance(arg);
            }
        };
    }

    @Override
    public String javaName() {
        String name = this.getName();
        if ("rf_list".equals(name)) {
            return "RfListType";
        }
        if ("rf_numeric".equals(name)) {
            return "RfScalarType";
        }
        if ("rf_enum".equals(name)) {
            return "RfScalarType";
        }
        if ("rf_string".equals(name)) {
            return "RfStringType";
        }
        if ("rf_value_holder".equals(name)) {
            return "RfValueHolder";
        }
        if ("rf_module".equals(name)) {
            return "RfModule";
        }
        if (SemanticUtils.isSetName(this.getRfProject(), name)) {
            return "ESet";
        }
        return DVTStringUtil.appendString((Object[])new Object[]{"__etools_", this.getPackageName(), "_", name});
    }
}

