/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.IRfAssociatedType;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfActionBlockLayer;
import ro.amiq.edt.base.model.reflection.RfCoverItem;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.WrapperType;

public class RfVar
extends RfNamedElement
implements IRfAssociatedType {
    public static final int ITEM = 0;
    public static final int CROSS = 1;
    public static final int TRANSITION = 2;
    private boolean fSlnImplicitActionLabel;
    private String fTypeName;
    private boolean fTypeFromName;
    protected RfStruct fParentStruct;
    private transient IRfNamedElement fAssocType;
    private transient Determinant fAssocDeterminant;
    private transient String fAssocTypeListKey;
    private transient int fAssocTypeListDepth;
    private transient int fJavaVarDepth;
    private transient RfActionBlockLayer fReferredSLNActionBlockLayer;

    public RfVar(RfProject project, String name, String typeName) {
        super(project, name);
        this.fTypeName = DVTStringUtil.intern((String)typeName);
    }

    @Override
    public void deepClean() {
        try {
            if (this.fAssocDeterminant != null) {
                this.fAssocDeterminant.deepClean();
            }
            this.fAssocDeterminant = null;
            this.fAssocType = null;
            this.fParentStruct = null;
            super.deepClean();
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    public RfVar(RfProject project, RfModule module, RfStruct parentStruct, String name, WrapperType typeInfo, boolean takeVarOrFieldType) {
        super(project, name);
        this.fParentStruct = parentStruct;
        this.setAssociatedType(module, typeInfo);
    }

    public RfVar(RfProject project, String name) {
        super(project, name);
    }

    @Override
    public void setAssociatedType(RfModule module, WrapperType typeInfo) {
        if (typeInfo == null) {
            return;
        }
        this.fTypeFromName = typeInfo.typeFromName;
        this.fTypeName = typeInfo.baseType == 4 ? this.getTypeName(typeInfo.def, typeInfo.listDepth) : (typeInfo.baseType == 5 ? this.getTypeName(typeInfo.def, typeInfo.listDepth) : (typeInfo.baseType == 6 ? this.getTypeName(typeInfo.def, typeInfo.listDepth) : (typeInfo.baseType == 7 ? this.getTypeName(typeInfo.def, typeInfo.listDepth) : (typeInfo.baseType == 12 ? this.getTypeName(typeInfo.def, typeInfo.listDepth) : (typeInfo.baseType == 10 ? this.getTypeName(typeInfo.baseName, typeInfo.listDepth) : (typeInfo.baseType == 9 ? this.getTypeName(typeInfo.def == null ? this.getName() : typeInfo.def, typeInfo.listDepth) : this.getTypeName(typeInfo.def == null ? this.getName() : typeInfo.def, typeInfo.listDepth)))))));
        this.fTypeName = DVTStringUtil.intern((String)this.fTypeName);
    }

    @Override
    public IRfScopeElement getEnclosingScope() {
        RfDefElement layer = this.getDeclaration();
        if (layer == null) {
            return null;
        }
        IRfScope layerEnclosingScope = layer.getEnclosingScope();
        while (layerEnclosingScope != null && !(layerEnclosingScope instanceof RfMethodLayer)) {
            layerEnclosingScope = layerEnclosingScope.getEnclosingScope();
        }
        if (!(layerEnclosingScope instanceof RfMethodLayer)) {
            return null;
        }
        RfMethod method = ((RfMethodLayer)layerEnclosingScope).getMethod();
        if (method == null) {
            return null;
        }
        return method;
    }

    @Override
    public boolean hasTypeFromName() {
        return this.fTypeFromName;
    }

    public String getSignature() {
        String typeName = this.getSignatureTypeName();
        return "variable " + this.getName() + (typeName == null ? "" : " : " + typeName);
    }

    public String getSignatureTypeName() {
        String typeName = this.getAssociatedFullTypeName();
        int i = 0;
        while (i < this.getAssociatedTypeList()) {
            typeName = DVTStringUtil.appendString((Object[])new Object[]{"list of ", typeName});
            ++i;
        }
        return typeName;
    }

    public boolean resolveType(boolean incremental, ParserPath parserPath, RfProject project, IRfScope enclosing) {
        return false;
    }

    @Override
    public int getAssociatedTypeKind() {
        return this.decodeTypeKind(this);
    }

    public String getAssociatedTypeName() {
        if (this.fAssocType != null) {
            return this.fAssocType.getName();
        }
        return this.fTypeName;
    }

    public String getTypeName() {
        return this.fTypeName;
    }

    @Override
    public int getAssociatedTypeList() {
        return this.fAssocTypeListDepth;
    }

    @Override
    public String getAssociatedTypeListKey() {
        return this.fAssocTypeListKey;
    }

    @Override
    public String getAssociatedFullTypeName() {
        if (this.fAssocDeterminant != null) {
            return this.fAssocDeterminant.toString();
        }
        if (this.fAssocType != null) {
            return this.fAssocType.getName();
        }
        return this.fTypeName;
    }

    @Override
    public boolean checkEquals(Object obj) {
        boolean result = super.checkEquals(obj);
        if (result) {
            return true;
        }
        if (obj instanceof RfType && this.hasTypeFromName() && !(this instanceof RfCoverItem)) {
            return this.getName().equals(((RfType)obj).getName());
        }
        return false;
    }

    public void setKind(int coverItemKind) {
    }

    public void setCoverCrossItems(List<String> coverCrossItems) {
    }

    public int getKind() {
        return 0;
    }

    public RfType getAssociatedType() {
        return RfListType.listFromType(this.getRfProject(), (RfType)this.fAssocType, this.fAssocDeterminant, this.fAssocTypeListKey, this.fAssocTypeListDepth);
    }

    public RfType getAssociatedBaseType() {
        return (RfType)this.fAssocType;
    }

    public void setAssociatedType(RfType assocType) {
        if (assocType instanceof RfListType) {
            this.fAssocType = ((RfListType)assocType).getAssociatedBaseType();
            this.fAssocDeterminant = ((RfListType)assocType).getAssociatedTypeDeterminant();
            this.fAssocTypeListKey = ((RfListType)assocType).getAssociatedTypeListKey();
            this.fAssocTypeListDepth = ((RfListType)assocType).getAssociatedTypeList();
        } else {
            this.fAssocType = assocType;
            this.fAssocDeterminant = null;
            this.fAssocTypeListKey = null;
            this.fAssocTypeListDepth = 0;
        }
    }

    public void setAssociatedTypeList(int assocTypeListDepth) {
        this.fAssocTypeListDepth = assocTypeListDepth;
    }

    public void setAssociatedTypeListKey(String assocTypeListKey) {
        this.fAssocTypeListKey = assocTypeListKey;
    }

    public void setAssociatedTypeFrom(RfProject rfp, RfNamedElement typeContainer, boolean getItem) {
        if (typeContainer instanceof IRfAssociatedType) {
            this.fAssocType = ((IRfAssociatedType)((Object)typeContainer)).getAssociatedBaseType();
            this.fAssocDeterminant = ((IRfAssociatedType)((Object)typeContainer)).getAssociatedTypeDeterminant();
            this.fAssocTypeListKey = ((IRfAssociatedType)((Object)typeContainer)).getAssociatedTypeListKey();
            this.fAssocTypeListDepth = ((IRfAssociatedType)((Object)typeContainer)).getAssociatedTypeList() - (getItem ? 1 : 0);
        }
    }

    public void setAssociatedTypeFrom(RfProject rfp, RfNamedElement typeContainer) {
        this.setAssociatedTypeFrom(rfp, typeContainer, false);
    }

    public void setAssociatedTypeDeterminant(Determinant determinant) {
        this.fAssocDeterminant = determinant;
    }

    @Override
    public Determinant getAssociatedTypeDeterminant() {
        return Determinant.resolveTypeParam(this.fAssocDeterminant, this.fAssocType);
    }

    @Override
    public String elementPathName() {
        RfDefElement declaration = this.getDeclaration();
        if (declaration == null || declaration.getStartOffset() < 0) {
            return this.getName();
        }
        return String.valueOf(this.getName()) + "@" + declaration.getStartOffset();
    }

    @Override
    public String javaName() {
        if (this.fJavaVarDepth <= 0) {
            return super.javaName();
        }
        return String.valueOf(super.javaName()) + "_" + this.fJavaVarDepth;
    }

    @Override
    public int javaVarDepth() {
        return this.fJavaVarDepth;
    }

    @Override
    public String javaTypeName() {
        if (this.fAssocType == null) {
            return "__INTERNAL_ERROR";
        }
        String result = ((RfNamedElement)this.fAssocType).javaName();
        if (this.fAssocTypeListDepth > 0) {
            int i = 0;
            while (i < this.fAssocTypeListDepth) {
                result = this.fAssocTypeListKey != null && i == 0 ? DVTStringUtil.appendString((Object[])new Object[]{"EKeyedList<", result, ">"}) : DVTStringUtil.appendString((Object[])new Object[]{"EList<", result, ">"});
                ++i;
            }
        }
        return result;
    }

    public void setJavaVarDepth(int variableDepth) {
        this.fJavaVarDepth = variableDepth;
    }

    public void setReferredSLNActionBlockLayer(RfActionBlockLayer referredSLNActionBlockLayer) {
        this.fReferredSLNActionBlockLayer = referredSLNActionBlockLayer;
    }

    public RfNamedElement slnSemanticGetActionLabel(RfProject project, String name, LineInfo lineInfo) {
        RfNamedElement result = null;
        RfType assocType = this.getAssociatedBaseType();
        if (this.fReferredSLNActionBlockLayer != null) {
            result = this.fReferredSLNActionBlockLayer.getLocalVariable(name, LineInfo.INFINITE, null);
        }
        if (result == null && assocType instanceof RfStruct && ((RfStruct)assocType).isSLNAction()) {
            result = ((RfStruct)assocType).slnSemanticGetActionLabel(project, name, lineInfo);
        }
        return result;
    }

    public void setSlnImplicitActionLabel() {
        this.fSlnImplicitActionLabel = true;
    }

    public boolean hasSlnImplicitActionLabel() {
        return this.fSlnImplicitActionLabel;
    }

    public boolean isIterator() {
        return false;
    }

    public boolean isIndex() {
        return false;
    }

    public static class RfIndexVar
    extends RfVar {
        public RfIndexVar(RfProject project, String name) {
            super(project, name);
        }

        public RfIndexVar(RfProject project, RfModule module, RfStruct parentStruct, String name, WrapperType type, boolean takeVarOrFieldType) {
            super(project, module, parentStruct, name, type, takeVarOrFieldType);
        }

        @Override
        public boolean isIndex() {
            return true;
        }
    }

    public static class RfIteratorVar
    extends RfVar {
        public RfIteratorVar(RfProject project, String name) {
            super(project, name);
        }

        public RfIteratorVar(RfProject project, RfModule module, RfStruct parentStruct, String name, WrapperType type, boolean takeVarOrFieldType) {
            super(project, module, parentStruct, name, type, takeVarOrFieldType);
        }

        @Override
        public boolean isIterator() {
            return true;
        }
    }
}

