/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.ascomputed;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.apache.commons.io.output.NullWriter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.compiler.tool.EclipseCompiler;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.ascomputed.AsComputedCompilerUtils;
import ro.amiq.edt.base.model.reflection.ascomputed.AsComputedProcessor;

public class AsComputedCompiler {
    private static volatile AsComputedCompiler fInstance;
    public static final Object fSyncInstance;
    public static final Pattern WRAPPER_NAME;
    private JavaCompiler fCompiler = new EclipseCompiler();
    private MemoryFileManager fManager;
    private List<String> fOptions;
    private ErrorsCollector<JavaFileObject> fDiagCollector;
    private Map<String, Property> fCompiledClasses;
    private AsComputedClassLoader fClassLoader;
    private boolean fDebugLog;
    private static final Pattern MEMO_PATH;

    static {
        fSyncInstance = new Object();
        WRAPPER_NAME = Pattern.compile("[AECST][a-z_]+Wrapper");
        MEMO_PATH = Pattern.compile("memo://");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AsComputedCompiler getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new AsComputedCompiler();
            }
        }
        return fInstance;
    }

    public boolean doCompile(Map<String, String> classes, AsComputedProcessor asComputedProcessor, boolean[] nothingToCompile) {
        String javaTypeName;
        int newHash;
        if (this.fCompiler == null) {
            if (asComputedProcessor != null) {
                asComputedProcessor.setJavaCompilerError(true);
            }
            return false;
        }
        if (this.fManager == null) {
            this.fManager = new MemoryFileManager(this.fCompiler);
        }
        if (this.fCompiledClasses == null) {
            this.fCompiledClasses = new HashMap<String, Property>();
        }
        this.fDiagCollector = new ErrorsCollector();
        ArrayList<Source> list = new ArrayList<Source>();
        for (Map.Entry<String, String> entry : classes.entrySet()) {
            String javaTypeClass = entry.getValue();
            if (javaTypeClass == null) continue;
            String javaTypeName2 = entry.getKey();
            Property oldProperty = this.fCompiledClasses.get(javaTypeName2);
            newHash = javaTypeClass.hashCode();
            if (oldProperty != null && oldProperty.getHashCode() == newHash) {
                if (!oldProperty.hasErrors()) continue;
                nothingToCompile[0] = true;
                return false;
            }
            list.add(new Source(javaTypeName2, JavaFileObject.Kind.SOURCE, javaTypeClass));
        }
        if (list.isEmpty()) {
            nothingToCompile[0] = true;
            return true;
        }
        if (this.fDebugLog) {
            DVTLogger.INSTANCE.logDebug("AS_COMPUTED: *** Info:  Recompiling list (removed cached classes): " + ((Object)list).toString());
        }
        boolean success = this.doCompile(list);
        for (Source source : list) {
            String javaTypeClass = (String)source.getCharContent(false);
            javaTypeName = source.getRawName();
            newHash = javaTypeClass.hashCode();
            this.fCompiledClasses.put(javaTypeName, new Property(newHash));
        }
        if (!success) {
            for (Diagnostic diagnostic : this.fDiagCollector.getDiagnostics()) {
                Property property;
                JavaFileObject source;
                if (diagnostic.getKind() != Diagnostic.Kind.ERROR || !((source = (JavaFileObject)diagnostic.getSource()) instanceof Source) || (property = this.fCompiledClasses.get(javaTypeName = ((Source)source).getRawName())) == null) continue;
                property.setHasErrors();
            }
        }
        nothingToCompile[0] = false;
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean(boolean cleanCompiledClasses) {
        Object object = fSyncInstance;
        synchronized (object) {
            if (cleanCompiledClasses) {
                if (this.fManager != null) {
                    this.fManager.clear();
                }
                if (this.fCompiledClasses != null) {
                    this.fCompiledClasses.clear();
                }
            }
            this.fClassLoader = null;
            this.fDiagCollector = new ErrorsCollector();
        }
    }

    public byte[] getBytecode(String className) {
        ByteArrayOutputStream output;
        block3: {
            try {
                output = this.fManager.getOutputStream(className.replace('/', '.'));
                if (output != null) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        byte[] bytecode = output.toByteArray();
        output.close();
        return bytecode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doCompile(List<Source> list) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (NullWriter out = new NullWriter();){
                this.initClassPath();
                JavaCompiler.CompilationTask compilationTask = this.fCompiler.getTask((Writer)out, this.fManager, this.fDiagCollector, this.fOptions, null, list);
                if (compilationTask != null) return compilationTask.call();
                return false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    private void initClassPath() {
        if (this.fOptions != null) {
            return;
        }
        this.fOptions = AsComputedCompilerUtils.initClassPath();
    }

    public ClassLoader getClassLoader() {
        if (this.fClassLoader == null) {
            this.fClassLoader = new AsComputedClassLoader(this.getClass());
        }
        return this.fClassLoader;
    }

    public void printErrors(IProject project, String debugPath) {
        if (project == null || this.fDiagCollector == null) {
            return;
        }
        String fullDebugPath = debugPath == null ? "" : Path.fromOSString((String)debugPath).append("ro.amiq.edt.base.debug.ascomputed".replace('.', '/')).toOSString();
        for (Diagnostic<JavaFileObject> diagnostic : this.fDiagCollector.getDiagnostics()) {
            try {
                URI uri;
                DVTBuildConsole console;
                String message;
                if (diagnostic.getKind() != Diagnostic.Kind.ERROR || (message = diagnostic.getMessage(null)) == null) continue;
                message = MEMO_PATH.matcher(message).replaceFirst(fullDebugPath);
                if (this.fDebugLog) {
                    DVTLogger.INSTANCE.logDebug("AS_COMPUTED: *** COMPILER ERROR: " + message);
                }
                if ((console = DVTBuildConsoleRegistry.getConsole((IProject)project)) == null) {
                    return;
                }
                int index = message.lastIndexOf(".java:");
                if (index > 0 && (index = message.indexOf(58, index + 6)) > 0) {
                    message = message.substring(index + 1).trim();
                }
                message = message.replace("\n", "\n    ");
                String fileName = null;
                JavaFileObject source = diagnostic.getSource();
                if (source != null && (uri = source.toUri()) != null) {
                    fileName = uri.toString();
                }
                if (fileName == null) {
                    Field fileNameField = diagnostic.getClass().getDeclaredField("val$originatingFileName");
                    fileNameField.setAccessible(true);
                    char[] fileNameCharArray = (char[])fileNameField.get(diagnostic);
                    fileName = "memo://" + new String(fileNameCharArray);
                }
                fileName = MEMO_PATH.matcher(fileName).replaceFirst(fullDebugPath);
                String messageToPrint = "*** Error: COMPILER_ERROR: " + message + "\n    at line " + (diagnostic.getLineNumber() - 1L) + " in " + fileName;
                console.print(messageToPrint);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            catch (Exception exception) {}
        }
    }

    public void setDebugLog(boolean debugLog) {
        this.fDebugLog = debugLog;
    }

    class AsComputedClassLoader
    extends ClassLoader {
        protected Map<String, Class<?>> fLoadedClasses;

        public AsComputedClassLoader(Class<?> parent) {
            super(parent.getClassLoader());
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (AsComputedCompiler.this.fDebugLog) {
                DVTLogger.INSTANCE.logDebug(DVTStringUtil.appendString((Object[])new Object[]{"DVT_DEBUG_MODE", "AS_COMPUTED: Load '", DVTStringUtil.replaceAll((Pattern)WRAPPER_NAME, (CharSequence)name.replace("__etools_", ""), (String)""), "' ..."}));
            }
            if (this.fLoadedClasses == null) {
                this.fLoadedClasses = new HashMap();
            }
            if (this.fLoadedClasses.containsKey(name)) {
                return this.fLoadedClasses.get(name);
            }
            byte[] bytecode = AsComputedCompiler.this.getBytecode(name);
            if (bytecode == null) {
                return null;
            }
            Class<?> clazz = this.defineClass(name, bytecode, 0, bytecode.length);
            this.fLoadedClasses.put(name, clazz);
            return clazz;
        }
    }

    public static final class ErrorsCollector<S>
    implements DiagnosticListener<S> {
        private List<Diagnostic<? extends S>> fDiagnostics = new ArrayList<Diagnostic<? extends S>>();

        @Override
        public void report(Diagnostic<? extends S> diagnostic) {
            if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
                this.fDiagnostics.add(diagnostic);
            }
        }

        public List<Diagnostic<? extends S>> getDiagnostics() {
            return Collections.unmodifiableList(this.fDiagnostics);
        }

        public void clear() {
            if (!this.fDiagnostics.isEmpty()) {
                this.fDiagnostics.clear();
            }
        }
    }

    private static final class MemoryFileManager
    extends ForwardingJavaFileManager<JavaFileManager> {
        private Map<String, Output> fMap = new HashMap<String, Output>();
        private Map<String, JavaFileObject> fCache = new HashMap<String, JavaFileObject>();
        private Map<String, Iterable<JavaFileObject>> fListCache = new HashMap<String, Iterable<JavaFileObject>>();

        protected MemoryFileManager(JavaCompiler compiler) {
            super(compiler.getStandardFileManager(null, null, null));
        }

        @Override
        public Output getJavaFileForOutput(JavaFileManager.Location location, String name, JavaFileObject.Kind kind, FileObject source) {
            Output mc = new Output(name.replace('/', '.'), kind);
            this.fMap.put(name, mc);
            return mc;
        }

        protected ByteArrayOutputStream getOutputStream(String name) {
            Output clazz = this.fMap.get(name.replace('.', '/'));
            if (clazz == null) {
                return null;
            }
            return clazz.openOutputStream();
        }

        @Override
        public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
            Output clazz = this.fMap.get(className);
            if (clazz != null) {
                return clazz;
            }
            String key = "|" + location.getName() + "|" + (Object)((Object)kind) + "|" + className;
            JavaFileObject result = this.fCache.get(key);
            if (result == null) {
                result = super.getJavaFileForInput(location, className, kind);
                this.fCache.put(key, result);
            }
            return result;
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
            if (packageName.replace('.', '/').equals("ro.amiq.edt.base.debug.ascomputed")) {
                ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>(this.fMap.values());
                return result;
            }
            String key = "|" + packageName + "|" + location.getName() + "|" + kinds.stream().map(k -> k.toString()).collect(Collectors.joining(",")) + "|" + recurse;
            Iterable<JavaFileObject> result = this.fListCache.get(key);
            if (result == null) {
                result = super.list(location, packageName.replace('/', '.'), kinds, recurse);
                this.fListCache.put(key, result);
            }
            return result;
        }

        @Override
        public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
            if (file instanceof Output) {
                return file.getName().substring(1).replace(".class", "").replace('/', '.');
            }
            String result = super.inferBinaryName(location, file);
            return result;
        }

        public void clear() {
            this.fMap.clear();
            this.fCache.clear();
            this.fListCache.clear();
        }
    }

    private static final class Output
    extends SimpleJavaFileObject {
        private ByteArrayOutputStream fOutput = new ByteArrayOutputStream();

        protected Output(String name, JavaFileObject.Kind kind) {
            super(URI.create("memo:///" + name + kind.extension), kind);
        }

        @Override
        public ByteArrayOutputStream openOutputStream() {
            return this.fOutput;
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return new ByteArrayInputStream(this.fOutput.toByteArray());
        }
    }

    public static final class Property {
        int fHashCode;
        boolean fHasErrors;

        public Property(int hashCode) {
            this.fHashCode = hashCode;
        }

        public int getHashCode() {
            return this.fHashCode;
        }

        public void setHasErrors() {
            this.fHasErrors = true;
        }

        public boolean hasErrors() {
            return this.fHasErrors;
        }
    }

    private static final class Source
    extends SimpleJavaFileObject {
        private final String fContent;
        private final String fName;

        protected Source(String name, JavaFileObject.Kind kind, String content) {
            super(URI.create("memo:///" + name.replace('.', '/') + kind.extension), kind);
            this.fName = name;
            this.fContent = content;
        }

        public String getRawName() {
            return this.fName;
        }

        @Override
        public CharSequence getCharContent(boolean ignore) {
            return this.fContent;
        }
    }
}

