/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.ascomputed;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.core.EDTBasePlugin;

public class AsComputedCompilerUtils {
    public static final Pattern WS_COMMA_WS = Pattern.compile("\\s*,\\s*");

    public static List<String> initClassPath() {
        StringBuilder classPathBuilder = new StringBuilder();
        Bundle dvtBundle = DVTPlugin.getDefault().getBundle();
        Bundle edtBaseBundle = EDTBasePlugin.getDefault().getBundle();
        try {
            String[] candidates;
            String[] stringArray = candidates = DVTStringUtil.split((Pattern)WS_COMMA_WS, (String)((String)edtBaseBundle.getHeaders().get("Bundle-ClassPath")));
            int n = candidates.length;
            int n2 = 0;
            while (n2 < n) {
                String candidate = stringArray[n2];
                if (candidate.contains("eparser-tee-")) {
                    URL eParserURL = FileLocator.find((Bundle)edtBaseBundle, (IPath)new Path(candidate), null);
                    if (eParserURL != null) {
                        classPathBuilder.append(File.pathSeparator).append(FileLocator.toFileURL((URL)eParserURL).getPath());
                    }
                    break;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        try {
            Bundle adaptableBundle = FrameworkUtil.getBundle(IAdaptable.class);
            File bundleFile = FileLocator.getBundleFile((Bundle)adaptableBundle);
            if (bundleFile != null) {
                classPathBuilder.append(File.pathSeparator).append(bundleFile.getAbsolutePath());
            }
        }
        catch (Exception exception) {}
        try {
            String bundleFilePath;
            File bundleFile = FileLocator.getBundleFile((Bundle)edtBaseBundle);
            if (bundleFile != null) {
                bundleFilePath = bundleFile.getAbsolutePath();
                classPathBuilder.append(File.pathSeparator).append(bundleFilePath);
                if (!bundleFilePath.endsWith(".jar")) {
                    classPathBuilder.append(File.separator).append("bin");
                }
            }
            if ((bundleFile = FileLocator.getBundleFile((Bundle)dvtBundle)) != null) {
                bundleFilePath = bundleFile.getAbsolutePath();
                classPathBuilder.append(File.pathSeparator).append(bundleFilePath);
                if (!bundleFilePath.endsWith(".jar")) {
                    classPathBuilder.append(File.separator).append("bin");
                }
            }
        }
        catch (Exception exception) {}
        String classPath = classPathBuilder.toString();
        DVTLogger.INSTANCE.logInfo("CLASS_PATH = " + classPath);
        return Arrays.asList("-classpath", classPath, "-1.8", "-nowarn");
    }
}

