/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.ascomputed;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;
import ro.amiq.dvt.builders.DVTConsoleButtonsDescription;
import ro.amiq.dvt.builders.DVTMessageConsole;
import ro.amiq.dvt.externaltools.ConsoleHighlightModelManager;
import ro.amiq.dvt.externaltools.ExternalToolsConfiguration;
import ro.amiq.dvt.externaltools.ExternalToolsModelManager;
import ro.amiq.dvt.externaltools.IConsoleScanListener;
import ro.amiq.dvt.externaltools.IExternalToolsConfiguration;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.utils.EDTFileUtils;

public class AsComputedConsoleViewer {
    private DVTMessageConsole fConsole;
    private IConsoleScanListener fListener;
    private RfProject fRfProject;
    private IConsoleManager fConsoleManager;
    private static final Pattern fPattern = Pattern.compile("at\\sline\\s(\\d+)\\sin\\s[']([^']+)[']");

    public void dispose() {
        if (this.fConsole == null || this.fListener == null) {
            return;
        }
        this.fConsole.removePatternMatchListener((IPatternMatchListener)this.fListener);
        this.fConsoleManager.removeConsoles(new IConsole[]{this.fConsole});
    }

    private void createConsole() {
        if (this.fConsole != null) {
            return;
        }
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        this.fConsoleManager = plugin.getConsoleManager();
        this.fConsole = new DVTMessageConsole(this.fRfProject.getProject(), "[" + this.fRfProject.getProject().getName() + "] computed macros output", null, new DVTConsoleButtonsDescription(false, false, true));
        this.fListener = new ConsoleListener();
        this.fConsole.addPatternMatchListener((IPatternMatchListener)this.fListener);
        this.fConsoleManager.addConsoles(new IConsole[]{this.fConsole});
        ConsoleHighlightModelManager.getInstance().fConsoleToListeners.putIfAbsent(this.fConsole, new ConcurrentLinkedQueue());
        Queue listeners = (Queue)ConsoleHighlightModelManager.getInstance().fConsoleToListeners.get(this.fConsole);
        listeners.add(this.fListener);
        ExternalToolsConfiguration config = new ExternalToolsConfiguration();
        ExternalToolsModelManager.getInstance().setProcessConsole((IConsole)this.fConsole, this.fRfProject.getProject(), (IExternalToolsConfiguration)config, null, 1, this.fRfProject.getProject().getLocation().toOSString());
    }

    public void notifyMacroMessage(final String message, RfProject rfProject, final int severity) {
        if (message == null || rfProject == null) {
            return;
        }
        this.fRfProject = rfProject;
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (AsComputedConsoleViewer.this.fConsole == null) {
                        AsComputedConsoleViewer.this.createConsole();
                    }
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try (MessageConsoleStream out = AsComputedConsoleViewer.this.fConsole.newMessageStream();){
                        if (severity == 1) {
                            out.setColor(DVTColorUtil.INSTANCE.getColor(255, 0, 0));
                        } else if (severity == 2) {
                            out.setColor(DVTColorUtil.INSTANCE.getColor(255, 150, 0));
                        }
                        out.setActivateOnWrite(true);
                        out.println(message);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        });
    }

    public String testGetConsoleContent() {
        if (this.fConsole == null) {
            return null;
        }
        IDocument document = this.fConsole.getDocument();
        if (document == null) {
            return null;
        }
        return document.get();
    }

    class ConsoleListener
    implements IConsoleScanListener {
        private TextConsole fConsole;
        private TextConsoleViewer fConsoleViewer;

        ConsoleListener() {
        }

        public TextConsoleViewer getConsoleViewer() {
            return this.fConsoleViewer;
        }

        public TextConsole getConsole() {
            return this.fConsole;
        }

        public void connect(TextConsole console) {
            this.fConsole = console;
        }

        public void disconnect() {
            this.fConsole = null;
            this.fConsoleViewer = null;
        }

        public void addHyperlink(int offset, int length) {
            try {
                IDocument document = this.fConsole.getDocument();
                int line = -1;
                String file = "";
                Matcher m = fPattern.matcher(document.get(offset, length));
                if (!m.matches() || m.groupCount() != 2) {
                    return;
                }
                line = Integer.parseInt(m.group(1));
                file = m.group(2);
                if (AsComputedConsoleViewer.this.fRfProject == null) {
                    return;
                }
                if (line != -1) {
                    Hyperlink link = new Hyperlink(AsComputedConsoleViewer.this.fRfProject, file, line);
                    this.fConsole.addHyperlink((IHyperlink)link, offset, length);
                }
            }
            catch (Exception x) {
                DVTLogger.INSTANCE.logError((Throwable)x);
            }
        }

        public int getCompilerFlags() {
            return 0;
        }

        public String getLineQualifier() {
            return "at line";
        }

        public String getPattern() {
            return fPattern.pattern();
        }

        public Pattern getWholePattern() {
            return fPattern;
        }

        public void setConsoleViewer(TextConsoleViewer newConsoleViewer) {
            this.fConsoleViewer = newConsoleViewer;
        }
    }

    private class Hyperlink
    implements IHyperlink {
        private RfProject rfProject;
        private String fileName;
        private int line;

        Hyperlink(RfProject rfProject, String file, int line) {
            this.rfProject = rfProject;
            this.fileName = file;
            this.line = line;
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }

        public void linkActivated() {
            IFile file;
            if (this.rfProject == null) {
                return;
            }
            RfModule module = null;
            if (!Path.fromOSString((String)this.fileName).isAbsolute() && (file = EDTFileUtils.getInstance().findProjectFile(AsComputedConsoleViewer.this.fRfProject.getProject(), this.fileName)) != null) {
                module = this.rfProject.getModule((IResource)file);
            }
            if (module == null) {
                module = this.rfProject.getModule(new ParserPath(this.fileName));
            }
            if (module == null) {
                module = this.rfProject.getModuleUsingLastSegment(this.fileName);
            }
            if (module == null) {
                return;
            }
            EDTFileUtils.getInstance().openFile(this.rfProject.getModelManager(), this.rfProject.getProject(), module.getParserPath().path, this.line, null);
        }
    }
}

