/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.ascomputed;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.IEProject;
import ro.amiq.edt.base.model.reflection.RfActionBlockLayer;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfPseudoListField;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.ascomputed.AsComputedCompiler;
import ro.amiq.edt.base.model.reflection.ascomputed.AsComputedConsoleViewer;
import ro.amiq.edt.base.model.reflection.ascomputed.ClassEncap;
import ro.amiq.edt.base.model.reflection.ascomputed.base.__etools_string;
import ro.amiq.edt.base.model.reflection.semantic.RfDummyField;
import ro.amiq.edt.base.utils.EDTFileUtils;
import ro.amiq.etools.eparser.EModuleLexer;
import ro.amiq.etools.eparser.ascomputed.AsComputedException;
import ro.amiq.etools.eparser.ascomputed.IAsComputedExecutionPrintStream;
import ro.amiq.etools.eparser.ascomputed.IAsComputedExecutionProvider;
import ro.amiq.etools.eparser.ascomputed.RejectMatchException;

public class AsComputedProcessor {
    public static final String JAVA_NAME_PREFIX = "__etools_";
    public static final String REPLACEMENT_TERM_VAR = "__etools_replacement_";
    public static final String EMODULE_ARGUMENT = "__etools_module";
    public static final String MATCHER_VARIABLE = "__etools_matcher";
    public static final String COMPUTE_DUMMY_OBJ = "__etools_compute_dummy";
    public static final String DVT_EXP_EVALUATE_FAIL_PREFIX = "DVT_EXP_EVALUATE_FAIL_";
    public static final String INTERNAL_ERROR = "__INTERNAL_ERROR";
    private boolean initDefinitions;
    private RfProject project;
    private int pseudoMethodIndex;
    private int temporaryExprIndex;
    private StringBuilder pseudoMethodsJavaCode = new StringBuilder();
    private Map<String, Map<String, String>> cachedModuleClasses = new HashMap<String, Map<String, String>>();
    private final Class<?>[] params = new Class[1];
    private final Object[] argumentList = new Object[1];
    public long totalGenerationType = 0L;
    public long totalCompilerTime = 0L;
    public long totalExecutionType = 0L;
    private boolean javaCompilerNotFound;
    private boolean disable;
    private String lastMacroInfo;
    private String prevMacroInfo;
    private AsComputedConsoleViewer console;
    private boolean debugLog;
    private String debugPath;
    private Map<String, String> primitiveTypesMap;

    public AsComputedProcessor(RfProject project) {
        this.project = project;
        this.primitiveTypesMap = new HashMap<String, String>();
    }

    public static final StringBuilder indent(StringBuilder text, int level) {
        int i = 0;
        while (i < level * 4) {
            text.append(' ');
            ++i;
        }
        return text;
    }

    public String getArguments(boolean asComputed, String[] patterns, String[] separators, int level) {
        if (!asComputed) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < separators.length) {
            String typeName = "__etools_string";
            String name = REPLACEMENT_TERM_VAR + (i + 1);
            AsComputedProcessor.indent(result, level);
            if (separators[i] == null) {
                result.append(typeName).append(" ").append(name).append(" = __global.toEString(").append(EMODULE_ARGUMENT).append(".getGroup(\"").append(i + 1).append("\", \"\"));\n");
            } else {
                result.append("EList<").append(typeName).append("> ").append(name).append(" = __global.toEString(").append(EMODULE_ARGUMENT).append(".getGroup(\"").append(i + 1).append("\", \"\"), \"").append(separators[i]).append("\");\n");
            }
            ++i;
        }
        AsComputedProcessor.indent(result, level);
        result.append("__etools_string __etools_result = new __etools_string();\n");
        return result.toString();
    }

    public RfNamedElement getReplVariable(String[] patterns, String[] separators, String name) {
        if (this.isNumber(name)) {
            return this.getReplVariableForIndex(separators, Integer.parseInt(name) - 1);
        }
        int i = 0;
        while (i < patterns.length) {
            if (name.equals(patterns[i])) {
                return this.getReplVariableForIndex(separators, i);
            }
            ++i;
        }
        return null;
    }

    private RfNamedElement getReplVariableForIndex(String[] separators, int index) {
        final String typeName = separators[index] == null ? "__etools_string" : "EList<__etools_string>";
        final String varName = REPLACEMENT_TERM_VAR + (index + 1);
        return new RfDummyField(this.project, null){

            @Override
            public String javaName() {
                return varName;
            }

            @Override
            public String javaTypeName() {
                return typeName;
            }
        };
    }

    private boolean isNumber(String name) {
        int i = 0;
        while (i < name.length()) {
            char ch = name.charAt(i);
            if (ch < '0' || ch > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void reset(boolean resetIndex, boolean initDefinitions) {
        this.initDefinitions = initDefinitions;
        if (resetIndex) {
            this.pseudoMethodIndex = 0;
            this.temporaryExprIndex = 0;
        }
        this.pseudoMethodsJavaCode.delete(0, this.pseudoMethodsJavaCode.length());
    }

    public String getInitDefinitions(int indentLevel) {
        if (!this.initDefinitions) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        result.append("__etools_rf_manager = (RfProject) ").append(EMODULE_ARGUMENT).append(".getRfManager();\n");
        result.append("__etools_e_module = ").append(EMODULE_ARGUMENT).append(";\n");
        AsComputedProcessor.indent(result, indentLevel);
        result.append("__global.__etools_push_matcher();");
        this.initDefinitions = false;
        return result.toString();
    }

    public void setClass(boolean asComputed, String className, String classContent, Collection<RfType> referedTypes) {
        if (!asComputed) {
            return;
        }
        referedTypes.add(this.project.getType("main", true, 1, "base_struct", -1));
        referedTypes.add(this.project.getType("main", true, 1, "any_struct", -1));
        referedTypes.add(this.project.getType("main", true, 1, "ntv", -1));
        referedTypes.add(this.project.getType("main", true, 1, "global", -1));
        EDTFileUtils.getInstance().dumpAsComputedDebug(this.project.getProject(), className, classContent);
        this.project.getAsComputedJavaClassMap().put(className, new ClassEncap("\n" + classContent, referedTypes, false));
    }

    public StringBuilder getClassHeader(boolean asComputed, String className) {
        if (!asComputed) {
            return null;
        }
        StringBuilder result = new StringBuilder("package ").append("ro.amiq.edt.base.debug.ascomputed").append(";\n").append("import ro.amiq.dvt.model.reflection.*;\n").append("import static ro.amiq.edt.base.debug.ascomputed.__etools_main_global.*;\n").append("import ro.amiq.edt.base.model.reflection.*;\n").append("import ro.amiq.edt.base.model.reflection.ascomputed.*;\n\n").append("import ro.amiq.etools.eparser.EModuleLexer;\n").append("import ro.amiq.edt.base.model.reflection.ascomputed.base.*;\n\n").append("import java.util.regex.*;\n").append("import java.util.*;\n\n").append("public final class ").append(className).append(" extends __etools_main_ntv {\n\n").append("    public final __etools_string evaluate(EModuleLexer ").append(EMODULE_ARGUMENT).append(") throws Exception {\n").append("        try {\n");
        return result;
    }

    public final boolean genClassEncaps(Map<String, String> result, Collection<RfType> referedTypes) {
        if (referedTypes == null) {
            return false;
        }
        boolean newElementsToTranslate = false;
        for (RfType referedType : referedTypes) {
            String typeName;
            String javaTypeName;
            if (referedType == null || result.containsKey(javaTypeName = referedType.javaName()) || "rf_enum".equals(typeName = referedType.getName()) || "rf_like_struct".equals(typeName) || "rf_sequence".equals(typeName) || "rf_bfm_sequence".equals(typeName) || "rf_bool".equals(typeName) || "rf_method".equals(typeName) || "rf_event".equals(typeName) || "rf_field".equals(typeName) || "rf_buffer_port".equals(typeName) || "rf_event_port".equals(typeName) || "rf_list".equals(typeName) || "rf_keyed_list".equals(typeName)) continue;
            ClassEncap classEncap = referedType.toClassEncap(this.project);
            if (classEncap == null) {
                result.put(javaTypeName, null);
                continue;
            }
            newElementsToTranslate |= classEncap.hasNewElementsToTranslate();
            result.put(javaTypeName, classEncap.getContent());
            newElementsToTranslate |= this.genClassEncaps(result, classEncap.getRefered());
        }
        return newElementsToTranslate;
    }

    public StringBuilder getClassFooter(boolean asComputed, int indentLevel) {
        if (!asComputed) {
            return null;
        }
        StringBuilder result = new StringBuilder().append("        \n").append("        } catch (AsComputedReturnException e) {\n").append("                return null;\n").append("        } catch (Exception e) {\n").append(EMODULE_ARGUMENT).append(".setAsComputedInvocationException(e);\n").append("        } finally {\n").append("            __global.__etools_pop_matcher();\n").append("        }\n").append("        return null;\n").append("    }\n\n").append((CharSequence)this.pseudoMethodsJavaCode).append("}\n");
        return result;
    }

    public StringBuilder getPseudoMethodsJavaCode() {
        return this.pseudoMethodsJavaCode;
    }

    public static String getEvaluateString(String input) {
        if (input == null || input.length() == 0) {
            return input;
        }
        StringBuilder result = new StringBuilder();
        int pch = 32;
        int ppch = 32;
        int i = 0;
        while (i < input.length()) {
            char ch = input.charAt(i);
            if (ch == '\r' || ch == '\n') {
                result.append(' ');
            } else if ((ch == 'r' || ch == 'n' || ch == 't' || ch == '\"') && pch == 92) {
                result.append(ch);
            } else if (ppch == 92 && pch == 92 && ch != '\\') {
                result.append(ch);
            } else if (pch == 92 && ch != '\\') {
                result.append('\\').append(ch);
            } else {
                result.append(ch);
            }
            ppch = pch;
            pch = ch;
            ++i;
        }
        return result.toString();
    }

    public final IAsComputedExecutionProvider getExecProvider() {
        if (this.disable) {
            return null;
        }
        return new IAsComputedExecutionProvider(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String execute(String asComputedName, String asComputedKind, EModuleLexer module) throws Exception {
                String defaultResult = asComputedKind.equals("exp") ? AsComputedProcessor.DVT_EXP_EVALUATE_FAIL_PREFIX + asComputedName : "";
                Object object = AsComputedCompiler.fSyncInstance;
                synchronized (object) {
                    try {
                        String messageToPrint;
                        DVTBuildConsole console;
                        ClassEncap classEncap;
                        AsComputedProcessor.this.project.checkBuildCanceled();
                        String className = asComputedName + asComputedKind.substring(0, 1).toUpperCase() + asComputedKind.substring(1) + "Wrapper";
                        boolean generateAndCompileClasses = false;
                        Map<String, String> macroCachedModuleClasses = AsComputedProcessor.this.cachedModuleClasses.get(className);
                        if (macroCachedModuleClasses == null) {
                            macroCachedModuleClasses = new HashMap<String, String>();
                            AsComputedProcessor.this.cachedModuleClasses.put(className, macroCachedModuleClasses);
                            generateAndCompileClasses = true;
                        }
                        int line = module == null ? -1 : module.getLine();
                        String eModuleName = module == null ? "N/A" : module.getEModuleName();
                        AsComputedProcessor.this.lastMacroInfo = "at line " + line + " in '" + Path.fromOSString((String)eModuleName).lastSegment() + "'";
                        long time = System.currentTimeMillis();
                        Map<String, ClassEncap> asComputedJavaClassMap = AsComputedProcessor.this.project.getAsComputedJavaClassMap();
                        ClassEncap classEncap2 = classEncap = asComputedJavaClassMap == null ? null : asComputedJavaClassMap.get(className);
                        if (classEncap == null) {
                            if (AsComputedProcessor.this.debugLog) {
                                DVTLogger.INSTANCE.logDebug("AS_COMPUTED: *** ERROR: Java class '" + className + "' content is null.");
                            }
                            return defaultResult;
                        }
                        AsComputedProcessor.this.project.checkBuildCanceled();
                        AsComputedCompiler.getInstance().setDebugLog(AsComputedProcessor.this.debugLog);
                        if (generateAndCompileClasses) {
                            try {
                                boolean newElementsToTranslate = true;
                                while (newElementsToTranslate) {
                                    macroCachedModuleClasses.clear();
                                    newElementsToTranslate = AsComputedProcessor.this.genClassEncaps(macroCachedModuleClasses, classEncap.getRefered());
                                }
                            }
                            catch (Throwable e) {
                                DVTLogger.INSTANCE.logError(e);
                            }
                            String classContent = classEncap.getContent();
                            macroCachedModuleClasses.put(className, classContent);
                            AsComputedProcessor.this.totalGenerationType += System.currentTimeMillis() - time;
                            time = System.currentTimeMillis();
                            boolean[] nothingToCompile = new boolean[1];
                            boolean success = AsComputedCompiler.getInstance().doCompile(macroCachedModuleClasses, AsComputedProcessor.this, nothingToCompile);
                            if (!success) {
                                macroCachedModuleClasses.clear();
                                if (AsComputedProcessor.this.debugLog && !AsComputedProcessor.this.javaCompilerNotFound) {
                                    DVTLogger logger = DVTLogger.INSTANCE;
                                    logger.logDebug("AS_COMPUTED: *** ERROR: Java class '" + className + "' or a dependency has compilation errors.");
                                    AsComputedCompiler.getInstance().printErrors(AsComputedProcessor.this.project.getProject(), AsComputedProcessor.this.debugPath);
                                }
                                return defaultResult;
                            }
                            if (AsComputedProcessor.this.debugLog && !nothingToCompile[0]) {
                                DVTLogger.INSTANCE.logDebug("AS_COMPUTED: *** INFO: Compile (total: " + macroCachedModuleClasses.size() + ") '" + asComputedName + "' ...");
                                console = DVTBuildConsoleRegistry.getConsole((IProject)AsComputedProcessor.this.project.getProject());
                                if (console != null) {
                                    messageToPrint = "*** Info: Compiled classes (total: " + macroCachedModuleClasses.size() + ") for '" + asComputedName + "' [" + (System.currentTimeMillis() - time) + " ms] ...";
                                    console.print(messageToPrint);
                                }
                            }
                            AsComputedProcessor.this.totalCompilerTime += System.currentTimeMillis() - time;
                            time = System.currentTimeMillis();
                        }
                        AsComputedProcessor.this.params[0] = this.getClass().getClassLoader().loadClass("ro.amiq.etools.eparser.EModuleLexer");
                        AsComputedProcessor.this.argumentList[0] = module;
                        __etools_string result = null;
                        Class<?> javaClass = AsComputedCompiler.getInstance().getClassLoader().loadClass("ro.amiq.edt.base.debug.ascomputed" + '.' + className);
                        if (javaClass == null) {
                            DVTLogger.INSTANCE.logDebug("AS_COMPUTED: *** ERROR: Cannot load compiled class '" + className + "'");
                            if (AsComputedProcessor.this.debugLog && (console = DVTBuildConsoleRegistry.getConsole((IProject)AsComputedProcessor.this.project.getProject())) != null) {
                                messageToPrint = "*** Error: COMPILER_ERROR: Cannot load compiled class '" + className + "'";
                                console.print(messageToPrint);
                            }
                            return defaultResult;
                        }
                        if (AsComputedProcessor.this.debugLog) {
                            DVTLogger.INSTANCE.logDebug("AS_COMPUTED: Look for class '" + asComputedName + "' ...");
                            DVTLogger.INSTANCE.logDebug("AS_COMPUTED: Class '" + asComputedName + "' found. Invoke constructor...");
                        }
                        Object theObject = javaClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        Method theMethod = javaClass.getDeclaredMethod("evaluate", AsComputedProcessor.this.params);
                        try {
                            Exception invocationException;
                            if (module == null) {
                                return defaultResult;
                            }
                            module.readAsComputedInvocationException();
                            result = (__etools_string)theMethod.invoke(theObject, AsComputedProcessor.this.argumentList);
                            if (result != null) {
                                result.replaceUnique(module.getUnique());
                            }
                            if ((invocationException = module.readAsComputedInvocationException()) instanceof RejectMatchException) {
                                throw invocationException;
                            }
                            if (invocationException instanceof AsComputedException) {
                                throw invocationException;
                            }
                            if (invocationException != null) {
                                DVTBuildConsole console2;
                                if (AsComputedProcessor.this.debugLog && (console2 = DVTBuildConsoleRegistry.getConsole((IProject)AsComputedProcessor.this.project.getProject())) != null) {
                                    AsComputedProcessor.this.printExecutionError(invocationException, console2);
                                }
                                DVTLogger.INSTANCE.logError((Throwable)invocationException);
                            }
                        }
                        catch (InvocationTargetException e) {
                            DVTBuildConsole console3;
                            Throwable invocationException = e.getCause();
                            if (AsComputedProcessor.this.debugLog && (console3 = DVTBuildConsoleRegistry.getConsole((IProject)AsComputedProcessor.this.project.getProject())) != null) {
                                AsComputedProcessor.this.printExecutionError(invocationException, console3);
                            }
                            DVTLogger.INSTANCE.logError(invocationException);
                        }
                        AsComputedProcessor.this.totalExecutionType += System.currentTimeMillis() - time;
                        if (result == null) {
                            if (AsComputedProcessor.this.debugLog) {
                                DVTLogger logger = DVTLogger.INSTANCE;
                                logger.logDebug("AS_COMPUTED: *** CLASS RESULT IS NULL: " + className);
                            }
                            return defaultResult;
                        }
                        if (result.toString() == null) {
                            result.setString("");
                        }
                        if (result.toString().endsWith(";")) {
                            return result.toString();
                        }
                        return result.toString() + ';';
                    }
                    catch (BuildCancelException buildCancelException) {
                        return defaultResult;
                    }
                    catch (RejectMatchException e) {
                        throw e;
                    }
                    catch (AsComputedException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        if (AsComputedProcessor.this.debugLog) {
                            DVTLogger.INSTANCE.logError(e);
                        } else {
                            DVTLogger.INSTANCE.logInfo(e.getMessage());
                        }
                        return defaultResult;
                    }
                }
            }
        };
    }

    private void printExecutionError(Throwable invocationException, DVTBuildConsole console) {
        StackTraceElement[] stack = invocationException.getStackTrace();
        if (stack != null && stack[0] != null) {
            String messageToPrint = "*** Error: EXECUTION_ERROR: " + invocationException + "\n    at line " + stack[0].getLineNumber() + " in " + stack[0].getFileName();
            console.print(messageToPrint);
        } else {
            String messageToPrint = "*** Error: EXECUTION_ERROR: " + invocationException;
            console.print(messageToPrint);
        }
    }

    public IAsComputedExecutionPrintStream getExecPrintStream() {
        if (this.disable) {
            return null;
        }
        return new IAsComputedExecutionPrintStream(){

            public void println(int severity, String message) {
                if (AsComputedProcessor.this.console == null) {
                    AsComputedProcessor.this.console = new AsComputedConsoleViewer();
                }
                if (AsComputedProcessor.this.prevMacroInfo != null && !AsComputedProcessor.this.prevMacroInfo.equals(AsComputedProcessor.this.lastMacroInfo)) {
                    AsComputedProcessor.this.console.notifyMacroMessage("", AsComputedProcessor.this.project, 0);
                }
                AsComputedProcessor.this.prevMacroInfo = AsComputedProcessor.this.lastMacroInfo;
                message = DVTStringUtil.appendString((Object[])new Object[]{AsComputedProcessor.this.lastMacroInfo, "      ", message.trim()});
                AsComputedProcessor.this.console.notifyMacroMessage(message, AsComputedProcessor.this.project, severity);
            }
        };
    }

    public String testGetAsComputedConsoleContent() {
        if (this.console == null) {
            return null;
        }
        return this.console.testGetConsoleContent();
    }

    public void newClassLoader() {
        this.cachedModuleClasses.clear();
    }

    public Map<String, Map<String, String>> getCachedModuleClasses() {
        return this.cachedModuleClasses;
    }

    public void clean() {
        this.javaCompilerNotFound = false;
        this.primitiveTypesMap.clear();
        if (this.console != null) {
            this.console.dispose();
            this.console = null;
        }
        AsComputedCompiler.getInstance().clean(true);
    }

    public void setJavaCompilerError(boolean javaCompilerNotFound) {
        this.javaCompilerNotFound = javaCompilerNotFound;
    }

    public boolean getJavaCompilerError() {
        return this.javaCompilerNotFound;
    }

    public void disable(boolean disable) {
        this.disable = disable;
    }

    public static CharSequence getExpansionLiteralLine(List<String> list, int indentLevel) {
        StringBuilder line = new StringBuilder();
        if (list.isEmpty()) {
            line.append("__global.toEString(").append("new __etools_string(\"\\n\"))");
        } else if (list.size() == 1) {
            line.append("__global.append(").append("__global.toEString(").append(list.get(0)).append("), new __etools_string(\"\\n\"))");
        } else {
            StringBuilder listContent = new StringBuilder();
            int i = 0;
            while (i < list.size()) {
                listContent.append(list.get(i)).append(",\n");
                AsComputedProcessor.indent(listContent, indentLevel);
                ++i;
            }
            listContent.append("new __etools_string(\"\\n\")");
            line.append("__global.str_join(__global.toEString(new Object[] {").append((CharSequence)listContent).append("}), __global.toEString(\"\"))");
        }
        return line;
    }

    public void setDebugLog(boolean debugLog) {
        this.debugLog = debugLog;
    }

    public void setDebugPath(String debugPath) {
        this.debugPath = debugPath;
    }

    private String getPseudoMethodArgs(Set<RfNamedElement> referedVars, boolean declaration) {
        StringBuilder result = new StringBuilder();
        for (RfNamedElement variable : referedVars) {
            result.append(result.length() == 0 ? "" : ", ");
            if (declaration) {
                result.append(variable.javaTypeName()).append(" ");
            }
            if (declaration && variable instanceof RfEnum) {
                result.append(((RfEnum)variable).javaBaseName());
                continue;
            }
            if (!declaration && variable instanceof RfStructMember && ((RfStructMember)variable).getParentStruct() == this.project.getSpecman().getGlobalStruct()) {
                result.append("__global.").append(variable.javaName());
                continue;
            }
            result.append(variable.javaName());
        }
        return result.toString();
    }

    public String getPseudoMethod(RfActionBlockLayer scope, RfStruct parentStruct, String methodName, String typeName, String condition, Set<RfNamedElement> referedVars, String expression, LineInfo lineInfo, ParserPath parserPath) {
        ++this.pseudoMethodIndex;
        StringBuilder prevAndItVars = new StringBuilder();
        String indexVarName = INTERNAL_ERROR;
        String itVarName = INTERNAL_ERROR;
        String itVarTypeName = INTERNAL_ERROR;
        String prevVarName = INTERNAL_ERROR;
        RfVar itVar = scope.getLocalVariable("it", LineInfo.INFINITE, null);
        RfDummyField exprTypeContainer = new RfDummyField(this.project, parentStruct);
        String exprVarText = exprTypeContainer.javaTypeName() + " temp_expr = " + expression + ";";
        if (itVar != null) {
            RfVar prevVar;
            referedVars.remove(itVar);
            RfVar indexVar = scope.getLocalVariable("index", LineInfo.INFINITE, null);
            if (indexVar != null) {
                referedVars.remove(indexVar);
            }
            if ((prevVar = scope.getLocalVariable("prev", LineInfo.INFINITE, null)) != null) {
                referedVars.remove(prevVar);
            }
            int depth = ((RfNamedElement)itVar).javaVarDepth();
            indexVarName = this.javaName("index", depth);
            itVarName = ((RfNamedElement)itVar).javaName();
            itVarTypeName = ((RfNamedElement)itVar).javaTypeName();
            prevAndItVars.append("            ").append(((RfNamedElement)itVar).javaTypeName()).append(" ").append(itVarName).append(" = temp_expr.get(").append(indexVarName).append(");\n");
            prevVarName = this.javaName("prev", depth);
            prevAndItVars.append("            ").append(((RfNamedElement)itVar).javaTypeName()).append(" ").append(prevVarName).append(" = temp_expr.get(__etools_subtract(").append(indexVarName).append(", _Int.ONE));\n");
        }
        String methodDefArgs = this.getPseudoMethodArgs(referedVars, true);
        String methodCallArgs = this.getPseudoMethodArgs(referedVars, false);
        String staticAccess = "";
        if (methodName.equals("all")) {
            methodName = String.valueOf(methodName) + "_" + this.pseudoMethodIndex;
            this.pseudoMethodsJavaCode.append("    private ").append(staticAccess).append(typeName).append(" ").append(methodName).append("(").append(methodDefArgs).append(") throws Exception {\n");
            this.pseudoMethodsJavaCode.append("        ").append(typeName).append(" ").append("result").append(" = new ").append(typeName).append("();\n");
            this.pseudoMethodsJavaCode.append("        result.clazz = ").append(expression).append(".clazz;\n");
            this.pseudoMethodsJavaCode.append("        ").append(exprVarText).append("\n");
            this.pseudoMethodsJavaCode.append("        ").append("for (_Int ").append(indexVarName).append(" = _Int.ZERO; __etools_compareTo(").append(indexVarName).append(", temp_expr.size()) < 0; ").append(indexVarName).append(" = __etools_add(").append(indexVarName).append(", _Int.ONE)) {\n");
            this.pseudoMethodsJavaCode.append((CharSequence)prevAndItVars);
            this.pseudoMethodsJavaCode.append("            ").append("if (").append(condition).append(") {\n");
            this.pseudoMethodsJavaCode.append("                ").append("result.add(").append(itVarName).append(");\n");
            this.pseudoMethodsJavaCode.append("            }\n");
            this.pseudoMethodsJavaCode.append("        }\n");
            this.pseudoMethodsJavaCode.append("        return result;\n");
            this.pseudoMethodsJavaCode.append("    }\n\n");
        } else if (methodName.equals("has")) {
            methodName = String.valueOf(methodName) + "_" + this.pseudoMethodIndex;
            this.pseudoMethodsJavaCode.append("    private ").append(staticAccess).append("boolean ").append(methodName).append("(").append(methodDefArgs).append(") throws Exception {\n");
            this.pseudoMethodsJavaCode.append("        ").append(exprVarText).append("\n");
            this.pseudoMethodsJavaCode.append("        ").append("for (_Int ").append(indexVarName).append(" = _Int.ZERO; __etools_compareTo(").append(indexVarName).append(", temp_expr.size()) < 0; ").append(indexVarName).append(" = __etools_add(").append(indexVarName).append(", _Int.ONE)) {\n");
            this.pseudoMethodsJavaCode.append((CharSequence)prevAndItVars);
            this.pseudoMethodsJavaCode.append("            ").append("if (").append(condition).append(") {\n");
            this.pseudoMethodsJavaCode.append("                ").append("return true;\n");
            this.pseudoMethodsJavaCode.append("            }\n");
            this.pseudoMethodsJavaCode.append("        }\n");
            this.pseudoMethodsJavaCode.append("        return false;\n");
            this.pseudoMethodsJavaCode.append("    }\n\n");
        } else if (methodName.equals("or_all")) {
            methodName = String.valueOf(methodName) + "_" + this.pseudoMethodIndex;
            this.pseudoMethodsJavaCode.append("    private ").append(staticAccess).append("boolean ").append(methodName).append("(").append(methodDefArgs).append(") throws Exception {\n");
            this.pseudoMethodsJavaCode.append("        ").append(exprVarText).append("\n");
            this.pseudoMethodsJavaCode.append("        ").append("for (_Int ").append(indexVarName).append(" = _Int.ZERO; __etools_compareTo(").append(indexVarName).append(", temp_expr.size()) < 0; ").append(indexVarName).append(" = __etools_add(").append(indexVarName).append(", _Int.ONE)) {\n");
            this.pseudoMethodsJavaCode.append((CharSequence)prevAndItVars);
            this.pseudoMethodsJavaCode.append("            ").append("if (").append(condition).append(") {\n");
            this.pseudoMethodsJavaCode.append("                ").append("return true;\n");
            this.pseudoMethodsJavaCode.append("            }\n");
            this.pseudoMethodsJavaCode.append("        }\n");
            this.pseudoMethodsJavaCode.append("        return false;\n");
            this.pseudoMethodsJavaCode.append("    }\n\n");
        } else if (methodName.equals("and_all")) {
            methodName = String.valueOf(methodName) + "_" + this.pseudoMethodIndex;
            this.pseudoMethodsJavaCode.append("    private ").append(staticAccess).append("boolean ").append(methodName).append("(").append(methodDefArgs).append(") throws Exception {\n");
            this.pseudoMethodsJavaCode.append("        ").append(exprVarText).append("\n");
            this.pseudoMethodsJavaCode.append("        if (__etools_2equals(temp_expr.size(), _Int.ZERO))\n");
            this.pseudoMethodsJavaCode.append("            return false;\n");
            this.pseudoMethodsJavaCode.append("        ").append("for (_Int ").append(indexVarName).append(" = _Int.ZERO; __etools_compareTo(").append(indexVarName).append(", temp_expr.size()) < 0; ").append(indexVarName).append(" = __etools_add(").append(indexVarName).append(", _Int.ONE)) {\n");
            this.pseudoMethodsJavaCode.append((CharSequence)prevAndItVars);
            this.pseudoMethodsJavaCode.append("            ").append("if (!(").append(condition).append(")) {\n");
            this.pseudoMethodsJavaCode.append("                ").append("return false;\n");
            this.pseudoMethodsJavaCode.append("            }\n");
            this.pseudoMethodsJavaCode.append("        }\n");
            this.pseudoMethodsJavaCode.append("        return true;\n");
            this.pseudoMethodsJavaCode.append("    }\n\n");
        } else if (methodName.equals("first")) {
            methodName = String.valueOf(methodName) + "_" + this.pseudoMethodIndex;
            this.pseudoMethodsJavaCode.append("    private ").append(staticAccess).append(typeName).append(" ").append(methodName).append("(").append(methodDefArgs).append(") throws Exception {\n");
            this.pseudoMethodsJavaCode.append("        ").append(exprVarText).append("\n");
            this.pseudoMethodsJavaCode.append("        ").append("for (_Int ").append(indexVarName).append(" = _Int.ZERO; __etools_compareTo(").append(indexVarName).append(", temp_expr.size()) < 0; ").append(indexVarName).append(" = __etools_add(").append(indexVarName).append(", _Int.ONE)) {\n");
            this.pseudoMethodsJavaCode.append((CharSequence)prevAndItVars);
            this.pseudoMethodsJavaCode.append("            ").append("if (").append(condition).append(")\n");
            this.pseudoMethodsJavaCode.append("                ").append("return ").append(itVarName).append(";\n");
            this.pseudoMethodsJavaCode.append("        }\n");
            if (typeName.equals("__etools_string")) {
                this.pseudoMethodsJavaCode.append("        return new __etools_string();\n");
            } else {
                this.pseudoMethodsJavaCode.append("        return null;\n");
            }
            this.pseudoMethodsJavaCode.append("    }\n\n");
        } else if (methodName.equals("first_index")) {
            methodName = String.valueOf(methodName) + "_" + this.pseudoMethodIndex;
            this.pseudoMethodsJavaCode.append("    private ").append(staticAccess).append("_Int ").append(methodName).append("(").append(methodDefArgs).append(") throws Exception {\n");
            this.pseudoMethodsJavaCode.append("        ").append(exprVarText).append("\n");
            this.pseudoMethodsJavaCode.append("        ").append("for (_Int ").append(indexVarName).append(" = _Int.ZERO; __etools_compareTo(").append(indexVarName).append(", temp_expr.size()) < 0; ").append(indexVarName).append(" = __etools_add(").append(indexVarName).append(", _Int.ONE)) {\n");
            this.pseudoMethodsJavaCode.append((CharSequence)prevAndItVars);
            this.pseudoMethodsJavaCode.append("            ").append("if (").append(condition).append(")\n");
            this.pseudoMethodsJavaCode.append("                ").append("return ").append(indexVarName).append(";\n");
            this.pseudoMethodsJavaCode.append("        }\n");
            this.pseudoMethodsJavaCode.append("        return _Int.MINUS_ONE;\n");
            this.pseudoMethodsJavaCode.append("    }\n\n");
        } else if (methodName.equals("last")) {
            methodName = String.valueOf(methodName) + "_" + this.pseudoMethodIndex;
            this.pseudoMethodsJavaCode.append("    private ").append(staticAccess).append(typeName).append(" ").append(methodName).append("(").append(methodDefArgs).append(") throws Exception {\n");
            if (typeName.equals("__etools_string")) {
                this.pseudoMethodsJavaCode.append("        ").append(typeName).append(" result = new __etools_string();\n");
            } else {
                this.pseudoMethodsJavaCode.append("        ").append(typeName).append(" result = null;\n");
            }
            this.pseudoMethodsJavaCode.append("        ").append(exprVarText).append("\n");
            this.pseudoMethodsJavaCode.append("        ").append("for (_Int ").append(indexVarName).append(" = _Int.ZERO; __etools_compareTo(").append(indexVarName).append(", temp_expr.size()) < 0; ").append(indexVarName).append(" = __etools_add(").append(indexVarName).append(", _Int.ONE)) {\n");
            this.pseudoMethodsJavaCode.append((CharSequence)prevAndItVars);
            this.pseudoMethodsJavaCode.append("            ").append("if (").append(condition).append(")\n");
            this.pseudoMethodsJavaCode.append("                ").append("result = ").append(itVarName).append(";\n");
            this.pseudoMethodsJavaCode.append("        }\n");
            this.pseudoMethodsJavaCode.append("        return result;\n");
            this.pseudoMethodsJavaCode.append("    }\n\n");
        } else if (methodName.equals("last_index")) {
            methodName = String.valueOf(methodName) + "_" + this.pseudoMethodIndex;
            this.pseudoMethodsJavaCode.append("    private ").append(staticAccess).append("_Int ").append(methodName).append("(").append(methodDefArgs).append(") throws Exception {\n");
            this.pseudoMethodsJavaCode.append("        _Int result = _Int.MINUS_ONE;\n");
            this.pseudoMethodsJavaCode.append("        ").append(exprVarText).append("\n");
            this.pseudoMethodsJavaCode.append("        ").append("for (_Int ").append(indexVarName).append(" = _Int.ZERO; __etools_compareTo(").append(indexVarName).append(", temp_expr.size()) < 0; ").append(indexVarName).append(" = __etools_add(").append(indexVarName).append(", _Int.ONE)) {\n");
            this.pseudoMethodsJavaCode.append((CharSequence)prevAndItVars);
            this.pseudoMethodsJavaCode.append("            ").append("if (").append(condition).append(")\n");
            this.pseudoMethodsJavaCode.append("                ").append("result = ").append(indexVarName).append(";\n");
            this.pseudoMethodsJavaCode.append("        }\n");
            this.pseudoMethodsJavaCode.append("        return result;\n");
            this.pseudoMethodsJavaCode.append("    }\n\n");
        } else if (methodName.equals("apply")) {
            methodName = String.valueOf(methodName) + "_" + this.pseudoMethodIndex;
            this.pseudoMethodsJavaCode.append("    private ").append(staticAccess).append(typeName).append(" ").append(methodName).append("(").append(methodDefArgs).append(") throws Exception {\n");
            this.pseudoMethodsJavaCode.append("        ").append(typeName).append(" ").append("result").append(" = new ").append(typeName).append("();\n");
            this.pseudoMethodsJavaCode.append("        ").append(exprVarText).append("\n");
            this.pseudoMethodsJavaCode.append("        ").append("for (_Int ").append(indexVarName).append(" = _Int.ZERO; __etools_compareTo(").append(indexVarName).append(", temp_expr.size()) < 0; ").append(indexVarName).append(" = __etools_add(").append(indexVarName).append(", _Int.ONE)) {\n");
            this.pseudoMethodsJavaCode.append((CharSequence)prevAndItVars);
            this.pseudoMethodsJavaCode.append("            ").append("result.add(").append(condition).append(");\n");
            this.pseudoMethodsJavaCode.append("        }\n");
            this.pseudoMethodsJavaCode.append("        return result;\n");
            this.pseudoMethodsJavaCode.append("    }\n\n");
        } else {
            if (methodName.equals("sort")) {
                --this.pseudoMethodIndex;
                return DVTStringUtil.appendString((Object[])new Object[]{expression, ".sort(new Comparator<", itVarTypeName, ">() {\n", "    public int compare(", itVarTypeName, " o1, ", itVarTypeName, " o2) {\n", "        return __etools_2compare(", this.replace(condition, itVarName, "o1"), ", ", this.replace(condition, itVarName, "o2"), ");\n", "    }\n", "})"});
            }
            if (methodName.equals("unique") || methodName.equals("uniq")) {
                methodName = String.valueOf(methodName) + "_" + this.pseudoMethodIndex;
                this.pseudoMethodsJavaCode.append("    private ").append(staticAccess).append(typeName).append(" ").append(methodName).append("(").append(methodDefArgs).append(") throws Exception {\n");
                this.pseudoMethodsJavaCode.append("        ").append(typeName).append(" ").append("result").append(" = new ").append(typeName).append("();\n");
                this.pseudoMethodsJavaCode.append("        ").append(exprVarText).append("\n");
                this.pseudoMethodsJavaCode.append("        ").append("for (_Int ").append(indexVarName).append(" = _Int.ZERO; __etools_compareTo(").append(indexVarName).append(", temp_expr.size()) < 0; ").append(indexVarName).append(" = __etools_add(").append(indexVarName).append(", _Int.ONE)) {\n");
                this.pseudoMethodsJavaCode.append((CharSequence)prevAndItVars);
                this.pseudoMethodsJavaCode.append("            ").append("if (!__etools_2equals(").append(condition).append(", ").append(this.replace(condition, itVarName, prevVarName)).append(")) {\n");
                this.pseudoMethodsJavaCode.append("                ").append("result.add(").append(itVarName).append(");\n");
                this.pseudoMethodsJavaCode.append("            }\n");
                this.pseudoMethodsJavaCode.append("        }\n");
                this.pseudoMethodsJavaCode.append("        return result;\n");
                this.pseudoMethodsJavaCode.append("    }\n\n");
            } else if (methodName.equals("all_unique")) {
                methodName = String.valueOf(methodName) + "_" + this.pseudoMethodIndex;
                this.pseudoMethodsJavaCode.append("    private ").append(staticAccess).append(typeName).append(" ").append(methodName).append("(").append(methodDefArgs).append(") throws Exception {\n");
                this.pseudoMethodsJavaCode.append("        Set<Object> uniqueEval = new HashSet<Object>();\n");
                this.pseudoMethodsJavaCode.append("        ").append(typeName).append(" ").append("result").append(" = new ").append(typeName).append("();\n");
                this.pseudoMethodsJavaCode.append("        ").append(exprVarText).append("\n");
                this.pseudoMethodsJavaCode.append("        ").append("for (_Int ").append(indexVarName).append(" = _Int.ZERO; __etools_compareTo(").append(indexVarName).append(", temp_expr.size()) < 0; ").append(indexVarName).append(" = __etools_add(").append(indexVarName).append(", _Int.ONE)) {\n");
                this.pseudoMethodsJavaCode.append((CharSequence)prevAndItVars);
                this.pseudoMethodsJavaCode.append("            ").append("Object eval = ").append(condition).append(";\n");
                this.pseudoMethodsJavaCode.append("            ").append("if (!uniqueEval.contains(eval)) {\n");
                this.pseudoMethodsJavaCode.append("                result.add(eval);\n");
                this.pseudoMethodsJavaCode.append("            }\n");
                this.pseudoMethodsJavaCode.append("            uniqueEval.add(eval);\n");
                this.pseudoMethodsJavaCode.append("        }\n");
                this.pseudoMethodsJavaCode.append("        return result;\n");
                this.pseudoMethodsJavaCode.append("    }\n\n");
            } else if (methodName.equals("all_different")) {
                methodName = String.valueOf(methodName) + "_" + this.pseudoMethodIndex;
                this.pseudoMethodsJavaCode.append("    private ").append(staticAccess).append(typeName).append(" ").append(methodName).append("(").append(methodDefArgs).append(") throws Exception {\n");
                this.pseudoMethodsJavaCode.append("        Set<Object> uniqueEval = new HashSet<Object>();\n");
                this.pseudoMethodsJavaCode.append("        ").append(exprVarText).append("\n");
                this.pseudoMethodsJavaCode.append("        ").append("for (_Int ").append(indexVarName).append(" = _Int.ZERO; __etools_compareTo(").append(indexVarName).append(", temp_expr.size()) < 0; ").append(indexVarName).append(" = __etools_add(").append(indexVarName).append(", _Int.ONE)) {\n");
                this.pseudoMethodsJavaCode.append((CharSequence)prevAndItVars);
                this.pseudoMethodsJavaCode.append("            ").append("Object eval = ").append(condition).append(";\n");
                this.pseudoMethodsJavaCode.append("            ").append("if (uniqueEval.contains(eval)) {\n");
                this.pseudoMethodsJavaCode.append("                ").append("return false;\n");
                this.pseudoMethodsJavaCode.append("            }\n");
                this.pseudoMethodsJavaCode.append("            uniqueEval.add(eval);\n");
                this.pseudoMethodsJavaCode.append("        }\n");
                this.pseudoMethodsJavaCode.append("        return true;\n");
                this.pseudoMethodsJavaCode.append("    }\n\n");
            } else {
                this.project.addSemanticError1(2, "AS_COMPUTED_LIMITATION: List pseudo-method ''{0}'' not implemented in this DVT version", lineInfo.realOffset, lineInfo.realOffset + methodName.length(), null, lineInfo.line, parserPath, methodName);
            }
        }
        return DVTStringUtil.appendString((Object[])new Object[]{methodName, "(", methodCallArgs, ")"});
    }

    private final String replace(String input, String sequence, String replacement) {
        return DVTStringUtil.replace((String)input, (String)sequence, (String)replacement, (boolean)true);
    }

    public String getPseudoMethod(RfActionBlockLayer scope, String methodName, String typeName, String itemName, String actions, Set<RfNamedElement> referedVars) {
        ++this.pseudoMethodIndex;
        String itVarName = INTERNAL_ERROR;
        String itVarTypeName = INTERNAL_ERROR;
        RfVar itVar = scope.getLocalVariable(itemName, LineInfo.INFINITE, null);
        if (itVar != null) {
            referedVars.remove(itVar);
            itVarName = ((RfNamedElement)itVar).javaName();
            itVarTypeName = ((RfNamedElement)itVar).javaTypeName();
        }
        String methodDefArgs = this.getPseudoMethodArgs(referedVars, true);
        String methodCallArgs = this.getPseudoMethodArgs(referedVars, false);
        if (methodName.equals("new")) {
            methodName = String.valueOf(methodName) + "_" + this.pseudoMethodIndex;
            this.pseudoMethodsJavaCode.append("    private ").append(typeName).append(" ").append(methodName).append("(").append(methodDefArgs).append(") throws Exception {\n");
            this.pseudoMethodsJavaCode.append("        ").append(itVarTypeName).append(" ").append(itVarName).append(" = new ").append(typeName).append("();\n");
            this.pseudoMethodsJavaCode.append("        ").append(actions);
            this.pseudoMethodsJavaCode.append("        return ").append(itVarName).append(";\n");
            this.pseudoMethodsJavaCode.append("    }\n\n");
        }
        return DVTStringUtil.appendString((Object[])new Object[]{methodName, "(", methodCallArgs, ")"});
    }

    public String getTempExprName() {
        ++this.temporaryExprIndex;
        return "tempExpr_" + this.temporaryExprIndex;
    }

    public String getPseudoMethod(RfPseudoListField pseudoListField, String expression) {
        String pseudoFieldName;
        ++this.pseudoMethodIndex;
        String methodName = pseudoFieldName = pseudoListField.getName();
        String methodTypeName = pseudoListField.javaTypeName();
        RfListType listType = (RfListType)pseudoListField.getParentStruct();
        RfType assocType = listType.getAssociatedType();
        String argBaseTypeName = assocType == null ? INTERNAL_ERROR : assocType.javaName();
        methodName = String.valueOf(methodName) + "_" + this.pseudoMethodIndex;
        this.pseudoMethodsJavaCode.append("    private ").append(methodTypeName).append(" ").append(methodName).append("(EList<").append(argBaseTypeName).append("> listArg) throws Exception {\n");
        this.pseudoMethodsJavaCode.append("        EList<__etools_string> result = new EList<>();\n");
        this.pseudoMethodsJavaCode.append("        for (").append(argBaseTypeName).append(" arg : listArg)\n");
        this.pseudoMethodsJavaCode.append("            result.add(arg.__etools_").append(pseudoFieldName).append(");\n");
        this.pseudoMethodsJavaCode.append("        return result;\n");
        this.pseudoMethodsJavaCode.append("    }\n\n");
        return DVTStringUtil.appendString((Object[])new Object[]{methodName, "(", expression, ")"});
    }

    private String javaName(String name, int depth) {
        if (depth <= 0) {
            return JAVA_NAME_PREFIX + name;
        }
        return JAVA_NAME_PREFIX + name + "_" + depth;
    }

    public boolean shouldTranslate(RfProject project, RfMethod method) {
        if (method == null) {
            return false;
        }
        IEProject eProject = project.getModelManager().getEModel().getEProject(project.getProject());
        if (eProject == null) {
            return false;
        }
        RfStruct parentStruct = method.getParentStruct();
        if (parentStruct == null) {
            return false;
        }
        Set<String> methods2translate = eProject.getAsComputedMethodsToTranslate(parentStruct.getPackageName(), parentStruct.getName());
        return methods2translate != null && methods2translate.contains(method.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String primitive, String javaName) {
        Map<String, String> map = this.primitiveTypesMap;
        synchronized (map) {
            this.primitiveTypesMap.put(javaName, primitive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String registred(String javaName) {
        String result = null;
        Map<String, String> map = this.primitiveTypesMap;
        synchronized (map) {
            result = this.primitiveTypesMap.get(javaName);
        }
        return result == null ? javaName : result;
    }

    public boolean debugLog() {
        return this.debugLog;
    }

    public String getDebugPath() {
        return this.debugPath;
    }

    public static class NameAndDotClass {
        String className;
        String typeName;
        String tester;

        public NameAndDotClass(String typeName, String className, String tester) {
            this.typeName = typeName;
            this.className = className;
            this.tester = tester;
        }
    }

    public static class NameAndTypeName {
        String name;
        String typeName;

        public NameAndTypeName(String name, String typeName) {
            this.typeName = typeName;
            this.name = name;
        }
    }
}

