/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.ascomputed.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.ascomputed.AsComputedCompiler;

public enum AsComputedEvolvedClassHandler {
    INSTANCE;

    private RfProject fRfProject;
    private Object fLastGlobalObject;

    public RfProject getRfProject() {
        return this.fRfProject;
    }

    public void init(RfProject rfProject) {
        this.fRfProject = rfProject;
        this.fLastGlobalObject = null;
    }

    public Object getEvolvedRestoredObject(Object globalObject) {
        try {
            if (this.fLastGlobalObject == null) {
                this.fLastGlobalObject = globalObject;
                return this.fLastGlobalObject;
            }
            byte[] serialData = this.serialize(this.fLastGlobalObject);
            if (serialData == null) {
                this.fLastGlobalObject = globalObject;
                return this.fLastGlobalObject;
            }
            Object evolvedGlobalObject = this.deserialize(serialData, AsComputedCompiler.getInstance().getClassLoader());
            if (evolvedGlobalObject == null) {
                this.fLastGlobalObject = globalObject;
                return this.fLastGlobalObject;
            }
            this.fLastGlobalObject = evolvedGlobalObject;
            return this.fLastGlobalObject;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            this.fLastGlobalObject = globalObject;
            return this.fLastGlobalObject;
        }
    }

    private byte[] serialize(Object object) {
        ByteArrayOutputStream barray = null;
        ObjectOutputStream out = null;
        try {
            barray = new ByteArrayOutputStream();
            out = new ObjectOutputStream(barray);
            out.writeObject(object);
            out.close();
            barray.close();
            byte[] byArray = barray.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (barray != null) {
                    barray.close();
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return null;
    }

    private Object deserialize(byte[] serialData, final ClassLoader classLoader) {
        Object result = null;
        ByteArrayInputStream barray = null;
        ObjectInputStream in = null;
        try {
            try {
                barray = new ByteArrayInputStream(serialData);
                in = new ObjectInputStream(barray){

                    @Override
                    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                        Class<?> clazz = classLoader.loadClass(desc.getName());
                        if (clazz != null) {
                            return clazz;
                        }
                        return super.resolveClass(desc);
                    }
                };
                result = in.readObject();
                in.close();
                barray.close();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (barray != null) {
                        barray.close();
                    }
                }
                catch (Exception e2) {
                    DVTLogger.INSTANCE.logError((Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (barray != null) {
                    barray.close();
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return result;
    }
}

