/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.ascomputed.base;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.DuplicateFormatFlagsException;
import java.util.FormatFlagsConversionMismatchException;
import java.util.IllegalFormatCodePointException;
import java.util.IllegalFormatConversionException;
import java.util.IllegalFormatFlagsException;
import java.util.IllegalFormatPrecisionException;
import java.util.IllegalFormatWidthException;
import java.util.Locale;
import java.util.MissingFormatArgumentException;
import java.util.MissingFormatWidthException;
import java.util.TimeZone;
import java.util.UnknownFormatConversionException;
import java.util.UnknownFormatFlagsException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.edt.base.model.reflection.ascomputed.base.AsComputedEnum;
import ro.amiq.edt.base.model.reflection.ascomputed.base._Int;
import ro.amiq.edt.base.model.reflection.ascomputed.base.__etools_string;

public class EFormatter {
    private StringBuilder a = new StringBuilder();
    private IOException lastException;
    private final char zero = (char)48;
    private static final String formatSpecifier = "%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])";
    private static final Pattern fsPattern = Pattern.compile("%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");

    public Appendable out() {
        return this.a;
    }

    public String toString() {
        return this.a.toString();
    }

    public IOException ioException() {
        return this.lastException;
    }

    public EFormatter format(String format, Object ... args) {
        int last = -1;
        int lasto = -1;
        FormatString[] fsa = this.parse(format);
        int i = 0;
        while (i < fsa.length) {
            FormatString fs = fsa[i];
            int index = fs.index();
            try {
                switch (index) {
                    case -2: {
                        fs.print(null);
                        break;
                    }
                    case -1: {
                        if (last < 0 || args != null && last > args.length - 1) {
                            throw new MissingFormatArgumentException(fs.toString());
                        }
                        fs.print(args == null ? null : args[last]);
                        break;
                    }
                    case 0: {
                        last = ++lasto;
                        if (args != null && lasto > args.length - 1) {
                            throw new MissingFormatArgumentException(fs.toString());
                        }
                        fs.print(args == null ? null : args[lasto]);
                        break;
                    }
                    default: {
                        last = index - 1;
                        if (args != null && last > args.length - 1) {
                            throw new MissingFormatArgumentException(fs.toString());
                        }
                        fs.print(args == null ? null : args[last]);
                        break;
                    }
                }
            }
            catch (IOException x) {
                this.lastException = x;
            }
            ++i;
        }
        return this;
    }

    private FormatString[] parse(String s) {
        ArrayList<FormatString> al = new ArrayList<FormatString>();
        Matcher m = fsPattern.matcher(s);
        int i = 0;
        int len = s.length();
        while (i < len) {
            if (m.find(i)) {
                if (m.start() != i) {
                    EFormatter.checkText(s, i, m.start());
                    al.add(new FixedString(s.substring(i, m.start())));
                }
                al.add(new FormatSpecifier(m));
                i = m.end();
                continue;
            }
            EFormatter.checkText(s, i, len);
            al.add(new FixedString(s.substring(i)));
            break;
        }
        return al.toArray(new FormatString[al.size()]);
    }

    private static void checkText(String s, int start, int end) {
        int i = start;
        while (i < end) {
            if (s.charAt(i) == '%') {
                char c = i == end - 1 ? (char)'%' : (char)s.charAt(i + 1);
                throw new UnknownFormatConversionException(String.valueOf(c));
            }
            ++i;
        }
    }

    public static enum BigDecimalLayoutForm {
        SCIENTIFIC,
        DECIMAL_FLOAT;

    }

    private static class Conversion {
        static final char DECIMAL_INTEGER = 'd';
        static final char OCTAL_INTEGER = 'o';
        static final char HEXADECIMAL_INTEGER = 'x';
        static final char HEXADECIMAL_INTEGER_UPPER = 'X';
        static final char SCIENTIFIC = 'e';
        static final char SCIENTIFIC_UPPER = 'E';
        static final char CHARACTER = 'c';
        static final char CHARACTER_UPPER = 'C';
        static final char BOOLEAN = 'b';
        static final char BOOLEAN_UPPER = 'B';
        static final char STRING = 's';
        static final char STRING_UPPER = 'S';
        static final char HASHCODE = 'h';
        static final char HASHCODE_UPPER = 'H';
        static final char LINE_SEPARATOR = 'n';
        static final char PERCENT_SIGN = '%';

        private Conversion() {
        }

        static boolean isValid(char c) {
            return Conversion.isGeneral(c) || Conversion.isInteger(c) || Conversion.isFloat(c) || Conversion.isText(c) || c == 't' || Conversion.isCharacter(c);
        }

        static boolean isGeneral(char c) {
            switch (c) {
                case 'B': 
                case 'H': 
                case 'S': 
                case 'b': 
                case 'h': 
                case 's': {
                    return true;
                }
            }
            return false;
        }

        static boolean isCharacter(char c) {
            switch (c) {
                case 'C': 
                case 'c': {
                    return true;
                }
            }
            return false;
        }

        static boolean isInteger(char c) {
            switch (c) {
                case 'X': 
                case 'd': 
                case 'o': 
                case 'x': {
                    return true;
                }
            }
            return false;
        }

        static boolean isFloat(char c) {
            switch (c) {
                case 'E': 
                case 'e': {
                    return true;
                }
            }
            return false;
        }

        static boolean isText(char c) {
            switch (c) {
                case '%': 
                case 'n': {
                    return true;
                }
            }
            return false;
        }
    }

    private static class DateTime {
        static final char HOUR_OF_DAY_0 = 'H';
        static final char HOUR_0 = 'I';
        static final char HOUR_OF_DAY = 'k';
        static final char HOUR = 'l';
        static final char MINUTE = 'M';
        static final char NANOSECOND = 'N';
        static final char MILLISECOND = 'L';
        static final char MILLISECOND_SINCE_EPOCH = 'Q';
        static final char AM_PM = 'p';
        static final char SECONDS_SINCE_EPOCH = 's';
        static final char SECOND = 'S';
        static final char TIME = 'T';
        static final char ZONE_NUMERIC = 'z';
        static final char ZONE = 'Z';
        static final char NAME_OF_DAY_ABBREV = 'a';
        static final char NAME_OF_DAY = 'A';
        static final char NAME_OF_MONTH_ABBREV = 'b';
        static final char NAME_OF_MONTH = 'B';
        static final char CENTURY = 'C';
        static final char DAY_OF_MONTH_0 = 'd';
        static final char DAY_OF_MONTH = 'e';
        static final char NAME_OF_MONTH_ABBREV_X = 'h';
        static final char DAY_OF_YEAR = 'j';
        static final char MONTH = 'm';
        static final char YEAR_2 = 'y';
        static final char YEAR_4 = 'Y';
        static final char TIME_12_HOUR = 'r';
        static final char TIME_24_HOUR = 'R';
        static final char DATE_TIME = 'c';
        static final char DATE = 'D';
        static final char ISO_STANDARD_DATE = 'F';

        private DateTime() {
        }

        static boolean isValid(char c) {
            switch (c) {
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'H': 
                case 'I': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'Y': 
                case 'Z': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'h': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'p': 
                case 'r': 
                case 's': 
                case 'y': 
                case 'z': {
                    return true;
                }
            }
            return false;
        }
    }

    private class FixedString
    implements FormatString {
        private String s;

        FixedString(String s) {
            this.s = s;
        }

        @Override
        public int index() {
            return -2;
        }

        @Override
        public void print(Object arg) throws IOException {
            EFormatter.this.a.append(this.s);
        }

        @Override
        public String toString() {
            return this.s;
        }
    }

    private static class Flags {
        private int flags;
        static final Flags NONE = new Flags(0);
        static final Flags LEFT_JUSTIFY = new Flags(1);
        static final Flags UPPERCASE = new Flags(2);
        static final Flags ALTERNATE = new Flags(4);
        static final Flags PLUS = new Flags(8);
        static final Flags LEADING_SPACE = new Flags(16);
        static final Flags ZERO_PAD = new Flags(32);
        static final Flags GROUP = new Flags(64);
        static final Flags PARENTHESES = new Flags(128);
        static final Flags PREVIOUS = new Flags(256);

        private Flags(int f) {
            this.flags = f;
        }

        public int valueOf() {
            return this.flags;
        }

        public boolean contains(Flags f) {
            return (this.flags & f.valueOf()) == f.valueOf();
        }

        public Flags dup() {
            return new Flags(this.flags);
        }

        private Flags add(Flags f) {
            this.flags |= f.valueOf();
            return this;
        }

        public Flags remove(Flags f) {
            this.flags &= ~f.valueOf();
            return this;
        }

        public static Flags parse(String s) {
            char[] ca = s.toCharArray();
            Flags f = new Flags(0);
            int i = 0;
            while (i < ca.length) {
                Flags v = Flags.parse(ca[i]);
                if (f.contains(v)) {
                    throw new DuplicateFormatFlagsException(v.toString());
                }
                f.add(v);
                ++i;
            }
            return f;
        }

        private static Flags parse(char c) {
            switch (c) {
                case '-': {
                    return LEFT_JUSTIFY;
                }
                case '#': {
                    return ALTERNATE;
                }
                case '+': {
                    return PLUS;
                }
                case ' ': {
                    return LEADING_SPACE;
                }
                case '0': {
                    return ZERO_PAD;
                }
                case ',': {
                    return GROUP;
                }
                case '(': {
                    return PARENTHESES;
                }
                case '<': {
                    return PREVIOUS;
                }
            }
            throw new UnknownFormatFlagsException(String.valueOf(c));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.contains(LEFT_JUSTIFY)) {
                sb.append('-');
            }
            if (this.contains(UPPERCASE)) {
                sb.append('^');
            }
            if (this.contains(ALTERNATE)) {
                sb.append('#');
            }
            if (this.contains(PLUS)) {
                sb.append('+');
            }
            if (this.contains(LEADING_SPACE)) {
                sb.append(' ');
            }
            if (this.contains(ZERO_PAD)) {
                sb.append('0');
            }
            if (this.contains(GROUP)) {
                sb.append(',');
            }
            if (this.contains(PARENTHESES)) {
                sb.append('(');
            }
            if (this.contains(PREVIOUS)) {
                sb.append('<');
            }
            return sb.toString();
        }
    }

    private class FormatSpecifier
    implements FormatString {
        private int index = -1;
        private Flags f = Flags.NONE;
        private int width;
        private int precision;
        private boolean dt = false;
        private char c;

        private int index(String s) {
            if (s != null) {
                try {
                    this.index = Integer.parseInt(s.substring(0, s.length() - 1));
                }
                catch (NumberFormatException numberFormatException) {
                    assert (false);
                }
            } else {
                this.index = 0;
            }
            return this.index;
        }

        @Override
        public int index() {
            return this.index;
        }

        private Flags flags(String s) {
            this.f = Flags.parse(s);
            if (this.f.contains(Flags.PREVIOUS)) {
                this.index = -1;
            }
            return this.f;
        }

        private int width(String s) {
            block4: {
                this.width = -1;
                if (s != null) {
                    try {
                        this.width = Integer.parseInt(s);
                        if (this.width < 0) {
                            throw new IllegalFormatWidthException(this.width);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if ($assertionsDisabled) break block4;
                        throw new AssertionError();
                    }
                }
            }
            return this.width;
        }

        private int precision(String s) {
            block4: {
                this.precision = -1;
                if (s != null) {
                    try {
                        this.precision = Integer.parseInt(s.substring(1));
                        if (this.precision < 0) {
                            throw new IllegalFormatPrecisionException(this.precision);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if ($assertionsDisabled) break block4;
                        throw new AssertionError();
                    }
                }
            }
            return this.precision;
        }

        private char conversion(String s) {
            this.c = s.charAt(0);
            if (!this.dt) {
                if (!Conversion.isValid(this.c)) {
                    throw new UnknownFormatConversionException(String.valueOf(this.c));
                }
                if (Character.isUpperCase(this.c)) {
                    this.f.add(Flags.UPPERCASE);
                }
                this.c = Character.toLowerCase(this.c);
                if (Conversion.isText(this.c)) {
                    this.index = -2;
                }
            }
            return this.c;
        }

        FormatSpecifier(Matcher m) {
            int idx = 1;
            this.index(m.group(idx++));
            this.flags(m.group(idx++));
            this.width(m.group(idx++));
            this.precision(m.group(idx++));
            String tT = m.group(idx++);
            if (tT != null) {
                this.dt = true;
                if (tT.equals("T")) {
                    this.f.add(Flags.UPPERCASE);
                }
            }
            this.conversion(m.group(idx));
            if (this.dt) {
                this.checkDateTime();
            } else if (Conversion.isGeneral(this.c)) {
                this.checkGeneral();
            } else if (Conversion.isCharacter(this.c)) {
                this.checkCharacter();
            } else if (Conversion.isInteger(this.c)) {
                this.checkInteger();
            } else if (Conversion.isFloat(this.c)) {
                this.checkFloat();
            } else if (Conversion.isText(this.c)) {
                this.checkText();
            } else {
                throw new UnknownFormatConversionException(String.valueOf(this.c));
            }
        }

        @Override
        public void print(Object arg) throws IOException {
            if (this.dt) {
                this.printDateTime(arg);
                return;
            }
            switch (this.c) {
                case 'd': 
                case 'o': 
                case 'x': {
                    this.printInteger(arg);
                    break;
                }
                case 'e': {
                    this.printFloat(arg);
                    break;
                }
                case 'C': 
                case 'c': {
                    this.printCharacter(arg);
                    break;
                }
                case 'b': {
                    this.printBoolean(arg);
                    break;
                }
                case 's': {
                    this.printString(arg);
                    break;
                }
                case 'h': {
                    this.printHashCode(arg);
                    break;
                }
                case 'n': {
                    EFormatter.this.a.append(System.getProperty("line.separator"));
                    break;
                }
                case '%': {
                    EFormatter.this.a.append('%');
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        private void printInteger(Object arg) throws IOException {
            if (arg == null) {
                this.print("");
            } else if (arg instanceof AsComputedEnum) {
                this.print(((AsComputedEnum)arg).fValue);
            } else if (arg instanceof Byte) {
                this.print(arg);
            } else if (arg instanceof Short) {
                this.print(arg);
            } else if (arg instanceof Integer) {
                this.print(arg);
            } else if (arg instanceof Long) {
                this.print(arg);
            } else if (arg instanceof _Int) {
                this.print(((_Int)arg).longValue());
            } else if (arg instanceof __etools_string) {
                this.print(Integer.parseInt(arg.toString()));
            } else {
                this.failConversion(this.c, arg);
            }
        }

        private void printFloat(Object arg) throws IOException {
            if (arg == null) {
                this.print("");
            } else if (arg instanceof AsComputedEnum) {
                this.print(((AsComputedEnum)arg).fValue);
            } else if (arg instanceof Float) {
                this.print(arg);
            } else if (arg instanceof Double) {
                this.print(arg);
            } else if (arg instanceof _Int) {
                this.print(((_Int)arg).doubleValue());
            } else if (arg instanceof BigDecimal) {
                this.print((BigDecimal)arg);
            } else if (arg instanceof __etools_string) {
                this.print(Float.valueOf(Float.parseFloat(arg.toString())));
            } else {
                this.failConversion(this.c, arg);
            }
        }

        private void printDateTime(Object arg) throws IOException {
            if (arg == null) {
                this.print("");
                return;
            }
            Calendar cal = null;
            if (arg instanceof Long) {
                cal = Calendar.getInstance(Locale.US);
                cal.setTimeInMillis((Long)arg);
            } else if (arg instanceof Date) {
                cal = Calendar.getInstance(Locale.US);
                cal.setTime((Date)arg);
            } else if (arg instanceof Calendar) {
                cal = (Calendar)((Calendar)arg).clone();
                cal.setLenient(true);
            } else {
                this.failConversion(this.c, arg);
            }
            this.print(cal, this.c);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void printCharacter(Object arg) {
            if (arg == null) {
                this.print("");
                return;
            }
            String s = null;
            if (arg instanceof Character) {
                s = ((Character)arg).toString();
            } else if (arg instanceof Byte) {
                byte i = (Byte)arg;
                if (!Character.isValidCodePoint(i)) throw new IllegalFormatCodePointException(i);
                s = new String(Character.toChars(i));
            } else if (arg instanceof Short) {
                short i = (Short)arg;
                if (!Character.isValidCodePoint(i)) throw new IllegalFormatCodePointException(i);
                s = new String(Character.toChars(i));
            } else if (arg instanceof Integer) {
                int i = (Integer)arg;
                if (!Character.isValidCodePoint(i)) throw new IllegalFormatCodePointException(i);
                s = new String(Character.toChars(i));
            } else if (arg instanceof __etools_string && arg.toString().length() > 0) {
                s = arg.toString().substring(0, 1);
            } else {
                this.failConversion(this.c, arg);
            }
            this.print(s);
        }

        private void printString(Object arg) {
            if (this.f.contains(Flags.ALTERNATE)) {
                this.failMismatch(Flags.ALTERNATE, 's');
            }
            if (arg == null) {
                this.print("");
            } else if (arg instanceof Boolean) {
                this.print(arg.toString().toUpperCase());
            } else if (arg instanceof AsComputedEnum) {
                this.print(((AsComputedEnum)arg).fName);
            } else {
                this.print(arg.toString());
            }
        }

        private void printBoolean(Object arg) {
            if (arg instanceof __etools_string) {
                arg = new Boolean(arg.toString());
            }
            String s = arg != null ? (arg instanceof Boolean ? ((Boolean)arg).toString() : Boolean.toString(true)) : Boolean.toString(false);
            this.print(s.toUpperCase());
        }

        private void printHashCode(Object arg) {
            String s = arg == null ? "null" : Integer.toHexString(arg.hashCode());
            this.print(s);
        }

        private void print(String s) {
            if (this.precision != -1 && this.precision < s.length()) {
                s = s.substring(0, this.precision);
            }
            if (this.f.contains(Flags.UPPERCASE)) {
                s = s.toUpperCase();
            }
            EFormatter.this.a.append(this.justify(s));
        }

        private String justify(String s) {
            int i;
            if (this.width == -1) {
                return s;
            }
            StringBuilder sb = new StringBuilder();
            boolean pad = this.f.contains(Flags.LEFT_JUSTIFY);
            int sp = this.width - s.length();
            if (!pad) {
                i = 0;
                while (i < sp) {
                    sb.append(' ');
                    ++i;
                }
            }
            sb.append(s);
            if (pad) {
                i = 0;
                while (i < sp) {
                    sb.append(' ');
                    ++i;
                }
            }
            return sb.toString();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            Flags dupf = this.f.dup().remove(Flags.UPPERCASE);
            sb.append(dupf.toString());
            if (this.index > 0) {
                sb.append(this.index).append('$');
            }
            if (this.width != -1) {
                sb.append(this.width);
            }
            if (this.precision != -1) {
                sb.append('.').append(this.precision);
            }
            if (this.dt) {
                sb.append(this.f.contains(Flags.UPPERCASE) ? (char)'T' : 't');
            }
            sb.append(this.f.contains(Flags.UPPERCASE) ? Character.toUpperCase(this.c) : this.c);
            return sb.toString();
        }

        private void checkGeneral() {
            if ((this.c == 'b' || this.c == 'h') && this.f.contains(Flags.ALTERNATE)) {
                this.failMismatch(Flags.ALTERNATE, this.c);
            }
            if (this.width == -1 && this.f.contains(Flags.LEFT_JUSTIFY)) {
                throw new MissingFormatWidthException(this.toString());
            }
            this.checkBadFlags(Flags.PLUS, Flags.LEADING_SPACE, Flags.ZERO_PAD, Flags.GROUP, Flags.PARENTHESES);
        }

        private void checkDateTime() {
            if (this.precision != -1) {
                throw new IllegalFormatPrecisionException(this.precision);
            }
            if (!DateTime.isValid(this.c)) {
                throw new UnknownFormatConversionException("t" + this.c);
            }
            this.checkBadFlags(Flags.ALTERNATE, Flags.PLUS, Flags.LEADING_SPACE, Flags.ZERO_PAD, Flags.GROUP, Flags.PARENTHESES);
            if (this.width == -1 && this.f.contains(Flags.LEFT_JUSTIFY)) {
                throw new MissingFormatWidthException(this.toString());
            }
        }

        private void checkCharacter() {
            if (this.precision != -1) {
                throw new IllegalFormatPrecisionException(this.precision);
            }
            this.checkBadFlags(Flags.ALTERNATE, Flags.PLUS, Flags.LEADING_SPACE, Flags.ZERO_PAD, Flags.GROUP, Flags.PARENTHESES);
            if (this.width == -1 && this.f.contains(Flags.LEFT_JUSTIFY)) {
                throw new MissingFormatWidthException(this.toString());
            }
        }

        private void checkInteger() {
            this.checkNumeric();
            if (this.c == 'd') {
                this.checkBadFlags(Flags.ALTERNATE);
            } else if (this.c == 'o') {
                this.checkBadFlags(Flags.GROUP);
            } else {
                this.checkBadFlags(Flags.GROUP);
            }
        }

        private void checkBadFlags(Flags ... badFlags) {
            int i = 0;
            while (i < badFlags.length) {
                if (this.f.contains(badFlags[i])) {
                    this.failMismatch(badFlags[i], this.c);
                }
                ++i;
            }
        }

        private void checkFloat() {
            this.checkNumeric();
            if (this.c == 'e') {
                this.checkBadFlags(Flags.GROUP);
            }
        }

        private void checkNumeric() {
            if (this.width != -1 && this.width < 0) {
                throw new IllegalFormatWidthException(this.width);
            }
            if (this.precision != -1 && this.precision < 0) {
                throw new IllegalFormatPrecisionException(this.precision);
            }
        }

        private void checkText() {
            if (this.precision != -1) {
                throw new IllegalFormatPrecisionException(this.precision);
            }
            switch (this.c) {
                case '%': {
                    if (this.f.valueOf() != Flags.LEFT_JUSTIFY.valueOf() && this.f.valueOf() != Flags.NONE.valueOf()) {
                        throw new IllegalFormatFlagsException(this.f.toString());
                    }
                    if (this.width != -1 || !this.f.contains(Flags.LEFT_JUSTIFY)) break;
                    throw new MissingFormatWidthException(this.toString());
                }
                case 'n': {
                    if (this.width != -1) {
                        throw new IllegalFormatWidthException(this.width);
                    }
                    if (this.f.valueOf() == Flags.NONE.valueOf()) break;
                    throw new IllegalFormatFlagsException(this.f.toString());
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        private void print(int value) {
            long v = value;
            if (value < 0 && (this.c == 'o' || this.c == 'x')) assert ((v += 0x100000000L) >= 0L) : v;
            this.print(v);
        }

        private void print(long value) {
            StringBuilder sb = new StringBuilder();
            if (this.c == 'd') {
                int diff;
                boolean neg = value < 0L;
                char[] va = value < 0L ? Long.toString(value, 10).substring(1).toCharArray() : Long.toString(value, 10).toCharArray();
                this.leadingSign(sb, neg);
                char[] va2 = va;
                if (this.precision != -1 && (diff = this.precision - va.length) > 0) {
                    va2 = new char[this.precision];
                    int i = 0;
                    while (i < va2.length) {
                        va2[i] = i - diff >= 0 && i - diff < va.length ? va[i - diff] : 48;
                        ++i;
                    }
                }
                this.localizedMagnitude(sb, va2, this.f, this.adjustWidth(this.width, this.f, neg));
                this.trailingSign(sb, neg);
            } else if (this.c == 'o') {
                int len;
                this.checkBadFlags(Flags.PARENTHESES, Flags.LEADING_SPACE, Flags.PLUS);
                String s = Long.toOctalString(value);
                int n = len = this.f.contains(Flags.ALTERNATE) ? s.length() + 1 : s.length();
                if (this.f.contains(Flags.ALTERNATE)) {
                    sb.append('0');
                }
                if (this.f.contains(Flags.ZERO_PAD)) {
                    int i = 0;
                    while (i < this.width - len) {
                        sb.append('0');
                        ++i;
                    }
                }
                sb.append(s);
            } else if (this.c == 'x') {
                int len;
                this.checkBadFlags(Flags.PARENTHESES, Flags.LEADING_SPACE, Flags.PLUS);
                String s = Long.toHexString(value);
                int n = len = this.f.contains(Flags.ALTERNATE) ? s.length() + 2 : s.length();
                if (this.f.contains(Flags.ALTERNATE)) {
                    sb.append(this.f.contains(Flags.UPPERCASE) ? "0X" : "0x");
                }
                if (this.f.contains(Flags.ZERO_PAD)) {
                    int i = 0;
                    while (i < this.width - len) {
                        sb.append('0');
                        ++i;
                    }
                }
                if (this.f.contains(Flags.UPPERCASE)) {
                    s = s.toUpperCase();
                }
                sb.append(s);
            }
            EFormatter.this.a.append(this.justify(sb.toString()));
        }

        private StringBuilder leadingSign(StringBuilder sb, boolean neg) {
            if (!neg) {
                if (this.f.contains(Flags.PLUS)) {
                    sb.append('+');
                } else if (this.f.contains(Flags.LEADING_SPACE)) {
                    sb.append(' ');
                }
            } else if (this.f.contains(Flags.PARENTHESES)) {
                sb.append('(');
            } else {
                sb.append('-');
            }
            return sb;
        }

        private StringBuilder trailingSign(StringBuilder sb, boolean neg) {
            if (neg && this.f.contains(Flags.PARENTHESES)) {
                sb.append(')');
            }
            return sb;
        }

        private void print(BigDecimal value) {
            StringBuilder sb = new StringBuilder();
            boolean neg = value.signum() == -1;
            BigDecimal v = value.abs();
            this.leadingSign(sb, neg);
            this.print(sb, v, this.f, this.c, this.precision, neg);
            this.trailingSign(sb, neg);
            EFormatter.this.a.append(this.justify(sb.toString()));
        }

        private void print(StringBuilder sb, BigDecimal value, Flags f, char c, int precision, boolean neg) {
            if (c == 'e') {
                int compPrec;
                int prec = precision == -1 ? 6 : precision;
                int scale = value.scale();
                int origPrec = value.precision();
                int nzeros = 0;
                if (prec > origPrec - 1) {
                    compPrec = origPrec;
                    nzeros = prec - (origPrec - 1);
                } else {
                    compPrec = prec + 1;
                }
                MathContext mc = new MathContext(compPrec);
                BigDecimal v = new BigDecimal(value.unscaledValue(), scale, mc);
                BigDecimalLayout bdl = new BigDecimalLayout(v.unscaledValue(), v.scale(), BigDecimalLayoutForm.SCIENTIFIC);
                char[] mant = bdl.mantissa();
                if (!(origPrec != 1 && bdl.hasDot() || nzeros <= 0 && !f.contains(Flags.ALTERNATE))) {
                    mant = this.addDot(mant);
                }
                mant = this.trailingZeros(mant, nzeros);
                char[] exp = bdl.exponent();
                int newW = this.width;
                if (this.width != -1) {
                    newW = this.adjustWidth(this.width - exp.length - 1, f, neg);
                }
                this.localizedMagnitude(sb, mant, f, newW);
                sb.append(f.contains(Flags.UPPERCASE) ? (char)'E' : 'e');
                Flags flags = f.dup().remove(Flags.GROUP);
                char sign = exp[0];
                assert (sign == '+' || sign == '-');
                sb.append(exp[0]);
                char[] tmp = new char[exp.length - 1];
                System.arraycopy(exp, 1, tmp, 0, exp.length - 1);
                sb.append((CharSequence)this.localizedMagnitude(null, tmp, flags, -1));
            }
        }

        private int adjustWidth(int width, Flags f, boolean neg) {
            int newW = width;
            if (newW != -1 && neg && f.contains(Flags.PARENTHESES)) {
                --newW;
            }
            return newW;
        }

        private char[] addDot(char[] mant) {
            char[] tmp = mant;
            tmp = new char[mant.length + 1];
            System.arraycopy(mant, 0, tmp, 0, mant.length);
            tmp[tmp.length - 1] = 46;
            return tmp;
        }

        private char[] trailingZeros(char[] mant, int nzeros) {
            char[] tmp = mant;
            if (nzeros > 0) {
                tmp = new char[mant.length + nzeros];
                System.arraycopy(mant, 0, tmp, 0, mant.length);
                int i = mant.length;
                while (i < tmp.length) {
                    tmp[i] = 48;
                    ++i;
                }
            }
            return tmp;
        }

        private void print(Calendar t, char c) throws IOException {
            StringBuilder sb = new StringBuilder();
            this.print(sb, t, c);
            String s = this.justify(sb.toString());
            if (this.f.contains(Flags.UPPERCASE)) {
                s = s.toUpperCase();
            }
            EFormatter.this.a.append(s);
        }

        private Appendable print(StringBuilder sb, Calendar t, char c) throws IOException {
            assert (this.width == -1);
            if (sb == null) {
                sb = new StringBuilder();
            }
            switch (c) {
                case 'H': 
                case 'I': 
                case 'k': 
                case 'l': {
                    int i = t.get(11);
                    if (c == 'I' || c == 'l') {
                        i = i == 0 || i == 12 ? 12 : i % 12;
                    }
                    Flags flags = c == 'H' || c == 'I' ? Flags.ZERO_PAD : Flags.NONE;
                    sb.append((CharSequence)this.localizedMagnitude(null, i, flags, 2));
                    break;
                }
                case 'M': {
                    int i = t.get(12);
                    Flags flags = Flags.ZERO_PAD;
                    sb.append((CharSequence)this.localizedMagnitude(null, i, flags, 2));
                    break;
                }
                case 'N': {
                    int i = t.get(14) * 1000000;
                    Flags flags = Flags.ZERO_PAD;
                    sb.append((CharSequence)this.localizedMagnitude(null, i, flags, 9));
                    break;
                }
                case 'L': {
                    int i = t.get(14);
                    Flags flags = Flags.ZERO_PAD;
                    sb.append((CharSequence)this.localizedMagnitude(null, i, flags, 3));
                    break;
                }
                case 'Q': {
                    long i = t.getTimeInMillis();
                    Flags flags = Flags.NONE;
                    sb.append((CharSequence)this.localizedMagnitude(null, i, flags, this.width));
                    break;
                }
                case 'p': {
                    String[] ampm = new String[]{"AM", "PM"};
                    String s = ampm[t.get(9)];
                    sb.append(s.toLowerCase());
                    break;
                }
                case 's': {
                    long i = t.getTimeInMillis() / 1000L;
                    Flags flags = Flags.NONE;
                    sb.append((CharSequence)this.localizedMagnitude(null, i, flags, this.width));
                    break;
                }
                case 'S': {
                    int i = t.get(13);
                    Flags flags = Flags.ZERO_PAD;
                    sb.append((CharSequence)this.localizedMagnitude(null, i, flags, 2));
                    break;
                }
                case 'z': {
                    int i = t.get(15) + t.get(16);
                    boolean neg = i < 0;
                    sb.append(neg ? (char)'-' : '+');
                    if (neg) {
                        i = -i;
                    }
                    int min = i / 60000;
                    int offset = min / 60 * 100 + min % 60;
                    Flags flags = Flags.ZERO_PAD;
                    sb.append((CharSequence)this.localizedMagnitude(null, offset, flags, 4));
                    break;
                }
                case 'Z': {
                    TimeZone tz = t.getTimeZone();
                    sb.append(tz.getDisplayName(t.get(16) != 0, 0));
                    break;
                }
                case 'A': 
                case 'a': {
                    int i = t.get(7);
                    DateFormatSymbols dfs = DateFormatSymbols.getInstance(Locale.US);
                    if (c == 'A') {
                        sb.append(dfs.getWeekdays()[i]);
                        break;
                    }
                    sb.append(dfs.getShortWeekdays()[i]);
                    break;
                }
                case 'B': 
                case 'b': 
                case 'h': {
                    int i = t.get(2);
                    DateFormatSymbols dfs = DateFormatSymbols.getInstance(Locale.US);
                    if (c == 'B') {
                        sb.append(dfs.getMonths()[i]);
                        break;
                    }
                    sb.append(dfs.getShortMonths()[i]);
                    break;
                }
                case 'C': 
                case 'Y': 
                case 'y': {
                    int i = t.get(1);
                    int size = 2;
                    switch (c) {
                        case 'C': {
                            i /= 100;
                            break;
                        }
                        case 'y': {
                            i %= 100;
                            break;
                        }
                        case 'Y': {
                            size = 4;
                        }
                    }
                    Flags flags = Flags.ZERO_PAD;
                    sb.append((CharSequence)this.localizedMagnitude(null, i, flags, size));
                    break;
                }
                case 'd': 
                case 'e': {
                    int i = t.get(5);
                    Flags flags = c == 'd' ? Flags.ZERO_PAD : Flags.NONE;
                    sb.append((CharSequence)this.localizedMagnitude(null, i, flags, 2));
                    break;
                }
                case 'j': {
                    int i = t.get(6);
                    Flags flags = Flags.ZERO_PAD;
                    sb.append((CharSequence)this.localizedMagnitude(null, i, flags, 3));
                    break;
                }
                case 'm': {
                    int i = t.get(2) + 1;
                    Flags flags = Flags.ZERO_PAD;
                    sb.append((CharSequence)this.localizedMagnitude(null, i, flags, 2));
                    break;
                }
                case 'R': 
                case 'T': {
                    char sep = ':';
                    this.print(sb, t, 'H').append(sep);
                    this.print(sb, t, 'M');
                    if (c != 'T') break;
                    sb.append(sep);
                    this.print(sb, t, 'S');
                    break;
                }
                case 'r': {
                    char sep = ':';
                    this.print(sb, t, 'I').append(sep);
                    this.print(sb, t, 'M').append(sep);
                    this.print(sb, t, 'S').append(' ');
                    StringBuilder tsb = new StringBuilder();
                    this.print(tsb, t, 'p');
                    sb.append(tsb.toString().toUpperCase());
                    break;
                }
                case 'c': {
                    char sep = ' ';
                    this.print(sb, t, 'a').append(sep);
                    this.print(sb, t, 'b').append(sep);
                    this.print(sb, t, 'd').append(sep);
                    this.print(sb, t, 'T').append(sep);
                    this.print(sb, t, 'Z').append(sep);
                    this.print(sb, t, 'Y');
                    break;
                }
                case 'D': {
                    char sep = '/';
                    this.print(sb, t, 'm').append(sep);
                    this.print(sb, t, 'd').append(sep);
                    this.print(sb, t, 'y');
                    break;
                }
                case 'F': {
                    char sep = '-';
                    this.print(sb, t, 'Y').append(sep);
                    this.print(sb, t, 'm').append(sep);
                    this.print(sb, t, 'd');
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return sb;
        }

        private void failMismatch(Flags f, char c) {
            String fs = f.toString();
            throw new FormatFlagsConversionMismatchException(fs, c);
        }

        private void failConversion(char c, Object arg) {
            throw new IllegalFormatConversionException(c, arg.getClass());
        }

        private char getZero() {
            return EFormatter.this.zero;
        }

        private StringBuilder localizedMagnitude(StringBuilder sb, long value, Flags f, int width) {
            char[] va = Long.toString(value, 10).toCharArray();
            return this.localizedMagnitude(sb, va, f, width);
        }

        private StringBuilder localizedMagnitude(StringBuilder sb, char[] value, Flags f, int width) {
            int len;
            if (sb == null) {
                sb = new StringBuilder();
            }
            int begin = sb.length();
            char zero = this.getZero();
            char grpSep = '\u0000';
            int grpSize = -1;
            char decSep = '\u0000';
            int dot = len = value.length;
            int j = 0;
            while (j < len) {
                if (value[j] == '.') {
                    dot = j;
                    break;
                }
                ++j;
            }
            if (dot < len) {
                decSep = '.';
            }
            if (f.contains(Flags.GROUP)) {
                grpSep = ',';
                grpSize = 3;
            }
            j = 0;
            while (j < len) {
                if (j == dot) {
                    sb.append(decSep);
                    grpSep = '\u0000';
                } else {
                    char c = value[j];
                    sb.append((char)(c - 48 + zero));
                    if (grpSep != '\u0000' && j != dot - 1 && (dot - j) % grpSize == 1) {
                        sb.append(grpSep);
                    }
                }
                ++j;
            }
            len = sb.length();
            if (width != -1 && f.contains(Flags.ZERO_PAD)) {
                StringBuilder zeroPadding = new StringBuilder();
                int k = 0;
                while (k < width - len) {
                    zeroPadding.append(zero);
                    ++k;
                }
                if (zeroPadding.length() != 0) {
                    sb.insert(begin, zeroPadding.toString());
                }
            }
            return sb;
        }

        private class BigDecimalLayout {
            private StringBuilder mant;
            private StringBuilder exp;
            private boolean dot = false;

            public BigDecimalLayout(BigInteger intVal, int scale, BigDecimalLayoutForm form) {
                this.layout(intVal, scale, form);
            }

            public boolean hasDot() {
                return this.dot;
            }

            public char[] mantissa() {
                return this.toCharArray(this.mant);
            }

            public char[] exponent() {
                return this.toCharArray(this.exp);
            }

            private char[] toCharArray(StringBuilder sb) {
                if (sb == null) {
                    return null;
                }
                char[] result = new char[sb.length()];
                sb.getChars(0, result.length, result, 0);
                return result;
            }

            private void layout(BigInteger intVal, int scale, BigDecimalLayoutForm form) {
                char[] coeff = intVal.toString().toCharArray();
                this.mant = new StringBuilder(coeff.length + 14);
                if (scale == 0) {
                    int len = coeff.length;
                    if (len > 1) {
                        this.mant.append(coeff[0]);
                        if (form == BigDecimalLayoutForm.SCIENTIFIC) {
                            this.mant.append('.');
                            this.dot = true;
                            this.mant.append(coeff, 1, len - 1);
                            this.exp = new StringBuilder("+");
                            if (len < 10) {
                                this.exp.append("0").append(len - 1);
                            } else {
                                this.exp.append(len - 1);
                            }
                        } else {
                            this.mant.append(coeff, 1, len - 1);
                        }
                    } else {
                        this.mant.append(coeff);
                        if (form == BigDecimalLayoutForm.SCIENTIFIC) {
                            this.exp = new StringBuilder("+00");
                        }
                    }
                    return;
                }
                long adjusted = -((long)scale) + (long)(coeff.length - 1);
                if (form == BigDecimalLayoutForm.DECIMAL_FLOAT) {
                    int pad = scale - coeff.length;
                    if (pad >= 0) {
                        this.mant.append("0.");
                        this.dot = true;
                        while (pad > 0) {
                            this.mant.append('0');
                            --pad;
                        }
                        this.mant.append(coeff);
                    } else if (-pad < coeff.length) {
                        this.mant.append(coeff, 0, -pad);
                        this.mant.append('.');
                        this.dot = true;
                        this.mant.append(coeff, -pad, scale);
                    } else {
                        this.mant.append(coeff, 0, coeff.length);
                        int i = 0;
                        while (i < -scale) {
                            this.mant.append('0');
                            ++i;
                        }
                    }
                } else {
                    this.mant.append(coeff[0]);
                    if (coeff.length > 1) {
                        this.mant.append('.');
                        this.dot = true;
                        this.mant.append(coeff, 1, coeff.length - 1);
                    }
                    this.exp = new StringBuilder();
                    if (adjusted != 0L) {
                        long abs = Math.abs(adjusted);
                        this.exp.append(adjusted < 0L ? (char)'-' : '+');
                        if (abs < 10L) {
                            this.exp.append('0');
                        }
                        this.exp.append(abs);
                    } else {
                        this.exp.append("+00");
                    }
                }
            }
        }
    }

    private static interface FormatString {
        public int index();

        public void print(Object var1) throws IOException;

        public String toString();
    }
}

