/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.ascomputed.base;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.edt.base.model.reflection.ascomputed.base.EList;
import ro.amiq.edt.base.model.reflection.ascomputed.base.IRfCloneable;
import ro.amiq.edt.base.model.reflection.ascomputed.base._Int;

public class EKeyedList<T>
extends EList<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Object, Integer> keys = new HashMap<Object, Integer>();
    private String fieldName;

    public EKeyedList(String fieldName, Class<T> clazz, int size) {
        super(clazz, size);
        this.fieldName = fieldName;
    }

    public EKeyedList(String fieldName) {
        this.fieldName = fieldName;
    }

    public EKeyedList(String fieldName, EList<T> e) {
        super(e);
        this.fieldName = fieldName;
    }

    public EKeyedList(String fieldName, T ... a) {
        super(a);
        this.fieldName = fieldName;
    }

    @Override
    public boolean key_exists(Object key) {
        return this.keys.containsKey(key);
    }

    @Override
    public int key_index(Object key) {
        Integer index = this.keys.get(key);
        if (index == null) {
            return -1;
        }
        return index;
    }

    @Override
    public T key(Object key) {
        int index = this.key_index(key);
        if (index == -1) {
            return null;
        }
        return this.get(index);
    }

    @Override
    public boolean add(Object element) {
        Object key = this.getKeyObject(element);
        if (key == null) {
            return false;
        }
        Integer keyIndex = this.keys.get(key);
        if (keyIndex != null) {
            this.list.set(keyIndex, element);
            return true;
        }
        boolean result = super.add(element);
        this.keys.put(key, this.list.size() - 1);
        return result;
    }

    private Object getKeyObject(Object element) {
        try {
            if ("it".equals(this.fieldName)) {
                return element;
            }
            Field keyField = element.getClass().getDeclaredField("__etools_" + this.fieldName);
            return keyField.get(element);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add0(Object element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        super.clear();
        this.keys.clear();
    }

    @Override
    public T remove(_Int index) {
        Object element = super.remove(index);
        if (element != null) {
            Iterator<Map.Entry<Object, Integer>> keyIterator = this.keys.entrySet().iterator();
            while (keyIterator.hasNext()) {
                if (!index.toString().equals(keyIterator.next().getValue().toString())) continue;
                keyIterator.remove();
            }
        }
        return element;
    }

    @Override
    public void fast_delete(_Int index) {
        this.remove(index);
    }

    @Override
    public void delete(_Int index) {
        this.remove(index);
    }

    @Override
    public Object clone_deep() throws Exception {
        EKeyedList<T> result = new EKeyedList<T>(this.fieldName);
        for (Object obj : this) {
            if (obj instanceof _Int) {
                result.add(new _Int((_Int)obj));
                continue;
            }
            if (obj instanceof Integer) {
                result.add(obj);
                continue;
            }
            if (obj instanceof Boolean) {
                result.add(obj);
                continue;
            }
            if (!(obj instanceof IRfCloneable)) continue;
            result.add(((IRfCloneable)obj).clone_deep());
        }
        return result;
    }

    @Override
    public Object clone_copy() throws Exception {
        EKeyedList<T> result = new EKeyedList<T>(this.fieldName);
        result.addAll(this);
        return result;
    }
}

