/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.ascomputed.base;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import ro.amiq.edt.base.model.reflection.ascomputed.base.AsComputedBase;
import ro.amiq.edt.base.model.reflection.ascomputed.base.ERange;
import ro.amiq.edt.base.model.reflection.ascomputed.base.IRfCloneable;
import ro.amiq.edt.base.model.reflection.ascomputed.base.IRfType;
import ro.amiq.edt.base.model.reflection.ascomputed.base._Int;
import ro.amiq.edt.base.model.reflection.ascomputed.base.__etools_string;
import ro.amiq.etools.eparser.EParser;

public class EList<T>
implements Serializable,
Iterable<T>,
IRfType,
IRfCloneable {
    private static final long serialVersionUID = 1L;
    public Class<T> clazz;
    protected List<T> list = new ArrayList<T>();

    public <TT> EList<TT> get_field(Class<TT> clazz, String fieldName) throws Exception {
        try {
            EList<T> result = new EList<T>();
            for (T item : this.list) {
                Field field = item.getClass().getDeclaredField(fieldName);
                result.add(field.get(item));
            }
            return result;
        }
        catch (SecurityException securityException) {
            EParser.getAsComputedExecutionConsole().println(1, "Field '" + fieldName + "' of type '" + clazz.getName().replace("ro.amiq.edt.base.debug.ascomputed.__etools_", "") + "' is not accessible.");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            EParser.getAsComputedExecutionConsole().println(1, "Type '" + clazz.getName().replace("ro.amiq.edt.base.debug.ascomputed.__etools_", "") + "' does not have a field named '" + fieldName + "'");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            EParser.getAsComputedExecutionConsole().println(1, "Type '" + clazz.getName().replace("ro.amiq.edt.base.debug.ascomputed.__etools_", "") + "' does not have a field named '" + fieldName + "'");
        }
        catch (IllegalAccessException illegalAccessException) {
            EParser.getAsComputedExecutionConsole().println(1, "Field '" + fieldName + "' of type '" + clazz.getName().replace("ro.amiq.edt.base.debug.ascomputed.__etools_", "") + "' is not accessible.");
        }
        return null;
    }

    public EList(Class<T> clazz, int size) {
        this.resize(clazz, size);
    }

    public EList() {
    }

    public EList(EList<T> e) {
        this.addAll(e);
    }

    public EList(T ... a) {
        if (a == null) {
            return;
        }
        List<T> e = Arrays.asList(a);
        this.addAll(e);
    }

    public _Int size() {
        return new _Int(Integer.toString(this.list.size()), 10);
    }

    public void clear() {
        this.list.clear();
    }

    public T remove(_Int index) {
        return this.remove(index.intValue());
    }

    private T remove(int index) {
        T element = this.list.remove(index);
        return element;
    }

    public EList<T> sort(Comparator<T> comparator) {
        Object[] sorted = new Object[this.list.size()];
        Arrays.sort(this.list.toArray(sorted), comparator);
        EList<Object> result = new EList<Object>();
        result.addAll(Arrays.asList(sorted));
        return result;
    }

    public T get(_Int index) {
        return this.get(index.intValue());
    }

    protected T get(int index) {
        if (index < 0 || index >= this.list.size()) {
            return null;
        }
        return this.list.get(index);
    }

    public void push(T e) {
        this.add(e);
    }

    public void push0(T e) {
        this.add0(e);
    }

    public EList<T> subList(ERange range) {
        if (range == null) {
            return new EList<T>();
        }
        _Int leftValue = range.getLeft();
        int left = leftValue == null ? 0 : leftValue.intValue();
        _Int rightValue = range.getRight();
        int right = rightValue == null || rightValue.intValue() == Integer.MAX_VALUE ? this.list.size() : rightValue.intValue() + 1;
        return this.subList(left, right);
    }

    public EList<T> subList(_Int from) {
        return this.subList(from, this.size());
    }

    public EList<T> subList(_Int from, _Int to) {
        return this.subList(from.intValue(), to.intValue());
    }

    protected EList<T> subList(int from, int to) {
        if (to < from) {
            int temp = from;
            from = to;
            to = temp;
        }
        to = Math.min(to, this.list.size());
        from = Math.max(0, from);
        EList<T> result = new EList<T>();
        if (to >= from) {
            result.list.addAll(this.list.subList(from, to));
        }
        return result;
    }

    public void resize(Class<T> clazz, _Int size) {
        this.resize(clazz, size.intValue());
    }

    private void resize(Class<T> clazz, int size) {
        int i = 0;
        while (i < size) {
            if (clazz.equals(_Int.class)) {
                this.list.add(_Int.ZERO);
            } else if (clazz.equals(Boolean.class)) {
                this.list.add(false);
            } else if (clazz.equals(__etools_string.class)) {
                this.list.add(new __etools_string(""));
            } else {
                this.list.add(null);
            }
            ++i;
        }
    }

    public boolean is_empty() {
        return this.list.isEmpty();
    }

    public boolean add(Object e) {
        if (this.clazz != null && this.clazz.isInstance(e)) {
            this.list.add(e);
        } else if (e instanceof EList) {
            for (T c : ((EList)e).list) {
                this.add(c);
            }
        } else {
            this.list.add(e);
        }
        return true;
    }

    public boolean add0(Object e) {
        if (this.clazz != null && this.clazz.isInstance(e)) {
            this.list.add(0, e);
        } else if (e instanceof EList) {
            int i = ((EList)e).list.size() - 1;
            while (i >= 0) {
                T c = ((EList)e).get(i);
                this.add0(c);
                --i;
            }
        } else {
            this.list.add(0, e);
        }
        return true;
    }

    public void delete(_Int index) {
        this.delete(index.intValue());
    }

    private void delete(int index) {
        this.list.remove(index);
    }

    public void fast_delete(_Int index) {
        this.fast_delete(index.intValue());
    }

    private void fast_delete(int index) {
        this.list.set(index, null);
    }

    public void insert(int index, Object e) {
        if (this.clazz != null && this.clazz.isInstance(e)) {
            this.add(index, e);
        } else if (e instanceof EList) {
            this.addAll(index, (EList)e);
        } else {
            this.add(index, e);
        }
    }

    public T pop() {
        return this.list.remove(this.list.size() - 1);
    }

    public T pop0() {
        return this.list.remove(0);
    }

    public T top() {
        return this.get(this.list.size() - 1);
    }

    public T top0() {
        return this.get(0);
    }

    public EList<T> copy() {
        return new EList<T>(this);
    }

    public EList<T> reverse() {
        EList<T> e = new EList<T>();
        int i = 0;
        while (i < this.list.size()) {
            e.list.add(0, this.get(i));
            ++i;
        }
        return e;
    }

    public boolean exists(_Int index) {
        return this.exists(index.intValue());
    }

    private boolean exists(int index) {
        return index >= 0 && index < this.list.size();
    }

    public T key(Object key) {
        return null;
    }

    public boolean key_exists(Object key) {
        return false;
    }

    public int key_index(Object key) {
        return 0;
    }

    public String toString() {
        Iterator<T> i = this.list.iterator();
        if (!i.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            T e = i.next();
            sb.append(e.toString());
            if (!i.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(", ");
        }
    }

    public String list_as_string(AsComputedBase global) {
        Iterator<T> i = this.list.iterator();
        if (!i.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (true) {
            T e;
            if ((e = i.next()) instanceof __etools_string) {
                sb.append(global.str_expand_dots((__etools_string)e));
            } else {
                sb.append(e.toString());
            }
            if (!i.hasNext()) {
                return sb.toString();
            }
            sb.append(", ");
        }
    }

    @Override
    public Object clone_deep() throws Exception {
        EList<T> result = new EList<T>();
        for (T obj : this.list) {
            if (obj instanceof _Int) {
                result.add(new _Int((_Int)obj));
                continue;
            }
            if (obj instanceof Integer) {
                result.add(obj);
                continue;
            }
            if (obj instanceof Boolean) {
                result.add(obj);
                continue;
            }
            if (!(obj instanceof IRfCloneable)) continue;
            result.add(((IRfCloneable)obj).clone_deep());
        }
        return result;
    }

    @Override
    public Object clone_copy() throws Exception {
        EList<T> result = new EList<T>();
        result.addAll(this);
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    public boolean addAll(Iterable<? extends T> elements) {
        if (elements != null) {
            for (T element : elements) {
                this.add(element);
            }
        }
        return true;
    }

    public boolean addAll(int index, Iterable<? extends T> elements) {
        if (elements != null) {
            for (T element : elements) {
                this.add(index, element);
            }
        }
        return true;
    }

    protected void add(int index, T element) {
        this.list.add(index, element);
    }

    public T set(_Int index, T e) {
        return this.set(index.intValue(), e);
    }

    private T set(int index, T e) {
        return this.list.set(index, e);
    }

    public boolean contains(T e) {
        return this.list.contains(e);
    }

    @Override
    public String getPackageName() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }
}

