/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.predefined;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.edt.base.model.IEProject;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.ascomputed.ClassEncap;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedMethod;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedStruct;
import ro.amiq.edt.base.utils.EDTFileUtils;

public class RfGlobal
extends RfPredefinedStruct {
    private static final Set<String> IMPLEMENTED_METHODS = new HashSet<String>();

    static {
        IMPLEMENTED_METHODS.add("append");
        IMPLEMENTED_METHODS.add("appendf");
        IMPLEMENTED_METHODS.add("pow");
        IMPLEMENTED_METHODS.add("out");
        IMPLEMENTED_METHODS.add("outf");
        IMPLEMENTED_METHODS.add("writef");
        IMPLEMENTED_METHODS.add("error");
        IMPLEMENTED_METHODS.add("warning");
        IMPLEMENTED_METHODS.add("print");
        IMPLEMENTED_METHODS.add("str_match");
        IMPLEMENTED_METHODS.add("empty");
        IMPLEMENTED_METHODS.add("str_join");
        IMPLEMENTED_METHODS.add("str_empty");
        IMPLEMENTED_METHODS.add("str_len");
        IMPLEMENTED_METHODS.add("str_split");
        IMPLEMENTED_METHODS.add("str_split_all");
        IMPLEMENTED_METHODS.add("str_lower");
        IMPLEMENTED_METHODS.add("str_upper");
        IMPLEMENTED_METHODS.add("str_pad");
        IMPLEMENTED_METHODS.add("str_exactly");
        IMPLEMENTED_METHODS.add("str_chop");
        IMPLEMENTED_METHODS.add("str_sub");
        IMPLEMENTED_METHODS.add("str_replace");
        IMPLEMENTED_METHODS.add("str_insensitive");
        IMPLEMENTED_METHODS.add("str_trim");
        IMPLEMENTED_METHODS.add("str_repeat");
        IMPLEMENTED_METHODS.add("quote");
        IMPLEMENTED_METHODS.add("str_expand_dots");
        IMPLEMENTED_METHODS.add("get_symbol");
        IMPLEMENTED_METHODS.add("dec");
        IMPLEMENTED_METHODS.add("hex");
        IMPLEMENTED_METHODS.add("bin");
        IMPLEMENTED_METHODS.add("ipow");
        IMPLEMENTED_METHODS.add("ilog2");
        IMPLEMENTED_METHODS.add("ilog10");
        IMPLEMENTED_METHODS.add("min");
        IMPLEMENTED_METHODS.add("max");
        IMPLEMENTED_METHODS.add("abs");
        IMPLEMENTED_METHODS.add("isqrt");
        IMPLEMENTED_METHODS.add("odd");
        IMPLEMENTED_METHODS.add("even");
        IMPLEMENTED_METHODS.add("div_round_up");
        IMPLEMENTED_METHODS.add("all_values");
        IMPLEMENTED_METHODS.add("set_of_values");
        IMPLEMENTED_METHODS.add("full_set_of_values");
        IMPLEMENTED_METHODS.add("date_time");
        IMPLEMENTED_METHODS.add("sn_version_string");
        IMPLEMENTED_METHODS.add("reject_match");
        IMPLEMENTED_METHODS.add("ceil");
        IMPLEMENTED_METHODS.add("floor");
        IMPLEMENTED_METHODS.add("round");
        IMPLEMENTED_METHODS.add("get_context_name");
        IMPLEMENTED_METHODS.add("get_context_type");
    }

    public RfGlobal(RfProject project) {
        super(project, "global", "main", false, "The predefined struct global is the root of all e structs. All predefined structs and most predefined methods are part of the global struct. It is highly recommended that you do not extend the global struct.", null);
        RfPredefinedMethod method = null;
        if (!project.isInSDLMode()) {
            method = new RfPredefinedMethod(this.getRfProject(), this, "in_sequence", "", "sequence_type", "", " [sequence pseudoroutine] in_sequence() can be used in constraints to determine whether an item is inside a specific sequence type. This allows enforcing constraints on every item in the sequence tree under a specific sequence. Therefore, this kind of constraint is called a tree constraint.");
            this.addMethod(method);
            method = new RfPredefinedMethod(this.getRfProject(), this, "in_unit", "", "unit_type", "", " [sequence pseudoroutine] in_unit() returns TRUE if you are inside such a unit (at any depth). If name is specified, it assigns the found unit to name.");
            this.addMethod(method);
        }
    }

    @Override
    public boolean isTemplateStruct() {
        return false;
    }

    @Override
    public ClassEncap toClassEncap(RfProject rfProject) {
        HashSet<RfType> references = new HashSet<RfType>();
        String javaName = this.javaName();
        StringBuilder javaCode = new StringBuilder("package ").append("ro.amiq.edt.base.debug.ascomputed").append(";\n").append("import ro.amiq.dvt.model.reflection.*;\n").append("import ro.amiq.edt.base.model.reflection.*;\n").append("import ro.amiq.etools.eparser.*;\n").append("import java.io.IOException;\n").append("import java.lang.ClassNotFoundException;\n").append("import java.lang.reflect.Field;\n").append("import ro.amiq.edt.base.model.reflection.ascomputed.*;\n").append("import ro.amiq.edt.base.model.reflection.ascomputed.base.*;\n").append("import java.io.Serializable;\n").append("import java.util.*;\n\n").append("public class ").append(javaName).append(" extends AsComputedBase implements Serializable {\n\n").append("    private static final long serialVersionUID = ").append(javaName.hashCode()).append("L;\n\n");
        List<RfStructMember> methods = this.getMethods();
        boolean newElementsToTranslate = this.javaTranslateMethods(rfProject, methods);
        StringBuilder javaInitCode = new StringBuilder();
        List<RfStructMember> fields = this.getAsComputedUsedFields();
        for (RfStructMember field : fields) {
            ClassEncap classEncap;
            if ("rf_manager".equals(field.getName()) || (classEncap = ((RfField)field).toClassEncap(true)) == null) continue;
            ((RfField)field).toClassEncapInitField(false, javaInitCode);
            Collection<RfType> allRefered = classEncap.getRefered();
            if (allRefered != null) {
                references.addAll(allRefered);
            }
            if (classEncap.getContent().startsWith("static class")) {
                javaCode.append("    ").append(classEncap.getContent()).append(";\n");
                continue;
            }
            javaCode.append("    public ").append(classEncap.getContent()).append(";\n");
        }
        javaCode.append("\n");
        javaCode.append("    public static class base_class implements IRfType, IRfCloneable, Cloneable, Serializable {\n\n");
        javaCode.append("        private static final long serialVersionUID = ").append("base_class".hashCode()).append("L;\n\n");
        javaCode.append("        public static ").append(javaName).append(" __global = getInstance();\n\n");
        javaCode.append("        public Object clone_deep() throws Exception {\n");
        javaCode.append("            return super.clone();\n");
        javaCode.append("        }\n\n");
        javaCode.append("        public Object clone_copy() throws Exception {\n");
        javaCode.append("            return super.clone();\n");
        javaCode.append("        }\n\n");
        javaCode.append("        public String getName() {\n");
        javaCode.append("            return \"").append(this.getName()).append("\";\n");
        javaCode.append("        }\n\n");
        javaCode.append("        public String getPackageName() {\n");
        javaCode.append("            return \"").append(this.getPackageName()).append("\";\n");
        javaCode.append("        }\n\n");
        javaCode.append("    }\n\n");
        javaCode.append("    private static transient ").append(javaName).append(" __global;\n\n");
        javaCode.append("    public static __etools_main_global getInstance() {\n");
        javaCode.append("    \tif (__global == null) {\n");
        javaCode.append("    \t\t__global = new __etools_main_global();\n");
        javaCode.append("    \t\t__global = (__etools_main_global) AsComputedEvolvedClassHandler.INSTANCE.getEvolvedRestoredObject(__global);\n");
        javaCode.append("       }\n");
        javaCode.append("    \treturn __global;\n");
        javaCode.append("    }\n\n");
        javaCode.append("    private void initEvolvedClassNewFields(Set<String> restoredFields) {\n");
        javaCode.append((CharSequence)javaInitCode);
        javaCode.append("    }\n");
        javaCode.append("    private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException {\n");
        javaCode.append("    \t Set<String> restoredFields = (Set<String>) in.readObject();\n");
        javaCode.append("    \t in.defaultReadObject();\n");
        javaCode.append("    \t initEvolvedClassNewFields(restoredFields);\n");
        javaCode.append("    }\n\n");
        javaCode.append("    private void writeObject(java.io.ObjectOutputStream out) throws IOException {\n");
        javaCode.append("    \t Set<String> existingFields = new HashSet<>();\n");
        javaCode.append("    \t Field[] fields = this.getClass().getDeclaredFields();\n");
        javaCode.append("    \t for (Field field : fields) {\n");
        javaCode.append("            existingFields.add(field.getName());\n");
        javaCode.append("    \t }\n");
        javaCode.append("    \t out.writeObject(existingFields);\n");
        javaCode.append("    \t out.defaultWriteObject();\n");
        javaCode.append("    }\n\n");
        javaCode.append("    public IRfType get_current_module(EModuleLexer __etools_module) {\n");
        javaCode.append("        String modulePath = __etools_module.getEModuleName();\n");
        javaCode.append("        String moduleName = new java.io.File(modulePath).getName();\n");
        javaCode.append("        int index = moduleName.lastIndexOf('.');\n");
        javaCode.append("        if (index > 0)\n");
        javaCode.append("            moduleName = moduleName.substring(0, index);\n\n");
        javaCode.append("        EList<IRfType> modules = __etools_rf_manager.get_user_modules();\n");
        javaCode.append("        for (IRfType module: modules) {\n");
        javaCode.append("            final String tempName = module.get_name().toString();\n");
        javaCode.append("            if (tempName.equals(moduleName))\n");
        javaCode.append("                return module;\n");
        javaCode.append("        }\n");
        javaCode.append("        RfModule module = new RfModule(moduleName, -1, -1, -1, -1, new ParserPath(modulePath), false, null, (RfProject) __etools_rf_manager, false, false, null);\n");
        javaCode.append("        module.setPackageName(__etools_module.getPackageName());\n");
        javaCode.append("        return module;\n");
        javaCode.append("    }\n\n");
        javaCode.append("    public _Int get_current_line_num(EModuleLexer __etools_module)   {\n        return new _Int(Integer.toString(__etools_module.getLine()), 10);\n    }\n\n");
        boolean isAutoTranslateDisable = BuildConfigManager.isAsComputedAutoMethodsTranslateDisable((IProject)rfProject.getProject());
        if (isAutoTranslateDisable) {
            IEProject eProject = rfProject.getModelManager().getEModel().getEProject(rfProject.getProject());
            Set<String> methods2translate = eProject.getAsComputedMethodsToTranslate(this.getPackageName(), this.getName());
            if (methods2translate != null) {
                for (RfStructMember method : methods) {
                    ClassEncap classEncap;
                    if (!methods2translate.contains(method.getName()) || (classEncap = method.toClassEncap(rfProject)) == null) continue;
                    Collection<RfType> allRefered = classEncap.getRefered();
                    if (allRefered != null) {
                        references.addAll(allRefered);
                    }
                    javaCode.append("    ").append(classEncap.getContent()).append("\n");
                }
            }
        } else {
            for (RfStructMember method : methods) {
                ClassEncap classEncap;
                if (!((RfMethod)method).isAsComputedTranslate() || IMPLEMENTED_METHODS.contains(method.getName()) || (classEncap = method.toClassEncap(rfProject)) == null) continue;
                Collection<RfType> allRefered = classEncap.getRefered();
                if (allRefered != null) {
                    references.addAll(allRefered);
                }
                javaCode.append("    ").append(classEncap.getContent()).append("\n");
            }
        }
        javaCode.append("\n}");
        EDTFileUtils.getInstance().dumpAsComputedDebug(rfProject.getProject(), javaName, javaCode.toString());
        return new ClassEncap("\n" + javaCode.toString(), references, newElementsToTranslate);
    }

    @Override
    public String javaName() {
        return "__etools_main_global";
    }
}

