/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.predefined;

import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.util.RfUtils;

public class RfPredefinedEvent
extends RfEvent {
    private String fComment;
    private boolean fIsEPredefined;

    public RfPredefinedEvent(RfProject project, RfStruct parent, String name, String predefinedComment) {
        super(project, parent, new FullName(name, parent.getDeterminant()));
        this.fComment = predefinedComment;
    }

    @Override
    public boolean isPredefined() {
        return true;
    }

    @Override
    public boolean isEPredefined() {
        return this.fIsEPredefined;
    }

    public void setEPredefined(boolean isEPredefined) {
        this.fIsEPredefined = isEPredefined;
    }

    @Override
    public String getPackageName() {
        RfStruct parentStruct = this.getParentStruct();
        if (parentStruct == null) {
            return "main";
        }
        return parentStruct.getPackageName();
    }

    @Override
    public String getComment(boolean removeHTMLTags) {
        String comment = "<i>PREDEFINED: </i>" + (this.fComment == null ? "[Description not available]" : this.fComment);
        if (removeHTMLTags) {
            return DVTStringUtil.replaceAll((Pattern)RfUtils.HTML_TAGS_PATTERN, (CharSequence)comment, (String)"");
        }
        return comment;
    }

    @Override
    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currLayer, LineInfo lineInfo, ParserPath parserPath) {
    }

    @Override
    public void deepClean() {
        try {
            this.clearLayers();
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    @Override
    public boolean checkEquals(Object obj) {
        if (!(obj instanceof RfPredefinedEvent)) {
            return super.checkEquals(obj);
        }
        RfPredefinedEvent element = (RfPredefinedEvent)obj;
        if (this.getName() != null && !this.getName().equals(element.getName())) {
            return false;
        }
        if (this.getName() == null) {
            return false;
        }
        RfStruct parentStruct = this.getParentStruct();
        RfStruct elementParentStruct = element.getParentStruct();
        if (parentStruct != null && elementParentStruct != null && parentStruct.getName() != null && parentStruct.getName().equals(elementParentStruct.getName())) {
            return true;
        }
        return super.checkEquals(obj);
    }
}

