/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.predefined;

import java.util.regex.Pattern;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.WrapperType;
import ro.amiq.edt.base.model.reflection.ascomputed.ClassEncap;
import ro.amiq.edt.base.model.reflection.util.RfUtils;

public class RfPredefinedField
extends RfField {
    private String fComment;
    private boolean fIsEPredefined;

    public RfPredefinedField(RfProject project, RfStruct parent, String name, String typeName, boolean isInstance, boolean isUngenerated, boolean isPhysical, String comment) {
        super(project, parent, new FullName(name, parent.getDeterminant()));
        WrapperType typeInfo = WrapperType.fromName(typeName);
        typeInfo.baseType = 0;
        typeInfo.isInstance = isInstance;
        typeInfo.isGenerated = isUngenerated;
        typeInfo.isPhysical = isPhysical;
        this.setAssociatedType(null, typeInfo);
        this.fComment = comment;
        if (comment != null && comment.contains("@non_standard")) {
            this.setNonStandard(true);
        }
    }

    public RfPredefinedField(RfProject project, RfStruct parent, String name, WrapperType typeInfo, boolean isInstance, boolean isUngenerated, boolean isPhysical, String comment) {
        super(project, parent, new FullName(name, parent.getDeterminant()));
        typeInfo.isInstance = isInstance;
        typeInfo.isGenerated = isUngenerated;
        typeInfo.isPhysical = isPhysical;
        this.setAssociatedType(null, typeInfo);
        this.fComment = comment;
        if (comment != null && comment.contains("@non_standard")) {
            this.setNonStandard(true);
        }
    }

    @Override
    public String getPackageName() {
        RfStruct parentStruct = this.getParentStruct();
        if (parentStruct == null) {
            return "main";
        }
        return parentStruct.getPackageName();
    }

    @Override
    public boolean isPredefined() {
        return true;
    }

    @Override
    public boolean isEPredefined() {
        return this.fIsEPredefined;
    }

    public void setEPredefined(boolean isEPredefined) {
        this.fIsEPredefined = isEPredefined;
    }

    @Override
    public boolean isGenerated() {
        return super.isGenerated();
    }

    @Override
    public String getComment(boolean removeHTMLTags) {
        String comment = "<i>PREDEFINED: </i>" + (this.fComment == null ? "[Description not available]" : this.fComment);
        if (removeHTMLTags) {
            return DVTStringUtil.replaceAll((Pattern)RfUtils.HTML_TAGS_PATTERN, (CharSequence)comment, (String)"");
        }
        return comment;
    }

    @Override
    public ClassEncap toClassEncap(RfProject rfProject) {
        return this.toClassEncap(false);
    }

    @Override
    public ClassEncap toClassEncap(boolean initField) {
        if (this.getName().equals("rf_manager")) {
            StringBuilder javaCode = new StringBuilder("IRfManager ").append(this.javaName());
            return new ClassEncap(javaCode.toString(), null, false);
        }
        return super.toClassEncap(initField);
    }

    @Override
    public void deepClean() {
        try {
            this.clearLayers();
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    @Override
    public boolean checkEquals(Object obj) {
        if (!(obj instanceof RfPredefinedField)) {
            return super.checkEquals(obj);
        }
        RfPredefinedField element = (RfPredefinedField)obj;
        if (this.getName() != null && !this.getName().equals(element.getName())) {
            return false;
        }
        if (this.getName() == null) {
            return false;
        }
        RfStruct parentStruct = this.getParentStruct();
        RfStruct elementParentStruct = element.getParentStruct();
        if (parentStruct != null && elementParentStruct != null && parentStruct.getName() != null && parentStruct.getName().equals(elementParentStruct.getName())) {
            return true;
        }
        return super.checkEquals(obj);
    }
}

