/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.predefined;

import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.RfArg;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.WrapperType;
import ro.amiq.edt.base.model.reflection.ascomputed.ClassEncap;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedArg;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedStruct;
import ro.amiq.edt.base.model.reflection.util.RfUtils;

public class RfPredefinedMethod
extends RfMethod {
    private String fComment;
    private ListContainer<RfArg> fArguments;
    private boolean fIsIgnoreArgs;
    private boolean fIsEPredefined;

    private RfPredefinedMethod(RfProject project, RfStruct parent, String name) {
        super(project, parent, new FullName(name, parent.getDeterminant()));
    }

    public static RfPredefinedMethod createCopyMethod(RfProject project, RfStruct parent, Determinant determinant) {
        RfPredefinedMethod method = new RfPredefinedMethod(project, parent, "copy");
        method.setAssociatedType(parent);
        method.setAssociatedTypeDeterminant(determinant);
        return method;
    }

    public RfPredefinedMethod(RfProject project, RfStruct parent, String name, String resultType, String argDescription, String eventName, String comment) {
        super(project, parent, new FullName(name, parent.getDeterminant()));
        this.setArgumentDescr(argDescription);
        this.setTCMEventName(eventName);
        if (resultType != null && resultType.length() > 0) {
            WrapperType typeInfo = WrapperType.fromName(resultType);
            typeInfo.baseType = 0;
            this.setAssociatedType(null, typeInfo);
        }
        this.fComment = comment;
        if (comment != null && comment.contains("@non_standard")) {
            this.setNonStandard(true);
        }
    }

    @Override
    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currLayer, LineInfo lineInfo, ParserPath parserPath) {
        super.performAdditionalSemanticChecks(project, currLayer, lineInfo, parserPath);
    }

    @Override
    public void setAssociatedTypeFrom(RfProject project, RfNamedElement typeContainer) {
        if (this.getAssociatedType() != null) {
            return;
        }
        super.setAssociatedTypeFrom(project, typeContainer);
    }

    @Override
    public void setArgumentDescr(String argDescription) {
        this.fIsIgnoreArgs = argDescription == null ? false : argDescription.equals("__dvt_ignore_args");
        super.setArgumentDescr(argDescription);
    }

    @Override
    public boolean isIgnoreArgs() {
        return this.fIsIgnoreArgs;
    }

    @Override
    public boolean isPredefined() {
        return true;
    }

    @Override
    public boolean isEPredefined() {
        return this.fIsEPredefined;
    }

    public void setEPredefined(boolean isEPredefined) {
        this.fIsEPredefined = isEPredefined;
    }

    @Override
    public String getPackageName() {
        RfStruct parentStruct = this.getParentStruct();
        if (parentStruct == null) {
            return "main";
        }
        return parentStruct.getPackageName();
    }

    @Override
    public String getComment(boolean removeHTMLTags) {
        String comment = "<i>PREDEFINED: </i>" + (this.fComment == null ? "[Description not available]" : this.fComment);
        if (removeHTMLTags) {
            return DVTStringUtil.replaceAll((Pattern)RfUtils.HTML_TAGS_PATTERN, (CharSequence)comment, (String)"");
        }
        return comment;
    }

    public void addArgument(RfPredefinedArg argument) {
        this.fArguments = OptimizedUtils.listContainerAdd(this.fArguments, (Object)argument);
    }

    @Override
    public List<RfArg> getArguments(ParserPath importedByTest) {
        if (this.fArguments == null) {
            return null;
        }
        return this.processArguments(OptimizedUtils.asList(this.fArguments, (boolean)false));
    }

    @Override
    public String getAssociatedFullTypeName() {
        if (this.getParentStruct() instanceof RfListType && "apply".equals(this.getName())) {
            return "list of " + super.getAssociatedTypeName();
        }
        return super.getAssociatedFullTypeName();
    }

    @Override
    public ClassEncap toClassEncap(RfProject rfProject) {
        RfStruct parentStruct;
        RfType assocType = this.getAssociatedBaseType();
        HashSet<RfType> references = new HashSet<RfType>();
        if (assocType != null) {
            references.add(assocType);
        }
        StringBuilder javaCode = new StringBuilder();
        String javaTypeName = this.javaTypeName();
        int assocTypeListDepth = this.getAssociatedTypeList();
        String name = this.getName();
        List<RfArg> arguments = this.getArguments(null);
        String methodArguments = this.javaMethodArguments(arguments, references);
        javaCode.append("public ").append(javaTypeName).append(" ").append(name).append("(").append(methodArguments).append(") {\n");
        javaCode.append("    try {\n");
        if (!javaTypeName.equals("void")) {
            javaCode.append("        ").append(javaTypeName).append(" __etools_result");
            if (assocTypeListDepth > 0) {
                javaCode.append(" = new ").append(javaTypeName).append("()");
            } else if (javaTypeName.equals("_Int")) {
                javaCode.append(" = _Int.ZERO");
            } else if (javaTypeName.equals("Double")) {
                javaCode.append(" = 0D");
            } else if (javaTypeName.equals("Boolean")) {
                javaCode.append(" = false");
            } else {
                javaCode.append(" = null");
            }
            javaCode.append(";\n");
        }
        if ((parentStruct = this.getParentStruct()) instanceof RfPredefinedStruct && "files".equals(parentStruct.getName()) && "file_exists".equals(this.getName())) {
            javaCode.append("__etools_result = new java.io.File(").append(this.javaMethodCallArguments(arguments)).append(".toString()).exists();\n");
        } else {
            javaCode.append("out(\"*** Warning: AS_COMPUTED_LIMITATION: The predefined method '").append(parentStruct.getName()).append(".").append(this.getName()).append("()' is not implemented in this DVT version\");\n");
        }
        if (!javaTypeName.equals("void")) {
            javaCode.append("        return __etools_result;\n");
        }
        javaCode.append("    } catch (Exception e) {\n");
        javaCode.append("        if (e instanceof AsComputedReturnException) {\n");
        javaCode.append("            // nothing\n");
        javaCode.append("        } else if (e instanceof RuntimeException) {\n");
        javaCode.append("            throw (RuntimeException) e;\n");
        javaCode.append("        } else {\n");
        javaCode.append("            throw new RuntimeException(e.getMessage());\n");
        javaCode.append("        }\n");
        if (!javaTypeName.equals("void")) {
            javaCode.append("        return null;\n");
        }
        javaCode.append("    }\n");
        javaCode.append("}\n\n");
        return new ClassEncap(javaCode.toString(), references, false);
    }

    @Override
    public void deepClean() {
        this.clearLayers();
    }

    @Override
    public boolean checkEquals(Object obj) {
        if (!(obj instanceof RfPredefinedMethod)) {
            return super.checkEquals(obj);
        }
        RfPredefinedMethod element = (RfPredefinedMethod)obj;
        if (this.getName() != null && !this.getName().equals(element.getName())) {
            return false;
        }
        if (this.getName() == null) {
            return false;
        }
        RfStruct parentStruct = this.getParentStruct();
        RfStruct elementParentStruct = element.getParentStruct();
        if (parentStruct != null && elementParentStruct != null && parentStruct.getName() != null && parentStruct.getName().equals(elementParentStruct.getName())) {
            return true;
        }
        return super.checkEquals(obj);
    }
}

