/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.predefined;

import java.util.Iterator;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.semantic.RfDummyField;
import ro.amiq.edt.base.model.reflection.util.RfUtils;

public class RfPredefinedScalar
extends RfScalarType {
    private String fComment;
    private boolean fIsEPredefined;

    public RfPredefinedScalar(RfProject project, String name, int bits, String comment) {
        super(project, name);
        this.setPackageName("main");
        this.fComment = comment;
        if (comment != null && comment.contains("@non_standard")) {
            this.setNonStandard(true);
        }
        this.setNofBits(bits);
    }

    public RfPredefinedScalar(RfPredefinedScalar scalarType) {
        this(scalarType.getRfProject(), scalarType.getName(), scalarType.getNofBits(), scalarType.getComment());
        this.setIsEnumType(scalarType.isEnumType());
        this.setLayersContainer(scalarType.getLayersContainer());
        RfProject rfProject = scalarType.getRfProject();
        this.setAssociatedTypeFrom(rfProject, new RfDummyField(rfProject, scalarType.getAssociatedType()));
    }

    @Override
    public int getMaxNofBits() {
        return this.getNofBits();
    }

    @Override
    public boolean isJavaNotEnum() {
        String name = this.getName();
        return NOT_ENUMS_FOR_AS_COMPUTED.contains(name);
    }

    @Override
    public boolean isSigned() {
        String name = this.getName();
        return "int".equals(name) || "longint".equals(name);
    }

    @Override
    public boolean isPredefined() {
        return true;
    }

    @Override
    public boolean isEPredefined() {
        return this.fIsEPredefined;
    }

    public void setEPredefined(boolean isEPredefined) {
        this.fIsEPredefined = isEPredefined;
    }

    @Override
    public String getComment(boolean removeHTMLTags) {
        String comment = "<i>PREDEFINED: </i>" + (this.fComment == null ? "[Description not available]" : this.fComment);
        if (removeHTMLTags) {
            return DVTStringUtil.replaceAll((Pattern)RfUtils.HTML_TAGS_PATTERN, (CharSequence)comment, (String)"");
        }
        return comment;
    }

    public void removeDirty(RfProject project, RfStruct packg, Iterator iterator) {
    }

    @Override
    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currLayer, LineInfo lineInfo, ParserPath parserPath) {
        super.performAdditionalSemanticChecks(project, currLayer, lineInfo, parserPath);
    }

    @Override
    public void deepClean() {
        try {
            this.clearLayers();
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    @Override
    public boolean checkEquals(Object obj) {
        if (!(obj instanceof RfPredefinedScalar)) {
            return super.checkEquals(obj);
        }
        RfPredefinedScalar element = (RfPredefinedScalar)obj;
        if (this.getName() != null && !this.getName().equals(element.getName())) {
            return false;
        }
        if (this.getName() == null) {
            return false;
        }
        RfScalarType parentEnumType = this.getParentEnumType();
        RfScalarType elementParentEnumType = element.getParentEnumType();
        if (parentEnumType != null && elementParentEnumType != null && parentEnumType.getName() != null && parentEnumType.getName().equals(elementParentEnumType.getName())) {
            return true;
        }
        return super.checkEquals(obj);
    }

    public static RfPredefinedScalar create(RfPredefinedScalar assocType, int width) {
        String cachedTypeName;
        RfProject rfProject = assocType.getRfProject();
        RfPredefinedScalar copyAssocType = rfProject.getCachedScalarType(cachedTypeName = assocType.isEnumType() ? null : DVTStringUtil.appendString((Object[])new Object[]{assocType.getPackageName(), ".", assocType.getName(), "__", width}));
        if (copyAssocType != null) {
            return copyAssocType;
        }
        copyAssocType = new RfPredefinedScalar(assocType);
        copyAssocType.setNofBits(width);
        rfProject.setCachedScalarType(cachedTypeName, copyAssocType);
        return copyAssocType;
    }
}

