/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.predefined;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfTemplateStruct;
import ro.amiq.edt.base.model.reflection.WrapperParam;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedEvent;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedField;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedMethod;
import ro.amiq.edt.base.model.reflection.util.RfUtils;

public class RfPredefinedStruct
extends RfTemplateStruct {
    public static final Set<String> PORT_STRUCT_NAMES = new HashSet<String>();
    private String fComment;
    private boolean fIsEPredefined;

    static {
        PORT_STRUCT_NAMES.add("any_simple_port");
        PORT_STRUCT_NAMES.add("any_event_port");
        PORT_STRUCT_NAMES.add("any_buffer_port");
        PORT_STRUCT_NAMES.add("any_method_port");
        PORT_STRUCT_NAMES.add("any_interface_port");
        PORT_STRUCT_NAMES.add("any_tlm_socket");
        PORT_STRUCT_NAMES.add("any_port");
    }

    public RfPredefinedStruct(RfProject project, String name, String packageName, boolean isUnit, String comment, List<WrapperParam> parameters) {
        super(project, name, parameters);
        this.setDefinitionData(null, packageName, isUnit, false, 16);
        this.fComment = comment;
        if (comment != null && comment.contains("@non_standard")) {
            this.setNonStandard(true);
        }
    }

    @Override
    public boolean isPredefined() {
        return true;
    }

    @Override
    public boolean isEPredefined() {
        return this.fIsEPredefined;
    }

    public void setEPredefined(boolean isEPredefined) {
        this.fIsEPredefined = isEPredefined;
    }

    @Override
    protected boolean memberOf(Determinant determinant, Determinant containedDeterminant) {
        if (PORT_STRUCT_NAMES.contains(this.getName())) {
            return true;
        }
        return RfTemplateStruct.isMemberOf(determinant, containedDeterminant);
    }

    @Override
    public int addMethodsToList(List<RfNamedElement> elements) {
        int members = 0;
        for (RfStructMember method : this.getMethods()) {
            if (method.hasNoLayers()) continue;
            ++members;
            elements.add(method);
        }
        return members;
    }

    @Override
    public int addFieldsToList(List<RfNamedElement> elements) {
        int members = 0;
        for (RfStructMember field : this.getFields()) {
            if (field.hasNoLayers()) continue;
            ++members;
            elements.add(field);
        }
        return members;
    }

    @Override
    public int addEventsToList(List<RfNamedElement> elements) {
        int members = 0;
        for (RfStructMember event : this.getEvents()) {
            if (event.hasNoLayers()) continue;
            ++members;
            elements.add(event);
        }
        return members;
    }

    @Override
    public String getComment(boolean removeHTMLTags) {
        String comment = "<i>PREDEFINED: </i>" + (this.fComment == null ? "[Description not available]" : this.fComment);
        if (removeHTMLTags) {
            return DVTStringUtil.replaceAll((Pattern)RfUtils.HTML_TAGS_PATTERN, (CharSequence)comment, (String)"");
        }
        return comment;
    }

    public void removeDirty(RfProject project, RfStruct packg, Iterator structIterator) {
        this.removeDirtyStructMembers(this.getRawMethods(), false);
        this.removeDirtyStructMembers(this.getRawFields(), false);
        this.removeDirtyStructMembers(this.getRawEvents(), false);
        this.removeDirtyStructMembers(this.getRawExpects(), false);
        this.removeDirtyStructMembers(this.getRawFieldTCs(), false);
        this.removeDirtyStructMembers(this.getRawFieldPCs(), false);
        this.removeDirtyStructMembers(this.getRawConstraints(), false);
    }

    @Override
    protected void removeDirtyStructMembers(Map<String, ListContainer<RfStructMember>> candidateMembers, boolean removeStruct) {
        if (candidateMembers == null) {
            return;
        }
        Iterator<Map.Entry<String, ListContainer<RfStructMember>>> candidatesIterator = candidateMembers.entrySet().iterator();
        while (candidatesIterator.hasNext()) {
            RfStructMember member;
            Map.Entry<String, ListContainer<RfStructMember>> membersEntries = candidatesIterator.next();
            ListContainer<RfStructMember> members = membersEntries.getValue();
            if (members instanceof List) {
                Iterator iterator = members.iterator();
                while (iterator.hasNext()) {
                    RfStructMember member2 = (RfStructMember)iterator.next();
                    if (member2 instanceof RfPredefinedEvent || member2 instanceof RfPredefinedField) continue;
                    RfEvent event = null;
                    if (member2 instanceof RfPredefinedMethod && (!member2.getName().startsWith("on_") || (event = (RfEvent)this.getLocalMember(new FullName(member2.getName().substring(3), this.getDeterminant()), 5)) instanceof RfPredefinedEvent || event != null && !event.hasNoLayers()) || !member2.hasNoLayers()) continue;
                    iterator.remove();
                    if (members.isEmpty()) {
                        candidatesIterator.remove();
                    }
                    if (members.size() != 1) continue;
                    membersEntries.setValue((ListContainer<RfStructMember>)((ListContainer)members.get(0)));
                }
                continue;
            }
            if (!(members instanceof RfStructMember) || (member = (RfStructMember)members) instanceof RfPredefinedEvent || member instanceof RfPredefinedField) continue;
            RfEvent event = null;
            if (member instanceof RfPredefinedMethod && (!member.getName().startsWith("on_") || (event = (RfEvent)this.getLocalMember(new FullName(member.getName().substring(3), this.getDeterminant()), 5)) instanceof RfPredefinedEvent || event != null && !event.hasNoLayers()) || !member.hasNoLayers()) continue;
            candidatesIterator.remove();
        }
    }

    @Override
    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currLayer, LineInfo lineInfo, ParserPath parserPath) {
        super.performAdditionalSemanticChecks(project, currLayer, lineInfo, parserPath);
    }

    @Override
    protected void addEvent(RfEvent event) {
        super.addEvent(event);
        if (event instanceof RfPredefinedEvent) {
            String methodName = "on_" + event.getName();
            RfPredefinedMethod method = new RfPredefinedMethod(this.getRfProject(), this, methodName, "", "", "", "<i>PREDEFINED: </i>[on_event-type() method] The 'on' struct member is implemented as a method, named on_event-type(). You can invoke the action block without the occurrence of the event by calling the on_event-type() method. You can extend the on_event-type() method like any other method, using is, is also, is only, or is first.");
            method.setByEvent(true);
            this.addMethod(method);
        }
    }

    @Override
    public String getSignature() {
        if ("set".equals(this.getName())) {
            return "type set";
        }
        return super.getSignature();
    }

    @Override
    public void deepClean() {
        try {
            this.clearLayers();
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    @Override
    public boolean checkEquals(Object obj) {
        if (!(obj instanceof RfPredefinedStruct)) {
            return super.checkEquals(obj);
        }
        RfPredefinedStruct element = (RfPredefinedStruct)obj;
        if (this.getName() != null && !this.getName().equals(element.getName())) {
            return false;
        }
        if (this.getName() == null) {
            return false;
        }
        RfStruct parentStruct = this.getParentStruct();
        RfStruct elementParentStruct = element.getParentStruct();
        if (parentStruct != null && elementParentStruct != null && parentStruct.getName() != null && parentStruct.getName().equals(elementParentStruct.getName())) {
            return true;
        }
        return super.checkEquals(obj);
    }
}

