/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.predefined;

import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.util.RfUtils;

public class RfPredefinedVar
extends RfVar {
    private String fComment;

    public RfPredefinedVar(RfProject project, String name, String type, String predefinedComment) {
        super(project, name, type);
        this.fComment = predefinedComment;
    }

    @Override
    public String getComment(boolean removeHTMLTags) {
        String comment = "<i>PREDEFINED: </i>" + (this.fComment == null ? "[Description not available]" : this.fComment);
        if (removeHTMLTags) {
            return DVTStringUtil.replaceAll((Pattern)RfUtils.HTML_TAGS_PATTERN, (CharSequence)comment, (String)"");
        }
        return comment;
    }

    @Override
    public void deepClean() {
        try {
            this.clearLayers();
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    @Override
    public boolean checkEquals(Object obj) {
        if (!(obj instanceof RfPredefinedVar)) {
            return super.checkEquals(obj);
        }
        RfPredefinedVar element = (RfPredefinedVar)obj;
        if (this.getName() != null && !this.getName().equals(element.getName())) {
            return false;
        }
        if (this.getName() == null) {
            return false;
        }
        IRfScopeElement parentScope = this.getEnclosingScope();
        IRfScopeElement elementParentScope = element.getEnclosingScope();
        if (parentScope != null && elementParentScope != null && parentScope.getName() != null && parentScope.getName().equals(elementParentScope.getName())) {
            return true;
        }
        return super.checkEquals(obj);
    }
}

