/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.predefined.ecode;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.edt.base.model.IEProject;

public class RfPredefinedCodeLoader {
    public static final String[] PREDEF_FILES_LIST = new String[]{"__etools__sn_defines.e", "__etools__sn_enums.e", "__etools__sn_base.e", "__etools__sn_rf.e", "__etools__sn_global.e", "__etools__sn_ports.e", "__etools__sn_main.e", "__etools__sn_tlm.e", "__etools__sn_vt.e"};
    public static final String[] SLN_PREDEF_FILE_LIST = new String[]{"__etools__sln_main.sln"};
    public static final String[] SDL_PREDEF_FILE_LIST = new String[]{"__etools__sdl_main.sdl"};

    public static final void importPredefinedFiles(IEProject eProject, StringBuilder topFileContent) {
        ArrayList<String> predefinedFiles = new ArrayList<String>();
        predefinedFiles.addAll(Arrays.asList(PREDEF_FILES_LIST));
        if (DVTUtilsCommon.INSTANCE.isInSLNMode(eProject.getNature())) {
            predefinedFiles.addAll(Arrays.asList(SLN_PREDEF_FILE_LIST));
        }
        if (DVTUtilsCommon.INSTANCE.isInSDLMode(eProject.getNature())) {
            predefinedFiles.addAll(Arrays.asList(SDL_PREDEF_FILE_LIST));
        }
        topFileContent.append("import (");
        int size = predefinedFiles.size();
        int i = 0;
        while (i < size) {
            block10: {
                String predefinedFile = (String)predefinedFiles.get(i);
                BufferedWriter predefinedFileWriter = null;
                String inputPredefinedPath = null;
                BufferedReader predefinedFileReader = null;
                try {
                    try {
                        String line;
                        IPath predefinedPath = eProject.getExtensionsPath(predefinedFile);
                        topFileContent.append(predefinedPath.lastSegment());
                        if (i < size - 1) {
                            topFileContent.append(",\n        ");
                        }
                        predefinedFileWriter = new BufferedWriter(new FileWriter(predefinedPath.toOSString()));
                        URL predefinedURL = RfPredefinedCodeLoader.class.getResource(predefinedFile);
                        inputPredefinedPath = predefinedURL.getPath();
                        predefinedFileReader = new BufferedReader(new InputStreamReader(predefinedURL.openStream()));
                        while ((line = predefinedFileReader.readLine()) != null) {
                            predefinedFileWriter.write(String.valueOf(line) + "\n");
                        }
                    }
                    catch (IOException iOException) {
                        DVTLogger.INSTANCE.logInfo("Could not load extension: " + inputPredefinedPath);
                        DVTUtilsCommon.INSTANCE.closeClosable(predefinedFileReader);
                        DVTUtilsCommon.INSTANCE.closeClosable(predefinedFileWriter);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    DVTUtilsCommon.INSTANCE.closeClosable(predefinedFileReader);
                    DVTUtilsCommon.INSTANCE.closeClosable(predefinedFileWriter);
                    throw throwable;
                }
                DVTUtilsCommon.INSTANCE.closeClosable((Closeable)predefinedFileReader);
                DVTUtilsCommon.INSTANCE.closeClosable((Closeable)predefinedFileWriter);
            }
            ++i;
        }
        topFileContent.append(");\n");
    }
}

