/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.regbitfields;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.diagrams.wavedrom.BitField;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.edt.base.model.EModuleInfo;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfFieldLayer;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.ascomputed.RfValueHolder;
import ro.amiq.edt.base.model.reflection.ascomputed.base._Int;
import ro.amiq.edt.base.model.reflection.ascomputed.base.__etools_string;
import ro.amiq.edt.base.model.reflection.regbitfields.RegBitfieldsWalker;
import ro.amiq.edt.base.utils.EASTUtils;
import ro.amiq.etools.eparser.EAST;

public enum BitfieldsUtils {
    INSTANCE;

    public static final String VR_AD_DATA_WIDTH = "VR_AD_DATA_WIDTH";
    public static final int VR_AD_DATA_WIDTH_DEFAULT = 32;
    public static final String VR_AD_REG = "vr_ad_reg";
    public static final String VR_AD_REG_KIND = "vr_ad_reg_kind";
    public static final String VR_AD = "vr_ad";
    private static final int MAX_BITFIELD_DEPTH = 10;

    public Map<String, BitField> computeBitfields(RfEnum vrAdRegKind) {
        LinkedHashMap<String, BitField> result = new LinkedHashMap<String, BitField>();
        if (vrAdRegKind == null) {
            return result;
        }
        RfProject rfProject = vrAdRegKind.getRfProject();
        if (rfProject == null) {
            return result;
        }
        RfType vrAdStruct = rfProject.getType(VR_AD, true, 1, VR_AD_REG, -1);
        if (vrAdStruct == null) {
            return result;
        }
        List<RfDefElement> vrAdLayers = vrAdStruct.getLayers();
        if (vrAdLayers == null) {
            return result;
        }
        String[] regDeterminant = new String[]{vrAdRegKind.getName(), VR_AD_REG};
        for (RfDefElement vrAdLayer : vrAdLayers) {
            Determinant layerDeterminant;
            if (!(vrAdLayer instanceof RfStructLayer) || !(layerDeterminant = ((RfStructLayer)vrAdLayer).getDeterminant()).equals(new Determinant(regDeterminant))) continue;
            int position = 0;
            for (RfDefElement memberLayer : vrAdLayer.getChildren()) {
                RfField rfField;
                if (!(memberLayer instanceof RfFieldLayer) || (rfField = (RfField)((RfFieldLayer)memberLayer).getNamedElement()) == null || !rfField.isPhysical()) continue;
                int size = this.computeSize(rfField, 10);
                result.put(rfField.getName(), BitField.BitfieldBuilder.of((int)size, (BitField.Color)BitField.Color.BLACK).name(rfField.getName()).type(rfField.getAssociatedTypeName()).position(position).build());
                position += size;
            }
            IRfFileDef fileDef = vrAdLayer.getDefFile();
            if (!(fileDef instanceof RfModule)) {
                return result;
            }
            EModuleInfo moduleInfo = rfProject.getModuleInfo(((RfModule)fileDef).getModuleReference());
            if (moduleInfo == null) {
                return result;
            }
            AST moduleAST = moduleInfo.getModuleAST();
            if (moduleAST == null) {
                return result;
            }
            AST layerAST = EASTUtils.getInstance().getLayerAST(moduleAST, vrAdLayer);
            if (layerAST == null) {
                return result;
            }
            RegBitfieldsWalker walker = new RegBitfieldsWalker(result);
            try {
                walker.extend_struct_statement((AST)((EAST)layerAST).getParent());
            }
            catch (RecognitionException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return result;
    }

    public int computeSize(RfField field, int depth) {
        if (depth > 10) {
            return 0;
        }
        RfType type = field.getAssociatedType();
        if (type == null) {
            return 0;
        }
        if (type instanceof RfEnum) {
            return ((RfEnum)type).getNofBits();
        }
        if (type instanceof RfScalarType) {
            return ((RfScalarType)type).getNofBits();
        }
        if (!(type instanceof RfStruct)) {
            return 0;
        }
        int size = 0;
        Map<String, ListContainer<RfStructMember>> members = ((RfStruct)type).getAllMembersOfType(2);
        if (members == null) {
            return 0;
        }
        for (Map.Entry<String, ListContainer<RfStructMember>> member : members.entrySet()) {
            RfField subField;
            ListContainer<RfStructMember> value = member.getValue();
            if (value.isEmpty() || !(subField = (RfField)value.get(0)).isPhysical()) continue;
            size += this.computeSize(subField, 0);
        }
        return size;
    }

    public int getRegDataWidth(RfProject rfProject) {
        _Int intResult;
        block9: {
            RfValueHolder result;
            block8: {
                block7: {
                    block6: {
                        try {
                            if (rfProject != null) break block6;
                            return 32;
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            return 0;
                        }
                    }
                    RfType vrAdStruct = rfProject.getType(VR_AD, true, 1, VR_AD_REG, -1);
                    if (vrAdStruct != null) break block7;
                    return 32;
                }
                result = rfProject.eval_exp_string(new __etools_string(VR_AD_DATA_WIDTH));
                if (result != null) break block8;
                return 32;
            }
            intResult = (_Int)result.get_value();
            if (intResult != null) break block9;
            return 32;
        }
        return intResult.intValue();
    }
}

