/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.semantic;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructMember;

public class IllegalAccessError
extends RfNamedElement {
    private RfNamedElement element;
    private RfMethodLayer isOnlyMethodLayer;

    public IllegalAccessError(RfProject project, RfNamedElement element) {
        super(project, "[private/package access error]");
        this.element = element;
    }

    public IllegalAccessError(RfProject project, RfNamedElement element, RfMethodLayer isOnlyMethodLayer) {
        super(project, "[sln label not visible due to is only method layer]");
        this.element = element;
        this.isOnlyMethodLayer = isOnlyMethodLayer;
    }

    public String getSignature() {
        return null;
    }

    public RfNamedElement getElement() {
        return this.element;
    }

    public String getAccessModifierText() {
        return this.element.isPrivate() ? "private" : (this.element.isProtected() ? "protected" : "package");
    }

    public String getElementKindText() {
        return this.element instanceof RfEvent ? "event" : (this.element instanceof RfMethod ? "method" : "field");
    }

    public String getParentName() {
        return ((RfStructMember)this.element).getParentStruct().getName();
    }

    public String getMethodName() {
        if (this.isOnlyMethodLayer == null) {
            return null;
        }
        RfMethod method = this.isOnlyMethodLayer.getMethod();
        if (method == null) {
            return null;
        }
        RfStruct parentStruct = method.getParentStruct();
        if (parentStruct == null) {
            return null;
        }
        return String.valueOf(parentStruct.getName()) + "." + method.getName();
    }

    public int getMethodLayerLine() {
        if (this.isOnlyMethodLayer == null) {
            return 0;
        }
        return this.isOnlyMethodLayer.getStartLine();
    }

    public String getMethodLayerFile() {
        if (this.isOnlyMethodLayer == null) {
            return null;
        }
        ParserPath parserPath = this.isOnlyMethodLayer.getParserPath();
        if (parserPath == null) {
            return null;
        }
        return parserPath.toString();
    }
}

