/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.semantic;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.IRfAssociatedType;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfTemplateParam;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.WrapperType;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedScalar;
import ro.amiq.edt.base.model.reflection.semantic.RfSemanticUnsafe;

public class RfDummyField
extends RfNamedElement
implements IRfAssociatedType {
    protected IRfNamedElement assocType;
    private Determinant determinant;
    private RfStruct parentStruct;
    private Constraint constraint;
    private int width = -1;
    private boolean perUnitInstance;
    private boolean isBitConcat;
    private String nameForErrorReporting;
    private int concatDepth;

    public RfDummyField(String name, RfProject project, IRfNamedElement assocType) {
        super(project, name);
        this.assocType = assocType;
    }

    public RfDummyField(RfProject project, IRfNamedElement assocType) {
        super(project, "[dummy field]");
        this.assocType = assocType;
    }

    public RfDummyField(RfProject project, IRfNamedElement assocType, Determinant determinant) {
        this(project, assocType);
        this.determinant = determinant;
    }

    public RfDummyField(RfProject project, IRfNamedElement assocType, String name) {
        this(project, assocType);
        this.nameForErrorReporting = name;
    }

    public String getNameForErrorReporting() {
        return this.nameForErrorReporting;
    }

    public String getSignature() {
        return null;
    }

    public String getAssociatedTypeName() {
        if (this.assocType == null) {
            return null;
        }
        return this.assocType.getName();
    }

    public String getSignatureTypeName() {
        return this.getAssociatedTypeName();
    }

    public IRfNamedElement getAssociatedType() {
        return this.assocType;
    }

    public IRfNamedElement getAssociatedBaseType() {
        if (this.assocType instanceof RfListType) {
            return ((RfListType)this.assocType).getAssociatedBaseType();
        }
        if (this.assocType instanceof RfPredefinedScalar && this.width > 0 && this.width != 32) {
            this.assocType = RfPredefinedScalar.create((RfPredefinedScalar)this.assocType, this.width);
        }
        return this.assocType;
    }

    public void init(IRfNamedElement assocType, Determinant determinant) {
        this.assocType = assocType;
        this.determinant = determinant;
    }

    @Override
    public String getAssociatedFullTypeName() {
        if (this.determinant != null && this.determinant.toArray() != null && this.determinant.toArray().length > 1) {
            return this.determinant.toString();
        }
        if (this instanceof RfSemanticUnsafe && this.assocType == null) {
            return null;
        }
        if (this.assocType == null) {
            return null;
        }
        return this.assocType.getName();
    }

    @Override
    public int getAssociatedTypeKind() {
        return 0;
    }

    @Override
    public int getAssociatedTypeList() {
        if (this.assocType instanceof RfListType) {
            return ((RfListType)this.assocType).getAssociatedTypeList();
        }
        return 0;
    }

    @Override
    public String getAssociatedTypeListKey() {
        if (this.assocType instanceof RfListType) {
            return ((RfListType)this.assocType).getAssociatedTypeListKey();
        }
        return null;
    }

    @Override
    public Determinant getAssociatedTypeDeterminant() {
        return this.determinant;
    }

    @Override
    public void setAssociatedType(RfModule module, WrapperType typeInfo) {
    }

    @Override
    public String javaName() {
        if (this.assocType instanceof RfType && "ntv".equals(this.assocType.getName()) && "main".equals(((RfType)this.assocType).getPackageName())) {
            return "this";
        }
        if (this.assocType instanceof RfType && "global".equals(this.assocType.getName()) && "main".equals(((RfType)this.assocType).getPackageName())) {
            return "__global";
        }
        return "DUMMY_FIELD_ERROR";
    }

    @Override
    public String javaTypeName() {
        if (this.assocType == null) {
            return "__INTERNAL_ERROR";
        }
        if (this.assocType instanceof RfTemplateParam) {
            this.assocType = ((RfTemplateParam)this.assocType).getAssociatedType();
        }
        String result = null;
        String assocTypeListKey = null;
        int assocTypeListDepth = 0;
        if (this.assocType instanceof RfListType) {
            assocTypeListDepth = ((RfListType)this.assocType).getAssociatedTypeList();
            assocTypeListKey = ((RfListType)this.assocType).getAssociatedTypeListKey();
            RfType baseAssocType = ((RfListType)this.assocType).getAssociatedBaseType();
            result = baseAssocType == null ? null : ((RfNamedElement)baseAssocType).javaName();
            int i = 0;
            while (i < assocTypeListDepth) {
                result = assocTypeListKey != null && i == 0 ? DVTStringUtil.appendString((Object[])new Object[]{"EKeyedList<", result, ">"}) : DVTStringUtil.appendString((Object[])new Object[]{"EList<", result, ">"});
                ++i;
            }
        } else {
            result = ((RfNamedElement)this.assocType).javaName();
        }
        return result;
    }

    @Override
    public String javaTypeClassName() {
        if (this.assocType == null) {
            return "__INTERNAL_ERROR";
        }
        String assocTypeListKey = null;
        if (this.assocType instanceof RfListType) {
            assocTypeListKey = ((RfListType)this.assocType).getAssociatedTypeListKey();
            if (assocTypeListKey != null) {
                return "EKeyedList.class";
            }
            return "EList.class";
        }
        return String.valueOf(((RfNamedElement)this.assocType).javaName()) + ".class";
    }

    @Override
    public boolean hasTypeFromName() {
        return false;
    }

    public void setParentStruct(RfStruct parentStruct) {
        this.parentStruct = parentStruct;
    }

    public RfStruct getParentStruct() {
        return this.parentStruct;
    }

    public void setConstraint(Constraint constraint) {
        this.constraint = constraint;
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public void setPerUnitInstance() {
        this.perUnitInstance = true;
    }

    public boolean isPerUnitInstance() {
        return this.perUnitInstance;
    }

    public RfDummyField setIsBitConcat() {
        this.isBitConcat = true;
        return this;
    }

    public boolean isBitConcat() {
        return this.isBitConcat;
    }

    public void setConcatDepth(int concatDepth) {
        this.concatDepth = concatDepth;
    }

    public int getConcatDepth() {
        return this.concatDepth;
    }

    public static class Constraint {
        RfVar itVar;
        String structQualifier;

        public Constraint(RfVar itVar, String structQualifier) {
            this.itVar = itVar;
            this.structQualifier = structQualifier;
        }
    }
}

