/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.semantic;

import java.util.Map;
import ro.amiq.dvt.model.problems.ISourceProblem;
import ro.amiq.dvt.model.problems.Severity;
import ro.amiq.dvt.utils.DVTStringUtil;

public class RfSemanticError
implements ISourceProblem {
    public static final int ERROR_TYPE = 1;
    public static final int WARNING_TYPE = 2;
    public static final String NO_PACKAGE_CALLED = "UNDEFINED_PACKAGE: No package called ''{0}''";
    public static final String NO_TYPE_CALLED_1 = "UNDEFINED_TYPE: No type called ''{1}::{0}''";
    public static final String NO_TYPE_CALLED_2 = "UNDEFINED_TYPE: No type called ''{0}''";
    public static final String NO_TEMPLATE_CALLED_1 = "UNDEFINED_TEMPLATE: No template called ''{1}::{0}''";
    public static final String NO_TEMPLATE_CALLED_2 = "UNDEFINED_TEMPLATE: No template called ''{0}''";
    public static final String UNDEFINED_FIELD = "UNDEFINED_VARIABLE: No field or local variable called ''{0}''";
    public static final String EXTEND_BEFORE_DEF = "EXTEND_BEFORE_DEFINITION: Cannot extend type ''{1}::{0}'' before declaration\n    at line {2,number,#######} in {3}";
    public static final String ACCESS_TYPE = "TYPE_ACCESS: Cannot access type ''{0}'' of package ''{1}''";
    public static final String MULTIPLE_PACKAGES = "MULTIPLE_PACKAGES: Type name ''{0}'' exists in multiple packages (''{1}'', ''{2}'', and possibly others)";
    public static final String MULTIPLE_COMPONENTS = "MULTIPLE_COMPONENTS: Type name ''{0}'' exists in multiple components (''{1}'', ''{2}'', and possibly others)";
    public static final String MULTIPLE_AGENTS = "MULTIPLE_AGENTS: Type name ''{0}'' exists in multiple agents (''{1}'', ''{2}'', and possibly others)";
    public static final String DUPLICATE_NAME = "DUPLICATE_NAME: Name ''{0}'' in package ''{1}'' was previously defined\n    at line {2,number,#######} in {3}";
    public static final String DUPLICATE_ENUM = "DUPLICATE_ENUM: Enum name ''{0}'' was previously defined\n    at line {1,number,#######} in {2}";
    public static final String DUPLICATE_COVER_ITEM = "DUPLICATE_COVER_ITEM: Cover item ''{0}'' was previously defined\n    at line {1,number,#######} in {2}";
    public static final String DUPLICATE_VARIABLE = "DUPLICATE_NAME: Name ''{0}'' already used in the current scope\n    at line {1,number,#######} in {2}";
    public static final String PREDEFINED_NAME = "PREDEFINED_NAME: Type name ''{0}'' is a reserved type name. Use a different name";
    public static final String REQUESTED_TYPE = "REQUESTED_TYPE: ''{1}::{0}'' it is not a {2} type";
    public static final String LIKE_INHERITANCE = "LIKE_INHERITANCE: Cannot derive a like-subtype of ''{0}'' (it already has when-subtypes)";
    public static final String WHEN_INHERITANCE = "WHEN_INHERITANCE: Cannot derive a when-subtype of ''{0}'' (it already has like-subtypes)";
    public static final String IS_INSTANCE = "IS_INSTANCE: Cannot declare an instance of ''{0}'' (only instance of an unit type is allowed)";
    public static final String UNDEFINED_METHOD = "UNDEFINED_METHOD: Method ''{0}.{1}()'' was not defined previously (cannot use ''is also'', ''is first'' or ''is only'')";
    public static final String UNDEFINED_CVL_METHOD = "UNDEFINED_METHOD: CVL method ''{0}.{1}()'' was not defined previously";
    public static final String REDEFINED_METHOD = "REDEFINED_METHOD: Method ''{0}.{1}()'' was previously defined (must use ''is also'', ''is first'' or ''is only'')\n    at line {2,number,#######} in {3}";
    public static final String REDEFINED_METHOD_2 = "REDEFINED_METHOD: Method ''{0}.{1}()'' was previously defined in predefined struct ''{2}'' (must use ''is also'', ''is first'' or ''is only'')";
    public static final String UNDEFINED_EVENT = "UNDEFINED_EVENT: Event ''{0}.{1}'' was not defined previously";
    public static final String REDEFINED_EVENT = "REDEFINED_EVENT: Event ''{0}.{1}'' was previously defined (must use ''is only'')\n    at line {2,number,#######} in {3}";
    public static final String UNDEFINED_COVER = "UNDEFINED_COVER: Cover group ''{0}.{1}'' was not defined previously (cannot use ''is also'')";
    public static final String UNDEFINED_EXPECT = "UNDEFINED_EXPECT: Expect ''{0}.{1}'' was not defined previously";
    public static final String REDEFINED_EXPECT = "REDEFINED_EXPECT: Expect ''{0}.{1}'' was previously defined\n    at line {2,number,#######} in {3}";
    public static final String UNDEFINED_CONSTRAINT = "UNDEFINED_CONSTRAINT: Constraint ''{0}.{1}'' was not defined previously";
    public static final String REDEFINED_CONSTRAINT = "REDEFINED_CONSTRAINT: Constraint ''{0}.{1}'' was previously defined (must use ''is only'')\n    at line {2,number,#######} in {3}";
    public static final String REDEFINED_FIELD = "REDEFINED_FIELD: Field ''{0}.{1}'' was previously defined\n    at line {2,number,#######} in {3}";
    public static final String REDEFINED_FIELD_2 = "REDEFINED_FIELD: Field ''{0}.{1}'' was previously defined in predefined struct ''{2}''";
    public static final String UNIMPLEMENTED_METHOD = "UNIMPLEMENTED_METHOD: In method port ''{0}.{1}()'' is not implemented";
    public static final String CIRCULAR_INHERITANCE = "CIRCULAR_INHERITANCE: ''{1}::{0}'' extends itself";
    public static final String MISSING_PARAMETER = "MISSING_PARAMETER: Template ''{1}::{0}'' given {2} parameters instead of {3}";
    public static final String METHOD_ACCESS = "METHOD_ACCESS: Cannot access method ''{1}.{0}()'' of package ''{2}''";
    public static final String EVENT_ACCESS = "EVENT_ACCESS: Cannot access event ''{1}.{0}'' of package ''{2}''";
    public static final String ARGUMENT_DEFAULTS_1 = "ARGUMENT_DEFAULT: Arguments following an argument with default value must also have default values";
    public static final String ARGUMENT_DEFAULTS_2 = "ARGUMENT_DEFAULT: Argument default value differs from previous declaration\n    at line {0,number,#######} in {1}";
    public static final String ARGUMENT_NUMBER = "ARGUMENT_COUNT: Argument number differs from previous declaration\n    at line {0,number,#######} in {1}";
    public static final String REDEFINED_FINAL = "REDEFINED_FINAL: Cannot declare ''{0}.{1}()'' as final, it was previously defined\n    at line {2,number,#######} in {3}";
    public static final String REDEFINED_TCM_EVENT = "REDEFINED_TCM_EVENT: Event name ''{0}'' differs from previous TCM declaration ''{1}.{2}() @ {3}''";
    public static final String EXTEND_TCM = "EXTEND_TCM: TCM ''{0}.{1}()'' cannot be extended as non-TCM, it was previously defined\n    at line {2,number,#######} in {3}";
    public static final String EXTEND_TCM_2 = "EXTEND_TCM: Predefined TCM ''{0}.{1}() @{2}'' cannot be extended as non-TCM";
    public static final String EXTEND_NON_TCM = "EXTEND_NON_TCM: Non-TCM ''{0}.{1}()'' cannot be extended as TCM, it was previously defined\n    at line {2,number,#######} in {3}";
    public static final String EXTEND_NON_TCM_2 = "EXTEND_NON_TCM: Predefined non-TCM ''{0}.{1}()'' cannot be extended as TCM";
    public static final String EXTEND_FINAL = "EXTEND_FINAL: Cannot extend ''{0}.{1}()'', it was previously defined final\n    at line {2,number,#######} in {3}";
    public static final String NON_STANDARD_TYPE = "NON_STANDARD_TYPE: ''{1}::{0}''";
    public static final String NON_STANDARD_METHOD = "NON_STANDARD_METHOD: ''{0}.{1}()''";
    public static final String NON_STANDARD_MACRO = "NON_STANDARD_MACRO: ''{0}''";
    public static final String UNRESOLVED_BIND_ARG = "UNRESOLVED_BIND_ARG: Argument {0} of ''{1}()'' cannot be resolved";
    public static final String BAD_BIND_ARG_COUNT = "BIND_ARG_COUNT: Wrong number of arguments for ''{0}()'', must be exactly 2";
    public static final String BIND_ARG_IS_NOT_PORT = "BIND_ARG_PORT_TYPE: Argument {0} of ''{1}()'' method must be a port";
    public static final String BIND_ARGS_PORT_TYPES = "BIND_ARGS_PORT_KIND: Different kinds of ports cannot be bound to each other";
    public static final String BIND_ARGS_PORT_OF = "BIND_ARGS_PORT_ELEM: Ports with associated element types that do not agree cannot be bound";
    public static final String UNDEFINED_COVER_ITEM = "UNDEFINED_COVER_ITEM: Cover item ''{0}'' is not defined";
    public static final String UNDEFINED_IDENTIFIER = "UNDEFINED_IDENTIFIER: Identifier ''{0}'' is not defined";
    public static final String UNDEFINED_IDENTIFIER_2 = "UNDEFINED_IDENTIFIER: Identifier ''{0}'' is not a member of ''{1}''";
    public static final String UNDEFINED_IDENTIFIER_ENUM = "UNDEFINED_IDENTIFIER: Identifier ''{0}'' is not a value of enumerated type ''{1}''";
    public static final String UNDEFINED_METHOD_1 = "UNDEFINED_METHOD: Method ''{0}'' is not defined";
    public static final String UNDEFINED_METHOD_2 = "UNDEFINED_METHOD: Method ''{0}'' is not a member of ''{1}''";
    public static final String UNEXPECTED_ATTRIBUTE_NAME = "UNEXPECTED_ATTRIBUTE_NAME: Unexpected attibute name ''{0}'', must be one of ''deep_copy'', ''deep_compare'', ''deep_compare_physical'' or ''deep_all''";
    public static final String UNEXPECTED_ATTRIBUTE_VALUE = "UNEXPECTED_ATTRIBUTE_VALUE: Unexpected attibute value ''{0}'', must be one of ''normal'', ''reference'' or ''ignore''";
    public static final String UNRESOLVED_IDENTIFIER = "UNRESOLVED_IDENTIFIER: Cannot resolve identifier ''{0}'' (unresolved preceding expression)";
    public static final String UNRESOLVED_METHOD = "UNRESOLVED_METHOD: Cannot resolve method ''{0}'' (unresolved preceding expression)";
    public static final String METHOD_RETURN_TYPE = "UNRESOLVED_RETURN_TYPE: Cannot resolve ''{0}'' method return type (unresolved argument expression)";
    public static final String INVALID_TLM_METHOD_CALL = "INVALID_TLM_METHOD_CALL: Method ''{0}'' should be called using the port access operator ''{1}$.{0}(...)''";
    public static final String INVALID_SELECT_CONSTRAINT = "INVALID_SELECT_CONSTRAINT: Select constraint must be defined as ''soft''";
    public static final String SELECT_IN_NON_LIST = "SELECT_IN_NON_LIST: Cannot use select, element ''{0}'' is not a list";
    public static final String AS_COMPUTED_LIMITATION = "AS_COMPUTED_LIMITATION: List pseudo-method ''{0}'' not implemented in this DVT version";
    public static final String AS_COMPUTED_LIMITATION_2 = "AS_COMPUTED_LIMITATION: Actions in expansion literal not supported in this DVT version";
    public static final String AS_COMPUTED_METHOD_CALL = "AS_COMPUTED_METHOD_CALL: Add +dvt_e_as_computed_translate_method+{0} to default build (required by 'as computed' macro execution)";
    public static final String ILLEGAL_ACCESS = "ILLEGAL_ACCESS: Cannot access {0} {1} ''{2}.{3}''";
    public static final String ILLEGAL_ACCESS_SAP = "ILLEGAL_ACCESS: Cannot access sub-action path ''{0}'' due to method ''{1}()'' ''is only'' restriction \n    at line {2,number,#######} in {3}";
    public static final String RESERVED_NAME = "RESERVED_NAME: ''{0}'' is a reserved name, cannot be used as a when qualifier name";
    public static final String MISSING_ENUM_NAME = "MISSING_ENUM_NAME: ''{0}'' is not a value of enum type ''{1}''";
    public static final String NOT_A_SUBTYPE = "NOT_A_SUBTYPE: ''{0}'' is not a subtype of ''{1}''";
    public static final String WRONG_FIELD_TYPE = "WRONG_FIELD_TYPE: Field ''{0}'' cannot be a when qualifier, it is neither an enum nor a boolean";
    public static final String AMBIGUOUS_QUALIFIER = "AMBIGUOUS_QUALIFIER: ''{0}'' when qualifier for struct ''{1}'' is ambiguous, use full qualifier (e.g. ''{2}'' or ''{3}'')";
    public static final String CONFLICTING_QUALIFIER = "CONFLICTING_QUALIFIER: ''{0}'' and ''{1}'' when qualifiers for ''{2}'' are conflicting and may not be used together";
    public static final String REDUNDANT_QUALIFIER = "REDUNDANT_QUALIFIER: ''{0}'' when qualifier for ''{1}'' is redundant";
    public static final String DEBUG_SEMANTIC = "DEBUG: [SEMANTIC] Unresolved identifier ''{0}''";
    public static final String EVALUATE_MACRO = "EVALUATE_MACRO: Fail to evaluate ''as computed'' macro <{0}''{1}>";
    public static final String METHOD_CALL_ARGUMENTS = "METHOD_CALL_ARGUMENTS: Expecting ''{1}'' argument{1,choice,0#s|1#|1<s} when calling ''{0}'', found ''{2}''";
    public static final String METHOD_CALL_ARGUMENTS_1 = "METHOD_CALL_ARGUMENTS: Expecting minimum ''{1}'' argument{1,choice,0#s|1#|1<s} when calling ''{0}'', found ''{2}''";
    public static final String METHOD_CALL_ARGUMENTS_2 = "METHOD_CALL_ARGUMENTS: Expecting maximum ''{1}'' argument{1,choice,0#s|1#|1<s} when calling ''{0}'', found ''{2}''";
    public static final String UNEXPECTED_TYPE_1 = "UNEXPECTED_TYPE: ''{0}'' is of type ''{1}'', while expecting numeric type";
    public static final String UNEXPECTED_TYPE_2 = "UNEXPECTED_TYPE: ''{0}'' is of type ''{1}'', while expecting type ''{2}''";
    public static final String UNEXPECTED_TYPE_3 = "UNEXPECTED_TYPE: ''{0}'' is of type ''{1}'', while expecting some type";
    public static final String UNEXPECTED_TYPE_4 = "UNEXPECTED_TYPE: ''{0}'' is of type ''{1}'', while expecting type ''{2}'' or ''{3}''";
    public static final String AMBIGUOUS_ACTION_PATH = "AMBIGUOUS_ACTION_PATH: ''{0}'' is an ambiguous sub-action path, more than 1 action with the same label\n    at line {1,number,#######} in {2}\n    at line {3,number,#######} in {4}";
    public static final String NOT_A_STRUCT = "NOT_A_STRUCT: ''{0}'' is not a struct";
    public static final String NOT_A_PORT = "NOT_A_PORT: ''{0}'' is not a port";
    public static final String NOT_AN_ENUM_TYPE = "NOT_AN_ENUM_TYPE: ''{0}'' is not an enum type";
    public static final String NOT_IMPLEMENTED_METHOD = "NOT_IMPLEMENTED_METHOD: Struct ''{0}'' does not implement ''{1}'' method declared in ''{2}'' implemented interface";
    public static final String CUSTOM_PRAGMA_NESTING_EXCEEDED = "CUSTOM_PRAGMA_NESTING_EXCEEDED: More than 3 nested custom pragmas found";
    public static final String CUSTOM_PRAGMA_UNEXPECTED_END = "CUSTOM_PRAGMA_UNEXPECTED_END: No ''{0}'' start found";
    public static final String CUSTOM_PRAGMA_MISMATCH = "CUSTOM_PRAGMA_MISMATCH: Expecting ''{0}'' found ''{1}''";
    public static final String CUSTOM_PRAGMA_NO_END = "CUSTOM_PRAGMA_NO_END: No matching ''{0}'' end pragma found";
    public static final String SDL_INLINE_BLOCK_PARSE_ERROR = "UNRECOGNIZED_INLINE_CONSTRUCT: {0}";
    public static final String SDL_NO_AGENT_CALLED = "UNDEFINED_AGENT: No agent called ''{0}''";
    public static final String SDL_NO_POSITIONAL_PARAM = "UNRESOLVED_POSITIONAL_PARAM: Positional param {0} of ''{1}'' scenario invocation cannot be resolved";
    public static final String SDL_NOT_ALLOWED_POSITIONAL_PARAM = "NOT_ALLOWED_POSITIONAL_PARAM: Not allowed positional param {0} of ''{1}'' scenario invocation";
    public static final String SDL_INLINE_BLOCK_PARSE_ERROR_ATTRIBUTE = "SDL_UNRECOGNIZED_INLINE_CONSTRUCT";
    private String fMessage;
    private int fLine;
    private int fSeveriy;
    private String fResourcePath;
    private boolean fObsolete;
    private transient Severity fSeverityAfterWaive;
    private int fOffsetStart;
    private int fOffsetEnd;
    private Map<String, Object> fAttributes;
    private int fFileIndex;

    public RfSemanticError(int messageType, String message, int line, String parserPath, int fileIndex) {
        this.fMessage = message;
        this.fLine = line;
        this.fSeveriy = messageType;
        this.fResourcePath = DVTStringUtil.intern((String)parserPath);
        this.fFileIndex = fileIndex;
    }

    public int getLineNumber() {
        return this.fLine;
    }

    public String getMessage() {
        if (this.fFileIndex <= 0) {
            return DVTStringUtil.appendString((Object[])new Object[]{"_", this.fMessage});
        }
        return this.fMessage;
    }

    public int getSeverity() {
        return this.fSeveriy;
    }

    public String getResourcePath() {
        return this.fResourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.fResourcePath = resourcePath;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.fAttributes = attributes;
    }

    public Map<String, Object> getAttributes() {
        return this.fAttributes;
    }

    public boolean hasAttribute(String name) {
        return this.fAttributes == null ? false : this.fAttributes.get(name) != null;
    }

    public void setOffsetStart(int offsetStart) {
        this.fOffsetStart = offsetStart;
    }

    public void setOffsetEnd(int offsetEnd) {
        this.fOffsetEnd = offsetEnd;
    }

    public int getOffsetStart() {
        return this.fOffsetStart;
    }

    public int getOffsetEnd() {
        return this.fOffsetEnd;
    }

    public int hashCode() {
        return (String.valueOf(this.fSeveriy) + "@" + this.fMessage + "@" + this.fLine + "@" + this.fResourcePath).hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RfSemanticError)) {
            return false;
        }
        RfSemanticError other = (RfSemanticError)obj;
        return this.fMessage != null && this.fMessage.equals(other.fMessage) && this.fLine == other.fLine && this.fSeveriy == other.fSeveriy && this.fResourcePath != null && this.fResourcePath.equals(other.fResourcePath);
    }

    public boolean isObsolete() {
        return this.fObsolete;
    }

    public void setObsolete(boolean obsolete) {
        this.fObsolete = obsolete;
    }

    public Severity getSeverityAfterWaive() {
        return this.fSeverityAfterWaive;
    }

    public void setSeverityAfterWaive(Severity severity) {
        this.fSeverityAfterWaive = severity;
    }
}

