/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.semantic;

import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;

public class RfStructQualifier
extends RfNamedElement {
    private RfEnum enumItem;
    private RfField field;

    public RfStructQualifier(RfProject project, RfEnum enumItem, RfField field) {
        super(project, "[dummy wrapper]");
        this.enumItem = enumItem;
        this.field = field;
    }

    @Override
    public void deepClean() {
        try {
            this.enumItem = null;
            this.field = null;
            super.deepClean();
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    public String getSignature() {
        return null;
    }

    public RfEnum getEnum() {
        return this.enumItem;
    }

    public RfField getElement() {
        return this.field;
    }

    @Override
    public String toString() {
        return DVTStringUtil.appendString((Object[])new Object[]{this.enumItem.getName(), "'", this.field.getName()});
    }

    public String getFieldAssocTypeName() {
        return this.field.getAssociatedTypeName();
    }

    @Override
    public boolean checkEquals(Object obj) {
        if (obj instanceof RfField) {
            return this.field.checkEquals(obj);
        }
        if (obj instanceof RfEnum) {
            return this.enumItem.checkEquals(obj);
        }
        return false;
    }

    public String javaCondition() {
        return String.valueOf(this.field.javaName()) + " == " + this.enumItem.javaName();
    }
}

