/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.semantic;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.IRfAssociatedType;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.semantic.RfDummyField;

public class RfUndefVariable
extends RfDummyField {
    private IRfNamedElement parentScope;

    private RfUndefVariable(RfProject project, String name) {
        super(project, (IRfNamedElement)null);
        this.setName(name);
    }

    @Override
    public String getSignature() {
        String type;
        String string = type = this.assocType instanceof IRfAssociatedType ? ((IRfAssociatedType)this.assocType).getAssociatedTypeName() : "[UNKNOWN]";
        if (this.parentScope instanceof IRfAssociatedType) {
            String parentScopeAssocFullTypeName = ((IRfAssociatedType)this.parentScope).getAssociatedFullTypeName();
            return "undeclared field " + parentScopeAssocFullTypeName + "." + this.getName() + " : " + type;
        }
        return "undeclared variable " + this.getName() + " : " + type;
    }

    public RfUndefVariable parent(IRfNamedElement parentScope) {
        this.parentScope = parentScope;
        return this;
    }

    public RfUndefVariable type(IRfNamedElement assocType) {
        if (assocType instanceof RfUndefVariable) {
            return this;
        }
        this.assocType = assocType;
        return this;
    }

    public static RfUndefVariable create(RfProject rfp, String name) {
        return new RfUndefVariable(rfp, name);
    }

    public Determinant getParentScopeDeterminant() {
        if (this.parentScope instanceof IRfAssociatedType) {
            return ((IRfAssociatedType)this.parentScope).getAssociatedTypeDeterminant();
        }
        return this.getAssociatedTypeDeterminant();
    }

    public List<RfDefElement> getParentScopeLayers() {
        if (this.parentScope == null || !(this.parentScope instanceof RfNamedElement)) {
            return null;
        }
        if (this.parentScope instanceof IRfAssociatedType) {
            IRfNamedElement parentAssocType = ((IRfAssociatedType)this.parentScope).getAssociatedType();
            if (!(parentAssocType instanceof RfNamedElement)) {
                return null;
            }
            return ((RfNamedElement)parentAssocType).getLayers();
        }
        return ((RfNamedElement)this.parentScope).getLayers();
    }

    @Override
    public boolean checkEquals(Object obj) {
        if (obj instanceof IRfNamedElement) {
            return this.getName().equals(((IRfNamedElement)obj).getName());
        }
        return false;
    }

    public boolean isInCurrentScope() {
        return this.parentScope == null;
    }
}

