/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.semantic;

import antlr.RecognitionException;
import antlr.TreeParser;
import antlr.collections.AST;
import antlr.collections.impl.ASTArray;
import antlr.collections.impl.BitSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.edt.base.model.EModuleInfo;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.IRfAssociatedType;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.IRfTemplateParam;
import ro.amiq.edt.base.model.reflection.InnerInclude;
import ro.amiq.edt.base.model.reflection.RfActionBlockLayer;
import ro.amiq.edt.base.model.reflection.RfAnnotationType;
import ro.amiq.edt.base.model.reflection.RfArg;
import ro.amiq.edt.base.model.reflection.RfArgLayer;
import ro.amiq.edt.base.model.reflection.RfCoverItem;
import ro.amiq.edt.base.model.reflection.RfCoverLayer;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfFieldPropConstraint;
import ro.amiq.edt.base.model.reflection.RfFieldTypeConstraint;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfMethodType;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfTemplateStruct;
import ro.amiq.edt.base.model.reflection.RfTemplateStructInstance;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.RfVarLayer;
import ro.amiq.edt.base.model.reflection.TypesWalker;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedArg;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedMethod;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedStruct;
import ro.amiq.edt.base.model.reflection.semantic.IllegalAccessError;
import ro.amiq.edt.base.model.reflection.semantic.RfDummyField;
import ro.amiq.edt.base.model.reflection.semantic.RfDummyMethod;
import ro.amiq.edt.base.model.reflection.semantic.RfSemanticUnsafe;
import ro.amiq.edt.base.model.reflection.semantic.RfStructQualifier;
import ro.amiq.edt.base.model.reflection.semantic.RfSubtypeElement;
import ro.amiq.edt.base.model.reflection.semantic.RfUndefVariable;
import ro.amiq.edt.base.model.reflection.semantic.SemanticUtils;
import ro.amiq.edt.base.model.reflection.semantic.SemanticWalkerTokenTypes;
import ro.amiq.edt.base.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.etools.eparser.EAST;
import ro.amiq.etools.eparser.EASTFactory;

public class SemanticWalker
extends TreeParser
implements SemanticWalkerTokenTypes {
    private static final EnumSet<IRfNamedElement.ElementKind> FIELD = EnumSet.of(IRfNamedElement.ElementKind.E_FIELD);
    private static final EnumSet<IRfNamedElement.ElementKind> EVENT = EnumSet.of(IRfNamedElement.ElementKind.E_EVENT);
    private static final EnumSet<IRfNamedElement.ElementKind> METHOD = EnumSet.of(IRfNamedElement.ElementKind.E_METHOD);
    private static final EnumSet<IRfNamedElement.ElementKind> FIELD_VARIABLE = EnumSet.of(IRfNamedElement.ElementKind.E_FIELD, IRfNamedElement.ElementKind.E_VARIABLE);
    private static final Set<String> LIMITATIONS = new HashSet<String>();
    private Set<String> GLOBAL_PSEUDOMETHODS;
    private static final Set<String> PSEUDO_LIST_METHODS_DECLARING_IT = RfMethod.PSEUDO_LIST_METHODS_DECLARING_IT;
    private static final Set<String> PORT_STRUCT_NAMES = RfPredefinedStruct.PORT_STRUCT_NAMES;
    public static final RfNamedElement ERROR_SCOPE = new RfDummyField("ERROR_SCOPE", null, null);
    private static final Set<String> BIND_ARG_CONSTANTS = new HashSet<String>(Arrays.asList("empty", "external", "undefined"));
    private static final Set<String> TLM_METHODS = new HashSet<String>(Arrays.asList("put", "get", "peek", "try_put", "can_put", "ok_to_put", "try_get", "can_get", "ok_to_get", "try_peek", "can_peek", "ok_to_peek", "transport", "nb_transport", "write"));
    private RfProject rfp;
    private ParserPath parserPath;
    private int clusterIndex;
    private int moduleIndex;
    private int maxModuleIndex;
    private int invocationIndex;
    private String packageName;
    private String preSLNComponentPackageName;
    private int macroDepth;
    private LineInfo macroLineInfo;
    private int virtualOffsetBase;
    private RfNamedElement excludeVar;
    private RfModule module;
    private ParserPath importedByTest;
    private boolean disableChecks;
    private boolean incremental;
    private RfType REAL_TYPE;
    private RfType UINT_TYPE;
    private RfType INT_TYPE;
    private RfType BOOL_TYPE;
    private RfType BIT_TYPE;
    private RfType BYTE_TYPE;
    private RfType TIME_TYPE;
    private RfType SET_TYPE;
    private RfType STRING_TYPE;
    private RfType GLOBAL_TYPE;
    private RfType PRIMITIVE_DESC;
    private RfType STRUCT_DESC;
    private RfType ENUM_DESC;
    private RfType LINT_RULE_ID;
    private RfType ABS_TOKEN;
    private RfDummyField ELEM_OF_BOOL_TYPE;
    private Stack<RfDefElement> lastScopeLayerStack = new Stack();
    private Stack<RfDummyField.Constraint> lastConstraintStack = new Stack();
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "PROGRAM", "LOAD_UNIT", "MODULE", "ENCRYPTED_MODULE", "STATEMENT_BLOCK", "PREPROC_DEF_STATEMENT", "PREPROC_UNDEF_STATEMENT", "PREPROC_IFDEF_STATEMENT", "PREPROC_IFNDEF_STATEMENT", "DEFINE_AS_STATEMENT", "DEFINE_AS_COMPUTED_STATEMENT", "DEFINE_NAME", "DEFINE_BEFORE", "USER_DEFINED_STATEMENT", "AS_COMPUTED_USER_DEFINED_STATEMENT", "PACKAGE_STATEMENT", "PORT_ATTR_STATEMENT", "REGULAR_IMPORT_STATEMENT", "CYCLIC_IMPORT_STATEMENT", "VERILOG_IMPORT_STATEMENT", "E_FILE", "V_FILE", "ANNOTATION_STATEMENT", "TYPE_STATEMENT", "STRUCT_STATEMENT", "UNIT_STATEMENT", "INTERFACE_STATEMENT", "INTERFACE_TEMPLATE_STATEMENT", "LIKE", "IMPLEMENTING", "EXTEND_TYPE_STATEMENT", "ENUM_ITEM_LIST", "ENUM_ITEM", "EXTEND_STRUCT_STATEMENT", "EXTEND_TEMPLATE_STATEMENT", "EXTEND_STRUCT_TYPE", "STRUCT_QUALIFIER", "SEQUENCE_STATEMENT", "SEQUENCE_TEMPLATE_STATEMENT", "C_ROUTINE_STATEMENT", "C_EXPORT_STATEMENT", "METHOD_TYPE_STATEMENT", "VERILOG_TIME_STATEMENT", "VHDL_TIME_STATEMENT", "VHDL_OBJECT", "NUMERIC_TYPE_TEMPLATE_STATEMENT", "METHOD_EXPORT_STATEMENT", "STRUCT_MEMBER_BLOCK", "INTERFACE_MEMBER_BLOCK", "PREPROC_IFDEF_STRUCT_MEMBER", "PREPROC_IFNDEF_STRUCT_MEMBER", "USER_DEFINED_STRUCT_MEMBER", "AS_COMPUTED_USER_DEFINED_STRUCT_MEMBER", "WHEN_STRUCT_MEMBER", "WHEN_TYPE", "FIELD_STRUCT_MEMBER", "FIELD_TYPE", "SIZED_LIST_TYPE", "METHOD_STRUCT_MEMBER", "C_METHOD_STRUCT_MEMBER", "CVL_METHOD_STRUCT_MEMBER", "CONSTRAINT_STRUCT_MEMBER", "COVERAGE_STRUCT_MEMBER", "COVER_ITEM_LIST", "COVER_ITEM", "COVER_CROSS", "COVER_TRANSITION", "CROSS_ITEM_LIST", "ATTRIBUTE_STRUCT_MEMBER", "EVENT_STRUCT_MEMBER", "ON_EVENT_STRUCT_MEMBER", "SET_EXPECT_STRUCT_MEMBER", "ANONYMOUS_EXPECT_STRUCT_MEMBER", "NAMED_EXPECT_STRUCT_MEMBER", "SET_ASSUME_STRUCT_MEMBER", "ANONYMOUS_ASSUME_STRUCT_MEMBER", "NAMED_ASSUME_STRUCT_MEMBER", "METHOD_INTERFACE_MEMBER", "SIMULATOR_SPECIFIER", "VERILOG", "VHDL", "VERILOG_CODE", "VERILOG_FUNCTION", "VERILOG_FUNCTION_PARAMETER_LIST", "VERILOG_FUNCTION_PARAMETER", "VERILOG_TASK", "VERILOG_TASK_PARAMETER_LIST", "VERILOG_TASK_PARAMETER", "IN", "OUT", "INOUT", "VERILOG_VARIABLE", "VHDL_CODE", "VHDL_FUNCTION", "VHDL_DRIVER", "VHDL_PROCEDURE", "ACTION_BLOCK", "PREPROC_IFDEF_ACTION", "PREPROC_IFNDEF_ACTION", "USER_DEFINED_ACTION", "AS_COMPUTED_USER_DEFINED_ACTION", "COMPUTE_ACTION", "RETURN_ACTION", "REPORT_ACTION", "VAR_ACTION", "TYPE_FROM_NAME", "TYPE_SPECIFIED", "TYPE_FROM_EXPR", "ASSIGN_ACTION", "DELAYED_ASSIGN_ACTION", "PLUS_ASSIGN_ACTION", "MINUS_ASSIGN_ACTION", "MUL_ASSIGN_ACTION", "DIV_ASSIGN_ACTION", "MOD_ASSIGN_ACTION", "SHL_ASSIGN_ACTION", "SHR_ASSIGN_ACTION", "AND_ASSIGN_ACTION", "XOR_ASSIGN_ACTION", "OR_ASSIGN_ACTION", "LAND_ASSIGN_ACTION", "LOR_ASSIGN_ACTION", "TRY_ACTION", "GEN_ACTION", "DO_SEQ_ACTION", "SUBTYPE_EXPR", "PRINT_ACTION", "MESSAGE_ACTION", "MESSAGEF_ACTION", "ERROR_ACTION", "DUT_ERROR_ACTION", "DUT_ERRORF_ACTION", "CHECK_ACTION", "CHECK_NAME", "ASSERT_ACTION", "ASSERT_NAME", "METHOD_CALL_ACTION", "START_ACTION", "TASK_CALL_ACTION", "IF_ACTION", "CASE_ACTION", "CASE_BRANCH_LIST", "CASE_BRANCH", "WHILE_ACTION", "REPEAT_ACTION", "FOR_FROM_ACTION", "TO_INTERVAL", "DOWN_TO_INTERVAL", "FOR_ACTION", "FOR_INIT", "FOR_TEST", "FOR_STEP", "FOR_EACH_ACTION", "ITEM_NAME", "ITEM_TYPE", "INDEX_NAME", "PREV_NAME", "STRAIGHT", "REVERSE", "FOR_EACH_FILE_ACTION", "FOR_EACH_FILE_NAME", "FOR_EACH_LINE_ACTION", "FOR_EACH_LINE_NAME", "BREAK_ACTION", "CONTINUE_ACTION", "FORCE_ACTION", "RELEASE_ACTION", "EMIT_ACTION", "ALL_OF_ACTION", "FIRST_OF_ACTION", "WAIT_ACTION", "SYNC_ACTION", "STATE_MACHINE_ACTION", "FINAL_STATE", "STATE_TRANSITION_LIST", "STATE_TRANSITION", "STATE_ACTION", "DEFAULT_VALUE", "EXPANSION_LITERAL_ACTION", "USER_DEFINED_EXPRESSION", "AS_COMPUTED_USER_DEFINED_EXPRESSION", "PREPROC_IFDEF_EXPRESSION", "PREPROC_IFNDEF_EXPRESSION", "EXPR_LIST", "CONDITIONAL_OP", "IN_TABLE", "IN_TABLE_ROWS", "IMPLY", "LOR", "LAND", "XOR", "OR", "AND", "IS_NOT_IN", "IS_IN", "NOT_MATCH", "MATCH", "NOT_HDL_EQUAL", "HDL_EQUAL", "NOT_EQUAL", "EQUAL", "GTE", "GT", "LTE", "LT", "SHL", "SHR", "PLUS", "MINUS", "MUL", "DIV", "MOD", "UNARY_PLUS", "UNARY_MINUS", "LNOT", "NOT", "IS_NOT_EMPTY_EXPR", "IS_EMPTY_EXPR", "PAREN_EXPR", "FIELD_ACCESS_EXPR", "STATIC_FIELD_ACCESS_EXPR", "IT_FIELD_ACCESS_EXPR", "PORT_ACCESS_EXPR", "METHOD_INVOCATION_EXPR", "IN_SEQUENCE_EXPR", "IN_UNIT_EXPR", "TYPE_EXPR", "READ_ONLY_EXPR", "VALUE_EXPR", "DEEP_COPY_EXPR", "GET_ENCLOSING_UNIT_EXPR", "TRY_ENCLOSING_UNIT_EXPR", "AS_A_EXPR", "IS_ATTR_SET_EXPR", "METHOD_ACCESS_EXPR", "STATIC_METHOD_ACCESS_EXPR", "IT_METHOD_ACCESS_EXPR", "METHOD_PORT_INVOCATION_EXPR", "HDL_METHOD_INVOCATION_EXPR", "LIST_INDEX_EXPR", "LIST_RANGE_EXPR", "LIST_CONCAT_EXPR", "BIT_SLICE_EXPR", "BIT_SLICE", "BIT_SLICE_LEFT_BOUND", "BIT_SLICE_RIGHT_BOUND", "BIT_SLICE_TYPE", "BIT_CONCAT_EXPR", "RANGE_EXPR", "RANGE", "RANGE_LEFT_BOUND", "RANGE_RIGHT_BOUND", "NEW_EXPR", "NEW_TYPE", "NEW_NAME", "NOW_EXPR", "EVALUATE_EXPR", "IS_NOT_A_EXPR", "IS_A_EXPR", "ALL_VALUES_EXPR", "SET_OF_VALUES_EXPR", "GET_ALL_UNITS_EXPR", "BIND_EXPR", "FOR_EACH_EXPR", "GEN_BEFORE_EXPR", "SELECT_EXPR", "SELECTION_LIST", "SELECTION", "SELECT_MIN", "SELECT_MAX", "SELECT_PASS", "SELECT_EDGES", "SELECT_OTHERS", "SOFT_EXPR", "ALL_OF_EXPR", "TIME_FS", "TIME_PS", "TIME_NS", "TIME_US", "TIME_MS", "TIME_SEC", "TIME_MIN", "TIME_HR", "MATCH_TERM_EXPR", "FROM_EXPR", "TO", "DOWN_TO", "STEP", "EACH_LINE_IN_FILE_EXPR", "ID", "STRING_LITERAL", "NUMERIC_LITERAL", "CHAR_LITERAL", "HDL_LITERAL", "TEXT_EXPANSION_LITERAL", "TRUE", "FALSE", "NULL", "UNDEF", "MAX_INT", "MIN_INT", "MAX_UINT", "MAX_LONGINT", "MIN_LONGINT", "MAX_LONGUINT", "STRENGTH_NONE", "STRENGTH_HIZ", "STRENGTH_SMALLCHARGE", "STRENGTH_MEDIUMCHARGE", "STRENGTH_LARGECHARGE", "STRENGTH_WEAKDRIVE", "STRENGTH_PULLDRIVE", "STRENGTH_STRONGDRIVE", "STRENGTH_SUPPLYDRIVE", "DEPRECATED_TICK_ID", "FIRST_THEN_EXPR", "EACH_STARTING_FROM", "TYPE_IS_EXPR", "TYPE_LIST_DIM_EXPR", "TYPE_BIT_SIZE_EXPR", "USER_DEFINED_TYPE", "AS_COMPUTED_USER_DEFINED_TYPE", "WIDTH_MODIFIER", "RANGE_MODIFIER", "BITS", "BYTES", "INFINITE", "INTERFACE_PORT", "SIMPLE_PORT", "BUFFER_PORT", "METHOD_PORT", "EVENT_PORT", "CALL_PORT", "TLM_SOCKET_PORT", "LIST_TYPE", "LIST_KEY", "PORT_ATTR_TYPE", "CYCLE_TEXPR", "EVENT_TEXPR", "TRUE_TEXPR", "RISE_TEXPR", "FALL_TEXPR", "CHANGE_TEXPR", "SAMPLE_TEXPR", "IMPLY_TEXPR", "AND_TEXPR", "OR_TEXPR", "FIRST_MATCH_TEXPR", "TRUE_MATCH_TEXPR", "SEQUENCE_TEXPR", "DETACH_TEXPR", "NOT_TEXPR", "EVENTUALLY_TEXPR", "FAIL_TEXPR", "EXEC_TEXPR", "DELAY_TEXPR", "CONSUME_TEXPR", "PACKAGE", "PRIVATE", "PROTECTED", "REPLACEMENT", "BACKTICK_ID", "NOT_PARSED", "REPLACEMENT_TERM_LIST", "REPLACEMENT_TERM", "AS_COMPUTED_REPLACEMENT_TERM", "PATTERN", "IS_EMPTY", "IS_UNDEFINED", "IS_INLINE", "IS_INLINE_ONLY", "IS_FIRST", "IS_ALSO", "IS_ONLY", "IS", "ANONYMOUS_REF_TYPE", "RESULT_TYPE", "PARAMETER_LIST", "PARAMETER", "BY_REF", "USING", "USING_ALSO", "OPTION_EXPR", "OPTION_TYPE", "OPTION_RANGE_LIST", "OPTION_RANGE", "USER_DEFINED_BLOCK", "AS_COMPUTED_USER_DEFINED_BLOCK", "USER_DEFINED_NUM", "AS_COMPUTED_USER_DEFINED_NUM", "USER_DEFINED_FILE", "AS_COMPUTED_USER_DEFINED_FILE", "USER_DEFINED_CONSTRAINT", "AS_COMPUTED_USER_DEFINED_CONSTRAINT", "USER_DEFINED_SOMETHING", "AS_COMPUTED_USER_DEFINED_SOMETHING", "USER_DEFINED_TABLE_ROWS", "USER_DEFINED_SLN_SCD", "E_CLOSE", "USER_DEFINED_COVER_ITEM", "AS_COMPUTED_USER_DEFINED_COVER_ITEM", "COVER_INSTANCE", "DYNAMIC_C_ROUTINE", "FOREIGN", "C_LIBRARY", "QUALIFIED_TYPE", "TEMPLATE_PARAM_TYPE", "TEMPLATE_PARAM_EXPR", "TEMPLATE_INSTANCE", "STRUCT_TEMPLATE_STATEMENT", "UNIT_TEMPLATE_STATEMENT", "UVM_ML_TYPE_MATCH", "TYPE_FIELD_CONSTRAINT_EXPR", "TYPE_PROPERTY_CONSTRAINT_EXPR", "TYPE_TYPEOF", "PREPROC_IFDEF_COVER_ITEM", "PREPROC_IFNDEF_COVER_ITEM", "PREPROC_IFDEF_TEMPORAL_EXPRESSION", "PREPROC_IFNDEF_TEMPORAL_EXPRESSION", "PREPROC_IFDEF_CASE_BRANCH", "PREPROC_IFNDEF_CASE_BRANCH", "PREPROC_IFDEF_SLN_SCD", "PREPROC_IFNDEF_SLN_SCD", "SLN_PREPROC_TRACE_TABLE_STATEMENT", "SLN_ABSTRACT", "SLN_MACRO", "SLN_CONST_STATEMENT", "SLN_TOKEN", "SLN_TOKEN_DEFAULT_VALUE", "SLN_COMPONENT", "SLN_COMPONENT_MEMBER_BLOCK", "SLN_ACTION", "SLN_ACTION_MEMBER_BLOCK", "SLN_EXEC_CODE", "SLN_EXEC_FILE", "SLN_EXEC_METHOD", "SLN_ACTION_BLOCK", "SLN_COMPOUND", "SLN_SCD_LIST", "SLN_SCD_INSTANTIATE_SUB_ACTION", "SLN_SCD_INSTANTIATE_OPERAND", "SLN_SCD_LABELED_SUB_ACTION_OPERAND", "SLN_SCD_SCHEDULE_BEFORE", "SLN_SCD_SCHEDULE_SAME_TIME", "SLN_SCD_BIND", "SLN_SCD_REFINE", "SLN_SCD_CONSTRAINT", "SLN_SCD_CONSTRAINT_BLOCK", "SLN_SCD_SET_ATTRIBUTE", "SLN_SCD_CODE", "SLN_SCD_SUB_ACTION_ARGS", "SLN_CHILD", "SLN_TOKEN_FIELD", "SLN_BIND", "SLN_CONSTRAINT", "SLN_CONSTRAINT_DEFAULT", "SLN_CONSTRAINT_DEFAULT_DISABLE", "SLN_CONSTRAINT_NAMED", "SLN_FIELD_INITIAL_CONSTRAINTS", "SLN_FIELD_KEEPING_CONSTRAINTS", "SLN_EQUAL_DOT_STAR", "SLN_TABLE_DEFINE", "SLN_ITERATOR_INDEX_VAR", "SDL_ROLE", "SDL_AGENT", "SDL_SCENARIO", "SDL_DO", "SDL_LABEL", "SDL_LABEL_FRAGMENT", "SDL_PATH_EXPR", "SDL_SCENARIO_INVOCATION", "SDL_SCENARIO_INVOCATION_ARGUMENTS", "SDL_BY_NAME_ARGUMENT", "SDL_IN_ARGUMENT_EXPR", "SDL_SCENARIO_INVOCATION_BLOCK", "SDL_CODE_SCENARIO_INVOCATION", "SDL_EMIT_SCENARIO_INVOCATION", "SDL_WAIT_SCENARIO_INVOCATION", "SDL_IN", "SDL_IN_ANY", "SDL_MIX", "SDL_SAME", "SDL_FIELD_MEMBER_BLOCK", "SDL_FIELD_MEMBER_CONSTRAINT", "SDL_FIELD_CONSTRAINT", "SDL_FIELD_SAMPLE_VALUE", "SDL_FIELD_SAMPLE_EVENT", "SDL_FIELD_SAMPLE_WHERE", "SLN_FUNCTION_STATEMENT", "SDL_COVER_EXPR", "SDL_COVER_CROSS", "SDL_COVER_FROM", "SDL_RANGE_UNITS", "SDL_DEFAULT_EXPR", "SDL_INLINE_STRUCT_MEMBER", "SDL_INLINE_TEXT", "SDL_INLINE_ELSE_TEXT", "SDL_INLINE_BLOCK", "SDL_TOOL_DEFINE_STATEMENT", "SDL_TOOL_DIRECT_EXECUTION_STATEMENT", "SDL_TOOL_EDITOR_PRIORITIZE_ACTION", "SDL_TOOL_EDITOR_AVOID_ACTION", "SDL_DOLLAR_TABLE_EXPR", "SDL_GET_SUB_SCENARIOS_OF_TYPE", "SDL_ANY_TYPE", "SDL_WHEN_EXPR"};
    public static final BitSet _tokenSet_0 = new BitSet(SemanticWalker.mk_tokenSet_0());
    public static final BitSet _tokenSet_1 = new BitSet(SemanticWalker.mk_tokenSet_1());
    public static final BitSet _tokenSet_2 = new BitSet(SemanticWalker.mk_tokenSet_2());
    public static final BitSet _tokenSet_3 = new BitSet(SemanticWalker.mk_tokenSet_3());
    public static final BitSet _tokenSet_4 = new BitSet(SemanticWalker.mk_tokenSet_4());
    public static final BitSet _tokenSet_5 = new BitSet(SemanticWalker.mk_tokenSet_5());
    public static final BitSet _tokenSet_6 = new BitSet(SemanticWalker.mk_tokenSet_6());
    public static final BitSet _tokenSet_7 = new BitSet(SemanticWalker.mk_tokenSet_7());
    public static final BitSet _tokenSet_8 = new BitSet(SemanticWalker.mk_tokenSet_8());
    public static final BitSet _tokenSet_9 = new BitSet(SemanticWalker.mk_tokenSet_9());
    public static final BitSet _tokenSet_10 = new BitSet(SemanticWalker.mk_tokenSet_10());
    public static final BitSet _tokenSet_11 = new BitSet(SemanticWalker.mk_tokenSet_11());
    public static final BitSet _tokenSet_12 = new BitSet(SemanticWalker.mk_tokenSet_12());
    public static final BitSet _tokenSet_13 = new BitSet(SemanticWalker.mk_tokenSet_13());
    public static final BitSet _tokenSet_14 = new BitSet(SemanticWalker.mk_tokenSet_14());
    public static final BitSet _tokenSet_15 = new BitSet(SemanticWalker.mk_tokenSet_15());
    public static final BitSet _tokenSet_16 = new BitSet(SemanticWalker.mk_tokenSet_16());
    public static final BitSet _tokenSet_17 = new BitSet(SemanticWalker.mk_tokenSet_17());
    public static final BitSet _tokenSet_18 = new BitSet(SemanticWalker.mk_tokenSet_18());
    public static final BitSet _tokenSet_19 = new BitSet(SemanticWalker.mk_tokenSet_19());
    public static final BitSet _tokenSet_20 = new BitSet(SemanticWalker.mk_tokenSet_20());

    public void reportError(RecognitionException ex) {
    }

    public SemanticWalker(RfProject rfp, EModuleInfo info, RfModule module, boolean incremental) {
        this.rfp = rfp;
        this.clusterIndex = info.getClusterIndex();
        this.moduleIndex = info.getModuleIndex();
        this.maxModuleIndex = info.getMaxModuleIndex();
        this.parserPath = info.getParserPath();
        this.invocationIndex = info.getInvocationIndex();
        this.importedByTest = info.getImportedByTest();
        this.macroDepth = 0;
        this.module = module;
        this.preSLNComponentPackageName = this.packageName = module.getPackageName();
        this.incremental = incremental;
        this.GLOBAL_PSEUDOMETHODS = rfp.getGlobalPseudomethods();
        this.REAL_TYPE = rfp.getTypesUtil().REAL_TYPE();
        this.UINT_TYPE = rfp.getTypesUtil().UINT_TYPE();
        this.INT_TYPE = rfp.getTypesUtil().INT_TYPE();
        this.BOOL_TYPE = rfp.getTypesUtil().BOOL_TYPE();
        this.BIT_TYPE = rfp.getTypesUtil().BIT_TYPE();
        this.BYTE_TYPE = rfp.getTypesUtil().BYTE_TYPE();
        this.TIME_TYPE = rfp.getTypesUtil().TIME_TYPE();
        this.SET_TYPE = rfp.getTypesUtil().SET_TYPE();
        this.STRING_TYPE = rfp.getTypesUtil().STRING_TYPE();
        this.GLOBAL_TYPE = rfp.getTypesUtil().GLOBAL_TYPE();
        this.PRIMITIVE_DESC = rfp.getTypesUtil().PRIMITIVE_DESC();
        this.STRUCT_DESC = rfp.getTypesUtil().STRUCT_DESC();
        this.ENUM_DESC = rfp.getTypesUtil().ENUM_DESC();
        this.LINT_RULE_ID = rfp.getTypesUtil().LINT_RULE_ID();
        this.ABS_TOKEN = rfp.getTypesUtil().ABS_TOKEN();
        this.ELEM_OF_BOOL_TYPE = new RfDummyField(rfp, this.BOOL_TYPE);
    }

    public final void setMaxModuleIndex() {
        this.moduleIndex = Integer.MAX_VALUE;
        this.maxModuleIndex = Integer.MAX_VALUE;
    }

    private final void setTransientResult(AST node, RfWNamedElementAndScope elementAndScope) {
        this.setTransientResult(node, elementAndScope, false);
    }

    private final void setTransientResult(AST node, RfWNamedElementAndScope elementAndScope, boolean forceOverride) {
        if (node == null || elementAndScope == null) {
            return;
        }
        RfNamedElement namedElement = elementAndScope.getNamedElement();
        if (namedElement instanceof IllegalAccessError) {
            namedElement = ((IllegalAccessError)namedElement).getElement();
        }
        if (namedElement == null || namedElement == ERROR_SCOPE) {
            return;
        }
        if (forceOverride || ((EAST)node).transientResult == null) {
            ((EAST)node).transientResult = namedElement;
        }
        if (forceOverride || ((EAST)node).transientScope == null) {
            ((EAST)node).transientScope = elementAndScope.getScope();
        }
    }

    private final void setTransientResult(AST node, RfNamedElement result) {
        if (result instanceof IllegalAccessError) {
            result = ((IllegalAccessError)result).getElement();
        }
        SemanticUtils.setTransientResult(node, result);
    }

    private final <T extends RfNamedElement> T getTransientResult(Class<T> clazz, AST node) {
        T result = SemanticUtils.getTransientResult(clazz, node);
        if (result == null || result == TypesWalker.UNRESOLVED_TYPE) {
            return null;
        }
        return result;
    }

    private final void setTransientScope(AST node, IRfScope result) {
        SemanticUtils.setTransientScope(node, result);
    }

    private final <T extends RfDefElement> T getTransientScope(Class<T> clazz, AST node) {
        return (T)((RfDefElement)SemanticUtils.getTransientScope(clazz, node));
    }

    private final String append(Object ... s) {
        return DVTStringUtil.appendString((Object[])s);
    }

    public final void userExceptionHandler(Exception ex) throws RecognitionException {
        if (ex instanceof RecognitionException) {
            throw (RecognitionException)((Object)ex);
        }
        if (ex instanceof BuildCancelException) {
            throw (RuntimeException)ex;
        }
        DVTLogger.INSTANCE.logError((Throwable)ex);
    }

    private final boolean pushScopeLayer(AST node) {
        RfDefElement result = this.getTransientScope(RfDefElement.class, node);
        if (result == null) {
            return false;
        }
        this.lastScopeLayerStack.push(result);
        return true;
    }

    private final boolean pushScopeLayer(RfDefElement def) {
        if (def == null) {
            return false;
        }
        this.lastScopeLayerStack.push(def);
        return true;
    }

    private final boolean popScopeLayer() {
        if (this.lastScopeLayerStack.isEmpty()) {
            return false;
        }
        this.lastScopeLayerStack.pop();
        return true;
    }

    private final boolean pushConstraint(RfNamedElement constraintHolder) {
        RfDummyField.Constraint constraint;
        if (constraintHolder instanceof RfDummyField && (constraint = ((RfDummyField)constraintHolder).getConstraint()) != null) {
            this.lastConstraintStack.push(constraint);
        }
        return true;
    }

    public final RfNamedElement peekConstraint(RfProject project, RfNamedElement itVarCandidate) {
        if (this.lastConstraintStack.isEmpty()) {
            return itVarCandidate;
        }
        RfDummyField.Constraint lastConstraint = this.lastConstraintStack.peek();
        if (lastConstraint.itVar == itVarCandidate) {
            Determinant assocDeterminant = ((IRfAssociatedType)((Object)itVarCandidate)).getAssociatedTypeDeterminant();
            Determinant determinant = new Determinant(new String[]{lastConstraint.structQualifier}, assocDeterminant.toArray());
            return new RfDummyField(project, ((IRfAssociatedType)((Object)itVarCandidate)).getAssociatedType(), determinant);
        }
        return itVarCandidate;
    }

    private final boolean isInCompoundBlock() {
        if (this.lastScopeLayerStack.isEmpty()) {
            return false;
        }
        int i = this.getLastScopeLayerStackSize() - 1;
        while (i >= 0) {
            RfDefElement tmp = (RfDefElement)this.lastScopeLayerStack.get(i);
            if (tmp instanceof RfActionBlockLayer && ((RfActionBlockLayer)tmp).getActionKind() == RfActionBlockLayer.ActionKind.COMPOUND_ACTION) {
                return true;
            }
            --i;
        }
        return false;
    }

    private final RfStructLayer getSDLAgentEnclosingLayer() {
        int i = this.getLastScopeLayerStackSize() - 1;
        while (i >= 0) {
            RfDefElement defElement = (RfDefElement)this.lastScopeLayerStack.get(i);
            if (defElement instanceof RfStructLayer && ((RfStructLayer)defElement).getStruct() != null && ((RfStructLayer)defElement).getStruct().isSDLAgent()) {
                return (RfStructLayer)defElement;
            }
            --i;
        }
        return null;
    }

    private final RfStruct getStruct() {
        if (this.lastScopeLayerStack.isEmpty()) {
            return null;
        }
        int i = this.getLastScopeLayerStackSize() - 1;
        while (i >= 0) {
            RfDefElement candidate = (RfDefElement)this.lastScopeLayerStack.get(i);
            if (candidate instanceof RfStructLayer) {
                return ((RfStructLayer)candidate).getStruct();
            }
            --i;
        }
        return null;
    }

    private final void cleanAllScopes() {
        this.lastScopeLayerStack.clear();
    }

    private final void cleanAllScopes(int restoreToSize) {
        while (restoreToSize < this.getLastScopeLayerStackSize()) {
            this.lastScopeLayerStack.pop();
        }
    }

    private final int getLastScopeLayerStackSize() {
        if (this.lastScopeLayerStack == null || this.lastScopeLayerStack.isEmpty()) {
            return 0;
        }
        return this.lastScopeLayerStack.size();
    }

    private final RfDefElement getLastScopeLayerStackElement() {
        if (this.lastScopeLayerStack == null || this.lastScopeLayerStack.isEmpty()) {
            return null;
        }
        return this.lastScopeLayerStack.peek();
    }

    private final void cleanAllConstraints(int restoreToSize) {
        while (restoreToSize < this.lastConstraintStack.size()) {
            this.lastConstraintStack.pop();
        }
    }

    private final RfWNamedElementAndScope resolveIdentifier(AST id, EnumSet<IRfNamedElement.ElementKind> allowedElements, boolean createDependency) {
        RfDefElement declaration;
        if (id == null) {
            return null;
        }
        if (this.disableChecks) {
            return new RfWNamedElementAndScope(ERROR_SCOPE, this.GLOBAL_TYPE, true);
        }
        String idText = id.getText();
        int errPrefixLength = "DVT_EXP_EVALUATE_FAIL_".length();
        if (idText.length() > errPrefixLength && idText.startsWith("DVT_EXP_EVALUATE_FAIL_")) {
            String asComputedName = idText.substring(errPrefixLength);
            LineInfo lineInfo = this.getMacroSafeLine(id);
            this.rfp.addSemanticError2(1, "EVALUATE_MACRO: Fail to evaluate ''as computed'' macro <{0}''{1}>", -1, -1, null, lineInfo.line, this.parserPath, asComputedName, "exp");
            return new RfWNamedElementAndScope(ERROR_SCOPE, this.GLOBAL_TYPE, true);
        }
        RfNamedElement result = null;
        IRfScope scope = null;
        if (allowedElements.contains(IRfNamedElement.ElementKind.E_FIELD) && "global".equals(idText)) {
            scope = this.GLOBAL_TYPE;
            result = new RfDummyField(this.rfp, (IRfNamedElement)scope, new Determinant(new String[]{"global"}));
            return new RfWNamedElementAndScope(result, scope, true);
        }
        if (this.lastScopeLayerStack != null && !this.lastScopeLayerStack.isEmpty()) {
            LineInfo lineInfo = this.getMacroSafeLine(id);
            RfStruct global = (RfStruct)this.GLOBAL_TYPE;
            if (this.GLOBAL_PSEUDOMETHODS.contains(idText) && allowedElements.contains(IRfNamedElement.ElementKind.E_METHOD)) {
                result = global.getMethod(idText);
            }
            if (result instanceof RfPredefinedMethod && result.getEnclosingScope() == this.GLOBAL_TYPE) {
                scope = this.GLOBAL_TYPE;
            } else {
                RfStructLayer agentScope;
                scope = (IRfScope)((Object)this.getLastScopeLayerStackElement());
                result = ((RfDefElement)((Object)scope)).semanticGetMember(this.rfp, this.packageName, idText, allowedElements, lineInfo, this.maxModuleIndex, this.parserPath, this.excludeVar);
                if (this.rfp.isInSDLMode() && result == null && (agentScope = this.getSDLAgentEnclosingLayer()) != null) {
                    result = agentScope.semanticGetMember(this.rfp, this.packageName, idText, allowedElements, lineInfo, this.maxModuleIndex, this.parserPath, this.excludeVar);
                }
            }
            if (createDependency) {
                this.module.createVariableDependency(this.rfp, result, idText);
            }
        } else {
            RfStruct global = (RfStruct)this.GLOBAL_TYPE;
            result = global.semanticGetMember(this.rfp, new Determinant(new String[]{"global"}), this.packageName, null, idText, allowedElements, 31, this.maxModuleIndex, this.parserPath, this.excludeVar);
            scope = this.GLOBAL_TYPE;
            if (createDependency) {
                this.module.createVariableDependency(this.rfp, result, idText);
            }
        }
        if (this.incremental && result != null && !result.isPredefined() && (declaration = result.getDeclaration()) != null && declaration.getMaxModuleIndex() > this.maxModuleIndex) {
            return null;
        }
        return result == null ? null : new RfWNamedElementAndScope(result, scope, true);
    }

    private final RfWNamedElementAndScope resolvePotentialEnum(AST id1, RfWNamedElementAndScope resultId1, RfNamedElement resultId2, boolean inList) {
        List<IRfAssociatedType> typeParams;
        if (id1 == null) {
            return resultId1;
        }
        IRfNamedElement assocType = null;
        if (resultId2 instanceof IRfAssociatedType && (assocType = ((IRfAssociatedType)((Object)resultId2)).getAssociatedType()) instanceof IRfTemplateParam) {
            return resultId1;
        }
        if (resultId2 instanceof IRfAssociatedType && (assocType = ((IRfAssociatedType)((Object)resultId2)).getAssociatedType()) instanceof RfListType) {
            resultId2 = (RfListType)assocType;
        }
        if (resultId2 instanceof IRfAssociatedType && (assocType = ((IRfAssociatedType)((Object)resultId2)).getAssociatedType()) instanceof RfTemplateStructInstance && PORT_STRUCT_NAMES.contains(assocType.getName()) && (typeParams = ((RfTemplateStructInstance)assocType).getParameters()) != null && typeParams.size() > 0) {
            IRfAssociatedType typeParam = ((RfTemplateStructInstance)assocType).getParameters().get(0);
            resultId2 = new RfDummyField(this.rfp, typeParam.getAssociatedType(), typeParam.getAssociatedTypeDeterminant());
        }
        if (resultId2 instanceof IRfAssociatedType && (assocType = ((IRfAssociatedType)((Object)resultId2)).getAssociatedType()) instanceof RfScalarType) {
            RfNamedElement tmpResultId1;
            while (assocType instanceof RfScalarType && !((RfScalarType)assocType).isEnumType()) {
                assocType = ((RfScalarType)assocType).getAssociatedType();
            }
            if (assocType instanceof RfScalarType && ((RfScalarType)assocType).isEnumType() && (tmpResultId1 = ((RfScalarType)assocType).semanticGetMember(this.rfp, null, this.packageName, this.getStruct(), id1.getText(), FIELD, 31, this.maxModuleIndex, this.parserPath, null)) != null) {
                resultId1 = new RfWNamedElementAndScope(tmpResultId1, (RfType)assocType, true);
            }
        }
        return resultId1;
    }

    private final LineInfo getLineInfo(AST node) {
        return SemanticUtils.getLineInfo(node);
    }

    public final void inMacro(AST node) {
        if (this.macroDepth == 0) {
            this.macroLineInfo = this.getLineInfo(node);
            this.virtualOffsetBase = node.getOffset();
        } else {
            this.virtualOffsetBase += node.getOffset();
        }
        ++this.macroDepth;
    }

    public final void outMacro(AST node) {
        --this.macroDepth;
        this.virtualOffsetBase = this.macroDepth == 0 ? 0 : (this.virtualOffsetBase -= node.getOffset());
    }

    private final LineInfo getMacroSafeLine(AST node) {
        if (this.macroDepth == 0) {
            return this.getLineInfo(node);
        }
        return new LineInfo(this.macroLineInfo.line, this.macroLineInfo.realOffset, node == null ? 1 : this.virtualOffsetBase + node.getOffset());
    }

    private final LineInfo getMacroSafeLine(LineInfo lineInfo) {
        if (this.macroDepth == 0) {
            return lineInfo;
        }
        return new LineInfo(this.macroLineInfo.line, this.macroLineInfo.realOffset, lineInfo == null ? 1 : this.virtualOffsetBase + lineInfo.realOffset);
    }

    private final LineInfo metaToLineInfo(String meta) {
        if (meta != null) {
            try {
                int index = meta.indexOf(58);
                int line = Integer.parseInt(meta.substring(0, index));
                int offset = Integer.parseInt(meta.substring(index + 1));
                return new LineInfo(line, offset, -1);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return new LineInfo(-1, -1, -1);
    }

    private final RfNamedElement getNamedElement(RfWNamedElementAndScope elementAndScope) {
        return elementAndScope == null ? null : elementAndScope.getNamedElement();
    }

    public final void range_element(AST _t) throws RecognitionException {
        this.range_element(_t, null);
    }

    public final void expr_list(AST _t) throws RecognitionException {
        this.expr_list(_t, null, null, null);
    }

    public final RfNamedElement expr(AST _t) throws RecognitionException {
        return this.expr(_t, null);
    }

    public final void using_list(AST _t) throws RecognitionException {
        this.using_list(_t, ERROR_SCOPE, null, null);
    }

    public final void action_block(AST _t) throws RecognitionException {
        this.action_block(_t, null);
    }

    private final LineInfo getTreeLineInfo(AST node) {
        return SemanticUtils.getTreeLineInfo(node, this.macroDepth, this.macroLineInfo);
    }

    private final boolean isConstraintScope() {
        int i = this.getLastScopeLayerStackSize() - 1;
        while (i >= 0) {
            RfDefElement defElement = (RfDefElement)this.lastScopeLayerStack.get(i);
            if (!(defElement instanceof RfActionBlockLayer)) {
                return defElement instanceof RfStructLayer;
            }
            --i;
        }
        return false;
    }

    private final boolean isPortAssocType(RfType assocType) {
        return SemanticUtils.isPortAssocType(assocType);
    }

    private final String getAssocTypeName(IRfNamedElement assocType, Determinant assocDeterminant) {
        if (assocType instanceof RfListType) {
            return assocType.getName();
        }
        if (assocDeterminant != null && assocDeterminant.toArray() != null && assocDeterminant.toArray().length > 0) {
            return assocDeterminant.toString();
        }
        return assocType.getName();
    }

    private final void specialMethodReturnType(RfProject project, RfDummyField lhScope, AST exp2, RfNamedElement result) {
        if (result != null && this.valid(result)) {
            RfType assocType = (RfType)((IRfAssociatedType)((Object)result)).getAssociatedType();
            if (assocType != null) {
                Determinant assocDeterminant = ((IRfAssociatedType)((Object)result)).getAssociatedTypeDeterminant();
                assocType = (RfType)((IRfAssociatedType)((Object)result)).getAssociatedBaseType();
                String assocListKey = ((IRfAssociatedType)((Object)result)).getAssociatedTypeListKey();
                int assocListDepth = ((IRfAssociatedType)((Object)result)).getAssociatedTypeList();
                assocListDepth = assocListDepth == 0 ? 1 : assocListDepth;
                assocType = RfListType.listFromType(project, assocType, assocDeterminant, assocListKey, assocListDepth);
                lhScope.init(assocType, assocDeterminant);
            } else {
                LineInfo lineInfo = this.getTreeLineInfo(exp2);
                project.addSemanticError2(1, "UNRESOLVED_RETURN_TYPE: Cannot resolve ''{0}'' method return type (unresolved argument expression)", lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, this.parserPath, lhScope.getName());
            }
        }
    }

    private final void checkDeprecatedTickIdSubtype(List<AST> ids, RfStruct struct) {
        Determinant determinant = new Determinant(new String[]{struct.getName()});
        int i = ids.size() - 2;
        while (i >= 0) {
            block12: {
                AST id;
                block13: {
                    LineInfo lineInfo;
                    ArrayList<RfStructQualifier> qualifiers;
                    block10: {
                        block11: {
                            id = ids.get(i);
                            qualifiers = new ArrayList<RfStructQualifier>();
                            if (i > 0) {
                                lineInfo = this.getMacroSafeLine(ids.get(i - 1));
                                struct.getStructQualifierCandidates(this.rfp, qualifiers, this.packageName, ids.get(i - 1).getText(), id.getText(), determinant, 31, this.moduleIndex, lineInfo, this.parserPath);
                            }
                            if (qualifiers.size() != 1) break block10;
                            if (((RfStructQualifier)qualifiers.get(0)).getEnum() == null) break block11;
                            this.setTransientResult(id, ((RfStructQualifier)qualifiers.get(0)).getElement());
                            this.setTransientResult(ids.get(i - 1), ((RfStructQualifier)qualifiers.get(0)).getEnum());
                            determinant = new Determinant(new String[]{String.valueOf(ids.get(i - 1).getText()) + "'" + id.getText()}, determinant.toArray());
                            --i;
                            break block12;
                        }
                        qualifiers.clear();
                        lineInfo = this.getMacroSafeLine(id);
                        struct.getStructQualifierCandidates(this.rfp, qualifiers, this.packageName, null, id.getText(), determinant, 31, this.moduleIndex, lineInfo, this.parserPath);
                        if (qualifiers.size() == 1 && ((RfStructQualifier)qualifiers.get(0)).getEnum() != null) {
                            this.setTransientResult(id, (RfNamedElement)qualifiers.get(0));
                        } else if (qualifiers.size() > 1) {
                            this.rfp.addSemanticError2(1, "AMBIGUOUS_QUALIFIER: ''{0}'' when qualifier for struct ''{1}'' is ambiguous, use full qualifier (e.g. ''{2}'' or ''{3}'')", lineInfo.getOffset(), lineInfo.getOffset() + id.getText().length(), null, lineInfo.line, this.parserPath, id.getText(), struct.getName(), ((RfStructQualifier)qualifiers.get(0)).toString(), ((RfStructQualifier)qualifiers.get(1)).toString());
                        } else {
                            this.rfp.addSemanticError2(1, "NOT_A_SUBTYPE: ''{0}'' is not a subtype of ''{1}''", lineInfo.getOffset(), lineInfo.getOffset() + id.getText().length(), null, lineInfo.line, this.parserPath, id.getText(), struct.getName());
                        }
                        break block13;
                    }
                    qualifiers.clear();
                    lineInfo = this.getMacroSafeLine(id);
                    struct.getStructQualifierCandidates(this.rfp, qualifiers, this.packageName, null, id.getText(), determinant, 31, this.moduleIndex, lineInfo, this.parserPath);
                    if (qualifiers.size() == 1 && ((RfStructQualifier)qualifiers.get(0)).getEnum() != null) {
                        this.setTransientResult(id, (RfNamedElement)qualifiers.get(0));
                    } else if (qualifiers.size() > 1) {
                        this.rfp.addSemanticError2(1, "AMBIGUOUS_QUALIFIER: ''{0}'' when qualifier for struct ''{1}'' is ambiguous, use full qualifier (e.g. ''{2}'' or ''{3}'')", lineInfo.getOffset(), lineInfo.getOffset() + id.getText().length(), null, lineInfo.line, this.parserPath, id.getText(), struct.getName(), ((RfStructQualifier)qualifiers.get(0)).toString(), ((RfStructQualifier)qualifiers.get(1)).toString());
                    } else {
                        this.rfp.addSemanticError2(1, "NOT_A_SUBTYPE: ''{0}'' is not a subtype of ''{1}''", lineInfo.getOffset(), lineInfo.getOffset() + id.getText().length(), null, lineInfo.line, this.parserPath, id.getText(), struct.getName());
                    }
                }
                determinant = new Determinant(new String[]{id.getText()}, determinant.toArray());
            }
            --i;
        }
    }

    private final boolean valid(IRfNamedElement element) {
        return element != null && element != ERROR_SCOPE && !(element instanceof RfUndefVariable) && element instanceof IRfAssociatedType && ((IRfAssociatedType)element).getAssociatedBaseType() != this.rfp.getSpecman().getVoidType();
    }

    private final RfNamedElement undefVarOrNull(RfNamedElement element) {
        if (element instanceof RfUndefVariable) {
            return element;
        }
        return null;
    }

    public final RfNamedElement method_invocation(AST _t) throws RecognitionException {
        return this.method_invocation(_t, null);
    }

    public final void preproc_ifdef_expr(AST _t) throws RecognitionException {
        this.preproc_ifdef_expr(_t, null);
    }

    public final void preproc_ifndef_expr(AST _t) throws RecognitionException {
        this.preproc_ifndef_expr(_t, null);
    }

    public SemanticWalker() {
        this.tokenNames = _tokenNames;
    }

    public final String define_name(AST _t) throws RecognitionException {
        String result;
        block15: {
            Runnable finalRunnable;
            block14: {
                result = null;
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST id1 = null;
                AST id2 = null;
                try {
                    try {
                        AST __t2 = _t;
                        this.match(_t, 15);
                        _t = _t.getFirstChild();
                        id1 = _t == ASTNULL ? null : _t;
                        this.identifier(_t);
                        _t = this._retTree;
                        id2 = _t == ASTNULL ? null : _t;
                        this.identifier(_t);
                        _t = this._retTree;
                        _t = __t2;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block14;
                        try {
                            if (id1 != null && id2 != null) {
                                result = String.valueOf(id1.getText()) + "'" + id2.getText();
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final void identifier(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    this.match(_t, 293);
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void user_defined_statement(AST _t) throws RecognitionException {
        block19: {
            Runnable finalRunnable;
            block18: {
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST ud = null;
                try {
                    try {
                        AST __t4 = _t;
                        ud = _t == ASTNULL ? null : _t;
                        this.match(_t, 17);
                        _t = _t.getFirstChild();
                        this.define_name(_t);
                        _t = this._retTree;
                        this.replacement_term_list(_t);
                        _t = this._retTree;
                        if (this.inputState.guessing() == 0) {
                            try {
                                if (ud != null) {
                                    this.inMacro(ud);
                                }
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        this.statement_block(_t);
                        _t = this._retTree;
                        _t = __t4;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block18;
                        try {
                            if (ud != null) {
                                this.outMacro(ud);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void replacement_term_list(AST _t) throws RecognitionException {
        block14: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t887 = _t;
                    this.match(_t, 367);
                    _t = _t.getFirstChild();
                    while (true) {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (_t.getType() != 368) break;
                        this.replacement_term(_t);
                        _t = this._retTree;
                    }
                    _t = __t887;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void statement_block(AST _t) throws RecognitionException {
        block14: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t860 = _t;
                    this.match(_t, 8);
                    _t = _t.getFirstChild();
                    while (true) {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (!_tokenSet_0.member(_t.getType())) break;
                        this.statement(_t);
                        _t = this._retTree;
                    }
                    _t = __t860;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void user_defined_struct_member(AST _t) throws RecognitionException {
        block19: {
            Runnable finalRunnable;
            block18: {
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST ud = null;
                try {
                    try {
                        AST __t6 = _t;
                        ud = _t == ASTNULL ? null : _t;
                        this.match(_t, 55);
                        _t = _t.getFirstChild();
                        this.define_name(_t);
                        _t = this._retTree;
                        this.replacement_term_list(_t);
                        _t = this._retTree;
                        if (this.inputState.guessing() == 0) {
                            try {
                                if (ud != null) {
                                    this.inMacro(ud);
                                }
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        this.struct_member_block(_t);
                        _t = this._retTree;
                        _t = __t6;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block18;
                        try {
                            if (ud != null) {
                                this.outMacro(ud);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void struct_member_block(AST _t) throws RecognitionException {
        block14: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t973 = _t;
                    this.match(_t, 51);
                    _t = _t.getFirstChild();
                    while (true) {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (!_tokenSet_1.member(_t.getType())) break;
                        this.struct_member(_t);
                        _t = this._retTree;
                    }
                    _t = __t973;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void user_defined_action(AST _t) throws RecognitionException {
        block24: {
            Runnable finalRunnable;
            block23: {
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST ud = null;
                try {
                    try {
                        AST __t8 = _t;
                        ud = _t == ASTNULL ? null : _t;
                        this.match(_t, 103);
                        _t = _t.getFirstChild();
                        this.define_name(_t);
                        _t = this._retTree;
                        this.replacement_term_list(_t);
                        _t = this._retTree;
                        if (this.inputState.guessing() == 0) {
                            try {
                                if (ud != null) {
                                    this.inMacro(ud);
                                }
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 100: {
                                this.action_block(_t);
                                _t = this._retTree;
                                break;
                            }
                            case 108: {
                                this.var_action(_t);
                                _t = this._retTree;
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        _t = __t8;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block23;
                        try {
                            if (ud != null) {
                                this.outMacro(ud);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void action_block(AST _t, InnerInclude innerInclude) throws RecognitionException {
        block19: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST ab = null;
            final int stackScopeSize = this.getLastScopeLayerStackSize();
            if (this.inputState.guessing() == 0) {
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.cleanAllScopes(stackScopeSize);
                    }
                };
            }
            try {
                try {
                    AST __t163 = _t;
                    ab = _t == ASTNULL ? null : _t;
                    this.match(_t, 100);
                    _t = _t.getFirstChild();
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.pushScopeLayer(ab);
                            if (ab != null && innerInclude != null) {
                                innerInclude.include(ab);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    while (true) {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (!_tokenSet_2.member(_t.getType())) break;
                        this.action(_t);
                        _t = this._retTree;
                    }
                    _t = __t163;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void var_action(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1215 = _t;
                    this.match(_t, 108);
                    _t = _t.getFirstChild();
                    this.var_declaration(_t);
                    _t = this._retTree;
                    _t = __t1215;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void user_defined_cover_item(AST _t) throws RecognitionException {
        block19: {
            Runnable finalRunnable;
            block18: {
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST ud = null;
                try {
                    try {
                        AST __t11 = _t;
                        ud = _t == ASTNULL ? null : _t;
                        this.match(_t, 403);
                        _t = _t.getFirstChild();
                        this.define_name(_t);
                        _t = this._retTree;
                        this.replacement_term_list(_t);
                        _t = this._retTree;
                        if (this.inputState.guessing() == 0) {
                            try {
                                if (ud != null) {
                                    this.inMacro(ud);
                                }
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        this.cover_item_list(_t);
                        _t = this._retTree;
                        _t = __t11;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block18;
                        try {
                            if (ud != null) {
                                this.outMacro(ud);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void cover_item_list(AST _t) throws RecognitionException {
        block18: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1033 = _t;
                    this.match(_t, 67);
                    _t = _t.getFirstChild();
                    block8: while (true) {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 68: 
                            case 69: 
                            case 70: 
                            case 403: 
                            case 404: 
                            case 419: 
                            case 420: {
                                this.cover_item(_t);
                                _t = this._retTree;
                                continue block8;
                            }
                            case 67: {
                                this.cover_item_list(_t);
                                _t = this._retTree;
                                continue block8;
                            }
                        }
                        break;
                    }
                    _t = __t1033;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final RfNamedElement user_defined_expression(AST _t, RfNamedElement lhScope, boolean isEvent) throws RecognitionException {
        RfNamedElement result;
        block25: {
            Runnable finalRunnable;
            block24: {
                result = null;
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST ud = null;
                try {
                    try {
                        AST __t13 = _t;
                        ud = _t == ASTNULL ? null : _t;
                        this.match(_t, 183);
                        _t = _t.getFirstChild();
                        this.define_name(_t);
                        _t = this._retTree;
                        this.replacement_term_list(_t);
                        _t = this._retTree;
                        if (this.inputState.guessing() == 0) {
                            try {
                                if (ud != null) {
                                    this.inMacro(ud);
                                }
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (_tokenSet_3.member(_t.getType()) && isEvent) {
                            result = this.event(_t);
                            _t = this._retTree;
                        } else if (_tokenSet_4.member(_t.getType())) {
                            result = this.expr(_t, lhScope);
                            _t = this._retTree;
                        } else if (_t.getType() != 3) {
                            throw this.getNoViableAltException(_t);
                        }
                        _t = __t13;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block24;
                        try {
                            if (ud != null) {
                                this.outMacro(ud);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement event(AST _t) throws RecognitionException {
        RfNamedElement result;
        block29: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST id = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 293: {
                            id = _t == ASTNULL ? null : _t;
                            this.identifier(_t);
                            _t = this._retTree;
                            if (this.inputState.guessing() != 0) break;
                            try {
                                if (id != null) {
                                    RfWNamedElementAndScope elementAndScope = null;
                                    if ("sim".equals(id.getText())) {
                                        elementAndScope = new RfWNamedElementAndScope(this.rfp.getSpecman().getSimEvent(), null, true);
                                    } else {
                                        elementAndScope = this.resolveIdentifier(id, EVENT, true);
                                        result = this.getNamedElement(elementAndScope);
                                        if (result == null) {
                                            RfStruct parentStruct = this.getStruct();
                                            if (parentStruct != null) {
                                                LineInfo lineInfo = this.getMacroSafeLine(id);
                                                this.rfp.addSemanticError1(1, "UNDEFINED_EVENT: Event ''{0}.{1}'' was not defined previously", lineInfo.getOffset(), lineInfo.getOffset() + id.getText().length(), null, lineInfo.line, this.parserPath, parentStruct.getName(), id.getText());
                                            }
                                            elementAndScope = null;
                                            result = ERROR_SCOPE;
                                        } else if (result instanceof IllegalAccessError) {
                                            LineInfo lineInfo = this.getMacroSafeLine(id);
                                            this.rfp.addSemanticError2(1, "ILLEGAL_ACCESS: Cannot access {0} {1} ''{2}.{3}''", lineInfo.getOffset(), lineInfo.getOffset() + id.getText().length(), null, lineInfo.line, this.parserPath, ((IllegalAccessError)result).getAccessModifierText(), ((IllegalAccessError)result).getElementKindText(), ((IllegalAccessError)result).getParentName(), id.getText());
                                            result = ((IllegalAccessError)result).getElement();
                                        }
                                    }
                                    this.setTransientResult(id, elementAndScope);
                                }
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break;
                        }
                        case 223: 
                        case 224: 
                        case 225: {
                            result = this.field_access_expr(_t, true);
                            _t = this._retTree;
                            break;
                        }
                        case 226: {
                            result = this.port_access_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 183: {
                            result = this.user_defined_expression(_t, null, true);
                            _t = this._retTree;
                            break;
                        }
                        case 184: {
                            this.as_computed_user_defined_expression(_t);
                            _t = this._retTree;
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block29;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement expr(AST _t, RfNamedElement lhScope) throws RecognitionException {
        RfNamedElement result;
        block41: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST id = null;
            if (lhScope instanceof IRfAssociatedType && ((IRfAssociatedType)((Object)lhScope)).getAssociatedBaseType() == this.LINT_RULE_ID && ((IRfAssociatedType)((Object)lhScope)).getAssociatedTypeList() == 0) {
                lhScope = ERROR_SCOPE;
            }
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 184: {
                            this.as_computed_user_defined_expression(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 188: {
                            result = this.conditional_op_expr(_t, lhScope);
                            _t = this._retTree;
                            break;
                        }
                        case 191: 
                        case 192: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: 
                        case 198: 
                        case 199: 
                        case 200: 
                        case 201: 
                        case 202: 
                        case 203: 
                        case 204: 
                        case 205: 
                        case 206: 
                        case 207: 
                        case 208: 
                        case 209: 
                        case 210: 
                        case 211: 
                        case 212: 
                        case 213: 
                        case 214: 
                        case 215: 
                        case 464: {
                            result = this.binary_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 216: 
                        case 217: 
                        case 218: 
                        case 219: 
                        case 220: 
                        case 221: {
                            result = this.unary_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 298: {
                            result = this.expansion_literal_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 292: {
                            result = this.each_line_in_file_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 294: 
                        case 295: 
                        case 296: 
                        case 297: 
                        case 299: 
                        case 300: 
                        case 301: 
                        case 302: 
                        case 303: 
                        case 304: 
                        case 305: 
                        case 306: 
                        case 307: 
                        case 308: 
                        case 309: 
                        case 310: 
                        case 311: 
                        case 312: 
                        case 313: 
                        case 314: 
                        case 315: 
                        case 316: 
                        case 317: {
                            result = this.literal_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 293: {
                            id = _t == ASTNULL ? null : _t;
                            this.identifier(_t);
                            _t = this._retTree;
                            if (this.inputState.guessing() != 0) break;
                            try {
                                IRfAssociatedType element;
                                IRfNamedElement assocType;
                                RfWNamedElementAndScope elementAndScope = null;
                                if (id != null && lhScope != ERROR_SCOPE) {
                                    elementAndScope = this.resolveIdentifier(id, FIELD_VARIABLE, false);
                                    elementAndScope = this.resolvePotentialEnum(id, elementAndScope, lhScope, false);
                                    result = this.getNamedElement(elementAndScope);
                                }
                                if (id != null && lhScope instanceof RfDummyField && ((RfDummyField)lhScope).isPerUnitInstance() && elementAndScope == null && (elementAndScope = this.resolveIdentifier(id, FIELD_VARIABLE, false)) == null && (assocType = (element = (IRfAssociatedType)((Object)lhScope)).getAssociatedType()) instanceof RfType) {
                                    result = ((RfType)assocType).semanticGetMember(this.rfp, element.getAssociatedTypeDeterminant(), this.packageName, this.getStruct(), id.getText(), FIELD, 31, this.maxModuleIndex, this.parserPath, null);
                                    elementAndScope = new RfWNamedElementAndScope(result, (RfType)assocType, true);
                                }
                                if (id != null && lhScope != ERROR_SCOPE) {
                                    this.module.createVariableDependency(this.rfp, result, id.getText());
                                    if (result != null || !(lhScope instanceof IRfAssociatedType) || !(((IRfAssociatedType)((Object)lhScope)).getAssociatedBaseType() instanceof IRfTemplateParam)) {
                                        if (result == null) {
                                            HashMap<String, Object> attributes = new HashMap<String, Object>();
                                            attributes.put("QUICKFIX_ELEMENT_NAME", id.getText());
                                            attributes.put("QUICKFIX_KIND", 1);
                                            LineInfo lineInfo = this.getMacroSafeLine(id);
                                            this.rfp.addSemanticError2(1, "UNDEFINED_IDENTIFIER: Identifier ''{0}'' is not defined", lineInfo.getOffset(), lineInfo.getOffset() + id.getText().length(), attributes, lineInfo.line, this.parserPath, id.getText());
                                            elementAndScope = null;
                                            result = RfUndefVariable.create(this.rfp, id.getText());
                                            this.setTransientResult(id, result);
                                        } else if (result instanceof IllegalAccessError) {
                                            LineInfo lineInfo = this.getMacroSafeLine(id);
                                            this.rfp.addSemanticError2(1, "ILLEGAL_ACCESS: Cannot access {0} {1} ''{2}.{3}''", lineInfo.getOffset(), lineInfo.getOffset() + id.getText().length(), null, lineInfo.line, this.parserPath, ((IllegalAccessError)result).getAccessModifierText(), ((IllegalAccessError)result).getElementKindText(), ((IllegalAccessError)result).getParentName(), id.getText());
                                            result = ((IllegalAccessError)result).getElement();
                                        }
                                    }
                                    if (lhScope instanceof RfUndefVariable) {
                                        ((RfUndefVariable)lhScope).type(result);
                                    }
                                    this.setTransientResult(id, elementAndScope);
                                }
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break;
                        }
                        case 318: {
                            result = this.deprecated_tick_id(_t, lhScope);
                            _t = this._retTree;
                            break;
                        }
                        case 369: {
                            result = this.as_computed_replacement_term(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 411: {
                            this.match(_t, 411);
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 506: {
                            this.match(_t, 506);
                            _t = _t.getNextSibling();
                            break;
                        }
                        default: {
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            if (_t.getType() == 183) {
                                result = this.user_defined_expression(_t, lhScope, false);
                                _t = this._retTree;
                                break;
                            }
                            if (_tokenSet_5.member(_t.getType())) {
                                result = this.primitive_expr(_t, lhScope);
                                _t = this._retTree;
                                break;
                            }
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block41;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement user_defined_type(AST _t) throws RecognitionException {
        RfNamedElement result;
        block24: {
            Runnable finalRunnable;
            block23: {
                result = null;
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST ud = null;
                try {
                    try {
                        AST __t16 = _t;
                        ud = _t == ASTNULL ? null : _t;
                        this.match(_t, 324);
                        _t = _t.getFirstChild();
                        this.define_name(_t);
                        _t = this._retTree;
                        this.replacement_term_list(_t);
                        _t = this._retTree;
                        if (this.inputState.guessing() == 0) {
                            try {
                                if (ud != null) {
                                    this.inMacro(ud);
                                }
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 35: 
                            case 40: 
                            case 293: 
                            case 324: 
                            case 325: 
                            case 326: 
                            case 327: 
                            case 331: 
                            case 332: 
                            case 333: 
                            case 334: 
                            case 335: 
                            case 336: 
                            case 337: 
                            case 338: 
                            case 379: 
                            case 409: 
                            case 410: 
                            case 412: 
                            case 418: {
                                result = this.type(_t);
                                _t = this._retTree;
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        _t = __t16;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block23;
                        try {
                            if (ud != null) {
                                this.outMacro(ud);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement type(AST _t) throws RecognitionException {
        RfNamedElement result;
        block34: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST id = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 324: {
                            result = this.user_defined_type(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 325: {
                            this.as_computed_user_defined_type(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 40: {
                            result = this.struct_subtype(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 331: 
                        case 332: 
                        case 333: 
                        case 334: 
                        case 335: 
                        case 336: 
                        case 337: {
                            result = this.port_type(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 338: {
                            result = this.list_type(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 409: {
                            result = this.qualified_type(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 410: {
                            result = this.param_type(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 412: {
                            result = this.template_instance(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 418: {
                            result = this.typeof_type(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 379: {
                            result = this.anonymous_ref_type(_t);
                            _t = this._retTree;
                            break;
                        }
                        default: {
                            boolean synPredMatched260 = false;
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            if (_t.getType() == 293) {
                                AST __t260 = _t;
                                synPredMatched260 = true;
                                this.inputState.incGuessing();
                                try {
                                    this.identifier(_t);
                                    _t = this._retTree;
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched260 = false;
                                }
                                _t = __t260;
                                this.inputState.decGuessing(synPredMatched260);
                            }
                            if (synPredMatched260) {
                                id = _t == ASTNULL ? null : _t;
                                this.identifier(_t);
                                _t = this._retTree;
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        result = this.getTransientResult(RfNamedElement.class, id);
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                                break;
                            }
                            if (_tokenSet_6.member(_t.getType())) {
                                result = this.scalar_type(_t);
                                _t = this._retTree;
                                break;
                            }
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block34;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement user_defined_constraint(AST _t, RfNamedElement lhScope) throws RecognitionException {
        RfNamedElement result;
        block19: {
            Runnable finalRunnable;
            block18: {
                result = null;
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST ud = null;
                try {
                    try {
                        AST __t19 = _t;
                        ud = _t == ASTNULL ? null : _t;
                        this.match(_t, 396);
                        _t = _t.getFirstChild();
                        this.define_name(_t);
                        _t = this._retTree;
                        this.replacement_term_list(_t);
                        _t = this._retTree;
                        if (this.inputState.guessing() == 0) {
                            try {
                                if (ud != null) {
                                    this.inMacro(ud);
                                }
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        this.keep_list_concat_expr(_t, lhScope);
                        _t = this._retTree;
                        _t = __t19;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block18;
                        try {
                            if (ud != null) {
                                this.outMacro(ud);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final void keep_list_concat_expr(AST _t, RfNamedElement lhScope) throws RecognitionException {
        block14: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t250 = _t;
                    this.match(_t, 245);
                    _t = _t.getFirstChild();
                    while (true) {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (!_tokenSet_7.member(_t.getType())) break;
                        this.keep_expr(_t, lhScope, false);
                        _t = this._retTree;
                    }
                    _t = __t250;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void define_as_computed_statement(AST _t) throws RecognitionException {
        block20: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            InnerInclude innerInclude = null;
            try {
                try {
                    AST __t21 = _t;
                    this.match(_t, 14);
                    _t = _t.getFirstChild();
                    this.define_name(_t);
                    _t = this._retTree;
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 16: {
                            this.define_before(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 294: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    this.match(_t, 294);
                    _t = _t.getNextSibling();
                    if (this.inputState.guessing() == 0) {
                        try {
                            innerInclude = new InnerInclude(){

                                @Override
                                public void include(AST ab) {
                                    RfActionBlockLayer def;
                                    if (ab != null && (def = SemanticWalker.this.getTransientScope(RfActionBlockLayer.class, ab)) != null) {
                                        def.startVarLayer(SemanticWalker.this.rfp, "result", SemanticWalker.this.STRING_TYPE, new Determinant(new String[]{SemanticWalker.this.STRING_TYPE.getName()}), def.getStartInfo(), new CommentBlock("<i>PREDEFINED: </i>'as computed' macro returned variable.", null, false), RfProject.VariableKind.DEFAULT);
                                    }
                                }

                                @Override
                                public LineInfo getStartLine(AST ab) {
                                    return null;
                                }
                            };
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    this.action_block(_t, innerInclude);
                    _t = this._retTree;
                    _t = __t21;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void define_before(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t883 = _t;
                    this.match(_t, 16);
                    _t = _t.getFirstChild();
                    this.identifier(_t);
                    _t = this._retTree;
                    this.identifier(_t);
                    _t = this._retTree;
                    _t = __t883;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void interface_statement(AST _t) throws RecognitionException {
        block26: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST ss = null;
            if (this.inputState.guessing() == 0) {
                this.cleanAllScopes();
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.cleanAllScopes();
                    }
                };
            }
            try {
                try {
                    AST __t24 = _t;
                    ss = _t == ASTNULL ? null : _t;
                    this.match(_t, 30);
                    _t = _t.getFirstChild();
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 361: {
                            this.statement_encap(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 293: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    this.identifier(_t);
                    _t = this._retTree;
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 33: {
                            this.implementing(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 52: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.pushScopeLayer(ss);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    this.interface_member_block(_t);
                    _t = this._retTree;
                    _t = __t24;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void statement_encap(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    this.match(_t, 361);
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void implementing(AST _t) throws RecognitionException {
        block20: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t931 = _t;
                    this.match(_t, 33);
                    _t = _t.getFirstChild();
                    int _cnt933 = 0;
                    block10: while (true) {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 293: {
                                this.identifier(_t);
                                _t = this._retTree;
                                break;
                            }
                            case 409: {
                                this.qualified_type(_t);
                                _t = this._retTree;
                                break;
                            }
                            case 412: {
                                this.template_instance(_t);
                                _t = this._retTree;
                                break;
                            }
                            case 410: {
                                this.match(_t, 410);
                                _t = _t.getNextSibling();
                                break;
                            }
                            default: {
                                if (_cnt933 >= 1) break block10;
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        ++_cnt933;
                    }
                    _t = __t931;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void interface_member_block(AST _t) throws RecognitionException {
        block14: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t969 = _t;
                    this.match(_t, 52);
                    _t = _t.getFirstChild();
                    while (true) {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (!_tokenSet_8.member(_t.getType())) break;
                        this.interface_member(_t);
                        _t = this._retTree;
                    }
                    _t = __t969;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void interface_template_statement(AST _t) throws RecognitionException {
        block26: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST ss = null;
            if (this.inputState.guessing() == 0) {
                this.cleanAllScopes();
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.cleanAllScopes();
                    }
                };
            }
            try {
                try {
                    AST __t28 = _t;
                    ss = _t == ASTNULL ? null : _t;
                    this.match(_t, 31);
                    _t = _t.getFirstChild();
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 361: {
                            this.statement_encap(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 293: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    this.identifier(_t);
                    _t = this._retTree;
                    this.template_parameters(_t, null);
                    _t = this._retTree;
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 33: {
                            this.implementing(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 52: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.pushScopeLayer(ss);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    this.interface_member_block(_t);
                    _t = this._retTree;
                    _t = __t28;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void template_parameters(AST _t, RfNamedElement result) throws RecognitionException {
        block25: {
            IRfNamedElement assocType;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            int index = 0;
            List parameters = Collections.emptyList();
            if (result != null && this.valid(result) && (assocType = ((IRfAssociatedType)((Object)result)).getAssociatedBaseType()) instanceof RfTemplateStructInstance) {
                RfTemplateStruct templateStruct = ((RfTemplateStructInstance)assocType).getTemplateStruct();
                parameters = templateStruct == null ? parameters : templateStruct.getParameters();
            }
            try {
                try {
                    while (true) {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (_t.getType() != 410 && _t.getType() != 411) break;
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 410: {
                                this.template_param_type(_t);
                                _t = this._retTree;
                                break;
                            }
                            case 411: {
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        result = index < parameters.size() ? (RfNamedElement)parameters.get(index) : null;
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                                this.template_param_exp(_t, result);
                                _t = this._retTree;
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        if (this.inputState.guessing() != 0) continue;
                        try {
                            ++index;
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block25;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void numeric_type_template_statement(AST _t) throws RecognitionException {
        block18: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            if (this.inputState.guessing() == 0) {
                this.cleanAllScopes();
            }
            try {
                try {
                    AST __t32 = _t;
                    AST aST = _t == ASTNULL ? null : _t;
                    this.match(_t, 49);
                    _t = _t.getFirstChild();
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 361: {
                            this.statement_encap(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 293: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    this.identifier(_t);
                    _t = this._retTree;
                    this.template_parameters(_t, null);
                    _t = this._retTree;
                    this.like(_t);
                    _t = this._retTree;
                    _t = __t32;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void like(AST _t) throws RecognitionException {
        block19: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t928 = _t;
                    this.match(_t, 32);
                    _t = _t.getFirstChild();
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 293: {
                            this.identifier(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 409: {
                            this.qualified_type(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 412: {
                            this.template_instance(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 410: {
                            this.match(_t, 410);
                            _t = _t.getNextSibling();
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t928;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void struct_statement(AST _t) throws RecognitionException {
        block31: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST ss = null;
            if (this.inputState.guessing() == 0) {
                this.cleanAllScopes();
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.cleanAllScopes();
                    }
                };
            }
            try {
                try {
                    AST __t35 = _t;
                    ss = _t == ASTNULL ? null : _t;
                    this.match(_t, 28);
                    _t = _t.getFirstChild();
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 361: {
                            this.statement_encap(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 293: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    this.identifier(_t);
                    _t = this._retTree;
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 32: {
                            this.like(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 33: 
                        case 51: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 33: {
                            this.implementing(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 51: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.pushScopeLayer(ss);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    this.struct_member_block(_t);
                    _t = this._retTree;
                    _t = __t35;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block31;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void struct_template_statement(AST _t) throws RecognitionException {
        block31: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST ss = null;
            if (this.inputState.guessing() == 0) {
                this.cleanAllScopes();
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.rfp.setSemanticInTemplateDefinition(null);
                        SemanticWalker.this.cleanAllScopes();
                    }
                };
            }
            try {
                try {
                    AST __t40 = _t;
                    ss = _t == ASTNULL ? null : _t;
                    this.match(_t, 413);
                    _t = _t.getFirstChild();
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 361: {
                            this.statement_encap(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 293: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    this.identifier(_t);
                    _t = this._retTree;
                    this.template_parameters(_t, null);
                    _t = this._retTree;
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 32: {
                            this.like(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 33: 
                        case 51: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 33: {
                            this.implementing(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 51: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.pushScopeLayer(ss);
                            this.rfp.setSemanticInTemplateDefinition(this.getStruct());
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    this.struct_member_block(_t);
                    _t = this._retTree;
                    _t = __t40;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block31;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void unit_statement(AST _t) throws RecognitionException {
        block31: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST ss = null;
            if (this.inputState.guessing() == 0) {
                this.cleanAllScopes();
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.cleanAllScopes();
                    }
                };
            }
            try {
                try {
                    AST __t45 = _t;
                    ss = _t == ASTNULL ? null : _t;
                    this.match(_t, 29);
                    _t = _t.getFirstChild();
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 361: {
                            this.statement_encap(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 293: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    this.identifier(_t);
                    _t = this._retTree;
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 32: {
                            this.like(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 33: 
                        case 51: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 33: {
                            this.implementing(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 51: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.pushScopeLayer(ss);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    this.struct_member_block(_t);
                    _t = this._retTree;
                    _t = __t45;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block31;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void unit_template_statement(AST _t) throws RecognitionException {
        block31: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST ss = null;
            if (this.inputState.guessing() == 0) {
                this.cleanAllScopes();
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.rfp.setSemanticInTemplateDefinition(null);
                        SemanticWalker.this.cleanAllScopes();
                    }
                };
            }
            try {
                try {
                    AST __t50 = _t;
                    ss = _t == ASTNULL ? null : _t;
                    this.match(_t, 414);
                    _t = _t.getFirstChild();
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 361: {
                            this.statement_encap(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 293: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    this.identifier(_t);
                    _t = this._retTree;
                    this.template_parameters(_t, null);
                    _t = this._retTree;
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 32: {
                            this.like(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 33: 
                        case 51: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 33: {
                            this.implementing(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 51: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.pushScopeLayer(ss);
                            this.rfp.setSemanticInTemplateDefinition(this.getStruct());
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    this.struct_member_block(_t);
                    _t = this._retTree;
                    _t = __t50;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block31;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void method_export_statement(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            RfNamedElement typeContainer = null;
            try {
                try {
                    AST __t55 = _t;
                    this.match(_t, 50);
                    _t = _t.getFirstChild();
                    typeContainer = this.type(_t);
                    _t = this._retTree;
                    this.method_invocation_expr(_t, null, typeContainer);
                    _t = this._retTree;
                    _t = __t55;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final RfNamedElement method_invocation_expr(AST _t, RfNamedElement lhScope1, RfNamedElement lhScope2) throws RecognitionException {
        RfNamedElement result;
        block18: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 227: {
                            result = this.regular_method_invocation_expr(_t, lhScope1);
                            _t = this._retTree;
                            break;
                        }
                        case 228: 
                        case 229: 
                        case 230: 
                        case 231: 
                        case 232: 
                        case 233: 
                        case 234: 
                        case 235: 
                        case 236: 
                        case 237: 
                        case 266: 
                        case 507: {
                            result = this.special_method_invocation_expr(_t, lhScope1, lhScope2);
                            _t = this._retTree;
                            break;
                        }
                        case 183: {
                            result = this.user_defined_expression(_t, null, false);
                            _t = this._retTree;
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final void when_struct_member(AST _t) throws RecognitionException {
        block17: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            Determinant determinant = null;
            final int stackScopeSize = this.getLastScopeLayerStackSize();
            if (this.inputState.guessing() == 0) {
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.cleanAllScopes(stackScopeSize);
                    }
                };
            }
            try {
                try {
                    AST __t57 = _t;
                    this.match(_t, 57);
                    _t = _t.getFirstChild();
                    if (this.inputState.guessing() == 0) {
                        try {
                            RfDefElement def;
                            if (this.lastScopeLayerStack != null && !this.lastScopeLayerStack.isEmpty() && (def = this.getLastScopeLayerStackElement()) instanceof RfStructLayer) {
                                determinant = ((RfStructLayer)def).getDeterminant();
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    this.when_type(_t, determinant);
                    _t = this._retTree;
                    this.struct_member_block(_t);
                    _t = this._retTree;
                    _t = __t57;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void when_type(AST _t, Determinant layerDeterminant) throws RecognitionException {
        block30: {
            Runnable finalRunnable;
            block29: {
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST ss = null;
                AST sq = null;
                AST id = null;
                ArrayList<AST> sqs = new ArrayList<AST>();
                ArrayList<String> determinantParts = new ArrayList<String>();
                try {
                    try {
                        AST __t64 = _t;
                        ss = _t == ASTNULL ? null : _t;
                        this.match(_t, 58);
                        _t = _t.getFirstChild();
                        while (true) {
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            if (_t.getType() != 40) break;
                            sq = _t == ASTNULL ? null : _t;
                            this.struct_qualifier(_t, determinantParts);
                            _t = this._retTree;
                            if (this.inputState.guessing() != 0) continue;
                            try {
                                sqs.add(sq);
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 293: {
                                id = _t == ASTNULL ? null : _t;
                                this.identifier(_t);
                                _t = this._retTree;
                                break;
                            }
                            case 409: {
                                this.qualified_type(_t);
                                _t = this._retTree;
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        _t = __t64;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block29;
                        try {
                            this.pushScopeLayer(ss);
                            RfStructLayer def = this.getTransientScope(RfStructLayer.class, ss);
                            if (def != null) {
                                RfStruct struct = def.getStruct();
                                if (id != null) {
                                    if (struct.getName().equals(id.getText())) {
                                        this.setTransientResult(id, new RfSubtypeElement(this.rfp, null, struct, new Determinant(determinantParts.toArray(new String[determinantParts.size()]))));
                                    } else {
                                        determinantParts.add(id.getText());
                                        sqs.add(EASTFactory.make((ASTArray)new ASTArray(2).add(EASTFactory.createAST((String)"struct_qualifier", (int)40)).add(id)));
                                    }
                                }
                                if (layerDeterminant != null) {
                                    Determinant determinant = layerDeterminant;
                                    int i = sqs.size() - 1;
                                    while (i >= 0) {
                                        AST qualifierAST = (AST)sqs.get(i);
                                        RfStructQualifier structQualifier = this.struct_qualifier_check(qualifierAST, struct, determinant);
                                        def.addStructQualifier(structQualifier);
                                        determinant = new Determinant(new String[]{qualifierAST.getText()}, determinant.toArray());
                                        --i;
                                    }
                                }
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block30;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void struct_member(AST _t) throws RecognitionException {
        block57: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 51: {
                            this.struct_member_block(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 53: {
                            this.preproc_ifdef_struct_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 54: {
                            this.preproc_ifndef_struct_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 55: {
                            this.user_defined_struct_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 56: {
                            this.as_computed_user_defined_struct_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 57: {
                            this.when_struct_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 59: {
                            this.field_struct_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 62: 
                        case 63: 
                        case 64: {
                            this.method_struct_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 65: {
                            this.constraint_struct_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 66: {
                            this.coverage_struct_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 72: {
                            this.attribute_struct_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 73: {
                            this.event_struct_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 74: {
                            this.on_event_struct_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 75: 
                        case 76: 
                        case 77: {
                            this.expect_struct_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 78: 
                        case 79: 
                        case 80: {
                            this.assume_struct_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 82: 
                        case 85: 
                        case 86: 
                        case 89: 
                        case 95: 
                        case 96: 
                        case 97: 
                        case 98: 
                        case 99: {
                            this.simulator_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 48: {
                            this.vhdl_object(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 8: {
                            this.statement_block_scope_restore(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 435: {
                            this.sln_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 455: {
                            this.sln_child_struct_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 456: {
                            this.sln_token_field_struct_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 457: {
                            this.sln_bind_struct_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 458: {
                            this.sln_constraint_struct_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 459: {
                            this.sln_constraint_default_struct_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 460: {
                            this.sln_constraint_default_disable_struct_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 461: {
                            this.sln_named_constraint_struct_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 432: {
                            this.sln_token_default_value_struct_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 437: 
                        case 438: 
                        case 439: {
                            this.sln_exec(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 441: {
                            this.sln_compound(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 492: {
                            this.sln_function_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 27: {
                            this.sln_type_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 34: {
                            this.sln_extend_type_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 498: {
                            this.sdl_inline_struct_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 467: {
                            this.sdl_role_struct_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 469: {
                            this.sdl_scenario_struct_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 37: {
                            this.sdl_extend_scenario_struct_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 470: {
                            this.sdl_do_struct_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 493: {
                            this.sdl_cover_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 494: {
                            this.sdl_cover_cross(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 482: {
                            this.sdl_in(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 483: {
                            this.sdl_in_any(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 484: {
                            this.sdl_mix(_t);
                            _t = this._retTree;
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block57;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void preproc_ifdef_struct_member(AST _t) throws RecognitionException {
        block17: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1004 = _t;
                    this.match(_t, 53);
                    _t = _t.getFirstChild();
                    this.preproc_id(_t);
                    _t = this._retTree;
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 51: 
                        case 366: {
                            this.preproc_struct_member_block(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t1004;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void preproc_ifndef_struct_member(AST _t) throws RecognitionException {
        block17: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1007 = _t;
                    this.match(_t, 54);
                    _t = _t.getFirstChild();
                    this.preproc_id(_t);
                    _t = this._retTree;
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 51: 
                        case 366: {
                            this.preproc_struct_member_block(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t1007;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void as_computed_user_defined_struct_member(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1011 = _t;
                    this.match(_t, 56);
                    _t = _t.getFirstChild();
                    this.define_name(_t);
                    _t = this._retTree;
                    this.replacement_term_list(_t);
                    _t = this._retTree;
                    _t = __t1011;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void field_struct_member(AST _t) throws RecognitionException {
        block61: {
            Runnable finalRunnable;
            block60: {
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST sm = null;
                AST id = null;
                AST exp = null;
                RfNamedElement result = null;
                RfNamedElement typeContainer = null;
                RfStructMember declaredField = null;
                RfNamedElement sdsv = null;
                try {
                    try {
                        AST __t174 = _t;
                        sm = _t == ASTNULL ? null : _t;
                        this.match(_t, 59);
                        _t = _t.getFirstChild();
                        id = _t == ASTNULL ? null : _t;
                        this.identifier(_t);
                        _t = this._retTree;
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (_t.getType() == 60) {
                            typeContainer = this.field_type(_t);
                            _t = this._retTree;
                        } else if (!_tokenSet_9.member(_t.getType())) {
                            throw this.getNoViableAltException(_t);
                        }
                        if (this.inputState.guessing() == 0) {
                            try {
                                declaredField = this.getTransientResult(RfStructMember.class, id);
                                if (declaredField != null) {
                                    RfDefElement def = this.getTransientScope(RfDefElement.class, sm);
                                    LineInfo lineInfo = this.getMacroSafeLine(id);
                                    declaredField.performAdditionalSemanticChecks(this.rfp, def, lineInfo, this.parserPath);
                                    if (typeContainer == null) {
                                        typeContainer = declaredField;
                                    }
                                }
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 183: 
                            case 184: 
                            case 188: 
                            case 189: 
                            case 191: 
                            case 192: 
                            case 193: 
                            case 194: 
                            case 195: 
                            case 196: 
                            case 197: 
                            case 198: 
                            case 199: 
                            case 200: 
                            case 201: 
                            case 202: 
                            case 203: 
                            case 204: 
                            case 205: 
                            case 206: 
                            case 207: 
                            case 208: 
                            case 209: 
                            case 210: 
                            case 211: 
                            case 212: 
                            case 213: 
                            case 214: 
                            case 215: 
                            case 216: 
                            case 217: 
                            case 218: 
                            case 219: 
                            case 220: 
                            case 221: 
                            case 222: 
                            case 223: 
                            case 224: 
                            case 225: 
                            case 226: 
                            case 227: 
                            case 228: 
                            case 229: 
                            case 230: 
                            case 231: 
                            case 232: 
                            case 233: 
                            case 234: 
                            case 235: 
                            case 236: 
                            case 237: 
                            case 238: 
                            case 239: 
                            case 240: 
                            case 241: 
                            case 242: 
                            case 243: 
                            case 244: 
                            case 245: 
                            case 246: 
                            case 251: 
                            case 252: 
                            case 256: 
                            case 259: 
                            case 260: 
                            case 261: 
                            case 262: 
                            case 263: 
                            case 264: 
                            case 265: 
                            case 266: 
                            case 267: 
                            case 268: 
                            case 269: 
                            case 277: 
                            case 278: 
                            case 279: 
                            case 280: 
                            case 281: 
                            case 282: 
                            case 283: 
                            case 284: 
                            case 285: 
                            case 286: 
                            case 287: 
                            case 288: 
                            case 292: 
                            case 293: 
                            case 294: 
                            case 295: 
                            case 296: 
                            case 297: 
                            case 298: 
                            case 299: 
                            case 300: 
                            case 301: 
                            case 302: 
                            case 303: 
                            case 304: 
                            case 305: 
                            case 306: 
                            case 307: 
                            case 308: 
                            case 309: 
                            case 310: 
                            case 311: 
                            case 312: 
                            case 313: 
                            case 314: 
                            case 315: 
                            case 316: 
                            case 317: 
                            case 318: 
                            case 319: 
                            case 320: 
                            case 321: 
                            case 322: 
                            case 323: 
                            case 369: 
                            case 411: 
                            case 416: 
                            case 417: 
                            case 464: 
                            case 497: 
                            case 506: 
                            case 507: {
                                exp = _t == ASTNULL ? null : _t;
                                result = this.expr(_t, typeContainer);
                                _t = this._retTree;
                                break;
                            }
                            case 3: 
                            case 463: 
                            case 486: 
                            case 488: 
                            case 489: 
                            case 490: 
                            case 491: {
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 463: {
                                this.sln_field_keeping_constraints(_t, typeContainer);
                                _t = this._retTree;
                                break;
                            }
                            case 3: 
                            case 486: 
                            case 488: 
                            case 489: 
                            case 490: 
                            case 491: {
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 488: {
                                this.sdl_field_constraint(_t, declaredField);
                                _t = this._retTree;
                                break;
                            }
                            case 3: 
                            case 486: 
                            case 489: 
                            case 490: 
                            case 491: {
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 489: {
                                sdsv = this.sdl_field_sample_value(_t, typeContainer);
                                _t = this._retTree;
                                if (this.inputState.guessing() != 0) break;
                                try {
                                    RfStructMember member;
                                    if (id == null || !(sdsv instanceof IRfAssociatedType) || !((member = this.getTransientResult(RfStructMember.class, id)) instanceof RfField)) break;
                                    member.setAssociatedTypeFrom(this.rfp, sdsv);
                                    ((RfField)member).updateTypeNameFromAssociatedType();
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                                break;
                            }
                            case 3: 
                            case 486: 
                            case 490: 
                            case 491: {
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 490: {
                                this.sdl_field_sample_event(_t);
                                _t = this._retTree;
                                break;
                            }
                            case 3: 
                            case 486: 
                            case 491: {
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 491: {
                                this.sdl_field_sample_where(_t);
                                _t = this._retTree;
                                break;
                            }
                            case 3: 
                            case 486: {
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 486: {
                                this.sdl_field_member_block(_t, typeContainer);
                                _t = this._retTree;
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        _t = __t174;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block60;
                        try {
                            if (result != null && !(result instanceof RfUndefVariable)) {
                                SemanticUtils.incompatibleAssign(this.rfp, this.parserPath, this.macroDepth, this.macroLineInfo, null, exp, typeContainer, result, SemanticUtils.AssignKind.ASSIGN);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block61;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void method_struct_member(AST _t) throws RecognitionException {
        block53: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST msm = null;
            AST id1 = null;
            AST cvl = null;
            AST id2 = null;
            AST cms = null;
            AST id3 = null;
            RfNamedElement typeContainer = null;
            final int stackScopeSize = this.getLastScopeLayerStackSize();
            if (this.inputState.guessing() == 0) {
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.cleanAllScopes(stackScopeSize);
                    }
                };
            }
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 62: {
                            AST __t95 = _t;
                            msm = _t == ASTNULL ? null : _t;
                            this.match(_t, 62);
                            _t = _t.getFirstChild();
                            id1 = _t == ASTNULL ? null : _t;
                            this.identifier(_t);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    this.pushScopeLayer(msm);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            this.parameter_list(_t);
                            _t = this._retTree;
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            switch (_t.getType()) {
                                case 380: {
                                    typeContainer = this.result_type(_t);
                                    _t = this._retTree;
                                    break;
                                }
                                case 183: 
                                case 184: 
                                case 223: 
                                case 224: 
                                case 225: 
                                case 226: 
                                case 293: 
                                case 371: 
                                case 372: 
                                case 373: 
                                case 374: 
                                case 375: 
                                case 376: 
                                case 377: 
                                case 378: {
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltException(_t);
                                }
                            }
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            switch (_t.getType()) {
                                case 183: 
                                case 184: 
                                case 223: 
                                case 224: 
                                case 225: 
                                case 226: 
                                case 293: {
                                    this.event(_t);
                                    _t = this._retTree;
                                    break;
                                }
                                case 371: 
                                case 372: 
                                case 373: 
                                case 374: 
                                case 375: 
                                case 376: 
                                case 377: 
                                case 378: {
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltException(_t);
                                }
                            }
                            if (this.inputState.guessing() == 0) {
                                try {
                                    RfStructMember member = this.getTransientResult(RfStructMember.class, id1);
                                    if (member != null) {
                                        RfDefElement def = this.getTransientScope(RfDefElement.class, msm);
                                        LineInfo lineInfo = this.getMacroSafeLine(id1);
                                        member.performAdditionalSemanticChecks(this.rfp, def, lineInfo, this.parserPath);
                                        RfStruct parentStruct = member.getParentStruct();
                                        if (parentStruct instanceof RfTemplateStruct && typeContainer != null) {
                                            member.setAssociatedTypeFrom(this.rfp, typeContainer);
                                        }
                                    }
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            this.method_body(_t);
                            _t = this._retTree;
                            _t = __t95;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 64: {
                            AST __t98 = _t;
                            cvl = _t == ASTNULL ? null : _t;
                            this.match(_t, 64);
                            _t = _t.getFirstChild();
                            id2 = _t == ASTNULL ? null : _t;
                            this.identifier(_t);
                            _t = this._retTree;
                            this.parameter_list(_t);
                            _t = this._retTree;
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            switch (_t.getType()) {
                                case 183: 
                                case 184: 
                                case 223: 
                                case 224: 
                                case 225: 
                                case 226: 
                                case 293: {
                                    this.event(_t);
                                    _t = this._retTree;
                                    break;
                                }
                                case 3: {
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltException(_t);
                                }
                            }
                            _t = __t98;
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() != 0) break;
                            try {
                                RfStructMember member = this.getTransientResult(RfStructMember.class, id2);
                                if (member != null) {
                                    RfDefElement def = this.getTransientScope(RfDefElement.class, cvl);
                                    LineInfo lineInfo = this.getMacroSafeLine(id2);
                                    member.performAdditionalSemanticChecks(this.rfp, def, lineInfo, this.parserPath);
                                }
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break;
                        }
                        case 63: {
                            AST __t100 = _t;
                            cms = _t == ASTNULL ? null : _t;
                            this.match(_t, 63);
                            _t = _t.getFirstChild();
                            id3 = _t == ASTNULL ? null : _t;
                            this.identifier(_t);
                            _t = this._retTree;
                            this.parameter_list(_t);
                            _t = this._retTree;
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            switch (_t.getType()) {
                                case 380: {
                                    this.result_type(_t);
                                    _t = this._retTree;
                                    break;
                                }
                                case 3: {
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltException(_t);
                                }
                            }
                            _t = __t100;
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() != 0) break;
                            try {
                                RfStructMember member = this.getTransientResult(RfStructMember.class, id3);
                                if (member != null) {
                                    RfDefElement def = this.getTransientScope(RfDefElement.class, cms);
                                    LineInfo lineInfo = this.getMacroSafeLine(id3);
                                    member.performAdditionalSemanticChecks(this.rfp, def, lineInfo, this.parserPath);
                                }
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block53;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void constraint_struct_member(AST _t) throws RecognitionException {
        block30: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST ab = null;
            AST id = null;
            final int stackScopeSize = this.getLastScopeLayerStackSize();
            if (this.inputState.guessing() == 0) {
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.cleanAllScopes(stackScopeSize);
                    }
                };
            }
            try {
                try {
                    AST __t237 = _t;
                    ab = _t == ASTNULL ? null : _t;
                    this.match(_t, 65);
                    _t = _t.getFirstChild();
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    if (_t.getType() == 377 || _t.getType() == 378) {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 378: {
                                this.match(_t, 378);
                                _t = _t.getNextSibling();
                                break;
                            }
                            case 377: {
                                this.match(_t, 377);
                                _t = _t.getNextSibling();
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        id = _t == ASTNULL ? null : _t;
                        this.identifier(_t);
                        _t = this._retTree;
                        if (this.inputState.guessing() == 0) {
                            try {
                                RfStructMember member = this.getTransientResult(RfStructMember.class, id);
                                if (member != null) {
                                    RfDefElement def = this.getTransientScope(RfDefElement.class, id);
                                    LineInfo lineInfo = this.getMacroSafeLine(id);
                                    member.performAdditionalSemanticChecks(this.rfp, def, lineInfo, this.parserPath);
                                }
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                    } else if (!_tokenSet_7.member(_t.getType())) {
                        throw this.getNoViableAltException(_t);
                    }
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.pushScopeLayer(ab);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    this.keep_expr(_t, null, false);
                    _t = this._retTree;
                    _t = __t237;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block30;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void coverage_struct_member(AST _t) throws RecognitionException {
        block24: {
            Runnable finalRunnable;
            block23: {
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST sm = null;
                AST id = null;
                final int stackScopeSize = this.getLastScopeLayerStackSize();
                if (this.inputState.guessing() == 0) {
                    finalRunnable = new Runnable(){

                        @Override
                        public void run() {
                            SemanticWalker.this.cleanAllScopes(stackScopeSize);
                        }
                    };
                }
                try {
                    try {
                        AST __t117 = _t;
                        sm = _t == ASTNULL ? null : _t;
                        this.match(_t, 66);
                        _t = _t.getFirstChild();
                        id = _t == ASTNULL ? null : _t;
                        this.identifier(_t);
                        _t = this._retTree;
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 384: 
                            case 385: {
                                this.using_list(_t);
                                _t = this._retTree;
                                break;
                            }
                            case 371: 
                            case 376: 
                            case 378: {
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        if (this.inputState.guessing() == 0) {
                            try {
                                this.pushScopeLayer(sm);
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        this.coverage_body(_t);
                        _t = this._retTree;
                        _t = __t117;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block23;
                        try {
                            RfStructMember member = this.getTransientResult(RfStructMember.class, id);
                            if (member != null) {
                                RfDefElement def = this.getTransientScope(RfDefElement.class, sm);
                                LineInfo lineInfo = this.getMacroSafeLine(id);
                                member.performAdditionalSemanticChecks(this.rfp, def, lineInfo, this.parserPath);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void attribute_struct_member(AST _t) throws RecognitionException {
        block20: {
            Runnable finalRunnable;
            block19: {
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST id1 = null;
                AST id2 = null;
                AST id3 = null;
                try {
                    try {
                        AST __t115 = _t;
                        this.match(_t, 72);
                        _t = _t.getFirstChild();
                        id1 = _t == ASTNULL ? null : _t;
                        this.identifier(_t);
                        _t = this._retTree;
                        id2 = _t == ASTNULL ? null : _t;
                        this.identifier(_t);
                        _t = this._retTree;
                        id3 = _t == ASTNULL ? null : _t;
                        this.identifier(_t);
                        _t = this._retTree;
                        _t = __t115;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block19;
                        try {
                            LineInfo lineInfo;
                            if (id1 != null) {
                                RfWNamedElementAndScope elementAndScope = this.resolveIdentifier(id1, FIELD, true);
                                RfNamedElement result = this.getNamedElement(elementAndScope);
                                if (result == null) {
                                    LineInfo lineInfo2 = this.getMacroSafeLine(id1);
                                    this.rfp.addSemanticError2(1, "UNDEFINED_IDENTIFIER: Identifier ''{0}'' is not defined", lineInfo2.getOffset(), lineInfo2.getOffset() + id1.getText().length(), null, lineInfo2.line, this.parserPath, id1.getText());
                                    elementAndScope = null;
                                } else if (result instanceof IllegalAccessError) {
                                    LineInfo lineInfo3 = this.getMacroSafeLine(id1);
                                    this.rfp.addSemanticError2(1, "ILLEGAL_ACCESS: Cannot access {0} {1} ''{2}.{3}''", lineInfo3.getOffset(), lineInfo3.getOffset() + id1.getText().length(), null, lineInfo3.line, this.parserPath, ((IllegalAccessError)result).getAccessModifierText(), ((IllegalAccessError)result).getElementKindText(), ((IllegalAccessError)result).getParentName(), id1.getText());
                                }
                                this.setTransientResult(id1, elementAndScope);
                            }
                            if (!(id2 == null || "deep_copy".equals(id2.getText()) || "deep_compare".equals(id2.getText()) || "deep_compare_physical".equals(id2.getText()) || "deep_all".equals(id2.getText()))) {
                                lineInfo = this.getMacroSafeLine(id2);
                                this.rfp.addSemanticError2(1, "UNEXPECTED_ATTRIBUTE_NAME: Unexpected attibute name ''{0}'', must be one of ''deep_copy'', ''deep_compare'', ''deep_compare_physical'' or ''deep_all''", lineInfo.getOffset(), lineInfo.getOffset() + id2.getText().length(), null, lineInfo.line, this.parserPath, id2.getText());
                            }
                            if (!(id3 == null || "normal".equals(id3.getText()) || "reference".equals(id3.getText()) || "ignore".equals(id3.getText()))) {
                                lineInfo = this.getMacroSafeLine(id3);
                                this.rfp.addSemanticError2(1, "UNEXPECTED_ATTRIBUTE_VALUE: Unexpected attibute value ''{0}'', must be one of ''normal'', ''reference'' or ''ignore''", lineInfo.getOffset(), lineInfo.getOffset() + id3.getText().length(), null, lineInfo.line, this.parserPath, id3.getText());
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void event_struct_member(AST _t) throws RecognitionException {
        block35: {
            Runnable finalRunnable;
            block34: {
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST sm = null;
                AST id = null;
                RfNamedElement rfEvent = null;
                try {
                    try {
                        AST __t184 = _t;
                        sm = _t == ASTNULL ? null : _t;
                        this.match(_t, 73);
                        _t = _t.getFirstChild();
                        id = _t == ASTNULL ? null : _t;
                        this.identifier(_t);
                        _t = this._retTree;
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 381: {
                                this.parameter_list(_t);
                                _t = this._retTree;
                                break;
                            }
                            case 3: 
                            case 187: 
                            case 376: 
                            case 377: 
                            case 378: 
                            case 509: {
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 376: 
                            case 377: 
                            case 378: {
                                rfEvent = this.event_body(_t);
                                _t = this._retTree;
                                break;
                            }
                            case 3: 
                            case 187: 
                            case 509: {
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 509: {
                                this.sdl_when_expr(_t, rfEvent);
                                _t = this._retTree;
                                break;
                            }
                            case 3: 
                            case 187: {
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 187: {
                                this.using_temporal_operators(_t);
                                _t = this._retTree;
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        _t = __t184;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block34;
                        try {
                            RfStructMember member = this.getTransientResult(RfStructMember.class, id);
                            if (member != null) {
                                RfDefElement def = this.getTransientScope(RfDefElement.class, sm);
                                LineInfo lineInfo = this.getMacroSafeLine(id);
                                member.performAdditionalSemanticChecks(this.rfp, def, lineInfo, this.parserPath);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block35;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void on_event_struct_member(AST _t) throws RecognitionException {
        block21: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST on = null;
            final int stackScopeSize = this.getLastScopeLayerStackSize();
            if (this.inputState.guessing() == 0) {
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.cleanAllScopes(stackScopeSize);
                    }
                };
            }
            try {
                try {
                    AST __t138 = _t;
                    on = _t == ASTNULL ? null : _t;
                    this.match(_t, 74);
                    _t = _t.getFirstChild();
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.pushScopeLayer(on);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 384: {
                            this.using_indexes(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 183: 
                        case 184: 
                        case 223: 
                        case 224: 
                        case 225: 
                        case 226: 
                        case 293: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    this.event(_t);
                    _t = this._retTree;
                    this.action_block(_t);
                    _t = this._retTree;
                    _t = __t138;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void expect_struct_member(AST _t) throws RecognitionException {
        block47: {
            Runnable finalRunnable;
            block46: {
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST ses = null;
                AST id1 = null;
                AST nes = null;
                AST id2 = null;
                AST sm = null;
                AST id = null;
                try {
                    try {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 75: {
                                AST __t220 = _t;
                                ses = _t == ASTNULL ? null : _t;
                                this.match(_t, 75);
                                _t = _t.getFirstChild();
                                id1 = _t == ASTNULL ? null : _t;
                                this.identifier(_t);
                                _t = this._retTree;
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        sm = ses;
                                        id = id1;
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                                _t = __t220;
                                _t = _t.getNextSibling();
                                break;
                            }
                            case 76: {
                                AST __t221 = _t;
                                this.match(_t, 76);
                                _t = _t.getFirstChild();
                                this.temporal_expr(_t);
                                _t = this._retTree;
                                if (_t == null) {
                                    _t = ASTNULL;
                                }
                                switch (_t.getType()) {
                                    case 134: 
                                    case 135: {
                                        this.dut_error_action(_t);
                                        _t = this._retTree;
                                        break;
                                    }
                                    case 3: 
                                    case 187: {
                                        break;
                                    }
                                    default: {
                                        throw this.getNoViableAltException(_t);
                                    }
                                }
                                if (_t == null) {
                                    _t = ASTNULL;
                                }
                                switch (_t.getType()) {
                                    case 187: {
                                        this.using_temporal_operators(_t);
                                        _t = this._retTree;
                                        break;
                                    }
                                    case 3: {
                                        break;
                                    }
                                    default: {
                                        throw this.getNoViableAltException(_t);
                                    }
                                }
                                _t = __t221;
                                _t = _t.getNextSibling();
                                break;
                            }
                            case 77: {
                                AST __t224 = _t;
                                nes = _t == ASTNULL ? null : _t;
                                this.match(_t, 77);
                                _t = _t.getFirstChild();
                                id2 = _t == ASTNULL ? null : _t;
                                this.identifier(_t);
                                _t = this._retTree;
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        sm = nes;
                                        id = id2;
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                                this.expect_body(_t);
                                _t = this._retTree;
                                if (_t == null) {
                                    _t = ASTNULL;
                                }
                                switch (_t.getType()) {
                                    case 134: 
                                    case 135: {
                                        this.dut_error_action(_t);
                                        _t = this._retTree;
                                        break;
                                    }
                                    case 3: 
                                    case 187: {
                                        break;
                                    }
                                    default: {
                                        throw this.getNoViableAltException(_t);
                                    }
                                }
                                if (_t == null) {
                                    _t = ASTNULL;
                                }
                                switch (_t.getType()) {
                                    case 187: {
                                        this.using_temporal_operators(_t);
                                        _t = this._retTree;
                                        break;
                                    }
                                    case 3: {
                                        break;
                                    }
                                    default: {
                                        throw this.getNoViableAltException(_t);
                                    }
                                }
                                _t = __t224;
                                _t = _t.getNextSibling();
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        if (this.inputState.guessing() != 0) break block46;
                        try {
                            RfStructMember member = this.getTransientResult(RfStructMember.class, id);
                            if (member != null) {
                                RfDefElement def = this.getTransientScope(RfDefElement.class, sm);
                                LineInfo lineInfo = this.getMacroSafeLine(id);
                                member.performAdditionalSemanticChecks(this.rfp, def, lineInfo, this.parserPath);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block47;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void assume_struct_member(AST _t) throws RecognitionException {
        block47: {
            Runnable finalRunnable;
            block46: {
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST ses = null;
                AST id1 = null;
                AST nes = null;
                AST id2 = null;
                AST sm = null;
                AST id = null;
                try {
                    try {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 78: {
                                AST __t229 = _t;
                                ses = _t == ASTNULL ? null : _t;
                                this.match(_t, 78);
                                _t = _t.getFirstChild();
                                id1 = _t == ASTNULL ? null : _t;
                                this.identifier(_t);
                                _t = this._retTree;
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        sm = ses;
                                        id = id1;
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                                _t = __t229;
                                _t = _t.getNextSibling();
                                break;
                            }
                            case 79: {
                                AST __t230 = _t;
                                this.match(_t, 79);
                                _t = _t.getFirstChild();
                                this.temporal_expr(_t);
                                _t = this._retTree;
                                if (_t == null) {
                                    _t = ASTNULL;
                                }
                                switch (_t.getType()) {
                                    case 134: 
                                    case 135: {
                                        this.dut_error_action(_t);
                                        _t = this._retTree;
                                        break;
                                    }
                                    case 3: 
                                    case 187: {
                                        break;
                                    }
                                    default: {
                                        throw this.getNoViableAltException(_t);
                                    }
                                }
                                if (_t == null) {
                                    _t = ASTNULL;
                                }
                                switch (_t.getType()) {
                                    case 187: {
                                        this.using_temporal_operators(_t);
                                        _t = this._retTree;
                                        break;
                                    }
                                    case 3: {
                                        break;
                                    }
                                    default: {
                                        throw this.getNoViableAltException(_t);
                                    }
                                }
                                _t = __t230;
                                _t = _t.getNextSibling();
                                break;
                            }
                            case 80: {
                                AST __t233 = _t;
                                nes = _t == ASTNULL ? null : _t;
                                this.match(_t, 80);
                                _t = _t.getFirstChild();
                                id2 = _t == ASTNULL ? null : _t;
                                this.identifier(_t);
                                _t = this._retTree;
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        sm = nes;
                                        id = id2;
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                                this.expect_body(_t);
                                _t = this._retTree;
                                if (_t == null) {
                                    _t = ASTNULL;
                                }
                                switch (_t.getType()) {
                                    case 134: 
                                    case 135: {
                                        this.dut_error_action(_t);
                                        _t = this._retTree;
                                        break;
                                    }
                                    case 3: 
                                    case 187: {
                                        break;
                                    }
                                    default: {
                                        throw this.getNoViableAltException(_t);
                                    }
                                }
                                if (_t == null) {
                                    _t = ASTNULL;
                                }
                                switch (_t.getType()) {
                                    case 187: {
                                        this.using_temporal_operators(_t);
                                        _t = this._retTree;
                                        break;
                                    }
                                    case 3: {
                                        break;
                                    }
                                    default: {
                                        throw this.getNoViableAltException(_t);
                                    }
                                }
                                _t = __t233;
                                _t = _t.getNextSibling();
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        if (this.inputState.guessing() != 0) break block46;
                        try {
                            RfStructMember member = this.getTransientResult(RfStructMember.class, id);
                            if (member != null) {
                                RfDefElement def = this.getTransientScope(RfDefElement.class, sm);
                                LineInfo lineInfo = this.getMacroSafeLine(id);
                                member.performAdditionalSemanticChecks(this.rfp, def, lineInfo, this.parserPath);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block47;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void simulator_member(AST _t) throws RecognitionException {
        block24: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 82: {
                            this.simulator_specifier(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 85: {
                            this.verilog_code(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 86: {
                            this.verilog_function(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 89: {
                            this.verilog_task(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 95: {
                            this.verilog_variable(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 96: {
                            this.vhdl_code(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 97: {
                            this.vhdl_function(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 98: {
                            this.vhdl_driver(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 99: {
                            this.vhdl_procedure(_t);
                            _t = this._retTree;
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void vhdl_object(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t963 = _t;
                    this.match(_t, 48);
                    _t = _t.getFirstChild();
                    this.match(_t, 297);
                    _t = _t.getNextSibling();
                    _t = __t963;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void statement_block_scope_restore(AST _t) throws RecognitionException {
        block15: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            final Stack<RfDefElement> prevLastScopeLayerStack = new Stack<RfDefElement>();
            prevLastScopeLayerStack.addAll(this.lastScopeLayerStack);
            this.cleanAllScopes();
            if (this.inputState.guessing() == 0) {
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.lastScopeLayerStack = prevLastScopeLayerStack;
                    }
                };
            }
            try {
                try {
                    AST __t60 = _t;
                    this.match(_t, 8);
                    _t = _t.getFirstChild();
                    while (true) {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (!_tokenSet_0.member(_t.getType())) break;
                        this.statement(_t);
                        _t = this._retTree;
                    }
                    _t = __t60;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sln_action(AST _t) throws RecognitionException {
        block35: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST ss = null;
            AST id = null;
            if (this.inputState.guessing() == 0) {
                final int stackScopeSize = this.getLastScopeLayerStackSize();
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.cleanAllScopes(stackScopeSize);
                        SemanticWalker.this.packageName = SemanticWalker.this.preSLNComponentPackageName;
                    }
                };
            }
            try {
                try {
                    AST __t831 = _t;
                    ss = _t == ASTNULL ? null : _t;
                    this.match(_t, 435);
                    _t = _t.getFirstChild();
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 428: {
                            this.sln_abstract(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 293: 
                        case 429: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 429: {
                            this.sln_macro(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 293: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    id = _t == ASTNULL ? null : _t;
                    this.identifier(_t);
                    _t = this._retTree;
                    if (this.inputState.guessing() == 0) {
                        try {
                            RfStruct container;
                            if (id != null && (container = this.getTransientResult(RfStruct.class, id)) != null) {
                                this.preSLNComponentPackageName = this.packageName;
                                this.packageName = container.getPackageName();
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 32: {
                            this.like(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 51: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.pushScopeLayer(ss);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    this.sln_action_member_block(_t);
                    _t = this._retTree;
                    _t = __t831;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block35;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sln_child_struct_member(AST _t) throws RecognitionException {
        block22: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            RfNamedElement typeContainer = null;
            try {
                try {
                    AST __t711 = _t;
                    AST aST = _t == ASTNULL ? null : _t;
                    this.match(_t, 455);
                    _t = _t.getFirstChild();
                    this.identifier(_t);
                    _t = this._retTree;
                    typeContainer = this.field_type(_t);
                    _t = this._retTree;
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 462: {
                            this.sln_field_initial_constraints(_t, typeContainer);
                            _t = this._retTree;
                            break;
                        }
                        case 3: 
                        case 463: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 463: {
                            this.sln_field_keeping_constraints(_t, typeContainer);
                            _t = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t711;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sln_token_field_struct_member(AST _t) throws RecognitionException {
        block33: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST id = null;
            AST trg = null;
            RfNamedElement typeContainer = null;
            try {
                try {
                    AST __t707 = _t;
                    this.match(_t, 456);
                    _t = _t.getFirstChild();
                    id = _t == ASTNULL ? null : _t;
                    this.identifier(_t);
                    _t = this._retTree;
                    if (this.inputState.guessing() == 0) {
                        try {
                            typeContainer = this.getTransientResult(RfNamedElement.class, id);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    trg = _t == ASTNULL ? null : _t;
                    this.identifier(_t);
                    _t = this._retTree;
                    if (this.inputState.guessing() == 0) {
                        try {
                            RfDefElement def;
                            if (trg != null && (def = this.getTransientScope(RfDefElement.class, id)) != null) {
                                RfStruct slnComponent = this.getStruct();
                                if (slnComponent != null && !slnComponent.isSLNComponent()) {
                                    slnComponent = slnComponent.getSLNEnclosingComponent();
                                }
                                if (slnComponent != null) {
                                    RfField result = slnComponent.getField(trg.getText());
                                    if (result == null) {
                                        LineInfo lineInfo = this.getMacroSafeLine(trg);
                                        this.rfp.addSemanticError2(1, "UNDEFINED_IDENTIFIER: Identifier ''{0}'' is not defined", lineInfo.getOffset(), lineInfo.getOffset() + trg.getText().length(), null, lineInfo.line, this.parserPath, trg.getText());
                                    }
                                    this.setTransientResult(trg, result);
                                } else {
                                    LineInfo lineInfo = this.getMacroSafeLine(trg);
                                    this.rfp.addSemanticError2(1, "UNDEFINED_IDENTIFIER: Identifier ''{0}'' is not defined", lineInfo.getOffset(), lineInfo.getOffset() + trg.getText().length(), null, lineInfo.line, this.parserPath, trg.getText());
                                }
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 293: {
                            this.identifier(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 3: 
                        case 463: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 463: {
                            this.sln_field_keeping_constraints(_t, typeContainer);
                            _t = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t707;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block33;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sln_bind_struct_member(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1095 = _t;
                    this.match(_t, 457);
                    _t = _t.getFirstChild();
                    this.expr(_t);
                    _t = this._retTree;
                    _t = __t1095;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sln_constraint_struct_member(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1097 = _t;
                    this.match(_t, 458);
                    _t = _t.getFirstChild();
                    this.expr(_t);
                    _t = this._retTree;
                    _t = __t1097;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sln_constraint_default_struct_member(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1099 = _t;
                    this.match(_t, 459);
                    _t = _t.getFirstChild();
                    this.expr(_t);
                    _t = this._retTree;
                    _t = __t1099;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sln_constraint_default_disable_struct_member(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1101 = _t;
                    this.match(_t, 460);
                    _t = _t.getFirstChild();
                    this.expr(_t);
                    _t = this._retTree;
                    _t = __t1101;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sln_named_constraint_struct_member(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1103 = _t;
                    this.match(_t, 461);
                    _t = _t.getFirstChild();
                    this.identifier(_t);
                    _t = this._retTree;
                    this.expr_list(_t);
                    _t = this._retTree;
                    _t = __t1103;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sln_token_default_value_struct_member(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1105 = _t;
                    this.match(_t, 432);
                    _t = _t.getFirstChild();
                    this.expr(_t);
                    _t = this._retTree;
                    _t = __t1105;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sln_exec(AST _t) throws RecognitionException {
        block18: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 437: {
                            AST __t1107 = _t;
                            this.match(_t, 437);
                            _t = _t.getFirstChild();
                            this.expansion_literal_expr(_t);
                            _t = this._retTree;
                            _t = __t1107;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 438: {
                            AST __t1108 = _t;
                            this.match(_t, 438);
                            _t = _t.getFirstChild();
                            this.expansion_literal_expr(_t);
                            _t = this._retTree;
                            _t = __t1108;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 439: {
                            AST __t1109 = _t;
                            this.match(_t, 439);
                            _t = _t.getFirstChild();
                            this.identifier(_t);
                            _t = this._retTree;
                            this.parameter_list(_t);
                            _t = this._retTree;
                            this.expansion_literal_expr(_t);
                            _t = this._retTree;
                            _t = __t1109;
                            _t = _t.getNextSibling();
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sln_compound(AST _t) throws RecognitionException {
        block16: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST ab = null;
            final int stackScopeSize = this.getLastScopeLayerStackSize();
            if (this.inputState.guessing() == 0) {
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.cleanAllScopes(stackScopeSize);
                    }
                };
            }
            try {
                try {
                    AST __t167 = _t;
                    ab = _t == ASTNULL ? null : _t;
                    this.match(_t, 441);
                    _t = _t.getFirstChild();
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.pushScopeLayer(ab);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    this.sln_scd_list(_t);
                    _t = this._retTree;
                    _t = __t167;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sln_function_statement(AST _t) throws RecognitionException {
        block22: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t913 = _t;
                    this.match(_t, 492);
                    _t = _t.getFirstChild();
                    this.identifier(_t);
                    _t = this._retTree;
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 381: {
                            this.parameter_list(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 3: 
                        case 380: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 380: {
                            this.result_type(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t913;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sln_type_statement(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    this.type_statement(_t);
                    _t = this._retTree;
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sln_extend_type_statement(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    this.extend_type_statement(_t);
                    _t = this._retTree;
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sdl_inline_struct_member(AST _t) throws RecognitionException {
        block27: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1153 = _t;
                    this.match(_t, 498);
                    _t = _t.getFirstChild();
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 293: {
                            this.identifier(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 3: 
                        case 499: 
                        case 500: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 499: {
                            this.match(_t, 499);
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 3: 
                        case 500: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 500: {
                            this.match(_t, 500);
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t1153;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block27;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sdl_role_struct_member(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1158 = _t;
                    this.match(_t, 467);
                    _t = _t.getFirstChild();
                    this.identifier(_t);
                    _t = this._retTree;
                    _t = __t1158;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sdl_scenario_struct_member(AST _t) throws RecognitionException {
        block16: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST ss = null;
            if (this.inputState.guessing() == 0) {
                final int stackScopeSize = this.getLastScopeLayerStackSize();
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.cleanAllScopes(stackScopeSize);
                    }
                };
            }
            try {
                try {
                    AST __t841 = _t;
                    ss = _t == ASTNULL ? null : _t;
                    this.match(_t, 469);
                    _t = _t.getFirstChild();
                    this.identifier(_t);
                    _t = this._retTree;
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.pushScopeLayer(ss);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    this.sdl_scenario_member_block(_t);
                    _t = this._retTree;
                    _t = __t841;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sdl_extend_scenario_struct_member(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    this.extend_struct_statement(_t);
                    _t = this._retTree;
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sdl_do_struct_member(AST _t) throws RecognitionException {
        block24: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1179 = _t;
                    this.match(_t, 470);
                    _t = _t.getFirstChild();
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 376: {
                            this.match(_t, 376);
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 375: {
                            this.match(_t, 375);
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 377: {
                            this.match(_t, 377);
                            _t = _t.getNextSibling();
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 474: {
                            this.sdl_scenario_invocation(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 479: {
                            this.sdl_code_scenario_invocation(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 478: {
                            this.sdl_scenario_invocation_block(_t);
                            _t = this._retTree;
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t1179;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sdl_cover_expr(AST _t) throws RecognitionException {
        block17: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1164 = _t;
                    this.match(_t, 493);
                    _t = _t.getFirstChild();
                    this.expr(_t);
                    _t = this._retTree;
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 384: 
                        case 385: {
                            this.using_list(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t1164;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sdl_cover_cross(AST _t) throws RecognitionException {
        block17: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1167 = _t;
                    this.match(_t, 494);
                    _t = _t.getFirstChild();
                    this.cross_item_list(_t);
                    _t = this._retTree;
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 384: 
                        case 385: {
                            this.using_list(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t1167;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sdl_in(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1170 = _t;
                    this.match(_t, 482);
                    _t = _t.getFirstChild();
                    this.sdl_path_expr(_t);
                    _t = this._retTree;
                    this.sdl_scenario_invocation_block(_t);
                    _t = this._retTree;
                    _t = __t1170;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sdl_in_any(AST _t) throws RecognitionException {
        block22: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1172 = _t;
                    this.match(_t, 483);
                    _t = _t.getFirstChild();
                    this.type(_t);
                    _t = this._retTree;
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 473: {
                            this.sdl_path_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 183: 
                        case 184: 
                        case 188: 
                        case 189: 
                        case 191: 
                        case 192: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: 
                        case 198: 
                        case 199: 
                        case 200: 
                        case 201: 
                        case 202: 
                        case 203: 
                        case 204: 
                        case 205: 
                        case 206: 
                        case 207: 
                        case 208: 
                        case 209: 
                        case 210: 
                        case 211: 
                        case 212: 
                        case 213: 
                        case 214: 
                        case 215: 
                        case 216: 
                        case 217: 
                        case 218: 
                        case 219: 
                        case 220: 
                        case 221: 
                        case 222: 
                        case 223: 
                        case 224: 
                        case 225: 
                        case 226: 
                        case 227: 
                        case 228: 
                        case 229: 
                        case 230: 
                        case 231: 
                        case 232: 
                        case 233: 
                        case 234: 
                        case 235: 
                        case 236: 
                        case 237: 
                        case 238: 
                        case 239: 
                        case 240: 
                        case 241: 
                        case 242: 
                        case 243: 
                        case 244: 
                        case 245: 
                        case 246: 
                        case 251: 
                        case 252: 
                        case 256: 
                        case 259: 
                        case 260: 
                        case 261: 
                        case 262: 
                        case 263: 
                        case 264: 
                        case 265: 
                        case 266: 
                        case 267: 
                        case 268: 
                        case 269: 
                        case 277: 
                        case 278: 
                        case 279: 
                        case 280: 
                        case 281: 
                        case 282: 
                        case 283: 
                        case 284: 
                        case 285: 
                        case 286: 
                        case 287: 
                        case 288: 
                        case 292: 
                        case 293: 
                        case 294: 
                        case 295: 
                        case 296: 
                        case 297: 
                        case 298: 
                        case 299: 
                        case 300: 
                        case 301: 
                        case 302: 
                        case 303: 
                        case 304: 
                        case 305: 
                        case 306: 
                        case 307: 
                        case 308: 
                        case 309: 
                        case 310: 
                        case 311: 
                        case 312: 
                        case 313: 
                        case 314: 
                        case 315: 
                        case 316: 
                        case 317: 
                        case 318: 
                        case 319: 
                        case 320: 
                        case 321: 
                        case 322: 
                        case 323: 
                        case 369: 
                        case 411: 
                        case 416: 
                        case 417: 
                        case 464: 
                        case 478: 
                        case 497: 
                        case 506: 
                        case 507: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 183: 
                        case 184: 
                        case 188: 
                        case 189: 
                        case 191: 
                        case 192: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: 
                        case 198: 
                        case 199: 
                        case 200: 
                        case 201: 
                        case 202: 
                        case 203: 
                        case 204: 
                        case 205: 
                        case 206: 
                        case 207: 
                        case 208: 
                        case 209: 
                        case 210: 
                        case 211: 
                        case 212: 
                        case 213: 
                        case 214: 
                        case 215: 
                        case 216: 
                        case 217: 
                        case 218: 
                        case 219: 
                        case 220: 
                        case 221: 
                        case 222: 
                        case 223: 
                        case 224: 
                        case 225: 
                        case 226: 
                        case 227: 
                        case 228: 
                        case 229: 
                        case 230: 
                        case 231: 
                        case 232: 
                        case 233: 
                        case 234: 
                        case 235: 
                        case 236: 
                        case 237: 
                        case 238: 
                        case 239: 
                        case 240: 
                        case 241: 
                        case 242: 
                        case 243: 
                        case 244: 
                        case 245: 
                        case 246: 
                        case 251: 
                        case 252: 
                        case 256: 
                        case 259: 
                        case 260: 
                        case 261: 
                        case 262: 
                        case 263: 
                        case 264: 
                        case 265: 
                        case 266: 
                        case 267: 
                        case 268: 
                        case 269: 
                        case 277: 
                        case 278: 
                        case 279: 
                        case 280: 
                        case 281: 
                        case 282: 
                        case 283: 
                        case 284: 
                        case 285: 
                        case 286: 
                        case 287: 
                        case 288: 
                        case 292: 
                        case 293: 
                        case 294: 
                        case 295: 
                        case 296: 
                        case 297: 
                        case 298: 
                        case 299: 
                        case 300: 
                        case 301: 
                        case 302: 
                        case 303: 
                        case 304: 
                        case 305: 
                        case 306: 
                        case 307: 
                        case 308: 
                        case 309: 
                        case 310: 
                        case 311: 
                        case 312: 
                        case 313: 
                        case 314: 
                        case 315: 
                        case 316: 
                        case 317: 
                        case 318: 
                        case 319: 
                        case 320: 
                        case 321: 
                        case 322: 
                        case 323: 
                        case 369: 
                        case 411: 
                        case 416: 
                        case 417: 
                        case 464: 
                        case 497: 
                        case 506: 
                        case 507: {
                            this.expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 478: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    this.sdl_scenario_invocation_block(_t);
                    _t = this._retTree;
                    _t = __t1172;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sdl_mix(AST _t) throws RecognitionException {
        block17: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1176 = _t;
                    this.match(_t, 484);
                    _t = _t.getFirstChild();
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 474: {
                            this.sdl_scenario_invocation(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 479: {
                            this.sdl_code_scenario_invocation(_t);
                            _t = this._retTree;
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t1176;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void statement(AST _t) throws RecognitionException {
        block64: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 8: {
                            this.statement_block(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 9: {
                            this.preproc_define_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 10: {
                            this.preproc_undef_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 11: {
                            this.preproc_ifdef_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 12: {
                            this.preproc_ifndef_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 13: {
                            this.define_as_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 14: {
                            this.define_as_computed_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 17: {
                            this.user_defined_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 18: {
                            this.as_computed_user_defined_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 19: {
                            this.package_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 21: {
                            this.regular_import_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 22: {
                            this.cyclic_import_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 23: {
                            this.verilog_import_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 26: {
                            this.annotation_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 27: {
                            this.type_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 30: {
                            this.interface_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 31: {
                            this.interface_template_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 28: {
                            this.struct_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 413: {
                            this.struct_template_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 29: {
                            this.unit_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 414: {
                            this.unit_template_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 49: {
                            this.numeric_type_template_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 34: {
                            this.extend_type_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 37: {
                            this.extend_struct_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 38: {
                            this.extend_template_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 41: {
                            this.sequence_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 42: {
                            this.sequence_template_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 43: {
                            this.c_routine_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 44: {
                            this.c_export_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 45: {
                            this.method_type_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 46: {
                            this.verilog_time_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 47: {
                            this.vhdl_time_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 82: 
                        case 85: 
                        case 86: 
                        case 89: 
                        case 95: 
                        case 96: 
                        case 97: 
                        case 98: 
                        case 99: {
                            this.simulator_member(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 20: {
                            this.port_attribute_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 48: {
                            this.vhdl_object(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 415: {
                            this.match(_t, 415);
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 50: {
                            this.method_export_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 427: {
                            this.sln_preproc_trace_table_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 465: {
                            this.sln_table_define_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 430: {
                            this.sln_const_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 431: {
                            this.sln_token_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 433: {
                            this.sln_component_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 492: {
                            this.sln_function_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 435: {
                            this.sln_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 467: {
                            this.sdl_role_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 468: {
                            this.sdl_agent_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 469: {
                            this.sdl_scenario_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 502: {
                            this.sdl_tool_define_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 503: {
                            this.sdl_tool_direct_execution_statement(_t);
                            _t = this._retTree;
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block64;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void struct_qualifier(AST _t, List<String> determinantParts) throws RecognitionException {
        block35: {
            Runnable finalRunnable;
            block34: {
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST sq = null;
                AST id1 = null;
                AST id2 = null;
                StringBuilder determinantPart = new StringBuilder();
                try {
                    try {
                        AST __t294 = _t;
                        sq = _t == ASTNULL ? null : _t;
                        this.match(_t, 40);
                        _t = _t.getFirstChild();
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 299: {
                                this.match(_t, 299);
                                _t = _t.getNextSibling();
                                if (this.inputState.guessing() != 0) break;
                                try {
                                    determinantPart.append("TRUE");
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                                break;
                            }
                            case 300: {
                                this.match(_t, 300);
                                _t = _t.getNextSibling();
                                if (this.inputState.guessing() != 0) break;
                                try {
                                    determinantPart.append("FALSE");
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                                break;
                            }
                            case 293: {
                                id1 = _t == ASTNULL ? null : _t;
                                this.identifier(_t);
                                _t = this._retTree;
                                if (this.inputState.guessing() != 0) break;
                                try {
                                    if (id1 == null) break;
                                    determinantPart.append(id1.getText());
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 293: {
                                id2 = _t == ASTNULL ? null : _t;
                                this.identifier(_t);
                                _t = this._retTree;
                                if (this.inputState.guessing() != 0) break;
                                try {
                                    if (id2 == null) break;
                                    determinantPart.append("'").append(id2.getText());
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        _t = __t294;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block34;
                        try {
                            String determinantPartText = determinantPart.toString();
                            if (determinantParts != null) {
                                determinantParts.add(determinantPartText);
                            }
                            if (sq != null) {
                                sq.setText(determinantPartText);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block35;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final RfNamedElement qualified_type(AST _t) throws RecognitionException {
        RfNamedElement result;
        block15: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST qt = null;
            try {
                try {
                    AST __t317 = _t;
                    qt = _t == ASTNULL ? null : _t;
                    this.match(_t, 409);
                    _t = _t.getFirstChild();
                    this.identifier(_t);
                    _t = this._retTree;
                    this.identifier(_t);
                    _t = this._retTree;
                    _t = __t317;
                    _t = _t.getNextSibling();
                    if (this.inputState.guessing() == 0) {
                        try {
                            result = this.getTransientResult(RfNamedElement.class, qt);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final void extend_struct_statement(AST _t) throws RecognitionException {
        block13: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            final int stackScopeSize = this.getLastScopeLayerStackSize();
            if (this.inputState.guessing() == 0) {
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.cleanAllScopes(stackScopeSize);
                    }
                };
            }
            try {
                try {
                    AST __t69 = _t;
                    this.match(_t, 37);
                    _t = _t.getFirstChild();
                    this.extend_struct_type(_t);
                    _t = this._retTree;
                    this.struct_member_block(_t);
                    _t = this._retTree;
                    _t = __t69;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void extend_struct_type(AST _t) throws RecognitionException {
        block37: {
            Runnable finalRunnable;
            block36: {
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST ss = null;
                AST sq = null;
                ArrayList<AST> sqs = new ArrayList<AST>();
                try {
                    try {
                        AST __t86 = _t;
                        ss = _t == ASTNULL ? null : _t;
                        this.match(_t, 39);
                        _t = _t.getFirstChild();
                        while (true) {
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            if (_t.getType() != 40) break;
                            sq = _t == ASTNULL ? null : _t;
                            this.struct_qualifier(_t, null);
                            _t = this._retTree;
                            if (this.inputState.guessing() != 0) continue;
                            try {
                                sqs.add(sq);
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 293: {
                                this.identifier(_t);
                                _t = this._retTree;
                                break;
                            }
                            case 409: {
                                this.qualified_type(_t);
                                _t = this._retTree;
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        boolean synPredMatched92 = false;
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (_tokenSet_10.member(_t.getType())) {
                            AST __t92 = _t;
                            synPredMatched92 = true;
                            this.inputState.incGuessing();
                            try {
                                this.template_parameters(_t, null);
                                _t = this._retTree;
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched92 = false;
                            }
                            _t = __t92;
                            this.inputState.decGuessing(synPredMatched92);
                        }
                        if (synPredMatched92) {
                            this.template_parameters(_t, null);
                            _t = this._retTree;
                        } else if (_t.getType() != 3 && _t.getType() != 33) {
                            throw this.getNoViableAltException(_t);
                        }
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 33: {
                                this.implementing(_t);
                                _t = this._retTree;
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        _t = __t86;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block36;
                        try {
                            RfStruct struct;
                            this.pushScopeLayer(ss);
                            RfStructLayer def = this.getTransientScope(RfStructLayer.class, ss);
                            if (def != null && (struct = def.getStruct()) != null) {
                                Determinant determinant = new Determinant(new String[]{struct.getName()});
                                int i = sqs.size() - 1;
                                while (i >= 0) {
                                    AST qualifierAST = (AST)sqs.get(i);
                                    RfStructQualifier structQualifier = this.struct_qualifier_check(qualifierAST, struct, determinant);
                                    def.addStructQualifier(structQualifier);
                                    determinant = new Determinant(new String[]{qualifierAST.getText()}, determinant.toArray());
                                    --i;
                                }
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block37;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void extend_template_statement(AST _t) throws RecognitionException {
        block21: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            if (this.inputState.guessing() == 0) {
                this.cleanAllScopes();
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.rfp.setSemanticInTemplateDefinition(null);
                        SemanticWalker.this.cleanAllScopes();
                    }
                };
            }
            try {
                try {
                    AST __t71 = _t;
                    this.match(_t, 38);
                    _t = _t.getFirstChild();
                    this.extend_struct_type(_t);
                    _t = this._retTree;
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.rfp.setSemanticInTemplateDefinition(this.getStruct());
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 188: {
                            this.extend_template_conditions(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 51: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    this.struct_member_block(_t);
                    _t = this._retTree;
                    _t = __t71;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void extend_template_conditions(AST _t) throws RecognitionException {
        block14: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t74 = _t;
                    this.match(_t, 188);
                    _t = _t.getFirstChild();
                    while (true) {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (!_tokenSet_4.member(_t.getType())) break;
                        this.expr(_t);
                        _t = this._retTree;
                    }
                    _t = __t74;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sequence_template_statement(AST _t) throws RecognitionException {
        block26: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST ss = null;
            if (this.inputState.guessing() == 0) {
                this.cleanAllScopes();
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.rfp.setSemanticInTemplateDefinition(null);
                        SemanticWalker.this.cleanAllScopes();
                    }
                };
            }
            try {
                try {
                    AST __t78 = _t;
                    ss = _t == ASTNULL ? null : _t;
                    this.match(_t, 42);
                    _t = _t.getFirstChild();
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 361: {
                            this.statement_encap(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 293: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    this.identifier(_t);
                    _t = this._retTree;
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.pushScopeLayer(ss);
                            this.rfp.setSemanticInTemplateDefinition(this.getStruct());
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    this.template_parameters(_t, null);
                    _t = this._retTree;
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 384: 
                        case 385: {
                            this.using_list(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t78;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void using_list(AST _t, RfNamedElement lhScope, AST scope, Map<String, Object> using) throws RecognitionException {
        block23: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            RfNamedElement[] perUnitInstance = new RfNamedElement[1];
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 384: {
                            AST __t798 = _t;
                            this.match(_t, 384);
                            _t = _t.getFirstChild();
                            int _cnt800 = 0;
                            while (true) {
                                if (_t == null) {
                                    _t = ASTNULL;
                                }
                                if (_t.getType() < 386 || _t.getType() > 388) {
                                    if (_cnt800 >= 1) break;
                                    throw this.getNoViableAltException(_t);
                                }
                                this.option(_t, lhScope, perUnitInstance, using);
                                _t = this._retTree;
                                ++_cnt800;
                            }
                            _t = __t798;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 385: {
                            AST __t801 = _t;
                            this.match(_t, 385);
                            _t = _t.getFirstChild();
                            int _cnt803 = 0;
                            while (true) {
                                if (_t == null) {
                                    _t = ASTNULL;
                                }
                                if (_t.getType() < 386 || _t.getType() > 388) {
                                    if (_cnt803 >= 1) break;
                                    throw this.getNoViableAltException(_t);
                                }
                                this.option(_t, lhScope, perUnitInstance, using);
                                _t = this._retTree;
                                ++_cnt803;
                            }
                            _t = __t801;
                            _t = _t.getNextSibling();
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sln_scd_constraint(AST _t) throws RecognitionException {
        block26: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST csm = null;
            final int stackScopeSize = this.getLastScopeLayerStackSize();
            if (this.inputState.guessing() == 0) {
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.cleanAllScopes(stackScopeSize);
                    }
                };
            }
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 450: {
                            AST __t82 = _t;
                            this.match(_t, 450);
                            _t = _t.getFirstChild();
                            this.expr(_t);
                            _t = this._retTree;
                            _t = __t82;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 451: {
                            AST __t83 = _t;
                            csm = _t == ASTNULL ? null : _t;
                            this.match(_t, 451);
                            _t = _t.getFirstChild();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    this.pushScopeLayer(csm);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            switch (_t.getType()) {
                                case 293: {
                                    this.identifier(_t);
                                    _t = this._retTree;
                                    break;
                                }
                                case 110: {
                                    this.sln_scd_any_type(_t);
                                    _t = this._retTree;
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltException(_t);
                                }
                            }
                            this.expr_list(_t);
                            _t = this._retTree;
                            _t = __t83;
                            _t = _t.getNextSibling();
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sln_scd_any_type(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1142 = _t;
                    this.match(_t, 110);
                    _t = _t.getFirstChild();
                    this.type(_t);
                    _t = this._retTree;
                    _t = __t1142;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    /*
     * Unable to fully structure code
     */
    public final void expr_list(AST _t, AST methodCallAST, RfNamedElement lhScope, Set<String> allowIds) throws RecognitionException {
        block84: {
            if (_t == SemanticWalker.ASTNULL) {
                // empty if block
            }
            finalRunnable = null;
            id = null;
            tp = null;
            exp2 = null;
            argumentNumber = 0;
            nofRequiredMinArgs = 0;
            nofRequiredMaxArgs = 0;
            result = null;
            arguments = null;
            portTypeName = null;
            portTypeOf = null;
            keyIndex = null;
            isType = false;
            if (lhScope instanceof RfPredefinedMethod && ((RfMethod)lhScope).isIgnoreArgs() && !"do_bind".equals(lhScope.getName()) && !"bind".equals(lhScope.getName())) {
                lhScope = SemanticWalker.ERROR_SCOPE;
            } else if (lhScope instanceof RfMethod) {
                arguments = ((RfMethod)lhScope).getArguments(this.importedByTest);
                v0 = prevMethodDeclaration = lhScope instanceof RfPredefinedMethod != false ? null : ((RfMethod)lhScope).getFirstLayerOfMethodInLikeParent();
                if (!((RfMethod)lhScope).isDisabledArgsCheck()) {
                    if (arguments == null || arguments.isEmpty()) {
                        nofRequiredMinArgs = 0;
                        nofRequiredMaxArgs = 0;
                    } else {
                        for (RfArg argument : arguments) {
                            if (argument instanceof RfPredefinedArg && ((RfPredefinedArg)argument).getDefaultValue() != null || prevMethodDeclaration instanceof RfMethodLayer && (prevArg = ((RfMethodLayer)prevMethodDeclaration).getArgumentWithPrefix(2, argument.getName())) != null && prevArg.getDeclaration() instanceof RfArgLayer && ((RfArgLayer)prevArg.getDeclaration()).getDefaultValue() != null || (argDeclaration = argument.getDeclaration()) instanceof RfArgLayer && ((RfArgLayer)argDeclaration).getDefaultValue() != null) continue;
                            ++nofRequiredMinArgs;
                        }
                        nofRequiredMaxArgs = arguments.size();
                    }
                }
            }
            try {
                try {
                    if (_t == null) {
                        _t = SemanticWalker.ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 185: {
                            this.preproc_ifdef_expr(_t, lhScope);
                            _t = this._retTree;
                            break;
                        }
                        case 186: {
                            this.preproc_ifndef_expr(_t, lhScope);
                            _t = this._retTree;
                            break;
                        }
                        case 187: {
                            __t339 = _t;
                            v1 = _t == SemanticWalker.ASTNULL ? null : _t;
                            this.match(_t, 187);
                            _t = _t.getFirstChild();
                            while (true) {
                                synPredMatched342 = false;
                                if (_t == null) {
                                    _t = SemanticWalker.ASTNULL;
                                }
                                if (_t.getType() == 293) {
                                    __t342 = _t;
                                    synPredMatched342 = true;
                                    this.inputState.incGuessing();
                                    try {
                                        if (!(lhScope instanceof RfDummyMethod || _t != null && allowIds != null && allowIds.contains(_t.getText()))) {
                                            throw this.getSemanticException(" (/*messagef limitation*/lhScope instanceof RfDummyMethod) || (_t != null && allowIds != null && allowIds.contains(_t.getText())) ");
                                        }
                                        this.identifier(_t);
                                        _t = this._retTree;
                                    }
                                    catch (RecognitionException v2) {
                                        synPredMatched342 = false;
                                    }
                                    _t = __t342;
                                    this.inputState.decGuessing(synPredMatched342);
                                }
                                if (synPredMatched342) {
                                    this.identifier(_t);
                                    _t = this._retTree;
                                    if (this.inputState.guessing() != 0) continue;
                                    try {
                                        ++argumentNumber;
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                    continue;
                                }
                                synPredMatched344 = false;
                                if (_t == null) {
                                    _t = SemanticWalker.ASTNULL;
                                }
                                if (_t.getType() == 293) {
                                    __t344 = _t;
                                    synPredMatched344 = true;
                                    this.inputState.incGuessing();
                                    try {
                                        if (_t == null || !(lhScope instanceof RfPredefinedMethod) || !"sort_by_field".equals(lhScope.getName())) {
                                            throw this.getSemanticException(" _t != null && lhScope instanceof RfPredefinedMethod && \"sort_by_field\".equals(lhScope.getName()) ");
                                        }
                                        this.identifier(_t);
                                        _t = this._retTree;
                                    }
                                    catch (RecognitionException v3) {
                                        synPredMatched344 = false;
                                    }
                                    _t = __t344;
                                    this.inputState.decGuessing(synPredMatched344);
                                }
                                if (synPredMatched344) {
                                    id = _t == SemanticWalker.ASTNULL ? null : _t;
                                    this.identifier(_t);
                                    _t = this._retTree;
                                    if (this.inputState.guessing() != 0) continue;
                                    try {
                                        ++argumentNumber;
                                        if (id == null || !(lhScope instanceof RfMethod) || lhScope == SemanticWalker.ERROR_SCOPE) continue;
                                        parentStruct = ((RfMethod)lhScope).getParentStruct();
                                        if (parentStruct instanceof RfListType && (assocType = ((RfListType)parentStruct).getAssociatedType()) instanceof RfStruct) {
                                            result = ((RfStruct)assocType).getField(new FullName(id.getText(), parentStruct.getDeterminant()));
                                            this.setTransientResult(id, new RfWNamedElementAndScope(result, assocType, true));
                                        }
                                        if (result != null) continue;
                                        lineInfo = this.getMacroSafeLine(id);
                                        this.rfp.addSemanticError2(1, "UNDEFINED_IDENTIFIER: Identifier ''{0}'' is not defined", lineInfo.getOffset(), lineInfo.getOffset() + id.getText().length(), null, lineInfo.line, this.parserPath, new Object[]{id.getText()});
                                        result = SemanticWalker.ERROR_SCOPE;
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                    continue;
                                }
                                if (!SemanticWalker._tokenSet_11.member(_t.getType())) ** GOTO lbl249
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        if (lhScope == SemanticWalker.ERROR_SCOPE) {
                                            result = SemanticWalker.ERROR_SCOPE;
                                        } else if (lhScope instanceof RfPredefinedMethod && ((RfMethod)lhScope).getEnclosingScope() instanceof RfListType && ("key".equals(lhScope.getName()) || "key_exists".equals(lhScope.getName()) || "key_index".equals(lhScope.getName()))) {
                                            listScope = (RfListType)((RfMethod)lhScope).getEnclosingScope();
                                            keyName = listScope.getAssociatedTypeListKey();
                                            if (keyName != null) {
                                                assocType = listScope.getAssociatedType();
                                                if (assocType instanceof RfStruct) {
                                                    assocDeterminant = listScope.getAssociatedTypeDeterminant();
                                                    result = "it".equals(keyName) ? new RfDummyField(this.rfp, (IRfNamedElement)assocType, assocDeterminant) : ((RfStruct)assocType).getField(new FullName(keyName, assocDeterminant));
                                                } else if (assocType instanceof RfScalarType && ((RfScalarType)assocType).isEnumType()) {
                                                    result = "it".equals(keyName) != false ? new RfDummyField(this.rfp, assocType) : ((RfScalarType)assocType).getEnum(this.rfp, keyName, this.moduleIndex, this.parserPath);
                                                }
                                                keyIndex = result;
                                            }
                                        } else if (lhScope instanceof RfMethod) {
                                            result = null;
                                            if (arguments != null && arguments.size() > argumentNumber) {
                                                result = arguments.get(argumentNumber);
                                            }
                                        } else {
                                            result = lhScope;
                                        }
                                        if (arguments != null && arguments.size() > argumentNumber && arguments.get(argumentNumber) instanceof RfPredefinedArg) {
                                            rfArg = arguments.get(argumentNumber);
                                            isType = rfArg.getName().contains("type_name") != false && (rfArg.getAssociatedBaseType() == null || rfArg.getAssociatedBaseType().getName().contains("type_name") != false);
                                        }
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                                synPredMatched347 = false;
                                if (_t == null) {
                                    _t = SemanticWalker.ASTNULL;
                                }
                                if (SemanticWalker._tokenSet_12.member(_t.getType()) && isType) {
                                    __t347 = _t;
                                    synPredMatched347 = true;
                                    this.inputState.incGuessing();
                                    try {
                                        this.type(_t);
                                        _t = this._retTree;
                                    }
                                    catch (RecognitionException v4) {
                                        synPredMatched347 = false;
                                    }
                                    _t = __t347;
                                    this.inputState.decGuessing(synPredMatched347);
                                }
                                if (synPredMatched347) {
                                    tp = _t == SemanticWalker.ASTNULL ? null : _t;
                                    result = this.type(_t);
                                    _t = this._retTree;
                                    if (this.inputState.guessing() == 0) {
                                        try {
                                            if (tp != null && tp.getType() == 293) {
                                                lineInfo = this.getMacroSafeLine(tp);
                                                result = this.rfp.getType(this.packageName, null, 1, tp.getText(), this.maxModuleIndex, this.parserPath, null, lineInfo);
                                                this.module.createTypeDependency(this.rfp, result, tp.getText());
                                                this.setTransientResult(tp, new RfDummyField(this.rfp, result));
                                            }
                                            exp2 = tp;
                                        }
                                        catch (Exception ex) {
                                            this.userExceptionHandler(ex);
                                        }
                                    }
                                } else if (SemanticWalker._tokenSet_4.member(_t.getType())) {
                                    exp2 = _t == SemanticWalker.ASTNULL ? null : _t;
                                    result = this.expr(_t, result);
                                    _t = this._retTree;
                                } else {
                                    throw this.getNoViableAltException(_t);
                                }
                                if (this.inputState.guessing() != 0) continue;
                                try {
                                    ++argumentNumber;
                                    if (exp2 == null || !(lhScope instanceof RfDummyField) || !"apply_container".equals(lhScope.getName())) ** GOTO lbl191
                                    this.specialMethodReturnType(this.rfp, (RfDummyField)lhScope, exp2, result);
                                    ** GOTO lbl236
lbl191:
                                    // 1 sources

                                    if (exp2 == null || !(lhScope instanceof RfPredefinedMethod) || ((RfMethod)lhScope).getParentStruct() != this.GLOBAL_TYPE || !"do_bind".equals(lhScope.getName()) && !"bind".equals(lhScope.getName())) ** GOTO lbl236
                                    lineInfo = this.getTreeLineInfo(exp2);
                                    if (result == null || !this.valid(result)) ** GOTO lbl236
                                    assocType = (RfType)((IRfAssociatedType)result).getAssociatedType();
                                    if (this.isPortAssocType(assocType)) ** GOTO lbl199
                                    this.rfp.addSemanticError1(1, "BIND_ARG_PORT_TYPE: Argument {0} of ''{1}()'' method must be a port", lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, this.parserPath, new Object[]{argumentNumber, lhScope.getName()});
                                    ** GOTO lbl236
lbl199:
                                    // 1 sources

                                    if (portTypeName != null || !(assocType instanceof RfTemplateStructInstance)) ** GOTO lbl203
                                    portTypeOf = ((RfTemplateStructInstance)assocType).getParameters();
                                    portTypeName = assocType.getName();
                                    ** GOTO lbl236
lbl203:
                                    // 1 sources

                                    if (portTypeName != null || !(assocType instanceof RfPredefinedStruct)) ** GOTO lbl206
                                    portTypeName = assocType.getName();
                                    ** GOTO lbl236
lbl206:
                                    // 1 sources

                                    if (!(assocType instanceof RfTemplateStructInstance)) ** GOTO lbl228
                                    portTypeOf2 = ((RfTemplateStructInstance)assocType).getParameters();
                                    portTypeName2 = assocType.getName();
                                    if (portTypeName == null || portTypeName.equals(portTypeName2)) ** GOTO lbl213
                                    this.rfp.addSemanticError1(1, "BIND_ARGS_PORT_KIND: Different kinds of ports cannot be bound to each other", lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, this.parserPath, new Object[]{argumentNumber, lhScope.getName()});
                                    ** GOTO lbl236
lbl213:
                                    // 1 sources

                                    if (portTypeOf == null || portTypeOf2 == null) ** GOTO lbl236
                                    i = 0;
                                    while (i < portTypeOf.size()) {
                                        portType1 = portTypeOf.get(i);
                                        portType2 = portTypeOf2.get(i);
                                        if (portType1 == null || portType2 == null) ** GOTO lbl225
                                        portTypeOfName = portType1.getAssociatedTypeName();
                                        portTypeOfName2 = portType2.getAssociatedTypeName();
                                        if (portTypeOfName == null || portTypeOfName.equals(portTypeOfName2)) ** GOTO lbl225
                                        this.rfp.addSemanticError1(1, "BIND_ARGS_PORT_ELEM: Ports with associated element types that do not agree cannot be bound", lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, this.parserPath, new Object[]{argumentNumber, lhScope.getName()});
                                        ** GOTO lbl236
lbl225:
                                        // 2 sources

                                        ++i;
                                    }
                                    ** GOTO lbl236
lbl228:
                                    // 1 sources

                                    if (assocType instanceof RfPredefinedStruct) {
                                        portTypeName2 = assocType.getName();
                                        if (portTypeName != null && !portTypeName.equals(portTypeName2)) {
                                            this.rfp.addSemanticError1(1, "BIND_ARGS_PORT_KIND: Different kinds of ports cannot be bound to each other", lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, this.parserPath, new Object[]{argumentNumber, lhScope.getName()});
                                        }
                                    } else {
                                        this.rfp.addSemanticError1(1, "BIND_ARGS_PORT_KIND: Different kinds of ports cannot be bound to each other", lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, this.parserPath, new Object[]{argumentNumber, lhScope.getName()});
                                    }
lbl236:
                                    // 12 sources

                                    if (exp2 != null && exp2.getType() == 266) {
                                        this.setTransientResult(exp2, result);
                                    }
                                    if (exp2 == null || !(lhScope instanceof RfMethod) || arguments == null || arguments.size() <= argumentNumber - 1) continue;
                                    if (lhScope instanceof RfPredefinedMethod && ((RfMethod)lhScope).getEnclosingScope() instanceof RfListType && ("key".equals(lhScope.getName()) || "key_exists".equals(lhScope.getName()) || "key_index".equals(lhScope.getName()))) {
                                        SemanticUtils.incompatibleAssign(this.rfp, this.parserPath, this.macroDepth, this.macroLineInfo, exp2, exp2, keyIndex, result, SemanticUtils.AssignKind.ARGUMENT);
                                        continue;
                                    }
                                    SemanticUtils.incompatibleAssign(this.rfp, this.parserPath, this.macroDepth, this.macroLineInfo, exp2, exp2, arguments.get(argumentNumber - 1), result, SemanticUtils.AssignKind.ARGUMENT);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                                continue;
lbl249:
                                // 1 sources

                                if (_t.getType() < 185 || _t.getType() > 187) break;
                                this.expr_list(_t, methodCallAST, result, allowIds);
                                _t = this._retTree;
                            }
                            _t = __t339;
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() != 0) break;
                            try {
                                if (lhScope instanceof RfPredefinedMethod && ((RfMethod)lhScope).getParentStruct() == this.GLOBAL_TYPE && ("do_bind".equals(lhScope.getName()) || "bind".equals(lhScope.getName()))) {
                                    if (exp2 != null && argumentNumber != 2) {
                                        lineInfo = this.getTreeLineInfo(exp2);
                                        this.rfp.addSemanticError1(1, "BIND_ARG_COUNT: Wrong number of arguments for ''{0}()'', must be exactly 2", lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, this.parserPath, new Object[]{lhScope.getName()});
                                    }
                                    break;
                                }
                                if (lhScope instanceof RfPredefinedMethod && "get_config".equals(lhScope.getName()) || !(lhScope instanceof RfMethod) || ((RfMethod)lhScope).isDisabledArgsCheck() || !this.rfp.isEnableExtendedSemanticChecks() || (methodCallAST == null || argumentNumber >= nofRequiredMinArgs) && argumentNumber <= nofRequiredMaxArgs) break;
                                lineInfo = this.getTreeLineInfo(methodCallAST);
                                if (nofRequiredMinArgs == nofRequiredMaxArgs) {
                                    this.rfp.addSemanticError1(1, "METHOD_CALL_ARGUMENTS: Expecting ''{1}'' argument{1,choice,0#s|1#|1<s} when calling ''{0}'', found ''{2}''", lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, this.parserPath, new Object[]{lhScope.getName(), nofRequiredMinArgs, argumentNumber});
                                    break;
                                }
                                if (argumentNumber < nofRequiredMinArgs) {
                                    this.rfp.addSemanticError1(1, "METHOD_CALL_ARGUMENTS: Expecting minimum ''{1}'' argument{1,choice,0#s|1#|1<s} when calling ''{0}'', found ''{2}''", lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, this.parserPath, new Object[]{lhScope.getName(), nofRequiredMinArgs, argumentNumber});
                                    break;
                                }
                                this.rfp.addSemanticError1(1, "METHOD_CALL_ARGUMENTS: Expecting maximum ''{1}'' argument{1,choice,0#s|1#|1<s} when calling ''{0}'', found ''{2}''", lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, this.parserPath, new Object[]{lhScope.getName(), nofRequiredMaxArgs, argumentNumber});
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block84;
                }
            }
            catch (Throwable var31_49) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw var31_49;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void parameter_list(AST _t) throws RecognitionException {
        block14: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1023 = _t;
                    this.match(_t, 381);
                    _t = _t.getFirstChild();
                    while (true) {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (_t.getType() != 382) break;
                        this.parameter(_t);
                        _t = this._retTree;
                    }
                    _t = __t1023;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final RfNamedElement result_type(AST _t) throws RecognitionException {
        RfNamedElement result;
        block15: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST rt = null;
            try {
                try {
                    AST __t103 = _t;
                    rt = _t == ASTNULL ? null : _t;
                    this.match(_t, 380);
                    _t = _t.getFirstChild();
                    this.type(_t);
                    _t = this._retTree;
                    _t = __t103;
                    _t = _t.getNextSibling();
                    if (this.inputState.guessing() == 0) {
                        try {
                            result = this.getTransientResult(RfNamedElement.class, rt);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final void method_body(AST _t) throws RecognitionException {
        block43: {
            Runnable finalRunnable;
            block42: {
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                try {
                    try {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 371: {
                                this.match(_t, 371);
                                _t = _t.getNextSibling();
                                break;
                            }
                            case 372: {
                                this.match(_t, 372);
                                _t = _t.getNextSibling();
                                break;
                            }
                            case 373: {
                                this.match(_t, 373);
                                _t = _t.getNextSibling();
                                this.action_block(_t);
                                _t = this._retTree;
                                break;
                            }
                            case 374: {
                                this.match(_t, 374);
                                _t = _t.getNextSibling();
                                this.action_block(_t);
                                _t = this._retTree;
                                break;
                            }
                            case 375: {
                                this.match(_t, 375);
                                _t = _t.getNextSibling();
                                if (_t == null) {
                                    _t = ASTNULL;
                                }
                                switch (_t.getType()) {
                                    case 100: {
                                        this.action_block(_t);
                                        _t = this._retTree;
                                        break block42;
                                    }
                                    case 406: {
                                        this.dynamic_c_routine(_t);
                                        _t = this._retTree;
                                        break block42;
                                    }
                                    default: {
                                        throw this.getNoViableAltException(_t);
                                    }
                                }
                            }
                            case 376: {
                                this.match(_t, 376);
                                _t = _t.getNextSibling();
                                if (_t == null) {
                                    _t = ASTNULL;
                                }
                                switch (_t.getType()) {
                                    case 100: {
                                        this.action_block(_t);
                                        _t = this._retTree;
                                        break block42;
                                    }
                                    case 406: {
                                        this.dynamic_c_routine(_t);
                                        _t = this._retTree;
                                        break block42;
                                    }
                                    default: {
                                        throw this.getNoViableAltException(_t);
                                    }
                                }
                            }
                            case 377: {
                                this.match(_t, 377);
                                _t = _t.getNextSibling();
                                if (_t == null) {
                                    _t = ASTNULL;
                                }
                                switch (_t.getType()) {
                                    case 100: {
                                        this.action_block(_t);
                                        _t = this._retTree;
                                        break block42;
                                    }
                                    case 406: {
                                        this.dynamic_c_routine(_t);
                                        _t = this._retTree;
                                        break block42;
                                    }
                                    default: {
                                        throw this.getNoViableAltException(_t);
                                    }
                                }
                            }
                            case 378: {
                                this.match(_t, 378);
                                _t = _t.getNextSibling();
                                if (_t == null) {
                                    _t = ASTNULL;
                                }
                                switch (_t.getType()) {
                                    case 100: {
                                        this.action_block(_t);
                                        _t = this._retTree;
                                        break block42;
                                    }
                                    case 406: {
                                        this.dynamic_c_routine(_t);
                                        _t = this._retTree;
                                        break block42;
                                    }
                                    default: {
                                        throw this.getNoViableAltException(_t);
                                    }
                                }
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block43;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void parameter(AST _t) throws RecognitionException {
        block31: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST id = null;
            RfNamedElement typeContainer = null;
            if (this.inputState.guessing() == 0) {
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.excludeVar = null;
                    }
                };
            }
            try {
                try {
                    AST __t105 = _t;
                    this.match(_t, 382);
                    _t = _t.getFirstChild();
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 383: {
                            this.match(_t, 383);
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 293: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    id = _t == ASTNULL ? null : _t;
                    this.identifier(_t);
                    _t = this._retTree;
                    if (this.inputState.guessing() == 0) {
                        try {
                            typeContainer = this.getTransientResult(RfArg.class, id);
                            this.excludeVar = typeContainer;
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 35: 
                        case 40: 
                        case 293: 
                        case 324: 
                        case 325: 
                        case 326: 
                        case 327: 
                        case 331: 
                        case 332: 
                        case 333: 
                        case 334: 
                        case 335: 
                        case 336: 
                        case 337: 
                        case 338: 
                        case 379: 
                        case 409: 
                        case 410: 
                        case 412: 
                        case 418: {
                            typeContainer = this.type(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 3: 
                        case 181: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 181: {
                            this.parameter_default_value(_t, typeContainer);
                            _t = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t105;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block31;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void parameter_default_value(AST _t, RfNamedElement lhScope) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t110 = _t;
                    this.match(_t, 181);
                    _t = _t.getFirstChild();
                    this.expr(_t, lhScope);
                    _t = this._retTree;
                    _t = __t110;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sln_const_statement(AST _t) throws RecognitionException {
        block20: {
            Runnable finalRunnable;
            block19: {
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST sm = null;
                AST id = null;
                RfNamedElement typeContainer = null;
                try {
                    try {
                        AST __t112 = _t;
                        sm = _t == ASTNULL ? null : _t;
                        this.match(_t, 430);
                        _t = _t.getFirstChild();
                        id = _t == ASTNULL ? null : _t;
                        this.identifier(_t);
                        _t = this._retTree;
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 60: {
                                typeContainer = this.field_type(_t);
                                _t = this._retTree;
                                break;
                            }
                            case 183: 
                            case 184: 
                            case 188: 
                            case 189: 
                            case 191: 
                            case 192: 
                            case 193: 
                            case 194: 
                            case 195: 
                            case 196: 
                            case 197: 
                            case 198: 
                            case 199: 
                            case 200: 
                            case 201: 
                            case 202: 
                            case 203: 
                            case 204: 
                            case 205: 
                            case 206: 
                            case 207: 
                            case 208: 
                            case 209: 
                            case 210: 
                            case 211: 
                            case 212: 
                            case 213: 
                            case 214: 
                            case 215: 
                            case 216: 
                            case 217: 
                            case 218: 
                            case 219: 
                            case 220: 
                            case 221: 
                            case 222: 
                            case 223: 
                            case 224: 
                            case 225: 
                            case 226: 
                            case 227: 
                            case 228: 
                            case 229: 
                            case 230: 
                            case 231: 
                            case 232: 
                            case 233: 
                            case 234: 
                            case 235: 
                            case 236: 
                            case 237: 
                            case 238: 
                            case 239: 
                            case 240: 
                            case 241: 
                            case 242: 
                            case 243: 
                            case 244: 
                            case 245: 
                            case 246: 
                            case 251: 
                            case 252: 
                            case 256: 
                            case 259: 
                            case 260: 
                            case 261: 
                            case 262: 
                            case 263: 
                            case 264: 
                            case 265: 
                            case 266: 
                            case 267: 
                            case 268: 
                            case 269: 
                            case 277: 
                            case 278: 
                            case 279: 
                            case 280: 
                            case 281: 
                            case 282: 
                            case 283: 
                            case 284: 
                            case 285: 
                            case 286: 
                            case 287: 
                            case 288: 
                            case 292: 
                            case 293: 
                            case 294: 
                            case 295: 
                            case 296: 
                            case 297: 
                            case 298: 
                            case 299: 
                            case 300: 
                            case 301: 
                            case 302: 
                            case 303: 
                            case 304: 
                            case 305: 
                            case 306: 
                            case 307: 
                            case 308: 
                            case 309: 
                            case 310: 
                            case 311: 
                            case 312: 
                            case 313: 
                            case 314: 
                            case 315: 
                            case 316: 
                            case 317: 
                            case 318: 
                            case 319: 
                            case 320: 
                            case 321: 
                            case 322: 
                            case 323: 
                            case 369: 
                            case 411: 
                            case 416: 
                            case 417: 
                            case 464: 
                            case 497: 
                            case 506: 
                            case 507: {
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        this.expr(_t, typeContainer);
                        _t = this._retTree;
                        _t = __t112;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block19;
                        try {
                            RfStructMember member = this.getTransientResult(RfStructMember.class, id);
                            if (member != null) {
                                RfDefElement def = this.getTransientScope(RfDefElement.class, sm);
                                LineInfo lineInfo = this.getMacroSafeLine(id);
                                member.performAdditionalSemanticChecks(this.rfp, def, lineInfo, this.parserPath);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final RfNamedElement field_type(AST _t) throws RecognitionException {
        RfNamedElement result;
        block17: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t735 = _t;
                    this.match(_t, 60);
                    _t = _t.getFirstChild();
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 61: {
                            result = this.sized_list_type(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 35: 
                        case 40: 
                        case 293: 
                        case 324: 
                        case 325: 
                        case 326: 
                        case 327: 
                        case 331: 
                        case 332: 
                        case 333: 
                        case 334: 
                        case 335: 
                        case 336: 
                        case 337: 
                        case 338: 
                        case 379: 
                        case 409: 
                        case 410: 
                        case 412: 
                        case 418: {
                            result = this.type(_t);
                            _t = this._retTree;
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t735;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final void coverage_body(AST _t) throws RecognitionException {
        block23: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 371: {
                            this.match(_t, 371);
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 378: {
                            AST __t1029 = _t;
                            this.match(_t, 378);
                            _t = _t.getFirstChild();
                            this.cover_item_list(_t);
                            _t = this._retTree;
                            _t = __t1029;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 376: {
                            AST __t1030 = _t;
                            this.match(_t, 376);
                            _t = _t.getFirstChild();
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            switch (_t.getType()) {
                                case 405: {
                                    this.cover_instance(_t);
                                    _t = this._retTree;
                                    break;
                                }
                                case 67: {
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltException(_t);
                                }
                            }
                            this.cover_item_list(_t);
                            _t = this._retTree;
                            _t = __t1030;
                            _t = _t.getNextSibling();
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void cover_instance(AST _t) throws RecognitionException {
        block34: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST id = null;
            RfNamedElement result = null;
            RfWNamedElementAndScope elementAndScope = null;
            if (this.inputState.guessing() == 0) {
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.disableChecks = false;
                    }
                };
            }
            try {
                try {
                    AST __t120;
                    block32: {
                        __t120 = _t;
                        this.match(_t, 405);
                        _t = _t.getFirstChild();
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (_t.getType() == 293) {
                            id = _t == ASTNULL ? null : _t;
                            this.identifier(_t);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    if (id == null) break block32;
                                    if ("e_path".equals(id.getText())) {
                                        this.disableChecks = true;
                                        break block32;
                                    }
                                    elementAndScope = this.resolveIdentifier(id, FIELD_VARIABLE, true);
                                    result = this.getNamedElement(elementAndScope);
                                    this.setTransientResult(id, elementAndScope);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                        } else if (!_tokenSet_13.member(_t.getType())) {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 183: 
                        case 184: 
                        case 188: 
                        case 189: 
                        case 191: 
                        case 192: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: 
                        case 198: 
                        case 199: 
                        case 200: 
                        case 201: 
                        case 202: 
                        case 203: 
                        case 204: 
                        case 205: 
                        case 206: 
                        case 207: 
                        case 208: 
                        case 209: 
                        case 210: 
                        case 211: 
                        case 212: 
                        case 213: 
                        case 214: 
                        case 215: 
                        case 216: 
                        case 217: 
                        case 218: 
                        case 219: 
                        case 220: 
                        case 221: 
                        case 222: 
                        case 223: 
                        case 224: 
                        case 225: 
                        case 226: 
                        case 227: 
                        case 228: 
                        case 229: 
                        case 230: 
                        case 231: 
                        case 232: 
                        case 233: 
                        case 234: 
                        case 235: 
                        case 236: 
                        case 237: 
                        case 238: 
                        case 239: 
                        case 240: 
                        case 241: 
                        case 242: 
                        case 243: 
                        case 244: 
                        case 245: 
                        case 246: 
                        case 251: 
                        case 252: 
                        case 256: 
                        case 259: 
                        case 260: 
                        case 261: 
                        case 262: 
                        case 263: 
                        case 264: 
                        case 265: 
                        case 266: 
                        case 267: 
                        case 268: 
                        case 269: 
                        case 277: 
                        case 278: 
                        case 279: 
                        case 280: 
                        case 281: 
                        case 282: 
                        case 283: 
                        case 284: 
                        case 285: 
                        case 286: 
                        case 287: 
                        case 288: 
                        case 292: 
                        case 293: 
                        case 294: 
                        case 295: 
                        case 296: 
                        case 297: 
                        case 298: 
                        case 299: 
                        case 300: 
                        case 301: 
                        case 302: 
                        case 303: 
                        case 304: 
                        case 305: 
                        case 306: 
                        case 307: 
                        case 308: 
                        case 309: 
                        case 310: 
                        case 311: 
                        case 312: 
                        case 313: 
                        case 314: 
                        case 315: 
                        case 316: 
                        case 317: 
                        case 318: 
                        case 319: 
                        case 320: 
                        case 321: 
                        case 322: 
                        case 323: 
                        case 369: 
                        case 411: 
                        case 416: 
                        case 417: 
                        case 464: 
                        case 497: 
                        case 506: 
                        case 507: {
                            if (this.inputState.guessing() == 0) {
                                try {
                                    if (id != null && !this.disableChecks) {
                                        if (result == null) {
                                            LineInfo lineInfo = this.getMacroSafeLine(id);
                                            this.rfp.addSemanticError2(1, "UNDEFINED_IDENTIFIER: Identifier ''{0}'' is not defined", lineInfo.getOffset(), lineInfo.getOffset() + id.getText().length(), null, lineInfo.line, this.parserPath, id.getText());
                                            elementAndScope = null;
                                            result = ERROR_SCOPE;
                                        } else if (result instanceof IllegalAccessError) {
                                            LineInfo lineInfo = this.getMacroSafeLine(id);
                                            this.rfp.addSemanticError2(1, "ILLEGAL_ACCESS: Cannot access {0} {1} ''{2}.{3}''", lineInfo.getOffset(), lineInfo.getOffset() + id.getText().length(), null, lineInfo.line, this.parserPath, ((IllegalAccessError)result).getAccessModifierText(), ((IllegalAccessError)result).getElementKindText(), ((IllegalAccessError)result).getParentName(), id.getText());
                                            result = ((IllegalAccessError)result).getElement();
                                        }
                                        this.setTransientResult(id, elementAndScope);
                                    }
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            this.expr(_t, result);
                            _t = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t120;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block34;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void cover_item(AST _t) throws RecognitionException {
        block22: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 403: {
                            this.user_defined_cover_item(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 404: {
                            this.as_computed_user_defined_cover_item(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 419: {
                            this.preproc_ifdef_cover_item(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 420: {
                            this.preproc_ifndef_cover_item(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 68: {
                            this.item_cover_item(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 69: {
                            this.cross_cover_item(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 70: {
                            this.transition_cover_item(_t);
                            _t = this._retTree;
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void as_computed_user_defined_cover_item(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1044 = _t;
                    this.match(_t, 404);
                    _t = _t.getFirstChild();
                    this.define_name(_t);
                    _t = this._retTree;
                    this.replacement_term_list(_t);
                    _t = this._retTree;
                    _t = __t1044;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void preproc_ifdef_cover_item(AST _t) throws RecognitionException {
        block17: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1037 = _t;
                    this.match(_t, 419);
                    _t = _t.getFirstChild();
                    this.preproc_id(_t);
                    _t = this._retTree;
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 67: 
                        case 366: {
                            this.preproc_cover_item_block(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t1037;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void preproc_ifndef_cover_item(AST _t) throws RecognitionException {
        block17: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1040 = _t;
                    this.match(_t, 420);
                    _t = _t.getFirstChild();
                    this.preproc_id(_t);
                    _t = this._retTree;
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 67: 
                        case 366: {
                            this.preproc_cover_item_block(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t1040;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void item_cover_item(AST _t) throws RecognitionException {
        block27: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST ci = null;
            AST var = null;
            RfNamedElement variable = null;
            final int stackScopeSize = this.getLastScopeLayerStackSize();
            final RfDefElement[] currentScope = new RfDefElement[1];
            if (this.inputState.guessing() == 0) {
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        if (currentScope[0] != null) {
                            SemanticWalker.this.lastScopeLayerStack.push(currentScope[0]);
                        }
                        SemanticWalker.this.cleanAllScopes(stackScopeSize);
                    }
                };
            }
            try {
                try {
                    AST __t125 = _t;
                    ci = _t == ASTNULL ? null : _t;
                    this.match(_t, 68);
                    _t = _t.getFirstChild();
                    if (this.inputState.guessing() == 0) {
                        try {
                            if (!this.lastScopeLayerStack.isEmpty()) {
                                currentScope[0] = this.lastScopeLayerStack.pop();
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    var = _t == ASTNULL ? null : _t;
                    variable = this.var_declaration(_t);
                    _t = this._retTree;
                    if (this.inputState.guessing() == 0) {
                        try {
                            RfVar prevVar;
                            int usingKind = ((EAST)ci).getMeta("also") == null ? 378 : 376;
                            int varOffset = ((EAST)var).getFirstChild() != null ? ((EAST)var).getFirstChild().getOffset() : ((EAST)var).getOffset();
                            LineInfo lineInfo = this.getMacroSafeLine(ci);
                            this.rfp.checkDuplicateCoverItem(variable, currentScope[0], lineInfo, usingKind, this.parserPath, varOffset);
                            if (currentScope[0] != null) {
                                this.lastScopeLayerStack.push(currentScope[0]);
                                currentScope[0] = null;
                            }
                            this.pushScopeLayer(ci);
                            RfActionBlockLayer def = this.getTransientScope(RfActionBlockLayer.class, ci);
                            if (def != null && (prevVar = def.getLocalVariable("prev", LineInfo.INFINITE, null)) != null) {
                                prevVar.setAssociatedTypeFrom(this.rfp, this.ELEM_OF_BOOL_TYPE);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 384: 
                        case 385: {
                            this.using_list(_t, variable, ci, null);
                            _t = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t125;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block27;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void cross_cover_item(AST _t) throws RecognitionException {
        block25: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST cc = null;
            final int stackScopeSize = this.getLastScopeLayerStackSize();
            if (this.inputState.guessing() == 0) {
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.cleanAllScopes(stackScopeSize);
                    }
                };
            }
            try {
                try {
                    AST __t128 = _t;
                    cc = _t == ASTNULL ? null : _t;
                    this.match(_t, 69);
                    _t = _t.getFirstChild();
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.pushScopeLayer(cc);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    this.cross_item_list(_t);
                    _t = this._retTree;
                    if (this.inputState.guessing() == 0) {
                        try {
                            RfVar prevVar;
                            RfActionBlockLayer def = this.getTransientScope(RfActionBlockLayer.class, cc);
                            if (def != null && (prevVar = def.getLocalVariable("prev", LineInfo.INFINITE, null)) != null) {
                                prevVar.setAssociatedTypeFrom(this.rfp, this.ELEM_OF_BOOL_TYPE);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 384: 
                        case 385: {
                            this.using_list(_t, null, cc, null);
                            _t = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t128;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block25;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void transition_cover_item(AST _t) throws RecognitionException {
        block35: {
            Runnable finalRunnable;
            block34: {
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST ct = null;
                AST id = null;
                HashMap<String, Object> using = new HashMap<String, Object>();
                final int stackScopeSize = this.getLastScopeLayerStackSize();
                if (this.inputState.guessing() == 0) {
                    finalRunnable = new Runnable(){

                        @Override
                        public void run() {
                            SemanticWalker.this.cleanAllScopes(stackScopeSize);
                        }
                    };
                }
                try {
                    try {
                        RfActionBlockLayer def;
                        AST __t131 = _t;
                        ct = _t == ASTNULL ? null : _t;
                        this.match(_t, 70);
                        _t = _t.getFirstChild();
                        if (this.inputState.guessing() == 0) {
                            try {
                                this.pushScopeLayer(ct);
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        id = _t == ASTNULL ? null : _t;
                        this.identifier(_t);
                        _t = this._retTree;
                        if (this.inputState.guessing() == 0) {
                            try {
                                def = this.getTransientScope(RfActionBlockLayer.class, ct);
                                if (def != null && id != null && (def = (RfActionBlockLayer)def.getEnclosingScope(RfCoverLayer.class)) != null) {
                                    RfVar prevVar;
                                    RfVar coverItem = def.getLocalVariable(id.getText(), LineInfo.INFINITE, null);
                                    if (coverItem instanceof RfCoverItem && coverItem.getKind() == 1) {
                                        List<String> itemNames = ((RfCoverItem)coverItem).getCoverCrossItems();
                                        if (itemNames != null && !itemNames.isEmpty()) {
                                            for (String itemName : itemNames) {
                                                RfVar prevVar2 = def.getLocalVariable("prev_" + itemName, LineInfo.INFINITE, null);
                                                RfVar var = def.getLocalVariable(itemName, LineInfo.INFINITE, null);
                                                if (prevVar2 == null || var == null) continue;
                                                prevVar2.setAssociatedTypeFrom(this.rfp, var);
                                            }
                                        }
                                    } else {
                                        prevVar = def.getLocalVariable("prev_" + id.getText(), LineInfo.INFINITE, null);
                                        if (prevVar != null) {
                                            prevVar.setAssociatedTypeFrom(this.rfp, this.expr(id, null));
                                        }
                                    }
                                    if ((prevVar = def.getLocalVariable("prev", LineInfo.INFINITE, null)) != null) {
                                        prevVar.setAssociatedTypeFrom(this.rfp, this.ELEM_OF_BOOL_TYPE);
                                    }
                                }
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 384: 
                            case 385: {
                                this.using_list(_t, null, ct, using);
                                _t = this._retTree;
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        _t = __t131;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block34;
                        try {
                            RfVar coverItem;
                            String name;
                            def = this.getTransientScope(RfActionBlockLayer.class, ct);
                            if (def == null || id == null) break block34;
                            def = def.getEnclosingScope(RfCoverLayer.class);
                            String string = name = using.get("name") instanceof EAST ? ((EAST)using.get("name")).getText() : "transition__" + id.getText();
                            if (def == null || !((coverItem = def.getLocalVariable(name, LineInfo.INFINITE, null)) instanceof RfCoverItem) || coverItem.getKind() != 2 || coverItem.getLayers() == null) break block34;
                            for (RfDefElement layer : coverItem.getLayers()) {
                                if (layer.getEndOffset() < id.getOffset()) {
                                    this.rfp.addSemanticError1(1, "DUPLICATE_COVER_ITEM: Cover item ''{0}'' was previously defined\n    at line {1,number,#######} in {2}", id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), this.parserPath, name, layer.getStartLine(), layer.getParserPath());
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block35;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final RfNamedElement var_declaration(AST _t) throws RecognitionException {
        RfNamedElement variable;
        block76: {
            variable = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST id1 = null;
            AST id2 = null;
            AST exp1 = null;
            AST id3 = null;
            AST exp2 = null;
            AST id4 = null;
            AST ne4 = null;
            AST ex4 = null;
            RfNamedElement result = null;
            final int stackScopeSize = this.getLastScopeLayerStackSize();
            if (this.inputState.guessing() == 0) {
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.cleanAllScopes(stackScopeSize);
                        SemanticWalker.this.excludeVar = null;
                    }
                };
            }
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 109: {
                            AST __t671 = _t;
                            this.match(_t, 109);
                            _t = _t.getFirstChild();
                            id1 = _t == ASTNULL ? null : _t;
                            this.identifier(_t);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    variable = this.excludeVar = this.getTransientResult(RfNamedElement.class, id1);
                                    if (variable instanceof RfCoverItem && id1 != null && ((RfVar)variable).getAssociatedType() == null && ((RfVar)variable).getKind() == 0) {
                                        RfWNamedElementAndScope elementAndScope = this.resolveIdentifier(id1, FIELD, true);
                                        result = this.getNamedElement(elementAndScope);
                                        if (result == null) {
                                            LineInfo lineInfo = this.getMacroSafeLine(id1);
                                            this.rfp.addSemanticError1(1, "UNDEFINED_VARIABLE: No field or local variable called ''{0}''", lineInfo.getOffset(), lineInfo.getOffset() + id1.getText().length(), null, lineInfo.line, this.parserPath, id1.getText());
                                            result = ERROR_SCOPE;
                                        } else if (result instanceof IllegalAccessError) {
                                            LineInfo lineInfo = this.getMacroSafeLine(id1);
                                            this.rfp.addSemanticError2(1, "ILLEGAL_ACCESS: Cannot access {0} {1} ''{2}.{3}''", lineInfo.getOffset(), lineInfo.getOffset() + id1.getText().length(), null, lineInfo.line, this.parserPath, ((IllegalAccessError)result).getAccessModifierText(), ((IllegalAccessError)result).getElementKindText(), ((IllegalAccessError)result).getParentName(), id1.getText());
                                            result = ((IllegalAccessError)result).getElement();
                                        }
                                        ((RfVar)variable).setAssociatedTypeFrom(this.rfp, result);
                                    }
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            switch (_t.getType()) {
                                case 183: 
                                case 184: 
                                case 188: 
                                case 189: 
                                case 191: 
                                case 192: 
                                case 193: 
                                case 194: 
                                case 195: 
                                case 196: 
                                case 197: 
                                case 198: 
                                case 199: 
                                case 200: 
                                case 201: 
                                case 202: 
                                case 203: 
                                case 204: 
                                case 205: 
                                case 206: 
                                case 207: 
                                case 208: 
                                case 209: 
                                case 210: 
                                case 211: 
                                case 212: 
                                case 213: 
                                case 214: 
                                case 215: 
                                case 216: 
                                case 217: 
                                case 218: 
                                case 219: 
                                case 220: 
                                case 221: 
                                case 222: 
                                case 223: 
                                case 224: 
                                case 225: 
                                case 226: 
                                case 227: 
                                case 228: 
                                case 229: 
                                case 230: 
                                case 231: 
                                case 232: 
                                case 233: 
                                case 234: 
                                case 235: 
                                case 236: 
                                case 237: 
                                case 238: 
                                case 239: 
                                case 240: 
                                case 241: 
                                case 242: 
                                case 243: 
                                case 244: 
                                case 245: 
                                case 246: 
                                case 251: 
                                case 252: 
                                case 256: 
                                case 259: 
                                case 260: 
                                case 261: 
                                case 262: 
                                case 263: 
                                case 264: 
                                case 265: 
                                case 266: 
                                case 267: 
                                case 268: 
                                case 269: 
                                case 277: 
                                case 278: 
                                case 279: 
                                case 280: 
                                case 281: 
                                case 282: 
                                case 283: 
                                case 284: 
                                case 285: 
                                case 286: 
                                case 287: 
                                case 288: 
                                case 292: 
                                case 293: 
                                case 294: 
                                case 295: 
                                case 296: 
                                case 297: 
                                case 298: 
                                case 299: 
                                case 300: 
                                case 301: 
                                case 302: 
                                case 303: 
                                case 304: 
                                case 305: 
                                case 306: 
                                case 307: 
                                case 308: 
                                case 309: 
                                case 310: 
                                case 311: 
                                case 312: 
                                case 313: 
                                case 314: 
                                case 315: 
                                case 316: 
                                case 317: 
                                case 318: 
                                case 319: 
                                case 320: 
                                case 321: 
                                case 322: 
                                case 323: 
                                case 369: 
                                case 411: 
                                case 416: 
                                case 417: 
                                case 464: 
                                case 497: 
                                case 506: 
                                case 507: {
                                    result = this.expr(_t, null);
                                    _t = this._retTree;
                                    if (this.inputState.guessing() != 0) break;
                                    try {
                                        if (!(result instanceof RfUndefVariable)) break;
                                        ((RfUndefVariable)result).type(variable);
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                    break;
                                }
                                case 3: {
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltException(_t);
                                }
                            }
                            _t = __t671;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 111: {
                            AST __t680 = _t;
                            this.match(_t, 111);
                            _t = _t.getFirstChild();
                            id4 = _t == ASTNULL ? null : _t;
                            this.identifier(_t);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    variable = this.excludeVar = this.getTransientResult(RfNamedElement.class, id4);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            boolean synPredMatched683 = false;
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            if (_t.getType() == 256) {
                                AST __t683 = _t;
                                synPredMatched683 = true;
                                this.inputState.incGuessing();
                                try {
                                    this.new_expr(_t, null);
                                    _t = this._retTree;
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched683 = false;
                                }
                                _t = __t683;
                                this.inputState.decGuessing(synPredMatched683);
                            }
                            if (synPredMatched683) {
                                ne4 = _t == ASTNULL ? null : _t;
                                this.new_expr(_t, variable);
                                _t = this._retTree;
                            } else if (_tokenSet_4.member(_t.getType())) {
                                ex4 = _t == ASTNULL ? null : _t;
                                result = this.expr(_t, null);
                                _t = this._retTree;
                            } else {
                                throw this.getNoViableAltException(_t);
                            }
                            _t = __t680;
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() != 0) break;
                            try {
                                if (variable == null || result == null) break;
                                if (result instanceof IRfAssociatedType && ((IRfAssociatedType)((Object)result)).getAssociatedType() == this.rfp.getSpecman().getVoidType()) {
                                    AST expFrom = ne4 != null ? ne4 : ex4;
                                    LineInfo lineInfo = this.getTreeLineInfo(expFrom);
                                    String fromElementName = expFrom == null ? "null" : ((EAST)expFrom).getMeta("text");
                                    fromElementName = SemanticUtils.customizeElementName(fromElementName);
                                    this.rfp.addSemanticError2(1, "UNEXPECTED_TYPE: ''{0}'' is of type ''{1}'', while expecting some type", lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, this.parserPath, fromElementName, "void");
                                    break;
                                }
                                if (result instanceof RfPredefinedMethod && "get_config".equals(result.getName())) {
                                    ((RfVar)variable).setAssociatedTypeFrom(this.rfp, new RfDummyField(this.rfp, this.rfp.getSpecman().getUndefType()));
                                    break;
                                }
                                ((RfVar)variable).setAssociatedTypeFrom(this.rfp, result);
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break;
                        }
                        default: {
                            boolean synPredMatched675 = false;
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            if (_t.getType() == 110) {
                                AST __t675 = _t;
                                synPredMatched675 = true;
                                this.inputState.incGuessing();
                                try {
                                    AST __t674 = _t;
                                    this.match(_t, 110);
                                    _t = _t.getFirstChild();
                                    this.identifier(_t);
                                    _t = this._retTree;
                                    this.match(_t, 418);
                                    _t = _t.getNextSibling();
                                    _t = __t674;
                                    _t = _t.getNextSibling();
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched675 = false;
                                }
                                _t = __t675;
                                this.inputState.decGuessing(synPredMatched675);
                            }
                            if (synPredMatched675) {
                                AST __t676 = _t;
                                this.match(_t, 110);
                                _t = _t.getFirstChild();
                                id2 = _t == ASTNULL ? null : _t;
                                this.identifier(_t);
                                _t = this._retTree;
                                exp1 = _t == ASTNULL ? null : _t;
                                result = this.typeof_type(_t);
                                _t = this._retTree;
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        variable = this.excludeVar = this.getTransientResult(RfNamedElement.class, id2);
                                        if (variable != null) {
                                            ((RfVar)variable).setAssociatedTypeFrom(this.rfp, result);
                                        }
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                                if (_t == null) {
                                    _t = ASTNULL;
                                }
                                switch (_t.getType()) {
                                    case 183: 
                                    case 184: 
                                    case 188: 
                                    case 189: 
                                    case 191: 
                                    case 192: 
                                    case 193: 
                                    case 194: 
                                    case 195: 
                                    case 196: 
                                    case 197: 
                                    case 198: 
                                    case 199: 
                                    case 200: 
                                    case 201: 
                                    case 202: 
                                    case 203: 
                                    case 204: 
                                    case 205: 
                                    case 206: 
                                    case 207: 
                                    case 208: 
                                    case 209: 
                                    case 210: 
                                    case 211: 
                                    case 212: 
                                    case 213: 
                                    case 214: 
                                    case 215: 
                                    case 216: 
                                    case 217: 
                                    case 218: 
                                    case 219: 
                                    case 220: 
                                    case 221: 
                                    case 222: 
                                    case 223: 
                                    case 224: 
                                    case 225: 
                                    case 226: 
                                    case 227: 
                                    case 228: 
                                    case 229: 
                                    case 230: 
                                    case 231: 
                                    case 232: 
                                    case 233: 
                                    case 234: 
                                    case 235: 
                                    case 236: 
                                    case 237: 
                                    case 238: 
                                    case 239: 
                                    case 240: 
                                    case 241: 
                                    case 242: 
                                    case 243: 
                                    case 244: 
                                    case 245: 
                                    case 246: 
                                    case 251: 
                                    case 252: 
                                    case 256: 
                                    case 259: 
                                    case 260: 
                                    case 261: 
                                    case 262: 
                                    case 263: 
                                    case 264: 
                                    case 265: 
                                    case 266: 
                                    case 267: 
                                    case 268: 
                                    case 269: 
                                    case 277: 
                                    case 278: 
                                    case 279: 
                                    case 280: 
                                    case 281: 
                                    case 282: 
                                    case 283: 
                                    case 284: 
                                    case 285: 
                                    case 286: 
                                    case 287: 
                                    case 288: 
                                    case 292: 
                                    case 293: 
                                    case 294: 
                                    case 295: 
                                    case 296: 
                                    case 297: 
                                    case 298: 
                                    case 299: 
                                    case 300: 
                                    case 301: 
                                    case 302: 
                                    case 303: 
                                    case 304: 
                                    case 305: 
                                    case 306: 
                                    case 307: 
                                    case 308: 
                                    case 309: 
                                    case 310: 
                                    case 311: 
                                    case 312: 
                                    case 313: 
                                    case 314: 
                                    case 315: 
                                    case 316: 
                                    case 317: 
                                    case 318: 
                                    case 319: 
                                    case 320: 
                                    case 321: 
                                    case 322: 
                                    case 323: 
                                    case 369: 
                                    case 411: 
                                    case 416: 
                                    case 417: 
                                    case 464: 
                                    case 497: 
                                    case 506: 
                                    case 507: {
                                        result = this.expr(_t, this.excludeVar);
                                        _t = this._retTree;
                                        if (this.inputState.guessing() != 0) break;
                                        try {
                                            if (result instanceof RfUndefVariable) {
                                                ((RfUndefVariable)result).type(variable);
                                                break;
                                            }
                                            SemanticUtils.incompatibleAssign(this.rfp, this.parserPath, this.macroDepth, this.macroLineInfo, null, exp1, variable, result, SemanticUtils.AssignKind.ASSIGN);
                                        }
                                        catch (Exception ex) {
                                            this.userExceptionHandler(ex);
                                        }
                                        break;
                                    }
                                    case 3: {
                                        break;
                                    }
                                    default: {
                                        throw this.getNoViableAltException(_t);
                                    }
                                }
                                _t = __t676;
                                _t = _t.getNextSibling();
                                break;
                            }
                            if (_t.getType() == 110) {
                                AST __t678 = _t;
                                this.match(_t, 110);
                                _t = _t.getFirstChild();
                                id3 = _t == ASTNULL ? null : _t;
                                this.identifier(_t);
                                _t = this._retTree;
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        variable = this.excludeVar = this.getTransientResult(RfNamedElement.class, id3);
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                                this.type(_t);
                                _t = this._retTree;
                                if (_t == null) {
                                    _t = ASTNULL;
                                }
                                switch (_t.getType()) {
                                    case 183: 
                                    case 184: 
                                    case 188: 
                                    case 189: 
                                    case 191: 
                                    case 192: 
                                    case 193: 
                                    case 194: 
                                    case 195: 
                                    case 196: 
                                    case 197: 
                                    case 198: 
                                    case 199: 
                                    case 200: 
                                    case 201: 
                                    case 202: 
                                    case 203: 
                                    case 204: 
                                    case 205: 
                                    case 206: 
                                    case 207: 
                                    case 208: 
                                    case 209: 
                                    case 210: 
                                    case 211: 
                                    case 212: 
                                    case 213: 
                                    case 214: 
                                    case 215: 
                                    case 216: 
                                    case 217: 
                                    case 218: 
                                    case 219: 
                                    case 220: 
                                    case 221: 
                                    case 222: 
                                    case 223: 
                                    case 224: 
                                    case 225: 
                                    case 226: 
                                    case 227: 
                                    case 228: 
                                    case 229: 
                                    case 230: 
                                    case 231: 
                                    case 232: 
                                    case 233: 
                                    case 234: 
                                    case 235: 
                                    case 236: 
                                    case 237: 
                                    case 238: 
                                    case 239: 
                                    case 240: 
                                    case 241: 
                                    case 242: 
                                    case 243: 
                                    case 244: 
                                    case 245: 
                                    case 246: 
                                    case 251: 
                                    case 252: 
                                    case 256: 
                                    case 259: 
                                    case 260: 
                                    case 261: 
                                    case 262: 
                                    case 263: 
                                    case 264: 
                                    case 265: 
                                    case 266: 
                                    case 267: 
                                    case 268: 
                                    case 269: 
                                    case 277: 
                                    case 278: 
                                    case 279: 
                                    case 280: 
                                    case 281: 
                                    case 282: 
                                    case 283: 
                                    case 284: 
                                    case 285: 
                                    case 286: 
                                    case 287: 
                                    case 288: 
                                    case 292: 
                                    case 293: 
                                    case 294: 
                                    case 295: 
                                    case 296: 
                                    case 297: 
                                    case 298: 
                                    case 299: 
                                    case 300: 
                                    case 301: 
                                    case 302: 
                                    case 303: 
                                    case 304: 
                                    case 305: 
                                    case 306: 
                                    case 307: 
                                    case 308: 
                                    case 309: 
                                    case 310: 
                                    case 311: 
                                    case 312: 
                                    case 313: 
                                    case 314: 
                                    case 315: 
                                    case 316: 
                                    case 317: 
                                    case 318: 
                                    case 319: 
                                    case 320: 
                                    case 321: 
                                    case 322: 
                                    case 323: 
                                    case 369: 
                                    case 411: 
                                    case 416: 
                                    case 417: 
                                    case 464: 
                                    case 497: 
                                    case 506: 
                                    case 507: {
                                        exp2 = _t == ASTNULL ? null : _t;
                                        result = this.expr(_t, this.excludeVar);
                                        _t = this._retTree;
                                        if (this.inputState.guessing() != 0) break;
                                        try {
                                            if (result instanceof RfUndefVariable) {
                                                ((RfUndefVariable)result).type(variable);
                                                break;
                                            }
                                            SemanticUtils.incompatibleAssign(this.rfp, this.parserPath, this.macroDepth, this.macroLineInfo, null, exp2, variable, result, SemanticUtils.AssignKind.ASSIGN);
                                        }
                                        catch (Exception ex) {
                                            this.userExceptionHandler(ex);
                                        }
                                        break;
                                    }
                                    case 3: {
                                        break;
                                    }
                                    default: {
                                        throw this.getNoViableAltException(_t);
                                    }
                                }
                                _t = __t678;
                                _t = _t.getNextSibling();
                                break;
                            }
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block76;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return variable;
    }

    public final void cross_item_list(AST _t) throws RecognitionException {
        block19: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST id = null;
            try {
                try {
                    AST __t134 = _t;
                    this.match(_t, 71);
                    _t = _t.getFirstChild();
                    while (true) {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (_t.getType() != 293) break;
                        id = _t == ASTNULL ? null : _t;
                        this.identifier(_t);
                        _t = this._retTree;
                        if (this.inputState.guessing() != 0) continue;
                        try {
                            if (id == null) continue;
                            RfWNamedElementAndScope elementAndScope = this.resolveIdentifier(id, FIELD_VARIABLE, true);
                            RfNamedElement result = this.getNamedElement(elementAndScope);
                            if (result == null) {
                                lineInfo = this.getMacroSafeLine(id);
                                this.rfp.addSemanticError2(1, "UNDEFINED_COVER_ITEM: Cover item ''{0}'' is not defined", lineInfo.getOffset(), lineInfo.getOffset() + id.getText().length(), null, lineInfo.line, this.parserPath, id.getText());
                                elementAndScope = null;
                                result = ERROR_SCOPE;
                            } else if (result instanceof IllegalAccessError) {
                                lineInfo = this.getMacroSafeLine(id);
                                this.rfp.addSemanticError2(1, "ILLEGAL_ACCESS: Cannot access {0} {1} ''{2}.{3}''", lineInfo.getOffset(), lineInfo.getOffset() + id.getText().length(), null, lineInfo.line, this.parserPath, ((IllegalAccessError)result).getAccessModifierText(), ((IllegalAccessError)result).getElementKindText(), ((IllegalAccessError)result).getParentName(), id.getText());
                                result = ((IllegalAccessError)result).getElement();
                            }
                            this.setTransientResult(id, elementAndScope);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    _t = __t134;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void using_indexes(AST _t) throws RecognitionException {
        block14: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1050 = _t;
                    this.match(_t, 384);
                    _t = _t.getFirstChild();
                    while (true) {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (_t.getType() != 159) break;
                        this.index_name(_t);
                        _t = this._retTree;
                    }
                    _t = __t1050;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void for_action(AST _t) throws RecognitionException {
        block16: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST ab = null;
            final int stackScopeSize = this.getLastScopeLayerStackSize();
            if (this.inputState.guessing() == 0) {
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.cleanAllScopes(stackScopeSize);
                    }
                };
            }
            try {
                try {
                    AST __t141 = _t;
                    ab = _t == ASTNULL ? null : _t;
                    this.match(_t, 152);
                    _t = _t.getFirstChild();
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.pushScopeLayer(ab);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    this.for_init(_t);
                    _t = this._retTree;
                    this.for_test(_t);
                    _t = this._retTree;
                    this.for_step(_t);
                    _t = this._retTree;
                    this.action_block(_t);
                    _t = this._retTree;
                    _t = __t141;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void for_init(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1252 = _t;
                    this.match(_t, 153);
                    _t = _t.getFirstChild();
                    this.action(_t);
                    _t = this._retTree;
                    _t = __t1252;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void for_test(AST _t) throws RecognitionException {
        block15: {
            Runnable finalRunnable;
            block14: {
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST exp = null;
                RfNamedElement result = null;
                try {
                    try {
                        AST __t143 = _t;
                        this.match(_t, 154);
                        _t = _t.getFirstChild();
                        exp = _t == ASTNULL ? null : _t;
                        result = this.expr(_t, null);
                        _t = this._retTree;
                        _t = __t143;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block14;
                        try {
                            if (this.valid(result)) {
                                SemanticUtils.incompatibleAssign(this.rfp, this.parserPath, this.macroDepth, this.macroLineInfo, null, exp, this.ELEM_OF_BOOL_TYPE, result, SemanticUtils.AssignKind.COMPARE);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void for_step(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1254 = _t;
                    this.match(_t, 155);
                    _t = _t.getFirstChild();
                    this.action(_t);
                    _t = this._retTree;
                    _t = __t1254;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void for_each_action(AST _t) throws RecognitionException {
        block39: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST ab = null;
            String itemName = "it";
            String indexName = "index";
            boolean typeFromExp = true;
            RfNamedElement typeContainer = null;
            final int stackScopeSize = this.getLastScopeLayerStackSize();
            if (this.inputState.guessing() == 0) {
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.cleanAllScopes(stackScopeSize);
                    }
                };
            }
            try {
                try {
                    AST __t145 = _t;
                    ab = _t == ASTNULL ? null : _t;
                    this.match(_t, 156);
                    _t = _t.getFirstChild();
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 158: {
                            typeContainer = this.item_type(_t);
                            _t = this._retTree;
                            if (this.inputState.guessing() != 0) break;
                            try {
                                typeFromExp = false;
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break;
                        }
                        case 157: 
                        case 159: 
                        case 161: 
                        case 162: 
                        case 469: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 157: {
                            itemName = this.item_name(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 159: 
                        case 161: 
                        case 162: 
                        case 469: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 159: {
                            indexName = this.index_name(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 161: 
                        case 162: 
                        case 469: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    typeContainer = this.for_each_interval(_t, typeContainer);
                    _t = this._retTree;
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.pushScopeLayer(ab);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    if (this.inputState.guessing() == 0) {
                        try {
                            RfActionBlockLayer def = this.getTransientScope(RfActionBlockLayer.class, ab);
                            if (def != null) {
                                RfVar indexVar;
                                RfVar itemVar;
                                if (typeFromExp && typeContainer != null && (itemVar = def.getLocalVariable(itemName, LineInfo.INFINITE, null)) != null) {
                                    itemVar.setAssociatedTypeFrom(this.rfp, typeContainer, true);
                                }
                                if ((indexVar = def.getLocalVariable(indexName, LineInfo.INFINITE, null)) != null) {
                                    indexVar.setAssociatedTypeFrom(this.rfp, new RfDummyField(this.rfp, this.UINT_TYPE));
                                }
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    this.action_block(_t);
                    _t = this._retTree;
                    _t = __t145;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block39;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final RfNamedElement item_type(AST _t) throws RecognitionException {
        RfNamedElement result;
        block12: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t150 = _t;
                    this.match(_t, 158);
                    _t = _t.getFirstChild();
                    result = this.type(_t);
                    _t = this._retTree;
                    _t = __t150;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final String item_name(AST _t) throws RecognitionException {
        String itemName;
        block15: {
            itemName = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST id = null;
            try {
                try {
                    AST __t157 = _t;
                    this.match(_t, 157);
                    _t = _t.getFirstChild();
                    id = _t == ASTNULL ? null : _t;
                    this.identifier(_t);
                    _t = this._retTree;
                    if (this.inputState.guessing() == 0) {
                        try {
                            itemName = id == null ? "it" : id.getText();
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    _t = __t157;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return itemName;
    }

    public final String index_name(AST _t) throws RecognitionException {
        String indexName;
        block15: {
            indexName = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST id = null;
            try {
                try {
                    AST __t159 = _t;
                    this.match(_t, 159);
                    _t = _t.getFirstChild();
                    id = _t == ASTNULL ? null : _t;
                    this.identifier(_t);
                    _t = this._retTree;
                    if (this.inputState.guessing() == 0) {
                        try {
                            indexName = id == null ? "index" : id.getText();
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    _t = __t159;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return indexName;
    }

    public final RfNamedElement for_each_interval(AST _t, RfNamedElement lhScope) throws RecognitionException {
        RfNamedElement result;
        block21: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 161: {
                            AST __t636 = _t;
                            this.match(_t, 161);
                            _t = _t.getFirstChild();
                            result = this.expr(_t, lhScope);
                            _t = this._retTree;
                            _t = __t636;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 162: {
                            AST __t637 = _t;
                            this.match(_t, 162);
                            _t = _t.getFirstChild();
                            result = this.expr(_t, lhScope);
                            _t = this._retTree;
                            _t = __t637;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 469: {
                            this.match(_t, 469);
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = lhScope;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final void for_each_expr(AST _t) throws RecognitionException {
        block38: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST ab = null;
            String itemName = "it";
            String indexName = "index";
            String prevName = "prev";
            RfNamedElement typeContainer = null;
            final int stackScopeSize = this.getLastScopeLayerStackSize();
            if (this.inputState.guessing() == 0) {
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.cleanAllScopes(stackScopeSize);
                    }
                };
            }
            try {
                try {
                    AST __t152 = _t;
                    ab = _t == ASTNULL ? null : _t;
                    this.match(_t, 267);
                    _t = _t.getFirstChild();
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    if (_t.getType() == 157) {
                        itemName = this.item_name(_t);
                        _t = this._retTree;
                    } else if (!_tokenSet_14.member(_t.getType())) {
                        throw this.getNoViableAltException(_t);
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 159: {
                            indexName = this.index_name(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 160: 
                        case 183: 
                        case 184: 
                        case 188: 
                        case 189: 
                        case 191: 
                        case 192: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: 
                        case 198: 
                        case 199: 
                        case 200: 
                        case 201: 
                        case 202: 
                        case 203: 
                        case 204: 
                        case 205: 
                        case 206: 
                        case 207: 
                        case 208: 
                        case 209: 
                        case 210: 
                        case 211: 
                        case 212: 
                        case 213: 
                        case 214: 
                        case 215: 
                        case 216: 
                        case 217: 
                        case 218: 
                        case 219: 
                        case 220: 
                        case 221: 
                        case 222: 
                        case 223: 
                        case 224: 
                        case 225: 
                        case 226: 
                        case 227: 
                        case 228: 
                        case 229: 
                        case 230: 
                        case 231: 
                        case 232: 
                        case 233: 
                        case 234: 
                        case 235: 
                        case 236: 
                        case 237: 
                        case 238: 
                        case 239: 
                        case 240: 
                        case 241: 
                        case 242: 
                        case 243: 
                        case 244: 
                        case 245: 
                        case 246: 
                        case 251: 
                        case 252: 
                        case 256: 
                        case 259: 
                        case 260: 
                        case 261: 
                        case 262: 
                        case 263: 
                        case 264: 
                        case 265: 
                        case 266: 
                        case 267: 
                        case 268: 
                        case 269: 
                        case 277: 
                        case 278: 
                        case 279: 
                        case 280: 
                        case 281: 
                        case 282: 
                        case 283: 
                        case 284: 
                        case 285: 
                        case 286: 
                        case 287: 
                        case 288: 
                        case 292: 
                        case 293: 
                        case 294: 
                        case 295: 
                        case 296: 
                        case 297: 
                        case 298: 
                        case 299: 
                        case 300: 
                        case 301: 
                        case 302: 
                        case 303: 
                        case 304: 
                        case 305: 
                        case 306: 
                        case 307: 
                        case 308: 
                        case 309: 
                        case 310: 
                        case 311: 
                        case 312: 
                        case 313: 
                        case 314: 
                        case 315: 
                        case 316: 
                        case 317: 
                        case 318: 
                        case 319: 
                        case 320: 
                        case 321: 
                        case 322: 
                        case 323: 
                        case 369: 
                        case 411: 
                        case 416: 
                        case 417: 
                        case 464: 
                        case 497: 
                        case 506: 
                        case 507: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 160: {
                            prevName = this.prev_name(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 183: 
                        case 184: 
                        case 188: 
                        case 189: 
                        case 191: 
                        case 192: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: 
                        case 198: 
                        case 199: 
                        case 200: 
                        case 201: 
                        case 202: 
                        case 203: 
                        case 204: 
                        case 205: 
                        case 206: 
                        case 207: 
                        case 208: 
                        case 209: 
                        case 210: 
                        case 211: 
                        case 212: 
                        case 213: 
                        case 214: 
                        case 215: 
                        case 216: 
                        case 217: 
                        case 218: 
                        case 219: 
                        case 220: 
                        case 221: 
                        case 222: 
                        case 223: 
                        case 224: 
                        case 225: 
                        case 226: 
                        case 227: 
                        case 228: 
                        case 229: 
                        case 230: 
                        case 231: 
                        case 232: 
                        case 233: 
                        case 234: 
                        case 235: 
                        case 236: 
                        case 237: 
                        case 238: 
                        case 239: 
                        case 240: 
                        case 241: 
                        case 242: 
                        case 243: 
                        case 244: 
                        case 245: 
                        case 246: 
                        case 251: 
                        case 252: 
                        case 256: 
                        case 259: 
                        case 260: 
                        case 261: 
                        case 262: 
                        case 263: 
                        case 264: 
                        case 265: 
                        case 266: 
                        case 267: 
                        case 268: 
                        case 269: 
                        case 277: 
                        case 278: 
                        case 279: 
                        case 280: 
                        case 281: 
                        case 282: 
                        case 283: 
                        case 284: 
                        case 285: 
                        case 286: 
                        case 287: 
                        case 288: 
                        case 292: 
                        case 293: 
                        case 294: 
                        case 295: 
                        case 296: 
                        case 297: 
                        case 298: 
                        case 299: 
                        case 300: 
                        case 301: 
                        case 302: 
                        case 303: 
                        case 304: 
                        case 305: 
                        case 306: 
                        case 307: 
                        case 308: 
                        case 309: 
                        case 310: 
                        case 311: 
                        case 312: 
                        case 313: 
                        case 314: 
                        case 315: 
                        case 316: 
                        case 317: 
                        case 318: 
                        case 319: 
                        case 320: 
                        case 321: 
                        case 322: 
                        case 323: 
                        case 369: 
                        case 411: 
                        case 416: 
                        case 417: 
                        case 464: 
                        case 497: 
                        case 506: 
                        case 507: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    typeContainer = this.expr(_t, null);
                    _t = this._retTree;
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.pushScopeLayer(ab);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    if (this.inputState.guessing() == 0) {
                        try {
                            RfActionBlockLayer def = this.getTransientScope(RfActionBlockLayer.class, ab);
                            if (def != null) {
                                RfVar indexVar;
                                if (typeContainer != null) {
                                    RfVar prevVar;
                                    RfVar itemVar = def.getLocalVariable(itemName, LineInfo.INFINITE, null);
                                    if (itemVar != null) {
                                        itemVar.setAssociatedTypeFrom(this.rfp, typeContainer, true);
                                    }
                                    if ((prevVar = def.getLocalVariable(prevName, LineInfo.INFINITE, null)) != null) {
                                        prevVar.setAssociatedTypeFrom(this.rfp, typeContainer, true);
                                    }
                                }
                                if ((indexVar = def.getLocalVariable(indexName, LineInfo.INFINITE, null)) != null) {
                                    indexVar.setAssociatedTypeFrom(this.rfp, new RfDummyField(this.rfp, this.UINT_TYPE));
                                }
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    this.expr_list(_t);
                    _t = this._retTree;
                    _t = __t152;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block38;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final String prev_name(AST _t) throws RecognitionException {
        String prevName;
        block15: {
            prevName = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST id = null;
            try {
                try {
                    AST __t161 = _t;
                    this.match(_t, 160);
                    _t = _t.getFirstChild();
                    id = _t == ASTNULL ? null : _t;
                    this.identifier(_t);
                    _t = this._retTree;
                    if (this.inputState.guessing() == 0) {
                        try {
                            prevName = id == null ? "prev" : id.getText();
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    _t = __t161;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return prevName;
    }

    public final void action(AST _t) throws RecognitionException {
        block63: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            final int stackScopeSize = this.getLastScopeLayerStackSize();
            if (this.inputState.guessing() == 0) {
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.cleanAllScopes(stackScopeSize);
                    }
                };
            }
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 100: {
                            this.action_block(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 101: {
                            this.preproc_ifdef_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 102: {
                            this.preproc_ifndef_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 103: {
                            this.user_defined_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 104: {
                            this.as_computed_user_defined_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 105: {
                            this.compute_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 106: {
                            this.return_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 108: {
                            this.var_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 112: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: 
                        case 118: 
                        case 119: 
                        case 120: 
                        case 121: 
                        case 122: 
                        case 123: 
                        case 124: 
                        case 125: {
                            this.assign_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 126: {
                            this.try_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 127: {
                            this.gen_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 128: {
                            this.do_seq_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 130: {
                            this.print_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 131: 
                        case 132: {
                            this.message_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 133: {
                            this.error_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 134: 
                        case 135: {
                            this.dut_error_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 136: {
                            this.check_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 138: {
                            this.assert_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 140: {
                            this.method_call_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 141: {
                            this.start_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 142: {
                            this.task_call_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 143: {
                            this.if_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 144: {
                            this.case_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 147: {
                            this.while_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 148: {
                            this.repeat_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 149: {
                            this.for_from_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 152: {
                            this.for_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 156: {
                            this.for_each_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 163: {
                            this.for_each_file_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 165: {
                            this.for_each_line_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 167: {
                            this.break_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 168: {
                            this.continue_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 169: {
                            this.force_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 170: {
                            this.release_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 171: {
                            this.emit_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 172: {
                            this.all_of_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 173: {
                            this.first_of_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 174: {
                            this.wait_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 175: {
                            this.sync_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 176: {
                            this.state_machine_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 107: {
                            this.report_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 8: {
                            this.statement_block_scope_restore(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 440: {
                            this.sln_action_block(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 182: {
                            this.expansion_literal_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 470: {
                            this.sdl_do_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 504: {
                            this.sdl_tool_editor_prioritize_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 505: {
                            this.sdl_tool_editor_avoid_action(_t);
                            _t = this._retTree;
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block63;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sln_scd_list(AST _t) throws RecognitionException {
        block21: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1122 = _t;
                    this.match(_t, 442);
                    _t = _t.getFirstChild();
                    block11: while (true) {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 443: 
                            case 444: 
                            case 445: 
                            case 446: 
                            case 447: 
                            case 448: 
                            case 449: 
                            case 450: 
                            case 451: 
                            case 452: 
                            case 453: {
                                this.sln_scd(_t);
                                _t = this._retTree;
                                continue block11;
                            }
                            case 401: {
                                this.user_defined_table_sln_scd(_t);
                                _t = this._retTree;
                                continue block11;
                            }
                            case 425: {
                                this.preproc_ifdef_sln_scd(_t);
                                _t = this._retTree;
                                continue block11;
                            }
                            case 426: {
                                this.preproc_ifndef_sln_scd(_t);
                                _t = this._retTree;
                                continue block11;
                            }
                            case 442: {
                                this.sln_scd_list(_t);
                                _t = this._retTree;
                                continue block11;
                            }
                        }
                        break;
                    }
                    _t = __t1122;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sln_action_block(AST _t) throws RecognitionException {
        block16: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST ab = null;
            final int stackScopeSize = this.getLastScopeLayerStackSize();
            if (this.inputState.guessing() == 0) {
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.cleanAllScopes(stackScopeSize);
                    }
                };
            }
            try {
                try {
                    AST __t169 = _t;
                    ab = _t == ASTNULL ? null : _t;
                    this.match(_t, 440);
                    _t = _t.getFirstChild();
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.pushScopeLayer(ab);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    this.sln_scd_list(_t);
                    _t = this._retTree;
                    _t = __t169;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void c_export_statement(AST _t) throws RecognitionException {
        block22: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST id = null;
            RfNamedElement result = null;
            try {
                try {
                    AST __t171 = _t;
                    this.match(_t, 44);
                    _t = _t.getFirstChild();
                    result = this.type(_t);
                    _t = this._retTree;
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 293: {
                            id = _t == ASTNULL ? null : _t;
                            this.identifier(_t);
                            _t = this._retTree;
                            if (this.inputState.guessing() != 0) break;
                            try {
                                if (!this.valid(result) || id == null) break;
                                IRfAssociatedType element = (IRfAssociatedType)((Object)result);
                                RfType assocType = (RfType)element.getAssociatedType();
                                if (assocType instanceof RfType) {
                                    result = assocType.semanticGetMember(this.rfp, element.getAssociatedTypeDeterminant(), this.packageName, this.getStruct(), id.getText(), METHOD, 31, this.maxModuleIndex, this.parserPath, null);
                                    this.module.createVariableDependency(this.rfp, result, id.getText());
                                    if (result == null) {
                                        LineInfo lineInfo = this.getMacroSafeLine(id);
                                        this.rfp.addSemanticError2(1, "UNDEFINED_METHOD: Method ''{0}'' is not a member of ''{1}''", lineInfo.getOffset(), lineInfo.getOffset() + id.getText().length(), null, lineInfo.line, this.parserPath, id.getText(), assocType.getName());
                                        result = ERROR_SCOPE;
                                        break;
                                    }
                                    if (result instanceof IllegalAccessError) {
                                        LineInfo lineInfo = this.getMacroSafeLine(id);
                                        this.rfp.addSemanticError2(1, "ILLEGAL_ACCESS: Cannot access {0} {1} ''{2}.{3}''", lineInfo.getOffset(), lineInfo.getOffset() + id.getText().length(), null, lineInfo.line, this.parserPath, ((IllegalAccessError)result).getAccessModifierText(), ((IllegalAccessError)result).getElementKindText(), ((IllegalAccessError)result).getParentName(), id.getText());
                                        result = ((IllegalAccessError)result).getElement();
                                        this.setTransientResult(id, new RfWNamedElementAndScope(result, assocType, true));
                                        break;
                                    }
                                    this.setTransientResult(id, new RfWNamedElementAndScope(result, assocType, true));
                                    break;
                                }
                                LineInfo lineInfo = this.getMacroSafeLine(id);
                                this.rfp.addSemanticError2(1, "UNRESOLVED_METHOD: Cannot resolve method ''{0}'' (unresolved preceding expression)", lineInfo.getOffset(), lineInfo.getOffset() + id.getText().length(), null, lineInfo.line, this.parserPath, id.getText());
                                result = ERROR_SCOPE;
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t171;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sln_field_keeping_constraints(AST _t, RfNamedElement typeContainer) throws RecognitionException {
        block17: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t718 = _t;
                    this.match(_t, 463);
                    _t = _t.getFirstChild();
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 187: {
                            this.expr_list_sfkc(_t, typeContainer);
                            _t = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t718;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sdl_field_constraint(AST _t, RfNamedElement declaredField) throws RecognitionException {
        block16: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            if (this.inputState.guessing() == 0) {
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.excludeVar = null;
                    }
                };
            }
            try {
                try {
                    AST __t843 = _t;
                    this.match(_t, 488);
                    _t = _t.getFirstChild();
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.excludeVar = declaredField;
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    this.expr(_t);
                    _t = this._retTree;
                    _t = __t843;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final RfNamedElement sdl_field_sample_value(AST _t, RfNamedElement typeContainer) throws RecognitionException {
        RfNamedElement result;
        block12: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t721 = _t;
                    this.match(_t, 489);
                    _t = _t.getFirstChild();
                    result = this.expr(_t, typeContainer);
                    _t = this._retTree;
                    _t = __t721;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final void sdl_field_sample_event(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1149 = _t;
                    this.match(_t, 490);
                    _t = _t.getFirstChild();
                    this.event(_t);
                    _t = this._retTree;
                    _t = __t1149;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sdl_field_sample_where(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1151 = _t;
                    this.match(_t, 491);
                    _t = _t.getFirstChild();
                    this.expr(_t);
                    _t = this._retTree;
                    _t = __t1151;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void sdl_field_member_block(AST _t, RfNamedElement typeContainer) throws RecognitionException {
        block19: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST ab = null;
            final int stackScopeSize = this.getLastScopeLayerStackSize();
            if (this.inputState.guessing() == 0) {
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.cleanAllScopes(stackScopeSize);
                    }
                };
            }
            try {
                try {
                    AST __t723 = _t;
                    ab = _t == ASTNULL ? null : _t;
                    this.match(_t, 486);
                    _t = _t.getFirstChild();
                    if (this.inputState.guessing() == 0) {
                        try {
                            RfVar itemVar;
                            this.pushScopeLayer(ab);
                            RfActionBlockLayer def = this.getTransientScope(RfActionBlockLayer.class, ab);
                            if (def != null && typeContainer != null && (itemVar = def.getLocalVariable("it", LineInfo.INFINITE, null)) != null) {
                                itemVar.setAssociatedTypeFrom(this.rfp, typeContainer);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    while (true) {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (_t.getType() != 487 && _t.getType() != 493 && _t.getType() != 494) break;
                        this.sdl_field_member(_t);
                        _t = this._retTree;
                    }
                    _t = __t723;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final RfNamedElement event_body(AST _t) throws RecognitionException {
        RfNamedElement result;
        block18: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 378: {
                            AST __t190 = _t;
                            this.match(_t, 378);
                            _t = _t.getFirstChild();
                            result = this.temporal_expr(_t);
                            _t = this._retTree;
                            _t = __t190;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 377: {
                            AST __t191 = _t;
                            this.match(_t, 377);
                            _t = _t.getFirstChild();
                            result = this.temporal_expr(_t);
                            _t = this._retTree;
                            _t = __t191;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 376: {
                            this.match(_t, 376);
                            _t = _t.getNextSibling();
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final void sdl_when_expr(AST _t, RfNamedElement rfEvent) throws RecognitionException {
        block20: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST swe = null;
            final int stackScopeSize = this.getLastScopeLayerStackSize();
            if (this.inputState.guessing() == 0) {
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.cleanAllScopes(stackScopeSize);
                    }
                };
            }
            try {
                try {
                    AST __t774 = _t;
                    swe = _t == ASTNULL ? null : _t;
                    this.match(_t, 509);
                    _t = _t.getFirstChild();
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.pushScopeLayer(swe);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    if (this.inputState.guessing() == 0) {
                        try {
                            RfVar itemVar;
                            RfStruct eventScenario;
                            RfStruct enclosingStruct;
                            RfActionBlockLayer def = this.getTransientScope(RfActionBlockLayer.class, swe);
                            if (def != null && rfEvent instanceof RfEvent && (enclosingStruct = ((RfEvent)rfEvent).getParentStruct()) != null && enclosingStruct.isSDLAgent() && (eventScenario = enclosingStruct.getSDLScenario(rfEvent.getName())) != null && (itemVar = def.getLocalVariable("it", LineInfo.INFINITE, null)) != null) {
                                itemVar.setAssociatedType(eventScenario);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    this.expr(_t);
                    _t = this._retTree;
                    _t = __t774;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void using_temporal_operators(AST _t) throws RecognitionException {
        block18: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1046 = _t;
                    this.match(_t, 187);
                    _t = _t.getFirstChild();
                    block8: while (true) {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 341: 
                            case 342: 
                            case 343: 
                            case 344: 
                            case 345: 
                            case 346: 
                            case 347: 
                            case 348: 
                            case 349: 
                            case 350: 
                            case 351: 
                            case 352: 
                            case 353: 
                            case 354: 
                            case 355: 
                            case 356: 
                            case 357: 
                            case 358: 
                            case 359: 
                            case 360: 
                            case 421: 
                            case 422: {
                                this.temporal_expr(_t);
                                _t = this._retTree;
                                continue block8;
                            }
                            case 293: {
                                this.identifier(_t);
                                _t = this._retTree;
                                continue block8;
                            }
                        }
                        break;
                    }
                    _t = __t1046;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final RfNamedElement temporal_expr(AST _t) throws RecognitionException {
        RfNamedElement result;
        block50: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 341: {
                            this.match(_t, 341);
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 342: {
                            AST __t193 = _t;
                            this.match(_t, 342);
                            _t = _t.getFirstChild();
                            result = this.event(_t);
                            _t = this._retTree;
                            _t = __t193;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 343: {
                            AST __t194 = _t;
                            this.match(_t, 343);
                            _t = _t.getFirstChild();
                            this.expr(_t);
                            _t = this._retTree;
                            _t = __t194;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 344: {
                            AST __t195 = _t;
                            this.match(_t, 344);
                            _t = _t.getFirstChild();
                            this.expr(_t);
                            _t = this._retTree;
                            _t = __t195;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 345: {
                            AST __t196 = _t;
                            this.match(_t, 345);
                            _t = _t.getFirstChild();
                            this.expr(_t);
                            _t = this._retTree;
                            _t = __t196;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 346: {
                            AST __t197 = _t;
                            this.match(_t, 346);
                            _t = _t.getFirstChild();
                            this.expr(_t);
                            _t = this._retTree;
                            _t = __t197;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 347: {
                            AST __t198 = _t;
                            this.match(_t, 347);
                            _t = _t.getFirstChild();
                            this.temporal_expr(_t);
                            _t = this._retTree;
                            this.event(_t);
                            _t = this._retTree;
                            _t = __t198;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 348: {
                            AST __t199 = _t;
                            this.match(_t, 348);
                            _t = _t.getFirstChild();
                            this.temporal_expr(_t);
                            _t = this._retTree;
                            this.temporal_expr(_t);
                            _t = this._retTree;
                            _t = __t199;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 349: {
                            AST __t200 = _t;
                            this.match(_t, 349);
                            _t = _t.getFirstChild();
                            this.temporal_expr(_t);
                            _t = this._retTree;
                            this.temporal_expr(_t);
                            _t = this._retTree;
                            _t = __t200;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 350: {
                            AST __t201 = _t;
                            this.match(_t, 350);
                            _t = _t.getFirstChild();
                            this.temporal_expr(_t);
                            _t = this._retTree;
                            this.temporal_expr(_t);
                            _t = this._retTree;
                            _t = __t201;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 351: {
                            AST __t202 = _t;
                            this.match(_t, 351);
                            _t = _t.getFirstChild();
                            this.range_element(_t);
                            _t = this._retTree;
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            switch (_t.getType()) {
                                case 341: 
                                case 342: 
                                case 343: 
                                case 344: 
                                case 345: 
                                case 346: 
                                case 347: 
                                case 348: 
                                case 349: 
                                case 350: 
                                case 351: 
                                case 352: 
                                case 353: 
                                case 354: 
                                case 355: 
                                case 356: 
                                case 357: 
                                case 358: 
                                case 359: 
                                case 360: 
                                case 421: 
                                case 422: {
                                    this.temporal_expr(_t);
                                    _t = this._retTree;
                                    break;
                                }
                                case 3: {
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltException(_t);
                                }
                            }
                            _t = __t202;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 352: {
                            AST __t205 = _t;
                            this.match(_t, 352);
                            _t = _t.getFirstChild();
                            this.range_element(_t);
                            _t = this._retTree;
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            switch (_t.getType()) {
                                case 341: 
                                case 342: 
                                case 343: 
                                case 344: 
                                case 345: 
                                case 346: 
                                case 347: 
                                case 348: 
                                case 349: 
                                case 350: 
                                case 351: 
                                case 352: 
                                case 353: 
                                case 354: 
                                case 355: 
                                case 356: 
                                case 357: 
                                case 358: 
                                case 359: 
                                case 360: 
                                case 421: 
                                case 422: {
                                    this.temporal_expr(_t);
                                    _t = this._retTree;
                                    break;
                                }
                                case 3: {
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltException(_t);
                                }
                            }
                            _t = __t205;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 353: {
                            AST __t208 = _t;
                            this.match(_t, 353);
                            _t = _t.getFirstChild();
                            int _cnt210 = 0;
                            while (true) {
                                if (_t == null) {
                                    _t = ASTNULL;
                                }
                                if (!_tokenSet_15.member(_t.getType())) {
                                    if (_cnt210 >= 1) break;
                                    throw this.getNoViableAltException(_t);
                                }
                                this.temporal_expr(_t);
                                _t = this._retTree;
                                ++_cnt210;
                            }
                            _t = __t208;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 354: {
                            AST __t211 = _t;
                            this.match(_t, 354);
                            _t = _t.getFirstChild();
                            this.temporal_expr(_t);
                            _t = this._retTree;
                            _t = __t211;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 355: {
                            AST __t212 = _t;
                            this.match(_t, 355);
                            _t = _t.getFirstChild();
                            this.temporal_expr(_t);
                            _t = this._retTree;
                            _t = __t212;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 356: {
                            AST __t213 = _t;
                            this.match(_t, 356);
                            _t = _t.getFirstChild();
                            this.temporal_expr(_t);
                            _t = this._retTree;
                            _t = __t213;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 357: {
                            AST __t214 = _t;
                            this.match(_t, 357);
                            _t = _t.getFirstChild();
                            this.temporal_expr(_t);
                            _t = this._retTree;
                            _t = __t214;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 358: {
                            AST __t215 = _t;
                            this.match(_t, 358);
                            _t = _t.getFirstChild();
                            this.temporal_expr(_t);
                            _t = this._retTree;
                            this.action_block(_t);
                            _t = this._retTree;
                            _t = __t215;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 359: {
                            AST __t216 = _t;
                            this.match(_t, 359);
                            _t = _t.getFirstChild();
                            this.expr(_t);
                            _t = this._retTree;
                            _t = __t216;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 360: {
                            AST __t217 = _t;
                            this.match(_t, 360);
                            _t = _t.getFirstChild();
                            this.temporal_expr(_t);
                            _t = this._retTree;
                            _t = __t217;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 421: {
                            this.preproc_ifdef_temporal_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 422: {
                            this.preproc_ifndef_temporal_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block50;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement range_element(AST _t, RfNamedElement lhScope) throws RecognitionException {
        RfNamedElement result;
        block27: {
            Runnable finalRunnable;
            block26: {
                result = null;
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST id = null;
                try {
                    try {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (_t.getType() == 253) {
                            result = this.range(_t, lhScope);
                            _t = this._retTree;
                            break block26;
                        }
                        boolean synPredMatched545 = false;
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (_t.getType() == 293) {
                            AST __t545 = _t;
                            synPredMatched545 = true;
                            this.inputState.incGuessing();
                            try {
                                this.identifier(_t);
                                _t = this._retTree;
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched545 = false;
                            }
                            _t = __t545;
                            this.inputState.decGuessing(synPredMatched545);
                        }
                        if (synPredMatched545) {
                            id = _t == ASTNULL ? null : _t;
                            this.identifier(_t);
                            _t = this._retTree;
                            if (this.inputState.guessing() != 0) break block26;
                            try {
                                if (id != null && lhScope != ERROR_SCOPE) {
                                    RfWNamedElementAndScope elementAndScope = this.resolveIdentifier(id, FIELD_VARIABLE, false);
                                    elementAndScope = this.resolvePotentialEnum(id, elementAndScope, lhScope, false);
                                    this.module.createVariableDependency(this.rfp, this.getNamedElement(elementAndScope), id.getText());
                                    result = this.getNamedElement(elementAndScope);
                                    if (result != null || !(lhScope instanceof IRfAssociatedType) || !(((IRfAssociatedType)((Object)lhScope)).getAssociatedBaseType() instanceof IRfTemplateParam)) {
                                        if (result == null) {
                                            LineInfo lineInfo = this.getMacroSafeLine(id);
                                            HashMap<String, Object> attributes = new HashMap<String, Object>();
                                            attributes.put("QUICKFIX_ELEMENT_NAME", id.getText());
                                            attributes.put("QUICKFIX_KIND", 1);
                                            this.rfp.addSemanticError2(1, "UNDEFINED_IDENTIFIER: Identifier ''{0}'' is not defined", lineInfo.getOffset(), lineInfo.getOffset() + id.getText().length(), attributes, lineInfo.line, this.parserPath, id.getText());
                                            elementAndScope = null;
                                            result = RfUndefVariable.create(this.rfp, id.getText()).type(lhScope);
                                            this.setTransientResult(id, result);
                                        } else if (result instanceof IllegalAccessError) {
                                            LineInfo lineInfo = this.getMacroSafeLine(id);
                                            this.rfp.addSemanticError2(1, "ILLEGAL_ACCESS: Cannot access {0} {1} ''{2}.{3}''", lineInfo.getOffset(), lineInfo.getOffset() + id.getText().length(), null, lineInfo.line, this.parserPath, ((IllegalAccessError)result).getAccessModifierText(), ((IllegalAccessError)result).getElementKindText(), ((IllegalAccessError)result).getParentName(), id.getText());
                                            result = ((IllegalAccessError)result).getElement();
                                        }
                                    }
                                    this.setTransientResult(id, elementAndScope);
                                }
                                break block26;
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break block26;
                        }
                        if (_tokenSet_4.member(_t.getType())) {
                            result = this.expr(_t, null);
                            _t = this._retTree;
                            break block26;
                        }
                        throw this.getNoViableAltException(_t);
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block27;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final void preproc_ifdef_temporal_expr(AST _t) throws RecognitionException {
        block17: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1300 = _t;
                    this.match(_t, 421);
                    _t = _t.getFirstChild();
                    this.preproc_id(_t);
                    _t = this._retTree;
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 341: 
                        case 342: 
                        case 343: 
                        case 344: 
                        case 345: 
                        case 346: 
                        case 347: 
                        case 348: 
                        case 349: 
                        case 350: 
                        case 351: 
                        case 352: 
                        case 353: 
                        case 354: 
                        case 355: 
                        case 356: 
                        case 357: 
                        case 358: 
                        case 359: 
                        case 360: 
                        case 366: 
                        case 421: 
                        case 422: {
                            this.preproc_temporal_expr_block(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t1300;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void preproc_ifndef_temporal_expr(AST _t) throws RecognitionException {
        block17: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1303 = _t;
                    this.match(_t, 422);
                    _t = _t.getFirstChild();
                    this.preproc_id(_t);
                    _t = this._retTree;
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 341: 
                        case 342: 
                        case 343: 
                        case 344: 
                        case 345: 
                        case 346: 
                        case 347: 
                        case 348: 
                        case 349: 
                        case 350: 
                        case 351: 
                        case 352: 
                        case 353: 
                        case 354: 
                        case 355: 
                        case 356: 
                        case 357: 
                        case 358: 
                        case 359: 
                        case 360: 
                        case 366: 
                        case 421: 
                        case 422: {
                            this.preproc_temporal_expr_block(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t1303;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void dut_error_action(AST _t) throws RecognitionException {
        block27: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 134: {
                            AST __t1226 = _t;
                            this.match(_t, 134);
                            _t = _t.getFirstChild();
                            this.expr_list(_t);
                            _t = this._retTree;
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            switch (_t.getType()) {
                                case 100: {
                                    this.action_block(_t);
                                    _t = this._retTree;
                                    break;
                                }
                                case 3: {
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltException(_t);
                                }
                            }
                            _t = __t1226;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 135: {
                            AST __t1228 = _t;
                            this.match(_t, 135);
                            _t = _t.getFirstChild();
                            this.expr_list(_t);
                            _t = this._retTree;
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            switch (_t.getType()) {
                                case 100: {
                                    this.action_block(_t);
                                    _t = this._retTree;
                                    break;
                                }
                                case 3: {
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltException(_t);
                                }
                            }
                            _t = __t1228;
                            _t = _t.getNextSibling();
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block27;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void expect_body(AST _t) throws RecognitionException {
        block18: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 378: {
                            AST __t1054 = _t;
                            this.match(_t, 378);
                            _t = _t.getFirstChild();
                            this.temporal_expr(_t);
                            _t = this._retTree;
                            _t = __t1054;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 377: {
                            AST __t1055 = _t;
                            this.match(_t, 377);
                            _t = _t.getFirstChild();
                            this.temporal_expr(_t);
                            _t = this._retTree;
                            _t = __t1055;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 376: {
                            this.match(_t, 376);
                            _t = _t.getNextSibling();
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void keep_expr(AST _t, RfNamedElement lhScope, boolean isSoft) throws RecognitionException {
        block36: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST exp = null;
            RfNamedElement result = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 396: {
                            this.user_defined_constraint(_t, lhScope);
                            _t = this._retTree;
                            break;
                        }
                        case 397: {
                            this.as_computed_user_defined_constraint(_t);
                            _t = this._retTree;
                            break;
                        }
                        default: {
                            boolean synPredMatched242 = false;
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            if (_t.getType() == 277) {
                                AST __t242 = _t;
                                synPredMatched242 = true;
                                this.inputState.incGuessing();
                                try {
                                    this.match(_t, 277);
                                    _t = _t.getNextSibling();
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched242 = false;
                                }
                                _t = __t242;
                                this.inputState.decGuessing(synPredMatched242);
                            }
                            if (synPredMatched242) {
                                this.keep_soft_expr(_t, lhScope);
                                _t = this._retTree;
                                break;
                            }
                            boolean synPredMatched244 = false;
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            if (_t.getType() == 245) {
                                AST __t244 = _t;
                                synPredMatched244 = true;
                                this.inputState.incGuessing();
                                try {
                                    this.match(_t, 245);
                                    _t = _t.getNextSibling();
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched244 = false;
                                }
                                _t = __t244;
                                this.inputState.decGuessing(synPredMatched244);
                            }
                            if (synPredMatched244) {
                                this.keep_list_concat_expr(_t, lhScope);
                                _t = this._retTree;
                                break;
                            }
                            boolean synPredMatched246 = false;
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            if (_t.getType() == 204 || _t.getType() == 267) {
                                AST __t246 = _t;
                                synPredMatched246 = true;
                                this.inputState.incGuessing();
                                try {
                                    this.select_constr_expr(_t, true);
                                    _t = this._retTree;
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched246 = false;
                                }
                                _t = __t246;
                                this.inputState.decGuessing(synPredMatched246);
                            }
                            if (synPredMatched246) {
                                this.select_constr_expr(_t, isSoft);
                                _t = this._retTree;
                                break;
                            }
                            if (_tokenSet_4.member(_t.getType())) {
                                exp = _t == ASTNULL ? null : _t;
                                result = this.expr(_t, null);
                                _t = this._retTree;
                                if (this.inputState.guessing() != 0) break;
                                try {
                                    if (this.valid(result) && exp != null && exp.getType() != 191) {
                                        SemanticUtils.incompatibleAssign(this.rfp, this.parserPath, this.macroDepth, this.macroLineInfo, null, exp, this.ELEM_OF_BOOL_TYPE, result, SemanticUtils.AssignKind.COMPARE);
                                    }
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                                break;
                            }
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block36;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void keep_soft_expr(AST _t, RfNamedElement lhScope) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t248 = _t;
                    this.match(_t, 277);
                    _t = _t.getFirstChild();
                    this.keep_expr(_t, lhScope, true);
                    _t = this._retTree;
                    _t = __t248;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void select_constr_expr(AST _t, boolean isSoft) throws RecognitionException {
        block24: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST select = null;
            AST id = null;
            AST select2 = null;
            RfNamedElement lhScope = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 204: {
                            AST __t254 = _t;
                            this.match(_t, 204);
                            _t = _t.getFirstChild();
                            lhScope = this.expr(_t, null);
                            _t = this._retTree;
                            select = _t == ASTNULL ? null : _t;
                            this.select_expr(_t, lhScope);
                            _t = this._retTree;
                            _t = __t254;
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() != 0) break;
                            try {
                                if (!isSoft && select != null) {
                                    LineInfo lineInfo = this.getMacroSafeLine(select);
                                    this.rfp.addSemanticError2(1, "INVALID_SELECT_CONSTRAINT: Select constraint must be defined as ''soft''", lineInfo.getOffset(), lineInfo.getOffset() + select.getText().length(), null, lineInfo.line, this.parserPath, new Object[0]);
                                }
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break;
                        }
                        case 267: {
                            AST __t255 = _t;
                            this.match(_t, 267);
                            _t = _t.getFirstChild();
                            lhScope = this.expr(_t, null);
                            AST __t256 = _t = this._retTree;
                            this.match(_t, 187);
                            AST __t257 = _t = _t.getFirstChild();
                            this.match(_t, 204);
                            _t = _t.getFirstChild();
                            id = _t == ASTNULL ? null : _t;
                            this.identifier(_t);
                            _t = this._retTree;
                            select2 = _t == ASTNULL ? null : _t;
                            this.select_expr(_t, lhScope);
                            _t = this._retTree;
                            _t = __t257;
                            _t = _t.getNextSibling();
                            _t = __t256;
                            _t = _t.getNextSibling();
                            _t = __t255;
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() != 0) break;
                            try {
                                LineInfo lineInfo;
                                if (!isSoft && select2 != null) {
                                    lineInfo = this.getMacroSafeLine(select2);
                                    this.rfp.addSemanticError2(1, "INVALID_SELECT_CONSTRAINT: Select constraint must be defined as ''soft''", lineInfo.getOffset(), lineInfo.getOffset() + select2.getText().length(), null, lineInfo.line, this.parserPath, new Object[0]);
                                }
                                if (id != null && !"it".equals(id.getText())) {
                                    lineInfo = this.getMacroSafeLine(id);
                                    this.rfp.addSemanticError2(1, "UNDEFINED_IDENTIFIER: Identifier ''{0}'' is not defined", lineInfo.getOffset(), lineInfo.getOffset() + id.getText().length(), null, lineInfo.line, this.parserPath, id.getText());
                                }
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void as_computed_user_defined_constraint(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1027 = _t;
                    this.match(_t, 397);
                    _t = _t.getFirstChild();
                    this.define_name(_t);
                    _t = this._retTree;
                    this.replacement_term_list(_t);
                    _t = this._retTree;
                    _t = __t1027;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final RfNamedElement select_expr(AST _t, RfNamedElement lhScope) throws RecognitionException {
        RfNamedElement result;
        block12: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t584 = _t;
                    this.match(_t, 269);
                    _t = _t.getFirstChild();
                    result = this.selection_list(_t, lhScope);
                    _t = this._retTree;
                    _t = __t584;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final void as_computed_user_defined_type(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t267 = _t;
                    this.match(_t, 325);
                    _t = _t.getFirstChild();
                    this.define_name(_t);
                    _t = this._retTree;
                    this.replacement_term_list(_t);
                    _t = this._retTree;
                    _t = __t267;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final RfNamedElement scalar_type(AST _t) throws RecognitionException {
        RfNamedElement result;
        block35: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST id = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 326: {
                            AST __t269 = _t;
                            this.match(_t, 326);
                            _t = _t.getFirstChild();
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            switch (_t.getType()) {
                                case 35: 
                                case 293: 
                                case 326: 
                                case 327: {
                                    result = this.scalar_type(_t);
                                    _t = this._retTree;
                                    break;
                                }
                                case 409: {
                                    result = this.qualified_type(_t);
                                    _t = this._retTree;
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltException(_t);
                                }
                            }
                            this.width_unit(_t);
                            _t = this._retTree;
                            this.width_size(_t);
                            _t = this._retTree;
                            _t = __t269;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 327: {
                            AST __t271 = _t;
                            this.match(_t, 327);
                            _t = _t.getFirstChild();
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            switch (_t.getType()) {
                                case 35: 
                                case 293: 
                                case 326: 
                                case 327: {
                                    result = this.scalar_type(_t);
                                    _t = this._retTree;
                                    break;
                                }
                                case 409: {
                                    result = this.qualified_type(_t);
                                    _t = this._retTree;
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltException(_t);
                                }
                            }
                            int _cnt274 = 0;
                            while (true) {
                                if (_t == null) {
                                    _t = ASTNULL;
                                }
                                if (!_tokenSet_16.member(_t.getType())) {
                                    if (_cnt274 >= 1) break;
                                    throw this.getNoViableAltException(_t);
                                }
                                this.range_element(_t, result);
                                _t = this._retTree;
                                ++_cnt274;
                            }
                            _t = __t271;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 35: {
                            result = this.enum_item_list(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 293: {
                            id = _t == ASTNULL ? null : _t;
                            this.identifier(_t);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = this.getTransientResult(RfNamedElement.class, id);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block35;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement struct_subtype(AST _t) throws RecognitionException {
        RfNamedElement result;
        block30: {
            Runnable finalRunnable;
            block29: {
                result = null;
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST sq = null;
                AST id = null;
                ArrayList<AST> sqs = new ArrayList<AST>();
                AST root = _t;
                try {
                    try {
                        int _cnt283 = 0;
                        while (true) {
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            if (_t.getType() == 40) {
                                sq = _t == ASTNULL ? null : _t;
                                this.struct_qualifier(_t, null);
                                _t = this._retTree;
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        sqs.add(sq);
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                            } else {
                                if (_cnt283 >= 1) break;
                                throw this.getNoViableAltException(_t);
                            }
                            ++_cnt283;
                        }
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 293: {
                                id = _t == ASTNULL ? null : _t;
                                this.identifier(_t);
                                _t = this._retTree;
                                break;
                            }
                            case 409: {
                                this.qualified_type(_t);
                                _t = this._retTree;
                                break;
                            }
                            case 412: {
                                this.template_instance(_t);
                                _t = this._retTree;
                                break;
                            }
                            case 410: {
                                this.param_type(_t);
                                _t = this._retTree;
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        if (this.inputState.guessing() != 0) break block29;
                        try {
                            IRfNamedElement assocType;
                            result = this.getTransientResult(RfNamedElement.class, root);
                            if (result != null && this.valid(result) && (assocType = ((IRfAssociatedType)((Object)result)).getAssociatedType()) instanceof RfStruct) {
                                RfStruct struct = (RfStruct)assocType;
                                Determinant determinant = new Determinant(new String[]{struct.getName()});
                                int i = sqs.size() - 1;
                                while (i >= 0) {
                                    AST qualifierAST = (AST)sqs.get(i);
                                    this.struct_qualifier_check(qualifierAST, struct, determinant);
                                    determinant = new Determinant(new String[]{qualifierAST.getText()}, determinant.toArray());
                                    --i;
                                }
                                this.setTransientResult(id, new RfSubtypeElement(this.rfp, null, struct, determinant));
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block30;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement port_type(AST _t) throws RecognitionException {
        RfNamedElement result;
        block73: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST sp = null;
            AST bp = null;
            AST mp = null;
            AST ip = null;
            AST tp = null;
            AST ep = null;
            AST cp = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 332: {
                            AST __t298 = _t;
                            sp = _t == ASTNULL ? null : _t;
                            this.match(_t, 332);
                            _t = _t.getFirstChild();
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            switch (_t.getType()) {
                                case 92: 
                                case 93: 
                                case 94: {
                                    this.direction(_t);
                                    _t = this._retTree;
                                    break;
                                }
                                case 35: 
                                case 40: 
                                case 293: 
                                case 324: 
                                case 325: 
                                case 326: 
                                case 327: 
                                case 331: 
                                case 332: 
                                case 333: 
                                case 334: 
                                case 335: 
                                case 336: 
                                case 337: 
                                case 338: 
                                case 379: 
                                case 409: 
                                case 410: 
                                case 412: 
                                case 418: {
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltException(_t);
                                }
                            }
                            this.type(_t);
                            _t = this._retTree;
                            _t = __t298;
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = this.getTransientResult(RfNamedElement.class, sp);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 333: {
                            AST __t300 = _t;
                            bp = _t == ASTNULL ? null : _t;
                            this.match(_t, 333);
                            _t = _t.getFirstChild();
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            switch (_t.getType()) {
                                case 92: 
                                case 93: 
                                case 94: {
                                    this.direction(_t);
                                    _t = this._retTree;
                                    break;
                                }
                                case 35: 
                                case 40: 
                                case 293: 
                                case 324: 
                                case 325: 
                                case 326: 
                                case 327: 
                                case 331: 
                                case 332: 
                                case 333: 
                                case 334: 
                                case 335: 
                                case 336: 
                                case 337: 
                                case 338: 
                                case 379: 
                                case 409: 
                                case 410: 
                                case 412: 
                                case 418: {
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltException(_t);
                                }
                            }
                            this.type(_t);
                            _t = this._retTree;
                            _t = __t300;
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = this.getTransientResult(RfNamedElement.class, bp);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 334: {
                            AST __t302 = _t;
                            mp = _t == ASTNULL ? null : _t;
                            this.match(_t, 334);
                            _t = _t.getFirstChild();
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            switch (_t.getType()) {
                                case 92: 
                                case 93: 
                                case 94: {
                                    this.direction(_t);
                                    _t = this._retTree;
                                    break;
                                }
                                case 35: 
                                case 40: 
                                case 293: 
                                case 324: 
                                case 325: 
                                case 326: 
                                case 327: 
                                case 331: 
                                case 332: 
                                case 333: 
                                case 334: 
                                case 335: 
                                case 336: 
                                case 337: 
                                case 338: 
                                case 379: 
                                case 409: 
                                case 410: 
                                case 412: 
                                case 418: {
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltException(_t);
                                }
                            }
                            this.type(_t);
                            _t = this._retTree;
                            _t = __t302;
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = this.getTransientResult(RfNamedElement.class, mp);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 331: {
                            AST __t304 = _t;
                            ip = _t == ASTNULL ? null : _t;
                            this.match(_t, 331);
                            _t = _t.getFirstChild();
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            switch (_t.getType()) {
                                case 92: 
                                case 93: 
                                case 94: {
                                    this.direction(_t);
                                    _t = this._retTree;
                                    break;
                                }
                                case 35: 
                                case 40: 
                                case 293: 
                                case 324: 
                                case 325: 
                                case 326: 
                                case 327: 
                                case 331: 
                                case 332: 
                                case 333: 
                                case 334: 
                                case 335: 
                                case 336: 
                                case 337: 
                                case 338: 
                                case 379: 
                                case 409: 
                                case 410: 
                                case 412: 
                                case 418: {
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltException(_t);
                                }
                            }
                            this.type(_t);
                            _t = this._retTree;
                            _t = __t304;
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = this.getTransientResult(RfNamedElement.class, ip);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 337: {
                            AST __t306 = _t;
                            tp = _t == ASTNULL ? null : _t;
                            this.match(_t, 337);
                            _t = _t.getFirstChild();
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            switch (_t.getType()) {
                                case 92: 
                                case 93: 
                                case 94: {
                                    this.direction(_t);
                                    _t = this._retTree;
                                    break;
                                }
                                case 35: 
                                case 40: 
                                case 293: 
                                case 324: 
                                case 325: 
                                case 326: 
                                case 327: 
                                case 331: 
                                case 332: 
                                case 333: 
                                case 334: 
                                case 335: 
                                case 336: 
                                case 337: 
                                case 338: 
                                case 379: 
                                case 409: 
                                case 410: 
                                case 412: 
                                case 418: {
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltException(_t);
                                }
                            }
                            this.type(_t);
                            _t = this._retTree;
                            _t = __t306;
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = this.getTransientResult(RfNamedElement.class, tp);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 335: {
                            AST __t308 = _t;
                            ep = _t == ASTNULL ? null : _t;
                            this.match(_t, 335);
                            _t = _t.getFirstChild();
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            switch (_t.getType()) {
                                case 92: 
                                case 93: 
                                case 94: {
                                    this.direction(_t);
                                    _t = this._retTree;
                                    break;
                                }
                                case 3: {
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltException(_t);
                                }
                            }
                            _t = __t308;
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = this.getTransientResult(RfNamedElement.class, ep);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 336: {
                            AST __t310 = _t;
                            cp = _t == ASTNULL ? null : _t;
                            this.match(_t, 336);
                            _t = _t.getFirstChild();
                            this.identifier(_t);
                            _t = this._retTree;
                            this.type(_t);
                            _t = this._retTree;
                            _t = __t310;
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = this.getTransientResult(RfNamedElement.class, cp);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block73;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement list_type(AST _t) throws RecognitionException {
        RfNamedElement result;
        block20: {
            Runnable finalRunnable;
            block19: {
                result = null;
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST lt = null;
                try {
                    try {
                        AST __t312 = _t;
                        lt = _t == ASTNULL ? null : _t;
                        this.match(_t, 338);
                        _t = _t.getFirstChild();
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 339: {
                                this.list_key(_t, lt);
                                _t = this._retTree;
                                break;
                            }
                            case 35: 
                            case 40: 
                            case 293: 
                            case 324: 
                            case 325: 
                            case 326: 
                            case 327: 
                            case 331: 
                            case 332: 
                            case 333: 
                            case 334: 
                            case 335: 
                            case 336: 
                            case 337: 
                            case 338: 
                            case 379: 
                            case 409: 
                            case 410: 
                            case 412: 
                            case 418: {
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        result = this.type(_t);
                        _t = this._retTree;
                        _t = __t312;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block19;
                        try {
                            if (result == null || !this.valid(result)) break block19;
                            RfType assocType = (RfType)((IRfAssociatedType)((Object)result)).getAssociatedBaseType();
                            Determinant assocDeterminant = ((IRfAssociatedType)((Object)result)).getAssociatedTypeDeterminant();
                            String assocListKey = ((IRfAssociatedType)((Object)result)).getAssociatedTypeListKey();
                            int assocListDepth = ((IRfAssociatedType)((Object)result)).getAssociatedTypeList();
                            if (assocType instanceof RfType) {
                                assocType = RfListType.listFromType(this.rfp, assocType, assocDeterminant, assocListKey, assocListDepth + 1);
                                result = new RfDummyField(this.rfp, (IRfNamedElement)assocType, assocDeterminant);
                                break block19;
                            }
                            result = ERROR_SCOPE;
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement param_type(AST _t) throws RecognitionException {
        RfNamedElement result;
        block15: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST tpt = null;
            try {
                try {
                    tpt = _t;
                    this.match(_t, 410);
                    _t = _t.getNextSibling();
                    if (this.inputState.guessing() == 0) {
                        try {
                            result = this.getTransientResult(RfNamedElement.class, tpt);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement template_instance(AST _t) throws RecognitionException {
        RfNamedElement result;
        block20: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST ti = null;
            try {
                try {
                    AST __t319 = _t;
                    ti = _t == ASTNULL ? null : _t;
                    this.match(_t, 412);
                    _t = _t.getFirstChild();
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 409: {
                            this.qualified_type(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 293: {
                            this.identifier(_t);
                            _t = this._retTree;
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (this.inputState.guessing() == 0) {
                        try {
                            result = this.getTransientResult(RfNamedElement.class, ti);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    this.template_parameters(_t, result);
                    _t = this._retTree;
                    _t = __t319;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement typeof_type(AST _t) throws RecognitionException {
        RfNamedElement result;
        block15: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST tt = null;
            try {
                try {
                    AST __t265 = _t;
                    tt = _t == ASTNULL ? null : _t;
                    this.match(_t, 418);
                    _t = _t.getFirstChild();
                    result = this.expr(_t, null);
                    _t = this._retTree;
                    _t = __t265;
                    _t = _t.getNextSibling();
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.setTransientResult(tt, result);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement anonymous_ref_type(AST _t) throws RecognitionException {
        RfNamedElement result;
        block15: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST ar = null;
            try {
                try {
                    AST __t262 = _t;
                    ar = _t == ASTNULL ? null : _t;
                    this.match(_t, 379);
                    _t = _t.getFirstChild();
                    this.identifier(_t);
                    _t = this._retTree;
                    this.identifier(_t);
                    _t = this._retTree;
                    _t = __t262;
                    _t = _t.getNextSibling();
                    if (this.inputState.guessing() == 0) {
                        try {
                            result = this.getTransientResult(RfNamedElement.class, ar);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final void width_unit(AST _t) throws RecognitionException {
        block17: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 328: {
                            this.match(_t, 328);
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 329: {
                            this.match(_t, 329);
                            _t = _t.getNextSibling();
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void width_size(AST _t) throws RecognitionException {
        block18: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 330: {
                            this.match(_t, 330);
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 253: {
                            this.range(_t, null);
                            _t = this._retTree;
                            break;
                        }
                        case 183: 
                        case 184: 
                        case 188: 
                        case 189: 
                        case 191: 
                        case 192: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: 
                        case 198: 
                        case 199: 
                        case 200: 
                        case 201: 
                        case 202: 
                        case 203: 
                        case 204: 
                        case 205: 
                        case 206: 
                        case 207: 
                        case 208: 
                        case 209: 
                        case 210: 
                        case 211: 
                        case 212: 
                        case 213: 
                        case 214: 
                        case 215: 
                        case 216: 
                        case 217: 
                        case 218: 
                        case 219: 
                        case 220: 
                        case 221: 
                        case 222: 
                        case 223: 
                        case 224: 
                        case 225: 
                        case 226: 
                        case 227: 
                        case 228: 
                        case 229: 
                        case 230: 
                        case 231: 
                        case 232: 
                        case 233: 
                        case 234: 
                        case 235: 
                        case 236: 
                        case 237: 
                        case 238: 
                        case 239: 
                        case 240: 
                        case 241: 
                        case 242: 
                        case 243: 
                        case 244: 
                        case 245: 
                        case 246: 
                        case 251: 
                        case 252: 
                        case 256: 
                        case 259: 
                        case 260: 
                        case 261: 
                        case 262: 
                        case 263: 
                        case 264: 
                        case 265: 
                        case 266: 
                        case 267: 
                        case 268: 
                        case 269: 
                        case 277: 
                        case 278: 
                        case 279: 
                        case 280: 
                        case 281: 
                        case 282: 
                        case 283: 
                        case 284: 
                        case 285: 
                        case 286: 
                        case 287: 
                        case 288: 
                        case 292: 
                        case 293: 
                        case 294: 
                        case 295: 
                        case 296: 
                        case 297: 
                        case 298: 
                        case 299: 
                        case 300: 
                        case 301: 
                        case 302: 
                        case 303: 
                        case 304: 
                        case 305: 
                        case 306: 
                        case 307: 
                        case 308: 
                        case 309: 
                        case 310: 
                        case 311: 
                        case 312: 
                        case 313: 
                        case 314: 
                        case 315: 
                        case 316: 
                        case 317: 
                        case 318: 
                        case 319: 
                        case 320: 
                        case 321: 
                        case 322: 
                        case 323: 
                        case 369: 
                        case 411: 
                        case 416: 
                        case 417: 
                        case 464: 
                        case 497: 
                        case 506: 
                        case 507: {
                            this.expr(_t, null);
                            _t = this._retTree;
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final RfNamedElement enum_item_list(AST _t) throws RecognitionException {
        RfNamedElement result;
        block17: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST eil = null;
            try {
                try {
                    AST __t276 = _t;
                    eil = _t == ASTNULL ? null : _t;
                    this.match(_t, 35);
                    _t = _t.getFirstChild();
                    while (true) {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (_t.getType() != 36) break;
                        this.enum_item(_t);
                        _t = this._retTree;
                    }
                    _t = __t276;
                    _t = _t.getNextSibling();
                    if (this.inputState.guessing() == 0) {
                        try {
                            result = this.getTransientResult(RfNamedElement.class, eil);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final void enum_item(AST _t) throws RecognitionException {
        block17: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t938 = _t;
                    this.match(_t, 36);
                    _t = _t.getFirstChild();
                    this.identifier(_t);
                    _t = this._retTree;
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 183: 
                        case 184: 
                        case 188: 
                        case 189: 
                        case 191: 
                        case 192: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: 
                        case 198: 
                        case 199: 
                        case 200: 
                        case 201: 
                        case 202: 
                        case 203: 
                        case 204: 
                        case 205: 
                        case 206: 
                        case 207: 
                        case 208: 
                        case 209: 
                        case 210: 
                        case 211: 
                        case 212: 
                        case 213: 
                        case 214: 
                        case 215: 
                        case 216: 
                        case 217: 
                        case 218: 
                        case 219: 
                        case 220: 
                        case 221: 
                        case 222: 
                        case 223: 
                        case 224: 
                        case 225: 
                        case 226: 
                        case 227: 
                        case 228: 
                        case 229: 
                        case 230: 
                        case 231: 
                        case 232: 
                        case 233: 
                        case 234: 
                        case 235: 
                        case 236: 
                        case 237: 
                        case 238: 
                        case 239: 
                        case 240: 
                        case 241: 
                        case 242: 
                        case 243: 
                        case 244: 
                        case 245: 
                        case 246: 
                        case 251: 
                        case 252: 
                        case 256: 
                        case 259: 
                        case 260: 
                        case 261: 
                        case 262: 
                        case 263: 
                        case 264: 
                        case 265: 
                        case 266: 
                        case 267: 
                        case 268: 
                        case 269: 
                        case 277: 
                        case 278: 
                        case 279: 
                        case 280: 
                        case 281: 
                        case 282: 
                        case 283: 
                        case 284: 
                        case 285: 
                        case 286: 
                        case 287: 
                        case 288: 
                        case 292: 
                        case 293: 
                        case 294: 
                        case 295: 
                        case 296: 
                        case 297: 
                        case 298: 
                        case 299: 
                        case 300: 
                        case 301: 
                        case 302: 
                        case 303: 
                        case 304: 
                        case 305: 
                        case 306: 
                        case 307: 
                        case 308: 
                        case 309: 
                        case 310: 
                        case 311: 
                        case 312: 
                        case 313: 
                        case 314: 
                        case 315: 
                        case 316: 
                        case 317: 
                        case 318: 
                        case 319: 
                        case 320: 
                        case 321: 
                        case 322: 
                        case 323: 
                        case 369: 
                        case 411: 
                        case 416: 
                        case 417: 
                        case 464: 
                        case 497: 
                        case 506: 
                        case 507: {
                            this.expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t938;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final RfNamedElement range(AST _t, RfNamedElement lhScope) throws RecognitionException {
        RfNamedElement result;
        block26: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            RfNamedElement tmpResult = null;
            try {
                try {
                    AST __t547 = _t;
                    this.match(_t, 253);
                    _t = _t.getFirstChild();
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 254: {
                            tmpResult = this.range_left_bound(_t, lhScope);
                            _t = this._retTree;
                            if (this.inputState.guessing() != 0) break;
                            try {
                                result = tmpResult;
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break;
                        }
                        case 3: 
                        case 255: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 255: {
                            tmpResult = this.range_right_bound(_t, lhScope);
                            _t = this._retTree;
                            if (this.inputState.guessing() != 0) break;
                            try {
                                result = result == null ? tmpResult : result;
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t547;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfStructQualifier struct_qualifier_check(AST _t, RfStruct struct, Determinant determinant) throws RecognitionException {
        RfStructQualifier structQualifier;
        block47: {
            structQualifier = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST v1 = null;
            AST v2 = null;
            AST id1 = null;
            AST id2 = null;
            AST id3 = null;
            AST v = null;
            String determinantPart = null;
            try {
                try {
                    AST __t286 = _t;
                    this.match(_t, 40);
                    _t = _t.getFirstChild();
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 299: 
                        case 300: {
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            switch (_t.getType()) {
                                case 299: {
                                    v1 = _t;
                                    this.match(_t, 299);
                                    _t = _t.getNextSibling();
                                    if (this.inputState.guessing() != 0) break;
                                    try {
                                        v = v1;
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                    break;
                                }
                                case 300: {
                                    v2 = _t;
                                    this.match(_t, 300);
                                    _t = _t.getNextSibling();
                                    if (this.inputState.guessing() != 0) break;
                                    try {
                                        v = v2;
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltException(_t);
                                }
                            }
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            switch (_t.getType()) {
                                case 293: {
                                    id1 = _t == ASTNULL ? null : _t;
                                    this.identifier(_t);
                                    _t = this._retTree;
                                    break;
                                }
                                case 3: {
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltException(_t);
                                }
                            }
                            if (this.inputState.guessing() != 0) break;
                            try {
                                if (struct == null || v == null) break;
                                if (id1 == null) {
                                    LineInfo lineInfo = this.getMacroSafeLine(v);
                                    this.rfp.addSemanticError2(1, "RESERVED_NAME: ''{0}'' is a reserved name, cannot be used as a when qualifier name", lineInfo.getOffset(), lineInfo.getOffset() + v.getText().length(), null, lineInfo.line, this.parserPath, v.getText());
                                    determinantPart = v.getText();
                                    break;
                                }
                                ArrayList<RfStructQualifier> qualifiers = new ArrayList<RfStructQualifier>();
                                LineInfo lineInfo = this.getMacroSafeLine(v);
                                struct.getStructQualifierCandidates(this.rfp, qualifiers, this.packageName, v.getText(), id1.getText(), determinant, 31, this.moduleIndex, lineInfo, this.parserPath);
                                determinantPart = this.append(v.getText(), "'", id1.getText());
                                if (qualifiers.isEmpty()) {
                                    this.rfp.addSemanticError2(1, "NOT_A_SUBTYPE: ''{0}'' is not a subtype of ''{1}''", lineInfo.getOffset(), lineInfo.getOffset() + v.getText().length() + 1 + id1.getText().length(), null, lineInfo.line, this.parserPath, String.valueOf(v.getText()) + "'" + id1.getText(), struct.getName());
                                    break;
                                }
                                structQualifier = (RfStructQualifier)qualifiers.get(0);
                                this.setTransientResult(v, (RfNamedElement)qualifiers.get(0));
                                this.setTransientResult(id1, (RfNamedElement)qualifiers.get(0));
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break;
                        }
                        case 293: {
                            id2 = _t == ASTNULL ? null : _t;
                            this.identifier(_t);
                            _t = this._retTree;
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            switch (_t.getType()) {
                                case 293: {
                                    id3 = _t == ASTNULL ? null : _t;
                                    this.identifier(_t);
                                    _t = this._retTree;
                                    break;
                                }
                                case 3: {
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltException(_t);
                                }
                            }
                            if (this.inputState.guessing() != 0) break;
                            try {
                                if (struct == null || id2 == null) break;
                                if (id3 == null) {
                                    ArrayList<RfStructQualifier> qualifiers = new ArrayList<RfStructQualifier>();
                                    LineInfo lineInfo = this.getMacroSafeLine(id2);
                                    struct.getStructQualifierCandidates(this.rfp, qualifiers, this.packageName, null, id2.getText(), determinant, 31, this.moduleIndex, lineInfo, this.parserPath);
                                    determinantPart = id2.getText();
                                    if (qualifiers.isEmpty()) {
                                        this.rfp.addSemanticError2(1, "NOT_A_SUBTYPE: ''{0}'' is not a subtype of ''{1}''", lineInfo.getOffset(), lineInfo.getOffset() + determinantPart.length(), null, lineInfo.line, this.parserPath, determinantPart, struct.getName());
                                        break;
                                    }
                                    if (qualifiers.size() > 1) {
                                        this.rfp.addSemanticError2(1, "AMBIGUOUS_QUALIFIER: ''{0}'' when qualifier for struct ''{1}'' is ambiguous, use full qualifier (e.g. ''{2}'' or ''{3}'')", lineInfo.getOffset(), lineInfo.getOffset() + determinantPart.length(), null, lineInfo.line, this.parserPath, determinantPart, struct.getName(), ((RfStructQualifier)qualifiers.get(0)).toString(), ((RfStructQualifier)qualifiers.get(1)).toString());
                                        break;
                                    }
                                    structQualifier = (RfStructQualifier)qualifiers.get(0);
                                    determinantPart = ((RfStructQualifier)qualifiers.get(0)).toString();
                                    this.setTransientResult(id2, (RfNamedElement)qualifiers.get(0));
                                    break;
                                }
                                ArrayList<RfStructQualifier> qualifiers = new ArrayList<RfStructQualifier>();
                                LineInfo lineInfo = this.getMacroSafeLine(id2);
                                struct.getStructQualifierCandidates(this.rfp, qualifiers, this.packageName, id2.getText(), id3.getText(), determinant, 31, this.moduleIndex, lineInfo, this.parserPath);
                                determinantPart = this.append(id2.getText(), "'", id3.getText());
                                if (qualifiers.isEmpty()) {
                                    this.rfp.addSemanticError2(1, "NOT_A_SUBTYPE: ''{0}'' is not a subtype of ''{1}''", lineInfo.getOffset(), lineInfo.getOffset() + determinantPart.length(), null, lineInfo.line, this.parserPath, determinantPart, struct.getName());
                                    break;
                                }
                                if (((RfStructQualifier)qualifiers.get(0)).getEnum() == null) {
                                    this.rfp.addSemanticError2(1, "MISSING_ENUM_NAME: ''{0}'' is not a value of enum type ''{1}''", lineInfo.getOffset(), lineInfo.getOffset() + id2.getText().length(), null, lineInfo.line, this.parserPath, id2.getText(), ((RfStructQualifier)qualifiers.get(0)).getFieldAssocTypeName());
                                    break;
                                }
                                structQualifier = (RfStructQualifier)qualifiers.get(0);
                                this.setTransientResult(id2, ((RfStructQualifier)qualifiers.get(0)).getEnum());
                                this.setTransientResult(id3, ((RfStructQualifier)qualifiers.get(0)).getElement());
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t286;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block47;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return structQualifier;
    }

    public final void direction(AST _t) throws RecognitionException {
        block18: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 92: {
                            this.match(_t, 92);
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 93: {
                            this.match(_t, 93);
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 94: {
                            this.match(_t, 94);
                            _t = _t.getNextSibling();
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void list_key(AST _t, AST lt) throws RecognitionException {
        block18: {
            Runnable finalRunnable;
            block17: {
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST id = null;
                try {
                    try {
                        AST __t315 = _t;
                        this.match(_t, 339);
                        _t = _t.getFirstChild();
                        id = _t == ASTNULL ? null : _t;
                        this.identifier(_t);
                        _t = this._retTree;
                        _t = __t315;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block17;
                        try {
                            RfNamedElement result = this.getTransientResult(RfNamedElement.class, lt);
                            if (id != null && this.valid(result)) {
                                RfType assocType = (RfType)((IRfAssociatedType)((Object)result)).getAssociatedType();
                                Determinant assocDeterminant = ((IRfAssociatedType)((Object)result)).getAssociatedTypeDeterminant();
                                if ((assocType = ((RfListType)assocType).getAssociatedType()) != null && !"it".equals(id.getText())) {
                                    LineInfo lineInfo;
                                    result = assocType.semanticGetMember(this.rfp, assocDeterminant, this.packageName, this.getStruct(), id.getText(), FIELD, 31, this.maxModuleIndex, this.parserPath, null);
                                    this.module.createVariableDependency(this.rfp, result, id.getText());
                                    if (result instanceof IllegalAccessError) {
                                        lineInfo = this.getMacroSafeLine(id);
                                        this.rfp.addSemanticError2(1, "ILLEGAL_ACCESS: Cannot access {0} {1} ''{2}.{3}''", lineInfo.getOffset(), lineInfo.getOffset() + id.getText().length(), null, lineInfo.line, this.parserPath, ((IllegalAccessError)result).getAccessModifierText(), ((IllegalAccessError)result).getElementKindText(), ((IllegalAccessError)result).getParentName(), id.getText());
                                        result = ((IllegalAccessError)result).getElement();
                                    }
                                    if (!(result instanceof RfField)) {
                                        lineInfo = this.getMacroSafeLine(id);
                                        this.rfp.addSemanticError1(1, "UNDEFINED_VARIABLE: No field or local variable called ''{0}''", lineInfo.getOffset(), lineInfo.getOffset() + id.getText().length(), null, lineInfo.line, this.parserPath, id.getText());
                                        result = RfUndefVariable.create(this.rfp, id.getText()).parent(assocType);
                                    }
                                    this.setTransientResult(id, new RfWNamedElementAndScope(result, assocType, true));
                                }
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void template_param_type(AST _t) throws RecognitionException {
        block17: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t326 = _t;
                    this.match(_t, 410);
                    _t = _t.getFirstChild();
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 35: 
                        case 40: 
                        case 293: 
                        case 324: 
                        case 325: 
                        case 326: 
                        case 327: 
                        case 331: 
                        case 332: 
                        case 333: 
                        case 334: 
                        case 335: 
                        case 336: 
                        case 337: 
                        case 338: 
                        case 379: 
                        case 409: 
                        case 410: 
                        case 412: 
                        case 418: {
                            this.type(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t326;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void template_param_exp(AST _t, RfNamedElement result) throws RecognitionException {
        block22: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t329 = _t;
                    this.match(_t, 411);
                    _t = _t.getFirstChild();
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 110: {
                            result = this.param_exp_type(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 3: 
                        case 183: 
                        case 184: 
                        case 188: 
                        case 189: 
                        case 191: 
                        case 192: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: 
                        case 198: 
                        case 199: 
                        case 200: 
                        case 201: 
                        case 202: 
                        case 203: 
                        case 204: 
                        case 205: 
                        case 206: 
                        case 207: 
                        case 208: 
                        case 209: 
                        case 210: 
                        case 211: 
                        case 212: 
                        case 213: 
                        case 214: 
                        case 215: 
                        case 216: 
                        case 217: 
                        case 218: 
                        case 219: 
                        case 220: 
                        case 221: 
                        case 222: 
                        case 223: 
                        case 224: 
                        case 225: 
                        case 226: 
                        case 227: 
                        case 228: 
                        case 229: 
                        case 230: 
                        case 231: 
                        case 232: 
                        case 233: 
                        case 234: 
                        case 235: 
                        case 236: 
                        case 237: 
                        case 238: 
                        case 239: 
                        case 240: 
                        case 241: 
                        case 242: 
                        case 243: 
                        case 244: 
                        case 245: 
                        case 246: 
                        case 251: 
                        case 252: 
                        case 256: 
                        case 259: 
                        case 260: 
                        case 261: 
                        case 262: 
                        case 263: 
                        case 264: 
                        case 265: 
                        case 266: 
                        case 267: 
                        case 268: 
                        case 269: 
                        case 277: 
                        case 278: 
                        case 279: 
                        case 280: 
                        case 281: 
                        case 282: 
                        case 283: 
                        case 284: 
                        case 285: 
                        case 286: 
                        case 287: 
                        case 288: 
                        case 292: 
                        case 293: 
                        case 294: 
                        case 295: 
                        case 296: 
                        case 297: 
                        case 298: 
                        case 299: 
                        case 300: 
                        case 301: 
                        case 302: 
                        case 303: 
                        case 304: 
                        case 305: 
                        case 306: 
                        case 307: 
                        case 308: 
                        case 309: 
                        case 310: 
                        case 311: 
                        case 312: 
                        case 313: 
                        case 314: 
                        case 315: 
                        case 316: 
                        case 317: 
                        case 318: 
                        case 319: 
                        case 320: 
                        case 321: 
                        case 322: 
                        case 323: 
                        case 369: 
                        case 411: 
                        case 416: 
                        case 417: 
                        case 464: 
                        case 497: 
                        case 506: 
                        case 507: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 183: 
                        case 184: 
                        case 188: 
                        case 189: 
                        case 191: 
                        case 192: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: 
                        case 198: 
                        case 199: 
                        case 200: 
                        case 201: 
                        case 202: 
                        case 203: 
                        case 204: 
                        case 205: 
                        case 206: 
                        case 207: 
                        case 208: 
                        case 209: 
                        case 210: 
                        case 211: 
                        case 212: 
                        case 213: 
                        case 214: 
                        case 215: 
                        case 216: 
                        case 217: 
                        case 218: 
                        case 219: 
                        case 220: 
                        case 221: 
                        case 222: 
                        case 223: 
                        case 224: 
                        case 225: 
                        case 226: 
                        case 227: 
                        case 228: 
                        case 229: 
                        case 230: 
                        case 231: 
                        case 232: 
                        case 233: 
                        case 234: 
                        case 235: 
                        case 236: 
                        case 237: 
                        case 238: 
                        case 239: 
                        case 240: 
                        case 241: 
                        case 242: 
                        case 243: 
                        case 244: 
                        case 245: 
                        case 246: 
                        case 251: 
                        case 252: 
                        case 256: 
                        case 259: 
                        case 260: 
                        case 261: 
                        case 262: 
                        case 263: 
                        case 264: 
                        case 265: 
                        case 266: 
                        case 267: 
                        case 268: 
                        case 269: 
                        case 277: 
                        case 278: 
                        case 279: 
                        case 280: 
                        case 281: 
                        case 282: 
                        case 283: 
                        case 284: 
                        case 285: 
                        case 286: 
                        case 287: 
                        case 288: 
                        case 292: 
                        case 293: 
                        case 294: 
                        case 295: 
                        case 296: 
                        case 297: 
                        case 298: 
                        case 299: 
                        case 300: 
                        case 301: 
                        case 302: 
                        case 303: 
                        case 304: 
                        case 305: 
                        case 306: 
                        case 307: 
                        case 308: 
                        case 309: 
                        case 310: 
                        case 311: 
                        case 312: 
                        case 313: 
                        case 314: 
                        case 315: 
                        case 316: 
                        case 317: 
                        case 318: 
                        case 319: 
                        case 320: 
                        case 321: 
                        case 322: 
                        case 323: 
                        case 369: 
                        case 411: 
                        case 416: 
                        case 417: 
                        case 464: 
                        case 497: 
                        case 506: 
                        case 507: {
                            this.expr(_t, result);
                            _t = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t329;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final RfNamedElement param_exp_type(AST _t) throws RecognitionException {
        RfNamedElement result;
        block12: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t333 = _t;
                    this.match(_t, 110);
                    _t = _t.getFirstChild();
                    result = this.type(_t);
                    _t = this._retTree;
                    _t = __t333;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement field_access_expr(AST _t, boolean isEvent) throws RecognitionException {
        RfNamedElement result;
        block61: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST id1 = null;
            AST it = null;
            AST id2 = null;
            AST id3 = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 223: {
                            AST __t458 = _t;
                            AST aST = _t == ASTNULL ? null : _t;
                            this.match(_t, 223);
                            _t = _t.getFirstChild();
                            result = this.expr(_t, null);
                            _t = this._retTree;
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            switch (_t.getType()) {
                                case 293: {
                                    id1 = _t == ASTNULL ? null : _t;
                                    this.identifier(_t);
                                    _t = this._retTree;
                                    if (this.inputState.guessing() != 0) break;
                                    try {
                                        if (!this.valid(result) || id1 == null || this.lastScopeLayerStack.isEmpty()) break;
                                        RfNamedElement parentTypeHolder = result = this.peekConstraint(this.rfp, result);
                                        RfType assocType = (RfType)((IRfAssociatedType)((Object)result)).getAssociatedType();
                                        Determinant assocDeterminant = ((IRfAssociatedType)((Object)result)).getAssociatedTypeDeterminant();
                                        List<Determinant> constraintDeterminants = result instanceof RfFieldTypeConstraint ? ((RfFieldTypeConstraint)result).getDeterminants() : null;
                                        HashMap<String, Object> attributes = new HashMap<String, Object>();
                                        attributes.put("QUICKFIX_ELEMENT_NAME", id1.getText());
                                        if (assocType instanceof IRfTemplateParam) break;
                                        if (assocType instanceof RfStruct) {
                                            LineInfo lineInfo;
                                            boolean isSLNLabel = this.module.isSLN() && result instanceof RfVar;
                                            RfVar slnLabel = isSLNLabel ? (RfVar)result : null;
                                            result = ((RfStruct)assocType).semanticGetMember(this.rfp, assocDeterminant, this.packageName, this.getStruct(), id1.getText(), isEvent ? EVENT : FIELD_VARIABLE, 31, this.maxModuleIndex, this.parserPath, null);
                                            if (slnLabel != null && result == null && this.isInCompoundBlock()) {
                                                lineInfo = this.getMacroSafeLine(id1);
                                                result = slnLabel.slnSemanticGetActionLabel(this.rfp, id1.getText(), lineInfo);
                                            }
                                            this.module.createVariableDependency(this.rfp, result, id1.getText());
                                            if (result instanceof IllegalAccessError) {
                                                lineInfo = this.getMacroSafeLine(id1);
                                                this.rfp.addSemanticError2(1, "ILLEGAL_ACCESS: Cannot access {0} {1} ''{2}.{3}''", lineInfo.getOffset(), lineInfo.getOffset() + id1.getText().length(), null, lineInfo.line, this.parserPath, ((IllegalAccessError)result).getAccessModifierText(), ((IllegalAccessError)result).getElementKindText(), ((IllegalAccessError)result).getParentName(), id1.getText());
                                                result = ((IllegalAccessError)result).getElement();
                                            }
                                            if (constraintDeterminants != null && result != null && this.valid(result)) {
                                                boolean constraintPass = false;
                                                Determinant memberDeterminant = result.getFullName().getDeterminant();
                                                for (Determinant constraintDeterminant : constraintDeterminants) {
                                                    if (memberDeterminant.toArray().length == 1) {
                                                        constraintPass = true;
                                                        break;
                                                    }
                                                    if (!RfStruct.isMemberOf(constraintDeterminant, memberDeterminant)) continue;
                                                    constraintPass = true;
                                                    break;
                                                }
                                                if (!constraintPass) {
                                                    result = null;
                                                }
                                            }
                                            if (result == null) {
                                                LineInfo lineInfo2 = this.getMacroSafeLine(id1);
                                                String assocTypeName = this.getAssocTypeName(assocType, assocDeterminant);
                                                if (assocType != this.STRING_TYPE) {
                                                    attributes.put("QUICKFIX_KIND", 1);
                                                    attributes.put("QUICKFIX_HIERARCHICAL_ID", true);
                                                }
                                                this.rfp.addSemanticError2(1, "UNDEFINED_IDENTIFIER: Identifier ''{0}'' is not a member of ''{1}''", lineInfo2.getOffset(), lineInfo2.getOffset() + id1.getText().length(), attributes, lineInfo2.line, this.parserPath, id1.getText(), assocTypeName);
                                                result = RfUndefVariable.create(this.rfp, id1.getText()).parent(parentTypeHolder);
                                            }
                                            this.setTransientResult(id1, new RfWNamedElementAndScope(result, (RfStruct)assocType, true));
                                            break;
                                        }
                                        if (assocType != null) {
                                            LineInfo lineInfo = this.getMacroSafeLine(id1);
                                            String assocTypeName = this.getAssocTypeName(assocType, assocDeterminant);
                                            this.rfp.addSemanticError2(1, "UNDEFINED_IDENTIFIER: Identifier ''{0}'' is not a member of ''{1}''", lineInfo.getOffset(), lineInfo.getOffset() + id1.getText().length(), attributes, lineInfo.line, this.parserPath, id1.getText(), assocTypeName);
                                            result = ERROR_SCOPE;
                                            break;
                                        }
                                        LineInfo lineInfo = this.getMacroSafeLine(id1);
                                        this.rfp.addSemanticError2(1, "UNRESOLVED_IDENTIFIER: Cannot resolve identifier ''{0}'' (unresolved preceding expression)", lineInfo.getOffset(), lineInfo.getOffset() + id1.getText().length(), null, lineInfo.line, this.parserPath, id1.getText());
                                        result = ERROR_SCOPE;
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                    break;
                                }
                                case 318: {
                                    result = this.deprecated_tick_id(_t, result);
                                    _t = this._retTree;
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltException(_t);
                                }
                            }
                            _t = __t458;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 225: {
                            AST __t460 = _t;
                            it = _t == ASTNULL ? null : _t;
                            this.match(_t, 225);
                            _t = _t.getFirstChild();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    EAST itAst = new EAST((EAST)it);
                                    itAst.setOffset(itAst.getOffset());
                                    itAst.setText("it");
                                    RfWNamedElementAndScope elementAndScope = this.resolveIdentifier((AST)itAst, EnumSet.of(IRfNamedElement.ElementKind.E_VARIABLE), true);
                                    result = this.getNamedElement(elementAndScope);
                                    if (result == null) {
                                        LineInfo lineInfo = this.getMacroSafeLine((AST)itAst);
                                        this.rfp.addSemanticError2(1, "UNRESOLVED_IDENTIFIER: Cannot resolve identifier ''{0}'' (unresolved preceding expression)", lineInfo.getOffset() - 1, lineInfo.getOffset(), null, lineInfo.line, this.parserPath, "it");
                                        result = ERROR_SCOPE;
                                    }
                                    this.setTransientResult(it, result);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            switch (_t.getType()) {
                                case 293: {
                                    id2 = _t == ASTNULL ? null : _t;
                                    this.identifier(_t);
                                    _t = this._retTree;
                                    if (this.inputState.guessing() != 0) break;
                                    try {
                                        if (!this.valid(result) || id2 == null || this.lastScopeLayerStack.isEmpty()) break;
                                        RfNamedElement parentTypeHolder = result = this.peekConstraint(this.rfp, result);
                                        HashMap<String, Object> attributes = new HashMap<String, Object>();
                                        attributes.put("QUICKFIX_ELEMENT_NAME", id2.getText());
                                        IRfAssociatedType cfr_ignored_0 = (IRfAssociatedType)((Object)result);
                                        RfType assocType = (RfType)((IRfAssociatedType)((Object)result)).getAssociatedType();
                                        Determinant assocDeterminant = ((IRfAssociatedType)((Object)result)).getAssociatedTypeDeterminant();
                                        if (assocType instanceof RfStruct) {
                                            LineInfo lineInfo;
                                            boolean isSLNLabel = this.module.isSLN() && result instanceof RfVar;
                                            RfVar slnLabel = isSLNLabel ? (RfVar)result : null;
                                            RfStruct enclosingStruct = this.getStruct();
                                            if (assocType instanceof RfTemplateStructInstance && enclosingStruct instanceof RfTemplateStructInstance && assocDeterminant.getParameters() == null && ((RfTemplateStructInstance)assocType).getTemplateStruct() == ((RfTemplateStructInstance)enclosingStruct).getTemplateStruct()) {
                                                ((RfTemplateStructInstance)assocType).setParamsValueOverride(((RfTemplateStructInstance)enclosingStruct).getParameters());
                                            }
                                            result = ((RfStruct)assocType).semanticGetMember(this.rfp, assocDeterminant, this.packageName, this.getStruct(), id2.getText(), isEvent ? EVENT : FIELD_VARIABLE, 31, this.maxModuleIndex, this.parserPath, null);
                                            if (slnLabel != null && result == null && this.isInCompoundBlock()) {
                                                lineInfo = this.getMacroSafeLine(id1);
                                                result = slnLabel.slnSemanticGetActionLabel(this.rfp, id2.getText(), lineInfo);
                                            }
                                            this.module.createVariableDependency(this.rfp, result, id2.getText());
                                            if (result == null) {
                                                lineInfo = this.getMacroSafeLine(id2);
                                                String assocTypeName = this.getAssocTypeName(assocType, assocDeterminant);
                                                int quickFixKind = isEvent ? 28 : 1;
                                                attributes.put("QUICKFIX_KIND", quickFixKind);
                                                attributes.put("QUICKFIX_HIERARCHICAL_ID", true);
                                                this.rfp.addSemanticError2(1, "UNDEFINED_IDENTIFIER: Identifier ''{0}'' is not a member of ''{1}''", lineInfo.getOffset(), lineInfo.getOffset() + id2.getText().length(), attributes, lineInfo.line, this.parserPath, id2.getText(), assocTypeName);
                                                result = RfUndefVariable.create(this.rfp, id2.getText()).parent(parentTypeHolder);
                                            } else if (result instanceof IllegalAccessError) {
                                                lineInfo = this.getMacroSafeLine(id2);
                                                this.rfp.addSemanticError2(1, "ILLEGAL_ACCESS: Cannot access {0} {1} ''{2}.{3}''", lineInfo.getOffset(), lineInfo.getOffset() + id2.getText().length(), null, lineInfo.line, this.parserPath, ((IllegalAccessError)result).getAccessModifierText(), ((IllegalAccessError)result).getElementKindText(), ((IllegalAccessError)result).getParentName(), id2.getText());
                                                result = ((IllegalAccessError)result).getElement();
                                            }
                                        } else {
                                            LineInfo lineInfo = this.getMacroSafeLine(id2);
                                            this.rfp.addSemanticError2(1, "UNRESOLVED_IDENTIFIER: Cannot resolve identifier ''{0}'' (unresolved preceding expression)", lineInfo.getOffset(), lineInfo.getOffset() + id2.getText().length(), null, lineInfo.line, this.parserPath, id2.getText());
                                            result = RfUndefVariable.create(this.rfp, id2.getText());
                                        }
                                        this.setTransientResult(id2, new RfWNamedElementAndScope(result, assocType, true));
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                    break;
                                }
                                case 318: {
                                    result = this.deprecated_tick_id(_t, result);
                                    _t = this._retTree;
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltException(_t);
                                }
                            }
                            _t = __t460;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 224: {
                            AST __t462 = _t;
                            this.match(_t, 224);
                            _t = _t.getFirstChild();
                            result = this.type(_t);
                            _t = this._retTree;
                            id3 = _t == ASTNULL ? null : _t;
                            this.identifier(_t);
                            _t = this._retTree;
                            _t = __t462;
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() != 0) break;
                            try {
                                if (this.valid(result) && id3 != null) {
                                    RfNamedElement parentTypeHolder = result;
                                    RfType assocType = (RfType)((IRfAssociatedType)((Object)result)).getAssociatedType();
                                    Determinant assocDeterminant = ((IRfAssociatedType)((Object)result)).getAssociatedTypeDeterminant();
                                    HashMap<String, Object> attributes = new HashMap<String, Object>();
                                    attributes.put("QUICKFIX_ELEMENT_NAME", id3.getText());
                                    if (assocType instanceof RfStruct) {
                                        result = ((RfStruct)assocType).semanticGetMember(this.rfp, assocDeterminant, this.packageName, this.getStruct(), id3.getText(), isEvent ? EVENT : FIELD_VARIABLE, 31, this.maxModuleIndex, this.parserPath, null);
                                        this.module.createVariableDependency(this.rfp, result, id3.getText());
                                        if (result == null) {
                                            int quickFixKind = isEvent ? 28 : 1;
                                            attributes.put("QUICKFIX_KIND", quickFixKind);
                                            attributes.put("QUICKFIX_HIERARCHICAL_ID", true);
                                            attributes.put("QUICKFIX_STATIC_ID", true);
                                            LineInfo lineInfo = this.getMacroSafeLine(id3);
                                            String assocTypeName = this.getAssocTypeName(assocType, assocDeterminant);
                                            this.rfp.addSemanticError2(1, "UNDEFINED_IDENTIFIER: Identifier ''{0}'' is not a member of ''{1}''", lineInfo.getOffset(), lineInfo.getOffset() + id3.getText().length(), attributes, lineInfo.line, this.parserPath, id3.getText(), assocTypeName);
                                            result = RfUndefVariable.create(this.rfp, id3.getText()).parent(parentTypeHolder);
                                        } else if (result instanceof IllegalAccessError) {
                                            LineInfo lineInfo = this.getMacroSafeLine(id3);
                                            this.rfp.addSemanticError2(1, "ILLEGAL_ACCESS: Cannot access {0} {1} ''{2}.{3}''", lineInfo.getOffset(), lineInfo.getOffset() + id3.getText().length(), null, lineInfo.line, this.parserPath, ((IllegalAccessError)result).getAccessModifierText(), ((IllegalAccessError)result).getElementKindText(), ((IllegalAccessError)result).getParentName(), id3.getText());
                                            result = ((IllegalAccessError)result).getElement();
                                        }
                                    } else {
                                        LineInfo lineInfo = this.getMacroSafeLine(id3);
                                        this.rfp.addSemanticError2(1, "UNRESOLVED_IDENTIFIER: Cannot resolve identifier ''{0}'' (unresolved preceding expression)", lineInfo.getOffset(), lineInfo.getOffset() + id3.getText().length(), null, lineInfo.line, this.parserPath, id3.getText());
                                        result = RfUndefVariable.create(this.rfp, id3.getText());
                                    }
                                    this.setTransientResult(id3, new RfWNamedElementAndScope(result, assocType, true));
                                }
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block61;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement port_access_expr(AST _t) throws RecognitionException {
        RfNamedElement result;
        block18: {
            Runnable finalRunnable;
            block17: {
                result = null;
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST exp = null;
                try {
                    try {
                        AST __t464 = _t;
                        this.match(_t, 226);
                        _t = _t.getFirstChild();
                        exp = _t == ASTNULL ? null : _t;
                        result = this.expr(_t, null);
                        _t = this._retTree;
                        _t = __t464;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block17;
                        try {
                            IRfNamedElement assocType;
                            if (result != null && this.valid(result) && (assocType = ((IRfAssociatedType)((Object)result)).getAssociatedType()) != this.rfp.getSpecman().getHdlLiteralType()) {
                                if (!(assocType instanceof RfTemplateStructInstance) || !this.isPortAssocType((RfType)assocType)) {
                                    LineInfo lineInfo = this.getTreeLineInfo(exp);
                                    this.rfp.addSemanticError1(1, "NOT_A_PORT: ''{0}'' is not a port", lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, this.parserPath, assocType.getName());
                                } else {
                                    List<IRfAssociatedType> portToParams = ((RfTemplateStructInstance)assocType).getParameters();
                                    if (portToParams != null && !portToParams.isEmpty()) {
                                        result = new RfDummyField(this.rfp, portToParams.get(0).getAssociatedType());
                                    }
                                }
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final void as_computed_user_defined_expression(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t337 = _t;
                    this.match(_t, 184);
                    _t = _t.getFirstChild();
                    this.define_name(_t);
                    _t = this._retTree;
                    this.replacement_term_list(_t);
                    _t = this._retTree;
                    _t = __t337;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final RfNamedElement conditional_op_expr(AST _t, RfNamedElement lhScope) throws RecognitionException {
        RfNamedElement result;
        block24: {
            Runnable finalRunnable;
            block23: {
                result = null;
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST exp = null;
                AST exp1 = null;
                AST exp2 = null;
                RfNamedElement tmpResult = null;
                try {
                    try {
                        AST __t357 = _t;
                        this.match(_t, 188);
                        _t = _t.getFirstChild();
                        exp = _t == ASTNULL ? null : _t;
                        tmpResult = this.expr(_t, null);
                        _t = this._retTree;
                        if (this.inputState.guessing() == 0) {
                            try {
                                if (this.valid(result)) {
                                    SemanticUtils.incompatibleAssign(this.rfp, this.parserPath, this.macroDepth, this.macroLineInfo, null, exp, this.ELEM_OF_BOOL_TYPE, tmpResult, SemanticUtils.AssignKind.COMPARE);
                                }
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        exp1 = _t == ASTNULL ? null : _t;
                        tmpResult = this.expr(_t, lhScope);
                        _t = this._retTree;
                        if (this.inputState.guessing() == 0) {
                            try {
                                if (tmpResult != ERROR_SCOPE && tmpResult instanceof IRfAssociatedType) {
                                    lhScope = tmpResult;
                                }
                                if (exp1 != null && exp1.getType() != 301) {
                                    result = tmpResult;
                                }
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        exp2 = _t == ASTNULL ? null : _t;
                        tmpResult = this.expr(_t, lhScope);
                        _t = this._retTree;
                        _t = __t357;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block23;
                        try {
                            if (exp2 != null && exp2.getType() != 301 && result == null) {
                                result = tmpResult;
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement binary_expr(AST _t) throws RecognitionException {
        RfNamedElement result;
        block88: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST exp1 = null;
            AST exp2 = null;
            RfDummyField.Constraint constraint = null;
            final int stackConstraintSize = this.lastConstraintStack.size();
            if (this.inputState.guessing() == 0) {
                finalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        SemanticWalker.this.cleanAllConstraints(stackConstraintSize);
                    }
                };
            }
            RfNamedElement temp = null;
            boolean isInSLNMode = this.module.isSLN();
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 191: {
                            AST __t359 = _t;
                            this.match(_t, 191);
                            _t = _t.getFirstChild();
                            exp1 = _t == ASTNULL ? null : _t;
                            temp = this.expr(_t, null);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    this.pushConstraint(result);
                                    result = null;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            exp2 = _t == ASTNULL ? null : _t;
                            result = this.expr(_t, null);
                            _t = this._retTree;
                            _t = __t359;
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() != 0) break;
                            try {
                                if (!isInSLNMode && this.valid(temp)) {
                                    SemanticUtils.incompatibleAssign(this.rfp, this.parserPath, this.macroDepth, this.macroLineInfo, null, exp1, this.ELEM_OF_BOOL_TYPE, temp, SemanticUtils.AssignKind.COMPARE);
                                    if (this.valid(result)) {
                                        SemanticUtils.incompatibleAssign(this.rfp, this.parserPath, this.macroDepth, this.macroLineInfo, exp1, exp2, this.ELEM_OF_BOOL_TYPE, result, SemanticUtils.AssignKind.IN_LIST);
                                    }
                                }
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break;
                        }
                        case 192: {
                            AST __t360 = _t;
                            this.match(_t, 192);
                            _t = _t.getFirstChild();
                            result = this.expr_expr_eval(_t, SemanticUtils.AssignKind.MATH_BOOL);
                            _t = this._retTree;
                            _t = __t360;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 193: {
                            AST __t361 = _t;
                            this.match(_t, 193);
                            _t = _t.getFirstChild();
                            result = this.expr_expr_eval(_t, SemanticUtils.AssignKind.MATH_BOOL);
                            _t = this._retTree;
                            _t = __t361;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 194: {
                            AST __t362 = _t;
                            this.match(_t, 194);
                            _t = _t.getFirstChild();
                            result = this.expr_expr_eval(_t, SemanticUtils.AssignKind.MATH_INT_REAL);
                            _t = this._retTree;
                            _t = __t362;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 195: {
                            AST __t363 = _t;
                            this.match(_t, 195);
                            _t = _t.getFirstChild();
                            result = this.expr_expr_eval(_t, SemanticUtils.AssignKind.MATH_INT_REAL);
                            _t = this._retTree;
                            _t = __t363;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 196: {
                            AST __t364 = _t;
                            this.match(_t, 196);
                            _t = _t.getFirstChild();
                            result = this.expr_expr_eval(_t, SemanticUtils.AssignKind.MATH_INT_REAL);
                            _t = this._retTree;
                            _t = __t364;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 197: {
                            AST __t365 = _t;
                            this.match(_t, 197);
                            _t = _t.getFirstChild();
                            this.potential_enum_in_expr_expr_eval(_t, true, SemanticUtils.AssignKind.IN_LIST);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = this.ELEM_OF_BOOL_TYPE;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            _t = __t365;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 198: {
                            AST __t366 = _t;
                            this.match(_t, 198);
                            _t = _t.getFirstChild();
                            this.potential_enum_in_expr_expr_eval(_t, true, SemanticUtils.AssignKind.IN_LIST);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = this.ELEM_OF_BOOL_TYPE;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            _t = __t366;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 199: {
                            AST __t367 = _t;
                            this.match(_t, 199);
                            _t = _t.getFirstChild();
                            this.expr_expr_eval(_t, SemanticUtils.AssignKind.MATH_STRING);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = this.ELEM_OF_BOOL_TYPE;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            _t = __t367;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 200: {
                            AST __t368 = _t;
                            this.match(_t, 200);
                            _t = _t.getFirstChild();
                            this.expr_expr_eval(_t, SemanticUtils.AssignKind.MATH_STRING);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = this.ELEM_OF_BOOL_TYPE;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            _t = __t368;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 201: {
                            AST __t369 = _t;
                            this.match(_t, 201);
                            _t = _t.getFirstChild();
                            this.expr(_t, null);
                            _t = this._retTree;
                            this.expr(_t, null);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = this.ELEM_OF_BOOL_TYPE;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            _t = __t369;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 202: {
                            AST __t370 = _t;
                            this.match(_t, 202);
                            _t = _t.getFirstChild();
                            this.expr(_t, null);
                            _t = this._retTree;
                            this.expr(_t, null);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = this.ELEM_OF_BOOL_TYPE;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            _t = __t370;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 203: {
                            AST __t371 = _t;
                            this.match(_t, 203);
                            _t = _t.getFirstChild();
                            this.potential_enum_in_expr_expr_eval(_t, true, SemanticUtils.AssignKind.COMPARE);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = this.ELEM_OF_BOOL_TYPE;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            _t = __t371;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 204: {
                            AST __t372 = _t;
                            this.match(_t, 204);
                            _t = _t.getFirstChild();
                            constraint = this.potential_enum_in_expr_expr_eval(_t, true, SemanticUtils.AssignKind.COMPARE);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = this.ELEM_OF_BOOL_TYPE;
                                    ((RfDummyField)result).setConstraint(constraint);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            _t = __t372;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 205: {
                            AST __t373 = _t;
                            this.match(_t, 205);
                            _t = _t.getFirstChild();
                            this.expr_expr_eval(_t, SemanticUtils.AssignKind.MATH_INT_REAL);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = this.ELEM_OF_BOOL_TYPE;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            _t = __t373;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 206: {
                            AST __t374 = _t;
                            this.match(_t, 206);
                            _t = _t.getFirstChild();
                            this.expr_expr_eval(_t, SemanticUtils.AssignKind.MATH_INT_REAL);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = this.ELEM_OF_BOOL_TYPE;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            _t = __t374;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 207: {
                            AST __t375 = _t;
                            this.match(_t, 207);
                            _t = _t.getFirstChild();
                            this.expr_expr_eval(_t, SemanticUtils.AssignKind.MATH_INT_REAL);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = this.ELEM_OF_BOOL_TYPE;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            _t = __t375;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 208: {
                            AST __t376 = _t;
                            this.match(_t, 208);
                            _t = _t.getFirstChild();
                            this.expr_expr_eval(_t, SemanticUtils.AssignKind.MATH_INT_REAL);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = this.ELEM_OF_BOOL_TYPE;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            _t = __t376;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 209: {
                            AST __t377 = _t;
                            this.match(_t, 209);
                            _t = _t.getFirstChild();
                            result = this.expr_expr_eval(_t, SemanticUtils.AssignKind.MATH_INT);
                            _t = this._retTree;
                            _t = __t377;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 210: {
                            AST __t378 = _t;
                            this.match(_t, 210);
                            _t = _t.getFirstChild();
                            result = this.expr_expr_eval(_t, SemanticUtils.AssignKind.MATH_INT);
                            _t = this._retTree;
                            _t = __t378;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 211: {
                            AST __t379 = _t;
                            this.match(_t, 211);
                            _t = _t.getFirstChild();
                            result = this.expr_expr_eval(_t, SemanticUtils.AssignKind.MATH_INT_REAL);
                            _t = this._retTree;
                            _t = __t379;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 212: {
                            AST __t380 = _t;
                            this.match(_t, 212);
                            _t = _t.getFirstChild();
                            result = this.expr_expr_eval(_t, SemanticUtils.AssignKind.MATH_INT_REAL);
                            _t = this._retTree;
                            _t = __t380;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 213: {
                            AST __t381 = _t;
                            this.match(_t, 213);
                            _t = _t.getFirstChild();
                            result = this.expr_expr_eval(_t, SemanticUtils.AssignKind.MATH_INT_REAL);
                            _t = this._retTree;
                            _t = __t381;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 214: {
                            AST __t382 = _t;
                            this.match(_t, 214);
                            _t = _t.getFirstChild();
                            result = this.expr_expr_eval(_t, SemanticUtils.AssignKind.MATH_INT_REAL);
                            _t = this._retTree;
                            _t = __t382;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 215: {
                            AST __t383 = _t;
                            this.match(_t, 215);
                            _t = _t.getFirstChild();
                            result = this.expr_expr_eval(_t, SemanticUtils.AssignKind.MATH_INT_REAL);
                            _t = this._retTree;
                            _t = __t383;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 464: {
                            AST __t384 = _t;
                            this.match(_t, 464);
                            _t = _t.getFirstChild();
                            constraint = this.potential_enum_in_expr_expr_eval(_t, false, SemanticUtils.AssignKind.COMPARE);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = this.ELEM_OF_BOOL_TYPE;
                                    ((RfDummyField)result).setConstraint(constraint);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            _t = __t384;
                            _t = _t.getNextSibling();
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block88;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement unary_expr(AST _t) throws RecognitionException {
        RfDummyField result;
        block53: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST exp1 = null;
            AST exp2 = null;
            AST exp4 = null;
            AST exp3 = null;
            AST exp5 = null;
            AST exp6 = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 216: 
                        case 217: 
                        case 219: {
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            switch (_t.getType()) {
                                case 216: {
                                    AST __t406 = _t;
                                    this.match(_t, 216);
                                    _t = _t.getFirstChild();
                                    exp1 = _t == ASTNULL ? null : _t;
                                    this.expr(_t, null);
                                    _t = this._retTree;
                                    if (this.inputState.guessing() == 0) {
                                        try {
                                            EAST cfr_ignored_0 = (EAST)exp1;
                                        }
                                        catch (Exception ex) {
                                            this.userExceptionHandler(ex);
                                        }
                                    }
                                    _t = __t406;
                                    _t = _t.getNextSibling();
                                    break;
                                }
                                case 217: {
                                    AST __t407 = _t;
                                    this.match(_t, 217);
                                    _t = _t.getFirstChild();
                                    exp2 = _t == ASTNULL ? null : _t;
                                    this.expr(_t, null);
                                    _t = this._retTree;
                                    if (this.inputState.guessing() == 0) {
                                        try {
                                            EAST cfr_ignored_1 = (EAST)exp2;
                                        }
                                        catch (Exception ex) {
                                            this.userExceptionHandler(ex);
                                        }
                                    }
                                    _t = __t407;
                                    _t = _t.getNextSibling();
                                    break;
                                }
                                case 219: {
                                    AST __t408 = _t;
                                    this.match(_t, 219);
                                    _t = _t.getFirstChild();
                                    exp4 = _t == ASTNULL ? null : _t;
                                    this.expr(_t, null);
                                    _t = this._retTree;
                                    if (this.inputState.guessing() == 0) {
                                        try {
                                            EAST cfr_ignored_2 = (EAST)exp4;
                                        }
                                        catch (Exception ex) {
                                            this.userExceptionHandler(ex);
                                        }
                                    }
                                    _t = __t408;
                                    _t = _t.getNextSibling();
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltException(_t);
                                }
                            }
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = new RfDummyField(this.rfp, this.UINT_TYPE);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 218: 
                        case 220: 
                        case 221: {
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            switch (_t.getType()) {
                                case 218: {
                                    AST __t410 = _t;
                                    this.match(_t, 218);
                                    _t = _t.getFirstChild();
                                    exp3 = _t == ASTNULL ? null : _t;
                                    this.expr(_t, null);
                                    _t = this._retTree;
                                    if (this.inputState.guessing() == 0) {
                                        try {
                                            EAST cfr_ignored_3 = (EAST)exp3;
                                        }
                                        catch (Exception ex) {
                                            this.userExceptionHandler(ex);
                                        }
                                    }
                                    _t = __t410;
                                    _t = _t.getNextSibling();
                                    break;
                                }
                                case 220: {
                                    AST __t411 = _t;
                                    this.match(_t, 220);
                                    _t = _t.getFirstChild();
                                    exp5 = _t == ASTNULL ? null : _t;
                                    this.expr(_t, null);
                                    _t = this._retTree;
                                    if (this.inputState.guessing() == 0) {
                                        try {
                                            EAST cfr_ignored_4 = (EAST)exp5;
                                        }
                                        catch (Exception ex) {
                                            this.userExceptionHandler(ex);
                                        }
                                    }
                                    _t = __t411;
                                    _t = _t.getNextSibling();
                                    break;
                                }
                                case 221: {
                                    AST __t412 = _t;
                                    this.match(_t, 221);
                                    _t = _t.getFirstChild();
                                    exp6 = _t == ASTNULL ? null : _t;
                                    this.expr(_t, null);
                                    _t = this._retTree;
                                    if (this.inputState.guessing() == 0) {
                                        try {
                                            EAST cfr_ignored_5 = (EAST)exp6;
                                        }
                                        catch (Exception ex) {
                                            this.userExceptionHandler(ex);
                                        }
                                    }
                                    _t = __t412;
                                    _t = _t.getNextSibling();
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltException(_t);
                                }
                            }
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = this.ELEM_OF_BOOL_TYPE;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block53;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement primitive_expr(AST _t, RfNamedElement lhScope) throws RecognitionException {
        RfNamedElement result;
        block67: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 222: {
                            result = this.paren_expr(_t, lhScope);
                            _t = this._retTree;
                            break;
                        }
                        case 223: 
                        case 224: 
                        case 225: {
                            result = this.field_access_expr(_t, false);
                            _t = this._retTree;
                            break;
                        }
                        case 226: {
                            result = this.port_access_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 183: 
                        case 227: 
                        case 228: 
                        case 229: 
                        case 230: 
                        case 231: 
                        case 232: 
                        case 233: 
                        case 234: 
                        case 235: 
                        case 236: 
                        case 237: 
                        case 238: 
                        case 239: 
                        case 240: 
                        case 241: 
                        case 242: 
                        case 266: 
                        case 507: {
                            result = this.method_invocation(_t, lhScope);
                            _t = this._retTree;
                            break;
                        }
                        case 243: {
                            result = this.list_index_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 244: {
                            result = this.list_range_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 245: {
                            result = this.list_concat_expr(_t, lhScope, true);
                            _t = this._retTree;
                            break;
                        }
                        case 246: {
                            this.bit_slice_expr(_t);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = new RfDummyField(this.rfp, this.UINT_TYPE);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 251: {
                            result = this.bit_concat_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 252: {
                            result = this.range_expr(_t, lhScope);
                            _t = this._retTree;
                            break;
                        }
                        case 256: {
                            result = this.new_expr(_t, lhScope);
                            _t = this._retTree;
                            break;
                        }
                        case 260: {
                            result = this.evaluate_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 259: {
                            this.now_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 261: 
                        case 262: {
                            this.is_a_expr(_t);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = this.ELEM_OF_BOOL_TYPE;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 263: {
                            result = this.all_values_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 264: {
                            result = this.set_of_values_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 265: {
                            result = this.get_all_units_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 267: {
                            this.for_each_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 268: {
                            this.gen_before_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 269: {
                            result = this.select_expr(_t, lhScope);
                            _t = this._retTree;
                            break;
                        }
                        case 277: {
                            result = this.soft_expr(_t, lhScope);
                            _t = this._retTree;
                            break;
                        }
                        case 278: {
                            this.all_of_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 279: 
                        case 280: 
                        case 281: 
                        case 282: 
                        case 283: 
                        case 284: 
                        case 285: 
                        case 286: {
                            result = this.time_unit_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 287: {
                            this.match_term_expr(_t);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = new RfDummyField(this.rfp, this.STRING_TYPE);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 288: {
                            result = this.from_expr(_t, lhScope);
                            _t = this._retTree;
                            break;
                        }
                        case 319: {
                            this.first_then_expr(_t, lhScope);
                            _t = this._retTree;
                            break;
                        }
                        case 416: {
                            this.field_type_constraint_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 417: {
                            this.property_type_constraint_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 189: {
                            this.in_table_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 321: {
                            this.type_is_expr(_t);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = this.ELEM_OF_BOOL_TYPE;
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 322: {
                            this.type_list_dim_expr(_t);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = new RfDummyField(this.rfp, this.UINT_TYPE);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 323: {
                            this.type_bit_size_expr(_t);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = new RfDummyField(this.rfp, this.UINT_TYPE);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 320: {
                            result = this.each_starting_from_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 497: {
                            this.sdl_default_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block67;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement expansion_literal_expr(AST _t) throws RecognitionException {
        RfNamedElement result;
        block15: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t616 = _t;
                    this.match(_t, 298);
                    _t = _t.getFirstChild();
                    this.action_block(_t);
                    _t = this._retTree;
                    _t = __t616;
                    _t = _t.getNextSibling();
                    if (this.inputState.guessing() == 0) {
                        try {
                            result = RfListType.listFromType(this.rfp, this.STRING_TYPE);
                            result = new RfDummyField(this.rfp, result);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement each_line_in_file_expr(AST _t) throws RecognitionException {
        RfNamedElement result;
        block15: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t618 = _t;
                    this.match(_t, 292);
                    _t = _t.getFirstChild();
                    this.expr(_t);
                    _t = this._retTree;
                    _t = __t618;
                    _t = _t.getNextSibling();
                    if (this.inputState.guessing() == 0) {
                        try {
                            result = RfListType.listFromType(this.rfp, this.STRING_TYPE);
                            result = new RfDummyField(this.rfp, result);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement literal_expr(AST _t) throws RecognitionException {
        RfDummyField result;
        block107: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST sl = null;
            AST nl = null;
            AST cl = null;
            AST hl = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 294: {
                            sl = _t;
                            this.match(_t, 294);
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = new RfDummyField(this.rfp, (IRfNamedElement)this.STRING_TYPE, "\"" + sl.getText() + "\"");
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 295: {
                            nl = _t;
                            this.match(_t, 295);
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = nl == null || nl.getText() == null || nl.getText().indexOf(46) == -1 ? new RfDummyField(this.rfp, (IRfNamedElement)this.UINT_TYPE, nl.getText()) : new RfDummyField(this.rfp, (IRfNamedElement)this.REAL_TYPE, nl.getText());
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 296: {
                            cl = _t;
                            this.match(_t, 296);
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = new RfDummyField(this.rfp, (IRfNamedElement)this.BYTE_TYPE, cl.getText());
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 297: {
                            hl = _t;
                            this.match(_t, 297);
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = new RfDummyField(this.rfp, (IRfNamedElement)this.rfp.getSpecman().getHdlLiteralType(), hl.getText());
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 299: {
                            this.match(_t, 299);
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = new RfDummyField(this.rfp, (IRfNamedElement)this.BOOL_TYPE, "TRUE");
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 300: {
                            this.match(_t, 300);
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = new RfDummyField(this.rfp, (IRfNamedElement)this.BOOL_TYPE, "FALSE");
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 301: {
                            this.match(_t, 301);
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = new RfDummyField(this.rfp, (IRfNamedElement)this.rfp.getSpecman().getNullType(), "NULL");
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 302: {
                            this.match(_t, 302);
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = new RfDummyField(this.rfp, (IRfNamedElement)this.rfp.getSpecman().getUndefType(), "UNDEF");
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 303: {
                            this.match(_t, 303);
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = new RfDummyField(this.rfp, (IRfNamedElement)this.INT_TYPE, "MAX_INT");
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 304: {
                            this.match(_t, 304);
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = new RfDummyField(this.rfp, (IRfNamedElement)this.INT_TYPE, "MIN_INT");
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 305: {
                            this.match(_t, 305);
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = new RfDummyField(this.rfp, (IRfNamedElement)this.UINT_TYPE, "MAX_UINT");
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 306: {
                            this.match(_t, 306);
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = new RfDummyField(this.rfp, (IRfNamedElement)this.INT_TYPE, "MAX_LONGINT");
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 307: {
                            this.match(_t, 307);
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = new RfDummyField(this.rfp, (IRfNamedElement)this.INT_TYPE, "MIN_LONGINT");
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 308: {
                            this.match(_t, 308);
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = new RfDummyField(this.rfp, (IRfNamedElement)this.UINT_TYPE, "MAX_LONGUINT");
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 309: {
                            this.match(_t, 309);
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = new RfDummyField(this.rfp, (IRfNamedElement)this.BYTE_TYPE, "STRENGTH_NONE");
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 310: {
                            this.match(_t, 310);
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = new RfDummyField(this.rfp, (IRfNamedElement)this.BYTE_TYPE, "STRENGTH_HIZ");
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 311: {
                            this.match(_t, 311);
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = new RfDummyField(this.rfp, (IRfNamedElement)this.BYTE_TYPE, "STRENGTH_SMALLCHARGE");
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 312: {
                            this.match(_t, 312);
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = new RfDummyField(this.rfp, (IRfNamedElement)this.BYTE_TYPE, "STRENGTH_MEDIUMCHARGE");
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 313: {
                            this.match(_t, 313);
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = new RfDummyField(this.rfp, (IRfNamedElement)this.BYTE_TYPE, "STRENGTH_LARGECHARGE");
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 314: {
                            this.match(_t, 314);
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = new RfDummyField(this.rfp, (IRfNamedElement)this.BYTE_TYPE, "STRENGTH_WEAKDRIVE");
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 315: {
                            this.match(_t, 315);
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = new RfDummyField(this.rfp, (IRfNamedElement)this.BYTE_TYPE, "STRENGTH_PULLDRIVE");
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 316: {
                            this.match(_t, 316);
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = new RfDummyField(this.rfp, (IRfNamedElement)this.BYTE_TYPE, "STRENGTH_STRONGDRIVE");
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        case 317: {
                            this.match(_t, 317);
                            _t = _t.getNextSibling();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = new RfDummyField(this.rfp, (IRfNamedElement)this.BYTE_TYPE, "STRENGTH_SUPPLYDRIVE");
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block107;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement deprecated_tick_id(AST _t, RfNamedElement lhScope) throws RecognitionException {
        RfNamedElement result;
        block49: {
            Runnable finalRunnable;
            block48: {
                result = null;
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST id = null;
                ArrayList<String> determinantParts = new ArrayList<String>();
                ArrayList<AST> ids = new ArrayList<AST>();
                AST id2 = null;
                String prefix = null;
                try {
                    try {
                        AST __t626 = _t;
                        this.match(_t, 318);
                        _t = _t.getFirstChild();
                        int _cnt628 = 0;
                        while (true) {
                            block47: {
                                if (_t == null) {
                                    _t = ASTNULL;
                                }
                                if (_t.getType() == 293) {
                                    id = _t == ASTNULL ? null : _t;
                                    this.identifier(_t);
                                    _t = this._retTree;
                                    if (this.inputState.guessing() == 0) {
                                        try {
                                            if (id == null) break block47;
                                            String text = id.getText();
                                            if ("TRUE".equals(text) || "FALSE".equals(text)) {
                                                prefix = text;
                                                break block47;
                                            }
                                            if (prefix != null) {
                                                determinantParts.add(String.valueOf(prefix) + "'" + id.getText());
                                            } else {
                                                determinantParts.add(id.getText());
                                            }
                                            prefix = null;
                                            ids.add(id);
                                            id2 = id;
                                        }
                                        catch (Exception ex) {
                                            this.userExceptionHandler(ex);
                                        }
                                    }
                                } else {
                                    if (_cnt628 >= 1) break;
                                    throw this.getNoViableAltException(_t);
                                }
                            }
                            ++_cnt628;
                        }
                        _t = __t626;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block48;
                        try {
                            LineInfo lineInfo;
                            if (ids.size() == 2) {
                                result = this.rfp.getType(this.packageName, false, 2, ((AST)ids.get(0)).getText(), this.maxModuleIndex);
                                if (result instanceof RfScalarType && ((RfScalarType)result).isEnumType()) {
                                    this.setTransientResult((AST)ids.get(0), result);
                                    RfNamedElement enumItem = ((RfScalarType)result).semanticGetMember(this.rfp, null, this.packageName, this.getStruct(), ((AST)ids.get(1)).getText(), FIELD, 31, this.maxModuleIndex, this.parserPath, null);
                                    this.module.createVariableDependency(this.rfp, enumItem, ((AST)ids.get(1)).getText());
                                    if (enumItem == null) {
                                        lineInfo = this.getMacroSafeLine((AST)ids.get(1));
                                        this.rfp.addSemanticError2(1, "UNRESOLVED_IDENTIFIER: Cannot resolve identifier ''{0}'' (unresolved preceding expression)", lineInfo.getOffset(), lineInfo.getOffset() + ((AST)ids.get(1)).getText().length(), null, lineInfo.line, this.parserPath, ((AST)ids.get(1)).getText());
                                        result = ERROR_SCOPE;
                                    } else {
                                        this.setTransientResult((AST)ids.get(1), new RfWNamedElementAndScope(enumItem, (RfScalarType)result, true));
                                        result = new RfDummyField(this.rfp, result);
                                    }
                                } else {
                                    result = null;
                                }
                            }
                            if (result == null && id2 != null && this.valid(lhScope) && lhScope instanceof IRfAssociatedType && ((IRfAssociatedType)((Object)lhScope)).getAssociatedBaseType() instanceof RfStruct) {
                                determinantParts.remove(determinantParts.size() - 1);
                                RfType assocType = null;
                                if (lhScope instanceof IRfAssociatedType && !(lhScope instanceof RfUndefVariable)) {
                                    assocType = (RfType)((IRfAssociatedType)((Object)lhScope)).getAssociatedType();
                                    Determinant assocDeterminant = ((IRfAssociatedType)((Object)lhScope)).getAssociatedTypeDeterminant();
                                    if (assocType instanceof RfStruct) {
                                        if (assocType instanceof RfListType) {
                                            determinantParts.add(((RfListType)assocType).getAssociatedBaseType().getName());
                                        } else {
                                            determinantParts.add(assocType.getName());
                                        }
                                        Determinant determinant = new Determinant(determinantParts.toArray(new String[determinantParts.size()]));
                                        if (assocDeterminant != null && assocDeterminant.toArray() != null && assocDeterminant.toArray().length > 1) {
                                            determinant = Determinant.merge(assocDeterminant.toArray(), determinant.toArray());
                                        }
                                        result = ((RfStruct)assocType).semanticGetMember(this.rfp, determinant, this.packageName, this.getStruct(), id2.getText(), FIELD_VARIABLE, 31, this.maxModuleIndex, this.parserPath, null);
                                        this.module.createVariableDependency(this.rfp, result, id2.getText());
                                        if (result == null) {
                                            LineInfo lineInfo2 = this.getMacroSafeLine(id2);
                                            String assocTypeName = this.getAssocTypeName(assocType, determinant);
                                            this.rfp.addSemanticError2(1, "UNDEFINED_IDENTIFIER: Identifier ''{0}'' is not a member of ''{1}''", lineInfo2.getOffset(), lineInfo2.getOffset() + id2.getText().length(), null, lineInfo2.line, this.parserPath, id2.getText(), assocTypeName);
                                            result = ERROR_SCOPE;
                                        } else if (result instanceof IllegalAccessError) {
                                            LineInfo lineInfo3 = this.getMacroSafeLine(id2);
                                            this.rfp.addSemanticError2(1, "ILLEGAL_ACCESS: Cannot access {0} {1} ''{2}.{3}''", lineInfo3.getOffset(), lineInfo3.getOffset() + id2.getText().length(), null, lineInfo3.line, this.parserPath, ((IllegalAccessError)result).getAccessModifierText(), ((IllegalAccessError)result).getElementKindText(), ((IllegalAccessError)result).getParentName(), id2.getText());
                                            result = ((IllegalAccessError)result).getElement();
                                            this.setTransientResult(id2, new RfWNamedElementAndScope(result, (RfStruct)assocType, true));
                                        } else {
                                            this.checkDeprecatedTickIdSubtype(ids, (RfStruct)assocType);
                                            this.setTransientResult(id2, new RfWNamedElementAndScope(result, (RfStruct)assocType, true));
                                        }
                                    }
                                }
                            } else if (result == null && id2 != null && lhScope != ERROR_SCOPE) {
                                RfStruct assocType = this.getStruct();
                                if (assocType instanceof RfStruct) {
                                    determinantParts.add(assocType.getName());
                                    Determinant determinant = new Determinant(determinantParts.toArray(new String[determinantParts.size()]));
                                    result = assocType.semanticGetMember(this.rfp, determinant, this.packageName, assocType, id2.getText(), FIELD_VARIABLE, 31, this.maxModuleIndex, this.parserPath, null);
                                    this.module.createVariableDependency(this.rfp, result, id2.getText());
                                    if (result == null) {
                                        LineInfo lineInfo4 = this.getMacroSafeLine(id2);
                                        String assocTypeName = this.getAssocTypeName(assocType, determinant);
                                        this.rfp.addSemanticError2(1, "UNDEFINED_IDENTIFIER: Identifier ''{0}'' is not a member of ''{1}''", lineInfo4.getOffset(), lineInfo4.getOffset() + id2.getText().length(), null, lineInfo4.line, this.parserPath, id2.getText(), assocTypeName);
                                        result = ERROR_SCOPE;
                                    } else if (result instanceof IllegalAccessError) {
                                        LineInfo lineInfo5 = this.getMacroSafeLine(id2);
                                        this.rfp.addSemanticError2(1, "ILLEGAL_ACCESS: Cannot access {0} {1} ''{2}.{3}''", lineInfo5.getOffset(), lineInfo5.getOffset() + id2.getText().length(), null, lineInfo5.line, this.parserPath, ((IllegalAccessError)result).getAccessModifierText(), ((IllegalAccessError)result).getElementKindText(), ((IllegalAccessError)result).getParentName(), id2.getText());
                                        result = ((IllegalAccessError)result).getElement();
                                        this.setTransientResult(id2, new RfWNamedElementAndScope(result, assocType, true));
                                    } else {
                                        this.setTransientResult(id2, new RfWNamedElementAndScope(result, assocType, true));
                                    }
                                } else {
                                    lineInfo = this.getMacroSafeLine(id2);
                                    this.rfp.addSemanticError2(1, "UNRESOLVED_IDENTIFIER: Cannot resolve identifier ''{0}'' (unresolved preceding expression)", lineInfo.getOffset(), lineInfo.getOffset() + id2.getText().length(), null, lineInfo.line, this.parserPath, id2.getText());
                                    result = ERROR_SCOPE;
                                }
                            }
                            if (lhScope instanceof RfUndefVariable) {
                                ((RfUndefVariable)lhScope).type(result);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block49;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement as_computed_replacement_term(AST _t) throws RecognitionException {
        RfDummyField result;
        block16: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST rt = null;
            try {
                try {
                    rt = _t;
                    this.match(_t, 369);
                    _t = _t.getNextSibling();
                    if (this.inputState.guessing() == 0) {
                        try {
                            RfType assocType = this.STRING_TYPE;
                            if (rt != null && rt.getText().endsWith("s")) {
                                assocType = RfListType.listFromType(this.rfp, this.STRING_TYPE);
                            }
                            result = new RfDummyField(this.rfp, (IRfNamedElement)assocType, new Determinant(new String[]{this.STRING_TYPE.getName()}));
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final void preproc_ifdef_expr(AST _t, RfNamedElement lhScope) throws RecognitionException {
        block17: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t350 = _t;
                    this.match(_t, 185);
                    _t = _t.getFirstChild();
                    this.preproc_id(_t);
                    _t = this._retTree;
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 185: 
                        case 186: 
                        case 187: 
                        case 366: {
                            this.preproc_expr_block(_t, lhScope);
                            _t = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t350;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void preproc_ifndef_expr(AST _t, RfNamedElement lhScope) throws RecognitionException {
        block17: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t353 = _t;
                    this.match(_t, 186);
                    _t = _t.getFirstChild();
                    this.preproc_id(_t);
                    _t = this._retTree;
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 185: 
                        case 186: 
                        case 187: 
                        case 366: {
                            this.preproc_expr_block(_t, lhScope);
                            _t = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t353;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void preproc_id(AST _t) throws RecognitionException {
        block17: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 293: {
                            this.identifier(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 365: {
                            this.match(_t, 365);
                            _t = _t.getNextSibling();
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void preproc_expr_block(AST _t, RfNamedElement lhScope) throws RecognitionException {
        block17: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 185: 
                        case 186: 
                        case 187: {
                            this.expr_list(_t, null, lhScope, null);
                            _t = this._retTree;
                            break;
                        }
                        case 366: {
                            this.match(_t, 366);
                            _t = _t.getNextSibling();
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final RfNamedElement expr_expr_eval(AST _t, SemanticUtils.AssignKind assignKind) throws RecognitionException {
        RfNamedElement result;
        block21: {
            Runnable finalRunnable;
            block20: {
                result = null;
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST exp1 = null;
                AST exp2 = null;
                RfNamedElement result1 = null;
                RfNamedElement result2 = null;
                try {
                    try {
                        exp1 = _t == ASTNULL ? null : _t;
                        result1 = this.expr(_t, null);
                        _t = this._retTree;
                        exp2 = _t == ASTNULL ? null : _t;
                        result2 = this.expr(_t, null);
                        _t = this._retTree;
                        if (this.inputState.guessing() != 0) break block20;
                        try {
                            boolean illegal;
                            RfDummyField expected = null;
                            if (assignKind == SemanticUtils.AssignKind.MATH_BOOL || assignKind == SemanticUtils.AssignKind.ASSIGN_BOOL) {
                                expected = this.ELEM_OF_BOOL_TYPE;
                            }
                            if (assignKind == SemanticUtils.AssignKind.MATH_INT || assignKind == SemanticUtils.AssignKind.ASSIGN_INT) {
                                expected = new RfDummyField(this.rfp, this.INT_TYPE);
                            }
                            if (assignKind == SemanticUtils.AssignKind.MATH_INT_REAL || assignKind == SemanticUtils.AssignKind.ASSIGN_INT_REAL) {
                                expected = new RfDummyField(this.rfp, this.REAL_TYPE);
                            }
                            if (assignKind == SemanticUtils.AssignKind.MATH_STRING) {
                                expected = new RfDummyField(this.rfp, this.STRING_TYPE);
                            }
                            result = SemanticUtils.getResultType(this.rfp, result1, result2, assignKind);
                            if (assignKind == SemanticUtils.AssignKind.ASSIGN) {
                                SemanticUtils.incompatibleAssign(this.rfp, this.parserPath, this.macroDepth, this.macroLineInfo, exp1, exp2, result1, result2, assignKind);
                            } else if (expected != null && !(illegal = SemanticUtils.incompatibleAssign(this.rfp, this.parserPath, this.macroDepth, this.macroLineInfo, null, exp1, expected, result1, assignKind))) {
                                SemanticUtils.incompatibleAssign(this.rfp, this.parserPath, this.macroDepth, this.macroLineInfo, null, exp2, expected, result2, assignKind);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfDummyField.Constraint potential_enum_in_expr_expr_eval(AST _t, boolean allowIdFollowedByExpr, SemanticUtils.AssignKind assignKind) throws RecognitionException {
        RfDummyField.Constraint constraint;
        block115: {
            Runnable finalRunnable;
            block114: {
                constraint = null;
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST id1 = null;
                AST id2 = null;
                AST id3 = null;
                AST exp1 = null;
                AST exp2 = null;
                AST exp7 = null;
                AST exp8 = null;
                AST exp3 = null;
                AST id4 = null;
                AST exp4 = null;
                AST exp5 = null;
                AST exp6 = null;
                RfNamedElement result = null;
                RfWNamedElementAndScope resultId3 = null;
                AST id5 = null;
                int[] depth = new int[]{1};
                RfWNamedElementAndScope resultId5 = null;
                RfNamedElement prevResult = null;
                boolean inList = assignKind == SemanticUtils.AssignKind.IN_LIST;
                try {
                    try {
                        boolean synPredMatched388 = false;
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (_t.getType() == 293) {
                            AST __t388 = _t;
                            synPredMatched388 = true;
                            this.inputState.incGuessing();
                            try {
                                this.identifier(_t);
                                _t = this._retTree;
                                this.identifier(_t);
                                _t = this._retTree;
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched388 = false;
                            }
                            _t = __t388;
                            this.inputState.decGuessing(synPredMatched388);
                        }
                        if (synPredMatched388) {
                            id1 = _t == ASTNULL ? null : _t;
                            this.identifier(_t);
                            _t = this._retTree;
                            id2 = _t == ASTNULL ? null : _t;
                            this.identifier(_t);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    LineInfo lineInfo;
                                    RfWNamedElementAndScope resultId1 = this.resolveIdentifier(id1, FIELD_VARIABLE, false);
                                    RfWNamedElementAndScope resultId2 = this.resolveIdentifier(id2, FIELD_VARIABLE, false);
                                    resultId1 = this.resolvePotentialEnum(id1, resultId1, this.getNamedElement(resultId2), inList);
                                    resultId2 = this.resolvePotentialEnum(id2, resultId2, this.getNamedElement(resultId1), inList);
                                    if (id1 != null) {
                                        this.module.createVariableDependency(this.rfp, this.getNamedElement(resultId1), id1.getText());
                                    }
                                    if (id2 != null) {
                                        this.module.createVariableDependency(this.rfp, this.getNamedElement(resultId2), id2.getText());
                                    }
                                    HashMap<String, Object> attributes = new HashMap<String, Object>();
                                    if (id1 == null || resultId1 != null || !(this.getNamedElement(resultId2) instanceof IRfAssociatedType) || !(((IRfAssociatedType)((Object)this.getNamedElement(resultId2))).getAssociatedBaseType() instanceof IRfTemplateParam)) {
                                        if (id1 != null && resultId1 == null) {
                                            attributes.put("QUICKFIX_ELEMENT_NAME", id1.getText());
                                            attributes.put("QUICKFIX_KIND", 1);
                                            lineInfo = this.getMacroSafeLine(id1);
                                            this.rfp.addSemanticError2(1, "UNDEFINED_IDENTIFIER: Identifier ''{0}'' is not defined", lineInfo.getOffset(), lineInfo.getOffset() + id1.getText().length(), attributes, lineInfo.line, this.parserPath, id1.getText());
                                            resultId1 = new RfWNamedElementAndScope(RfUndefVariable.create(this.rfp, id1.getText()).type(this.getNamedElement(resultId2)), null, true);
                                        } else {
                                            SemanticUtils.incompatibleAssign(this.rfp, this.parserPath, this.macroDepth, this.macroLineInfo, id1, id2, this.getNamedElement(resultId1), this.getNamedElement(resultId2), assignKind);
                                        }
                                    }
                                    if (this.getNamedElement(resultId2) instanceof RfUndefVariable) {
                                        ((RfUndefVariable)this.getNamedElement(resultId2)).type(this.getNamedElement(resultId1));
                                    }
                                    this.setTransientResult(id1, resultId1);
                                    if (!(id2 != null && resultId2 == null && this.getNamedElement(resultId1) instanceof IRfAssociatedType && ((IRfAssociatedType)((Object)this.getNamedElement(resultId1))).getAssociatedBaseType() instanceof IRfTemplateParam || id2 == null || resultId2 != null)) {
                                        attributes.put("QUICKFIX_ELEMENT_NAME", id2.getText());
                                        attributes.put("QUICKFIX_KIND", 1);
                                        lineInfo = this.getMacroSafeLine(id2);
                                        this.rfp.addSemanticError2(1, "UNDEFINED_IDENTIFIER: Identifier ''{0}'' is not defined", lineInfo.getOffset(), lineInfo.getOffset() + id2.getText().length(), attributes, lineInfo.line, this.parserPath, id2.getText());
                                        resultId2 = new RfWNamedElementAndScope(RfUndefVariable.create(this.rfp, id2.getText()).type(this.getNamedElement(resultId1)), null, true);
                                    }
                                    if (this.getNamedElement(resultId1) instanceof RfUndefVariable) {
                                        ((RfUndefVariable)this.getNamedElement(resultId1)).type(this.getNamedElement(resultId2));
                                    }
                                    this.setTransientResult(id2, resultId2);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break block114;
                        }
                        boolean synPredMatched390 = false;
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (_t.getType() == 293 && allowIdFollowedByExpr) {
                            AST __t390 = _t;
                            synPredMatched390 = true;
                            this.inputState.incGuessing();
                            try {
                                this.identifier(_t);
                                _t = this._retTree;
                                this.expr(_t, null);
                                _t = this._retTree;
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched390 = false;
                            }
                            _t = __t390;
                            this.inputState.decGuessing(synPredMatched390);
                        }
                        if (synPredMatched390) {
                            id3 = _t == ASTNULL ? null : _t;
                            this.identifier(_t);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    resultId3 = this.resolveIdentifier(id3, FIELD_VARIABLE, false);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            boolean synPredMatched393 = false;
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            if (_t.getType() == 318) {
                                AST __t393 = _t;
                                synPredMatched393 = true;
                                this.inputState.incGuessing();
                                try {
                                    this.deprecated_tick_id(_t, null);
                                    _t = this._retTree;
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched393 = false;
                                }
                                _t = __t393;
                                this.inputState.decGuessing(synPredMatched393);
                            }
                            if (synPredMatched393) {
                                exp1 = _t == ASTNULL ? null : _t;
                                result = this.deprecated_tick_id(_t, null);
                                _t = this._retTree;
                            } else if (_tokenSet_4.member(_t.getType())) {
                                exp2 = _t == ASTNULL ? null : _t;
                                result = this.expr(_t, this.getNamedElement(resultId3));
                                _t = this._retTree;
                            } else {
                                throw this.getNoViableAltException(_t);
                            }
                            if (this.inputState.guessing() == 0) {
                                try {
                                    resultId3 = this.resolvePotentialEnum(id3, resultId3, result, inList);
                                    if (id3 != null) {
                                        this.module.createVariableDependency(this.rfp, this.getNamedElement(resultId3), id3.getText());
                                    }
                                    HashMap<String, Object> attributes = new HashMap<String, Object>();
                                    if (id3 == null || resultId3 != null || !(result instanceof IRfAssociatedType) || !(((IRfAssociatedType)((Object)result)).getAssociatedBaseType() instanceof IRfTemplateParam)) {
                                        if (id3 != null && resultId3 == null) {
                                            attributes.put("QUICKFIX_ELEMENT_NAME", id3.getText());
                                            attributes.put("QUICKFIX_KIND", 1);
                                            LineInfo lineInfo = this.getMacroSafeLine(id3);
                                            this.rfp.addSemanticError2(1, "UNDEFINED_IDENTIFIER: Identifier ''{0}'' is not defined", lineInfo.getOffset(), lineInfo.getOffset() + id3.getText().length(), attributes, lineInfo.line, this.parserPath, id3.getText());
                                            resultId3 = new RfWNamedElementAndScope(RfUndefVariable.create(this.rfp, id3.getText()).type(result), null, true);
                                        } else {
                                            AST exp = exp1 == null ? exp2 : exp1;
                                            SemanticUtils.incompatibleAssign(this.rfp, this.parserPath, this.macroDepth, this.macroLineInfo, id3, exp, this.getNamedElement(resultId3), result, assignKind);
                                        }
                                    }
                                    if (result instanceof RfUndefVariable) {
                                        ((RfUndefVariable)result).type(this.getNamedElement(resultId3));
                                    }
                                    this.setTransientResult(id3, resultId3);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break block114;
                        }
                        boolean synPredMatched395 = false;
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (_t.getType() == 245 && allowIdFollowedByExpr) {
                            AST __t395 = _t;
                            synPredMatched395 = true;
                            this.inputState.incGuessing();
                            try {
                                this.identifier_list_concat_expr(_t, new int[0]);
                                _t = this._retTree;
                                this.expr(_t, null);
                                _t = this._retTree;
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched395 = false;
                            }
                            _t = __t395;
                            this.inputState.decGuessing(synPredMatched395);
                        }
                        if (synPredMatched395) {
                            id5 = this.identifier_list_concat_expr(_t, depth);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    resultId5 = this.resolveIdentifier(id5, FIELD_VARIABLE, false);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            boolean synPredMatched398 = false;
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            if (_t.getType() == 318) {
                                AST __t398 = _t;
                                synPredMatched398 = true;
                                this.inputState.incGuessing();
                                try {
                                    this.deprecated_tick_id(_t, null);
                                    _t = this._retTree;
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched398 = false;
                                }
                                _t = __t398;
                                this.inputState.decGuessing(synPredMatched398);
                            }
                            if (synPredMatched398) {
                                exp7 = _t == ASTNULL ? null : _t;
                                result = this.deprecated_tick_id(_t, null);
                                _t = this._retTree;
                            } else if (_tokenSet_4.member(_t.getType())) {
                                exp8 = _t == ASTNULL ? null : _t;
                                result = this.expr(_t, this.getNamedElement(resultId5));
                                _t = this._retTree;
                            } else {
                                throw this.getNoViableAltException(_t);
                            }
                            if (this.inputState.guessing() == 0) {
                                try {
                                    resultId5 = this.resolvePotentialEnum(id5, resultId5, result, inList);
                                    if (id5 != null) {
                                        this.module.createVariableDependency(this.rfp, this.getNamedElement(resultId5), id5.getText());
                                    }
                                    HashMap<String, Object> attributes = new HashMap<String, Object>();
                                    if (id5 == null || resultId5 != null || !(result instanceof IRfAssociatedType) || !(((IRfAssociatedType)((Object)result)).getAssociatedBaseType() instanceof IRfTemplateParam)) {
                                        if (id5 != null && resultId5 == null) {
                                            attributes.put("QUICKFIX_ELEMENT_NAME", id5.getText());
                                            attributes.put("QUICKFIX_KIND", 1);
                                            LineInfo lineInfo = this.getMacroSafeLine(id5);
                                            this.rfp.addSemanticError2(1, "UNDEFINED_IDENTIFIER: Identifier ''{0}'' is not defined", lineInfo.getOffset(), lineInfo.getOffset() + id5.getText().length(), attributes, lineInfo.line, this.parserPath, id5.getText());
                                            resultId5 = new RfWNamedElementAndScope(RfUndefVariable.create(this.rfp, id5.getText()).type(result), null, true);
                                        } else {
                                            AST exp = exp7 == null ? exp8 : exp7;
                                            int i = 0;
                                            while (i < depth[0] && result instanceof IRfAssociatedType) {
                                                result = (RfNamedElement)((IRfAssociatedType)((Object)result)).getAssociatedType();
                                                ++i;
                                            }
                                            SemanticUtils.incompatibleAssign(this.rfp, this.parserPath, this.macroDepth, this.macroLineInfo, id5, exp, this.getNamedElement(resultId5), result, assignKind);
                                        }
                                    }
                                    if (result instanceof RfUndefVariable) {
                                        ((RfUndefVariable)result).type(this.getNamedElement(resultId5));
                                    }
                                    this.setTransientResult(id5, resultId5);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break block114;
                        }
                        boolean synPredMatched400 = false;
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (_tokenSet_4.member(_t.getType())) {
                            AST __t400 = _t;
                            synPredMatched400 = true;
                            this.inputState.incGuessing();
                            try {
                                this.expr(_t, null);
                                _t = this._retTree;
                                this.identifier(_t);
                                _t = this._retTree;
                            }
                            catch (RecognitionException recognitionException) {
                                synPredMatched400 = false;
                            }
                            _t = __t400;
                            this.inputState.decGuessing(synPredMatched400);
                        }
                        if (synPredMatched400) {
                            exp3 = _t == ASTNULL ? null : _t;
                            result = this.expr(_t, null);
                            _t = this._retTree;
                            id4 = _t == ASTNULL ? null : _t;
                            this.identifier(_t);
                            _t = this._retTree;
                            if (this.inputState.guessing() != 0) break block114;
                            try {
                                RfWNamedElementAndScope resultId4 = this.resolveIdentifier(id4, FIELD_VARIABLE, false);
                                HashMap<String, Object> attributes = new HashMap<String, Object>();
                                if (result instanceof RfPredefinedMethod && "get_config".equals(result.getName())) {
                                    result = ERROR_SCOPE;
                                } else {
                                    resultId4 = this.resolvePotentialEnum(id4, resultId4, result, inList);
                                    if (id4 != null) {
                                        this.module.createVariableDependency(this.rfp, this.getNamedElement(resultId4), id4.getText());
                                    }
                                    if (id4 == null || resultId4 != null || !(result instanceof IRfAssociatedType) || !(((IRfAssociatedType)((Object)result)).getAssociatedBaseType() instanceof IRfTemplateParam)) {
                                        if (id4 != null && resultId4 == null) {
                                            attributes.put("QUICKFIX_ELEMENT_NAME", id4.getText());
                                            attributes.put("QUICKFIX_KIND", 1);
                                            LineInfo lineInfo = this.getMacroSafeLine(id4);
                                            this.rfp.addSemanticError2(1, "UNDEFINED_IDENTIFIER: Identifier ''{0}'' is not defined", lineInfo.getOffset(), lineInfo.getOffset() + id4.getText().length(), attributes, lineInfo.line, this.parserPath, id4.getText());
                                            resultId4 = new RfWNamedElementAndScope(RfUndefVariable.create(this.rfp, id4.getText()).type(result), null, true);
                                        } else {
                                            SemanticUtils.incompatibleAssign(this.rfp, this.parserPath, this.macroDepth, this.macroLineInfo, exp3, id4, result, this.getNamedElement(resultId4), assignKind);
                                        }
                                    }
                                    if (result instanceof RfUndefVariable) {
                                        ((RfUndefVariable)result).type(this.getNamedElement(resultId4));
                                    }
                                    this.setTransientResult(id4, resultId4);
                                    if (exp3 != null && result instanceof RfField && this.getNamedElement(resultId4) instanceof RfEnum) {
                                        RfVar itVar = null;
                                        if (exp3.getType() == 225) {
                                            itVar = this.getTransientResult(RfVar.class, exp3);
                                        } else if (exp3.getType() == 223 && exp3.getFirstChild() != null && "it".equals(exp3.getFirstChild().getText())) {
                                            itVar = this.getTransientResult(RfVar.class, exp3.getFirstChild());
                                        }
                                        if (itVar != null) {
                                            RfStructQualifier structQualifier = new RfStructQualifier(this.rfp, (RfEnum)this.getNamedElement(resultId4), (RfField)result);
                                            constraint = new RfDummyField.Constraint(itVar, structQualifier.toString());
                                        }
                                    }
                                }
                                break block114;
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break block114;
                        }
                        if (_tokenSet_4.member(_t.getType())) {
                            exp4 = _t == ASTNULL ? null : _t;
                            result = this.expr(_t, null);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    prevResult = result;
                                    if (result instanceof RfPredefinedMethod && "get_config".equals(result.getName())) {
                                        result = ERROR_SCOPE;
                                    }
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            boolean synPredMatched403 = false;
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            if (_t.getType() == 318) {
                                AST __t403 = _t;
                                synPredMatched403 = true;
                                this.inputState.incGuessing();
                                try {
                                    this.deprecated_tick_id(_t, null);
                                    _t = this._retTree;
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched403 = false;
                                }
                                _t = __t403;
                                this.inputState.decGuessing(synPredMatched403);
                            }
                            if (synPredMatched403) {
                                exp5 = _t == ASTNULL ? null : _t;
                                result = this.deprecated_tick_id(_t, this.undefVarOrNull(result));
                                _t = this._retTree;
                            } else if (_tokenSet_4.member(_t.getType())) {
                                exp6 = _t == ASTNULL ? null : _t;
                                result = this.expr(_t, result);
                                _t = this._retTree;
                            } else {
                                throw this.getNoViableAltException(_t);
                            }
                            if (this.inputState.guessing() == 0) {
                                try {
                                    if (result instanceof RfUndefVariable) {
                                        ((RfUndefVariable)result).type(prevResult);
                                    } else if (prevResult instanceof RfUndefVariable) {
                                        ((RfUndefVariable)prevResult).type(result);
                                    }
                                    AST exp = exp5 == null ? exp6 : exp5;
                                    SemanticUtils.incompatibleAssign(this.rfp, this.parserPath, this.macroDepth, this.macroLineInfo, exp4, exp, prevResult, result, assignKind);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break block114;
                        }
                        throw this.getNoViableAltException(_t);
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block115;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return constraint;
    }

    public final AST identifier_list_concat_expr(AST _t, int[] depth) throws RecognitionException {
        AST id;
        block22: {
            id = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST id1 = null;
            try {
                try {
                    AST __t510 = _t;
                    this.match(_t, 245);
                    _t = _t.getFirstChild();
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 245: {
                            id = this.identifier_list_concat_expr(_t, depth);
                            _t = this._retTree;
                            break;
                        }
                        case 293: {
                            id1 = _t == ASTNULL ? null : _t;
                            this.identifier(_t);
                            _t = this._retTree;
                            if (this.inputState.guessing() != 0) break;
                            try {
                                id = id1;
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t510;
                    _t = _t.getNextSibling();
                    if (this.inputState.guessing() == 0) {
                        try {
                            depth[0] = depth[0] + 1;
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return id;
    }

    public final RfNamedElement paren_expr(AST _t, RfNamedElement lhScope) throws RecognitionException {
        RfNamedElement result;
        block12: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t456 = _t;
                    this.match(_t, 222);
                    _t = _t.getFirstChild();
                    result = this.expr(_t, lhScope);
                    _t = this._retTree;
                    _t = __t456;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement method_invocation(AST _t, RfNamedElement lhScope) throws RecognitionException {
        RfNamedElement result;
        block25: {
            RfType assocType;
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            boolean propagateScope = false;
            if (lhScope instanceof RfDummyField && ((RfDummyField)lhScope).isPerUnitInstance()) {
                propagateScope = true;
            } else if (lhScope instanceof IRfAssociatedType && (assocType = (RfType)((IRfAssociatedType)((Object)lhScope)).getAssociatedBaseType()) instanceof RfScalarType && ((RfScalarType)assocType).isEnumType()) {
                propagateScope = true;
            }
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 183: 
                        case 227: 
                        case 228: 
                        case 229: 
                        case 230: 
                        case 231: 
                        case 232: 
                        case 233: 
                        case 234: 
                        case 235: 
                        case 236: 
                        case 237: 
                        case 266: 
                        case 507: {
                            result = this.method_invocation_expr(_t, null, lhScope);
                            _t = this._retTree;
                            break;
                        }
                        case 238: 
                        case 239: 
                        case 240: {
                            result = this.method_access_expr(_t, propagateScope ? lhScope : null);
                            _t = this._retTree;
                            break;
                        }
                        case 241: {
                            result = this.method_port_invocation_expr(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 242: {
                            this.hdl_method_invocation_expr(_t);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    result = new RfDummyField(this.rfp, this.UINT_TYPE);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block25;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement list_index_expr(AST _t) throws RecognitionException {
        RfNamedElement result;
        block22: {
            Runnable finalRunnable;
            block21: {
                result = null;
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST exp = null;
                try {
                    try {
                        AST __t506 = _t;
                        this.match(_t, 243);
                        _t = _t.getFirstChild();
                        result = this.expr(_t, null);
                        _t = this._retTree;
                        exp = _t == ASTNULL ? null : _t;
                        this.expr(_t, null);
                        _t = this._retTree;
                        _t = __t506;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block21;
                        try {
                            if (result != null && this.valid(result)) {
                                List<IRfAssociatedType> params;
                                RfType assocType = (RfType)((IRfAssociatedType)((Object)result)).getAssociatedType();
                                Determinant assocDeterminant = ((IRfAssociatedType)((Object)result)).getAssociatedTypeDeterminant();
                                if (assocType instanceof RfTemplateStructInstance && RfPredefinedStruct.PORT_STRUCT_NAMES.contains(assocType.getName()) && (params = ((RfTemplateStructInstance)assocType).getParameters()) != null && params.size() == 1) {
                                    assocType = (RfType)params.get(0).getAssociatedType();
                                }
                                if (assocType instanceof RfListType) {
                                    assocType = RfListType.typeFromList(this.rfp, (RfListType)assocType);
                                    result = new RfDummyField(this.rfp, (IRfNamedElement)assocType, assocDeterminant);
                                } else if (assocType instanceof RfScalarType && assocType != this.BIT_TYPE) {
                                    lineInfo = this.getTreeLineInfo(exp);
                                    if (!"HDL_LITERAL".equals(assocType.getName())) {
                                        this.rfp.addSemanticError2(1, "SELECT_IN_NON_LIST: Cannot use select, element ''{0}'' is not a list", lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, this.parserPath, result.getName());
                                    }
                                    result = new RfDummyField(this.rfp, this.BIT_TYPE);
                                } else if (exp != null) {
                                    lineInfo = this.getTreeLineInfo(exp);
                                    this.rfp.addSemanticError2(1, "SELECT_IN_NON_LIST: Cannot use select, element ''{0}'' is not a list", lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, this.parserPath, result.getName());
                                    result = ERROR_SCOPE;
                                }
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement list_range_expr(AST _t) throws RecognitionException {
        RfNamedElement result;
        block20: {
            Runnable finalRunnable;
            block19: {
                result = null;
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST exp = null;
                try {
                    try {
                        AST __t508 = _t;
                        this.match(_t, 244);
                        _t = _t.getFirstChild();
                        result = this.expr(_t, null);
                        _t = this._retTree;
                        exp = _t == ASTNULL ? null : _t;
                        this.range(_t, null);
                        _t = this._retTree;
                        _t = __t508;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block19;
                        try {
                            if (result != null && this.valid(result)) {
                                List<IRfAssociatedType> params;
                                RfType assocType = (RfType)((IRfAssociatedType)((Object)result)).getAssociatedType();
                                if (assocType instanceof RfTemplateStructInstance && RfPredefinedStruct.PORT_STRUCT_NAMES.contains(assocType.getName()) && (params = ((RfTemplateStructInstance)assocType).getParameters()) != null && params.size() == 1) {
                                    assocType = (RfType)params.get(0).getAssociatedType();
                                }
                                if (!(assocType instanceof RfListType)) {
                                    if (assocType instanceof RfScalarType) {
                                        result = RfListType.listFromType(this.rfp, this.BIT_TYPE);
                                        result = new RfDummyField(this.rfp, (RfListType)result);
                                    } else if (exp != null) {
                                        LineInfo lineInfo = this.getTreeLineInfo(exp);
                                        this.rfp.addSemanticError2(1, "SELECT_IN_NON_LIST: Cannot use select, element ''{0}'' is not a list", lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, this.parserPath, result.getName());
                                        result = ERROR_SCOPE;
                                    }
                                }
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement list_concat_expr(AST _t, RfNamedElement lhScope, boolean applyDepthCorrection) throws RecognitionException {
        RfNamedElement result;
        block45: {
            Runnable finalRunnable;
            block44: {
                result = null;
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST lce = null;
                AST exp1 = null;
                AST exp2 = null;
                AST exp = null;
                boolean emptyList = true;
                RfNamedElement tmpResult = null;
                int concatDepth = Integer.MAX_VALUE;
                int minFinalListDepth = 0;
                int maxFinalListDepth = Integer.MAX_VALUE;
                boolean errorAlreadyReported = false;
                int firstElementMinListDepth = lhScope instanceof IRfAssociatedType ? ((IRfAssociatedType)((Object)lhScope)).getAssociatedTypeList() : -1;
                try {
                    try {
                        AST __t515 = _t;
                        lce = _t == ASTNULL ? null : _t;
                        this.match(_t, 245);
                        _t = _t.getFirstChild();
                        while (true) {
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            if (!_tokenSet_4.member(_t.getType())) break;
                            boolean synPredMatched519 = false;
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            if (_t.getType() == 245) {
                                AST __t519 = _t;
                                synPredMatched519 = true;
                                this.inputState.incGuessing();
                                try {
                                    this.match(_t, 245);
                                    _t = _t.getNextSibling();
                                }
                                catch (RecognitionException recognitionException) {
                                    synPredMatched519 = false;
                                }
                                _t = __t519;
                                this.inputState.decGuessing(synPredMatched519);
                            }
                            if (synPredMatched519) {
                                exp1 = _t == ASTNULL ? null : _t;
                                tmpResult = this.list_concat_expr(_t, lhScope, false);
                                _t = this._retTree;
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        exp = exp1;
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                            } else if (_tokenSet_4.member(_t.getType())) {
                                exp2 = _t == ASTNULL ? null : _t;
                                tmpResult = this.expr(_t, lhScope);
                                _t = this._retTree;
                                if (this.inputState.guessing() == 0) {
                                    try {
                                        exp = exp2;
                                    }
                                    catch (Exception ex) {
                                        this.userExceptionHandler(ex);
                                    }
                                }
                            } else {
                                throw this.getNoViableAltException(_t);
                            }
                            if (this.inputState.guessing() != 0) continue;
                            try {
                                emptyList = false;
                                if (!this.valid(result)) {
                                    result = tmpResult;
                                }
                                int listDepthOfElement = tmpResult instanceof IRfAssociatedType ? ((IRfAssociatedType)((Object)tmpResult)).getAssociatedTypeList() : 0;
                                int concatDepthOfElement = tmpResult instanceof RfDummyField ? Math.max(0, ((RfDummyField)tmpResult).getConcatDepth()) : 0;
                                minFinalListDepth = Math.max(minFinalListDepth, listDepthOfElement - concatDepthOfElement);
                                maxFinalListDepth = Math.max(minFinalListDepth, Math.min(maxFinalListDepth, listDepthOfElement));
                                if (applyDepthCorrection && firstElementMinListDepth < 0) {
                                    firstElementMinListDepth = minFinalListDepth;
                                } else if (applyDepthCorrection && !errorAlreadyReported && exp != null && this.valid(tmpResult) && listDepthOfElement - concatDepthOfElement > firstElementMinListDepth + 1) {
                                    SemanticUtils.incompatibleListElement(this.rfp, true, this.parserPath, this.macroDepth, this.macroLineInfo, exp, tmpResult, firstElementMinListDepth);
                                    errorAlreadyReported = true;
                                } else if (applyDepthCorrection && !errorAlreadyReported && exp != null && this.valid(tmpResult) && listDepthOfElement + 1 < firstElementMinListDepth) {
                                    SemanticUtils.incompatibleListElement(this.rfp, false, this.parserPath, this.macroDepth, this.macroLineInfo, exp, tmpResult, firstElementMinListDepth);
                                    errorAlreadyReported = true;
                                }
                                concatDepth = Math.min(concatDepthOfElement, concatDepth);
                            }
                            catch (Exception ex) {
                                this.userExceptionHandler(ex);
                            }
                        }
                        _t = __t515;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block44;
                        try {
                            int n = maxFinalListDepth = maxFinalListDepth == Integer.MAX_VALUE ? 1 : maxFinalListDepth + 1;
                            if (result != null && result instanceof RfEnum) {
                                result = new RfDummyField(this.rfp, ((RfEnum)result).getAssociatedType());
                            }
                            if (result != null && this.valid(result)) {
                                RfType assocType = result instanceof RfSemanticUnsafe ? this.rfp.getSpecman().getUntypedType() : (RfType)((IRfAssociatedType)((Object)result)).getAssociatedBaseType();
                                Determinant assocDeterminant = ((IRfAssociatedType)((Object)result)).getAssociatedTypeDeterminant();
                                String assocListKey = ((IRfAssociatedType)((Object)result)).getAssociatedTypeListKey();
                                int assocListDepth = ((IRfAssociatedType)((Object)result)).getAssociatedTypeList();
                                int resultAssocListDepth = assocListDepth + 1;
                                if (applyDepthCorrection) {
                                    int lhAssocListDepth;
                                    int n2 = lhAssocListDepth = lhScope instanceof IRfAssociatedType ? ((IRfAssociatedType)((Object)lhScope)).getAssociatedTypeList() : Math.max(1, firstElementMinListDepth);
                                    resultAssocListDepth = minFinalListDepth <= lhAssocListDepth && lhAssocListDepth <= maxFinalListDepth ? lhAssocListDepth : (minFinalListDepth > lhAssocListDepth ? minFinalListDepth : maxFinalListDepth);
                                    if (resultAssocListDepth == 0) {
                                        resultAssocListDepth = 1;
                                    }
                                }
                                if (resultAssocListDepth != assocListDepth || !(result instanceof RfDummyField)) {
                                    result = RfListType.listFromType(this.rfp, assocType, assocDeterminant, assocListKey, resultAssocListDepth);
                                    result = new RfDummyField(this.rfp, (IRfNamedElement)((RfListType)result), assocDeterminant);
                                }
                                concatDepth = concatDepth == Integer.MAX_VALUE ? 1 : concatDepth + 1;
                                ((RfDummyField)result).setConcatDepth(concatDepth);
                                this.setTransientResult(lce, result);
                            } else if (emptyList && lhScope != null && lhScope != ERROR_SCOPE) {
                                result = lhScope;
                                this.setTransientResult(lce, result);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block45;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final void bit_slice_expr(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t522 = _t;
                    this.match(_t, 246);
                    _t = _t.getFirstChild();
                    this.expr(_t, null);
                    _t = this._retTree;
                    this.slice(_t);
                    _t = this._retTree;
                    _t = __t522;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final RfNamedElement bit_concat_expr(AST _t) throws RecognitionException {
        RfNamedElement result;
        block17: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t535 = _t;
                    this.match(_t, 251);
                    _t = _t.getFirstChild();
                    while (true) {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (!_tokenSet_4.member(_t.getType())) break;
                        this.expr(_t, null);
                        _t = this._retTree;
                    }
                    _t = __t535;
                    _t = _t.getNextSibling();
                    if (this.inputState.guessing() == 0) {
                        try {
                            result = RfListType.listFromType(this.rfp, this.BIT_TYPE);
                            result = new RfDummyField(this.rfp, (IRfNamedElement)result, null).setIsBitConcat();
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement range_expr(AST _t, RfNamedElement lhScope) throws RecognitionException {
        RfDummyField result;
        block24: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST re = null;
            boolean disableReport = false;
            RfNamedElement element = null;
            try {
                try {
                    AST __t539 = _t;
                    this.match(_t, 252);
                    _t = _t.getFirstChild();
                    while (true) {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (!_tokenSet_16.member(_t.getType())) break;
                        re = _t == ASTNULL ? null : _t;
                        element = this.range_element(_t, lhScope);
                        _t = this._retTree;
                        if (this.inputState.guessing() != 0) continue;
                        try {
                            RfType assocType2;
                            if (re == null || disableReport || !this.valid(lhScope) || !this.valid(element) && !(element instanceof RfEnum)) continue;
                            RfType assocType1 = (RfType)((IRfAssociatedType)((Object)lhScope)).getAssociatedType();
                            RfType rfType = assocType2 = element instanceof RfEnum ? ((RfEnum)element).getAssociatedType() : ((IRfAssociatedType)((Object)element)).getAssociatedType();
                            if (!(assocType1 instanceof RfScalarType) || !(assocType2 instanceof RfScalarType) || !SemanticUtils.incompatibleAssign(this.rfp, this.parserPath, this.macroDepth, this.macroLineInfo, null, re.getFirstChild(), lhScope, element, SemanticUtils.AssignKind.ASSIGN)) continue;
                            disableReport = true;
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 496: {
                            this.sdl_range_units(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t539;
                    _t = _t.getNextSibling();
                    if (this.inputState.guessing() == 0) {
                        try {
                            result = new RfDummyField(this.rfp, this.SET_TYPE);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement new_expr(AST _t, RfNamedElement lhScope) throws RecognitionException {
        RfNamedElement result;
        block31: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST ne = null;
            InnerInclude innerInclude = null;
            EAST name = null;
            try {
                try {
                    AST __t558 = _t;
                    ne = _t == ASTNULL ? null : _t;
                    this.match(_t, 256);
                    _t = _t.getFirstChild();
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 257: {
                            result = this.new_type(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 3: 
                        case 100: 
                        case 258: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 258: {
                            name = this.new_name(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 3: 
                        case 100: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (this.inputState.guessing() == 0) {
                        try {
                            final RfNamedElement scope = result != null ? result : lhScope;
                            this.setTransientResult(ne, scope);
                            final EAST varAST = name;
                            innerInclude = new InnerInclude(){

                                @Override
                                public void include(AST ab) {
                                    RfActionBlockLayer def;
                                    if (ab != null && (def = SemanticWalker.this.getTransientScope(RfActionBlockLayer.class, ab)) != null && SemanticWalker.this.valid(scope)) {
                                        IRfNamedElement assocType = ((IRfAssociatedType)((Object)scope)).getAssociatedType();
                                        if (assocType instanceof RfListType) {
                                            assocType = ((RfListType)assocType).getAssociatedType();
                                        }
                                        Determinant assocDeterminant = ((IRfAssociatedType)((Object)scope)).getAssociatedTypeDeterminant();
                                        if (assocType instanceof RfStruct) {
                                            String varName = varAST != null ? varAST.getText() : "it";
                                            LineInfo startLine = varAST != null ? SemanticWalker.this.getMacroSafeLine((AST)varAST) : SemanticWalker.this.getMacroSafeLine(ab);
                                            RfVarLayer varLayer = def.startVarLayer(SemanticWalker.this.rfp, varName, (RfType)assocType, assocDeterminant, startLine, new CommentBlock("<i>PREDEFINED: </i>Variable referring to the current created item.", null, false), RfProject.VariableKind.IT);
                                            if (varAST != null) {
                                                SemanticWalker.this.setTransientResult((AST)varAST, varLayer.getNamedElement());
                                            }
                                        }
                                    }
                                }

                                @Override
                                public LineInfo getStartLine(AST ab) {
                                    return null;
                                }
                            };
                            if (result == null && lhScope != null && !"apply_container".equals(lhScope.getName())) {
                                result = lhScope;
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 100: {
                            this.action_block(_t, innerInclude);
                            _t = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t558;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block31;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement evaluate_expr(AST _t) throws RecognitionException {
        RfNamedElement result;
        block21: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST ev = null;
            AST id = null;
            InnerInclude innerInclude = null;
            try {
                try {
                    AST __t555 = _t;
                    ev = _t == ASTNULL ? null : _t;
                    this.match(_t, 260);
                    _t = _t.getFirstChild();
                    result = this.type(_t);
                    _t = this._retTree;
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 293: {
                            id = _t == ASTNULL ? null : _t;
                            this.identifier(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 100: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (this.inputState.guessing() == 0) {
                        try {
                            this.setTransientResult(ev, result);
                            if (id != null) {
                                final EAST varAST = (EAST)id;
                                final RfNamedElement scope = result;
                                innerInclude = new InnerInclude(){

                                    @Override
                                    public void include(AST ab) {
                                        RfActionBlockLayer def;
                                        if (ab != null && (def = SemanticWalker.this.getTransientScope(RfActionBlockLayer.class, ab)) != null && SemanticWalker.this.valid(scope)) {
                                            IRfNamedElement assocType = ((IRfAssociatedType)((Object)scope)).getAssociatedType();
                                            Determinant assocDeterminant = ((IRfAssociatedType)((Object)scope)).getAssociatedTypeDeterminant();
                                            String varName = varAST.getText();
                                            LineInfo startLine = SemanticWalker.this.getMacroSafeLine((AST)varAST);
                                            RfVarLayer varLayer = def.startVarLayer(SemanticWalker.this.rfp, varName, (RfType)assocType, assocDeterminant, startLine, new CommentBlock("<i>PREDEFINED: </i>Variable referring to the current evaluated expression.", null, false), RfProject.VariableKind.DEFAULT);
                                            SemanticWalker.this.setTransientResult((AST)varAST, varLayer.getNamedElement());
                                        }
                                    }

                                    @Override
                                    public LineInfo getStartLine(AST ab) {
                                        return null;
                                    }
                                };
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    this.action_block(_t, innerInclude);
                    _t = this._retTree;
                    _t = __t555;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final void now_expr(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t567 = _t;
                    this.match(_t, 259);
                    _t = _t.getFirstChild();
                    this.event(_t);
                    _t = this._retTree;
                    _t = __t567;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void is_a_expr(AST _t) throws RecognitionException {
        block25: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            AST is = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 261: {
                            AST __t569 = _t;
                            this.match(_t, 261);
                            _t = _t.getFirstChild();
                            this.expr(_t, null);
                            _t = this._retTree;
                            this.type(_t);
                            _t = this._retTree;
                            _t = __t569;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 262: {
                            AST __t570 = _t;
                            is = _t == ASTNULL ? null : _t;
                            this.match(_t, 262);
                            _t = _t.getFirstChild();
                            this.expr(_t, null);
                            _t = this._retTree;
                            if (this.inputState.guessing() == 0) {
                                try {
                                    this.pushScopeLayer(is);
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            this.type(_t);
                            _t = this._retTree;
                            if (_t == null) {
                                _t = ASTNULL;
                            }
                            switch (_t.getType()) {
                                case 293: {
                                    this.identifier(_t);
                                    _t = this._retTree;
                                    break;
                                }
                                case 3: {
                                    break;
                                }
                                default: {
                                    throw this.getNoViableAltException(_t);
                                }
                            }
                            _t = __t570;
                            _t = _t.getNextSibling();
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block25;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final RfNamedElement all_values_expr(AST _t) throws RecognitionException {
        RfNamedElement result;
        block15: {
            Runnable finalRunnable;
            block14: {
                result = null;
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                try {
                    try {
                        AST __t573 = _t;
                        this.match(_t, 263);
                        _t = _t.getFirstChild();
                        result = this.type(_t);
                        _t = this._retTree;
                        _t = __t573;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block14;
                        try {
                            RfType assocType;
                            if (result != null && this.valid(result) && (assocType = (RfType)((IRfAssociatedType)((Object)result)).getAssociatedType()) instanceof RfType) {
                                result = RfListType.listFromType(this.rfp, assocType);
                                result = new RfDummyField(this.rfp, (IRfNamedElement)((RfListType)result), null);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement set_of_values_expr(AST _t) throws RecognitionException {
        RfNamedElement result;
        block15: {
            Runnable finalRunnable;
            block14: {
                result = null;
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                try {
                    try {
                        AST __t575 = _t;
                        this.match(_t, 264);
                        _t = _t.getFirstChild();
                        result = this.type(_t);
                        _t = this._retTree;
                        _t = __t575;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block14;
                        try {
                            RfType assocType;
                            if (result != null && this.valid(result) && (assocType = (RfType)((IRfAssociatedType)((Object)result)).getAssociatedType()) instanceof RfType) {
                                result = new RfDummyField(this.rfp, this.SET_TYPE);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final RfNamedElement get_all_units_expr(AST _t) throws RecognitionException {
        RfNamedElement result;
        block21: {
            Runnable finalRunnable;
            block20: {
                result = null;
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                try {
                    try {
                        AST __t577 = _t;
                        this.match(_t, 265);
                        _t = _t.getFirstChild();
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 129: {
                                result = this.subtype_expr(_t);
                                _t = this._retTree;
                                break;
                            }
                            case 35: 
                            case 40: 
                            case 293: 
                            case 324: 
                            case 325: 
                            case 326: 
                            case 327: 
                            case 331: 
                            case 332: 
                            case 333: 
                            case 334: 
                            case 335: 
                            case 336: 
                            case 337: 
                            case 338: 
                            case 379: 
                            case 409: 
                            case 410: 
                            case 412: 
                            case 418: {
                                result = this.type(_t);
                                _t = this._retTree;
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        _t = __t577;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block20;
                        try {
                            if (result != null && this.valid(result)) {
                                IRfNamedElement assocType = ((IRfAssociatedType)((Object)result)).getAssociatedType();
                                Determinant assocDeterminant = ((IRfAssociatedType)((Object)result)).getAssociatedTypeDeterminant();
                                if (assocType instanceof RfStruct) {
                                    ((RfStruct)assocType).isUnit();
                                    assocType = RfListType.listFromType(this.rfp, (RfType)assocType, assocDeterminant, null, 1);
                                    result = new RfDummyField(this.rfp, (IRfNamedElement)((RfType)assocType), assocDeterminant);
                                }
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final void gen_before_expr(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t582 = _t;
                    this.match(_t, 268);
                    _t = _t.getFirstChild();
                    this.expr_list(_t);
                    _t = this._retTree;
                    this.expr_list(_t);
                    _t = this._retTree;
                    _t = __t582;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final RfNamedElement soft_expr(AST _t, RfNamedElement lhScope) throws RecognitionException {
        RfNamedElement result;
        block12: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t593 = _t;
                    this.match(_t, 277);
                    _t = _t.getFirstChild();
                    result = this.expr(_t, lhScope);
                    _t = this._retTree;
                    _t = __t593;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final void all_of_expr(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t595 = _t;
                    this.match(_t, 278);
                    _t = _t.getFirstChild();
                    this.expr_list(_t);
                    _t = this._retTree;
                    _t = __t595;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final RfNamedElement time_unit_expr(AST _t) throws RecognitionException {
        RfDummyField result;
        block26: {
            result = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 279: {
                            AST __t598 = _t;
                            this.match(_t, 279);
                            _t = _t.getFirstChild();
                            this.expr(_t, null);
                            _t = this._retTree;
                            _t = __t598;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 280: {
                            AST __t599 = _t;
                            this.match(_t, 280);
                            _t = _t.getFirstChild();
                            this.expr(_t, null);
                            _t = this._retTree;
                            _t = __t599;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 281: {
                            AST __t600 = _t;
                            this.match(_t, 281);
                            _t = _t.getFirstChild();
                            this.expr(_t, null);
                            _t = this._retTree;
                            _t = __t600;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 282: {
                            AST __t601 = _t;
                            this.match(_t, 282);
                            _t = _t.getFirstChild();
                            this.expr(_t, null);
                            _t = this._retTree;
                            _t = __t601;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 283: {
                            AST __t602 = _t;
                            this.match(_t, 283);
                            _t = _t.getFirstChild();
                            this.expr(_t, null);
                            _t = this._retTree;
                            _t = __t602;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 284: {
                            AST __t603 = _t;
                            this.match(_t, 284);
                            _t = _t.getFirstChild();
                            this.expr(_t, null);
                            _t = this._retTree;
                            _t = __t603;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 285: {
                            AST __t604 = _t;
                            this.match(_t, 285);
                            _t = _t.getFirstChild();
                            this.expr(_t, null);
                            _t = this._retTree;
                            _t = __t604;
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 286: {
                            AST __t605 = _t;
                            this.match(_t, 286);
                            _t = _t.getFirstChild();
                            this.expr(_t, null);
                            _t = this._retTree;
                            _t = __t605;
                            _t = _t.getNextSibling();
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    if (this.inputState.guessing() == 0) {
                        try {
                            result = new RfDummyField(this.rfp, this.TIME_TYPE);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final void match_term_expr(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t607 = _t;
                    this.match(_t, 287);
                    _t = _t.getFirstChild();
                    this.match(_t, 295);
                    _t = _t.getNextSibling();
                    _t = __t607;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final RfNamedElement from_expr(AST _t, RfNamedElement lhScope) throws RecognitionException {
        RfNamedElement result;
        block25: {
            Runnable finalRunnable;
            block24: {
                result = null;
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                try {
                    try {
                        AST __t609 = _t;
                        this.match(_t, 288);
                        _t = _t.getFirstChild();
                        result = this.expr(_t, lhScope);
                        _t = this._retTree;
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 289: {
                                AST __t611 = _t;
                                this.match(_t, 289);
                                _t = _t.getFirstChild();
                                this.expr(_t, lhScope);
                                _t = this._retTree;
                                _t = __t611;
                                _t = _t.getNextSibling();
                                break;
                            }
                            case 290: {
                                AST __t612 = _t;
                                this.match(_t, 290);
                                _t = _t.getFirstChild();
                                this.expr(_t, lhScope);
                                _t = this._retTree;
                                _t = __t612;
                                _t = _t.getNextSibling();
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 291: {
                                AST __t614 = _t;
                                this.match(_t, 291);
                                _t = _t.getFirstChild();
                                this.expr(_t, null);
                                _t = this._retTree;
                                _t = __t614;
                                _t = _t.getNextSibling();
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                throw this.getNoViableAltException(_t);
                            }
                        }
                        _t = __t609;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block24;
                        try {
                            if (result == null || !this.valid(result)) break block24;
                            RfType assocType = (RfType)((IRfAssociatedType)((Object)result)).getAssociatedBaseType();
                            Determinant assocDeterminant = ((IRfAssociatedType)((Object)result)).getAssociatedTypeDeterminant();
                            String assocListKey = ((IRfAssociatedType)((Object)result)).getAssociatedTypeListKey();
                            int assocListDepth = ((IRfAssociatedType)((Object)result)).getAssociatedTypeList();
                            if (assocType instanceof RfType) {
                                assocType = RfListType.listFromType(this.rfp, assocType, assocDeterminant, assocListKey, assocListDepth + 1);
                                result = new RfDummyField(this.rfp, (IRfNamedElement)assocType, assocDeterminant);
                                break block24;
                            }
                            result = ERROR_SCOPE;
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final void first_then_expr(AST _t, RfNamedElement lhScope) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t454 = _t;
                    this.match(_t, 319);
                    _t = _t.getFirstChild();
                    this.action_block(_t);
                    _t = this._retTree;
                    this.expr(_t, lhScope);
                    _t = this._retTree;
                    _t = __t454;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void field_type_constraint_expr(AST _t) throws RecognitionException {
        block16: {
            Runnable finalRunnable;
            block15: {
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST id = null;
                try {
                    try {
                        AST __t450 = _t;
                        this.match(_t, 416);
                        _t = _t.getFirstChild();
                        id = _t == ASTNULL ? null : _t;
                        this.identifier(_t);
                        _t = this._retTree;
                        this.type(_t);
                        _t = this._retTree;
                        _t = __t450;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block15;
                        try {
                            RfNamedElement result;
                            if (id == null || !((result = this.getTransientResult(RfNamedElement.class, id)) instanceof RfFieldTypeConstraint)) break block15;
                            RfStruct parentStruct = ((RfFieldTypeConstraint)result).getParentStruct();
                            RfNamedElement fieldOrVariable = parentStruct.semanticGetMember(this.rfp, result.getFullName().getDeterminant(), this.packageName, this.getStruct(), result.getName(), FIELD_VARIABLE, 31, this.maxModuleIndex, this.parserPath, result);
                            this.module.createVariableDependency(this.rfp, fieldOrVariable, result.getName());
                            if (fieldOrVariable == null) {
                                LineInfo lineInfo = this.getMacroSafeLine(id);
                                this.rfp.addSemanticError1(1, "UNDEFINED_VARIABLE: No field or local variable called ''{0}''", lineInfo.getOffset(), lineInfo.getOffset() + id.getText().length(), null, lineInfo.line, this.parserPath, id.getText());
                                break block15;
                            }
                            if (fieldOrVariable instanceof IllegalAccessError) {
                                LineInfo lineInfo = this.getMacroSafeLine(id);
                                this.rfp.addSemanticError2(1, "ILLEGAL_ACCESS: Cannot access {0} {1} ''{2}.{3}''", lineInfo.getOffset(), lineInfo.getOffset() + id.getText().length(), null, lineInfo.line, this.parserPath, ((IllegalAccessError)fieldOrVariable).getAccessModifierText(), ((IllegalAccessError)fieldOrVariable).getElementKindText(), ((IllegalAccessError)fieldOrVariable).getParentName(), id.getText());
                                ((RfFieldTypeConstraint)result).setFieldOrVariable(fieldOrVariable);
                                break block15;
                            }
                            ((RfFieldTypeConstraint)result).setFieldOrVariable(fieldOrVariable);
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void property_type_constraint_expr(AST _t) throws RecognitionException {
        block15: {
            Runnable finalRunnable;
            block14: {
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                AST tc = null;
                RfNamedElement result = null;
                try {
                    try {
                        AST __t452 = _t;
                        tc = _t == ASTNULL ? null : _t;
                        this.match(_t, 417);
                        _t = _t.getFirstChild();
                        this.expr(_t, null);
                        _t = this._retTree;
                        result = this.expr(_t, null);
                        _t = this._retTree;
                        _t = __t452;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block14;
                        try {
                            RfFieldPropConstraint fieldPropConst;
                            if (tc != null && (fieldPropConst = this.getTransientResult(RfFieldPropConstraint.class, tc)) != null && fieldPropConst instanceof RfFieldPropConstraint && this.valid(result) && result instanceof RfField) {
                                fieldPropConst.setField((RfField)result);
                            }
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void in_table_expr(AST _t) throws RecognitionException {
        block17: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            List<Object> scopes = null;
            try {
                try {
                    AST __t415 = _t;
                    this.match(_t, 189);
                    _t = _t.getFirstChild();
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 197: {
                            this.match(_t, 197);
                            _t = _t.getNextSibling();
                            break;
                        }
                        case 185: 
                        case 186: 
                        case 187: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    scopes = this.expr_list_ts(_t);
                    _t = this._retTree;
                    this.in_table_rows(_t, scopes);
                    _t = this._retTree;
                    _t = __t415;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void type_is_expr(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1294 = _t;
                    this.match(_t, 321);
                    _t = _t.getFirstChild();
                    this.identifier(_t);
                    _t = this._retTree;
                    this.type(_t);
                    _t = this._retTree;
                    _t = __t1294;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void type_list_dim_expr(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1292 = _t;
                    this.match(_t, 322);
                    _t = _t.getFirstChild();
                    this.type(_t);
                    _t = this._retTree;
                    _t = __t1292;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void type_bit_size_expr(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1290 = _t;
                    this.match(_t, 323);
                    _t = _t.getFirstChild();
                    this.type(_t);
                    _t = this._retTree;
                    _t = __t1290;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final RfNamedElement each_starting_from_expr(AST _t) throws RecognitionException {
        RfNamedElement result;
        block16: {
            Runnable finalRunnable;
            block15: {
                result = null;
                if (_t == ASTNULL) {
                    // empty if block
                }
                finalRunnable = null;
                try {
                    try {
                        AST __t448 = _t;
                        AST aST = _t == ASTNULL ? null : _t;
                        this.match(_t, 320);
                        _t = _t.getFirstChild();
                        result = this.type(_t);
                        _t = this._retTree;
                        this.expr(_t);
                        _t = this._retTree;
                        _t = __t448;
                        _t = _t.getNextSibling();
                        if (this.inputState.guessing() != 0) break block15;
                        try {
                            if (!(result instanceof IRfAssociatedType)) break block15;
                            RfType assocType = (RfType)((IRfAssociatedType)((Object)result)).getAssociatedBaseType();
                            Determinant assocDeterminant = ((IRfAssociatedType)((Object)result)).getAssociatedTypeDeterminant();
                            String assocListKey = ((IRfAssociatedType)((Object)result)).getAssociatedTypeListKey();
                            int assocListDepth = ((IRfAssociatedType)((Object)result)).getAssociatedTypeList();
                            if (assocType instanceof RfStruct) {
                                assocType = RfListType.listFromType(this.rfp, assocType, assocDeterminant, assocListKey, assocListDepth + 1);
                                result = new RfDummyField(this.rfp, (IRfNamedElement)assocType, assocDeterminant);
                                break block15;
                            }
                            if (assocType instanceof RfType) {
                                assocType = RfListType.listFromType(this.rfp, assocType);
                                result = new RfDummyField(this.rfp, (IRfNamedElement)assocType, null);
                                break block15;
                            }
                            result = ERROR_SCOPE;
                        }
                        catch (Exception ex) {
                            this.userExceptionHandler(ex);
                        }
                    }
                    catch (RecognitionException ex) {
                        if (this.inputState.guessing() == 0) {
                            this.reportError(ex);
                            if (_t != null) {
                                _t = _t.getNextSibling();
                            }
                        } else {
                            throw ex;
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    throw throwable;
                }
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return result;
    }

    public final void sdl_default_expr(AST _t) throws RecognitionException {
        block12: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t1298 = _t;
                    this.match(_t, 497);
                    _t = _t.getFirstChild();
                    this.expr(_t);
                    _t = this._retTree;
                    _t = __t1298;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final List<Object> expr_list_ts(AST _t) throws RecognitionException {
        List<Object> scopes;
        block31: {
            scopes = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            Object result = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 185: {
                            scopes = this.preproc_ifdef_expr_ts(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 186: {
                            scopes = this.preproc_ifndef_expr_ts(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 187: {
                            AST __t418 = _t;
                            this.match(_t, 187);
                            _t = _t.getFirstChild();
                            if (this.inputState.guessing() == 0) {
                                try {
                                    scopes = new ArrayList<Object>();
                                }
                                catch (Exception ex) {
                                    this.userExceptionHandler(ex);
                                }
                            }
                            block19: while (true) {
                                if (_t == null) {
                                    _t = ASTNULL;
                                }
                                switch (_t.getType()) {
                                    case 183: 
                                    case 184: 
                                    case 188: 
                                    case 189: 
                                    case 191: 
                                    case 192: 
                                    case 193: 
                                    case 194: 
                                    case 195: 
                                    case 196: 
                                    case 197: 
                                    case 198: 
                                    case 199: 
                                    case 200: 
                                    case 201: 
                                    case 202: 
                                    case 203: 
                                    case 204: 
                                    case 205: 
                                    case 206: 
                                    case 207: 
                                    case 208: 
                                    case 209: 
                                    case 210: 
                                    case 211: 
                                    case 212: 
                                    case 213: 
                                    case 214: 
                                    case 215: 
                                    case 216: 
                                    case 217: 
                                    case 218: 
                                    case 219: 
                                    case 220: 
                                    case 221: 
                                    case 222: 
                                    case 223: 
                                    case 224: 
                                    case 225: 
                                    case 226: 
                                    case 227: 
                                    case 228: 
                                    case 229: 
                                    case 230: 
                                    case 231: 
                                    case 232: 
                                    case 233: 
                                    case 234: 
                                    case 235: 
                                    case 236: 
                                    case 237: 
                                    case 238: 
                                    case 239: 
                                    case 240: 
                                    case 241: 
                                    case 242: 
                                    case 243: 
                                    case 244: 
                                    case 245: 
                                    case 246: 
                                    case 251: 
                                    case 252: 
                                    case 256: 
                                    case 259: 
                                    case 260: 
                                    case 261: 
                                    case 262: 
                                    case 263: 
                                    case 264: 
                                    case 265: 
                                    case 266: 
                                    case 267: 
                                    case 268: 
                                    case 269: 
                                    case 277: 
                                    case 278: 
                                    case 279: 
                                    case 280: 
                                    case 281: 
                                    case 282: 
                                    case 283: 
                                    case 284: 
                                    case 285: 
                                    case 286: 
                                    case 287: 
                                    case 288: 
                                    case 292: 
                                    case 293: 
                                    case 294: 
                                    case 295: 
                                    case 296: 
                                    case 297: 
                                    case 298: 
                                    case 299: 
                                    case 300: 
                                    case 301: 
                                    case 302: 
                                    case 303: 
                                    case 304: 
                                    case 305: 
                                    case 306: 
                                    case 307: 
                                    case 308: 
                                    case 309: 
                                    case 310: 
                                    case 311: 
                                    case 312: 
                                    case 313: 
                                    case 314: 
                                    case 315: 
                                    case 316: 
                                    case 317: 
                                    case 318: 
                                    case 319: 
                                    case 320: 
                                    case 321: 
                                    case 322: 
                                    case 323: 
                                    case 369: 
                                    case 411: 
                                    case 416: 
                                    case 417: 
                                    case 464: 
                                    case 497: 
                                    case 506: 
                                    case 507: {
                                        result = this.expr(_t, null);
                                        _t = this._retTree;
                                        if (this.inputState.guessing() != 0) continue block19;
                                        try {
                                            if (scopes == null) continue block19;
                                            scopes.add(result);
                                        }
                                        catch (Exception ex) {
                                            this.userExceptionHandler(ex);
                                        }
                                        continue block19;
                                    }
                                    case 185: 
                                    case 186: 
                                    case 187: {
                                        result = this.expr_list_ts(_t);
                                        _t = this._retTree;
                                        if (this.inputState.guessing() != 0) continue block19;
                                        try {
                                            if (scopes == null) continue block19;
                                            scopes.add(result);
                                        }
                                        catch (Exception ex) {
                                            this.userExceptionHandler(ex);
                                        }
                                        continue block19;
                                    }
                                }
                                break;
                            }
                            _t = __t418;
                            _t = _t.getNextSibling();
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block31;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return scopes;
    }

    public final void in_table_rows(AST _t, List<Object> scopes) throws RecognitionException {
        block18: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t433 = _t;
                    this.match(_t, 190);
                    _t = _t.getFirstChild();
                    block8: while (true) {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 185: 
                            case 186: 
                            case 187: {
                                this.expr_list_tr(_t, scopes);
                                _t = this._retTree;
                                continue block8;
                            }
                            case 400: {
                                this.user_defined_table_rows(_t, scopes);
                                _t = this._retTree;
                                continue block8;
                            }
                        }
                        break;
                    }
                    _t = __t433;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final List<Object> preproc_ifdef_expr_ts(AST _t) throws RecognitionException {
        List<Object> scopes;
        block17: {
            scopes = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t422 = _t;
                    this.match(_t, 185);
                    _t = _t.getFirstChild();
                    this.preproc_id(_t);
                    _t = this._retTree;
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 185: 
                        case 186: 
                        case 187: 
                        case 366: {
                            scopes = this.preproc_expr_block_ts(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t422;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return scopes;
    }

    public final List<Object> preproc_ifndef_expr_ts(AST _t) throws RecognitionException {
        List<Object> scopes;
        block17: {
            scopes = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t425 = _t;
                    this.match(_t, 186);
                    _t = _t.getFirstChild();
                    this.preproc_id(_t);
                    _t = this._retTree;
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 185: 
                        case 186: 
                        case 187: 
                        case 366: {
                            scopes = this.preproc_expr_block_ts(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t425;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return scopes;
    }

    public final List<Object> preproc_expr_block_ts(AST _t) throws RecognitionException {
        List<Object> scopes;
        block17: {
            scopes = null;
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 185: 
                        case 186: 
                        case 187: {
                            scopes = this.expr_list_ts(_t);
                            _t = this._retTree;
                            break;
                        }
                        case 366: {
                            this.match(_t, 366);
                            _t = _t.getNextSibling();
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
        return scopes;
    }

    public final void user_defined_table_rows(AST _t, List<Object> scopes) throws RecognitionException {
        block18: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t429 = _t;
                    this.match(_t, 400);
                    _t = _t.getFirstChild();
                    this.define_name(_t);
                    _t = this._retTree;
                    this.replacement_term_list(_t);
                    _t = this._retTree;
                    block8: while (true) {
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        switch (_t.getType()) {
                            case 185: 
                            case 186: 
                            case 187: {
                                this.expr_list_tr(_t, scopes);
                                _t = this._retTree;
                                continue block8;
                            }
                            case 400: {
                                this.user_defined_table_rows(_t, scopes);
                                _t = this._retTree;
                                continue block8;
                            }
                        }
                        break;
                    }
                    _t = __t429;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void expr_list_tr(AST _t, List<Object> scopes) throws RecognitionException {
        block34: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            int index = 0;
            RfNamedElement lhScope = null;
            List lhScopes = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 185: {
                            this.preproc_ifdef_expr_tr(_t, scopes);
                            _t = this._retTree;
                            break;
                        }
                        case 186: {
                            this.preproc_ifndef_expr_tr(_t, scopes);
                            _t = this._retTree;
                            break;
                        }
                        case 187: {
                            AST __t437 = _t;
                            this.match(_t, 187);
                            _t = _t.getFirstChild();
                            block17: while (true) {
                                if (_t == null) {
                                    _t = ASTNULL;
                                }
                                switch (_t.getType()) {
                                    case 183: 
                                    case 184: 
                                    case 188: 
                                    case 189: 
                                    case 191: 
                                    case 192: 
                                    case 193: 
                                    case 194: 
                                    case 195: 
                                    case 196: 
                                    case 197: 
                                    case 198: 
                                    case 199: 
                                    case 200: 
                                    case 201: 
                                    case 202: 
                                    case 203: 
                                    case 204: 
                                    case 205: 
                                    case 206: 
                                    case 207: 
                                    case 208: 
                                    case 209: 
                                    case 210: 
                                    case 211: 
                                    case 212: 
                                    case 213: 
                                    case 214: 
                                    case 215: 
                                    case 216: 
                                    case 217: 
                                    case 218: 
                                    case 219: 
                                    case 220: 
                                    case 221: 
                                    case 222: 
                                    case 223: 
                                    case 224: 
                                    case 225: 
                                    case 226: 
                                    case 227: 
                                    case 228: 
                                    case 229: 
                                    case 230: 
                                    case 231: 
                                    case 232: 
                                    case 233: 
                                    case 234: 
                                    case 235: 
                                    case 236: 
                                    case 237: 
                                    case 238: 
                                    case 239: 
                                    case 240: 
                                    case 241: 
                                    case 242: 
                                    case 243: 
                                    case 244: 
                                    case 245: 
                                    case 246: 
                                    case 251: 
                                    case 252: 
                                    case 256: 
                                    case 259: 
                                    case 260: 
                                    case 261: 
                                    case 262: 
                                    case 263: 
                                    case 264: 
                                    case 265: 
                                    case 266: 
                                    case 267: 
                                    case 268: 
                                    case 269: 
                                    case 277: 
                                    case 278: 
                                    case 279: 
                                    case 280: 
                                    case 281: 
                                    case 282: 
                                    case 283: 
                                    case 284: 
                                    case 285: 
                                    case 286: 
                                    case 287: 
                                    case 288: 
                                    case 292: 
                                    case 293: 
                                    case 294: 
                                    case 295: 
                                    case 296: 
                                    case 297: 
                                    case 298: 
                                    case 299: 
                                    case 300: 
                                    case 301: 
                                    case 302: 
                                    case 303: 
                                    case 304: 
                                    case 305: 
                                    case 306: 
                                    case 307: 
                                    case 308: 
                                    case 309: 
                                    case 310: 
                                    case 311: 
                                    case 312: 
                                    case 313: 
                                    case 314: 
                                    case 315: 
                                    case 316: 
                                    case 317: 
                                    case 318: 
                                    case 319: 
                                    case 320: 
                                    case 321: 
                                    case 322: 
                                    case 323: 
                                    case 369: 
                                    case 411: 
                                    case 416: 
                                    case 417: 
                                    case 464: 
                                    case 497: 
                                    case 506: 
                                    case 507: {
                                        Object scope;
                                        if (this.inputState.guessing() == 0) {
                                            try {
                                                scope = null;
                                                if (scopes != null && scopes.size() > index) {
                                                    scope = scopes.get(index);
                                                }
                                                if (scope instanceof RfNamedElement) {
                                                    lhScope = (RfNamedElement)scope;
                                                }
                                                ++index;
                                            }
                                            catch (Exception ex) {
                                                this.userExceptionHandler(ex);
                                            }
                                        }
                                        this.expr(_t, lhScope);
                                        _t = this._retTree;
                                        continue block17;
                                    }
                                    case 185: 
                                    case 186: 
                                    case 187: {
                                        Object scope;
                                        if (this.inputState.guessing() == 0) {
                                            try {
                                                scope = null;
                                                if (scopes != null && scopes.size() > index) {
                                                    scope = scopes.get(index);
                                                }
                                                if (scope instanceof List) {
                                                    lhScopes = (List)scope;
                                                }
                                                ++index;
                                            }
                                            catch (Exception ex) {
                                                this.userExceptionHandler(ex);
                                            }
                                        }
                                        this.expr_list_tr(_t, lhScopes);
                                        _t = this._retTree;
                                        continue block17;
                                    }
                                }
                                break;
                            }
                            _t = __t437;
                            _t = _t.getNextSibling();
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block34;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void preproc_ifdef_expr_tr(AST _t, List<Object> scopes) throws RecognitionException {
        block17: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t441 = _t;
                    this.match(_t, 185);
                    _t = _t.getFirstChild();
                    this.preproc_id(_t);
                    _t = this._retTree;
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 185: 
                        case 186: 
                        case 187: 
                        case 366: {
                            this.preproc_expr_block_tr(_t, scopes);
                            _t = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t441;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void preproc_ifndef_expr_tr(AST _t, List<Object> scopes) throws RecognitionException {
        block17: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    AST __t444 = _t;
                    this.match(_t, 186);
                    _t = _t.getFirstChild();
                    this.preproc_id(_t);
                    _t = this._retTree;
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 185: 
                        case 186: 
                        case 187: 
                        case 366: {
                            this.preproc_expr_block_tr(_t, scopes);
                            _t = this._retTree;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                    _t = __t444;
                    _t = _t.getNextSibling();
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final void preproc_expr_block_tr(AST _t, List<Object> scopes) throws RecognitionException {
        block17: {
            if (_t == ASTNULL) {
                // empty if block
            }
            Runnable finalRunnable = null;
            try {
                try {
                    if (_t == null) {
                        _t = ASTNULL;
                    }
                    switch (_t.getType()) {
                        case 185: 
                        case 186: 
                        case 187: {
                            this.expr_list_tr(_t, scopes);
                            _t = this._retTree;
                            break;
                        }
                        case 366: {
                            this.match(_t, 366);
                            _t = _t.getNextSibling();
                            break;
                        }
                        default: {
                            throw this.getNoViableAltException(_t);
                        }
                    }
                }
                catch (RecognitionException ex) {
                    if (this.inputState.guessing() == 0) {
                        this.reportError(ex);
                        if (_t != null) {
                            _t = _t.getNextSibling();
                        }
                    } else {
                        throw ex;
                    }
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (finalRunnable != null) {
                    finalRunnable.run();
                }
                throw throwable;
            }
            if (finalRunnable != null) {
                finalRunnable.run();
            }
        }
        this._retTree = _t;
    }

    public final RfNamedElement method_access_expr(AST _t, RfNamedElement lhScope) throws RecognitionException {
        RfNamedElement result;
        block24: {
            result = null;
            