/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.util;

import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.AbstractRfManager;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfCoverLayer;
import ro.amiq.edt.base.model.reflection.RfKind;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStructLayer;

public class RfEnclosingScopeUtils {
    private static String getText(Object element) {
        String result = null;
        try {
            if (element instanceof RfStructLayer) {
                RfStructLayer layer = (RfStructLayer)element;
                result = layer.getInfo();
            } else if (element instanceof RfCoverLayer) {
                RfCoverLayer layer = (RfCoverLayer)element;
                result = layer.getInfo();
            } else if (element instanceof RfMethodLayer) {
                RfMethodLayer layer = (RfMethodLayer)element;
                result = layer.getMethod().isTCM() ? DVTStringUtil.appendString((Object[])new Object[]{layer.getStructLayer().getInfo(), ".", layer.getName(), "()@"}) : DVTStringUtil.appendString((Object[])new Object[]{layer.getStructLayer().getInfo(), ".", layer.getName(), "()"});
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    public static String getScopeInfo(AbstractRfManager rfManager, IProject project, ParserPath parserPath, int line, int offset) {
        if (project == null) {
            return null;
        }
        RfProject rfProject = rfManager.getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        RfModule module = rfProject.getModule(parserPath);
        if (module == null) {
            return null;
        }
        IRfScope scope = module.getMethodOrCoverOrStructScope(line, offset);
        if (scope == null) {
            return null;
        }
        String text = RfEnclosingScopeUtils.getText(scope);
        if (text == null) {
            return null;
        }
        String kindName = null;
        if (scope instanceof RfCoverLayer) {
            kindName = "covergroup";
        } else if (scope instanceof IRfNamedElement) {
            kindName = ((IRfNamedElement)scope).getKindName();
        } else if (scope instanceof IRfDefElement && ((IRfDefElement)scope).getNamedElement() != null) {
            kindName = ((IRfDefElement)scope).getNamedElement().getKindName();
        }
        if (kindName != null && !kindName.isEmpty()) {
            text = String.valueOf(RfEnclosingScopeUtils.beautify(kindName)) + ": " + text;
        }
        return " [" + text + "]";
    }

    private static String beautify(String kindName) {
        if (kindName == null) {
            return "";
        }
        if (RfKind.TCM.getName().equals(kindName)) {
            return "method";
        }
        return kindName;
    }
}

