/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.AbstractRfManager;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfKind;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfTableDefine;
import ro.amiq.edt.base.model.reflection.RfTemplateStructInstance;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.semantic.RfStructQualifier;
import ro.amiq.edt.base.model.reflection.semantic.RfSubtypeElement;
import ro.amiq.edt.base.model.reflection.util.NullProtectedList;
import ro.amiq.edt.base.model.reflection.util.RfUtilsCommon;
import ro.amiq.edt.base.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.edt.base.r2lparser.R2LMethodPortElement;
import ro.amiq.edt.base.ui.editor.EWordFinder;
import ro.amiq.edt.base.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public class RfUtils
extends RfUtilsCommon {
    public static String getAssociatedTypeHyperlinkLabelPart(IRfNamedElement namedElement) {
        RfKind kind = RfKind.of(namedElement);
        switch (kind) {
            case METHOD: 
            case ON_EVENT_METHOD: 
            case TCM: {
                return "Return";
            }
            case PORT_SIMPLE_IN: 
            case PORT_SIMPLE_OUT: 
            case PORT_SIMPLE_INOUT: 
            case PORT_EVENT_IN: 
            case PORT_EVENT_OUT: 
            case PORT_EVENT_INOUT: 
            case PORT_BUFFER_IN: 
            case PORT_BUFFER_OUT: 
            case PORT_METHOD_IN: 
            case PORT_METHOD_OUT: 
            case PORT_INTERFACE_IN: 
            case PORT_INTERFACE_OUT: {
                return "Port";
            }
            case SCALAR_TYPE: {
                return "Scalar";
            }
            case METHOD_TYPE: {
                return "Method";
            }
            case UNKNOWN: {
                return "";
            }
        }
        return DVTStringUtil.toTitleCase((String)kind.getName());
    }

    public static List<RfNamedElementActionHyperlink> getRfNamedElementActionHyperlink(IEPluginConfig pluginConfig, ITextEditor editor, IProject project, IDocument document, int offset, boolean allowMultiple, boolean firstImplementation) {
        try {
            boolean isDeclaration;
            RfUtilsCommon.MacroRegion macroRegion;
            NullProtectedList<RfNamedElementActionHyperlink> hyperlinks = new NullProtectedList<RfNamedElementActionHyperlink>();
            RfProject rfProject = pluginConfig.getRfManager().getRfProject(project);
            if (rfProject == null) {
                return hyperlinks;
            }
            IRegion wordAtOffset = EWordFinder.getDefault().getWordAtOffset(document, offset);
            RfWNamedElementAndScope elementAndScope = RfUtils.internalGetRfElement(rfProject, editor, document, offset, allowMultiple, false, false);
            if (elementAndScope != null && elementAndScope.getNamedElement() != null) {
                RfField field;
                RfStruct struct;
                RfMethod method;
                allowMultiple &= elementAndScope.isAllowMultipleHyperlinks();
                RfNamedElement element = elementAndScope.getNamedElement();
                if (element instanceof RfSubtypeElement) {
                    RfStruct struct2 = ((RfSubtypeElement)element).getStruct();
                    RfNamedElement candidate = ((RfSubtypeElement)element).getNamedElement();
                    if (!allowMultiple) {
                        hyperlinks.add(RfUtils.createOpenAction(pluginConfig, firstImplementation, candidate, elementAndScope.getScope(), project, wordAtOffset, false));
                        return hyperlinks;
                    }
                    Determinant determinant = ((RfSubtypeElement)element).getSubtypeDeterminant();
                    List<RfDefElement> layers = struct2.getLayers();
                    if (layers == null) {
                        hyperlinks.add(RfUtils.createOpenAction(pluginConfig, firstImplementation, candidate, elementAndScope.getScope(), project, wordAtOffset, false));
                        return hyperlinks;
                    }
                    if (determinant != null && determinant.toArray() != null && determinant.toArray().length > 1) {
                        for (RfDefElement layer : layers) {
                            RfStructLayer structLayer;
                            if (!(layer instanceof RfStructLayer) || !(structLayer = (RfStructLayer)layer).getDeterminant().equals(determinant)) continue;
                            RfNamedElementActionHyperlink createOpenAction = RfUtils.createOpenAction(pluginConfig, firstImplementation, candidate, elementAndScope.getScope(), project, wordAtOffset, false);
                            if (createOpenAction != null) {
                                createOpenAction.setMeta("ASSOC_TYPE_OF", determinant);
                            }
                            hyperlinks.add(createOpenAction);
                            RfNamedElementActionHyperlink createWhenSubtypeOpenAction = RfUtils.createOpenAction(pluginConfig, (RfDefElement)structLayer, elementAndScope.getScope(), project, wordAtOffset, true);
                            if (createWhenSubtypeOpenAction != null) {
                                createWhenSubtypeOpenAction.setMeta("ASSOC_TYPE_OF", determinant);
                            }
                            hyperlinks.add(createWhenSubtypeOpenAction);
                            return hyperlinks;
                        }
                    }
                    hyperlinks.add(RfUtils.createOpenAction(pluginConfig, firstImplementation, candidate, elementAndScope.getScope(), project, wordAtOffset, false));
                    return hyperlinks;
                }
                if (element instanceof RfStructQualifier) {
                    RfEnum enumElement = ((RfStructQualifier)element).getEnum();
                    RfField fieldElement = ((RfStructQualifier)element).getElement();
                    if (enumElement != null) {
                        hyperlinks.add(RfUtils.createOpenAction(pluginConfig, firstImplementation, (RfNamedElement)enumElement, elementAndScope.getScope(), project, wordAtOffset, false));
                    }
                    if (allowMultiple && fieldElement != null) {
                        hyperlinks.add(RfUtils.createOpenAction(pluginConfig, firstImplementation, (RfNamedElement)fieldElement, elementAndScope.getScope(), project, wordAtOffset, true));
                    }
                    return hyperlinks;
                }
                if (element instanceof RfTemplateStructInstance) {
                    element = ((RfTemplateStructInstance)element).getTemplateStruct();
                    hyperlinks.add(RfUtils.createOpenAction(pluginConfig, firstImplementation, element, elementAndScope.getScope(), project, wordAtOffset, false));
                    return hyperlinks;
                }
                if (element instanceof R2LMethodPortElement) {
                    hyperlinks.add(RfUtils.createOpenAction(pluginConfig, element.getDeclaration(true), elementAndScope.getScope(), project, wordAtOffset, false));
                    return hyperlinks;
                }
                if (element instanceof RfField && element.getName().equals("sys") && element.getRfProject() != null) {
                    elementAndScope.setNamedElement(element.getRfProject().getType("main", true, 1, "sys", -1));
                }
                if (!firstImplementation && element instanceof RfMethod) {
                    method = (RfMethod)element;
                    struct = method.getParentStruct();
                    if (struct != null) {
                        String methodName = method.getName();
                        if (method.isByEvent()) {
                            FullName candidateName = new FullName(methodName.substring(3), method.getDeterminant());
                            RfEvent event = struct.getEvent(candidateName);
                            if (event != null) {
                                hyperlinks.add(RfUtils.createOpenAction(pluginConfig, firstImplementation, (RfNamedElement)event, elementAndScope.getScope(), project, wordAtOffset, false));
                            }
                        } else {
                            RfField field2 = struct.getField(methodName);
                            if (!RfUtils.isMethodPortField(field2)) {
                                hyperlinks.add(RfUtils.createOpenAction(pluginConfig, firstImplementation, elementAndScope.getNamedElement(), elementAndScope.getScope(), project, wordAtOffset, false));
                            }
                        }
                    }
                } else {
                    RfNamedElementActionHyperlink createOpenAction = RfUtils.createOpenAction(pluginConfig, firstImplementation, elementAndScope.getNamedElement(), elementAndScope.getScope(), project, wordAtOffset, false);
                    RfNamedElement namedElement = elementAndScope.getNamedElement();
                    if (namedElement instanceof IRfScope) {
                        Determinant determinant = ((IRfScope)((Object)namedElement)).getDeterminant();
                        if (createOpenAction != null) {
                            createOpenAction.setMeta("ASSOC_TYPE_OF", determinant);
                        }
                    }
                    hyperlinks.add(createOpenAction);
                }
                if (!firstImplementation && element instanceof RfField) {
                    RfMethod method2;
                    RfField field3 = (RfField)element;
                    if (RfUtils.isMethodPortField(field3) && (struct = field3.getParentStruct()) != null && (method2 = struct.getMethod(field3.getName())) != null) {
                        RfNamedElementActionHyperlink action = RfUtils.createOpenAction(pluginConfig, method2, project, wordAtOffset);
                        action.setHasImplementationLabel(true);
                        hyperlinks.add(action);
                    }
                    hyperlinks.addAll(RfUtils.getBoundHyperlinks(pluginConfig, field3, project, wordAtOffset));
                }
                if (!firstImplementation && element instanceof RfMethod && (struct = (method = (RfMethod)element).getParentStruct()) != null && RfUtils.isMethodPortField(field = struct.getField(method.getName()))) {
                    hyperlinks.add(RfUtils.createOpenAction(pluginConfig, field, project, wordAtOffset));
                    hyperlinks.addAll(RfUtils.getBoundHyperlinks(pluginConfig, field, project, wordAtOffset));
                }
                if (!firstImplementation && element instanceof RfVar) {
                    hyperlinks.addAll(RfUtils.getBoundHyperlinks(pluginConfig, element, project, wordAtOffset));
                }
            }
            if ((macroRegion = RfUtils.getMacro(rfProject, editor, document, offset)) == null || macroRegion.macro == null) {
                return hyperlinks;
            }
            if ("__etools__table'__etools__expansion".equals(macroRegion.macro.getName())) {
                RfTableDefine tableDefine = rfProject.getTableDefine(document.get(wordAtOffset.getOffset(), wordAtOffset.getLength()));
                if (tableDefine != null) {
                    hyperlinks.add(RfUtils.createOpenAction(pluginConfig, tableDefine, project, wordAtOffset));
                }
                return hyperlinks;
            }
            boolean bl = isDeclaration = macroRegion.getMacroLayer() != null && macroRegion.getMacroLayer().isDeclaration();
            if (isDeclaration) {
                return hyperlinks;
            }
            if (macroRegion.getMacro() != null && !macroRegion.getMacro().isPredefined()) {
                Set<RfNamedElement> guessedElementsUnderCursor = macroRegion.getGuessedElementsUnderCursor();
                if (guessedElementsUnderCursor != null && !guessedElementsUnderCursor.isEmpty()) {
                    for (RfNamedElement namedElement : guessedElementsUnderCursor) {
                        hyperlinks.add(RfUtils.createOpenAction(pluginConfig, namedElement, project, wordAtOffset));
                    }
                }
                hyperlinks.add(RfUtils.createOpenAction(pluginConfig, macroRegion.getMacro(), project, macroRegion.getRegion()));
                return hyperlinks;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return Collections.emptyList();
    }

    private static List<RfNamedElementActionHyperlink> getBoundHyperlinks(IEPluginConfig pluginConfig, RfNamedElement element, IProject project, IRegion wordAtOffset) {
        NullProtectedList<RfNamedElementActionHyperlink> result = new NullProtectedList<RfNamedElementActionHyperlink>();
        HashSet<RfNamedElement> collectedBinds = new HashSet<RfNamedElement>();
        RfProject rfProject = pluginConfig.getRfManager().getRfProject(project);
        if (rfProject == null) {
            return result;
        }
        for (RfModule module : rfProject.getAllModules()) {
            module.collectBindsForPort(element, collectedBinds);
        }
        RfNamedElement[] sortedBinds = collectedBinds.toArray(new RfNamedElement[0]);
        Arrays.sort(sortedBinds, (e1, e2) -> {
            String n1 = e1.getName();
            String n2 = e2.getName();
            if (n1 == null) {
                return -1;
            }
            if (n2 == null) {
                return 1;
            }
            return n1.compareTo(n2);
        });
        RfNamedElement[] rfNamedElementArray = sortedBinds;
        int n = sortedBinds.length;
        int n2 = 0;
        while (n2 < n) {
            RfNamedElement boundElem = rfNamedElementArray[n2];
            result.add(RfUtils.createOpenAction(pluginConfig, false, boundElem, project, wordAtOffset, true, false));
            ++n2;
        }
        return result;
    }

    public static RfWNamedElementAndScope getRfElement(RfProject rfProject, ITextEditor textEditor, IDocument document, int offset, boolean allowWrappers) {
        IFile file;
        block9: {
            IEditorInput editorInput;
            block8: {
                block7: {
                    block6: {
                        try {
                            if (textEditor != null) break block6;
                            return null;
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            return null;
                        }
                    }
                    if (document != null) break block7;
                    return null;
                }
                editorInput = textEditor.getEditorInput();
                if (editorInput != null) break block8;
                return null;
            }
            file = (IFile)editorInput.getAdapter(IFile.class);
            if (file != null) break block9;
            return null;
        }
        return RfUtils.getRfElement(rfProject, file, document, offset, allowWrappers);
    }

    public static RfWNamedElementAndScope getNamedElementAndScope(RfProject rfProject, IFile file, IDocument document, int offset) {
        return RfUtils.internalGetRfElement(rfProject, file, document, offset, false, false, true);
    }

    public static RfWNamedElementAndScope getRfElementForSearch(RfProject rfProject, ITextEditor textEditor, IDocument document, int offset, RfNamedElement hint) {
        IFile file;
        block9: {
            IEditorInput editorInput;
            block8: {
                block7: {
                    block6: {
                        try {
                            if (textEditor != null) break block6;
                            return null;
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            return null;
                        }
                    }
                    if (document != null) break block7;
                    return null;
                }
                editorInput = textEditor.getEditorInput();
                if (editorInput != null) break block8;
                return null;
            }
            file = (IFile)editorInput.getAdapter(IFile.class);
            if (file != null) break block9;
            return null;
        }
        return RfUtils.getRfElementForSearch(rfProject, file, document, offset, hint);
    }

    public static IRfScopeElement getRfScope(AbstractRfManager rfManager, ITextEditor textEditor, IDocument document, int offset, int line) {
        if (textEditor == null) {
            return null;
        }
        if (document == null) {
            return null;
        }
        IEditorInput editorInput = textEditor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        RfProject rfProject = rfManager.getRfProject(file.getProject());
        if (rfProject == null) {
            return null;
        }
        IRfFileDef rfModule = rfProject.getFile((IResource)file);
        if (!(rfModule instanceof RfModule)) {
            return null;
        }
        return rfModule.getScope(line, offset);
    }

    public static IFile getFile(ITextEditor textEditor) {
        if (textEditor == null) {
            return null;
        }
        IEditorInput editorInput = textEditor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        return (IFile)editorInput.getAdapter(IFile.class);
    }

    public static String wrapIntoBold(String text) {
        return "<b>" + DVTStringUtil.partiallyEscapeHTML((String)text) + "</b>";
    }
}

