/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.util;

import antlr.collections.AST;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.diagrams.wavedrom.WaveDromManager;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipContent;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.ASTUtils;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.IRfAssociatedType;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.ImportFilePath;
import ro.amiq.edt.base.model.reflection.RfActionBlockLayer;
import ro.amiq.edt.base.model.reflection.RfAssert;
import ro.amiq.edt.base.model.reflection.RfCheckThat;
import ro.amiq.edt.base.model.reflection.RfConstraintLayer;
import ro.amiq.edt.base.model.reflection.RfCoverLayer;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfFieldAlias;
import ro.amiq.edt.base.model.reflection.RfFieldLayer;
import ro.amiq.edt.base.model.reflection.RfFieldTypeConstraint;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfMacro;
import ro.amiq.edt.base.model.reflection.RfMacroLayer;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfPropConstraint;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfTableDefine;
import ro.amiq.edt.base.model.reflection.RfTemplateStruct;
import ro.amiq.edt.base.model.reflection.RfTemplateStructInstance;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedModule;
import ro.amiq.edt.base.model.reflection.semantic.RfDummyField;
import ro.amiq.edt.base.model.reflection.semantic.RfStructQualifier;
import ro.amiq.edt.base.model.reflection.semantic.RfSubtypeElement;
import ro.amiq.edt.base.model.reflection.semantic.RfUndefVariable;
import ro.amiq.edt.base.model.reflection.semantic.SemanticUtils;
import ro.amiq.edt.base.model.reflection.util.NullProtectedList;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.edt.base.r2lparser.R2LMethodPortElement;
import ro.amiq.edt.base.r2lparser.R2LTooltipManager;
import ro.amiq.edt.base.ui.editor.EWordFinder;
import ro.amiq.edt.base.ui.editor.hyperlink.RfNamedElementActionHyperlink;
import ro.amiq.edt.base.ui.search.RfSearchQueryElement;
import ro.amiq.edt.base.utils.EDTFileUtils;

public abstract class RfUtilsCommon {
    public static final String ASSOC_TYPE_OF = "ASSOC_TYPE_OF";
    public static final Pattern HTML_TAGS_PATTERN = Pattern.compile("</?([iIbB]|br|BR)>");
    protected static RfElementCache fRfElementCache = new RfElementCache();

    public static RfWNamedElementAndScope internalGetRfElementForCallHierarchy(RfProject rfProject, IFile file, IDocument document, int offset) {
        return RfUtilsCommon.internalGetRfElementUsingR2L(rfProject, file, document, offset, true);
    }

    public static RfNamedElementActionHyperlink getAssociatedTypeHyperlink(IEPluginConfig pluginConfig, ITextEditor editor, IProject project, IDocument document, int offset, boolean allowMultiple, boolean firstImplementation) {
        RfNamedElementActionHyperlink assocTypeHyperlink;
        RfProject rfProject = pluginConfig.getRfManager().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        RfWNamedElementAndScope elementAndScope = RfUtilsCommon.getRfElement(rfProject, editor, document, offset, allowMultiple);
        if (elementAndScope == null || elementAndScope.getNamedElement() == null) {
            return null;
        }
        RfNamedElement element = elementAndScope.getNamedElement();
        if (element instanceof RfField && element.getName().equals("sys") && element.getRfProject() != null) {
            return null;
        }
        if (!(element instanceof IRfAssociatedType)) {
            return null;
        }
        IRfAssociatedType associatedType = (IRfAssociatedType)((Object)element);
        RfNamedElement associatedElement = (RfNamedElement)associatedType.getAssociatedType();
        if (associatedElement instanceof RfListType) {
            associatedElement = ((RfListType)associatedElement).getAssociatedType();
        }
        IRegion wordAtOffset = EWordFinder.getDefault().getWordAtOffset(document, offset);
        if (!(associatedElement instanceof RfStruct) || !allowMultiple) {
            return RfUtilsCommon.createOpenAction(pluginConfig, firstImplementation, associatedElement, elementAndScope.getScope(), project, wordAtOffset, false);
        }
        List<RfDefElement> layers = ((RfStruct)associatedElement).getLayers();
        if (layers == null) {
            return RfUtilsCommon.createOpenAction(pluginConfig, firstImplementation, associatedElement, elementAndScope.getScope(), project, wordAtOffset, false);
        }
        Determinant determinant = associatedType.getAssociatedTypeDeterminant();
        if (determinant != null && determinant.toArray().length > 1) {
            for (RfDefElement layer : layers) {
                RfStructLayer structLayer = (RfStructLayer)layer;
                if (!determinant.equals(structLayer.getDeterminant())) continue;
                RfNamedElementActionHyperlink assocTypeHyperlink2 = RfUtilsCommon.createOpenAction(pluginConfig, (RfDefElement)structLayer, elementAndScope.getScope(), project, wordAtOffset, false);
                if (assocTypeHyperlink2 != null) {
                    assocTypeHyperlink2.setMeta(ASSOC_TYPE_OF, determinant);
                }
                return assocTypeHyperlink2;
            }
        }
        if ((assocTypeHyperlink = RfUtilsCommon.createOpenAction(pluginConfig, firstImplementation, associatedElement, elementAndScope.getScope(), project, wordAtOffset, false)) != null) {
            assocTypeHyperlink.setMeta(ASSOC_TYPE_OF, determinant);
        }
        return assocTypeHyperlink;
    }

    public static List<RfNamedElementActionHyperlink> getRfNamedElementActionHyperlink(IEPluginConfig pluginConfig, ITextEditor editor, IProject project, IDocument document, int offset, boolean allowMultiple) {
        boolean firstImplementation = pluginConfig.getPlugin().getPreferenceStore().getBoolean("editor.jump_to_defined_method_layer");
        return RfUtilsCommon.getRfNamedElementActionHyperlink(pluginConfig, editor, project, document, offset, allowMultiple, firstImplementation);
    }

    public static List<RfNamedElementActionHyperlink> getRfNamedElementActionHyperlink(IEPluginConfig pluginConfig, ITextEditor editor, IProject project, IDocument document, int offset, boolean allowMultiple, boolean firstImplementation) {
        try {
            boolean isDeclaration;
            MacroRegion macroRegion;
            NullProtectedList<RfNamedElementActionHyperlink> hyperlinks = new NullProtectedList<RfNamedElementActionHyperlink>();
            RfProject rfProject = pluginConfig.getRfManager().getRfProject(project);
            if (rfProject == null) {
                return hyperlinks;
            }
            IRegion wordAtOffset = EWordFinder.getDefault().getWordAtOffset(document, offset);
            RfWNamedElementAndScope elementAndScope = RfUtilsCommon.internalGetRfElement(rfProject, editor, document, offset, allowMultiple, false, false);
            if (elementAndScope != null && elementAndScope.getNamedElement() != null) {
                RfField field;
                RfStruct struct;
                RfMethod method;
                allowMultiple &= elementAndScope.isAllowMultipleHyperlinks();
                RfNamedElement element = elementAndScope.getNamedElement();
                if (element instanceof RfSubtypeElement) {
                    RfStruct struct2 = ((RfSubtypeElement)element).getStruct();
                    RfNamedElement candidate = ((RfSubtypeElement)element).getNamedElement();
                    if (!allowMultiple) {
                        hyperlinks.add(RfUtilsCommon.createOpenAction(pluginConfig, firstImplementation, candidate, elementAndScope.getScope(), project, wordAtOffset, false));
                        return hyperlinks;
                    }
                    Determinant determinant = ((RfSubtypeElement)element).getSubtypeDeterminant();
                    List<RfDefElement> layers = struct2.getLayers();
                    if (layers == null) {
                        hyperlinks.add(RfUtilsCommon.createOpenAction(pluginConfig, firstImplementation, candidate, elementAndScope.getScope(), project, wordAtOffset, false));
                        return hyperlinks;
                    }
                    if (determinant != null && determinant.toArray() != null && determinant.toArray().length > 1) {
                        for (RfDefElement layer : layers) {
                            RfStructLayer structLayer;
                            if (!(layer instanceof RfStructLayer) || !(structLayer = (RfStructLayer)layer).getDeterminant().equals(determinant)) continue;
                            RfNamedElementActionHyperlink createOpenAction = RfUtilsCommon.createOpenAction(pluginConfig, firstImplementation, candidate, elementAndScope.getScope(), project, wordAtOffset, false);
                            if (createOpenAction != null) {
                                createOpenAction.setMeta(ASSOC_TYPE_OF, determinant);
                            }
                            hyperlinks.add(createOpenAction);
                            RfNamedElementActionHyperlink createWhenSubtypeOpenAction = RfUtilsCommon.createOpenAction(pluginConfig, (RfDefElement)structLayer, elementAndScope.getScope(), project, wordAtOffset, true);
                            if (createWhenSubtypeOpenAction != null) {
                                createWhenSubtypeOpenAction.setMeta(ASSOC_TYPE_OF, determinant);
                            }
                            hyperlinks.add(createWhenSubtypeOpenAction);
                            return hyperlinks;
                        }
                    }
                    hyperlinks.add(RfUtilsCommon.createOpenAction(pluginConfig, firstImplementation, candidate, elementAndScope.getScope(), project, wordAtOffset, false));
                    return hyperlinks;
                }
                if (element instanceof RfStructQualifier) {
                    RfEnum enumElement = ((RfStructQualifier)element).getEnum();
                    RfField fieldElement = ((RfStructQualifier)element).getElement();
                    if (enumElement != null) {
                        hyperlinks.add(RfUtilsCommon.createOpenAction(pluginConfig, firstImplementation, (RfNamedElement)enumElement, elementAndScope.getScope(), project, wordAtOffset, false));
                    }
                    if (allowMultiple && fieldElement != null) {
                        hyperlinks.add(RfUtilsCommon.createOpenAction(pluginConfig, firstImplementation, (RfNamedElement)fieldElement, elementAndScope.getScope(), project, wordAtOffset, true));
                    }
                    return hyperlinks;
                }
                if (element instanceof RfTemplateStructInstance) {
                    element = ((RfTemplateStructInstance)element).getTemplateStruct();
                    hyperlinks.add(RfUtilsCommon.createOpenAction(pluginConfig, firstImplementation, element, elementAndScope.getScope(), project, wordAtOffset, false));
                    return hyperlinks;
                }
                if (element instanceof R2LMethodPortElement) {
                    hyperlinks.add(RfUtilsCommon.createOpenAction(pluginConfig, element.getDeclaration(true), elementAndScope.getScope(), project, wordAtOffset, false));
                    return hyperlinks;
                }
                if (element instanceof RfField && element.getName().equals("sys") && element.getRfProject() != null) {
                    elementAndScope.setNamedElement(element.getRfProject().getType("main", true, 1, "sys", -1));
                }
                if (!firstImplementation && element instanceof RfMethod) {
                    method = (RfMethod)element;
                    struct = method.getParentStruct();
                    if (struct != null) {
                        String methodName = method.getName();
                        if (method.isByEvent()) {
                            FullName candidateName = new FullName(methodName.substring(3), method.getDeterminant());
                            RfEvent event = struct.getEvent(candidateName);
                            if (event != null) {
                                hyperlinks.add(RfUtilsCommon.createOpenAction(pluginConfig, firstImplementation, (RfNamedElement)event, elementAndScope.getScope(), project, wordAtOffset, false));
                            }
                        } else {
                            RfField field2 = struct.getField(methodName);
                            if (!RfUtilsCommon.isMethodPortField(field2)) {
                                hyperlinks.add(RfUtilsCommon.createOpenAction(pluginConfig, firstImplementation, elementAndScope.getNamedElement(), elementAndScope.getScope(), project, wordAtOffset, false));
                            }
                        }
                    }
                } else {
                    RfNamedElementActionHyperlink createOpenAction = RfUtilsCommon.createOpenAction(pluginConfig, firstImplementation, elementAndScope.getNamedElement(), elementAndScope.getScope(), project, wordAtOffset, false);
                    RfNamedElement namedElement = elementAndScope.getNamedElement();
                    if (namedElement instanceof IRfScope) {
                        Determinant determinant = ((IRfScope)((Object)namedElement)).getDeterminant();
                        if (createOpenAction != null) {
                            createOpenAction.setMeta(ASSOC_TYPE_OF, determinant);
                        }
                    }
                    hyperlinks.add(createOpenAction);
                }
                if (!firstImplementation && element instanceof RfField) {
                    RfMethod method2;
                    RfField field3 = (RfField)element;
                    if (RfUtilsCommon.isMethodPortField(field3) && (struct = field3.getParentStruct()) != null && (method2 = struct.getMethod(field3.getName())) != null) {
                        RfNamedElementActionHyperlink action = RfUtilsCommon.createOpenAction(pluginConfig, method2, project, wordAtOffset);
                        action.setHasImplementationLabel(true);
                        hyperlinks.add(action);
                    }
                    hyperlinks.addAll(RfUtilsCommon.getBoundHyperlinks(pluginConfig, field3, project, wordAtOffset));
                }
                if (!firstImplementation && element instanceof RfMethod && (struct = (method = (RfMethod)element).getParentStruct()) != null && RfUtilsCommon.isMethodPortField(field = struct.getField(method.getName()))) {
                    hyperlinks.add(RfUtilsCommon.createOpenAction(pluginConfig, field, project, wordAtOffset));
                    hyperlinks.addAll(RfUtilsCommon.getBoundHyperlinks(pluginConfig, field, project, wordAtOffset));
                }
                if (!firstImplementation && element instanceof RfVar) {
                    hyperlinks.addAll(RfUtilsCommon.getBoundHyperlinks(pluginConfig, element, project, wordAtOffset));
                }
            }
            if ((macroRegion = RfUtilsCommon.getMacro(rfProject, editor, document, offset)) == null || macroRegion.macro == null) {
                return hyperlinks;
            }
            if ("__etools__table'__etools__expansion".equals(macroRegion.macro.getName())) {
                RfTableDefine tableDefine = rfProject.getTableDefine(document.get(wordAtOffset.getOffset(), wordAtOffset.getLength()));
                if (tableDefine != null) {
                    hyperlinks.add(RfUtilsCommon.createOpenAction(pluginConfig, tableDefine, project, wordAtOffset));
                }
                return hyperlinks;
            }
            boolean bl = isDeclaration = macroRegion.getMacroLayer() != null && macroRegion.getMacroLayer().isDeclaration();
            if (isDeclaration) {
                return hyperlinks;
            }
            if (macroRegion.getMacro() != null && !macroRegion.getMacro().isPredefined()) {
                Set<RfNamedElement> guessedElementsUnderCursor = macroRegion.getGuessedElementsUnderCursor();
                if (guessedElementsUnderCursor != null && !guessedElementsUnderCursor.isEmpty()) {
                    for (RfNamedElement namedElement : guessedElementsUnderCursor) {
                        hyperlinks.add(RfUtilsCommon.createOpenAction(pluginConfig, namedElement, project, wordAtOffset));
                    }
                }
                hyperlinks.add(RfUtilsCommon.createOpenAction(pluginConfig, macroRegion.getMacro(), project, macroRegion.getRegion()));
                return hyperlinks;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return Collections.emptyList();
    }

    private static List<RfNamedElementActionHyperlink> getBoundHyperlinks(IEPluginConfig pluginConfig, RfNamedElement element, IProject project, IRegion wordAtOffset) {
        NullProtectedList<RfNamedElementActionHyperlink> result = new NullProtectedList<RfNamedElementActionHyperlink>();
        HashSet<RfNamedElement> collectedBinds = new HashSet<RfNamedElement>();
        RfProject rfProject = pluginConfig.getRfManager().getRfProject(project);
        if (rfProject == null) {
            return result;
        }
        for (RfModule module : rfProject.getAllModules()) {
            module.collectBindsForPort(element, collectedBinds);
        }
        RfNamedElement[] sortedBinds = collectedBinds.toArray(new RfNamedElement[0]);
        Arrays.sort(sortedBinds, (e1, e2) -> {
            String n1 = e1.getName();
            String n2 = e2.getName();
            if (n1 == null) {
                return -1;
            }
            if (n2 == null) {
                return 1;
            }
            return n1.compareTo(n2);
        });
        RfNamedElement[] rfNamedElementArray = sortedBinds;
        int n = sortedBinds.length;
        int n2 = 0;
        while (n2 < n) {
            RfNamedElement boundElem = rfNamedElementArray[n2];
            result.add(RfUtilsCommon.createOpenAction(pluginConfig, false, boundElem, project, wordAtOffset, true, false));
            ++n2;
        }
        return result;
    }

    protected static RfNamedElementActionHyperlink createOpenAction(IEPluginConfig pluginConfig, RfDefElement defElement, IRfScope scope, IProject project, IRegion region, boolean hasSubtypeLabel) {
        RfNamedElementActionHyperlink hyperlink = RfUtilsCommon.createOpenAction(pluginConfig, defElement, project, region, hasSubtypeLabel);
        if (hyperlink == null) {
            return null;
        }
        hyperlink.setScope(scope);
        return hyperlink;
    }

    protected static RfNamedElementActionHyperlink createOpenAction(IEPluginConfig pluginConfig, boolean firstImplementation, RfNamedElement namedElement, IRfScope scope, IProject project, IRegion region, boolean hasDeterminantLabel) {
        if (region.getLength() == 0) {
            return null;
        }
        RfNamedElementActionHyperlink hyperlink = RfUtilsCommon.createOpenAction(pluginConfig, firstImplementation, namedElement, project, region, false, hasDeterminantLabel);
        if (hyperlink == null) {
            return null;
        }
        hyperlink.setScope(scope);
        return hyperlink;
    }

    public static RfNamedElementActionHyperlink createOpenAction(IEPluginConfig pluginConfig, RfNamedElement namedElement, IProject project, IRegion region) {
        boolean firstImplementation = pluginConfig.getPlugin().getPreferenceStore().getBoolean("editor.jump_to_defined_method_layer");
        return RfUtilsCommon.createOpenAction(pluginConfig, firstImplementation, namedElement, project, region, false, false);
    }

    public static RfNamedElementActionHyperlink createOpenAction(IEPluginConfig pluginConfig, RfNamedElement namedElement, IProject project, IRegion region, String hyperlinkText) {
        boolean firstImplementation = pluginConfig.getPlugin().getPreferenceStore().getBoolean("editor.jump_to_defined_method_layer");
        return RfUtilsCommon.createOpenAction(pluginConfig, firstImplementation, namedElement, project, region, false, false, hyperlinkText);
    }

    public static RfNamedElementActionHyperlink createOpenActionToImportDirective(IEPluginConfig pluginConfig, RfNamedElement namedElement, IProject project, IRegion region, ImportFilePath importedFile) {
        return RfUtilsCommon.createOpenAction(pluginConfig, namedElement, project, region, importedFile, false, false);
    }

    public static RfNamedElementActionHyperlink createOpenAction(IEPluginConfig pluginConfig, boolean firstImplementation, RfNamedElement namedElement, IProject project, IRegion region, boolean hasBindLabel, boolean hasDeterminantLabel) {
        return RfUtilsCommon.createOpenAction(pluginConfig, firstImplementation, namedElement, project, region, hasBindLabel, hasDeterminantLabel, null);
    }

    public static RfNamedElementActionHyperlink createOpenAction(IEPluginConfig pluginConfig, boolean firstImplementation, RfNamedElement namedElement, IProject project, IRegion region, boolean hasBindLabel, boolean hasDeterminantLabel, String hyperlinkText) {
        if (!DVTPlugin.getDefault().collect().c(project, pluginConfig.feature())) {
            return null;
        }
        if (namedElement == null) {
            return null;
        }
        if (namedElement instanceof RfFieldTypeConstraint) {
            namedElement = ((RfFieldTypeConstraint)namedElement).getFieldOrVariable();
        }
        if (namedElement instanceof RfPropConstraint) {
            namedElement = ((RfPropConstraint)namedElement).getField();
        }
        if (namedElement instanceof RfFieldAlias) {
            namedElement = ((RfFieldAlias)namedElement).getField();
        }
        if (namedElement == null) {
            return null;
        }
        if (namedElement.hasNoLayers() && !(namedElement instanceof RfModule) && !(namedElement instanceof RfAssert) && !(namedElement instanceof RfCheckThat)) {
            return null;
        }
        RfDefElement methodOrEventLayer = null;
        if ((namedElement instanceof RfMethod || namedElement instanceof RfEvent) && firstImplementation) {
            Iterator<RfDefElement> iterator = namedElement.getLayers().iterator();
            while (iterator.hasNext()) {
                RfDefElement layer;
                methodOrEventLayer = layer = iterator.next();
                if (layer.getLayerKind() != 372 && layer.getLayerKind() != 371) break;
            }
        }
        RfModule rfModule = null;
        if (namedElement instanceof RfModule) {
            rfModule = (RfModule)namedElement;
        } else if (namedElement instanceof RfAssert || namedElement instanceof RfCheckThat) {
            rfModule = namedElement.getModule();
        } else if (methodOrEventLayer != null) {
            rfModule = methodOrEventLayer.getLayerModule();
        } else if (namedElement.getFirstLayer() != null) {
            rfModule = namedElement.getFirstLayer().getLayerModule();
        }
        if (rfModule == null) {
            return null;
        }
        IRfSingleLangProject rfProject = rfModule.getRfProject();
        if (rfProject == null) {
            return null;
        }
        ParserPath parserPath = rfModule.getParserPath();
        int line = methodOrEventLayer == null ? namedElement.getLine() : methodOrEventLayer.getStartLine();
        String elementName = namedElement.getName();
        Action action = new Action((RfProject)rfProject, project, parserPath, line, elementName){
            private final /* synthetic */ RfProject val$rfProject;
            private final /* synthetic */ IProject val$project;
            private final /* synthetic */ ParserPath val$parserPath;
            private final /* synthetic */ int val$line;
            private final /* synthetic */ String val$elementName;
            {
                this.val$rfProject = rfProject;
                this.val$project = iProject;
                this.val$parserPath = parserPath;
                this.val$line = n;
                this.val$elementName = string;
            }

            public void run() {
                EDTFileUtils.getInstance().openFile(this.val$rfProject.getModelManager(), this.val$project, this.val$parserPath.path, this.val$line, this.val$elementName);
            }

            public String getPath() {
                return this.val$parserPath.path;
            }

            public int getLine() {
                return this.val$line;
            }

            public String getElementName() {
                return this.val$elementName;
            }
        };
        return new RfNamedElementActionHyperlink(project, namedElement, hasBindLabel, hasDeterminantLabel, region, (IAction)action, parserPath.path, line, hyperlinkText);
    }

    public static RfNamedElementActionHyperlink createOpenAction(IEPluginConfig pluginConfig, RfDefElement defElement, IProject project, IRegion region, boolean hasSubtypeLabel) {
        return RfUtilsCommon.createOpenAction(pluginConfig, defElement, project, region, hasSubtypeLabel, null);
    }

    public static RfNamedElementActionHyperlink createOpenAction(IEPluginConfig pluginConfig, RfDefElement defElement, IProject project, IRegion region, boolean hasSubtypeLabel, String hyperlinkText) {
        if (!DVTPlugin.getDefault().collect().c(project, pluginConfig.feature())) {
            return null;
        }
        if (defElement == null || defElement.getNamedElement() == null) {
            return null;
        }
        RfModule rfModule = defElement.getLayerModule();
        if (rfModule == null || rfModule instanceof RfPredefinedModule) {
            return null;
        }
        IRfSingleLangProject rfProject = rfModule.getRfProject();
        if (rfProject == null) {
            return null;
        }
        ParserPath parserPath = rfModule.getParserPath();
        int line = defElement.getStartLine();
        Action action = new Action((RfProject)rfProject, project, parserPath, line, defElement){
            private final /* synthetic */ RfProject val$rfProject;
            private final /* synthetic */ IProject val$project;
            private final /* synthetic */ ParserPath val$parserPath;
            private final /* synthetic */ int val$line;
            private final /* synthetic */ RfDefElement val$defElement;
            {
                this.val$rfProject = rfProject;
                this.val$project = iProject;
                this.val$parserPath = parserPath;
                this.val$line = n;
                this.val$defElement = rfDefElement;
            }

            public void run() {
                EDTFileUtils.getInstance().openFile(this.val$rfProject.getModelManager(), this.val$project, this.val$parserPath.path, this.val$line, this.val$defElement.getName());
            }

            public String getPath() {
                return this.val$parserPath.path;
            }

            public int getLine() {
                return this.val$line;
            }

            public String getElementName() {
                return this.val$defElement.getName();
            }
        };
        return new RfNamedElementActionHyperlink(project, defElement, hasSubtypeLabel, region, (IAction)action, parserPath.path, line, hyperlinkText);
    }

    public static RfNamedElementActionHyperlink createOpenAction(IEPluginConfig pluginConfig, RfNamedElement namedElement, IProject project, IRegion region, ImportFilePath importedFile, boolean hasBindLabel, boolean hasDeterminantLabel) {
        if (!DVTPlugin.getDefault().collect().c(project, pluginConfig.feature())) {
            return null;
        }
        if (namedElement == null) {
            return null;
        }
        RfModule rfModule = null;
        if (namedElement instanceof RfModule) {
            rfModule = (RfModule)namedElement;
        }
        if (rfModule == null) {
            return null;
        }
        IRfSingleLangProject rfProject = rfModule.getRfProject();
        if (rfProject == null) {
            return null;
        }
        ParserPath parserPath = rfModule.getParserPath();
        int line = importedFile != null ? importedFile.getLineNumber() : namedElement.getLine();
        String elementName = namedElement.getName();
        Action action = new Action((RfProject)rfProject, project, parserPath, line, elementName){
            private final /* synthetic */ RfProject val$rfProject;
            private final /* synthetic */ IProject val$project;
            private final /* synthetic */ ParserPath val$parserPath;
            private final /* synthetic */ int val$line;
            private final /* synthetic */ String val$elementName;
            {
                this.val$rfProject = rfProject;
                this.val$project = iProject;
                this.val$parserPath = parserPath;
                this.val$line = n;
                this.val$elementName = string;
            }

            public void run() {
                EDTFileUtils.getInstance().openFile(this.val$rfProject.getModelManager(), this.val$project, this.val$parserPath.path, this.val$line, this.val$elementName);
            }
        };
        return new RfNamedElementActionHyperlink(project, namedElement, hasBindLabel, hasDeterminantLabel, region, (IAction)action, parserPath.path, line);
    }

    /*
     * Unable to fully structure code
     */
    public static RfStruct getEnclosingStruct(IRfScope scope) {
        if (scope == null) {
            return null;
        }
        if (scope instanceof RfStruct) {
            return (RfStruct)scope;
        }
        if (scope instanceof RfCoverLayer) {
            return ((RfCoverLayer)scope).getStructLayer().getStruct();
        }
        if (!(scope instanceof RfConstraintLayer)) ** GOTO lbl10
        return ((RfConstraintLayer)scope).getStructLayer().getStruct();
lbl-1000:
        // 1 sources

        {
            scope = ((RfActionBlockLayer)scope).getEnclosingScope();
lbl10:
            // 2 sources

            ** while (scope instanceof RfActionBlockLayer)
        }
lbl11:
        // 1 sources

        if (scope instanceof RfStructLayer) {
            return ((RfStructLayer)scope).getStruct();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static IRfScope getEnclosingMethod(IRfScope scope) {
        if (scope == null) {
            return null;
        }
        if (scope instanceof RfMethod) {
            return scope;
        }
        if (!(scope instanceof RfMethodLayer)) ** GOTO lbl9
        return ((RfMethodLayer)scope).getMethod();
lbl-1000:
        // 1 sources

        {
            if (!((scope = ((RfActionBlockLayer)scope).getEnclosingScope()) instanceof RfMethodLayer)) continue;
            return ((RfMethodLayer)scope).getMethod();
lbl9:
            // 2 sources

            ** while (scope instanceof RfActionBlockLayer)
        }
lbl10:
        // 1 sources

        return null;
    }

    public static int getLengthNoComments(IDocument document, int offset, int length) {
        int result = 0;
        try {
            if (offset < 0) {
                return result;
            }
            ITypedRegion region = RfUtilsCommon.getTypedRegion(document, offset);
            if (region == null || !region.getType().equals("__dftl_partition_content_type")) {
                return result;
            }
            DVTCharacterScanner scanner = new DVTCharacterScanner(20, document, offset, true);
            int c = 0;
            int i = 0;
            while (i < length && c != -1 && scanner.getOffset() < document.getLength()) {
                c = (char)scanner.read();
                region = RfUtilsCommon.getTypedRegion(document, scanner.getOffset() - 1);
                if (region != null && (region.getType().equals("__e_ml_comment") || region.getType().equals("__e_sv_ml_comment") || region.getType().equals("__e_sl_comment") && c != 13 && c != 10)) continue;
                ++i;
            }
            result = scanner.getOffset() - offset;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    public static ITypedRegion getTypedRegion(IDocument document, int offset) {
        try {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            return extension3.getPartition("__e_partitioning", offset, false);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public static RfWNamedElementAndScope getRfElement(RfProject rfProject, ITextEditor textEditor, IDocument document, int offset, boolean allowWrappers) {
        block5: {
            block4: {
                try {
                    if (textEditor != null) break block4;
                    return null;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            if (document != null) break block5;
            return null;
        }
        IFile file = RfUtils.getFile(textEditor);
        return RfUtilsCommon.getRfElement(rfProject, file, document, offset, allowWrappers);
    }

    public static RfWNamedElementAndScope getRfElement(RfProject rfProject, IFile file, IDocument document, int offset, boolean allowWrappers) {
        RfWNamedElementAndScope elementAndScope = RfUtilsCommon.internalGetRfElement(rfProject, file, document, offset, false, false, true);
        if (elementAndScope == null) {
            return null;
        }
        RfNamedElement result = elementAndScope.getNamedElement();
        if ((result == null || result instanceof RfMacro) && (result = RfUtilsCommon.getRfElementUnderMacro(rfProject, file, document, offset, null)) != null) {
            return new RfWNamedElementAndScope(result, null);
        }
        return elementAndScope;
    }

    protected static RfWNamedElementAndScope internalGetRfElementUsingR2L(RfProject rfProject, IFile file, IDocument document, int offset, boolean allowWrappers) {
        IRegion region;
        ParserPath parserPath;
        String packageName;
        IRfScope rfScope;
        int line;
        block13: {
            RfModule rfModule;
            block12: {
                block11: {
                    block10: {
                        if (file != null && document != null) break block10;
                        return null;
                    }
                    if (rfProject != null) break block11;
                    return null;
                }
                line = document.getLineOfOffset(offset) + 1;
                rfModule = rfProject.getModule((IResource)file);
                if (rfModule != null) break block12;
                return null;
            }
            rfScope = rfModule.getScope(line, offset);
            packageName = rfModule.getPackageName();
            parserPath = rfModule.getParserPath();
            region = EWordFinder.getDefault().getWordAtOffset(document, offset);
            if (region != null && region.getLength() != 0) break block13;
            return null;
        }
        try {
            fRfElementCache.setDocument(document);
            RfWNamedElementAndScope cachedElement = fRfElementCache.getCacheElement(region, allowWrappers);
            if (cachedElement != null && cachedElement.getNamedElement() != null) {
                return cachedElement;
            }
            R2LTooltipManager manager = new R2LTooltipManager(rfProject, rfScope, packageName, parserPath, document, offset, line);
            manager.setAllowWrappers(allowWrappers);
            RfWNamedElementAndScope element = manager.getElement();
            if (element != null) {
                RfNamedElement namedElement;
                RfNamedElement origNamedElement = namedElement = element.getNamedElement();
                IRfScope scope = element.getScope();
                if (namedElement instanceof RfStructMember) {
                    RfStruct struct;
                    RfStruct parent = struct = ((RfStructMember)namedElement).getParentStruct();
                    String name = namedElement.getName();
                    while ((parent = parent.getParentStruct()) != null) {
                        if (parent.isPredefined()) break;
                        IRfNamedElement localNamedElement = parent.getLocalMember(Collections.singleton(namedElement.getClass()), name, null);
                        if (localNamedElement == null) continue;
                        namedElement = (RfNamedElement)localNamedElement;
                        struct = parent;
                    }
                }
                Determinant scopeDeterminant = element.getScopeDeterminant();
                element = new RfWNamedElementAndScope(namedElement, scope, element.isAllowMultipleHyperlinks());
                element.setScopeDeterminant(scopeDeterminant);
                element.setOriginalElement(origNamedElement);
            }
            fRfElementCache.putCacheElement(region, element, allowWrappers);
            return element;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public static void clearCaches() {
        fRfElementCache = new RfElementCache();
    }

    private static boolean isTextMatch(AST ast, String text) {
        RfMacro macro;
        if (ast.getType() == 293 && text.equals(ast.getText())) {
            return true;
        }
        return ast.getType() == 183 && ast.getText().contains(text) && (macro = SemanticUtils.getTransientResult(RfMacro.class, ast)) != null && macro.getStringLiteral().contains(text);
    }

    public static void getMacroSignature(RfMacro element, IEPluginConfig pluginConfig, ITextEditor textEditor, DVTTooltipContent tooltipContent) {
        StringBuilder replacements = new StringBuilder();
        if (element.isPreprocessing()) {
            LinkedHashSet<String> macroReplacements = element.getPreprocessingReplacements();
            for (String uniMacro : macroReplacements) {
                if (uniMacro == null) continue;
                replacements.append("<br>").append(uniMacro.replace("<", "&lt;").replace(">", "&gt;"));
            }
        } else if ("__etools__table'__etools__expansion".equals(element.getName())) {
            tooltipContent.set(DVTTooltipContent.TooltipContent.SIGNATURE, "<b>table preprocessing</b>");
            return;
        }
        String comment = "";
        String preference = "";
        if (element.getRfProject() == null || CommentUtils.getInstance().shouldUseOldTooltip()) {
            comment = element.getComment();
        } else {
            comment = element.getRawUntrimmedComment("\n\n");
            if (comment.isEmpty()) {
                comment = element.getComment();
            }
            DVTPair<String, String> tooltipPair = pluginConfig.getSpecadorFormatting(element, comment, element.getRfProject().getProject(), (IAdaptable)textEditor);
            comment = (String)tooltipPair.getKey();
            preference = (String)tooltipPair.getValue();
        }
        String commentDelim = comment.isEmpty() ? "" : "<br>";
        tooltipContent.set(DVTTooltipContent.TooltipContent.SIGNATURE, "<b>" + DVTStringUtil.partiallyEscapeHTML((String)element.getSignature()) + "</b>");
        tooltipContent.set(DVTTooltipContent.TooltipContent.COMMENT, String.valueOf(commentDelim) + comment + (element.isPreprocessing() ? (replacements.length() != 0 ? "<br>Defined Values:" + replacements : "") : ""));
        tooltipContent.set(DVTTooltipContent.TooltipContent.PREFERENCE, preference);
    }

    public static void getTooltipFormattedText(RfNamedElement element, IEPluginConfig pluginConfig, ITextEditor textEditor, DVTTooltipContent tooltipContent) {
        String signature;
        String string = signature = element == null ? null : element.getSignature();
        if (element != null && signature != null) {
            if (element instanceof RfMacro) {
                RfUtilsCommon.getMacroSignature((RfMacro)element, pluginConfig, textEditor, tooltipContent);
                return;
            }
            if (element.getRfProject() == null || CommentUtils.getInstance().shouldUseOldTooltip()) {
                String comment = element.getComment(false);
                String commentDelim = comment.isEmpty() ? "" : "<br>";
                tooltipContent.set(DVTTooltipContent.TooltipContent.SIGNATURE, "<b>" + DVTStringUtil.partiallyEscapeHTML((String)signature) + "</b>");
                tooltipContent.set(DVTTooltipContent.TooltipContent.COMMENT, String.valueOf(commentDelim) + DVTStringUtil.partiallyEscapeHTML((String)comment));
                return;
            }
            IFile editorFile = RfUtils.getFile(textEditor);
            if (editorFile == null) {
                return;
            }
            String tooltipComment = element.getRawUntrimmedComment("\n\n");
            if (tooltipComment.isEmpty()) {
                tooltipComment = element.getComment(false);
            }
            tooltipComment = WaveDromManager.getInstance().getCommentWithExtractedWaveformFile(tooltipComment);
            DVTPair<String, String> tooltipPair = pluginConfig.getSpecadorFormatting(element, tooltipComment, element.getRfProject().getProject(), (IAdaptable)textEditor);
            tooltipComment = (String)tooltipPair.getKey();
            tooltipContent.set(DVTTooltipContent.TooltipContent.SIGNATURE, RfUtils.wrapIntoBold(signature));
            tooltipContent.set(DVTTooltipContent.TooltipContent.COMMENT, tooltipComment);
            tooltipContent.set(DVTTooltipContent.TooltipContent.PREFERENCE, (String)tooltipPair.getValue());
        }
    }

    public static RfWNamedElementAndScope getRfElementForSearch(RfProject rfProject, IFile file, IDocument document, int offset, IRfNamedElement hint) {
        RfWNamedElementAndScope elementAndScope = RfUtilsCommon.internalGetRfElement(rfProject, file, document, offset, false, true, true);
        if (elementAndScope == null) {
            return null;
        }
        if (hint instanceof RfMacro) {
            return RfUtilsCommon.internalGetRfElementUsingR2L(rfProject, file, document, offset, false);
        }
        RfNamedElement result = elementAndScope.getNamedElement();
        if (result instanceof RfSearchQueryElement || result == null) {
            RfNamedElement potentialMacro = RfUtilsCommon.getRfElementUnderMacro(rfProject, file, document, offset, hint);
            if (potentialMacro instanceof RfMacro) {
                if (hint != null && !RfMacro.class.equals(hint.getClass())) {
                    return null;
                }
                RfWNamedElementAndScope macroElementAndScope = RfUtilsCommon.internalGetRfElementUsingR2L(rfProject, file, document, offset, false);
                if (macroElementAndScope != null && macroElementAndScope.getNamedElement() instanceof RfMacro) {
                    potentialMacro = macroElementAndScope.getNamedElement();
                }
                result = potentialMacro;
            } else if (potentialMacro != null) {
                return new RfWNamedElementAndScope(potentialMacro, elementAndScope.getScope());
            }
            return new RfWNamedElementAndScope(result, null);
        }
        return elementAndScope;
    }

    public static MacroRegion getMacro(RfProject rfProject, ITextEditor textEditor, IDocument document, int offset) {
        IEditorInput editorInput = textEditor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        return RfUtilsCommon.getMacro(rfProject, file, document, offset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MacroRegion getMacro(RfProject rfProject, IFile file, IDocument document, int offset) {
        try {
            Region defReg;
            RfMacroLayer macroLayer;
            String word;
            IRegion region;
            block13: {
                String macroName;
                String contentType = ((IDocumentExtension3)document).getContentType("__e_partitioning", offset, false);
                if (!contentType.equals("__dftl_partition_content_type")) {
                    return null;
                }
                region = EWordFinder.getDefault().getWordAtOffset(document, offset);
                word = document.get(region.getOffset(), region.getLength());
                if (word.trim().isEmpty()) {
                    return null;
                }
                RfModule module = rfProject.getModule((IResource)file);
                if (module == null) {
                    return null;
                }
                int line = document.getLineOfOffset(offset) + 1;
                List<RfMacroLayer> macrosLayers = module.getMacrosLayers(line);
                if (macrosLayers == null || macrosLayers.isEmpty()) {
                    List<RfNamedElement> macros = rfProject.getAllPreprocessing();
                    if (macros == null) {
                        return null;
                    }
                    for (RfNamedElement macro : macros) {
                        String string;
                        String macroName2 = macro.getName();
                        if (macroName2 == null || !macroName2.equals(word)) continue;
                        RfDefElement firstLayer = macro.getFirstLayer();
                        RfMacro rfMacro = (RfMacro)macro;
                        if (firstLayer != null) {
                            string = ((RfMacroLayer)firstLayer).getReplacement();
                            return new MacroRegion(rfMacro, region, string, null);
                        }
                        string = null;
                        return new MacroRegion(rfMacro, region, string, null);
                    }
                }
                if (macrosLayers == null) return null;
                if (macrosLayers.isEmpty()) {
                    return null;
                }
                Iterator<RfMacroLayer> iterator = macrosLayers.iterator();
                do {
                    if (!iterator.hasNext()) {
                        return null;
                    }
                    macroLayer = iterator.next();
                    macroName = macroLayer.getMacro().getName();
                    if (!macroLayer.getMacro().isPreprocessing()) break block13;
                } while (!macroName.equals(word));
                return new MacroRegion(macroLayer.getMacro(), region, macroLayer.getReplacement(), macroLayer);
            }
            int startOffset = Math.max(0, macroLayer.getStartOffset());
            int endOffset = Math.max(0, macroLayer.getEndOffset());
            Region region2 = defReg = new Region(startOffset, endOffset - startOffset);
            if (macroLayer.isDeclaration()) {
                return new MacroRegion(macroLayer.getMacro(), (IRegion)region2, macroLayer.getUserDefinedReplace(), macroLayer);
            }
            AST pAST = macroLayer.getAST();
            String prevWord = RfUtilsCommon.getPrevWord(document, region);
            LinkedHashSet<RfNamedElement> elements = new LinkedHashSet<RfNamedElement>();
            RfUtilsCommon.getMatchElements(elements, pAST, word, prevWord, new boolean[1]);
            if (elements.isEmpty()) return new MacroRegion(macroLayer.getMacro(), (IRegion)region2, macroLayer.getUserDefinedReplace(), macroLayer);
            return new MacroRegion(macroLayer.getMacro(), region2, macroLayer.getUserDefinedReplace(), macroLayer, elements);
        }
        catch (Exception x) {
            DVTLogger.INSTANCE.logError((Throwable)x);
        }
        return null;
    }

    protected static String getPrevWord(IDocument document, IRegion region) throws BadLocationException {
        IRegion prevWordRegion;
        int prevWordOffset = -1;
        int nested = 0;
        int i = region.getOffset() - 1;
        while (i > Math.max(0, region.getOffset() - 201)) {
            char ch = document.getChar(i);
            if (!Character.isWhitespace(ch)) {
                if (nested == 0 && ch == '.') {
                    prevWordOffset = i;
                } else if (ch == '[' || ch == '(' || ch == '{') {
                    ++nested;
                } else if (ch == ']' || ch == ')' || ch == '}') {
                    --nested;
                } else {
                    if (nested == 0 && prevWordOffset > i && Character.isJavaIdentifierPart(ch)) {
                        prevWordOffset = i;
                        break;
                    }
                    if (nested == 0) {
                        prevWordOffset = -1;
                        break;
                    }
                }
            }
            --i;
        }
        String prevWord = null;
        if (prevWordOffset > 0 && (prevWord = document.get((prevWordRegion = EWordFinder.getDefault().getWordAtOffset(document, prevWordOffset)).getOffset(), prevWordRegion.getLength())).trim().isEmpty()) {
            return null;
        }
        return prevWord;
    }

    private static void getMatchElements(final Set<RfNamedElement> result, AST rootAST, final String currWord, final String prevWord, final boolean[] enableCurr) {
        final HashSet lessRelevantResult = new HashSet();
        ASTUtils.scanBelowAST(new ASTUtils.ASTRunnable(){

            @Override
            public void run(AST node) throws Exception {
                if (prevWord == null || RfUtilsCommon.isTextMatch(node, prevWord)) {
                    enableCurr[0] = true;
                }
                if (RfUtilsCommon.isTextMatch(node, currWord)) {
                    RfNamedElement element = SemanticUtils.getTransientResult(RfNamedElement.class, node);
                    if (element != null) {
                        lessRelevantResult.add(element);
                    }
                    if (enableCurr[0] && element != null) {
                        result.add(element);
                    }
                    enableCurr[0] = false;
                }
            }
        }, rootAST, true);
        if (result.isEmpty() && !lessRelevantResult.isEmpty()) {
            result.addAll(lessRelevantResult);
        }
    }

    protected static RfNamedElement getRfElementUnderMacro(RfProject rfProject, IFile file, IDocument document, int offset, IRfNamedElement hint) {
        MacroRegion macroRegion = RfUtilsCommon.getMacro(rfProject, file, document, offset);
        if (macroRegion == null || macroRegion.getMacro() == null) {
            return null;
        }
        if ("__etools__table'__etools__expansion".equals(macroRegion.macro.getName())) {
            try {
                IRegion wordAtOffset = EWordFinder.getDefault().getWordAtOffset(document, offset);
                RfTableDefine tableDefine = rfProject.getTableDefine(document.get(wordAtOffset.getOffset(), wordAtOffset.getLength()));
                return tableDefine;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        if (macroRegion.getMacro().isPredefined()) {
            return null;
        }
        Set<RfNamedElement> guessedElementsUnderCursor = macroRegion.getGuessedElementsUnderCursor();
        if (guessedElementsUnderCursor == null || guessedElementsUnderCursor.isEmpty()) {
            return macroRegion.getMacro();
        }
        RfNamedElement firstElement = null;
        for (RfNamedElement namedElement : guessedElementsUnderCursor) {
            if (namedElement.checkEquals(hint)) {
                return namedElement;
            }
            if (namedElement.hasNoLayers()) continue;
            if (hint == null) {
                return namedElement;
            }
            if (firstElement != null) continue;
            firstElement = namedElement;
        }
        if (hint == null || hint instanceof RfMacro) {
            return macroRegion.getMacro();
        }
        return firstElement;
    }

    public static boolean isMethodPortField(RfField field) {
        return field != null && "any_method_port".equals(field.getAssociatedTypeName());
    }

    protected static RfWNamedElementAndScope internalGetRfElement(RfProject rfProject, ITextEditor textEditor, IDocument document, int offset, boolean allowWrappers, boolean disableR2LGuessing, boolean searchParents) {
        IFile file;
        block9: {
            IEditorInput editorInput;
            block8: {
                block7: {
                    block6: {
                        try {
                            if (textEditor != null) break block6;
                            return null;
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            return null;
                        }
                    }
                    if (document != null) break block7;
                    return null;
                }
                editorInput = textEditor.getEditorInput();
                if (editorInput != null) break block8;
                return null;
            }
            file = (IFile)editorInput.getAdapter(IFile.class);
            if (file != null) break block9;
            return null;
        }
        return RfUtilsCommon.internalGetRfElement(rfProject, file, document, offset, allowWrappers, disableR2LGuessing, searchParents);
    }

    protected static RfWNamedElementAndScope internalGetRfElement(RfProject rfProject, IFile file, IDocument document, int offset, boolean allowWrappers, boolean disableR2LGuessing, boolean searchParents) {
        RfModule rfModule;
        int line;
        boolean disableFallback;
        block31: {
            block30: {
                block29: {
                    disableFallback = false;
                    if (file != null && document != null) break block29;
                    return null;
                }
                if (rfProject != null) break block30;
                return null;
            }
            line = document.getLineOfOffset(offset) + 1;
            rfModule = rfProject.getModule((IResource)file);
            if (rfModule != null) break block31;
            return null;
        }
        try {
            RfTemplateStructInstance templateInstance;
            RfNamedElement namedElement;
            RfModule.IdentifierPosition candidate;
            IRegion region = EWordFinder.getDefault().getWordAtOffset(document, offset);
            if (region == null || region.getLength() == 0) {
                return new RfWNamedElementAndScope(null, rfModule.getScope(line, offset));
            }
            String text = document.get(region.getOffset(), region.getLength());
            if (text.endsWith("$")) {
                text = text.substring(0, text.length() - 1);
                --offset;
            }
            disableFallback = (candidate = rfModule.getIdentifier(text, offset)) == null;
            RfNamedElement rfNamedElement = namedElement = candidate == null ? null : candidate.getNamedElement();
            IRfScope scope = candidate == null ? null : (candidate.getDefElement() instanceof IRfScope ? (IRfScope)((Object)candidate.getDefElement()) : null);
            RfTemplateStructInstance rfTemplateStructInstance = templateInstance = candidate == null ? null : candidate.getTemplateInstanceScope();
            if (namedElement != null) {
                RfWNamedElementAndScope element;
                if (scope == null && namedElement instanceof RfStructMember) {
                    scope = ((RfStructMember)namedElement).getParentStruct();
                } else if (scope == null) {
                    scope = rfModule.getScope(line, offset);
                }
                if (scope instanceof RfTemplateStruct && templateInstance != null) {
                    scope = templateInstance;
                } else if (scope instanceof RfStruct) {
                    struct = (RfStruct)scope;
                    struct.setParamsValueOverride();
                } else if (scope instanceof RfFieldLayer) {
                    struct = ((RfFieldLayer)((Object)scope)).getField().getParentStruct();
                    struct.setParamsValueOverride();
                } else if (scope instanceof RfMethodLayer) {
                    struct = ((RfMethodLayer)scope).getMethod().getParentStruct();
                    struct.setParamsValueOverride();
                }
                if (namedElement instanceof RfUndefVariable) {
                    element = new RfWNamedElementAndScope(namedElement, scope, true);
                    return element;
                }
                if (namedElement instanceof RfPropConstraint) {
                    element = new RfWNamedElementAndScope(namedElement, scope, true);
                    return element;
                }
                if (namedElement instanceof RfSubtypeElement) {
                    element = new RfWNamedElementAndScope(namedElement, scope, true);
                    element.setOriginalElement(namedElement);
                    return element;
                }
                if (namedElement instanceof RfStructQualifier) {
                    element = new RfWNamedElementAndScope(namedElement, scope, true);
                    RfField field = ((RfStructQualifier)namedElement).getElement();
                    RfEnum enumItem = ((RfStructQualifier)namedElement).getEnum();
                    if (field != null && text.equals(field.getName())) {
                        element.setOriginalElement(field);
                    } else if (enumItem != null && text.equals(enumItem.getName())) {
                        element.setOriginalElement(enumItem);
                    }
                    return element;
                }
                if (namedElement instanceof RfDummyField) {
                    namedElement = "deep_copy_container".equals(namedElement.getName()) ? rfProject.getSpecman().getGlobalStruct().getLocalMember(new FullName("deep_copy", new Determinant(new String[]{"global"})), 1) : ("apply_container".equals(namedElement.getName()) ? rfProject.getSpecman().getGlobalStruct().getLocalMember(new FullName("apply", new Determinant(new String[]{"global"})), 1) : (RfNamedElement)((RfDummyField)namedElement).getAssociatedType());
                }
                RfNamedElement origNamedElement = namedElement;
                if (searchParents && namedElement instanceof RfStructMember) {
                    RfStruct struct;
                    RfStruct parent = struct = ((RfStructMember)namedElement).getParentStruct();
                    String name = namedElement.getName();
                    while ((parent = parent.getParentStruct()) != null) {
                        if (parent.isPredefined()) break;
                        IRfNamedElement localNamedElement = parent.getLocalMember(Collections.singleton(namedElement.getClass()), name, null);
                        if (localNamedElement == null) continue;
                        namedElement = (RfNamedElement)localNamedElement;
                        struct = parent;
                    }
                }
                RfWNamedElementAndScope element2 = new RfWNamedElementAndScope(namedElement, scope, true);
                element2.setOriginalElement(origNamedElement);
                return element2;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (disableR2LGuessing && disableFallback) {
            RfSearchQueryElement rfDummyElement = new RfSearchQueryElement(-1, "[no ID under cursor]");
            return new RfWNamedElementAndScope(rfDummyElement, null);
        }
        return RfUtilsCommon.internalGetRfElementUsingR2L(rfProject, file, document, offset, allowWrappers);
    }

    public static class MacroRegion {
        RfMacro macro;
        RfMacroLayer macroDef;
        IRegion region;
        String userDefineReplace;
        Set<RfNamedElement> guessedElementsUnderCursor;

        public MacroRegion(RfMacro macro, IRegion region, String userDefineReplace, RfMacroLayer macroDef) {
            this.macro = macro;
            this.macroDef = macroDef;
            this.region = region;
            this.userDefineReplace = userDefineReplace;
        }

        public MacroRegion(RfMacro macro2, Region region2, String userDefinedReplace, RfMacroLayer macroLayer, Set<RfNamedElement> namedElements) {
            this(macro2, (IRegion)region2, userDefinedReplace, macroLayer);
            this.guessedElementsUnderCursor = namedElements;
        }

        public IRegion getRegion() {
            return this.region;
        }

        public RfMacro getMacro() {
            return this.macro;
        }

        public RfMacroLayer getMacroLayer() {
            return this.macroDef;
        }

        public String getUserDefineReplace() {
            return this.userDefineReplace;
        }

        public Set<RfNamedElement> getGuessedElementsUnderCursor() {
            return this.guessedElementsUnderCursor;
        }
    }

    protected static class RfElementCache {
        private IDocument fDocument;
        private RfWNamedElementAndScope fCachedElement;
        private IRegion fCachedRegion;
        private long fTimestamp;
        private boolean fAllowWrappers;

        protected RfElementCache() {
        }

        public void setDocument(IDocument document) {
            if (document == this.fDocument) {
                return;
            }
            this.fDocument = document;
            this.fCachedRegion = null;
            this.fCachedElement = null;
            this.fTimestamp = 0L;
        }

        public RfWNamedElementAndScope getCacheElement(IRegion region, boolean allowWrappers) {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    try {
                                        if (region != null && this.fCachedRegion != null) break block8;
                                        return null;
                                    }
                                    catch (Exception exception) {
                                        return null;
                                    }
                                }
                                if (this.fCachedElement != null) break block9;
                                return null;
                            }
                            if (this.fAllowWrappers == allowWrappers) break block10;
                            return null;
                        }
                        if (region.getLength() != 0) break block11;
                        return null;
                    }
                    if (region.equals(this.fCachedRegion)) break block12;
                    return null;
                }
                long oldTimestamp = this.fTimestamp;
                this.fTimestamp = System.currentTimeMillis();
                if (this.fTimestamp - oldTimestamp <= 200L) break block13;
                return null;
            }
            return new RfWNamedElementAndScope(this.fCachedElement);
        }

        public void putCacheElement(IRegion region, RfWNamedElementAndScope element, boolean allowWrappers) {
            this.fCachedElement = new RfWNamedElementAndScope(element);
            this.fCachedRegion = region;
            this.fTimestamp = System.currentTimeMillis();
            this.fAllowWrappers = allowWrappers;
        }
    }
}

