/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.model.reflection.views;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.views.CallHierarchyStateWrapper;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.IDVTEditor;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTGUIFiltersTopFilePatternExpander;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTPredefinedGUIFilters;
import ro.amiq.dvt.ui.guifilters.GUIFilter;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTJob;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.callhierarchy.CallHierarchyViewInput;
import ro.amiq.dvt.ui.views.callhierarchy.CallHierarchyViewInputConfigurator;
import ro.amiq.dvt.ui.views.callhierarchy.ICallHierarchyViewContributor;
import ro.amiq.dvt.ui.views.typehierarchy.GotoDataContainer;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.EModuleInfo;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.IRfAssociatedType;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfCheckThat;
import ro.amiq.edt.base.model.reflection.RfCoverItem;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfDummyElement;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfTemplateStruct;
import ro.amiq.edt.base.model.reflection.RfTemplateStructInstance;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedStruct;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.edt.base.model.reflection.views.AbstractCallHierarchyTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.ECallHierarchyLabelProvider;
import ro.amiq.edt.base.model.reflection.views.ECallHierarchyWalker;
import ro.amiq.edt.base.model.reflection.views.ECallHierarchyWalkerNode;
import ro.amiq.edt.base.model.reflection.views.ECallHierarchyWalkerNodeType;
import ro.amiq.edt.base.model.reflection.views.ELanguageElement;
import ro.amiq.edt.base.model.reflection.views.EQuickViewersUtil;
import ro.amiq.edt.base.ui.editor.AbstractEEditor;
import ro.amiq.edt.base.utils.EASTUtils;
import ro.amiq.edt.base.utils.EDTFileUtils;

public abstract class AbstractECallHierarchyViewContributor
implements ICallHierarchyViewContributor {
    private ECallHierarchyLabelProvider fLabelProvider = new ECallHierarchyLabelProvider(this.getPluginConfig());
    private boolean fHasGUIFilteredMembers;
    private List<GUIFilter> fExpandedXVMFilters;
    private boolean fIsPrependPackage;
    private boolean fShowConditionals = true;
    private boolean fShowForks = true;
    private boolean fShowOverrides = true;
    private boolean fShowNamedBeginEnds = true;
    private List<ECallHierarchyWalkerNode> fCallHierarchyElements = null;
    private CallHierarchyStateWrapper fStateWrapper = null;
    private String bulkDataInfo;

    public abstract IEPluginConfig getPluginConfig();

    public String getComment(Object wrapper) {
        RfNamedElement namedElement = this.getNamedElement(wrapper);
        return namedElement == null ? "" : DVTStringUtil.replaceAll((Pattern)DVTStringUtil.NEW_LINE, (CharSequence)namedElement.getComment(), (String)" ");
    }

    private RfNamedElement getNamedElement(Object wrapper) {
        if (!(wrapper instanceof AbstractRfTreeElementWrapper)) {
            return null;
        }
        if (!(((AbstractRfTreeElementWrapper)((Object)wrapper)).getRfElement() instanceof RfNamedElement)) {
            return null;
        }
        return (RfNamedElement)((AbstractRfTreeElementWrapper)((Object)wrapper)).getRfElement();
    }

    public void gotoElement(final IProject project, Object dataContainer) {
        try {
            IDVTElementWrapper wrapper = null;
            if (dataContainer instanceof GotoDataContainer) {
                wrapper = ((GotoDataContainer)dataContainer).getWrapper();
            } else if (dataContainer instanceof AbstractRfTreeElementWrapper) {
                wrapper = (AbstractRfTreeElementWrapper)((Object)dataContainer);
            }
            if (wrapper == null || !(wrapper.getRfElement() instanceof ECallHierarchyWalkerNode)) {
                return;
            }
            final ECallHierarchyWalkerNode node = (ECallHierarchyWalkerNode)wrapper.getRfElement();
            if (node == null) {
                return;
            }
            Action action = new Action(){

                public void run() {
                    if (node.getParserPath() == null) {
                        return;
                    }
                    EDTFileUtils.getInstance().openFile(AbstractECallHierarchyViewContributor.this.getPluginConfig().getModelManager(), project, node.getParserPath().path, node.getElementStartLine(), node.getLabel());
                }
            };
            action.run();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.fLabelProvider;
    }

    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        if (!(element instanceof AbstractRfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (rfElement == null) {
            return false;
        }
        if (rfElement instanceof ELanguageElement) {
            return false;
        }
        return matcher == null || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getText(element));
    }

    public CallHierarchyViewInput getInput(CallHierarchyViewInputConfigurator inputConfigurator) {
        this.fHasGUIFilteredMembers = false;
        this.fIsPrependPackage = inputConfigurator.isPrependPackage();
        AbstractRfTreeElementWrapper root = null;
        ArrayList<AbstractRfTreeElementWrapper> elements = new ArrayList<AbstractRfTreeElementWrapper>();
        CallHierarchyViewInput emptyResult = new CallHierarchyViewInput(this.fHasGUIFilteredMembers, Collections.emptyList(), this.bulkDataInfo);
        try {
            this.fHasGUIFilteredMembers = false;
            if (!inputConfigurator.getHistoryItem().getLanguage().equals((Object)this.getPluginConfig().getLanguageKind())) {
                return emptyResult;
            }
            IProject project = inputConfigurator.getSource();
            if (project == null || !project.isAccessible() || !project.hasNature(this.getPluginConfig().getNature())) {
                return emptyResult;
            }
            if (!DVTPlugin.getDefault().collect().c(project, this.getPluginConfig().feature())) {
                return emptyResult;
            }
            if (inputConfigurator.getJob() == null) {
                return emptyResult;
            }
            RfProject rfProject = this.getPluginConfig().getRfManager().getRfProject(project);
            if (rfProject == null) {
                return emptyResult;
            }
            this.updateExpandedXVMFilters(project);
            UpdateViewEvent ev = (UpdateViewEvent)inputConfigurator.getHistoryItem();
            root = this.toWrappers(rfProject, ev, inputConfigurator.getJob());
            if (root == null) {
                return emptyResult;
            }
            this.bulkDataInfo = this.fLabelProvider.getTextUtil((Object)root, 0);
            this.filterNonTerminalLeafsAndApplyContentFilters(root);
            elements.add(root);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (!this.bulkDataInfo.contains("::") && !elements.isEmpty() && ((IDVTElementWrapper)elements.get(0)).getRfElement() instanceof RfNamedElement && ((RfNamedElement)((IDVTElementWrapper)elements.get(0)).getRfElement()).getModule() != null && ((RfNamedElement)((IDVTElementWrapper)elements.get(0)).getRfElement()).getModule().getPackageName() != null) {
            this.bulkDataInfo = ((RfNamedElement)((IDVTElementWrapper)elements.get(0)).getRfElement()).getModule().getPackageName().concat("::").concat(this.bulkDataInfo);
        }
        return new CallHierarchyViewInput(this.fHasGUIFilteredMembers, elements, this.bulkDataInfo);
    }

    public AbstractRfTreeElementWrapper toWrappers(RfProject rfProject, UpdateViewEvent ev, IDVTJob job) {
        String moduleName;
        if (rfProject == null || ev == null) {
            return null;
        }
        String packageName = ev.getEdtPackageName();
        FullName rootMethodCallFullName = (FullName)ev.getEdtElementFullName();
        Determinant determinant = (Determinant)ev.getEdtDeterminant();
        this.bulkDataInfo = "";
        this.bulkDataInfo = determinant != null ? String.valueOf(this.bulkDataInfo) + determinant.toString() : String.valueOf(this.bulkDataInfo) + rootMethodCallFullName.getName();
        ParserPath moduleParserPath = ev.getEdtModuleParserPath();
        if (moduleParserPath != null && !(moduleName = Path.fromOSString((String)moduleParserPath.path).removeFileExtension().lastSegment()).isEmpty()) {
            this.bulkDataInfo = String.valueOf(this.bulkDataInfo) + " [in " + moduleName + "] ";
        }
        int maxModuleIndex = ev.getEdtMaxModuleIndex();
        Object elementScope = ev.getElementScope();
        RfMethod method = this.getMethod(rfProject, rootMethodCallFullName, (FullName)ev.getEdtStructFullName(), packageName);
        ECallHierarchyWalkerNode rootCallHierarchyNode = null;
        if (method == null) {
            Object element = ev.getElement();
            if (element == null || !(element instanceof RfMethod)) {
                return null;
            }
            method = (RfMethod)element;
        }
        String computedNodeLabel = AbstractECallHierarchyViewContributor.computeNodeLabel(determinant, ((FullName)ev.getEdtStructFullName()).getName(), method.getName(), method.getAssociatedFullTypeName());
        rootCallHierarchyNode = new ECallHierarchyWalkerNode(method, computedNodeLabel, moduleParserPath, determinant, ECallHierarchyWalkerNodeType.METHOD);
        if (moduleParserPath == null) {
            return this.makeWrapper(rootCallHierarchyNode, null, AbstractCallHierarchyTreeElementWrapper.WrapperKind.NORMAL, rfProject.getProject());
        }
        AbstractCallHierarchyTreeElementWrapper rootMethodCallWrapper = this.makeWrapper(rootCallHierarchyNode, moduleParserPath.toString(), AbstractCallHierarchyTreeElementWrapper.WrapperKind.NORMAL, rfProject.getProject());
        ArrayList<RfMethodLayer> triggerLayers = new ArrayList<RfMethodLayer>();
        RfMethodLayer methodLayer = null;
        if (elementScope instanceof RfMethodLayer) {
            elementScope = method.getLayer(determinant, ev.getEdtModuleParserPath(), ev.getOffset());
            methodLayer = (RfMethodLayer)elementScope;
            if (!PrefConst.getCallHierarchyViewAllSimilarLayers()) {
                triggerLayers.add((RfMethodLayer)elementScope);
            } else {
                List<RfMethodLayer> sortedLayers = AbstractECallHierarchyViewContributor.getTCMCallLayers(method, determinant, maxModuleIndex, moduleParserPath);
                if (sortedLayers != null) {
                    triggerLayers.addAll(sortedLayers);
                }
            }
        } else {
            List<RfMethodLayer> sortedLayers = AbstractECallHierarchyViewContributor.getTCMCallLayers(method, determinant, maxModuleIndex, moduleParserPath);
            if (sortedLayers != null) {
                triggerLayers.addAll(sortedLayers);
            }
            RfMethodLayer rfMethodLayer = (methodLayer = method.getFirstLayerOfDeterminant(determinant)) != null ? methodLayer : (methodLayer = sortedLayers != null && !sortedLayers.isEmpty() ? sortedLayers.get(0) : null);
        }
        if (methodLayer != null) {
            rootCallHierarchyNode.setEnclosingLayer(methodLayer);
            rootCallHierarchyNode.setElementLine(methodLayer.getStartLine());
            rootCallHierarchyNode.setElementOffset(methodLayer.getStartOffset());
            rootCallHierarchyNode.setParserPath(methodLayer.getParserPath());
            rootCallHierarchyNode.setMaxModuleIndex(methodLayer.getMaxModuleIndex());
            rootCallHierarchyNode.setComment(methodLayer.getLayerComment());
            rootCallHierarchyNode.setFirstBodyLayer(methodLayer);
        }
        if (this.fStateWrapper != null) {
            this.expandLastState(rootMethodCallWrapper, this.fStateWrapper, job);
            return rootMethodCallWrapper;
        }
        this.makeCallTreeWithLayers(rootMethodCallWrapper, triggerLayers, new HashSet<String>(), 1);
        return rootMethodCallWrapper;
    }

    private void makeCallTree(AbstractRfTreeElementWrapper parentWrapper, Set<String> knownMethodNames, int depth) {
        if (parentWrapper == null || !(parentWrapper.getRfElement() instanceof ECallHierarchyWalkerNode) && depth > 0) {
            return;
        }
        ECallHierarchyWalkerNode parentNode = (ECallHierarchyWalkerNode)parentWrapper.getRfElement();
        RfNamedElement namedElement = parentNode.getElement();
        Determinant determinant = parentNode.getMethodDeterminant();
        int maxModuleIndex = parentNode.getMaxModuleIndex();
        ParserPath moduleParserPath = parentNode.getParserPath();
        List<RfMethodLayer> layers = AbstractECallHierarchyViewContributor.getTCMCallLayers(namedElement, determinant, maxModuleIndex, moduleParserPath);
        this.makeCallTreeWithLayers(parentWrapper, layers, knownMethodNames, depth);
    }

    private void makeCallTreeWithLayers(AbstractRfTreeElementWrapper parentWrapper, List<RfMethodLayer> layers, Set<String> knownMethodNames, int depth) {
        ECallHierarchyWalkerNode parentNode = (ECallHierarchyWalkerNode)parentWrapper.getRfElement();
        int maxModuleIndex = parentNode.getMaxModuleIndex();
        ParserPath moduleParserPath = parentNode.getParserPath();
        ArrayList<AbstractCallHierarchyTreeElementWrapper> children = new ArrayList<AbstractCallHierarchyTreeElementWrapper>();
        HashSet<String> initialKnownMethodNames = new HashSet<String>(knownMethodNames);
        knownMethodNames = new HashSet<String>(knownMethodNames);
        for (RfMethodLayer methodLayer : layers) {
            String tcmFullName = String.valueOf(methodLayer.getParserPath().path) + " " + methodLayer.getStartOffset();
            if (knownMethodNames.contains(tcmFullName)) {
                parentNode.setNodeType(ECallHierarchyWalkerNodeType.RECCURENCE);
                continue;
            }
            knownMethodNames.add(tcmFullName);
            List<ECallHierarchyWalkerNode> methodCalls = this.getMethodCallNodesFromLayer(methodLayer, knownMethodNames, maxModuleIndex, moduleParserPath);
            for (ECallHierarchyWalkerNode methodCall : methodCalls) {
                AbstractCallHierarchyTreeElementWrapper currWrapper = this.makeWrapper(methodCall, moduleParserPath.path, AbstractCallHierarchyTreeElementWrapper.WrapperKind.NORMAL, methodLayer.getRfProject().getProject());
                children.add(currWrapper);
                currWrapper.setParent(parentWrapper);
                this.makeCallTree(currWrapper, knownMethodNames, depth - 1);
            }
            knownMethodNames = new HashSet<String>(initialKnownMethodNames);
        }
        if (!children.isEmpty()) {
            parentWrapper.setChildren(children);
        }
    }

    private List<ECallHierarchyWalkerNode> getMethodCallNodesFromLayer(RfMethodLayer methodLayer, Set<String> knownMethods, int maxModuleIndex, ParserPath moduleParserPath) {
        List<ECallHierarchyWalkerNode> callHierarchyElements;
        ArrayList<ECallHierarchyWalkerNode> callNodes;
        block10: {
            if (methodLayer == null) {
                return Collections.emptyList();
            }
            callNodes = new ArrayList<ECallHierarchyWalkerNode>();
            IRfFileDef fileDef = methodLayer.getDefFile();
            if (!(fileDef instanceof RfModule)) {
                return Collections.emptyList();
            }
            RfModule module = (RfModule)fileDef;
            RfProject rfProject = methodLayer.getRfProject();
            if (rfProject == null) {
                return Collections.emptyList();
            }
            EModuleInfo moduleInfo = rfProject.getModuleInfo(module.getModuleReference());
            if (moduleInfo == null) {
                return Collections.emptyList();
            }
            AST moduleAST = moduleInfo.getModuleAST();
            if (moduleAST == null) {
                return Collections.emptyList();
            }
            AST layerAST = EASTUtils.getInstance().getLayerAST(moduleAST, methodLayer);
            if (layerAST == null) {
                return Collections.emptyList();
            }
            knownMethods = new HashSet<String>(knownMethods);
            ECallHierarchyWalker callHierarchyWalker = new ECallHierarchyWalker((RfProject)module.getRfProject(), module.getParserPath(), moduleInfo);
            callHierarchyWalker.setCommentsPreferences(BuildConfigManager.getCommentsPreferences((IProject)rfProject.getProject()));
            callHierarchyWalker.method_struct_member(layerAST);
            callHierarchyElements = callHierarchyWalker.getCallHierarchyElements();
            if (callHierarchyElements != null) break block10;
            return null;
        }
        try {
            for (ECallHierarchyWalkerNode methodCallElement : callHierarchyElements) {
                if (methodCallElement == null) continue;
                methodCallElement.setEnclosingLayer(methodLayer);
                callNodes.add(methodCallElement);
            }
            return callNodes;
        }
        catch (RecognitionException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public static String computeNodeLabel(Determinant determinant, String structName, String methodName, String returnType) {
        StringBuilder result = new StringBuilder();
        if (determinant == null) {
            result.append(structName).append(".").append(methodName).append("()").append(returnType == null ? "" : ":" + returnType);
            return result.toString();
        }
        String label = "";
        String[] determinantArray = determinant.toArray();
        int i = 0;
        while (i < determinantArray.length - 1) {
            label = String.valueOf(label.isEmpty() ? "" : String.valueOf(label) + " ") + determinantArray[i];
            ++i;
        }
        result.append(!label.isEmpty() ? String.valueOf(label) + " " : "").append(structName).append(".").append(methodName).append("()").append(returnType == null ? "" : ":" + returnType);
        return result.toString();
    }

    private RfMethod getMethod(RfProject rfProject, FullName methodName, FullName structName, String packageName) {
        RfStruct struct = this.getRfStruct(rfProject, packageName, structName);
        if (struct instanceof RfTemplateStruct && !(struct instanceof RfPredefinedStruct)) {
            RfStruct origStruct = struct;
            struct = new RfTemplateStructInstance(rfProject, (RfTemplateStruct)struct);
            Determinant determinant = structName.getDeterminant();
            List<IRfAssociatedType> parameters = determinant.getParameters();
            if (parameters != null) {
                ((RfTemplateStructInstance)struct).setParamsValueOverride(new ArrayList<IRfAssociatedType>(parameters));
            }
            origStruct.setParamsValueOverride();
        }
        if (struct == null) {
            return null;
        }
        return struct.getMethod(methodName);
    }

    private RfStruct getRfStruct(RfProject project, String packageName, FullName fStructName) {
        block3: {
            try {
                if (project != null && packageName != null && fStructName != null && fStructName.getName() != null) break block3;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        return (RfStruct)project.getType(packageName, false, 1, fStructName.getName(), -1);
    }

    public static List<RfMethodLayer> getSortedTcmLayers(RfStruct struct, Determinant determinant, int maxModuleIndex, ParserPath moduleParserPath, String bodyName) {
        if (struct == null) {
            return Collections.emptyList();
        }
        ArrayList<RfMethodLayer> result = new ArrayList<RfMethodLayer>();
        List<RfDefElement> structLayers = struct.getLayers();
        block0: for (RfDefElement layer : structLayers) {
            Collection layerDefElements;
            RfStructLayer structLayer;
            Determinant layerDeterminant;
            if (!(layer instanceof RfStructLayer) || (layerDeterminant = (structLayer = (RfStructLayer)layer).getDeterminant()) == null || determinant == null || !determinant.contains(layerDeterminant, true) || (layerDefElements = layer.getChildren()) == null) continue;
            for (RfDefElement child : layerDefElements) {
                RfMethodLayer methodLayer;
                int layerMaxModuleIndex;
                if (!(child instanceof RfMethodLayer) || (layerMaxModuleIndex = layer.getMaxModuleIndex()) > maxModuleIndex || !bodyName.equals((methodLayer = (RfMethodLayer)child).getName()) || !AbstractECallHierarchyViewContributor.importedBySameTest(methodLayer, moduleParserPath)) continue;
                AbstractECallHierarchyViewContributor.addLayerOrderedByIsStatements(result, methodLayer);
                continue block0;
            }
        }
        return result;
    }

    private static void addLayerOrderedByIsStatements(List<RfMethodLayer> layers, RfMethodLayer methodLayer) {
        switch (methodLayer.getLayerKind()) {
            case 377: 
            case 378: {
                layers.clear();
                layers.add(methodLayer);
                break;
            }
            case 376: {
                layers.add(methodLayer);
                break;
            }
            case 375: {
                layers.add(0, methodLayer);
                break;
            }
        }
    }

    private static boolean importedBySameTest(RfMethodLayer layer, ParserPath moduleParserPath) {
        if (layer == null) {
            return false;
        }
        RfProject rfProject = layer.getRfProject();
        if (rfProject == null) {
            return false;
        }
        ParserPath candidateParserPath = layer.getParserPath();
        if (moduleParserPath == null) {
            Set<ParserPath> testFiles = rfProject.getTestFilesForModule(candidateParserPath);
            return testFiles == null || testFiles.isEmpty();
        }
        return rfProject.importedBySameTest(candidateParserPath, moduleParserPath);
    }

    private void updateExpandedXVMFilters(IProject project) {
        this.fExpandedXVMFilters = DVTPredefinedGUIFilters.getXVMFilter();
        DVTGUIFiltersTopFilePatternExpander.expand(this.fExpandedXVMFilters, (IProject)project);
    }

    public HistoryItem createHistoryItemForElementAtCursor(IDVTEditor editor, int cursor) {
        String moduleName;
        IRfScope scopeLayer;
        RfNamedElement namedElement;
        RfWNamedElementAndScope elementAndScope;
        IDocument document;
        IProject project;
        IFile file;
        block36: {
            block35: {
                block34: {
                    block33: {
                        block32: {
                            RfProject rfProject;
                            block31: {
                                block30: {
                                    IDocumentProvider documentProvider;
                                    IEditorInput editorInput;
                                    block29: {
                                        AbstractEEditor eEditor;
                                        block28: {
                                            block27: {
                                                block26: {
                                                    block25: {
                                                        block24: {
                                                            try {
                                                                if (editor instanceof AbstractEEditor) break block24;
                                                                return null;
                                                            }
                                                            catch (Exception e) {
                                                                DVTLogger.INSTANCE.logError((Throwable)e);
                                                                return null;
                                                            }
                                                        }
                                                        eEditor = (AbstractEEditor)editor;
                                                        editorInput = eEditor.getEditorInput();
                                                        if (editorInput != null) break block25;
                                                        return null;
                                                    }
                                                    file = (IFile)editorInput.getAdapter(IFile.class);
                                                    if (file != null) break block26;
                                                    return null;
                                                }
                                                project = file.getProject();
                                                if (project != null) break block27;
                                                return null;
                                            }
                                            rfProject = this.getPluginConfig().getRfManager().getRfProject(project);
                                            if (rfProject != null) break block28;
                                            return null;
                                        }
                                        documentProvider = eEditor.getDocumentProvider();
                                        if (documentProvider != null) break block29;
                                        return null;
                                    }
                                    document = documentProvider.getDocument((Object)editorInput);
                                    if (document != null) break block30;
                                    return null;
                                }
                                elementAndScope = RfUtils.internalGetRfElementForCallHierarchy(rfProject, file, document, cursor);
                                if (elementAndScope != null) break block31;
                                return null;
                            }
                            if (elementAndScope.getNamedElement() != null && elementAndScope.getNamedElement().isPredefined()) {
                                elementAndScope = RfUtils.getRfElement(rfProject, file, document, cursor, true);
                            }
                            namedElement = elementAndScope.getNamedElement();
                            scopeLayer = elementAndScope.getScope();
                            IRfFileDef rfModule = rfProject.getFile((IResource)file);
                            if (rfModule instanceof RfModule) break block32;
                            return null;
                        }
                        if (namedElement != null) break block33;
                        return null;
                    }
                    if (!RfStruct.isPackageElement(namedElement, false)) break block34;
                    return null;
                }
                if (!(namedElement instanceof RfCheckThat)) break block35;
                return null;
            }
            if (!(namedElement instanceof RfCoverItem)) break block36;
            return null;
        }
        RfStruct scope = EQuickViewersUtil.getInstance().getEnclosingStruct(elementAndScope.getScope());
        UpdateViewEvent updateEvent = EQuickViewersUtil.getInstance().createViewUpdateEvent(this.getPluginConfig(), namedElement, project, scope, true, 6);
        this.fStateWrapper = null;
        updateEvent.setElementScope((Object)scopeLayer);
        Determinant determinant = null;
        ParserPath moduleParserPath = null;
        int maxModuleIndex = 0;
        if (scopeLayer instanceof RfMethodLayer) {
            determinant = scopeLayer.getDeterminant();
            moduleParserPath = ((RfDefElement)((Object)scopeLayer)).getParserPath();
            maxModuleIndex = ((RfDefElement)((Object)scopeLayer)).getMaxModuleIndex();
            updateEvent.setElementScope((Object)scopeLayer);
        } else if (namedElement instanceof RfStructMember) {
            determinant = ((RfStructMember)namedElement).getAssociatedTypeDeterminant();
            RfDefElement declaration = namedElement.getDeclaration();
            if (declaration != null) {
                moduleParserPath = declaration.getParserPath();
                maxModuleIndex = declaration.getMaxModuleIndex();
            }
            if (updateEvent.getEdtHasAssociatedType()) {
                updateEvent.setEdtAssociatedType((Object)((RfStructMember)namedElement).getAssociatedType());
            }
        }
        if (determinant == null) {
            determinant = elementAndScope.getScopeDeterminant();
        }
        updateEvent.setEdtPackageName(scope.getPackageName());
        updateEvent.setOffset(document.getLineOfOffset(cursor) + 1);
        updateEvent.setFileName(file.getName());
        updateEvent.setEdtModuleParserPath(moduleParserPath);
        updateEvent.setEdtMaxModuleIndex(maxModuleIndex);
        updateEvent.setEdtDeterminant((Object)determinant);
        String text = "";
        text = determinant != null ? String.valueOf(text) + determinant.toString() + "." : String.valueOf(text) + scope.getName() + ".";
        text = String.valueOf(text) + ((FullName)updateEvent.getEdtElementFullName()).getName();
        if (moduleParserPath != null && !(moduleName = Path.fromOSString((String)moduleParserPath.path).removeFileExtension().lastSegment()).isEmpty()) {
            text = String.valueOf(text) + " [in " + moduleName + "] ";
        }
        if (!text.isEmpty()) {
            updateEvent.setText(text);
        }
        return updateEvent;
    }

    public void updateFilterOptions() {
        this.fShowConditionals = !PrefConst.getCallHierarchyViewHideConditionals();
        this.fShowForks = !PrefConst.getCallHierarchyViewHideForks();
        this.fShowOverrides = !PrefConst.getCallHierarchyViewHideOverrides();
        this.fShowNamedBeginEnds = !PrefConst.getCallHierarchyViewHideNamedBlocks();
    }

    public void expandXLevels(IDVTElementWrapper rootWrapper, int levels, IDVTJob job) {
        if (ViewsUtils.isCanceled((IDVTJob)job)) {
            return;
        }
        if (levels <= 0) {
            return;
        }
        if (this.fStateWrapper == null) {
            this.expandFromWrapper(rootWrapper, job);
        } else {
            this.expandLastState(rootWrapper, this.fStateWrapper, job);
        }
        if (!rootWrapper.hasChildren()) {
            return;
        }
        for (IDVTElementWrapper child : rootWrapper.getChildren()) {
            if (child.getChildren() == null || child.getChildren().isEmpty()) continue;
            this.expandXLevels(child, levels - 1, job);
        }
    }

    private void expandLastState(IDVTElementWrapper wrapper, CallHierarchyStateWrapper stateWrapper, IDVTJob job) {
        if (ViewsUtils.isCanceled((IDVTJob)job) || wrapper == null) {
            return;
        }
        this.expandFromWrapper(wrapper, job);
        if (wrapper.getChildren() == null) {
            return;
        }
        for (IDVTElementWrapper child : wrapper.getChildren()) {
            CallHierarchyStateWrapper statePair;
            if (child == null || stateWrapper == null || (statePair = stateWrapper.findPair(child)) == null || !statePair.hasChildren()) continue;
            this.expandLastState(child, statePair, job);
        }
    }

    private void expandFromWrapper(IDVTElementWrapper wrapper, IDVTJob job) {
        if (!(wrapper instanceof AbstractCallHierarchyTreeElementWrapper)) {
            return;
        }
        wrapper.setExpanded(0);
        boolean childrenComputed = (Boolean)wrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.CHILDREN_COMPUTED);
        if (childrenComputed) {
            return;
        }
        if (!(wrapper.getRfElement() instanceof ECallHierarchyWalkerNode)) {
            return;
        }
        if (wrapper.getChildren() == null) {
            this.makeCallTree((AbstractRfTreeElementWrapper)wrapper, new HashSet<String>(), 2);
        }
        if (wrapper.getChildren() != null && !wrapper.getChildren().isEmpty()) {
            this.filterFromWrapper(wrapper);
        }
        wrapper.setAdditionalInfo((Object)IDVTElementWrapper.Attribute.CHILDREN_COMPUTED, (Object)true);
    }

    private static List<RfMethodLayer> getTCMCallLayers(RfNamedElement element, Determinant determinant, int maxModuleIndex, ParserPath moduleParserPath) {
        if (!(element instanceof RfMethod)) {
            return Collections.emptyList();
        }
        if (determinant == null) {
            determinant = ((RfMethod)element).getDeterminant();
        }
        ArrayList<RfMethodLayer> result = new ArrayList<RfMethodLayer>();
        List<RfDefElement> tcmLayers = element.getLayers();
        for (RfDefElement layer : tcmLayers) {
            Determinant layerDeterminant;
            if (!(layer instanceof RfMethodLayer) || (layerDeterminant = ((RfMethodLayer)layer).getDeterminant()) == null || determinant == null || !determinant.contains(layerDeterminant, true) || !AbstractECallHierarchyViewContributor.importedBySameTest((RfMethodLayer)layer, moduleParserPath)) continue;
            AbstractECallHierarchyViewContributor.addLayerOrderedByIsStatements(result, (RfMethodLayer)layer);
        }
        return result;
    }

    private void filterFromWrapper(IDVTElementWrapper wrapper) {
        this.filterNonTerminalLeafsAndApplyContentFilters(wrapper);
        if (wrapper.getChildren() == null) {
            return;
        }
    }

    private int getVirtualOffset(IDVTElementWrapper wrapper) {
        AbstractCallHierarchyTreeElementWrapper callWrapper = (AbstractCallHierarchyTreeElementWrapper)wrapper;
        ECallHierarchyWalkerNode callHierarchyWalkerNode = (ECallHierarchyWalkerNode)callWrapper.getRfElement();
        if (callWrapper.getWrapperKind() == AbstractCallHierarchyTreeElementWrapper.WrapperKind.MACRO) {
            return 0;
        }
        RfNamedElement namedElement = callHierarchyWalkerNode.getElement();
        if (namedElement == null) {
            return -1;
        }
        return namedElement.getOffset();
    }

    private int getOffset(IDVTElementWrapper wrapper) {
        AbstractCallHierarchyTreeElementWrapper callWrapper = (AbstractCallHierarchyTreeElementWrapper)wrapper;
        Object node = callWrapper.getRfElement();
        if (!(node instanceof ECallHierarchyWalkerNode)) {
            return -1;
        }
        ECallHierarchyWalkerNode callHierarchyWalkerNode = (ECallHierarchyWalkerNode)node;
        RfNamedElement namedElement = callHierarchyWalkerNode.getElement();
        if (namedElement == null) {
            return -1;
        }
        return namedElement.getOffset();
    }

    public int getLine(IDVTElementWrapper wrapper) {
        AbstractCallHierarchyTreeElementWrapper callWrapper = (AbstractCallHierarchyTreeElementWrapper)wrapper;
        if (!(callWrapper.getRfElement() instanceof ECallHierarchyWalkerNode)) {
            return -1;
        }
        ECallHierarchyWalkerNode element = (ECallHierarchyWalkerNode)callWrapper.getRfElement();
        if (callWrapper.getWrapperKind() == AbstractCallHierarchyTreeElementWrapper.WrapperKind.MACRO) {
            return callWrapper.getMacroLine();
        }
        if (element.getElement() instanceof RfMethod && ((RfMethod)element.getElement()).getDeclaration() != null) {
            return ((RfMethod)element.getElement()).getDeclaration().getStartLine();
        }
        if (element.getElement() instanceof RfDummyElement) {
            RfDummyElement rfDummyElement = (RfDummyElement)element.getElement();
            return rfDummyElement.getDeclaration() != null ? rfDummyElement.getDeclaration().getStartLine() : 0;
        }
        return element.getElementStartLine();
    }

    private AbstractCallHierarchyTreeElementWrapper makeWrapper(Object element, String path, AbstractCallHierarchyTreeElementWrapper.WrapperKind wrapperKind, IProject project) {
        AbstractCallHierarchyTreeElementWrapper result = this.getPluginConfig().createCallHierarchyElementTreeWrapper(element, path, wrapperKind, project);
        if (this.fIsPrependPackage) {
            result.setAdditionalInfo(IDVTElementWrapper.Attribute.PREPEND_TEXT, "package");
        }
        return result;
    }

    private void sortByActualOrder(IDVTElementWrapper wrapper) {
        if (!(wrapper instanceof AbstractRfTreeElementWrapper)) {
            return;
        }
        AbstractRfTreeElementWrapper rootWrapper = (AbstractRfTreeElementWrapper)wrapper;
        List<AbstractRfTreeElementWrapper> children = rootWrapper.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        this.breakMainProblem(children, 0, children.size() - 1);
        for (AbstractRfTreeElementWrapper child : children) {
            this.sortByActualOrder(child);
        }
    }

    private void breakMainProblem(List<AbstractRfTreeElementWrapper> children, int startOffset, int endOffset) {
        if (children == null || children.isEmpty()) {
            return;
        }
        if (endOffset <= startOffset) {
            return;
        }
        int startSubProblemOffset = 0;
        int endSubProblemOffset = 0;
        int i = startOffset;
        int j = 0;
        while (i < endOffset) {
            startSubProblemOffset = i;
            endSubProblemOffset = i;
            j = i + 1;
            while (j <= endOffset && this.isCallInParameters((AbstractCallHierarchyTreeElementWrapper)children.get(startSubProblemOffset), (AbstractCallHierarchyTreeElementWrapper)children.get(j))) {
                endSubProblemOffset = j++;
            }
            if (endSubProblemOffset > startSubProblemOffset) {
                this.solveSubProblem(children, startSubProblemOffset, endSubProblemOffset);
                i = endSubProblemOffset + 1;
                continue;
            }
            ++i;
        }
    }

    private void solveSubProblem(List<AbstractRfTreeElementWrapper> children, int startOffset, int endOffset) {
        AbstractRfTreeElementWrapper mainCall = children.get(startOffset);
        int i = startOffset + 1;
        while (i <= endOffset) {
            children.set(i - 1, children.get(i));
            ++i;
        }
        children.set(endOffset, mainCall);
        this.breakMainProblem(children, startOffset, endOffset - 1);
    }

    public boolean isCallInParameters(AbstractCallHierarchyTreeElementWrapper mainCall, AbstractCallHierarchyTreeElementWrapper check) {
        return false;
    }

    public boolean filterNonTerminalLeafsAndApplyContentFilters(IDVTElementWrapper node) {
        if (!node.hasChildren()) {
            return !this.keep(node);
        }
        Iterator iterator = node.getChildren().iterator();
        while (iterator.hasNext()) {
            IDVTElementWrapper child = (IDVTElementWrapper)iterator.next();
            if (!this.filterNonTerminalLeafsAndApplyContentFilters(child)) continue;
            iterator.remove();
        }
        return !this.keep(node);
    }

    private boolean keep(IDVTElementWrapper node) {
        IDVTElementWrapper parent = node.getParent();
        if (parent == null) {
            return true;
        }
        Object rfElement = null;
        if (parent instanceof AbstractCallHierarchyTreeElementWrapper) {
            Object wrapper = ((AbstractCallHierarchyTreeElementWrapper)parent).getRfElement();
            if (wrapper instanceof ECallHierarchyWalkerNode) {
                rfElement = ((ECallHierarchyWalkerNode)wrapper).getElement();
            }
        } else {
            rfElement = parent.getRfElement();
        }
        if (rfElement instanceof RfMethod || rfElement instanceof RfMethodLayer) {
            if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.CALL_HIERARCHY, (IRfNamedElement)((RfNamedElement)rfElement), () -> this.fLabelProvider.getTextUtil(node, 0)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                this.fHasGUIFilteredMembers = true;
                return false;
            }
            return true;
        }
        if (rfElement instanceof RfDummyElement) {
            return true;
        }
        return rfElement instanceof ECallHierarchyWalkerNode;
    }

    public IDVTElementWrapper copyWrapperWithUpdatingNode(IDVTElementWrapper wrapper) {
        AbstractCallHierarchyTreeElementWrapper callWrapper = (AbstractCallHierarchyTreeElementWrapper)wrapper;
        AbstractCallHierarchyTreeElementWrapper copy = this.getPluginConfig().createCallHierarchyElementTreeWrapper(callWrapper);
        copy.setRfElement(wrapper.getRfElement());
        AbstractCallHierarchyTreeElementWrapper child = this.makeWrapper(new RfDummyElement(null, "Updating..."), null, AbstractCallHierarchyTreeElementWrapper.WrapperKind.UPDATING, callWrapper.getProject());
        if (this.fIsPrependPackage) {
            child.setAdditionalInfo(IDVTElementWrapper.Attribute.PREPEND_TEXT, "package");
        }
        copy.addChild(child);
        copy.setExpanded(0);
        return copy;
    }

    public void goToWrapperDeclaration(IDVTElementWrapper wrapper, IProject project) {
        this.gotoElement(project, wrapper);
    }

    public void triggerRefresh(IDVTElementWrapper wrapper, boolean applyFilters) {
        if (applyFilters) {
            this.filterFromWrapper(wrapper);
        }
        this.fStateWrapper = this.createStateTree(wrapper);
    }

    public CallHierarchyStateWrapper createStateTree(IDVTElementWrapper wrapper) {
        if (wrapper == null || !(wrapper instanceof AbstractCallHierarchyTreeElementWrapper)) {
            return null;
        }
        return this.createStateTree(wrapper, new CallHierarchyStateWrapper(this.fLabelProvider.getText(wrapper), (DVTBaseLabelProvider)this.fLabelProvider));
    }

    private CallHierarchyStateWrapper createStateTree(IDVTElementWrapper wrapper, CallHierarchyStateWrapper stateWrapper) {
        if (wrapper.hasChildren()) {
            for (IDVTElementWrapper child : wrapper.getChildren()) {
                if (child == null) continue;
                CallHierarchyStateWrapper stateChild = new CallHierarchyStateWrapper(this.fLabelProvider.getText(child), (DVTBaseLabelProvider)this.fLabelProvider);
                stateWrapper.addChild(stateChild);
                if (child.getExpanded() == -2) continue;
                this.createStateTree(child, stateChild);
            }
        }
        return stateWrapper;
    }

    public void filterByName(IDVTElementWrapper wrapper, StringMatcher[] searchSegments, boolean[] searchStrictness, UpdateJob updateJob) {
        if (wrapper == null) {
            return;
        }
        ViewsUtils.hierarchicalSearch((IDVTElementWrapper)wrapper, (DVTBaseLabelProvider)this.fLabelProvider, (UpdateJob)updateJob, (StringMatcher[])searchSegments, (boolean[])searchStrictness, (boolean)true);
    }

    public boolean canGoToDeclarationOnWrapper(IDVTElementWrapper wrapper) {
        if (wrapper == null) {
            return false;
        }
        ECallHierarchyWalkerNode callHierarchyNode = (ECallHierarchyWalkerNode)wrapper.getRfElement();
        RfNamedElement namedElement = callHierarchyNode.getElement();
        if (!(namedElement instanceof RfMethod)) {
            return false;
        }
        boolean isPotential = ((AbstractCallHierarchyTreeElementWrapper)wrapper).getWrapperKind() == AbstractCallHierarchyTreeElementWrapper.WrapperKind.POTENTIAL;
        boolean isPredefined = ((RfMethod)namedElement).isPredefined();
        return !isPredefined && !isPotential;
    }

    public IDVTElementWrapper getRecurrenceWrapper(IDVTElementWrapper wrapper) {
        return ((AbstractCallHierarchyTreeElementWrapper)wrapper).getRecurenceWrapper();
    }

    public boolean enableAllLayers(HistoryItem historyItem) {
        if (!(historyItem instanceof UpdateViewEvent)) {
            return false;
        }
        return ((UpdateViewEvent)historyItem).getElementScope() instanceof RfMethodLayer;
    }

    public void setStateWrapper(CallHierarchyStateWrapper stateWrapper) {
        this.fStateWrapper = stateWrapper;
    }
}

